//SNTP
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "cfg_api.h"
#include "message.h"
#include <errno.h>
#include <sys/types.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#include <errno.h>
#include <syslog.h>
#include <pthread.h>
//#include "sntp_msg.h"
#include "softap_api.h"

/**************************************************************************
* 궨
**************************************************************************/
#define  SNTP_PORT       123
#define  SNTP_8HOUR        (3600U * 8U)
#define  SNTP_SECONDS_FROM_1900_TO_1970     (86400U*(365U*70U+17U))
#define  SNTP_JAN_2000   946684791
#define  SNTP_WAIT_TIME_HOUR     (60*60)
#define  SNTP_WAIT_TIME_DAY     (60*60*24)
#define  SNTP_WAIT_TIME_WEEK   (SNTP_WAIT_TIME_DAY*7) 
#define  SNTP_DEFAULT_NEXT_SYNC_INTERVAL_TIME_WHEN_SUCCESS   SNTP_WAIT_TIME_WEEK   /* 30DAY */
#define  SNTP_DEFAULT_NEXT_SYNC_INTERVAL_TIME_WHEN_FAILURE   (60*10)   /* s */
#define  SNTP_DEFAULT_SYNC_SELECT_INTERVAL_TIME              30/*s*/
#define  SNTP_SERVER_NUM   "sntp_server_count"//3
#define  SNTP_PROCESS_OVER_TIME   "sntp_process_over_time"
#define  SNTP_PROCESS_RESULT  "sntp_process_result"
#define  SNTP_PROCESS_STATE  "sntp_process_state"
//#define  SNTP_ERROR_STATE "sntp_error_state"
#define  SNTP_SUCCESS_COUNT "sntp_success_count"

//ڲͬĽ̼ͬ
#define TIME_SEM_KEY_1 0x0A2B
#define TIME_SEM_KEY_2 0x3A4B



/**************************************************************************
* ȫֱ
**************************************************************************/
pthread_mutex_t g_sntp_getaddrinfo_mutex;
pthread_mutex_t g_sntp_getnameinfo_mutex;



/**************************************************************************
*ݳȶ
**************************************************************************/
#define NV_ITEM_STRING_LEN_5  5
#define NV_ITEM_STRING_LEN_10  10
#define NV_ITEM_STRING_LEN_20  20
#define NV_ITEM_STRING_LEN_50  50
#define NV_ITEM_STRING_LEN_64  64
#define NV_ITEM_STRING_LEN_150  150
#define NV_ITEM_STRING_LEN_200  200
#define NV_FW_RULE_MAX_LEN_V6 400
#define NV_ITEM_VALUE_STRING_LEN 50



/**************************************************************************
* ݽṹ
**************************************************************************/

union semun {
	int val;
	struct semid_ds *buf;
	unsigned short *array;
};

typedef enum _sntp_result_type_t {
	SNTP_RESULT_FAIL = -1,
	SNTP_RESULT_OK,
	SNTP_RESULT_CONTINUE,
	SNTP_RESULT_INVALID_SERVER,
} sntp_result_type_t;

typedef enum _sntp_error_type_t {
	SNTP_ERROR_NOT_GET_HOST,
	SNTP_ERROR_CREATE_SOCKET,
	SNTP_ERROR_SEND_TO,
	SNTP_ERROR_SELECT_OVER_TIME,
	SNTP_ERROR_SELECT_RETURN_ERR,
	SNTP_ERROR_RECV_FROM,
	SNTP_ERROR_ALL_SERVER_INVALID,
} sntp_error_type_t;

typedef struct NTP_TIME_FMT {
	time_t seconds;
	time_t fractional;
} NTP_TIME_FMT;

typedef struct NTP_PKT_BASE {
	unsigned char liVnMode; /* LeapSecond(2bits:0), VersionNumber(3bits: 3), Mode(3bits: Client=3, Server=4) */
	unsigned char stratum; /* ʱ㼶 0-15 */
	unsigned char poll; /* ʾϢ8 bits2xʽʾʵ0 */
	unsigned char precision; /* ʱ侫ȣ2ĸxʾ8 bitsʱдʵʾ */
	unsigned long rootDelay; /* οʱԴӳ١32 bits̶ССbit 15bit 16֮ */
	unsigned long rootDispersion; /* οʱԴ32 bits̶ССbit 15bit 16֮ */
	char referenceID[4]; /* ʶĲοԴ */
	NTP_TIME_FMT referenceTimestamp; /* ʱһûʱʱ䣬64bitstimestampʽ */
	NTP_TIME_FMT originateTimestamp; /* ͻ˷ʱ */
	NTP_TIME_FMT receiveTimestamp; /* յʱ */
	NTP_TIME_FMT transmitTimestamp; /* Ӧʱ */
} SNTP_HEADER;

struct sntp_server {
	struct list_head list;
	char sntp_server_ip[NV_ITEM_STRING_LEN_64];
	char is_ipaddr;
};

struct sntp_sync_queue {
	struct list_head list;
	int src_id;
};
void zte_sntp_success_notify();


