

/*ͷļ*/
#include "wifi_util.h"
#include "wifi.h"
//#include "wlan-server.h"
#include "wifi_hal.h"
#include "wifi_drv_ko.h"
#include "rtk_arch.h"
#include "wlan-station.h"
#include <sys/wait.h>
#include <ctype.h>
#include <limits.h>
#include <wifi_ap_ctrl.h>
#include <wlan_rtc_sleep.h>
/*궨*/

#define CONFIG_DIR                  WIFI_CONFIG_ROOT_DIR"/wlan0"
#define CONFIG_DIR_VA0         WIFI_CONFIG_ROOT_DIR"/wlan0-va0"
#define CONFIG_DIR_VA1         WIFI_CONFIG_ROOT_DIR"/wlan0-va1"
#define CONFIG_DIR_VXD         WIFI_CONFIG_ROOT_DIR"/wlan0-vxd"
#define  INITSH                           WIFI_SCRIPT_DIR"/init.sh"
#define  INITSH1                         WIFI_SCRIPT_DIR"/init1.sh"
#define  PARASET                        WIFI_SCRIPT_DIR"/para_set.sh"
#define  PARASET1                      WIFI_SCRIPT_DIR"/para_set1.sh"
#define  WLAN_DEAL					 WIFI_SCRIPT_DIR"/wlan_basic_deal.sh"

#define WSCD_CONFIG_STATUS			(WIFI_WPS_TMP_DIR "/wscd_status")
#define WSCD_LAST_SUCCESS_ENROLLEE	(WIFI_WPS_TMP_DIR "/wscd_enrollee")


#define SHORT_MODE_DEC 22

#define MEDIUM_MODE_DEC 8

#define MAX_STA_NUM  32

extern struct   wlan_ap_server  * ap_server ;
/**/
int g_get_access_sta_count = 0;
int wps_rtc_timer_open = 0;
char g_wps_sta_mac[32] = {0};

int g_wifi_inited=0;

extern char g_wps_sta_mac[32];//wpsӵsta mac

#ifdef USE_CAP_SUPPORT
extern int send_ap_status_to_cap(int idx, int status);
#endif


static char old_accesspolicy[2] = {0};//¼or
static CHAR g_old_acl_black_mac[MAX_STA_NUM][13] = {{0}};//õĺmacб
static int g_old_acl_black_mac_num = 0;//õĺ
static CHAR g_old_acl_white_mac[MAX_STA_NUM][13] = {{0}};//õİmacб
static int g_old_acl_white_mac_num = 0;//õİ
static char g_acl_mode[2] = {0};//acl mode:0(none) 1(white) 2(black)


/**************************궨*************************/

#define WAKE_UP_TIME 5
#define WPS_STATION_ACCESS_CHECK_ALL_PERIOD 15
#define WPS_STATION_ACCESS_CHECK_PERIOD 3
/**********mmi wlan wps status***************/
#define WPS_ACTIVING "0"
#define WPS_ACTIVED "1"
#define WPS_DEACTIVING "2"
#define WPS_DEACTIVED "3"
#define WPS_ACTIVE_MAX "4"



/**/
static int wlan_get_mac_list (char* station_mac, char* athx);
extern char* translateStringToEcho (char* inputStr, char* outputStr);
void wps_down();
extern void acl_mode_set();
void basic_deal (struct wlan_ap_server  *ap_svr, int cmd);
void  wlan_generate_para_file();

struct wlan_ap_server realtek_8192_ap =  {

	.sock    		={
		.iface_name	= 	"wlan0",
		.sockets_dir	= 	"/etc_rw/wifi/hostapd",
	},
	.drv_proxy =
	{
	
		.drv_init_flag = 1, //realtek  do not use ko, so set it has been inited
		.iface_name 	=	"wlan0-vxd",
		.drv_init		= 	wlan_drv_init,
		.drv_deinit	=	wlan_drv_deinit,
	},
	.init 			=  	wlan_generate_para_file,
	.basic_deal 	=      basic_deal,
};




#ifdef __SINGLE_AP__

static void startPINWPS (char *pin)
{
	char cmd[48] = {0};

	if (NULL != pin) {
		sprintf (cmd, WIFI_SCRIPT_DIR"/wps_init1.sh pin %s", pin);
	} else {
		sprintf (cmd, WIFI_SCRIPT_DIR"/wps_init1.sh pin %s", "12345670");
		perror ("startPINWPS pin is NULL\n");
	}
	wf_log ("startPINWPS cmd=%s", cmd);
	zxic_system(cmd); //kw 3
}

static void startPBCWPS()
{
	system (WIFI_SCRIPT_DIR"/wps_init1.sh pbc");
}

#else
static void startPINWPS (char *pin)
{
	char cmd[48] = {0};

	if (NULL != pin) {
		sprintf (cmd, WIFI_SCRIPT_DIR"/wps_init.sh pin %s", pin);
	} else {
		sprintf (cmd, WIFI_SCRIPT_DIR"/wps_init.sh pin %s", "12345670");
		perror ("startPINWPS pin is NULL\n");
	}
	wf_log ("startPINWPS cmd=%s", cmd);
	zxic_system(cmd);
}

static void startPBCWPS()
{
	system (WIFI_SCRIPT_DIR"/wps_init.sh pbc");
}

#endif


static VOID wlan_set_countryCode()
{
	CHAR countryCode[10] = {0};

	sc_cfg_get ("CountryCode", countryCode, sizeof (countryCode));
	if ( (strcmp (countryCode, "NONE")) && (strcmp (countryCode, " "))) {
		wlan_write_file (CONFIG_DIR"/countrycode_enable", "1");
		wlan_write_file (CONFIG_DIR"/countrycode", countryCode);
	} else {
		wlan_write_file (CONFIG_DIR"/countrycode_enable", "0");
	}
}

static VOID wlan_set_apmode()
{
	wlan_write_file (CONFIG_DIR"/wlan_mode", "0");
}


static VOID wlan_RF_config (CHAR *wirelessMode)
{
	CHAR htMode[2] = {0};
	sc_cfg_get ("wifi_11n_cap", htMode, sizeof (htMode));

	//20M bandwidth
	if ((!strcmp (htMode, "0"))
	    || ( (!strcmp (htMode, "1")) && ( (NULL != wirelessMode) && ((!strcmp (wirelessMode, "0")) || (!strcmp (wirelessMode, "1")) || (!strcmp (wirelessMode, "3")))))) {
		wlan_write_file (CONFIG_DIR"/coexist_enabled", "0");
		wlan_write_file (CONFIG_DIR"/channel_bonding", "0");
	}
	//20M/40M bandwidth auto
	else if ( (!strcmp (htMode, "1")) && ( (NULL != wirelessMode) && ((!strcmp (wirelessMode, "2")) || (!strcmp (wirelessMode, "4"))))) {
		wlan_write_file (CONFIG_DIR"/coexist_enabled", "1");
		wlan_write_file (CONFIG_DIR"/channel_bonding", "1");
	} else {
		wlan_write_file (CONFIG_DIR"/coexist_enabled", "1");
		wlan_write_file (CONFIG_DIR"/channel_bonding", "1");
	}
	
}

static VOID wlan_rate_config (UINT8 *wirelessMode, UINT8 *wifiBand)
{
	if (!strcmp (wifiBand, "b")) {
		wlan_write_file (CONFIG_DIR"/rate_adaptive_enabled", "1");
		wlan_write_file (CONFIG_DIR"/fix_rate", "0");
	} else if (strcmp (wifiBand, "b")) {
		wlan_write_file (CONFIG_DIR"/rate_adaptive_enabled", "1");
		wlan_write_file (CONFIG_DIR"/fix_rate", "0");
	}
}

static VOID wlan_80211Mode_config()
{
	CHAR wirelessMode[2] = {0};
	CHAR wifiBand[2] = {0};

	sc_cfg_get ("WirelessMode", wirelessMode, sizeof (wirelessMode));
	sc_cfg_get ("wifi_band", wifiBand, sizeof (wifiBand));

	
	if ( (!strcmp (wirelessMode, "4")) && (!strcmp (wifiBand, "b"))) {//11b/g/n mixed mode
		wlan_write_file (CONFIG_DIR"/band", "11");
	}
	else if ( (!strcmp (wirelessMode, "2")) && (!strcmp (wifiBand, "b"))) {//11n
		wlan_write_file (CONFIG_DIR"/band", "8");
	}	
	else if ( (!strcmp (wirelessMode, "0")) && (!strcmp (wifiBand, "b"))) {//11b only
		wlan_write_file (CONFIG_DIR"/band", "1");
	}	
	else if ( (!strcmp (wirelessMode, "1")) && (!strcmp (wifiBand, "b"))) {//11g only
		wlan_write_file (CONFIG_DIR"/band", "2");
	}	
	else if ( (!strcmp (wirelessMode, "3")) && (!strcmp (wifiBand, "b"))) {//11b/g
		wlan_write_file (CONFIG_DIR"/band", "3");
	} else {
		wlan_write_file (CONFIG_DIR"/band", "11");
	}

	wlan_RF_config (wirelessMode);
	wlan_rate_config (wirelessMode, wifiBand);
}


static VOID wlan_set_wifiConverage()
{
	CHAR wifiCoverage[16] = {0};
	CHAR file_path_buf[100] = {0};

	sc_cfg_get ("wifi_coverage", wifiCoverage, sizeof (wifiCoverage));
	sprintf (file_path_buf, "%s/tx_power_percet", CONFIG_DIR);

	if (!strcmp (wifiCoverage, "short_mode")) {
		wlan_write_file (CONFIG_DIR"/tx_power_percet", "40");
	} else if (!strcmp (wifiCoverage, "medium_mode")) {
		wlan_write_file (CONFIG_DIR"/tx_power_percet", "70");
	} else { //long mode
		wlan_write_file (CONFIG_DIR"/tx_power_percet", "100");
	}
}

static void wlan_set_channel_for_lte (int changeMode, char* htMode)
{
	CHAR file_path_buf[100] = {0};

	wf_log (">>wlan_set_channel_for_lte changeMode is %d", changeMode);
	if (changeMode == 2) { //TDD
		wlan_write_file (CONFIG_DIR"/channel", "11");

		if ( (NULL != htMode) && (!strcmp (htMode, "1"))) {
			wlan_write_file (CONFIG_DIR"/control_sideband", "0");
		}
	} else if (changeMode == 1) { //FDD
		wlan_write_file (CONFIG_DIR"/channel", "1");
		if ( (NULL != htMode) && (!strcmp (htMode, "1"))) {
			wlan_write_file (CONFIG_DIR"/control_sideband", "1");
		}
	}
}

static VOID wlan_set_channel()
{
	CHAR autoChannelSelect[2] = {0};
	CHAR channel[3] = {0};
	CHAR file_path_buf[100] = {0};
	CHAR htMode[2] = {0};


	sc_cfg_get ("wifi_11n_cap", htMode, sizeof (htMode));
	sc_cfg_get ("Channel", channel, sizeof (channel));


	if ( (!strcmp (channel, "")) || (!strcmp (channel, "0"))) {
		//sc_cfg_set ("AutoChannelSelect" , "1");
		wf_log("wlan_set_channel AutoChannelSelect \n");
		strcpy(autoChannelSelect, "1");
	} else {
		//sc_cfg_set ("AutoChannelSelect" , "0");
		wf_log("wlan_set_channel AutoChannelSelect not \n");
		strcpy(autoChannelSelect, "0");
	}

	if (strcmp (autoChannelSelect, "1")) {
		wlan_write_file (CONFIG_DIR"/channel", channel);
		memset (file_path_buf, 0, 100);
		if (!strcmp (htMode, "1")) {
			if (atoi (channel) < 5) {
				wlan_write_file (CONFIG_DIR"/control_sideband", "1");
			} else {
				wlan_write_file (CONFIG_DIR"/control_sideband", "0");
			}
		}
	} else { //auto channel
			wlan_write_file (CONFIG_DIR"/channel", "0");
	}
}

static VOID wlan_set_maxassoc()
{
	CHAR maxAccessNum[8] = {0};
	CHAR max_sta_num_str[8] = {0};

	sc_cfg_get ("MAX_Access_num", maxAccessNum, sizeof (maxAccessNum));

	if (atoi (maxAccessNum) < MAX_STA_NUM) {
		wlan_write_file (CONFIG_DIR"/supported_sta_num", maxAccessNum);
	} else {
		sprintf (max_sta_num_str, "%d", MAX_STA_NUM);
		wlan_write_file (CONFIG_DIR"/supported_sta_num", max_sta_num_str);
	}
}

static VOID wlan_set_bss()
{
	CHAR ssid[33] = {0};
	CHAR wifi_mac[20] = {0};
	CHAR tmp_mac[20] = {0};
	CHAR tmp_ssid[65] = {0};

	sc_cfg_get ("SSID1", ssid, sizeof (ssid));
	sc_cfg_get ("m_wifi_mac", wifi_mac, sizeof (wifi_mac));

	translateStringToEcho (ssid, tmp_ssid);// ʹecho ǷֱдļԽ
	wlan_write_file (CONFIG_DIR"/ssid", tmp_ssid);

	if(strlen(wifi_mac)==0) return;

	sprintf (tmp_mac, "%c%c%c%c%c%c%c%c%c%c%c%c", wifi_mac[0], wifi_mac[1], wifi_mac[3], wifi_mac[4], wifi_mac[6], wifi_mac[7], wifi_mac[9], wifi_mac[10],  wifi_mac[12], wifi_mac[13], wifi_mac[15], wifi_mac[16]);
	wlan_write_file (CONFIG_DIR"/wlan0_addr", tmp_mac);

}

static VOID wlan_set_hideSSID()
{
	CHAR hideSSID[2] = {0};
	CHAR file_path_buf[100] = {0};

	sc_cfg_get ("HideSSID", hideSSID, sizeof (hideSSID));

	if (!strcmp (hideSSID, "1")) {
		wlan_write_file (CONFIG_DIR"/hidden_ssid", "1");
	} else {
		wlan_write_file (CONFIG_DIR"/hidden_ssid", "0");
	}
}

static VOID wlan_set_aggregation()
{
	wlan_write_file (CONFIG_DIR"/aggregation", "1");
}

static VOID wlan_set_wmm()
{
	wlan_write_file (CONFIG_DIR"/wmm_enabled", "1");
}

static VOID wlan_set_NoForwarding()
{
	CHAR isolate[2] = {0};

	sc_cfg_get ("NoForwarding", isolate, sizeof (isolate));

	if (!strcmp (isolate, "1")) {
		wlan_write_file (CONFIG_DIR"/block_relay", "1");
	} else {
		wlan_write_file (CONFIG_DIR"/block_relay", "0");
	}
}

static VOID wlan_set_ShortGI()
{

	CHAR ht_gi[2] = {0};

	sc_cfg_get ("HT_GI", ht_gi, sizeof (ht_gi));

	if (!strcmp (ht_gi, "1")) {
		wlan_write_file (CONFIG_DIR"/short_gi", "1");
	} else {
		wlan_write_file (CONFIG_DIR"/short_gi", "0");
	}
}

static VOID wlan_set_dtim()
{
	CHAR dtim[2] = {0};
	sc_cfg_get ("DtimPeriod", dtim, sizeof (dtim));
	wlan_write_file (CONFIG_DIR"/dtim_period", dtim);
}


static VOID wlan_set_fragthreshold()
{
	CHAR fragThreshold[10] = {0};
	sc_cfg_get ("FragThreshold", fragThreshold, sizeof (fragThreshold));
	wlan_write_file (CONFIG_DIR"/frag_threshold", fragThreshold);
}

static VOID wlan_set_rtsthreshold()
{
	CHAR rtsThreshold[10] = {0};

	sc_cfg_get ("RTSThreshold", rtsThreshold, sizeof (rtsThreshold));
	wlan_write_file (CONFIG_DIR"/rts_threshold", rtsThreshold);
}

static VOID wlan_set_encrypType_WPA (const char *ifname)
{
	CHAR EncrypType[16] = {0};
	CHAR cmd[100] = {0};
	CHAR * dir = NULL;

	if (strcmp (ifname, "wlan0") == 0) {
		dir = CONFIG_DIR;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;
		sc_cfg_get ("m_EncrypType", EncrypType, sizeof (EncrypType));
	} else {
		wf_log ("ifcae not find!");
		return;
	}

	if (!strcmp (EncrypType, "AES")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "2");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "0");
	} else if (!strcmp (EncrypType, "TKIP")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "1");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "0");

	} else if (!strcmp (EncrypType, "TKIPAES")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "3");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "0");
	}
}

static VOID wlan_set_encrypType_WPA2 (const char * ifname)
{
	CHAR EncrypType[16] = {0};
	CHAR cmd[100] = {0};
	CHAR * dir = NULL;

	if (strcmp (ifname, "wlan0") == 0) {
		dir = CONFIG_DIR;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;
		sc_cfg_get ("m_EncrypType", EncrypType, sizeof (EncrypType));
	} else {
		wf_log ("ifcae not find!");
		return;
	}

	if (!strcmp (EncrypType, "AES")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "0");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "2");
	} else if (!strcmp (EncrypType, "TKIP")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "0");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "1");
	} else if (!strcmp (EncrypType, "TKIPAES")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "0");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "3");
	}
}

static VOID wlan_set_encrypType_WPAWPA2 (const char* ifname)
{
	CHAR EncrypType[12] = {0};
	CHAR cmd[100] = {0};

	CHAR * dir = NULL;

	if (strcmp (ifname, "wlan0") == 0) {
		dir = CONFIG_DIR;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;
		sc_cfg_get ("m_EncrypType", EncrypType, sizeof (EncrypType));
	} else {
		wf_log ("ifcae not find!");
		return;
	}

	if (!strcmp (EncrypType, "AES")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "2");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "2");


	} else if (!strcmp (EncrypType, "TKIP")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "1");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "1");

	} else if (!strcmp (EncrypType, "TKIPAES")) {
		sprintf (cmd, "%s/wpa_cipher", dir);
		wlan_write_file (cmd, "3");
		memset (cmd, 0, 100);
		sprintf (cmd, "%s/wpa2_cipher", dir);
		wlan_write_file (cmd, "3");


	}
}

static VOID wlan_set_encrypType_WPA3 (const char * ifname)
{
	CHAR EncrypType[16] = {0};
	CHAR cmd[100] = {0};
	CHAR * dir = NULL;

	if (strcmp (ifname, "wlan0") == 0) {
		dir = CONFIG_DIR;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;
		sc_cfg_get ("m_EncrypType", EncrypType, sizeof (EncrypType));
	} else {
		wf_log ("ifcae not find!");
		return;
	}

	sprintf (cmd, "%s/wpa_cipher", dir);
	wlan_write_file (cmd, "0");
	memset (cmd, 0, 100);
	sprintf (cmd, "%s/wpa2_cipher", dir);
	wlan_write_file (cmd, "2");
	
}


static VOID wlan_set_wep_key_hex (CHAR *KeyStr, int i, const char * dir)
{
	int len = 0;
	CHAR cmd[100] = {0};
	if (NULL == KeyStr) {
		return;
	}
	len = strlen (KeyStr);
	if (len == 10) { //64
		//kw 3
		memset (cmd, 0 , 100);
		sprintf (cmd, "%s/wep", dir);
		wlan_write_file (cmd, "1");

		memset (cmd, 0 , 100);
		sprintf (cmd, "%s/wepkey%d_64_hex", dir, i);
		wlan_write_file (cmd, KeyStr);

	} else if (len == 26) { // 128
		//kw 3
		memset (cmd, 0 , 100);
		sprintf (cmd, "%s/wep", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0 , 100);
		sprintf (cmd, "%s/wepkey%d_128_hex", dir, i);
		wlan_write_file (cmd, KeyStr);

	} else {
		wf_log ("wlan_set_wep_key_hex KeyStr is bad !");
		return;
	}
}

static int ascii_trans_hex (CHAR *asc_in, CHAR *hex_out)
{
	int len = 0;
	int i , j = 0;
	CHAR tmp_str[32] = {0};
	CHAR str[3] = {0};
#if 0 //kw 3
	if ( (NULL == asc_in) || (NULL == hex_out)) {
		return 0;
	}
#endif
	len = strlen (asc_in);

	for (i = 0, j = 0; i < len; i++, j += 2) {
		sprintf (str, "%02x", asc_in[i]);
		tmp_str[j] = str[0];
		tmp_str[j + 1] = str[1];
	}
	tmp_str[j] = '\0';

	strcpy (hex_out, tmp_str);
	return 1;
}


static VOID wlan_set_wep_key_ascii (CHAR *KeyStr, int i, const char * dir)
{
	int len = 0;
	CHAR cmd[128] = {0};

	if (NULL == KeyStr) {
		return;
	}
	len = strlen (KeyStr);

	if (len == 5) { //64
		CHAR hexKeyStr[12] = {0};
		//kw 3
		memset (cmd, 0 , 128);
		sprintf (cmd, "%s/wep", dir);
		wlan_write_file (cmd, "1");
		//kw 3
		ascii_trans_hex (KeyStr, hexKeyStr);
		memset (cmd, 0 , 128);
		sprintf (cmd, "%s/wepkey%d_64_asc", dir, i);
		wlan_write_file (cmd, hexKeyStr);

	} else if (len == 13) { // 128
		CHAR hexKeyStr[28] = {0};
		//kw 3
		memset (cmd, 0 , 128);
		sprintf (cmd, "%s/wep", dir);
		wlan_write_file (cmd, "2");
		//kw 3
		ascii_trans_hex (KeyStr, hexKeyStr);
		memset (cmd, 0 , 128);
		sprintf (cmd, "%s/wepkey%d_128_asc", dir, i);
		wlan_write_file (cmd, hexKeyStr);
		
	} else {
		wf_log ("wlan_set_wep_key_ascii KeyStr is bad !");
		return;
	}
}


static VOID wlan_add_wep (int index, const char * ifname)
{
	CHAR wep_is_hex_0[2] = {0};
	CHAR KeyType[21] = {0}; //klocwork
	CHAR KeyName[21] = {0};
	CHAR KeyStr[32] = {0};
	CHAR cmd[256] = {0};
	CHAR * dir = NULL;


	if (strcmp (ifname, "wlan0") == 0) {
		dir = CONFIG_DIR;
		sprintf (KeyType, "Key%dType", index);
		sprintf (KeyName, "Key%dStr1", index);


	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;
		sprintf (KeyType, "Key%dType", index);
		sprintf (KeyName, "Key%dStr1", index);


	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;
		sprintf (KeyType, "m_Key%dType", index);
		sprintf (KeyName, "m_Key%dStr1", index);
	} else {
		wf_log ("ifcae not find!");
		return;
	}

	sc_cfg_get (KeyType, wep_is_hex_0, sizeof (wep_is_hex_0));
	sc_cfg_get (KeyName, KeyStr, sizeof (KeyStr));

	if (!strcmp (wep_is_hex_0, "0")) { //hex key
		memset (cmd, 0 , 256);
		sprintf (cmd, "%s/wep_key_type", dir);
		wlan_write_file (cmd, "1");
		wlan_set_wep_key_hex (KeyStr, index, dir);
	} else { //ascii key
		memset (cmd, 0 , 256);
		sprintf (cmd, "%s/wep_key_type", dir);
		wlan_write_file (cmd, "0");

		wlan_set_wep_key_ascii (KeyStr, index, dir);
	}
}

static VOID wlan_set_wep (CHAR *authMode, const char * ifname)
{
	CHAR cmd[256] = {0};
	CHAR ap_primary_key_0[2] = {0};
	int i = 0;

	CHAR * dir = NULL;
	int index = 0;

	if (strcmp (ifname, "wlan0") == 0) {
		dir = CONFIG_DIR;
		sc_cfg_get ("DefaultKeyID", ap_primary_key_0, sizeof (ap_primary_key_0));
	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;
		sc_cfg_get ("DefaultKeyID", ap_primary_key_0, sizeof (ap_primary_key_0));
	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;
		sc_cfg_get ("m_DefaultKeyID", ap_primary_key_0, sizeof (ap_primary_key_0));
	} else {
		wf_log ("ifcae not find!");
		return;
	}

	memset (cmd, 0 , 256);
	sprintf (cmd, "%s/encrypt", dir);
	wlan_write_file (cmd, "1");

	memset (cmd, 0 , 256);
	sprintf (cmd, "%s/wep_default_key", dir);
	wlan_write_file (cmd, ap_primary_key_0);

	index = atoi(ap_primary_key_0);
	if (index < 0 || index > 4) { //kw 3, wep 4 group keys
		wf_log("wep group key index:%d!", index);
		return;
	}	
	wlan_add_wep(index + 1, ifname);

	if ( (NULL != authMode) && (!strcmp (authMode, "OPEN"))) {
		memset (cmd, 0 , 256);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "0");

	} else if ( (NULL != authMode) && (!strcmp (authMode, "SHARED"))) {
		memset (cmd, 0 , 256);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "1");

	} else {
		memset (cmd, 0 , 256);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "2");

	}
}

static VOID va1_set_apmode()
{
	wlan_write_file (CONFIG_DIR_VA1"/wlan_mode", "0");
}

static VOID va0_set_apmode()
{
	wlan_write_file (CONFIG_DIR_VA0"/wlan_mode", "0");
}

static VOID va1_set_hideSSID()
{
	CHAR hideSSID[2] = {0};
	sc_cfg_get ("m_HideSSID", hideSSID, sizeof (hideSSID));

	if (!strcmp (hideSSID, "1")) {
		wlan_write_file (CONFIG_DIR_VA1"/hidden_ssid", "1");
	} else {
		wlan_write_file (CONFIG_DIR_VA1"/hidden_ssid", "0");
	}
}

static VOID va0_set_hideSSID()
{
	CHAR hideSSID[2] = {0};
	sc_cfg_get ("HideSSID", hideSSID, sizeof (hideSSID));

	if (!strcmp (hideSSID, "1")) {
		wlan_write_file (CONFIG_DIR_VA0"/hidden_ssid", "1");

	} else {
		wlan_write_file (CONFIG_DIR_VA0"/hidden_ssid", "0");
	}
}

static VOID va1_set_maxassoc()
{
	CHAR m_MAX_Access_num[8] = {0};
	CHAR MAX_Access_num[8] = {0};
	int m_access_num = 0;
	int access_num = 0;
	CHAR cmd[100] = {0};
	CHAR file_path_buf[100] = {0};

	sc_cfg_get ("MAX_Access_num", MAX_Access_num, sizeof (MAX_Access_num));
	sc_cfg_get ("m_MAX_Access_num", m_MAX_Access_num, sizeof (m_MAX_Access_num));
	//kw 3
	access_num = atoi(MAX_Access_num);
	m_access_num = atoi(m_MAX_Access_num);
	if ((access_num < 0 || access_num > MAX_STA_NUM) ||
		(m_access_num < 0 || m_access_num > MAX_STA_NUM)) {
		wf_log("va1_set_maxassoc:%d,%d!", access_num, m_access_num);
		return;
	}

	if ((access_num + m_access_num) <= MAX_STA_NUM) {
		wlan_write_file (CONFIG_DIR_VA1"/supported_sta_num", m_MAX_Access_num);
	} else {
		char sta_num[12] = {0}; //klocwork
		sprintf (sta_num, "%d", MAX_STA_NUM - access_num);
		wlan_write_file (CONFIG_DIR_VA1"/supported_sta_num", sta_num);
	}
}


static VOID va0_set_maxassoc()
{
	CHAR maxAccessNum[8] = {0};
	CHAR max_sta_num_str[100] = {0};

	sc_cfg_get ("MAX_Access_num", maxAccessNum, sizeof (maxAccessNum));

	if (atoi (maxAccessNum) < MAX_STA_NUM) {
		wlan_write_file (CONFIG_DIR_VA0"/supported_sta_num", maxAccessNum);
	} else {
		sprintf (max_sta_num_str, "%d", MAX_STA_NUM);
		wlan_write_file (CONFIG_DIR_VA0"/supported_sta_num", max_sta_num_str);
	}
}

static VOID va1_set_bss()
{
	CHAR bssid[33] = {0};
	CHAR m_wifi_mac[20] = {0};
	CHAR cmd[20] = {0};
	CHAR tmpbssid[65] = {0};

	sc_cfg_get ("m_SSID", bssid, sizeof (bssid));
	sc_cfg_get ("m_wifi_mac", m_wifi_mac, sizeof (m_wifi_mac));
	wf_log (" va1 m_wifi_mac = %s", m_wifi_mac);

	translateStringToEcho (bssid, tmpbssid);
	wlan_write_file (CONFIG_DIR_VA1"/ssid", tmpbssid);

	if(strlen(m_wifi_mac)==0) return;
	sprintf (cmd, "%c%c%c%c%c%c%c%c%c%c%c%c",
			m_wifi_mac[0], m_wifi_mac[1], m_wifi_mac[3], m_wifi_mac[4],
			m_wifi_mac[6], m_wifi_mac[7], m_wifi_mac[9], m_wifi_mac[10],
			m_wifi_mac[12], m_wifi_mac[13], m_wifi_mac[15], m_wifi_mac[16]);
	wlan_write_file (CONFIG_DIR"/wlan2_addr", cmd);
}


static VOID va0_set_bss()
{
	CHAR bssid[33] = {0};
	CHAR wifi_mac[20] = {0};
	CHAR cmd[20] = {0};
	CHAR tmpbssid[65] = {0};

	sc_cfg_get ("SSID1", bssid, sizeof (bssid));
	sc_cfg_get ("wifi_mac", wifi_mac, sizeof (wifi_mac));

	wf_log ("va0 wifi_mac = %s", wifi_mac);

	translateStringToEcho (bssid, tmpbssid);
	wlan_write_file (CONFIG_DIR_VA0"/ssid", tmpbssid);

	if(strlen(wifi_mac)==0) return;

	sprintf (cmd, "%c%c%c%c%c%c%c%c%c%c%c%c",
		wifi_mac[0], wifi_mac[1], wifi_mac[3], wifi_mac[4],
		wifi_mac[6], wifi_mac[7], wifi_mac[9], wifi_mac[10],
		wifi_mac[12], wifi_mac[13], wifi_mac[15], wifi_mac[16]);

	wlan_write_file (CONFIG_DIR"/wlan1_addr", cmd);

}

static void vxd_sta_para_set()
{
	wlan_write_file (CONFIG_DIR_VXD"/wlan_mode", "1");
	wlan_write_file (CONFIG_DIR_VXD"/network_type", "0");
}

static void wlan_ap_para_set (const char* ifname)
{
	CHAR authMode[32] = {0};
	CHAR psk[65] = {0};
	CHAR RekeyInterval[10] = {0};
	CHAR cmd[192] = {0};
	CHAR wapiType[2] = {0};
	CHAR EncrypType[32] = {0};

	CHAR *dir = NULL;

	if (strcmp (ifname, "wlan0") == 0) {

		dir = CONFIG_DIR;
		wlan_set_apmode();
		wlan_set_maxassoc();
		wlan_set_bss();
		wlan_set_hideSSID();

		sc_cfg_get ("AuthMode", authMode, sizeof (authMode));
		sc_cfg_get ("WPAPSK1", psk, sizeof (psk));
		sc_cfg_get ("wapiType", wapiType, sizeof (wapiType));
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va0") == 0) {
		dir = CONFIG_DIR_VA0;

		va0_set_apmode();
		va0_set_maxassoc();
		va0_set_bss();
		va0_set_hideSSID();

		sc_cfg_get ("AuthMode", authMode, sizeof (authMode));
		sc_cfg_get ("WPAPSK1", psk, sizeof (psk));
		sc_cfg_get ("wapiType", wapiType, sizeof (wapiType));
		sc_cfg_get ("EncrypType", EncrypType, sizeof (EncrypType));
	} else if (strcmp (ifname, "wlan0-va1") == 0) {
		dir = CONFIG_DIR_VA1;

		va1_set_apmode();
		va1_set_maxassoc();
		va1_set_bss();
		va1_set_hideSSID();

		sc_cfg_get ("m_AuthMode", authMode, sizeof (authMode));
		sc_cfg_get ("m_WPAPSK1", psk, sizeof (psk));
		sc_cfg_get ("m_wapiType", wapiType, sizeof (wapiType));
		sc_cfg_get ("m_EncrypType", EncrypType, sizeof (EncrypType));
	} else {
		wf_log ("ifcae not find!");
		return;
	}


	if (strcmp (authMode, "WAPIPSK")) {
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/wapiType", dir);
		wlan_write_file (cmd, "0");
	}
	if (!strcmp (authMode, "WPAPSK")) {
		CHAR tmppsk[129] = {0};
		wlan_set_encrypType_WPA (ifname);
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/encrypt", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/enable_1x", dir);
		wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		translateStringToEcho (psk, tmppsk);
		sprintf (cmd, "%s/wpa_psk", dir);
		wlan_write_file (cmd, tmppsk);

#if 0
		sc_cfg_get ("RekeyInterval", RekeyInterval, sizeof (RekeyInterval));
		if ( (NULL != RekeyInterval) || (strcmp (RekeyInterval, ""))) {
			memset (cmd, 0, 192);
			sprintf (cmd, "echo %s > %s/gk_rekey", RekeyInterval, dir);
			system (cmd);
		} else {
			memset (cmd, 0, 192);
			sprintf (cmd, "echo \"38400\" > %s/gk_rekey", dir);
			system (cmd);
		}
#endif
	} else if (!strcmp (authMode, "WPA2PSK")) {
		CHAR tmppsk[129] = {0};
		wlan_set_encrypType_WPA2 (ifname);
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/encrypt", dir);
		wlan_write_file (cmd, "4");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/enable_1x", dir);
		wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		translateStringToEcho (psk, tmppsk);
		sprintf (cmd, "%s/wpa_psk", dir);
		wlan_write_file (cmd, tmppsk);


#if 0

		sc_cfg_get ("RekeyInterval", RekeyInterval, sizeof (RekeyInterval));
		if ( (NULL != RekeyInterval) || (strcmp (RekeyInterval, ""))) {
			memset (cmd, 0, 192);
			sprintf (cmd, "echo %s > %s/gk_rekey", RekeyInterval, dir);
			system (cmd);
		} else {
			memset (cmd, 0, 192);
			sprintf (cmd, "echo \"38400\" > %s/gk_rekey", dir);
			system (cmd);
		}
#endif
	} 
	else if (!strcmp (authMode, "WPAPSKWPA2PSK") || !strcmp (authMode, "WPA-PSK/WPA2-PSK")) {
		CHAR tmppsk[129] = {0};
		wlan_set_encrypType_WPAWPA2 (ifname);
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/encrypt", dir);
		wlan_write_file (cmd, "6");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/enable_1x", dir);
		wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		translateStringToEcho (psk, tmppsk);
		sprintf (cmd, "%s/wpa_psk", dir);
		wlan_write_file (cmd, tmppsk);

#if 0

		sc_cfg_get ("RekeyInterval", RekeyInterval, sizeof (RekeyInterval));
		if ( (NULL != RekeyInterval) || (strcmp (RekeyInterval, ""))) {
			memset (cmd, 0, 192);
			sprintf (cmd, "echo %s > %s/gk_rekey", RekeyInterval, dir);
			system (cmd);
		} else {
			memset (cmd, 0, 192);
			sprintf (cmd, "echo \"38400\" > %s/gk_rekey", dir);
			system (cmd);
		}
#endif
	} else if (!strcmp (authMode, "WPA3Personal")) {
		CHAR tmppsk[129] = {0};
		wlan_set_encrypType_WPA3 (ifname);
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/encrypt", dir);
		wlan_write_file (cmd, "8");

		//memset (cmd, 0, 192);
		//sprintf (cmd, "%s/enable_1x", dir);
		//wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		translateStringToEcho (psk, tmppsk);
		sprintf (cmd, "%s/wpa_psk", dir);
		wlan_write_file (cmd, tmppsk);

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/wpa11w", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/wpa2EnableSHA256", dir);
		wlan_write_file (cmd, "1");

	} else if (!strcmp (authMode, "WPA2WPA3")) {
		CHAR tmppsk[129] = {0};
		wlan_set_encrypType_WPA3 (ifname);
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/encrypt", dir);
		wlan_write_file (cmd, "10");

		//memset (cmd, 0, 192);
		//sprintf (cmd, "%s/enable_1x", dir);
		//wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "2");

		memset (cmd, 0, 192);
		translateStringToEcho (psk, tmppsk);
		sprintf (cmd, "%s/wpa_psk", dir);
		wlan_write_file (cmd, tmppsk);

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/wpa11w", dir);
		wlan_write_file (cmd, "1"); //PMF disable/enable/required 0/1/2

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/wpa2EnableSHA256", dir);
		wlan_write_file (cmd, "1");

	} else if ( ( (!strcmp ("WEP", EncrypType)) && (!strcmp ("OPEN", authMode))) || (!strcmp ("SHARED", authMode)) || (!strcmp ("WEPAUTO", authMode))) { //WEP
		wlan_set_wep (authMode, ifname);
	} else if (!strcmp (authMode, "WAPIPSK")) {
		if (strcmp (wapiType, "0") && strcmp (wapiType, "")) {
			CHAR wapiPsk[65] = {0};
			CHAR tmpwapiPsk[129] = {0};
			sc_cfg_get ("WPAPSK1", wapiPsk, sizeof (wapiPsk));

			memset (cmd, 0, 192);
			translateStringToEcho (wapiPsk, tmpwapiPsk);
			sprintf (cmd, "echo \"%s\" > %s/wapiPsk", tmpwapiPsk, dir);
			soft_system (cmd);
			perror (cmd);
			memset (cmd, 0, 192);
			sprintf (cmd, "echo %x > %s/wapiPsklen", strlen (wapiPsk), dir);
			soft_system (cmd);
			perror (cmd);
			memset (cmd, 0, 192);
			sprintf (cmd, "echo %s > %s/wapiType", wapiType, dir);
			soft_system (cmd);
			perror (cmd);
		}
	} else { //open
		memset (cmd, 0, 192);
		sprintf (cmd, "%s/encrypt", dir);
		wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/psk_enable", dir);
		wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/enable_1x", dir);
		wlan_write_file (cmd, "0");

		memset (cmd, 0, 192);
		sprintf (cmd, "%s/auth_type", dir);
		wlan_write_file (cmd, "0");

	}
}
static void wlan_set_vxd_on()
{
	wlan_write_file (CONFIG_DIR_VXD"/wlan_disabled", "0");
}
static void wlan_set_vxd_off()
{
	wlan_write_file (CONFIG_DIR_VXD"/wlan_disabled", "1");
}

static void wlan_set_va1_on()
{
	wlan_write_file (CONFIG_DIR_VA1"/wlan_disabled", "0");
}

static void wlan_set_va1_off()
{
	wlan_write_file (CONFIG_DIR_VA1"/wlan_disabled", "1");
}

static void wlan_set_va0_on()
{
	wlan_write_file (CONFIG_DIR_VA0"/wlan_disabled", "0");
}

static void wlan_set_va0_off()
{
	wlan_write_file (CONFIG_DIR_VA0"/wlan_disabled", "1");
}

static void wlan_set_ssid_on()
{
	wlan_write_file (CONFIG_DIR"/wlan_disabled", "0");
}

static void wlan0_radio_para_set()
{
	wlan_set_countryCode();
	wlan_80211Mode_config();
	wlan_set_wifiConverage();
	wlan_set_channel();
	//wlan_set_rate();
//    wlan_set_beaconinterval();
//    wlan_set_aggregation();
//    wlan_set_wmm();
	//wlan_set_11nparam();
	wlan_set_NoForwarding();
//    wlan_set_ShortGI();
//    wlan_set_dtim();
//    wlan_set_fragthreshold();
//   wlan_set_rtsthreshold();
}

static void wlan0_para_set()
{
	wlan_set_ssid_on();

	//set m_wifi_mac to wlan0_addr  for  vxd interface
	wlan_ap_para_set ("wlan0");
}

static void wlan_set_param()
{
	char m_ssid_enable[8] = {0};
	char wifi_sta_connection[8] = {0};

	wf_log ("[wlan0_radio_para_set]");

	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
	sc_cfg_get ("wifi_sta_connection", wifi_sta_connection, sizeof (wifi_sta_connection));

	wlan0_radio_para_set();
	wlan0_para_set();

#ifndef  __SINGLE_AP__
	wf_log ("[va0 va1 vxd para set, and set va0 open]");

	//every time poweron, need to set all para for every interface
	wlan_set_va0_on();
	wlan_ap_para_set ("wlan0-va0");
	wlan_ap_para_set ("wlan0-va1");
	vxd_sta_para_set(); //wlan_mode  wlan_disabled mac  network_type

	if (strcmp (m_ssid_enable, "1") == 0) {
		wlan_set_va1_on();
	} else {
		wlan_set_va1_off();
	}

	if (strcmp (wifi_sta_connection, "1") == 0) {
		wlan_set_vxd_on();
	} else {
		wlan_set_vxd_off();
	}
#endif
}
#if 0 //kw 3
//ŵַı֪ͨĿ
static void arp_br0()
{
	CHAR ip_addr[20] = {0};
	CHAR cmd[100] = {0};

	sc_cfg_get ("lan_ipaddr", ip_addr, sizeof (ip_addr));
	
	if ( (NULL != ip_addr) || (strcmp (ip_addr, ""))) {
		sprintf (cmd, "arping -U -c 1 -I br0 %s", ip_addr);
	} else {
		sprintf (cmd, "arping -U -c 1 -I br0 %s", "192.168.0.1");
	}
	system (cmd);
}
#endif
/* ************  ЩصĲЭṩ ********** */
void stop_vxd()
{
	wf_log ("stop_vxd ");
	system ("ifconfig wlan0-vxd down");
}

//wifiڵĲ˳Ҫ󣬲ܷϢ첽ֱӵṩű
static void stop_va1()
{
	wf_log ("stop_va1 ");
	system("iwpriv  wlan0-va1  clear_acl_table; \
	                ifconfig wlan0-va1 down");
//	system ("iwpriv wlan0-va1 clear_acl_table");
//	system ("landev_updown.sh \"wifilan2\" \"down\"");
}

static void stop_va0()
{
	wf_log ("stop_va0 ");
	system("ifconfig wlan0-va0 down");
//	system ("landev_updown.sh \"wifilan\" \"down\"");
}

static void stop_wlan0()
{
	system ("ifconfig wlan0 down");
}

static void stop_wifi()
{
// رwlan0 ͬʱSSIDڿ״̬ҲҪر
// пܹرwifiͬʱҲرնSSIDԴ˴Ҫж
	stop_va0();
	stop_va1();
	stop_vxd();
	stop_wlan0();
	//arp_br0();
}

//ȫֱ
static void renew_global_acl_table()
{
	char accesscontrollist0[720] = {0};
	char accesspolicy0[10] = {0};
	char *acl_mac_ptr = NULL;
	char *acl_mac_ptr_find = NULL;
	int acl_mac_num = 0;
	int acl_cn =  0;

	char acl_mac_new[MAX_STA_NUM][13] = {0};
	char acl_mac[18] = {0};
	char acl_mac_out[13] = {0};
	int tmp_num = 0;
	int i = 0;

	sc_cfg_get ("AccessPolicy0", accesspolicy0, sizeof (accesspolicy0));
	sc_cfg_get ("AccessControlList0", accesscontrollist0, sizeof (accesscontrollist0));

	acl_mac_ptr_find = accesscontrollist0;
	acl_mac_num = find_substr_num (acl_mac_ptr_find, ';');
	wf_log ("acl_mac_num is %d", acl_mac_num);
	tmp_num = acl_mac_num;

	if (acl_mac_num >= 1 && (strcmp (accesspolicy0, "") && strcmp (accesspolicy0, "0"))) {
		acl_mac_num--;
		acl_mac_ptr = accesscontrollist0;
		//kw 3
		strncpy (acl_mac, acl_mac_ptr, 17);
		deleteCharFromStr (':', acl_mac, acl_mac_out);

		strncpy (& (acl_mac_new[0][0]), acl_mac_out, 12);
		wf_log ("acl_mac_new :%s", & (acl_mac_new[0][0]));
		
		for (acl_cn = 0; acl_cn < acl_mac_num; acl_cn++) {
			if (NULL != acl_mac_ptr  && (acl_mac_ptr = strstr (acl_mac_ptr, ";")) != NULL) {
				acl_mac_ptr = acl_mac_ptr + 1;
				strncpy (acl_mac, acl_mac_ptr, 17);
				deleteCharFromStr (':', acl_mac, acl_mac_out);

				strncpy (& (acl_mac_new[0][0]) + (acl_cn + 1) * 13, acl_mac_out, 12);
				wf_log ("acl_mac_new :%s", & (acl_mac_new[0][0]) + (acl_cn + 1) * 13);
			}
		}

		if (strcmp (accesspolicy0, "2") == 0) {

			for (i = 0; i < g_old_acl_black_mac_num; i++) {
				memset (g_old_acl_black_mac[i], 0, 13);
			}
			g_old_acl_black_mac_num = tmp_num;
			for (i = 0; i < g_old_acl_black_mac_num; i++) {
				strncpy (g_old_acl_black_mac[i], (& (acl_mac_new[0][0]) + i * 13), 12);
			}
		} else if (strcmp (accesspolicy0, "1") == 0) {
			for (i = 0; i < g_old_acl_white_mac_num; i++) {
				memset (g_old_acl_white_mac[i], 0, 13);
			}
			g_old_acl_white_mac_num = tmp_num;
			for (i = 0; i < g_old_acl_white_mac_num; i++) {
				strncpy (g_old_acl_white_mac[i], (& (acl_mac_new[0][0]) + i * 13), 12);
			}

		}
	} else if (acl_mac_num == 0 || (!strcmp (accesspolicy0, "0"))) {
		if (!strcmp (accesspolicy0, "2")) { //acl_mac_num = 0 úmac
			for (i = 0; i < g_old_acl_black_mac_num; i++) {
				memset (g_old_acl_black_mac[i], 0, 13);
			}
			g_old_acl_black_mac_num = 0;
		} else if (!strcmp (accesspolicy0, "1")) { //acl_mac_num = 0 ðmac
			for (i = 0; i < g_old_acl_white_mac_num; i++) {
				memset (g_old_acl_white_mac[i], 0, 13);
			}
			g_old_acl_white_mac_num = 0;
		} else { //òЧ

		}
	} else {
		wf_log (" accesspolicy0 error!");
	}

	if (strcmp (accesspolicy0, "")) {
		strncpy (old_accesspolicy, accesspolicy0, 1);
	}
}

static void set_acl_mac_num (int acl_mac_num)
{
	char command_buf[100] = {0};

	sprintf (command_buf, "echo \"%d\" > %s/macac_num",  acl_mac_num, CONFIG_DIR);
	soft_system (command_buf);
}

static void reset_acl_num (char *athx)
{
	char cmd_buf[100] = {0};
	sprintf (cmd_buf, "/bin/iwpriv %s set_mib aclnum=0", athx);
	zxic_system(cmd_buf);
}

static void remove_all_connect_sta_from_acl_table (char* athx)
{
	char exist_mac[MAX_STA_NUM][13] = {0};
	int sta_num = 0;
	int i = 0;
	char command_buf[100] = {0};

	if (NULL == athx) {
		softap_assert ("[wlan]athx is null");
		return;
	}
	sta_num = wlan_get_mac_list (& (exist_mac[0][0]), athx);

	for (i = 0; i < sta_num; i++) {
		//kw 3
		memset (command_buf, 0, 100);
		sprintf (command_buf, "/bin/iwpriv %s del_acl_table %s", athx, exist_mac[i]);
		zxic_system(command_buf);
		wf_log ("[%s]:%s", athx, command_buf);
		perror (command_buf);
	
	}
}

//djj modified, g_old_acl_black_macg_old_acl_black_mac_num
static void remove_old_acl_black_mac (char* athx)
{
	char command_buf[100] = {0};
	int i = 0;
	if (NULL == athx) {
		softap_assert ("[wlan] athx is null");
		return;
	}
	for (i = 0; i < g_old_acl_black_mac_num; i++) {
		memset (command_buf, 0, 100);
		sprintf (command_buf, "/bin/iwpriv %s del_acl_table %s", athx, g_old_acl_black_mac[i]);
		zxic_system(command_buf);
	}
}


//djj modified, g_old_acl_white_macg_old_acl_white_mac_num
static void remove_old_acl_white_mac (char* athx)
{
	char command_buf[100] = {0};
	int i = 0;
	if (NULL == athx) {
		softap_assert ("athx is null");
		return;
	}
	for (i = 0; i < g_old_acl_white_mac_num; i++) {
		memset (command_buf, 0, 100);
		sprintf (command_buf, "/bin/iwpriv %s del_acl_table %s", athx, g_old_acl_white_mac[i]);
		zxic_system(command_buf);
		wf_log ("[%s]:%s",  athx, command_buf);
	}
}



static void remove_all_mac_from_acl_table_for_blacklist (char* athx)
{
	remove_old_acl_black_mac (athx);
	//remove_acl_timer_mac(athx);
}

static void remove_all_mac_from_acl_table_for_whitelist (char* athx)
{
	remove_all_connect_sta_from_acl_table (athx);
	remove_old_acl_white_mac (athx);
}

static void remove_all_mac_from_acl_table_for_nonlist (char* athx)
{
	char command_buf[100] = {0};
	char m_ssid_enable[2] = {0};
	int i = 0;
	if (NULL == athx) {
		softap_assert ("athx is null");
		return;
	}
#if 0
	if (!strcmp (old_accesspolicy, "2")) {
		wf_log ("<<<old_accesspolicy is 2>>> ");
		for (i = 0; i < g_old_acl_black_mac_num; i++) {
			memset (command_buf, 0, 100);
			sprintf (command_buf, "iwpriv %s del_acl_table %s", athx, g_old_acl_black_mac[i]);
			system (command_buf);
			//wf_log("remove_all_connect_sta_from_acl_table 2command_buf is %s", command_buf);
			wf_log ("remove_all_mac_from_acl_table_for_nonlist old blacklist del_acl_table,%s", g_old_acl_black_mac[i]);
			//perror(command_buf);
		}
	} else if (!strcmp (old_accesspolicy, "1")) {
		wf_log ("<<<old_accesspolicy is 1 >>> ");
		for (i = 0; i < g_old_acl_white_mac_num; i++) {
			memset (command_buf, 0, 100);
			sprintf (command_buf, "iwpriv %s del_acl_table %s", athx, g_old_acl_white_mac[i]);
			system (command_buf);
			//perror(command_buf);
			//wf_log("remove_all_connect_sta_from_acl_table 1command_buf is %s", command_buf);
			wf_log ("remove_all_mac_from_acl_table_for_nonlist old whitelist del_acl_table,%s", g_old_acl_white_mac[i]);
		}
	}
#else
	memset (command_buf, 0, sizeof (command_buf));
	sprintf (command_buf, "/bin/iwpriv %s clear_acl_table", athx);
	wf_log ("cmd= %s", command_buf);
	zxic_system(command_buf);
#endif
}

static void set_accesspolicy0 (char* accesspolicy0, char* athx)
{
	char command_buf[100] = {0};

	if (NULL == athx) {
		softap_assert ("athx is null");
		return;
	}

	if (NULL == accesspolicy0) {
		softap_assert ("accesspolicy0 is null");
		return;
	}
	memset (command_buf, 0, 100);
	//ʹļʽaclmodeʹiwprivʽֱ
#if 0
	if (!strcmp (accesspolicy0, "1")) { //white
		sprintf (command_buf, "echo \"1\" > %s/macac_enabled", CONFIG_DIR);
	} else if (!strcmp (accesspolicy0, "2")) { // black
		sprintf (command_buf, "echo \"2\" > %s/macac_enabled", CONFIG_DIR);
	} else if (!strcmp (accesspolicy0, "0")) {
		sprintf (command_buf, "echo \"0\" > %s/macac_enabled", CONFIG_DIR);
	}
	system (command_buf);
	memset (command_buf, 0, 100);
#endif
	sprintf (command_buf, "/bin/iwpriv %s set_mib aclmode=%s", athx, accesspolicy0);
	zxic_system(command_buf);
	wf_log ("set_acl_mode :%s", command_buf);
}

//Ҫʱ
static void set_acl_mode (char * athx)
{
	//char accesscontrollist0[720] = {0};
	char accesspolicy0[10] = {0};
	char cmd_buf[100] = {0};

	sc_cfg_get ("AccessPolicy0", accesspolicy0, sizeof (accesspolicy0));
	//sc_cfg_get("AccessControlList0",accesscontrollist0,sizeof(accesscontrollist0));

	if (strcmp (accesspolicy0, "")) {
		wf_log ("accesspolicy0 :%s,old_accesspolicy:%s",  accesspolicy0, old_accesspolicy);
		set_accesspolicy0 (accesspolicy0, athx);
		if (strcmp (accesspolicy0, "0") && strcmp (old_accesspolicy, "0") && strcmp (accesspolicy0, old_accesspolicy)) { //֮ǰõĲǲЧҵǰõҲ Ч   л
			wf_log ("remove_all_mac_from_acl_table_for_nonlist");
			//remove_all_mac_from_acl_table_for_nonlist(athx); // after reboot, the global value is NULL, so this func doesn't work
			memset (cmd_buf, 0, sizeof (cmd_buf)); //if acl mode swithed between black and white, clear acl table without doubt
			sprintf (cmd_buf, "/bin/iwpriv %s clear_acl_table", athx);
			zxic_system(cmd_buf);
			wf_log ("set_acl_mode %s", cmd_buf);
		}

	} else {
		wf_log ("accesspolicy0 error");
	}
}

static void add_mac_to_acl_table (char* acl_mac_ptr, char* athx, char* accesspolicy0, char* p_acl_mac_new, char* exist_flag, int index)
{
	char acl_mac[18] = {0};
	char command_buf[100] = {0};
	char acl_mac_out[13] = {0};
	int i = 0;

	if (NULL == acl_mac_ptr) {
		softap_assert ("add_mac_in_acl_table acl_mac_ptr is null");
		return;
	}
	if (NULL == accesspolicy0) {
		softap_assert ("add_mac_in_acl_table accesspolicy0 is null");
		return;
	}
	if (NULL == p_acl_mac_new) {
		softap_assert ("add_mac_in_acl_table acl_mac_new is null");
		return;
	}
	if (NULL == athx) {
		softap_assert ("add_mac_in_acl_table athx is null");
		return;
	}
	if (NULL == exist_flag) {
		softap_assert ("add_mac_in_acl_table exist_flag is null");
		return;
	}
	strncpy (acl_mac, acl_mac_ptr, 17);
	deleteCharFromStr (':', acl_mac, acl_mac_out);

	sprintf (command_buf, "/bin/iwpriv %s add_acl_table %s", athx, acl_mac_out);
	zxic_system(command_buf);
	perror (command_buf);

	if (!strcmp (accesspolicy0, "2")) {
		for (i = 0; i < g_old_acl_black_mac_num; i++) {
			if (!strcmp (g_old_acl_black_mac[i], acl_mac_out)) {//kw 3
				exist_flag[i] = 0x31;
			}
		}
	} else if (!strcmp (accesspolicy0, "1")) {
		for (i = 0; i < g_old_acl_white_mac_num; i++) {
			if (!strcmp (g_old_acl_white_mac[i], acl_mac_out)) {//kw 3
				exist_flag[i] = 0x31;
			}
		}
	}

	strncpy (p_acl_mac_new + index * 13, acl_mac_out, 12);
	wf_log ("[%s]add_mac_in_acl_table acl_mac_new+%d is %s", athx, index, (p_acl_mac_new + index * 13));
}

//djj modified,ȫֱg_old_acl_black_macg_old_acl_black_mac_num
static void del_not_exist_elment_from_old_acl_blacklist (char* exist_flag, char* p_acl_mac_new, int tmp_num, char* athx)
{
	int i = 0;
	char command_buf[100] = {0};
	char m_ssid_enable[8] = {0};
	if (NULL == p_acl_mac_new) {
		softap_assert (" acl_mac_new+index is null");
		return;
	}
	if (NULL == exist_flag) {
		softap_assert (" exist_flag is null");
		return;
	}
	if (NULL == athx) {
		softap_assert (" athx is null");
		return;
	}
	for (i = 0; i < g_old_acl_black_mac_num; i++) {
		if (exist_flag[i] != 0x31 && strcmp (g_old_acl_black_mac[i], "")) {
			memset (command_buf, 0, 100);
			sprintf (command_buf, "/bin/iwpriv %s  del_acl_table %s", athx, g_old_acl_black_mac[i]);
			zxic_system(command_buf);
			wf_log ("command_buf is %s", command_buf);
		}

	}

}

//djj modified,ȫֱg_old_acl_white_macg_old_acl_white_mac_num
static void del_not_exist_elment_from_old_acl_whitelist (char* exist_flag, char* p_acl_mac_new, int tmp_num, char* athx)
{
	int i = 0;
	char command_buf[100] = {0};

	if (NULL == p_acl_mac_new) {
		softap_assert (" acl_mac_new+index is null");
		return;
	}
	if (NULL == exist_flag) {
		softap_assert (" exist_flag is null");
		return;
	}
	if (NULL == athx) {
		softap_assert (" athx is null");
		return;
	}

	for (i = 0; i < g_old_acl_white_mac_num; i++) {
		if (exist_flag[i] != 0x31) {
			memset (command_buf, 0, 100);
			sprintf (command_buf, "/bin/iwpriv %s del_acl_table %s", athx, g_old_acl_white_mac[i]);
			zxic_system(command_buf);
			wf_log ("del_not_exist_elment_from_old_acl_whitelist command_buf is %s", command_buf);
		}
	}

}

static void del_connect_sta_for_set_whitelist (int tmp_num, char* athx, char* p_acl_mac_new)
{
	char exist_mac[MAX_STA_NUM][13] = {0};
	int sta_num = 0;
	int i, j = 0;
	int exist_mac_flag[MAX_STA_NUM] = {0};
	char command_buf[100] = {0};

	if (NULL == athx) {
		softap_assert (" athx is null");
		return;
	}
	if (NULL == p_acl_mac_new) {
		softap_assert (" acl_mac_new is null");
		return;
	}
	sta_num = wlan_get_mac_list (& (exist_mac[0][0]), athx);

	for (i = 0; i < sta_num; i++) {
		for (j = 0; j < tmp_num; j++) {
			if (!strcasecmp (exist_mac[i], (p_acl_mac_new + j * 13))) {//kw 3
				exist_mac_flag[i] = 1;
			}
		}
		if (!exist_mac_flag[i]) {
			memset (command_buf, 0, 100);
			sprintf (command_buf, "/bin/iwpriv %s del_acl_table %s", athx, exist_mac[i]);
			zxic_system(command_buf);
			perror (command_buf);
			wf_log ("[%s]:%s", athx, exist_mac[i]);
		}
	}
}

//djj modified, ȥold_accesspolicy
void acl_set_mac (char *athx)
{
	char accesscontrollist0[720] = {0};
	char accesspolicy0[10] = {0};

	char *acl_mac_ptr = NULL;
	char *acl_mac_ptr_find = NULL;
	int acl_mac_num = 0;
	int acl_cn =  0;

	char exist_flag[MAX_STA_NUM] = {0};
	char acl_mac_new[MAX_STA_NUM][13] = {0};

	int tmp_num = 0;

	sc_cfg_get ("AccessPolicy0", accesspolicy0, sizeof (accesspolicy0));
	sc_cfg_get ("AccessControlList0", accesscontrollist0, sizeof (accesscontrollist0));

	acl_mac_ptr_find = accesscontrollist0;
	acl_mac_num = find_substr_num (acl_mac_ptr_find, ';');
	wf_log ("%s accesspolicy0 =%s,  accesscontrollist0=%s", athx, accesspolicy0,  accesscontrollist0);
	wf_log ("g_old_acl_black_mac_num =%d,  g_old_acl_white_mac_num=%d", g_old_acl_black_mac_num, g_old_acl_white_mac_num);

	tmp_num = acl_mac_num;

	set_acl_mode (athx); //acl mode
	reset_acl_num (athx); //acl num

	if (acl_mac_num >= 1 && (strcmp (accesspolicy0, "") && strcmp (accesspolicy0, "0"))) {
		acl_mac_num--;
		acl_mac_ptr = accesscontrollist0;
		add_mac_to_acl_table (acl_mac_ptr, athx, accesspolicy0, & (acl_mac_new[0][0]), exist_flag, 0);
		for (acl_cn = 0; acl_cn < acl_mac_num; acl_cn++) {
			if ( (acl_mac_ptr = strstr (acl_mac_ptr, ";")) != NULL) {
				acl_mac_ptr = acl_mac_ptr + 1;
				add_mac_to_acl_table (acl_mac_ptr, athx, accesspolicy0, & (acl_mac_new[0][0]), exist_flag, acl_cn + 1);
			} else {//klocwork
				break;
			}
		}
		if (!strcmp (accesspolicy0, "2")) {
			del_not_exist_elment_from_old_acl_blacklist (exist_flag, & (acl_mac_new[0][0]), tmp_num, athx);
			//del_not_exist_elment_from_old_acl_timer_blacklist(athx);
		} else if (!strcmp (accesspolicy0, "1")) {
			del_not_exist_elment_from_old_acl_whitelist (exist_flag, & (acl_mac_new[0][0]), tmp_num, athx);
			del_connect_sta_for_set_whitelist (tmp_num, athx, & (acl_mac_new[0][0]));
		}
	} else if (acl_mac_num == 0 || (!strcmp (accesspolicy0, "0"))) {
		if (!strcmp (accesspolicy0, "2")) { //acl_mac_num = 0 úmac
			wf_log ("accesspolicy0 is 2, but acl mac num is 0");
			remove_all_mac_from_acl_table_for_blacklist (athx);
		} else if (!strcmp (accesspolicy0, "1")) { //acl_mac_num = 0 ðmac
			wf_log ("accesspolicy0 is 1, but acl mac num is 0");
			remove_all_mac_from_acl_table_for_whitelist (athx);
		} else { //òЧ
			wf_log ("accesspolicy0 is 0");
			remove_all_mac_from_acl_table_for_nonlist (athx);
		}
	} else {
		wf_log ("accesspolicy0 is error");
	}
}

void open_wifi_nv_set()
{
	sc_cfg_set ("wifiSleep", "0");
	sc_cfg_set ("wifiEnabled", "1");
	sc_cfg_set ("wifi_cur_state", WIFI_OPENED);
}

void close_wifi_nv_set()
{
	sc_cfg_set ("wifi_cur_state", WIFI_CLOSED);
	sc_cfg_set ("wifiEnabled", "0");
}

void confirm_close_vxd()
{

	int ret = -1;
retry:
	ret = wfsystem ("ifconfig wlan0-vxd |grep UP");

	if (ret == 0) {
		system ("ifconfig wlan0-vxd down");
		sleep (1);
		goto  retry;
	}

}

static const char* to_string (int wifi_cmd)
{
	switch (wifi_cmd) {
		CASE_RETURN_STR (WIFI_CFG_OPEN);           //wifi
		CASE_RETURN_STR (WIFI_CFG_CLOSE);              //رwifi
		CASE_RETURN_STR (WIFI_CFG_OPEN_MSSID);        //򿪸ssid
		CASE_RETURN_STR (WIFI_CFG_CLOSE_MSSID);               //رոssid
		CASE_RETURN_STR (WIFI_CFG_OPEN_VA0_VA1);   //ssid
		CASE_RETURN_STR (WIFI_CFG_RF);    			//Ƶ
		CASE_RETURN_STR (WIFI_CFG_AP);          //AP
		CASE_RETURN_STR (WIFI_CFG_MSSID);                //øssid
		CASE_RETURN_STR (WIFI_CFG_RESTART_APSTATION);   //ap station
		CASE_RETURN_STR (WIFI_CFG_RESTART_AP);  //ap
		CASE_RETURN_STR (WIFI_CFG_CLOSESTA_OPENMSSID);  //رstation򿪸ssid
		CASE_RETURN_STR (WIFI_CFG_FORCE_RESTART);   //ǿwifi
		CASE_RETURN_STR (WIFI_CFG_SLEEP);   //˯
	}
	return "UNKNOWN cmd";
}

void  clear_sta_count_nv()
{
	ap_server->g_sta_num = 0;
	sc_cfg_set ("sta_count", "0");
	sc_cfg_set ("m_sta_count", "0");
}

int wlan_system(const char * str1, const char * str2)
{

	pid_t ret  =  0 ;
	int len = 0;
	char *buf = NULL;

	if(str1 == NULL || str2 == NULL){
		softap_assert("wlan_system para is NULL");
		return -1; //klocwork
	}

	len = strlen(str1) + strlen(str2) + 8;

	buf = (char *)safe_malloc(len, 0);
	if(NULL == buf){
		wf_err("can not malloc memory len = %d", len);
		return -1;
	}
	
	sprintf(buf, "%s %s", str1, str2);
	ret = zxic_system(buf);
	wf_log ("[%s], ret = %d", buf, ret);
#if 0 //kw 3
	wf_log ("[%s]ret = %d, WIFEXITED(ret)=%d, WEXITSTATUS(ret) =%d",str2, ret , WIFEXITED (ret), WEXITSTATUS (ret));
	if (! (-1 != ret && WIFEXITED (ret) && 0 == WEXITSTATUS (ret))) {
		safe_free(buf);
		return -1;
	}
#endif
	wf_log ("[%s]ret = %d",str2, ret);
	if (ret != 0) { // include WEXITSTATUS
		safe_free(buf);
		return -1;
	}

	safe_free(buf);
	return ret;
}


/*
	just below case

	va0:va1
	0	0
	1	0
	1	1

*/
void wlan_set_state(int va0_state, int va1_state)
{
	if(va0_state == WLAN_OFF){
		if(0 == ap_server->ap0_state)return;
		close_wifi_nv_set();
		write_status (WIFISTATUS, WIFI_CLOSED);
		ap_server->ap0_state = 0;
		ap_server->ap1_state = 0;
	}
	else if(va0_state == WLAN_ON){
		open_wifi_nv_set();
		write_status (WIFISTATUS, WIFI_OPENED);
		ap_server->ap0_state = va0_state;
		ap_server->ap1_state = va1_state;
	}
}


void wlan_basic_close(char *wifi_sta_connection, char* m_ssid_enable)
{
	clear_sta_count_nv();
#ifdef  __STA_FUNC__
	if (strcmp (wifi_sta_connection, "1") == 0) {
		wifi_station_close();
	}
#endif	
	stop_va0();
	if (1 == atoi (m_ssid_enable))
		stop_va1();
	if (1 == atoi (wifi_sta_connection))
		stop_vxd();
	stop_wlan0();
	wlan_set_state(WLAN_OFF,WLAN_OFF);

}

void wlan_basic_open_va0_apsta(char *wifi_sta_connection)
{

	if (wlan_system(WLAN_DEAL, "open_va0") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
	#ifdef USE_CAP_SUPPORT
		send_ap_status_to_cap(IN_WIFI_AP_INDEX_AP0, IN_WIFI_AP_STATUS_ERROR);
	#endif
		return;
	}

	wlan_set_state(WLAN_ON,WLAN_OFF);
#ifdef USE_CAP_SUPPORT
	send_ap_status_to_cap(IN_WIFI_AP_INDEX_AP0, IN_WIFI_AP_STATUS_ENABLED);
#endif

#ifdef  __STA_FUNC__
	if (strcmp (wifi_sta_connection, "1") == 0) {
		wlan_set_vxd_on();
		wlan_station_init();
	}
#endif
}

void wlan_basic_open_va0_va1()
{

	wlan_set_va1_on();

	if (wlan_system(WLAN_DEAL,"open_va0_va1") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
	#ifdef USE_CAP_SUPPORT
		send_ap_status_to_cap(IN_WIFI_AP_INDEX_AP0, IN_WIFI_AP_STATUS_ERROR);
	#endif
		return;
	}

	wlan_set_state(WLAN_ON,WLAN_ON);
#ifdef USE_CAP_SUPPORT
	send_ap_status_to_cap(IN_WIFI_AP_INDEX_AP0, IN_WIFI_AP_STATUS_ENABLED);
#endif

// ֻҪøSSIDĺڰ --- TODO: siidĺڰӦ÷ֿŻ
	acl_set_mac ("wlan0-va1");
}

/*
webuimssid apstaڹر״̬
漰лҪȹرva0
*/
void wlan_basic_open_va1()
{

	clear_sta_count_nv();

	wlan_set_va1_on();

	if (wlan_system(WLAN_DEAL, "open_va1") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}
	wlan_set_state(WLAN_ON,WLAN_ON);

	acl_set_mac ("wlan0-va1");

}
/*
//open-mssid   webuimssid apstaڹر״̬
//漰лҪȹرva0
*/
void wlan_basic_close_va1()
{
	clear_sta_count_nv();

	wlan_set_va1_off();
	if (wlan_system(WLAN_DEAL, "close_va1") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}

	wlan_set_state(WLAN_ON,WLAN_OFF);

}
/*
 رmultissid,Ҫݲ
 webui  ڵapmssidģʽ¿apsta
*/
void wlan_basic_restart_apsta()
{

	write_status (WIFISTATUS, WIFI_CLOSED);
	wlan_set_vxd_on();
// mssid пǿ״̬Ҳǹر״̬Ҫȷǹر
	if (ap_server->ap1_state == 1) {
		clear_sta_count_nv();

		wlan_set_va1_off();
		if (wlan_system(WLAN_DEAL, "close_va1") < 0) {
			wlan_set_state(WLAN_OFF,WLAN_OFF);
			return;
		}
	}
	wlan_set_state(WLAN_ON, WLAN_OFF);
#ifdef  __STA_FUNC__
	wlan_station_init();
#endif
// Ϣwlan-station棬˴ٷ
}

/*
 sta ԷAP channelAP channelܵ1~4 channelڹرstaҪ
 AP channel ѡ񣬱ܿ1~4 channel

*/
void wlan_trigger_autoch()
{
	char  wifi_lte_intr[8] = {0};
	sc_cfg_get ("wifi_lte_intr", wifi_lte_intr, sizeof (wifi_lte_intr));

	if (strcmp (wifi_lte_intr, "1") == 0) {
		wf_log ("wifi_lte_intr:::iwpriv wlan0  autoch");
		system ("iwpriv wlan0  autoch");
	} else {
		wf_log ("wifi_lte_intr= 0");
	}
}

/*

closesta-openmssid webuimssid apstaڿ״̬
wlan-station ѹرstation

*/
void wlan_basic_closesta_openmssid()
{
	clear_sta_count_nv();
	write_status (WIFISTATUS, "0");//??
	
	wlan_set_vxd_off();
	wlan_set_va1_on();
	if (wlan_system(WLAN_DEAL, "close_sta_open_va1") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}

	confirm_close_vxd();
	wlan_set_state(WLAN_ON,WLAN_ON);
	acl_set_mac ("wlan0-va1");

	wlan_trigger_autoch();

}

/*
restart-ap  webuiرapstaָAPģʽ
*/
void wlan_basic_restart_ap()
{

	wlan_set_vxd_off();
	system ("ifconfig wlan0-vxd down");
	
	wlan_trigger_autoch();
}


/*øSSID ʱapsta϶ڹر״̬*/ 
void wlan_basic_cfg_va1()
{
	sc_cfg_set ("m_sta_count", "0");
	write_status (WIFISTATUS, "0");
	
	wlan_ap_para_set ("wlan0-va1");
#ifdef __AP_FUNC__
#ifdef __USE_AES__
	wifi_encrypt_code();
#endif
#endif

	if (wlan_system(PARASET, "wlan0-va1") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}

	wlan_set_state(WLAN_ON,WLAN_ON);
}

void wlan_basic_cfg_va0(char *m_ssid_enable)
{
	sc_cfg_set ("sta_count", "0");
	write_status (WIFISTATUS, "0");
	wlan_ap_para_set ("wlan0-va0");
#ifdef __AP_FUNC__
#ifdef __USE_AES__
	wifi_encrypt_code();
#endif
#endif	
	if (wlan_system(PARASET, "wlan0-va0") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}

	wlan_set_state(WLAN_ON,atoi(m_ssid_enable));
}

void wlan_basic_cfg_rf(char *wifi_sta_connection, char *m_ssid_enable)
{
	clear_sta_count_nv();
#ifdef  __STA_FUNC__
	if (strcmp (wifi_sta_connection, "1") == 0) {
		wifi_station_close();
	}
#endif
	write_status (WIFISTATUS, "0");
	wlan0_radio_para_set();
// para set script	close  wlan0 va0 va1 and vxd interface, so C code no this work
	if (wlan_system(PARASET, "wlan0") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}
	
	wlan_set_state(WLAN_ON, atoi(m_ssid_enable));
#ifdef  __STA_FUNC__
	if (strcmp (wifi_sta_connection, "1") == 0) {
		wlan_station_init();
	}
#endif
}

void wlan_basic_force_restart(char *wifi_sta_connection, char *m_ssid_enable)
{
	clear_sta_count_nv();

	write_status (WIFISTATUS, "0");
#ifdef  __STA_FUNC__	
	if (strcmp (wifi_sta_connection, "1") == 0) {
		wifi_station_close();
	}
#endif	
	stop_va0();
	if (1 == atoi (m_ssid_enable))
		stop_va1();
	if (1 == atoi (wifi_sta_connection))
		stop_vxd();
	stop_wlan0();
	wlan_init();
}

void wlan_single_ap_close()
{
	clear_sta_count_nv();
	stop_wlan0();
	wlan_set_state(WLAN_OFF,WLAN_OFF);
}
void wlan_single_ap_open()
{
	if (wlan_system("/sbin/ifconfig", "wlan0 up") < 0) { //kw 3
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}

	wlan_set_state(WLAN_ON,WLAN_OFF);
}

void wlan_single_ap_restart()
{
	clear_sta_count_nv();
	write_status (WIFISTATUS, "0");
	wlan_ap_para_set ("wlan0");
#ifdef __AP_FUNC__
#ifdef __USE_AES__
	wifi_encrypt_code();
#endif
#endif

	if (wlan_system(PARASET1, "wlan0") < 0) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
		return;
	}

	wlan_set_state(WLAN_ON,WLAN_OFF);
}
/**************************************************************************
* description of function:  wlan deal basic require
* input parameter: pstMsg:message content
* return value: 0:success -1:error
**************************************************************************/
#ifdef __SINGLE_AP__

void basic_deal (struct wlan_ap_server  *ap_svr, int cmd)
{
	wf_log ("cmd=%d(%s)", cmd, to_string(cmd));
	acl_mode_set();//set white-list or black-list or none to nv
	wps_off();

	switch (cmd) {
		case WIFI_CFG_CLOSE:
		case WIFI_CFG_SLEEP:
			wlan_single_ap_close();
			break;
		case WIFI_CFG_OPEN:
			wlan_single_ap_open();
			break;
		case WIFI_CFG_AP:
		case WIFI_CFG_RF:
		case WIFI_CFG_FORCE_RESTART:
			wlan_single_ap_restart();
			break;
		default:
			break;
	}
	wf_log ("cmd=%d(%s)", cmd, to_string(cmd));
}

#else

void basic_deal (struct wlan_ap_server  *ap_svr, int cmd)
{
	char wifi_sta_connection[8] = {0};
	char m_ssid_enable[8] = {0};

	wf_log ("cmd=%d(%s) start=%ld", cmd, to_string(cmd), time (NULL));
	sc_cfg_get ("wifi_sta_connection", wifi_sta_connection, sizeof (wifi_sta_connection));
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
	acl_mode_set();//set white-list or black-list or none to nv
	wps_off();
	wf_log ("wifi_sta_connection=%s,m_ssid_enable=%s,ap_svr->ap0_state=%d, ap_svr->ap1_state=%d", 
		wifi_sta_connection, m_ssid_enable, ap_svr->ap0_state, ap_svr->ap1_state, ap_svr->ap0_state, ap_svr->ap1_state);

	switch (cmd) {
	case WIFI_CFG_CLOSE:
	case WIFI_CFG_SLEEP:
		wlan_basic_close(wifi_sta_connection, m_ssid_enable);
		break;
	case WIFI_CFG_OPEN://open include open main ssid and apstation,	
		sc_cfg_set ("wifi_process_state", "processing");
		if(0 == g_wifi_inited)
			wlan_init();
		else
			wlan_basic_open_va0_apsta(wifi_sta_connection);
		sc_cfg_set ("wifi_process_state", "end");
		break;
	case WIFI_CFG_OPEN_VA0_VA1://open-mssid include open va0+va1	
		sc_cfg_set ("wifi_process_state", "processing");
		if(0 == g_wifi_inited)
			wlan_init();
		else
			wlan_basic_open_va0_va1();
		sc_cfg_set ("wifi_process_state", "end");
		break;
	case WIFI_CFG_OPEN_MSSID:
		wlan_basic_open_va1();
		break;
	case WIFI_CFG_CLOSE_MSSID:
		wlan_basic_close_va1();
		break;
	case WIFI_CFG_RESTART_APSTATION:
		wlan_basic_restart_apsta();
		break;
	case WIFI_CFG_CLOSESTA_OPENMSSID:
		wlan_basic_closesta_openmssid();
		break;
	case WIFI_CFG_RESTART_AP:
		wlan_basic_restart_ap();
		break;
	case WIFI_CFG_MSSID: 
		wlan_basic_cfg_va1();
		break;
	case WIFI_CFG_AP:
		wlan_basic_cfg_va0(m_ssid_enable);
		break;
	case WIFI_CFG_RF:
		wlan_basic_cfg_rf(wifi_sta_connection, m_ssid_enable);
		break;
	case WIFI_CFG_FORCE_RESTART:
		wlan_basic_force_restart(wifi_sta_connection, m_ssid_enable);
		break;
	default:
		break;
	}
	wf_log ("cmd=%d(%s) end=%ld", cmd, to_string(cmd), time (NULL));
}
#endif

//%02X:%02X:%02X:%02X:%02X:%02X
void handle_wps_mac (MSG_BUF *pstMsg)
{
	char wps_result[128] = {0};
	int len = 0;

	len = wlan_readfile (WSCD_LAST_SUCCESS_ENROLLEE, g_wps_sta_mac, sizeof(g_wps_sta_mac));
	if(len > 0){
		if(g_wps_sta_mac[len-1] == '\n')
			g_wps_sta_mac[len-1] = '\0';		
		wf_log ("g_wps_sta_mac = %s",  g_wps_sta_mac);
	}

	len = wlan_readfile (WSCD_CONFIG_STATUS, wps_result, sizeof(wps_result));
	if(len > 0){
		if(wps_result[len-1] == '\n')
			wps_result[len-1] = '\0';		
		wf_log ("wps_result = %s", wps_result);
	}

//PROTOCOL_SUCCESS=3
	if (strncmp (wps_result, "3",1) == 0) {
		strcpy ( (CHAR*) pstMsg->aucDataBuf, "0"); // Ϊ˼ݲͨм޸յmsg 
		pstMsg->usDataLen = strlen ("0") + 1;
	}
}
//cov m
static char wifi_toupper(char ch)
{
	if ((unsigned int)(ch - 'a') < 26u)
		ch += 'A' - 'a';
	return ch;
}

LONG get_wps_sta (char * iface)
{
	int i = 0;
	int ssid_index = 0;
	char authmode[20]			= {0};
	char buf[128]				= {0};
	char mac_tmp[18]            = {0};
	char *p = NULL;
	char *p_tmp = NULL;
	char  macaddr[32] = {0};
	char wps_addr[32] = {0};
	LONG wps_result = ERROR;

	FILE *p_maclist = NULL;

	wf_log (" iface = %s",  iface);

#ifdef __SINGLE_AP__
	if (!strcmp (iface, "wlan0"))
#else
	if (!strcmp (iface, "wlan0-va0"))
#endif
	{
		ssid_index = 1;
		sc_cfg_get ("AuthMode", authmode, sizeof (authmode));
	} else if (!strcmp (iface, "wlan0-va1")) {
		ssid_index = 2;
		sc_cfg_get ("m_AuthMode", authmode, sizeof (authmode));
	}

	memset (buf, 0, sizeof (buf));
	sprintf (buf, "cat /proc/%s/sta_info  | grep \"hwaddr\" > /tmp/wps_maclist", iface);
	soft_system (buf);

	p_maclist = fopen ("/tmp/wps_maclist", "r");
	if (NULL == p_maclist) {
		fprintf (stderr, "can not open file /tmp/wps_maclist.");
		goto END;
	}

	i = 0;
	memset (buf, 0, sizeof (buf));
	while (! (feof (p_maclist))) {
again:
		errno = 0;
		while (NULL != fgets (buf, sizeof (buf), p_maclist)) { //kw 3
			memset (mac_tmp, 0, 18);
			if ( (p = strstr (buf, ":")) != NULL) {
				p_tmp = p + 2;
				strncpy (mac_tmp, p_tmp, 12);
			/*
				sprintf (macaddr, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c", toupper (mac_tmp[0]), toupper (mac_tmp[1]) , toupper (mac_tmp[2]), toupper (mac_tmp[3]),
				         toupper (mac_tmp[4]), toupper (mac_tmp[5]), toupper (mac_tmp[6]), toupper (mac_tmp[7]),
				         toupper (mac_tmp[8]), toupper (mac_tmp[9]), toupper (mac_tmp[10]), toupper (mac_tmp[11]));
			*/
				sprintf (macaddr, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c", wifi_toupper (mac_tmp[0]), wifi_toupper (mac_tmp[1]) , wifi_toupper (mac_tmp[2]), wifi_toupper (mac_tmp[3]),
						wifi_toupper (mac_tmp[4]), wifi_toupper (mac_tmp[5]), wifi_toupper (mac_tmp[6]), wifi_toupper (mac_tmp[7]),
						wifi_toupper (mac_tmp[8]), wifi_toupper (mac_tmp[9]), wifi_toupper (mac_tmp[10]), wifi_toupper (mac_tmp[11]));

				wf_log ("g_wps_sta_mac=[%s], macaddr=%s",  g_wps_sta_mac, macaddr);
				if (strcmp (macaddr,  g_wps_sta_mac) == 0) {
					wps_result = OK;
					goto END;
				}
			}
			memset (buf, 0, sizeof (buf));
		}

		if(errno == EINTR){ //kw 3
			wf_log("fgets recv EINTR!");
			goto again;
		}
		
	}
END:
	if (NULL != p_maclist)
		fclose (p_maclist);
	return wps_result;
}

LONG wlan_get_wps_sta()
{
	int i = 0, j = 0;
	char wifi_wps_index[8] = {0};

	LONG ret = ERROR;

	sc_cfg_get ("wifi_wps_index", wifi_wps_index, sizeof (wifi_wps_index));

	if (strcmp (wifi_wps_index, "1") == 0) {
#ifdef __SINGLE_AP__
		ret = get_wps_sta ("wlan0");
#else
		ret = get_wps_sta ("wlan0-va0");
#endif
	} else if (strcmp (wifi_wps_index, "2") == 0) {
		ret = get_wps_sta ("wlan0-va1");
	}
	return ret;
}

static void wps_deal_invalid_para()
{
	wf_log ("wps_deal_invalid_para!");

	sc_cfg_set ("WscModeOption", "0");
	write_status (WPSSTATUS, "0");
	ap_server->ap0_wps_state = 0;
}

static int validate_pin_code (unsigned long code)
{
	unsigned long accum = 0;

	accum += 3 * ( (code / 10000000) % 10);
	accum += 1 * ( (code / 1000000) % 10);
	accum += 3 * ( (code / 100000) % 10);
	accum += 1 * ( (code / 10000) % 10);
	accum += 3 * ( (code / 1000) % 10);
	accum += 1 * ( (code / 100) % 10);
	accum += 3 * ( (code / 10) % 10);
	accum += 1 * ( (code / 1) % 10);

	return (0 == (accum % 10));
}

/**************************************************************************
* description of function:  wlan deal wps require
* input parameter: pstMsg:message content
* return value: 0:success -1:error
* zhaoyong set up this function
**************************************************************************/
void wps_deal (MSG_BUF *pstMsg)
{

	char wifi_wps_index[8] = {0};
	char wps_mode[8] = {0};
	char wps_pin[10] = {0};

	int wps_pin_len = 0;

	wf_log ("[realtek] wps deal start");

	sc_cfg_get ("wifi_wps_index", wifi_wps_index, sizeof (wifi_wps_index));
	sc_cfg_get ("wps_mode", wps_mode, sizeof (wps_mode));
	sc_cfg_get ("wps_pin", wps_pin, sizeof (wps_pin));

	wf_log (" wifi_wps_index=%s, wps_mode=%s,wps_pin=%s",  wifi_wps_index, wps_mode, wps_pin);

	if (!strcmp (wps_mode, "PBC")) { //pbc
		startPBCWPS();
	} else if ( (!strcmp (wps_mode, "PIN")) || (!strcmp (wps_mode, "APPIN"))) { //what is APPIN?

		wf_log ("[realtek] wps_pin=%s", wps_pin);

		wps_pin_len = strlen (wps_pin);
		int wps_pin_num = atoi(wps_pin);
		if(wps_pin_num<0 || wps_pin_num> INT_MAX-1)
		{
			wps_pin_num = 0;
		}
		if ( ( (wps_pin_len == 8) && (validate_pin_code (wps_pin_num))) || (wps_pin_len == 4)) {
			startPINWPS (wps_pin);
		} else {
			wps_deal_invalid_para();
		}
	} else {
		wps_deal_invalid_para();
	}
}

void wps_up()
{
	wf_log ("wps_up----");

	memset (g_wps_sta_mac, 0 , sizeof (g_wps_sta_mac));
	disable_rtc_wps_timer();
	write_status (WPSSTATUS, "1");
	ap_server->ap0_wps_state = 1;
}

static void wake_wps_unlock()
{
    write_lockfile("/sys/power/wake_unlock", "wps_lock");
}

void wps_down (MSG_BUF* pMsg)
{
	char wps_result[8] = {0};
	int result_int = -1;

	wf_log ("wps_down need to kill wscd ");

	while (!system ("ps -ef | grep \"bin/wscd\" | grep -v \"grep\"")) {
#ifdef __SINGLE_AP__
		system (WIFI_SCRIPT_DIR"/kill_wps1.sh");
#else
		system (WIFI_SCRIPT_DIR"/kill_wps.sh");
#endif
		usleep (100);
	}

	sc_cfg_set ("WscModeOption", "0");
	ap_server->ap0_wps_state = 0;

	if (pMsg != NULL) { //kw 3
		strncpy (wps_result, (CHAR*) pMsg->aucDataBuf, 1);
		result_int = atoi (wps_result);
	}

// wps failed (wps_result =1), wps success(wps_result = 0)
// handle wps result already write wpsstatus file, can not write again,  need to fix up
	if (result_int != 0)
		write_status (WPSSTATUS, "0");

	wake_wps_unlock();

	wf_log ("wps_down  end");
}

void wps_off()
{
	wf_log ("wps_off");
	
	if (ap_server->ap0_wps_state) {
		while (!system ("ps -ef | grep \"bin/wscd\" | grep -v \"grep\"")) {
#ifdef __SINGLE_AP__
			system (WIFI_SCRIPT_DIR"/kill_wps1.sh");
#else
			system (WIFI_SCRIPT_DIR"/kill_wps.sh");

#endif
			usleep (100);
		}
		//wake_wps_unlock();

		sc_cfg_set ("WscModeOption", "0");
		write_status (WPSSTATUS, "0");
		ap_server->ap0_wps_state = 0;

		memset (g_wps_sta_mac, 0 , sizeof (g_wps_sta_mac));
		disable_rtc_wps_timer();
		wf_log ("wps_off  done");
	} else {
		wf_log ("wps already be off");
	}
}

//wifi_hal.c of realtek, in order to capture sta num of va0 and va1(if multi ssid is enabled)
int captureWlanStaInfo()
{
	int staNum_va0 = 0;
	int staNum_va1 = 0;
	int staTotalNum = 0;
	char wifi_cur_state[8] = {0};
	char mutli_ssid_enable[8] = {0};
	char sta_count[12] = {0};
	char m_sta_count[12] = {0};
	int sta_count_from_nv = 0;

	sc_cfg_get ("wifi_cur_state", wifi_cur_state, sizeof (wifi_cur_state));
	sc_cfg_get ("m_ssid_enable", mutli_ssid_enable, sizeof (mutli_ssid_enable));

//	sc_cfg_get("sta_count",sta_count,sizeof(sta_count));

	if (!strncmp (wifi_cur_state, "0", 1)) {
		wf_log ("[Realtek]wifi is off, can't obtain sta info!!");
		return 0;
	}

	//staNum_va0 = get_vap_sta_num("wlan0-va0");
#ifdef __SINGLE_AP__
	staNum_va0 = get_vap_sta_num ("wlan0");
#else
	staNum_va0 = get_vap_sta_num ("wlan0-va0");
#endif
	sprintf (sta_count, "%d", staNum_va0);
	sc_cfg_set ("sta_count", sta_count);
	wf_log ("[Realtek] the Sta Num of Va0 = %d", staNum_va0);

	if (!strncmp (mutli_ssid_enable, "1", 1)) {
//	    sc_cfg_get("m_sta_count",m_sta_count,sizeof(m_sta_count));
		staNum_va1 = get_vap_sta_num ("wlan0-va1");
		sprintf (m_sta_count, "%d", staNum_va1);
		sc_cfg_set ("m_sta_count", m_sta_count);
		wf_log ("[Realtek] the Sta Num of Va1 = %d", staNum_va1);
	}
#if 1 // add for kw 3 SV.TAINTED.BINOP server
    if(staNum_va0 < 0 || staNum_va0 > INT_MAX-1)
    {
        staNum_va0 = 0;
    }

    if(staNum_va1 < 0 || staNum_va1 > INT_MAX-1)
    {
        staNum_va1  = 0;
    }
#endif
	ap_server->g_sta_num = staTotalNum = staNum_va0 + staNum_va1;
	wf_log ("[Realtek] staTotalNum = %d", staTotalNum);
	return staTotalNum;
}

// 1. adding wlan interface
// 2. no more use expire time as limiting condition
static int wlan_get_mac_list (char* station_mac, char* athx)
{
	char buf[128] = {0};
	char *p = NULL;
	char *p_tmp = NULL;
	char *p2 = NULL;
	char *p_tmp2 = NULL;
	int expiredtime_flag[35] = { -1};
	char expiredtime[4] = {0};
	RT_802_11_MAC_TABLE table;
	/*add by myc for wifi_client list 2012-04-20 begin*/
	FILE *fp2 = NULL;
	FILE *fp = NULL;
	FILE *fp5 = NULL;
	int i = 0;
	int index = 0;
	char cmd_buf[100] = {0};
	if (NULL == station_mac) {
		softap_assert("wlan_get_mac_list station_mac is null");
		return 0;
	}

	wf_log ("[wlan_get_mac_list] %s", athx);
	memset (&table, 0, sizeof (table));

	memset (cmd_buf, 0, 100);
	sprintf (cmd_buf, "cat /proc/%s/sta_info > /tmp/acl_stalist_%s", athx, athx);
	soft_system (cmd_buf);

	memset (cmd_buf, 0, 100);
	sprintf (cmd_buf, "/tmp/acl_stalist_%s", athx);

	fp = fopen (cmd_buf, "r");
	if (NULL == fp) {
		softap_assert("can not open file /tmp/acl_stalist_%s.", athx);
		return 0;
	}

	memset (cmd_buf, 0, 100);
	sprintf (cmd_buf, "cat /tmp/acl_stalist_%s | grep \"hwaddr\" > /tmp/acl_maclist_%s", athx, athx);
	soft_system (cmd_buf);

	memset (cmd_buf, 0, 100);
	sprintf (cmd_buf, "/tmp/acl_maclist_%s", athx);

	fp2 = fopen (cmd_buf, "r");
	if (NULL == fp2) {
		fprintf (stderr, "can not open file /tmp/acl_maclist_%s.", athx);
		fclose (fp); //kw 3
	
		return 0;
	}

	memset (cmd_buf, 0, 100);
	sprintf (cmd_buf, "cat /tmp/acl_stalist_%s | grep \"expired_time\" > /tmp/acl_expiredtime_%s", athx, athx);
	soft_system (cmd_buf);

	memset (cmd_buf, 0, 100);
	sprintf (cmd_buf, "/tmp/acl_expiredtime_%s", athx);

	fp5 = fopen (cmd_buf, "r");

	if (NULL == fp5) {
		fprintf (stderr, "can not open file /tmp/acl_expiredtime_%s", athx);
		//kw 3
		fclose (fp);
		fclose (fp2);
		return 0;
	}

	memset (buf, 0, sizeof (buf));
	i = 0;
	while (! (feof (fp5))) {
		while (fgets (buf, sizeof (buf), fp5)) {
			memset (expiredtime, 0, 4);
			if ( (p2 = strstr (buf, ":")) != NULL) {
				//p_tmp = p-2;
				p_tmp2 = p2 + 2;
				strncpy (expiredtime, p_tmp2, 3);
				//printf("zhouti expiredtime is %s, len is %d\n", expiredtime, strlen(expiredtime));
				if (atoi (expiredtime) > 0) { //kw 3
					expiredtime_flag[index] = i;
					wf_log ("[wlan_get_mac_list]  wlan_get_mac_list expiredtime_flag[%d] is %d", index, expiredtime_flag[index]);
					index++;
				}
				i++;
			}
			memset (buf, 0, sizeof (buf));
		}
	}
	//i = 0;
	//index = 0;
	memset (buf, 0, sizeof (buf));
	while (! (feof (fp2))) {
		while (fgets (buf, sizeof (buf), fp2)) {
			//printf("zhouti table.Num state_flag[%d]11 is %dsecurity_flag is %d \n ", table.Num,state_flag[table.Num],security_flag);
			if ( (p = strstr (buf, ":")) != NULL) {
				//if(expiredtime_flag[index] == i)
				//{
				p_tmp = p + 2;
				strncpy ( (station_mac + 13 * table.Num), p_tmp, 12);
				//(*(station_mac[table.Num]+12)) = '\0';
				wf_log ("[wlan_get_mac_list]  station_mac[%d] is %s", table.Num, (station_mac + 13 * table.Num));
				table.Num += 1;
				//index++;
				//}
				//i++;
			}
			memset (buf, 0, sizeof (buf));
		}
	}

	//kw 3
	fclose (fp2);
	fclose (fp);
	fclose (fp5);
	
	return table.Num;
}


void wlan_init (void)
{
	pid_t ret = 0;
	char wifi_sta_connection[8] = {0};
	char m_ssid_enable[8] = {0};

	if(0 == g_wifi_inited)
		g_wifi_inited = 1;

	wf_log ("wlan_init");

	sc_cfg_get ("wifi_sta_connection", wifi_sta_connection, sizeof (wifi_sta_connection));
	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));

	//1. nvòļ
	//  ۿúòֻҪdown upͿ
	wlan_set_param();

	//2.  űõоƬ
#ifdef  __SINGLE_AP__
	ret = system (INITSH1);
#else
	ret = system (INITSH);
#endif
	//arp_br0();
	//3. жǷ
	wf_log ("ret = %d, WIFEXITED(ret)=%d, WEXITSTATUS(ret) =%d", ret,  WIFEXITED (ret), WEXITSTATUS (ret));

	if (! (-1 != ret && WIFEXITED (ret) && 0 == WEXITSTATUS (ret))) {
		wlan_set_state(WLAN_OFF,WLAN_OFF);
	#ifdef USE_CAP_SUPPORT
		send_ap_status_to_cap(IN_WIFI_AP_INDEX_AP0, IN_WIFI_AP_STATUS_ERROR);
	#endif
		wf_log ("Open Error");
		return;
	}

	//4.ÿnvļ״̬ȫֱ
	wlan_set_state(WLAN_ON,atoi(m_ssid_enable));


	//5. úڰ
	acl_mode_set();

#ifdef __SINGLE_AP__
	acl_set_mac ("wlan0");
#else
	acl_set_mac ("wlan0-va0");
	if (strcmp (m_ssid_enable, "1") == 0) {     //va1  ֮Żva1acl
		acl_set_mac ("wlan0-va1");
	}
#ifdef  __STA_FUNC__
	//6. жǷapsta
	if (strcmp (wifi_sta_connection, "1") == 0) { // vxd ٽűwpa_supplicant 
		wlan_station_init();
	}
#endif
#endif

#ifdef USE_CAP_SUPPORT
	send_ap_status_to_cap(IN_WIFI_AP_INDEX_AP0, IN_WIFI_AP_STATUS_ENABLED);
#endif

	wf_log ("Open Success ");
}
void acl_set_process()
{
	char m_ssid_enable[8] = {0};

	sc_cfg_get ("m_ssid_enable", m_ssid_enable, sizeof (m_ssid_enable));
#ifdef __SINGLE_AP__
	acl_set_mac ("wlan0");
#else
	acl_set_mac ("wlan0-va0");
	if (strcmp (m_ssid_enable, "1") == 0) {
		acl_set_mac ("wlan0-va1");
	}
#endif
	renew_global_acl_table();
}


void wlan_get_wps_access_sta()
{
	wf_log (" g_get_access_sta_count =[%d], g_wps_sta_mac=[%s]", g_get_access_sta_count, g_wps_sta_mac);

	if (wlan_get_wps_sta() == OK) {
		wf_log ("wlan_get_wps_sta ok");
		write_status (WPSDISPLAYSTATUS, WPS_ACTIVED);
		write_status (WPSSTATUS, "2");
		g_get_access_sta_count = 0;
		return;
	}
	if (g_get_access_sta_count == ( (WPS_STATION_ACCESS_CHECK_ALL_PERIOD) / (WPS_STATION_ACCESS_CHECK_PERIOD))) {
		wf_log ("g_get_access_sta_count=[%d]",  g_get_access_sta_count);
		write_status (WPSSTATUS, "0");
		g_get_access_sta_count = 0;
		return;
	} else {
		if (-1  == create_rtc_wps_timer (WPS_STATION_ACCESS_CHECK_PERIOD)) {
			wf_log ("create wps sta check timer is fail  ");
			write_status (WPSSTATUS, "0");
			g_get_access_sta_count = 0;
		} else {
			wf_log ("recreate sta check timer,  g_get_access_sta_count=[%d]", g_get_access_sta_count);
			g_get_access_sta_count++;
		}
	}
}

void handle_wps_result (MSG_BUF *pstMsg)
{
	int result_int = 1;
	char result[2] = {0};

	wf_log ("g_wps_sta_mac is %s", g_wps_sta_mac);

	g_get_access_sta_count = 0;

	if (NULL == pstMsg) {
		wf_log ("pstMsg is NULL");
		return;
	}
	if (pstMsg->usDataLen > 0) {
		strncpy (result, (CHAR*) pstMsg->aucDataBuf, 1);
		result_int = atoi (result);
	} else {
		wf_log ("pstMsg buf is invalid");
	}

	if ( (result_int == 0) && (strcmp (g_wps_sta_mac, "") != 0)) {
		if (wlan_get_wps_sta() == OK) {
			write_status (WPSDISPLAYSTATUS, WPS_ACTIVED);
			write_status (WPSSTATUS, "2");
			wf_log (" wlan_get_wps_sta success  WPS_ACTIVED ");
		} else {
			wf_log ("wlan_handle_wps_success  need check sta");
			if (-1 == create_rtc_wps_timer (WPS_STATION_ACCESS_CHECK_PERIOD)) {
				wf_log ("create wps sta check timer is fail  ");
				write_status (WPSSTATUS, "0");
			}
		}
	} else {
		wf_log ("wlan_handle_wps_fail ");
		write_status (WPSSTATUS, "0");
	}
	return;
}

void wlan_ap_open ()
{
	wlan_init();
}

/*
qrStatus
staStatus
wifiStatus
wpsdisplayStatus
wpsStatus

this file will be created in rc file, and be inited before zte_mmi

*/
void  wlan_generate_para_file()
{
	// run dir
	ensure_config_dir_exist("/etc_rw/wifi/");
	ensure_config_dir_exist("/etc_rw/wifi/realtek/");
	ensure_config_dir_exist("/etc_rw/wifi/realtek/run");
	ensure_config_dir_exist("/etc_rw/wifi/realtek/rtl8192c");
	
	system("default_setting.sh wlan0");
	system("default_setting.sh wlan0-va0");
	system("default_setting.sh wlan0-va1");
	system("default_setting.sh wlan0-vxd");

}
