
/************************************************************************
* Ȩ (C)2015, ͨѶɷ޹˾
*
* ļƣ wlan_common.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ nxl
* ڣ 2015-09-18
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/
#ifdef __AP_FUNC__
#include <openssl/aes.h>
#endif
#include <ctype.h>

#include "wifi_util.h"
#include "rtk_arch.h"
#include "sys/wait.h"


/* 궨*/
#ifdef __AP_FUNC__
typedef struct
{
	unsigned int pubKeyRsaE[32];
	unsigned int pubKeyRsaN[32];
	unsigned int secureFlag;
	unsigned int pubKeyHash[4];
	unsigned int secureDevId[3];
}T_ZDrvEfuse_Secure;

#define EFUSE_IOC_MAGIC     'E'
#define EFUSE_GET_DATA			_IOWR(EFUSE_IOC_MAGIC, 1, char *)

unsigned char wifi_aes_key[16]={0};
#endif
static const unsigned char base64_table[65] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

/*  */


/**********************************************************************
	ļlog  start
*********************************************************************/

#if 0
#define	LOG_EMERG	0 /* system is unusable               */
#define	LOG_ALERT	1 /* action must be taken immediately */
#define	LOG_CRIT	2 /* critical conditions              */
#define	LOG_ERR		3 /* error conditions                 */
#define	LOG_WARNING	4 /* warning conditions               */
#define	LOG_NOTICE	5 /* normal but significant condition */
#define	LOG_INFO	6 /* informational                    */
#define	LOG_DEBUG	7 /* debug-level messages             */


#define WLAN_MAX_PRINT_LEN	  	256
#define WLAN_MAX_LOG_LENGTH 	524288
FILE* wifi_debug_file = NULL;
pthread_mutex_t   log_mutex;


int  wf_init_log_mutex()
{
	return pthread_mutex_init (&log_mutex, NULL);
}

void open_wifi_debug_file()
{
	wifi_debug_file = fopen (WLAN_LOG1_FILE_PATH, "a+");
	if (wifi_debug_file == NULL) {
		printf ("failed to fopen wifi debug file\n");
	}
}

void  close_wifi_debug_file()
{
	if (wifi_debug_file == NULL)
		return;
	fclose (wifi_debug_file);
	wifi_debug_file = NULL;
}


void wlog (const void *fmt, ...)
{
	va_list ap;
	time_t timep;
	struct tm timeRet = {0};//use localtime_r instead of localtime for safety concern , dujiajiao modified 20151223

	pthread_mutex_lock (&log_mutex);

	va_start (ap, fmt);

	time (&timep);
	localtime_r (&timep, &timeRet); //use localtime_r instead of localtime for safety concern, dujiajiao modified 20151223

	if (NULL != wifi_debug_file) {
		fprintf (wifi_debug_file, "[%02d %02d:%02d:%02d] ", timeRet.tm_mday, timeRet.tm_hour, timeRet.tm_min, timeRet.tm_sec);
		vfprintf (wifi_debug_file, fmt, ap);
		fflush (wifi_debug_file);
		if (ftell (wifi_debug_file) >= WLAN_MAX_LOG_LENGTH) {
			printf ("tmp/clog reach 512K, pid=%d\n", getpid());

			close_wifi_debug_file();
			remove (WLAN_LOG2_FILE_PATH);
			rename (WLAN_LOG1_FILE_PATH, WLAN_LOG2_FILE_PATH);
			open_wifi_debug_file();
		}

	}

	fprintf (stdout, "[%02d %02d:%02d:%02d] ", timeRet.tm_mday, timeRet.tm_hour, timeRet.tm_min, timeRet.tm_sec);
	vfprintf (stdout, fmt, ap);
	fflush (stdout);

	va_end (ap);

	pthread_mutex_unlock (&log_mutex);

}

/**********************************************************************
	ļlog   end
*********************************************************************/

#endif

#if 0//kw 3
/*
	ֽΪbig-endian, true
	֮Ϊlittle-endian, false

	С˿ھ ߸ߵ͵-->ֽڸߵַֽڵ͵ַ
	˿ھ ߵ͵͸->ֽڵ͵ַֽڸߵַ

*/

BOOL isbig_endian()
{
	unsigned short test = 0x1122;
	if (* ( (unsigned char*) &test) == 0x11)
		return TRUE;
	else
		return FALSE;


}
#endif




/*
 timeval ṹȻָһ΢뼶ķֱʣںֵ֧ķֱûôߣܶunixں˽ʱֵ10msı

 ⣬ں˵ʱ󣬼ʱʱ䵽ں˻ҪһʱӦ̵

 socketܵǷֱӷأ غûʱ-1tvֵΪʣֵ

 tvֵܵں˵޸

*/

/**********************************************************************
* Function:        milliseconds_sleep
* Description:     뼶ʱ
* Input:           mSec
* Output:   	   void
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/09/18    V1.0        nxl          	first version
**********************************************************************/
void wf_ms_sleep (unsigned long mSec)
{
	struct timeval tv;
	tv.tv_sec = mSec / 1000;
	tv.tv_usec = (mSec % 1000) * 1000;
	int err;
	do {
		err = select (0, NULL, NULL, NULL, &tv);
	} while (err < 0 && errno == EINTR);
}

/**********************************************************************
* Function:        get micro  second
* Description:     뼶ʱ
* Input:           mSec
* Output:   	   void
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/09/18    V1.0        nxl          	first version
**********************************************************************/

long  timeus()
{
	struct  timeval  tv;

	gettimeofday (&tv, NULL);

	return tv.tv_usec;
}


long  timens()
{
	struct timespec ts;

	clock_gettime (CLOCK_REALTIME, &ts);

	return  ts.tv_nsec;

}

/**********************************************************************
* Function:        wf_get_msg_qid
* Description:     ȡϢid
* Input:           ̵߳IDʶ
* Output:   	   ϢID
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/09/18    V1.0        nxl          	first version

msgget
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
ԭͣ int    msgget ( key_t  key , int  msgflg );
Ϣ

	msgget()ĵһϢжĹؼ(key)еϢ
	жĹؼֽбȽжϢжǷѾеľ	ɵڶmsgflg Ƶġȡļֵ
	IPC_CREAT Ϣж󲻴ڣ򴴽֮д򿪲;
	IPC_EXCLIPC_CREAT һʹãá|ӣϢ󲻴򴴽֮     һ󲢷ء
ֵ
	ɹʱضID,ʧܷ-1ԭerror
	EEXIST (Queue exists, cannot create)
	EIDRM (Queue is marked for deletion)
	ENOENT (Queue does not exist)
	ENOMEM (Not enough memory to create queue)
	ENOSPC (Maximum queue limit exceeded)

**********************************************************************/
int wf_get_msg_qid (int module_id)
{
	int msg_qid = -1;
	wf_log ("[wf_get_msg_qid] module_id = %d", module_id);
AGAIN:
	msg_qid = msgget (module_id, 0);

	if (msg_qid == -1) {
		wf_log ("fail,module_id=%d, errno=%d", module_id, errno);
		wf_ms_sleep (100);
		goto AGAIN;
	}

	return msg_qid;

}

/**********************************************************************
* Function:        wf_create_msg_id
* Description:     ϢID
* Input:           ̵߳IDʶ
* Output:   	   ϢID
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/09/18    V1.0        nxl          	first version
**********************************************************************/

int wf_create_msg_qid (int module_id)
{
	int msg_qid = -1;

AGAIN:
	msg_qid = msgget (module_id, IPC_CREAT | 0600);

	if (msg_qid == -1) {
		wf_log ("create msg fail,module_id=%d, errno=%d", module_id, errno);
		wf_ms_sleep (100);
		goto AGAIN;
	}

	return msg_qid;
}
int wf_msg_to_self(unsigned short msg_cmd, unsigned short datalen, unsigned char *pData)
{
	return platform_send_msg(MODULE_ID_WLAN_SERVER,MODULE_ID_WIFI, msg_cmd, datalen, pData);
}

int wf_msg_to_zcore(unsigned short msg_cmd, unsigned short datalen, unsigned char *pData)
{
#if (PRODUCT_TYPE == PRODUCT_PHONE)
	//return platform_send_msg(MODULE_ID_WIFI,MODULE_ID_ZCORE, msg_cmd, datalen, pData);
	return platform_send_msg(MODULE_ID_WIFI,MODULE_ID_MMI_SVR, msg_cmd, datalen, pData);
#endif
	return 0;
}

int wf_msg_to_mmi(unsigned short msg_cmd, unsigned short datalen, unsigned char *pData)
{
#if (PRODUCT_TYPE == PRODUCT_PHONE)
	if (ipc_send_message (MODULE_ID_WIFI, MODULE_ID_MMI_SVR, msg_cmd, datalen, pData, 0) != 0) {
		wf_log (" sta change  send msg to mmi failed");
	}
#else
	if (ipc_send_message (MODULE_ID_WIFI, MODULE_ID_MMI, msg_cmd, datalen, pData, 0) != 0) {
		wf_log (" sta change  send msg to mmi failed");
	}
#endif
	if (ipc_send_message (MODULE_ID_WIFI, MODULE_ID_WLAN_SERVER, msg_cmd, datalen, pData, 0) != 0) {
		//wf_log (" sta change  send msg to wifi_test failed");
	}
	return 0;
}

#if 0
int wf_sndmsg_to_rtc (int src_module, int cmd, ULONG ulSec, int magic_id)
{
	int ret = -1;
	int data_len = 0;
	RTC_DATA_BUF  buf = {0};

//    wf_log("buf.module=%d ,buf.magic_id= %d, buf.ulSec=%d \n", buf.module,buf.magic_id, buf.ulSec);


//    memset(&buf, 0, sizeof(RTC_DATA_BUF));


	buf.module = src_module;
	buf.ulSec = ulSec;
	buf.magic_id = magic_id;

	data_len = sizeof (RTC_DATA_BUF);

	wf_log ("buf.module=%d ,buf.magic_id= %d, buf.ulSec=%d, data_len=%d \n", buf.module, buf.magic_id, buf.ulSec, data_len);
#if 0
	wf_log ("buf.ucMac[0]=[0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x][0x%x] \n",
	        buf.ucMac[0], buf.ucMac[1], buf.ucMac[2], buf.ucMac[3], buf.ucMac[4],
	        buf.ucMac[5], buf.ucMac[6], buf.ucMac[7], buf.ucMac[8], buf.ucMac[9],
	        buf.ucMac[10], buf.ucMac[11], buf.ucMac[12], buf.ucMac[13], buf.ucMac[14], buf.ucMac[15]);
#endif

	ret =  wf_send_message (MODULE_ID_RTC_SERVICE, MODULE_ID_WIFI, cmd, data_len, (unsigned char *) &buf);

	return ret;
}
//#else



/**********************************************************************
* Function:        wf_sndmsg_to_rtc
* Description:    wifirtc  Ϣ
* Input:
* Output:
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2016/01/06    V1.0        djj         	first version
**********************************************************************/
int wf_sndmsg_to_rtc (int target_msg_id, int source_msg_id, int cmd, int ulInterval_sec, int magic_id)
{
	RTC_MSG_BUFF stMsg;
	int ret = -1;
	int tgt_msg_id = -1;
	unsigned int msgSize = sizeof (RTC_MSG_BUFF) - sizeof (long);

	memset (&stMsg, 0, sizeof (RTC_MSG_BUFF));

	stMsg.mtype = 1;
	stMsg.module = 1000;   //WIFI_MODULE_ID
	stMsg.msg_id = source_msg_id;
	stMsg.cmd = cmd;
	stMsg.param[0] = ulInterval_sec;
	stMsg.magic_id = magic_id;

	wf_log ("[wf_sndmsg_to_rtc]ulInterval_sec=%d,source_msg_id:%d,target_msg_id:%d\n", ulInterval_sec, source_msg_id, target_msg_id);

AGAIN:
	ret = msgsnd (target_msg_id, &stMsg, msgSize, 0);
	if (ret < 0) {
		if (errno == EINTR) {
			goto AGAIN;
		}

		wf_log ("[wf_sndmsg_to_rtc]send_message failed: msgsnd error code [%d,%d]!", ret, errno);
		return -1;
	}

	return 0;

}
#endif


/**********************************************************************
* Function:        wf_write_file
* Description:     ִдļ
* Input:           char* file
* Output:   	   char* status
* Return:
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2015/09/18    V1.0        nxl          	first version
**********************************************************************/


void write_status (char* file, const char* status)
{
#if 1
	int f, len = 0;

	f = open (file, O_RDWR);
	if (f == -1) {
		perror ("[wlan-server]open status file failed\n");
		return;
	}

	len = strlen (status);
	if (write (f, status, len) != len) {
		wf_log ("write failed");
	}
	close (f);

#else

	FILE *fp = fopen (file, "w+");

	if (fp == NULL) {
		fprintf (stderr, "open file %s failed\n", file);
		return;
	}

	fprintf (fp, "%s", status);
	fclose (fp);

#endif
}



void write_lockfile (char *filepath, char *setbuf)
{
	int f, len = 0;

	f = open (filepath, O_RDWR);
	if (f == -1) {
		perror ("open status file failed\n");
		return;
	}

	len = strlen (setbuf);
	if (write (f, setbuf, len) != len) {
		wf_log ("write failed");
	}
	close (f);
}

//ļдרú
void wlan_write_file (char* file_path, char* param)
{
	if (NULL == file_path) {
		wf_log ("file path is null!!");
		return;
	}

	FILE* fp = NULL;
	fp = fopen (file_path, "w+");
	if (NULL == fp) {
		wf_log ("open %s file error!!", file_path);
		return;
	}

	fprintf (fp, "%s", param);
	fclose (fp);

}


void* safe_malloc (int size, unsigned char is_assert)
{
	void *ret = malloc (size);

	if (ret == NULL) {
		if (is_assert == TRUE) {
			assert (ret);
		} else {
			printf ("xujian wifi station ----can not get memory");
		}
	} else {
		memset (ret, 0, size);
	}

	return ret;
}

//sizedestĳ
void safe_strcpy (char* dest, char* source, int size)
{
	if (dest == NULL || source == NULL || size < 1) {
		return;
	}

	strncpy (dest, source, size - 1);
	dest[size - 1] = '\0';

}


void  wf_create_thread (void *thread_name, void * (*thread_loop) (void*))
{
	int result = 0;
	pthread_t stHandle;

	pthread_attr_t attribute;
	pthread_attr_init (&attribute);
	pthread_attr_setstacksize (&attribute, 65536);
	pthread_attr_setdetachstate (&attribute, PTHREAD_CREATE_DETACHED);

	result = pthread_create (&stHandle, &attribute, thread_loop, thread_name);
	if (0 != result) {
		wf_log ("[%s]  create thread fail %d", (char*) thread_name, result);
	}
	pthread_attr_destroy(&attribute);
}

/*char to hex*/
char c2x (char c)
{
	if ( (c >= '0') && (c <= '9')) {
		return c - '0';
	}
	if ( (c >= 'a') && (c <= 'f')) {
		return (c - 'a') + 10;
	}
	if ( (c >= 'A') && (c <= 'F')) {
		return (c - 'A') + 10;
	}
	return 0;
}

/*string to hex*/
unsigned char s2x (char *s)
{
	int     i;
	char    str[3];
	unsigned char result;


	for (i = 0; i < 3; i++) {
		str[i] = *s++;
		if (str[i] == '\0') {
			break;
		}
	}

	result = 0;
	for (i = 0; i < 3; i++) {
		if (str[i] == '\0') {
			break;
		}
		result = (unsigned char) (c2x (str[i]) + (result << 4));
	}

	return result;
}

unsigned int deleteCharFromStr (char c, char* instr, char* outstr)
{
	unsigned int len = 0;
	unsigned int i , j = 0;
	//char cmd[20] = {0};
	if ( (NULL == instr) || (NULL == outstr)) {
		perror ("deleteCharFromStr return-------------");
		return 0;
	}

	len = 17;
	//perror(instr);
	for (i = 0, j = 0; i < len; i++) {
		//sprintf(cmd, "-------------instr[i] is %c, c is %c",instr[i], c);
		//perror(cmd);
		if (c != instr[i]) {
			outstr[j] = instr[i];
			j++;
		}
		//sprintf(cmd, "-------------outstr is %s,",outstr);
		//perror(cmd);
	}
	outstr[j] = '\0';
	//perror(outstr);
	return 1;
}


int wfsystem(const char * cmd)
{
	pid_t ret  =  0 ;
	ret = soft_system(cmd);
	wf_log ("[%s]ret = %d, WIFEXITED(ret)=%d, WEXITSTATUS(ret) =%d",cmd, ret , WIFEXITED (ret), WEXITSTATUS (ret));
	if (! (-1 != ret && WIFEXITED (ret) && 0 == WEXITSTATUS (ret))) {
		return -1;
	}
	return 0;
}

/*
    inputStr: if there is a $ \ ", then
    outputStr: add \ before, \$ \\ \"


*/
char* translateStringToEcho (char* inputStr, char* outputStr)
{
	int len = 0;
	int i, j = 0;
	if ( (NULL == inputStr) || (NULL == outputStr)) {
		return NULL;
	}

	len = strlen (inputStr);
	for (i = 0; i < len; i++) { //linux ת
		if ( (inputStr[i] == 0x22) || (inputStr[i] == 0x5c) || (inputStr[i] == 0x24)) {
			outputStr[j++]  = 0x5c;
		}
		outputStr[j++] = inputStr[i];
	}
	outputStr[j] = '\0';
	wf_log ("inputStr=%s,outputStr=%s\n", inputStr, outputStr);

	return outputStr;
}


int find_substr_num (char* str, char substr)
{
	int i = 1;

	if ( (*str == NULL) || (substr == '\0') || (!strcmp (str, ""))) {
		return 0;
	}

	while (*str != '\0') {
		if (str[0] == substr) {
			i++;
		}
		str++;
	}
	return i;
}

int find_substr_num_for_acl (char* str, char substr)
{
	int i = 0;

	if ( (*str == NULL) || (substr == '\0') || (!strcmp (str, ""))) {
		return 0;
	}

	while (*str != '\0') {
		if (str[0] == substr) {
			i++;
		}
		str++;
	}
	return i;
}

int wlan_readfile (const char *path, char * buf,  int  len)
{
	FILE  *fp = NULL;
	int cnt = -1;;

	if (NULL == path  || NULL == buf) return -1;

	if ( (fp = fopen (path, "rb")) == NULL) {
		wf_log ("%s can not be open\n", path);
		cnt = -1;
		goto err;
	}

	cnt = fread (buf, 1, len, fp);
	if (cnt < 0) {
		wf_log ("%s read failed \n", path);
		cnt = -1;
		goto err;
	}
err:	
	if (fp != NULL)
		fclose(fp);

	return cnt;

}


int  copyfile (const char *source, const char * target)
{

	FILE  *fp_s = NULL;
	FILE  *fp_t = NULL;
	char  buf[1024] = {0};
	int  lenR = 0;
	int  lenW = 0;

	if (NULL == source  || NULL == target) return -1;
	if ( (fp_s = fopen (source, "r")) == NULL) {
		printf ("[copyfile] %s can not be open\n", source);
		return -1;
	}

	if ( (fp_t = fopen (target, "w")) == NULL) {
		printf ("[copyfile] %s can not be open\n", target);
		fclose (fp_s);
		return -1;
	}

	while ( (lenR = fread (buf, 1, 1024, fp_s)) > 0) {
		if ( (lenW = fwrite (buf, 1, lenR, fp_t)) != lenR) {
			printf ("[copyfile] write to %s failed\n", target);
			fclose (fp_s);
			fclose (fp_t);
			return  -1;
		}
		memset (buf, 0, 1024);
	}

	fclose (fp_s);
	fclose (fp_t);
	return 0;

}
int ensure_config_dir_exist(char * dir)
 {
	 if(access(dir, F_OK) != 0){
		 if(mkdir(dir, 777) < 0 ){
			 wf_log("%s mkdir failed", dir);
			 return -1;
		 }
	 }
 
	 return 0;
 }
 
int ensure_file_exist(char * file)
{
	if(access(file, F_OK) != 0){
		int fd = creat(file, 777);
		if(fd < 0){
			wf_log("%s create  failed", file);
			return -1;
		}
		close(fd);
	}

	return 0;
}

int   get_file_size (char * file)
{
	int ret = 0;
	struct stat s;
	memset (&s, 0, sizeof (struct stat));
	ret = stat (file, &s);
	if (ret) {
		printf ("stat() failed, ret=%d(%s)", ret, strerror (errno));
		return 0;
	} else {
		return s.st_size;
	}
}

unsigned char *wlan_base64_decode(const unsigned char *src, int len, int *out_len)
{
	unsigned char dtable[256] = {0};//kw
	unsigned char *out = NULL;
	unsigned char *pos = NULL;
	unsigned char in[4] = {0};
	unsigned char block[4] = {0};
	unsigned char tmp = 0;
	int i = 0;
	int count = 0;
	int olen = 0;

	memset(dtable, 0x80, 256);
	for (i = 0; i < sizeof(base64_table) - 1; i++)
		dtable[base64_table[i]] = (unsigned char) i;
	dtable['='] = 0;

	count = 0;
	for (i = 0; i < len; i++) {
		if (dtable[src[i]] != 0x80)
			count++;
	}

	if (count == 0 || count % 4)
		return NULL;

	olen = count / 4 * 3;
	pos = out = malloc(olen);
	if (out == NULL)
		return NULL;
	memset(pos, 0, olen);

	count = 0;
	for (i = 0; i < len; i++) {
		tmp = dtable[src[i]];
		if (tmp == 0x80)
			continue;

		in[count] = src[i];
		block[count] = tmp;
		count++;
		if (count == 4) {
			*pos++ = (block[0] << 2) | (block[1] >> 4);
			*pos++ = (block[1] << 4) | (block[2] >> 2);
			*pos++ = (block[2] << 6) | block[3];
			count = 0;
		}
	}

	if (pos > out) {
		if (in[2] == '=')
			pos -= 2;
		else if (in[3] == '=')
			pos--;
	}

	*out_len = pos - out;
	return out;
}

int wifi_string2bytes(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    int i=0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i = 0; i < nSrcLength; i += 2)
    {
        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst = (*pSrc - '0') << 4;
        }
        else
        {
            *pDst = ((toupper(*pSrc) - 'A') + 10) << 4;
        }

        pSrc++;

        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst |= *pSrc - '0';
        }
        else
        {
            *pDst |= (toupper(*pSrc) - 'A') + 10;
        }

        pSrc++;
        pDst++;
    }

    // Ŀݳ
    return nSrcLength / 2;
}

int wifi_bytes2string(const unsigned char* pSrc, char* pDst, int nSrcLength)
{
    const char tab[]="0123456789ABCDEF";	// 0x0-0xfַұ
    int i = 0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i=0; i<nSrcLength; i++)
    {
        *pDst++ = tab[*pSrc >> 4];		// 4λ
        *pDst++ = tab[*pSrc & 0x0f];	// 4λ
        pSrc++;
    }

    // Ŀַ
    return nSrcLength * 2;
}

#ifdef __AP_FUNC__
//bsim
static int bs_aes_init_key(unsigned char *aes_key, int k_len)
{
	int efuse_fd = -1;
	T_ZDrvEfuse_Secure efuse = {0};
	
	memset(&efuse, 0, sizeof(efuse));
	efuse_fd = open("/dev/efuse", O_RDWR);
	if (efuse_fd < 0) {
		printf("wifi_aes_init_key efuse open errno=%d\n", errno);
		return 0;
	}
	if(ioctl(efuse_fd , EFUSE_GET_DATA, &efuse) != 0) {
		printf("wifi_aes_init_key efuse ioctl errno=%d\n", errno);
		close(efuse_fd);
		return 0;
	}
	close(efuse_fd);
	memcpy(aes_key, efuse.pubKeyHash, k_len);
	
	return 1;
}

static int bs_aes_encrypt(char* in, int len, char* out, unsigned char* key, int key_len)
{
    if (!in || !out || !key || len <=0 || (len%AES_BLOCK_SIZE)!=0 || (key_len!=16 && key_len!=24 && key_len!=32)) {
		printf("bs_aes_encrypt err in=%p out=%p key=%p len=%d key_len=%d\n",in,key,out,len,key_len);
        return 0;
    }
 
    AES_KEY aes = {0}; //cov h
    if (AES_set_encrypt_key(key, key_len*8, &aes) < 0) {
		printf("bs_aes_encrypt AES_set_encrypt_key err\n");
        return 0;
    }
 
    int en_len = 0;
    while (en_len < len) {
        AES_encrypt((unsigned char*)in, (unsigned char*)out, &aes);
        in	+= AES_BLOCK_SIZE;
        out += AES_BLOCK_SIZE;
        en_len += AES_BLOCK_SIZE;
    }
 
    return 1;
}

static int bs_aes_decrypt(char* in, int len, char* out, char* key, int key_len)
{
    if (!in || !out || !key || len <=0 || (len%AES_BLOCK_SIZE)!=0 || (key_len!=16 && key_len!=24 && key_len!=32)) {
		printf("bs_aes_decrypt err in=%p out=%p key=%p len=%d key_len=%d\n",in,key,out,len,key_len);
        return 0;
    }
 
    AES_KEY aes = {0}; //cov h
    if (AES_set_decrypt_key((unsigned char*)key, key_len*8, &aes) < 0) {
		printf("bs_aes_decrypt AES_set_decrypt_key err\n");
        return 0;
    }
 
    int en_len = 0;
    while (en_len < len) {
        AES_decrypt((unsigned char*)in, (unsigned char*)out, &aes);
        in	+= AES_BLOCK_SIZE;
        out += AES_BLOCK_SIZE;
        en_len += AES_BLOCK_SIZE;
    }
 
    return 1;
}

int wifi_aes_init_key(void)
{
	bs_aes_init_key(wifi_aes_key, sizeof(wifi_aes_key));

	return 1;
}

int wifi_encrypt_code(void)
{
	char w_code[WIFI_PSW_MAN_LEN + 1]= {0};
	char b_aes[WIFI_PSW_MAN_LEN + 1] = {0};
	char s_aes[WIFI_PSW_MAN_LEN*2 + 1] = {0};

	sc_cfg_get("WPAPSK1", w_code, sizeof(w_code));
	bs_aes_encrypt(w_code, WIFI_PSW_MAN_LEN, b_aes, wifi_aes_key, sizeof(wifi_aes_key));
	wifi_bytes2string(b_aes, s_aes, WIFI_PSW_MAN_LEN);
	sc_cfg_set("WPAPSK1_aes", s_aes);
	printf("encrypt psk1\n");

	memset(w_code, 0, sizeof(w_code));
	memset(b_aes, 0, sizeof(b_aes));
	memset(s_aes, 0, sizeof(s_aes));
	sc_cfg_get("m_WPAPSK1", w_code, sizeof(w_code));
	bs_aes_encrypt(w_code, WIFI_PSW_MAN_LEN, b_aes, wifi_aes_key, sizeof(wifi_aes_key));
	wifi_bytes2string(b_aes, s_aes, WIFI_PSW_MAN_LEN);
	sc_cfg_set("m_WPAPSK1_aes", s_aes);
	printf("encrypt psk2\n");

	return 1;
}

static int wifi_decode_b64_psk1(void)
{
	unsigned char *p_code = NULL;
	int p_code_len = 0;
	char b_code[WLAN_ENCODE_PSK_LEN] = {0};
	sc_cfg_get("WPAPSK1_encode", b_code, sizeof(b_code));
	p_code = wlan_base64_decode(b_code, strlen(b_code), &p_code_len);
	if (p_code == NULL) {
		printf("decrypt psk1 no memory\n");
		return 0;
	}
	sc_cfg_set("WPAPSK1", (char *)p_code);
	printf("decrypt psk1\n");
	free(p_code);

	return 1;
}

static int wifi_decode_b64_psk2(void)
{
	unsigned char *p_code = NULL;
	int p_code_len = 0;
	char b_code[WLAN_ENCODE_PSK_LEN] = {0};
	sc_cfg_get("m_WPAPSK1_encode", b_code, sizeof(b_code));
	p_code = wlan_base64_decode(b_code, strlen(b_code), &p_code_len);
	if (p_code == NULL) {
		printf("decrypt psk2 no memory\n");
		return 0;
	}
	sc_cfg_set("m_WPAPSK1", (char *)p_code);
	printf("decrypt psk2\n");
	free(p_code);

	return 1;
}

//ָnv, wepwebui֧֣δ
int wifi_decrypt_code(void)
{
	char w_code[WIFI_PSW_MAN_LEN + 1]= {0};
	char b_aes[WIFI_PSW_MAN_LEN + 1] = {0};
	char s_aes[WIFI_PSW_MAN_LEN*2 + 1] = {0};
	int flag = 0;

	sc_cfg_get("WPAPSK1_aes", s_aes, sizeof(s_aes));
	if (strlen(s_aes) > 0) {
		wifi_string2bytes(s_aes, b_aes, WIFI_PSW_MAN_LEN*2);
		bs_aes_decrypt(b_aes, WIFI_PSW_MAN_LEN, w_code, wifi_aes_key, sizeof(wifi_aes_key));
		sc_cfg_set("WPAPSK1", w_code);
		printf("dec1\n");
	} else {
		if (wifi_decode_b64_psk1()) {
			flag = 1;
		} else {
			return 0;
		}
	}
	
	memset(w_code, 0, sizeof(w_code));
	memset(b_aes, 0, sizeof(b_aes));
	memset(s_aes, 0, sizeof(s_aes));
	sc_cfg_get("m_WPAPSK1_aes", s_aes, sizeof(s_aes));
	if (strlen(s_aes) > 0) {
		wifi_string2bytes(s_aes, b_aes, WIFI_PSW_MAN_LEN*2);
		bs_aes_decrypt(b_aes, WIFI_PSW_MAN_LEN, w_code, wifi_aes_key, sizeof(wifi_aes_key));
		sc_cfg_set("m_WPAPSK1", w_code);
		printf("dec2\n");
	} else {
		if (wifi_decode_b64_psk2()) {
			flag = 1;
		} else {
			return 0;
		}
	}

	if (flag)
		return 2;
	return 1;
}

int wifi_decode_b2s(void)
{
	if (!wifi_decode_b64_psk1()) {
		return 0;
	}
	
	if (!wifi_decode_b64_psk2()) {
		return 0;
	}

	return 1;
}

#endif

