#include "hotplug.h"
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/if_arp.h>
#include "libcpnv.h"
#include "RONvParam_AMT.h"


/*
ĿǰRJ45ȰβϢʽ

[sw0 wan]
gmackobj: /gmac/gmacconfig
action:KOBJ_ADD
envp_ext:GMACEVENT = gmac_sw0_wan


add@/gmac/gmacconfig
ACTION=add
DEVPATH=/gmac/gmacconfig
SUBSYSTEM=gmac
GMACEVENT = gmac_sw0_wan



gmackobj: /gmac/gmacconfig
action:KOBJ_REMOVE
envp_ext:GMACEVENT = gmac_sw0_wan

remove@/gmac/gmacconfig
ACTION=remove
DEVPATH=/gmac/gmacconfig
SUBSYSTEM=gmac
GMACEVENT = gmac_sw0_wan


[sw0 lan]
gmackobj: /gmac/gmacconfig
action:KOBJ_ADD
envp_ext:GMACEVENT = gmac_sw0_lan

add@/gmac/gmacconfig
ACTION=add
DEVPATH=/gmac/gmacconfig
SUBSYSTEM=gmac
GMACEVENT = gmac_sw0_lan



gmackobj: /gmac/gmacconfig
action:KOBJ_REMOVE
envp_ext:GMACEVENT = gmac_sw0_lan

remove@/gmac/gmacconfig
ACTION=remove
DEVPATH=/gmac/gmacconfig
SUBSYSTEM=gmac
GMACEVENT = gmac_sw0_lan


[ eth0 ]
gmackobj: /gmac/gmacconfig
action:KOBJ_ADD
envp_ext:GMACEVENT = gmac_eth0

add@/gmac/gmacconfig
ACTION=add
DEVPATH=/gmac/gmacconfig
SUBSYSTEM=gmac
GMACEVENT = gmac_eth0


gmackobj: /gmac/gmacconfig
action:KOBJ_REMOVE
envp_ext:GMACEVENT = gmac_eth0

remove@/gmac/gmacconfig
ACTION=remove
DEVPATH=/gmac/gmacconfig
SUBSYSTEM=gmac
GMACEVENT = gmac_eth0

*/



/*USB [rj45]*/
#define RJ45_ONLINE_MESSAGE       "online@/devices/platform/zx297520_usb.0/usb1/1-1"
#define RJ45_OFFLINE_MESSAGE      "offline@/devices/platform/zx297520_usb.0/usb1/1-1"
//#define RJ45_PLUG_STATE_PATH      "/sys/kernel/eth_debug/eth_state"     /*ͨnv  rj45_plugstate_path洢*/

/*USB״̬ļͨnv洢*/
/*usb_name_path棬洢usbƣʽ: usblan0;usblan1;usblan2*/
//#define RNDIS_NAME_FILE_PATH      "/sys/dwc_usb/usbconfig/netname"

/*usb״̬ļ·*/
//#define USB_PLUG_STATE_PATH       "/sys/dwc_usb/usbconfig/"


/*ڲ״̬*/
#define WAN_PLUG_OUT   0
#define WAN_PLUG_IN    1


typedef enum {
	RJ45_WAN_LAN_OFF = 0,		/*rj45 γ*/
	RJ45_WAN_ON_LAN_OFF,        /*rj45ڲ룬ڰγ*/
	RJ45_WAN_OFF_LAN_ON,        /*RJ45ڲ룬ڰγ*/
	RJ45_WAN_LAN_ON,            /*rj45ھ*/
	RJ45_LAN_OFF,               /*rj45ڰγĿǰδʹ*/
	RJ45_LAN_ON,                /*rj45ڲ룬Ŀǰδʹ*/
	RJ45_INVALID,               /*Ч״̬*/
	RJ45_STATE_MAX,
};

/*rj45״̬ļд洢״ַ̬*/
static const char *rj45_state_str[] = {
	[RJ45_WAN_LAN_OFF]    = "wan_lan_off",
	[RJ45_WAN_ON_LAN_OFF] = "wan_on_lan_off",
	[RJ45_WAN_OFF_LAN_ON] = "wan_off_lan_on",
	[RJ45_WAN_LAN_ON]     = "wan_lan_on",
	[RJ45_LAN_OFF]        = "lan_off",
	[RJ45_LAN_ON]         = "lan_on",
	[RJ45_INVALID]   = "invalid",
};


char usbdev_name[1024] = {0};

/*ͣ1:eth0ڣ0:sw*/
int  rj45_eth0 = 0;

static inline int read_file(char *path, char *buf, int len)
{
	FILE *fp = NULL;
	int msglen = 0;

	if ((fp = fopen(path, "r")) != NULL) {
		msglen = fread(buf, 1, len, fp);
		fclose(fp);
		return msglen;
	}

	return -1;
}

static int parse_string(char *str, char split, char out_str[][20], int max_num)
{
	char *curr = NULL;
	char *prev = NULL;
	char *tail = NULL;
	int count = 0;

	prev = str;
	tail = str + strlen(str);

	if (max_num <= 0)
		return 0;


	while ((curr = strchr(prev, split)) != 0) {
		strncpy(out_str[count], prev, curr - prev);
		prev = curr + 1;
		count++;
		if (count >= max_num)
			return count;
	}

	if (prev < tail) {
		strncpy(out_str[count], prev, tail - prev);
		count++;
	}

	return count;
}

static char* neutralize(char *path)
{
	if(path == NULL)
	{
		return NULL;
	}
	/* · */
	if (strstr(path, "../"))
	{
		return NULL;
	}
	
	/* ϵͳ· */
	if (strncmp(path, "/etc", 4) == 0)
	{
		return NULL;
	}
	
	/* null ŷ*/
	if (strstr(path, "%00"))
	{
		return NULL;
	}

	return path;
}


/*USBϵ״̬Ӧplugin/plugout*/
static void usb_hotplug_init()
{
	char usb_name[64] = {0};
	char path[160] = {0};//klocwork
	char state_str[8] = {0};
	char netif_name[4][20] = {0};
	char rndis_path[128] = {0};
	char state_path[128] = {0};
	int netif_num = 0;
	int msglen = 0;
	int state = 0;
	int i = 0;

	sc_cfg_get("usb_name_path", rndis_path, sizeof(rndis_path));
	sc_cfg_get("usb_plugstate_path", state_path, sizeof(state_path));

	msglen = read_file(rndis_path, usb_name, sizeof(usb_name)-1);
	if (msglen <= 0)
		return;
	usb_name[63]=0;
	slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]read state = %s\n", __func__, __LINE__, usb_name);

	netif_num = parse_string(usb_name, ';', netif_name, 4);
	if (netif_num > 0) {
		for (i = 0; i < netif_num; i++) {
			char *path_t = NULL;
			memset(state_str, 0, sizeof(state_str));
			memset(path, 0, sizeof(path));
			snprintf(path, sizeof(path), "%s/%s", state_path, netif_name[i]);
			path[159]=0;
			path_t = neutralize(path); //klocwork
			if (path_t == NULL) 
				continue;
			path_t[159]=0;
			msglen = read_file(path_t, state_str, sizeof(state_str)-1);
			if (msglen > 0) {
				slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]netif_name = %s, state = %s\n", __func__, __LINE__, netif_name[i], state_str);

				state = atoi(state_str);
				if (1 == state) {
					netdev_plugin_proc_byname(netif_name[i], MODULE_ID_HOTPLUG);
				}
			}
		}
	}
}


/*ȡrj45ϵ״̬*/
int rj45_state_get(char *state, int len)
{
	int ret = -1;
	int count = 0;

	if (len && (state[len - 1] == '\n' || state[len - 1] == '\0'))
		len--;

	if (!len)
		return -1;

	/*phy eth0״̬*/
	if (0 == strncmp(state, "0", 1)) { /*γ*/
		rj45_eth0 = 1;
		return RJ45_WAN_LAN_OFF;
	} else if (0 == strncmp(state, "1", 1)) { /**/
		rj45_eth0 = 1;
		return RJ45_WAN_ON_LAN_OFF;
	} else {
		/*sw״̬*/
		for (count = 0; count < RJ45_STATE_MAX; count++) {
			if (0 == strncmp(rj45_state_str[count], state, len)) {
				return count;
			}
		}
	}

	return -1;
}

/*ȡswitch rj45ϵ״̬*/
int rj45_switch_state_get(char *wan_state, int wan_len, char *lan_state, int lan_len)
{
	int ret = -1;
	int count = 0;

	if (wan_len && (wan_state[wan_len - 1] == '\n' || wan_state[wan_len - 1] == '\0'))
		wan_len--;
	if (!wan_len)
		return -1;

	if (lan_len && (lan_state[lan_len - 1] == '\n' || lan_state[lan_len - 1] == '\0'))
		lan_len--;
	if (!lan_len)
		return -1;

	if(0 == strncmp(wan_state, "0", 1) && 0 == strncmp(lan_state, "0", 1))
	{
		count = RJ45_WAN_LAN_OFF;
	}
	else if(0 == strncmp(wan_state, "1", 1) && 0 == strncmp(lan_state, "0", 1))
	{
		count = RJ45_WAN_ON_LAN_OFF;
	}
	else if(0 == strncmp(wan_state, "0", 1) && 0 == strncmp(lan_state, "1", 1))
	{
		count = RJ45_WAN_OFF_LAN_ON;
	}
	else if(0 == strncmp(wan_state, "1", 1) && 0 == strncmp(lan_state, "1", 1))
	{
		count = RJ45_WAN_LAN_ON;
	}
	else
	{
		return -1;
	}

	return count;
}



static inline void rj45_wan_mode_set(char *mode)
{
	char wan_mode[32] = {0};

	sc_cfg_get("blc_wan_mode", wan_mode, sizeof(wan_mode));

	if (0 == strcmp(wan_mode, "AUTO")) {
		sc_cfg_set("blc_wan_auto_mode", mode);
	}
}


/*ȡdevid*/
int rj45_wan_devid_get(int plug_type)
{
	char wan_mode[20] = {0};
	char wan_auto_mode[20] = {0};
	int dev_id = -1;

	sc_cfg_get("blc_wan_mode", wan_mode, sizeof(wan_mode));
	sc_cfg_get("blc_wan_auto_mode", wan_auto_mode, sizeof(wan_auto_mode));

	/**/
	if (WAN_PLUG_IN == plug_type) {
		if (0 == strcmp(wan_mode, "AUTO")) {
			sc_cfg_set("blc_wan_auto_mode", "AUTO_PPPOE");
			if (1 == rj45_eth0)
				dev_id = RJ45_WAN_DEV;
			else
				dev_id = SW_WAN_DEV;
		} else if (0 == strcmp(wan_mode, "PPPOE")) {
			if (1 == rj45_eth0)
				dev_id = RJ45_WAN_DEV;
			else
				dev_id = SW_WAN_DEV;
		} else if (0 == strcmp(wan_mode, "PPP")) {
			/*ΪPSeth0Ϊڣsw0.200*/
			if (1 == rj45_eth0)
				dev_id = RJ45_LAN_DEV;
		}
	} else { /*γ*/
		if (0 == strcmp(wan_mode, "PPP")) {
			if (1 == rj45_eth0)
				dev_id = RJ45_LAN_DEV;
		} else {
			if (0 == strcmp(wan_mode, "AUTO"))
				sc_cfg_set("blc_wan_auto_mode", "AUTO_PPP");

			if (1 == rj45_eth0)
				dev_id = RJ45_WAN_DEV;
			else
				dev_id = SW_WAN_DEV;
		}
	}

	return dev_id;
}



/*RJ45ϵ״̬Ӧ*/
void rj45_hotplug_init()
{
	char state_str[32] = {0};
	char wan_state_str[32] = {0};
	char lan_state_str[32] = {0};
	char state_path[128] = {0};
	char wan_state_path[128] = {0};
	char lan_state_path[128] = {0};
	char cpe_type[32] = {0};
	int state_len = 0;
	int wan_state_len = 0;
	int lan_state_len = 0;
	int state;
	int dev_id = 0;

	sc_cfg_get("cpe_type", cpe_type, sizeof(cpe_type));
	
	//ʱֻǵphyswitchûпǵphy+switch̬
	if(strcmp(cpe_type, "switch") == 0) //switch
	{		
		sc_cfg_get("rj45_wan_plugstate_path", wan_state_path, sizeof(wan_state_path));
		if (0 == strcmp(wan_state_path, ""))
			return;
		wan_state_len = read_file(wan_state_path, wan_state_str, sizeof(wan_state_str));
		if (wan_state_len <= 0) {
			return;
		}
			
		sc_cfg_get("rj45_lan_plugstate_path", lan_state_path, sizeof(lan_state_path));
		if (0 == strcmp(lan_state_path, ""))
			return;
		lan_state_len = read_file(lan_state_path, lan_state_str, sizeof(lan_state_str));
		if (lan_state_len <= 0) {
			return;
		}		
		
		state = rj45_switch_state_get(wan_state_str, wan_state_len, lan_state_str, lan_state_len);
		slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]read pht wan_state = %s,lan_state = %s\n", __func__, __LINE__, wan_state_str, lan_state_str);
	}
	else //phy
	{	
		sc_cfg_get("rj45_plugstate_path", state_path, sizeof(state_path));
		if (0 == strcmp(state_path, ""))
			return;
		state_len = read_file(state_path, state_str, sizeof(state_str));
		if (state_len <= 0) {
			return;
		}
		state = rj45_state_get(state_str, state_len);
		
		slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]read pht state = %s\n", __func__, __LINE__, state_str);
	}
	

	if (state < 0 || state == RJ45_INVALID) {
		return;
	}

	slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]init state = %d\n", __func__, __LINE__, state);

	switch (state) {
	case RJ45_WAN_LAN_OFF:
		rj45_wan_mode_set("AUTO_PPP");
		break;
	case RJ45_WAN_ON_LAN_OFF:
		rj45_wan_mode_set("AUTO_PPPOE");
		dev_id = rj45_wan_devid_get(WAN_PLUG_IN);
		if (dev_id >= 0) {
			slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]dev_id = %d\n", __func__, __LINE__, dev_id);
			netdev_plugin_proc(dev_id, MODULE_ID_HOTPLUG);
		}
		break;
	case RJ45_WAN_OFF_LAN_ON:
		rj45_wan_mode_set("AUTO_PPP");
		netdev_plugin_proc(SW_LAN_DEV, MODULE_ID_HOTPLUG);
		break;
	case RJ45_WAN_LAN_ON:
		rj45_wan_mode_set("AUTO_PPPOE");
		dev_id = rj45_wan_devid_get(WAN_PLUG_IN);
		if (dev_id >= 0) {
			slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]dev_id = %d\n", __func__, __LINE__, dev_id);
			netdev_plugin_proc(dev_id, MODULE_ID_HOTPLUG);
		}
		netdev_plugin_proc(SW_LAN_DEV, MODULE_ID_HOTPLUG);
		break;
	default:
		break;
	}

	return;
}

/*rj45ȰβϢ*/
int rj45_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
	char buff[UEVENT_BUFFER_SIZE] = {0};
	int dev_id = 0;

	memcpy(buff, msg, msglen);
	char_replace(buff, msglen, '\0', '\n');

	switch (event->action) {
	case KOBJ_ADD:
	case KOBJ_REMOVE:
		if (strstr(buff, "gmac/gmacconfig")) {
			if (strstr(buff, "gmac_eth_sw_wan") || strstr(buff, "gmac_eth_phy")) {
				if (KOBJ_ADD == event->action) {
					dev_id = rj45_wan_devid_get(WAN_PLUG_IN);
				} else {
					dev_id = rj45_wan_devid_get(WAN_PLUG_OUT);
				}
				if (dev_id < 0)
					goto err_out;

				slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]rj45 dev id = %d\n", __func__, __LINE__, dev_id);

				event->type = DEVICE_TYPE_RJ45;
				event->u.netdev.dev_id = dev_id;
				return 0;
			} else if (strstr(buff, "gmac_eth_sw_lan")) {
				slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]rj45 dev id = %d\n", __func__, __LINE__, SW_LAN_DEV);
				event->type = DEVICE_TYPE_RJ45;
				event->u.netdev.dev_id = SW_LAN_DEV;
				return 0;
			}
		}
		break;

	case KOBJ_ONLINE:
		if (strncmp(RJ45_ONLINE_MESSAGE, buff, strlen(RJ45_ONLINE_MESSAGE)) == 0) {
			dev_id = rj45_wan_devid_get(WAN_PLUG_IN);
			if (dev_id < 0)
				goto err_out;

			slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]rj45 dev id = %d\n", __func__, __LINE__, dev_id);

			event->type = DEVICE_TYPE_RJ45;
			event->u.netdev.dev_id = dev_id;
			return 0;
		}
		break;

	case KOBJ_OFFLINE:
		if (strncmp(RJ45_OFFLINE_MESSAGE, buff, strlen(RJ45_OFFLINE_MESSAGE)) == 0) {
			dev_id = rj45_wan_devid_get(WAN_PLUG_OUT);
			if (dev_id < 0)
				goto err_out;

			slog(NET_PRINT, SLOG_DEBUG, "[%s][%d]rj45 dev id = %d\n", __func__, __LINE__, dev_id);

			event->u.netdev.dev_id = dev_id;
			event->type = DEVICE_TYPE_RJ45;
			return 0;
		}
		break;
	default:
		break;
	}

err_out:
	slog(NET_PRINT, SLOG_ERR, "[%s][%d]not rj45 hotplug msg\n", __func__, __LINE__);
	return -1;
}


/*usbȰβϢ*/
static int usb_msg_parse(const char *msg, int msglen, struct hotplug_event *event)
{
	char *dev_ptr = NULL;
	int dev_id = 0;

	dev_ptr = strrchr(msg, '/');
	if (NULL == dev_ptr) {
		slog(NET_PRINT, SLOG_ERR, "[%s][%d]can not find devname\n", __func__, __LINE__);
		return -1;
	}

	dev_ptr++;

	if (strlen(dev_ptr)) {
		slog(NET_PRINT, SLOG_ERR, "[%s][%d]dev_name1 = %s\n", __func__, __LINE__, dev_ptr);
		if (strstr(usbdev_name, dev_ptr)) {
			slog(NET_PRINT, SLOG_ERR, "[%s][%d]dev_name = %s\n", __func__, __LINE__, dev_ptr);
			dev_id = getDevId_byname(dev_ptr);
			slog(NET_PRINT, SLOG_ERR, "[%s][%d]dev_id = %d\n", __func__, __LINE__, dev_id);
			if (dev_id < 0)
				return -1;

			event->type = DEVICE_TYPE_USB;
			strncpy(event->u.netdev.dev_name, dev_ptr, sizeof(event->u.netdev.dev_name)-1);
			event->u.netdev.dev_id = dev_id;
			return 0;
		}
		if (KOBJ_ADD == event->action && strstr(dev_ptr, "v4-wan")) {
			char cmd[60] = {0};
			
			snprintf(cmd, sizeof(cmd), "ip route add default dev %s", dev_ptr);
			slog(NET_PRINT, SLOG_ERR, "[%s][%d]system=%s\n", __func__, __LINE__, cmd);
			soft_system(cmd);
			return 0;
		}
	}

	return -1;
}


/*Ŀǰrj45ϱϢȽ϶ƣ޷dev_name*/
void netdev_name_init()
{
	char usblan_name[NETIF_NAME_LEN] = {0};
	char psext1_name[NETIF_NAME_LEN] = {0};
	char psext2_name[NETIF_NAME_LEN] = {0};
	char psext3_name[NETIF_NAME_LEN] = {0};
	char psext4_name[NETIF_NAME_LEN] = {0};
	char psext5_name[NETIF_NAME_LEN] = {0};
	char psext6_name[NETIF_NAME_LEN] = {0};
	char psext7_name[NETIF_NAME_LEN] = {0};
	char psext8_name[NETIF_NAME_LEN] = {0};

	sc_cfg_get("usblan", usblan_name, sizeof(usblan_name));
	sc_cfg_get("ps_ext1", psext1_name, sizeof(psext1_name));
	sc_cfg_get("ps_ext2", psext2_name, sizeof(psext2_name));
	sc_cfg_get("ps_ext3", psext3_name, sizeof(psext3_name));
	sc_cfg_get("ps_ext4", psext4_name, sizeof(psext4_name));
	sc_cfg_get("ps_ext5", psext5_name, sizeof(psext1_name));
	sc_cfg_get("ps_ext6", psext6_name, sizeof(psext2_name));
	sc_cfg_get("ps_ext7", psext7_name, sizeof(psext3_name));
	sc_cfg_get("ps_ext8", psext8_name, sizeof(psext4_name));
	//sc_cfg_get("ethwan", ethwan_name, sizeof(ethwan_name));
	//sc_cfg_get("ethlan", ethlan_name, sizeof(ethlan_name));

	if (0 != strlen(usblan_name))
		strcpy(usbdev_name, usblan_name);
	if (0 != strlen(psext1_name))
		strcat(usbdev_name, psext1_name);
	if (0 != strlen(psext2_name))
		strcat(usbdev_name, psext2_name);
	if (0 != strlen(psext3_name))
		strcat(usbdev_name, psext3_name);
	if (0 != strlen(psext4_name))
		strcat(usbdev_name, psext4_name);
	if (0 != strlen(psext5_name))
		strcat(usbdev_name, psext1_name);
	if (0 != strlen(psext6_name))
		strcat(usbdev_name, psext2_name);
	if (0 != strlen(psext7_name))
		strcat(usbdev_name, psext3_name);
	if (0 != strlen(psext8_name))
		strcat(usbdev_name, psext4_name);
}


/*豸Ȱβ崦*/
int netdev_hotplug_proc(struct hotplug_event *event)
{
	slog(NET_PRINT, SLOG_NORMAL, "[%s][%d]act type = %d, dev_id = %d\n", __func__, __LINE__, event->action, event->u.netdev.dev_id);

	switch (event->action) {
	case KOBJ_ADD:
	case KOBJ_ONLINE:
		netdev_plugin_proc(event->u.netdev.dev_id, MODULE_ID_HOTPLUG);
		break;

	case KOBJ_REMOVE:
	case KOBJ_OFFLINE:
		netdev_plugout_proc(event->u.netdev.dev_id, MODULE_ID_HOTPLUG);
		break;
    case KOBJ_CHANGE:
        //λ߼
        break ;
	default:
		break;
	}

	return 0;
}


/**************************************************************************
* : gmacif_hwaddr_init
* : ʼgmacڶӦmacַ
* ˵: (IN)
*                         (OUT)
*   ֵ: 
* ˵: NVMACַΪBCD룬ҪתASCII
**************************************************************************/
static int gmacif_hwaddr_init()
{
    unsigned long   retCode = CPNV_ERROR;
    char            TmpMacAddr[OS_FLASH_AMT_COMM_RO_GMAC_SIZE] = {0};//imeiֵ
	char			ethwan[16] = {0};
	char			ethwan_name[16] = {0};
	char 			*ptr = NULL;
	char			device_type[16] = {0};
	int 			fd, rt;
	struct ifreq 	ifr;
	int				i = 0;
	int				sum_and = 0xFF;
	int				sum_or = 0x0;
	
	sc_cfg_get("fota_device_type", device_type, sizeof(device_type));
	if(strcmp(device_type, "cpe") != 0)
	{
		return -1;
	}
    retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_GMAC_ADDRESS, (UINT8 *)TmpMacAddr, OS_FLASH_AMT_COMM_RO_GMAC_SIZE);    
    if (CPNV_ERROR == retCode)
    {   
    	printf("gmacif_hwaddr_init() cpnv_NvItemRead() read fail \n");
        return CPNV_ERROR;
    }

	//nvroȡmacֵǷȫ0x0ȫ0xFF˵δͨAT+GMACдgmacmacַ
	for(i = 0; i < 6; i++)
	{
		sum_and &= TmpMacAddr[i];
		sum_or	|= TmpMacAddr[i]; 	
	}
	if(sum_and == 0xFF || sum_or == 0x0)
	{
		return -1;
	}
	
	sc_cfg_get("ethwan", ethwan_name, sizeof(ethwan_name));
	if((ptr = strchr(ethwan_name, '.')) != NULL)	//cpe switch̬nvethwanֵΪeth0.200
	{
		int len = ptr - ethwan_name;
		memcpy((void*)ethwan, (void*)ethwan_name, len);
	}
	else
	{
		memcpy((void*)ethwan, (void*)ethwan_name, strlen(ethwan_name));
	}
	
	fd = socket(AF_INET, SOCK_DGRAM, 0);
	if(fd < 0)
	{
		printf("gmacif_hwaddr_init() create socket fail \n");
		return -1;
	}

	ifr.ifr_addr.sa_family = ARPHRD_ETHER;
	strncpy(ifr.ifr_name, (const char*)ethwan, IFNAMSIZ - 1);
	memcpy((unsigned char*)ifr.ifr_hwaddr.sa_data, TmpMacAddr, 6);

	if((rt = ioctl(fd, SIOCSIFHWADDR, &ifr)) != 0)
	{
		printf("gmacif_hwaddr_init() ioctl fail\n");
	}
	close(fd);
	   
    return rt;
}


/*ϵʼ*/
void netdev_hotplug_init()
{
	/*豸ʼ*/
	netdev_name_init();
	gmacif_hwaddr_init();

	/*ȰβϢʼ*/
	hotplug_parse_register(DEVICE_TYPE_RJ45, (hotplug_parse_func)rj45_msg_parse);
	hotplug_parse_register(DEVICE_TYPE_USB, (hotplug_parse_func)usb_msg_parse);

	/*豸Ȱβ崦ע*/
	hotplug_proc_register(DEVICE_TYPE_RJ45, (hotplug_proc_func)netdev_hotplug_proc);
	hotplug_proc_register(DEVICE_TYPE_USB, (hotplug_proc_func)netdev_hotplug_proc);

	/*豸ʼ״̬*/
	rj45_hotplug_init();
	usb_hotplug_init();
}


