/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_lcd_page.c
*  ļʶ  
*  ļ  
*  ʵֹ  
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
*******************************************************************************/
#ifndef DISABLE_LCD
#include "mmi_lcd.h"

extern T_LcdShowInfoItem g_LcdShowInfoTab[];
extern E_zMmi_Sim_Tip s_mmi_sim_tip;
extern pthread_mutex_t g_mmi_refresh_lcd_mutex;

extern UINT32 g_show_pagefirst;
extern UINT32 g_show_pagesecond;
extern UINT32 g_show_pagethird;

static E_zMMI_Lcd_Page_Index g_mmi_lcd_page_index = MMI_SHOW_PAGE_FIRST;
/***********************************************************************************
   :Ƿʾͼ, visible: TRUEʾ;FALSE, 
***********************************************************************************/
static VOID mmi_set_top_bar_visibility(BOOL visible)
{
	g_LcdShowInfoTab[LCD_SHOW_NET_SIGNAL].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_NET_CONNECT].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_WIFISTATION_CONNECT].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_SMS].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_SMS_NUM].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_WIFI].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_NEW_VERSION].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_BATTERY].needShowFL = visible;
}

static VOID mmi_set_middle_visibility(BOOL visible)
{
	g_LcdShowInfoTab[LCD_SHOW_CMCC].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_SIM_STATE].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_WPS_ACTIVE].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_NET_CONNECTING].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_NET_PROVIDER].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_WIFISTA_SSID].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_TIP_UPDATE_INFO].needShowFL = visible;
}

static VOID mmi_set_ssid_page_visibility(BOOL visible)
{
	g_LcdShowInfoTab[LCD_SHOW_WIFI_PASSWORD].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_WIFI_SSID].needShowFL = visible;
}

static VOID mmi_set_ssid2_page_visibility(BOOL visible)
{
	g_LcdShowInfoTab[LCD_SHOW_WIFI_PASSWORD2].needShowFL = visible;
	g_LcdShowInfoTab[LCD_SHOW_WIFI_SSID2].needShowFL = visible;
}

static VOID mmi_set_first_page_visibility(BOOL visible)
{
	if (g_show_pagefirst) {
		g_LcdShowInfoTab[LCD_SHOW_TRAFFIC].needShowFL = visible;
		g_LcdShowInfoTab[LCD_SHOW_TRAFFIC_BAR].needShowFL = visible;
		g_LcdShowInfoTab[LCD_SHOW_TRAFFIC_SLIDER].needShowFL = visible;
	}
}

static VOID mmi_set_second_page_visibility(BOOL visible)
{
	if (g_show_pagesecond) {
		mmi_set_middle_visibility(visible);
		mmi_set_ssid_page_visibility(visible);
	}
}

static VOID mmi_set_third_page_visibility(BOOL visible)
{
	if (g_show_pagethird) {
		g_LcdShowInfoTab[LCD_SHOW_WIFI_CODE].needShowFL = visible;
	}
}

static VOID mmi_set_four_page_visibility(BOOL visible)
{
//ssidʱҪʾ
	mmi_set_middle_visibility(visible);
	mmi_set_ssid2_page_visibility(visible);
}

static VOID mmi_set_five_page_visibility(BOOL visible)
{
//ssidʱҪʾ
	g_LcdShowInfoTab[LCD_SHOW_WIFI_CODE2].needShowFL = visible;
}

static VOID mmi_set_all_page_invisibility()
{
	mmi_set_first_page_visibility(FALSE);
	mmi_set_second_page_visibility(FALSE);
	mmi_set_third_page_visibility(FALSE);
	mmi_set_ssid2_page_visibility(FALSE);
	mmi_set_five_page_visibility(FALSE);
}


BOOL mmi_is_the_last_page()
{
	int lastpage = 0;

	if (g_show_pagethird)
		lastpage = MMI_SHOW_PAGE_THIRD;

	else if (g_show_pagefirst)
		lastpage = MMI_SHOW_PAGE_SECOND;

	return (g_mmi_lcd_page_index == lastpage);
}

E_zMMI_Lcd_Page_Index mmi_get_lcd_page_index(VOID)
{
	return g_mmi_lcd_page_index;
}

static E_zMMI_Lcd_Page_Index mmi_get_lcd_next_page_index(VOID)
{
	E_zMMI_Lcd_Page_Index index = mmi_get_lcd_page_index();
	E_zMMI_Lcd_Page_Index next_index = index;
	slog(MMI_PRINT, SLOG_DEBUG, "MMI  mmi_get_lcd_next_page_index index = %d\n", index);

	while (index < MMI_SHOW_PAGE_MAX) {
		if (index == MMI_SHOW_PAGE_FIVE) {
			index = MMI_SHOW_PAGE_FIRST;
		} else {
			index++;
		}

		if (index == MMI_SHOW_PAGE_FIRST) {
			if (g_show_pagesecond) {
				next_index = index;
				break;
			}
		} else if (index == MMI_SHOW_PAGE_SECOND) {
			if (g_show_pagefirst) {
				next_index = index;
				break;
			}
		} else if ((index == MMI_SHOW_PAGE_THIRD) && (mmi_get_qrcode_state() == TRUE)) {
			if (g_show_pagethird) {
				next_index = index;
				break;
			}
		}
		if (mmi_get_multi_ssid_switch_flag()) {
			if (index == MMI_SHOW_PAGE_FOUR) {
				next_index = index;
				break;
			} else if ((index == MMI_SHOW_PAGE_FIVE) && (mmi_get_qrcode_state() == TRUE)) {
				next_index = index;
				break;
			}
		}
	}

	return next_index;
}


VOID mmi_set_lcd_page_index(E_zMMI_Lcd_Page_Index index)
{
	mmi_getMutex(&g_mmi_refresh_lcd_mutex);
	g_mmi_lcd_page_index = index;
	switch (index) {
	case MMI_SHOW_PAGE_FIRST:
		mmi_set_all_page_invisibility();
		mmi_set_top_bar_visibility(TRUE);
		mmi_set_middle_visibility(TRUE);
		mmi_set_first_page_visibility(TRUE);
		break;
	case MMI_SHOW_PAGE_SECOND:
		mmi_set_top_bar_visibility(TRUE);
		mmi_set_all_page_invisibility();
		mmi_set_second_page_visibility(TRUE);//һҳҳֱлҪҳȫfalse
		break;
	case MMI_SHOW_PAGE_THIRD:
		mmi_set_top_bar_visibility(FALSE);
		mmi_set_all_page_invisibility();
		mmi_set_third_page_visibility(TRUE);
		break;
	case MMI_SHOW_PAGE_FOUR:
		mmi_set_top_bar_visibility(TRUE);
		mmi_set_all_page_invisibility();
		mmi_set_four_page_visibility(TRUE);
		break;
	case MMI_SHOW_PAGE_FIVE:
		mmi_set_top_bar_visibility(FALSE);
		mmi_set_all_page_invisibility();
		mmi_set_five_page_visibility(TRUE);
		break;
	default:
		break;
	}
	mmi_putMutex(&g_mmi_refresh_lcd_mutex);

}


VOID mmi_handle_lcd_key_switch_page()
{
	int page_index = mmi_get_lcd_next_page_index();
	slog(MMI_PRINT, SLOG_DEBUG, "MMI  mmi_handle_lcd_key_switch_page page_index = %d\n", page_index);

	//ʾSSIDʱstop λΪ0
	mmi_stopLcdShowScrollSSIDTimer();
	mmi_set_wificode_show_flag(FALSE);
	if (page_index == MMI_SHOW_PAGE_FIRST) {
		mmi_set_lcd_page_index(MMI_SHOW_PAGE_FIRST);
		mmi_set_update_flag(MMI_TASK_SSID);
	} else if (page_index == MMI_SHOW_PAGE_SECOND) {
		mmi_set_lcd_page_index(MMI_SHOW_PAGE_SECOND);
		mmi_set_update_flag(MMI_TASK_TRAFFIC);
	} else if (page_index == MMI_SHOW_PAGE_THIRD) {
		mmi_set_wificode_show_flag(TRUE);
		mmi_set_lcd_page_index(MMI_SHOW_PAGE_THIRD);
		mmi_set_update_flag(MMI_TASK_WIFICODE);
	} else if (page_index == MMI_SHOW_PAGE_FOUR) {
		mmi_set_lcd_page_index(MMI_SHOW_PAGE_FOUR);
		mmi_set_update_flag(MMI_TASK_SSID);
	} else if (page_index == MMI_SHOW_PAGE_FIVE) {
		mmi_set_wificode_show_flag(TRUE);
		mmi_set_lcd_page_index(MMI_SHOW_PAGE_FIVE);
		mmi_set_update_flag(MMI_TASK_WIFICODE);
	}

}
#endif
