/**
* @File: telecom_dm.c
* @Brief: Implementation of Device Manager in Sanechips
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @Author:
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
* */

#include <sched.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>
#include <errno.h>
#include <sys/msg.h>
#include <sys/ipc.h>
#include <errno.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/select.h>
#include "../include/message.h"
#include <netdb.h>
#include "telecom_dm.h"
#include "softap_api.h"


/**************************************************************************
* 궨
**************************************************************************/
#define log(...)            do { printf(__VA_ARGS__); fflush(stdout); } while(0)
#define log_err(...)        do { log("DM-ERR NOW: FILE(%s) , LINE(%d) >>>>: ", __FILE__, __LINE__ );  printf(__VA_ARGS__); fflush(stdout);} while(0)
#define DM_FOR_DEBUG_ENCRYPT
#define __DM_DEBUG__

#ifdef __DM_DEBUG__
#define log_debug(...)      do { log("dm-debug now: file(%s) ,line(%d) >>>>: ", __FILE__, __LINE__); printf(__VA_ARGS__); fflush(stdout);} while(0)
#else
#define log_debug(...)
#endif

#define CALL(x) do { int t_ret = (x); if (t_ret != ERR_SUCCESS) { log_err("Get t_ret(%d)\n", t_ret); return t_ret;} } while (0)
#define CHECK_PARAM(X)  do {if(X) {log_err("the param is null\n");  return ERR_PARAM_NULL;} } while(0)
#define ASSER_VOID(X)   do {if(X) {log_err("the param is null\n");  return;}                } while(0)

#define  PORT       9999
#define  DEFAULT_SERVER_IP  "124.126.119.37"
#define  SEARCH_STR_RESULT_CODE			 	"\"resultCode\":\"0\""
#define  TELECOM_DM_REQUEST_URL  "http://zzhc.vnet.cn/"


#define  BASE64_LEN 1000
#define  RESPONSE_JSONDATA_LEN 100
#define  HTTP_HEAD_SZIE	512

/**************************************************************************
* ȫֱ
**************************************************************************/
static int g_sock_fd = -1;
static int g_socke_flag = -1;


/**************************************************************************
* 
**************************************************************************/
static int telecom_encode_http_head(char *httpPacketData, DM_TELECOM_HTTP_DATA_INFO *sendSrcData);
int telecom_parse_response(char *srcStr);

/**
 * ƣ https_packet_parse
 *  ݰַָ
 * ˵
 *   ֵ
 * ˵ ҪŻݽ
 */
static char * https_packet_parse(char *srcPackket, char *str)
{
    if (!srcPackket || !str)
        return NULL;

    return strstr(srcPackket, str);
}

/**
 * ƣ http_get_server_ip
 *  ȡIPַ
 * ˵urlַϢ
 *   ֵ   IPַ
 * ˵
 */
static unsigned long  http_get_server_ip(DM_TELECOM_HTTP_URL_INFO *urlInfo)
{
    struct hostent *hptr = NULL;
    char **pptr = NULL;
    char str[100] = "";
    char hostname[64] = {0};
    unsigned long ul_ip = (unsigned long)inet_addr(urlInfo->ipAddr);

    hptr = gethostbyname(urlInfo->hostName);
    if (NULL == hptr)
    {
        log_debug("dm_telecom_get_server_ip: gethostbyname %s failed!\n", hostname);
        return ul_ip;
    }

    for (pptr = hptr->h_aliases; *pptr != NULL; pptr++)
        log_debug("alias:%s\n", *pptr);

    switch (hptr->h_addrtype)
    {
    case AF_INET:
        pptr =  hptr->h_addr_list;
        for (; *pptr != NULL; pptr++)
        {
            inet_ntop(hptr->h_addrtype, *pptr, str, sizeof(str));

        }
        break;
    default:
        break;
    }
    log_debug("dm_telecom_get_server_ip == %s \n", str);

    return (unsigned long)inet_addr(str);
}

/**
 * ƣ http_socket_create
 *  socket
 * ˵
 *   ֵ   socket id
 * ˵
 */
static int http_socket_create()
{
    struct timeval  timeOut = {3, 0};

    g_sock_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (g_sock_fd < 0)
    {
        log_debug("[dm] create socket failed. fd=%d \n", g_sock_fd);
        return  ERR_SOCKET_CREATE_ERROR;
    }

    /*set timeout for reading/writing */
    if(0 != setsockopt(g_sock_fd, SOL_SOCKET, SO_SNDTIMEO, (char*)&timeOut, sizeof(struct timeval)))
    {
		log_err("http_socket_create setsockopt SO_SNDTIMEO err...\n");
	}
    if(0 != setsockopt(g_sock_fd, SOL_SOCKET, SO_RCVTIMEO, (char*)&timeOut, sizeof(struct timeval)))
    {
		log_err("http_socket_create setsockopt SO_RCVTIMEO err...\n");
	}

    return  g_sock_fd;
}

/**
 * ƣ http_socket_close
 *  رsocket
 * ˵socket id
 *   ֵ   
 * ˵
 */
static void http_socket_close(int socketId)
{
    if (socketId != -1)
    {
        close(socketId);
    }
}

/**
 * ƣ http_socket_connect
 *  socket
 * ˵socketId: socket id  urlInfo:ַϢ
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
static int http_socket_connect(int socketId, DM_TELECOM_HTTP_URL_INFO *urlInfo)
{
    static int connectNum = 0;

    struct sockaddr_in toAddr;
    toAddr.sin_addr.s_addr = http_get_server_ip(urlInfo); //(unsigned long)inet_addr("61.155.5.246");
    toAddr.sin_family      = AF_INET;
    toAddr.sin_port        = htons(urlInfo->portNum);
    bzero(&(toAddr.sin_zero), 8);
    log_debug("[dm] Send IP:%s\n", inet_ntoa(toAddr.sin_addr));

    connectNum = 3;
CONNECT_SOCKET:
    if (connect(socketId, (struct sockaddr *)&toAddr, sizeof(struct sockaddr)) == -1)
    {
        while (connectNum-- > 0)
        {
            close(socketId);
            socketId = -1;
            log_debug("[dm]http socket connect	connectNum(%d), errno = %d\n", connectNum, errno);
            sleep(1);
            if (-1 == (socketId = http_socket_create()))
            {
                log_debug("[dm]create socket fail. err= %d!\n", ERR_SOCKET_CREATE_ERROR);
                return ERR_SOCKET_CREATE_ERROR;
            }
            goto CONNECT_SOCKET;
        }
        log_debug("[dm] sendSocket connect Fail.err =%d!\n", ERR_SOCKET_CONNECT_ERROR);
        return ERR_SOCKET_CONNECT_ERROR;
    }

    return ERR_SUCCESS;
}

/**
 * ƣ http_socket_send
 *  HTTP
 * ˵socketId: socket id  sendSrcData:
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
static int http_socket_send(int socketId, DM_TELECOM_HTTP_DATA_INFO *sendSrcData)
{
    int retValue;
    char *sendPacketData = NULL;

    if (sendSrcData == NULL)
    {
        log_debug("create https packet param is null.\n");
        return ERR_PARAM_NULL;
    }

    sendPacketData = malloc(sendSrcData->dataLen + HTTP_SEARCH_LENGTH);
    if(!sendPacketData)
    {
        return ERR_MEM_ALLOC_ERROR;
    } //klockworks issue.
    memset(sendPacketData, 0, sendSrcData->dataLen + HTTP_SEARCH_LENGTH);
    //assert(sendPacketData);
    telecom_encode_http_head(sendPacketData, sendSrcData);

    log_debug("[dm] need send message =%s \n", sendPacketData);
    retValue = send(socketId, sendPacketData, strlen(sendPacketData), 0);
    if (retValue <= 0)
    {

    }
    log_debug("[dm] need send len = %d,  send success len = %d chars \n", strlen(sendPacketData), retValue);
    free(sendPacketData);
    return  ERR_SUCCESS;
}

/**
 * ƣ http_socket_select
 *  ȴhttpӦ
 * ˵socketId: socket id
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
static int http_socket_select(int socketId)
{
    fd_set readfds;
    struct timeval tv;
    int retValue;

    FD_ZERO(&readfds);
    FD_SET(socketId, &readfds);
    tv.tv_sec = 10;
    tv.tv_usec = 0;
    retValue = select(socketId + 1, &readfds, NULL, NULL, &tv);
    if (retValue <= 0)
    {
        log_debug("[dm]  ...select data fail:%d,errno:%d... \n", retValue, errno);
        return  ERR_RECV_ERROR;
    }
    log_debug("[dm]  select  retValue = %d\n", retValue);
    return  ERR_SUCCESS;
}

/**
 * ƣ http_socket_recv
 * httpӦ
 * ˵socketId: socket id  packetbuf:Žյ
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
static int http_socket_recv(int socketId, DM_TELECOM_HTTP_DATA_INFO *packetbuf)
{
    int retValue;
    DM_TELECOM_HTTP_DATA_INFO *data_info = packetbuf;
    log_debug("[dm] http_socket_recv , data_info->dataLen = %d\n", data_info->dataLen);
    retValue = recv(socketId, data_info->dataBuffer, data_info->dataLen - 1, 0);
    if (retValue <= 0)
    {
        log_debug("[dm]  ...recv data fail:%d,errno:%d... \n", retValue, errno);
        return ERR_RECV_ERROR;
    }
    data_info->dataBuffer[data_info->dataLen - 1] = '\0';
    log_debug("[dm] http_socket_recv , bufsize = %d, buf = %s\n", retValue, data_info->dataBuffer);
    data_info->totalSize = retValue;
    return telecom_parse_response(data_info->dataBuffer);
}

/**
 * ƣ telecom_base64_encode
 * ݽbase64
 * ˵data:data_len:ݳencode:ܺencode_len:ܺݳ
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
void telecom_base64_encode(const char* data, int data_len, char* encode, int encode_len)
{
    int prepare = 0;
    int ret_len;
    int temp = 0;
    char *ret = NULL;
    char *f = NULL;
    int tmp = 0;
    char changed[4];
    int i = 0;
    const char base[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    if (data == NULL)
    {
        return;
    }
    if (encode == NULL)
    {
        return;
    }
    if (data_len == 0)
    {
        return;
    }
    ret_len = data_len / 3;
    temp = data_len % 3;
    if (temp > 0)
    {
        ret_len += 1;
    }
    ret_len = ret_len * 4 + 1;
    ret = (char *)malloc(ret_len);

    if (ret == NULL)
    {
        log_debug("No enough memory.\n");
        return;
    }
    memset(ret, 0, ret_len);
    f = ret;
    while (tmp < data_len)
    {
        temp = 0;
        prepare = 0;
        memset(changed, '\0', 4);
        while (temp < 3)
        {
            //printf("tmp = %d\n", tmp);
            if (tmp >= data_len)
            {
                break;
            }
            prepare = ((prepare << 8) | (data[tmp] & 0xFF));
            tmp++;
            temp++;
        }
        prepare = (prepare << ((3 - temp) * 8));
        //printf("before for : temp = %d, prepare = %d\n", temp, prepare);
        for (i = 0; i < 4 ; i++)
        {
            if (temp < i)
            {
                changed[i] = 0x40;
            }
            else
            {
                changed[i] = (prepare >> ((3 - i) * 6)) & 0x3F;
            }
            *f = base[changed[i]];
            //printf("%.2X", changed[i]);
            f++;
        }
    }
    *f = '\0';
    strncpy(encode, ret, encode_len - 1);
    if (ret != NULL)
    {
        free(ret);
    }
}

/**
 * ƣtelecom_parse_response_state
 * Ӧ
 * ˵srcStr:
 *   ֵ   Ӧ
 * ˵
 */
int telecom_parse_response_state(char *srcStr)
{
    char *p1 = NULL;
    char *p2 = NULL;
    char state[10] = {0};
    int len = 0;
    int i = 0;

    while (srcStr[i] == ' ')
    {
        i++;
    }

    if (i > 0)
    {
        srcStr = srcStr + i;
    }

    i = 0;
    p1 = strchr(srcStr, ' ');
    if(NULL == p1)
    {
        return -1;
    } //klockworks issue.

    while (p1[i] == ' ')
    {
        i++;
    }
    p1 = p1 + i;
    p2 = strchr(p1, ' ');
    len = p2 - p1;

    //memcpy(state, p1, len);
    strncpy(state, p1, sizeof(state) - 1); //klockworks issue.

    log_debug("[dm] telecom_parse_response_state....state = %s \n", state);
    return atoi(state);
}

/**
 * ƣtelecom_parse_response_state
 * Ӧ
 * ˵content:
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
int telecom_parse_response_content(char *content)
{
    if (!https_packet_parse(content, SEARCH_STR_RESULT_CODE))
    {
        log_err("can not find the result-code(%s)\n", SEARCH_STR_RESULT_CODE);
        return ERR_RECV_ERROR;
    }
    return ERR_SUCCESS;
}

/**
 * ƣtelecom_get_response_content
 * ȡӦ
 * ˵srcStr:Ӧcontent:Ч
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
int telecom_get_response_content(char *srcStr, char *content, int datalen)
{
    char *p1 = NULL;
    char *p2 = NULL;
    int len = 0, temp_len = 0; //klockworks issue.
    char content_length[10] = {0};

    p1 = strstr(srcStr, "Content-Length");
    if (p1 != NULL)
    {
        len = strlen("Content-Length:");
        p1 = p1 + len;

        p2 = strchr(p1, '\r');
        len = p2 - p1;
        memcpy(content_length, p1, len);
        p1 = strchr(srcStr, '{');
        if (p1 == NULL)
        {
            return -1;
        }

        temp_len = atoi(content_length);
        if(temp_len <= RESPONSE_JSONDATA_LEN)
        {
            memcpy(content, p1, temp_len);
        }
        else
        {
            memcpy(content, p1, RESPONSE_JSONDATA_LEN);
        }//klockworks issue.
    }
    else
    {
        p1 = strchr(srcStr, '{');
        if (p1 == NULL)
        {
            log_debug("[dm] telecom_get_response_content....not Content-Length and no { ,fail, return \n");
            return -1;
        }

        p2 = strrchr(srcStr, '}');
        if (p2 == NULL)
        {
            return -1;
        }

        len = p2 - p1 + 1;
        if (len <= datalen)
        {
            memcpy(content, p1, len);
        }
        else
        {
            memcpy(content, p1, datalen);
            log_debug("[dm] content too long ,error\n");
        }
    }
    return ERR_SUCCESS;
}

/**
 * ƣtelecom_parse_response
 * Ӧ
 * ˵srcStr:Ӧ
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
int telecom_parse_response(char *srcStr)
{
    char data[RESPONSE_JSONDATA_LEN + 1] = {0};
    int state = 0;

    if (srcStr == NULL)
    {
        return ERR_RECV_ERROR;
    }

    state = telecom_parse_response_state(srcStr);
    if (state != 200)
    {
        log_debug("[dm] telecom_parse_response..state = %d, fail\n", state);
        return ERR_RECV_ERROR;
    }

    state = telecom_get_response_content(srcStr, data, RESPONSE_JSONDATA_LEN);
    if (state != ERR_SUCCESS)
    {
        log_debug("[dm] telecom_parse_response. fail\n");
        return ERR_RECV_ERROR;
    }
    log_debug("[dm] telecom_parse_response..data = %s \n", data);

    return telecom_parse_response_content(data);
}

/**
 * ƣtelecom_encode_http_head
 * httpͷ
 * ˵httpPacketData: sendSrcData:͵
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
static int telecom_encode_http_head(char *httpPacketData, DM_TELECOM_HTTP_DATA_INFO *sendSrcData)
{
    char data[BASE64_LEN] = {0};
    int len = 0;
    char buf[10] = {0};
    char hostname[64] = {0};

    if (httpPacketData == NULL)
    {
        return ERR_DM_HTTP_REQUEST_HANDLE_ERROR;
    }

    sc_cfg_get("hostName", hostname, sizeof(hostname));
    log_debug("[dm] telecom_encode_http_head senddata = %s \n", sendSrcData->dataBuffer);
    telecom_base64_encode(sendSrcData->dataBuffer, strlen(sendSrcData->dataBuffer), data, BASE64_LEN - 1);
    log_debug("[dm] telecom_encode_http_head base64 senddata = %s \n", data);
    len = strlen(data);
    snprintf(buf, sizeof(buf)-1, "%d", len); //klockworks issue.

    strcat(httpPacketData, "POST ");
    strcat(httpPacketData, TELECOM_DM_REQUEST_URL);
    strcat(httpPacketData, " HTTP/1.1\r\n");

    strcat(httpPacketData, "Host: ");
    //strcat(httpPacketData, ip);
    strcat(httpPacketData, hostname);
    strcat(httpPacketData, "\r\n");

    strcat(httpPacketData, "Content-Length: ");
    strcat(httpPacketData, buf);
    strcat(httpPacketData, "\r\n");

    strcat(httpPacketData, "Content-Type: application/encrypted-json\r\n");

    strcat(httpPacketData, "\r\n");
    strcat(httpPacketData, data);
    strcat(httpPacketData, "\r\n");

    log_debug("[dm] http_head: %s \n", httpPacketData);

    return ERR_SUCCESS;
}

/**
 * ƣtelecom_request_handle
 * httpӦ
 * ˵urlInfo:ַsendSrcData:recData:յӦ
 *   ֵ   ERR_SUCCESS:ɹ :ʧ
 * ˵
 */
int telecom_request_handle(DM_TELECOM_HTTP_URL_INFO *urlInfo, DM_TELECOM_HTTP_DATA_INFO *sendSrcData, DM_TELECOM_HTTP_DATA_INFO *recData)
{
    int retValue = -1;
    int  sockt_id = -1;

    log_debug("[dm]telecom_request_handle come in!\n");

    g_socke_flag = ERR_SUCCESS;

    while (1)
    {
        sockt_id = http_socket_create();
        if (sockt_id == -1)
        {
            break;
        }

        retValue = http_socket_connect(sockt_id, urlInfo);
        if (retValue != 0)
        {
            break;
        }

        retValue = http_socket_send(sockt_id, sendSrcData);
        if (retValue != 0)
        {
            break;
        }

        retValue = http_socket_select(sockt_id);
        if (retValue != 0)
        {
            break;
        }

        retValue = http_socket_recv(sockt_id, recData);
        if (retValue != 0)
        {
            break;
        }

        break;
    }

    http_socket_close(sockt_id);
    g_socke_flag = retValue;
    log_debug("[dm]telecom_request_handle come out! retValue =%d!\n", retValue);
    return retValue;
}

/**
 * ƣ telecom_https_request
 *  dmύעϢݹ
 * ˵
 *   ֵ ɹDCAMERA_OP_SUCCESSʧܷӦĴ
 * ˵ 
 */
int telecom_https_request(DM_TELECOM_HTTP_URL_INFO *urlInfo, DM_TELECOM_HTTP_DATA_INFO *sendSrcData)
{
    int retValue = -1;
    DM_TELECOM_HTTP_DATA_INFO recData = {0};
    char recDataBuffer[HTTP_HEAD_SZIE] = {0};

    printf("telecom_https_request enter!\n");
    CHECK_PARAM(!urlInfo || !sendSrcData || !sendSrcData->dataBuffer);

    log_debug("*************debug info**********************************");
    log_debug("url info portNum(%d), ipAdress(%s), hostName(%s)\n",
              urlInfo->portNum, urlInfo->ipAddr, urlInfo->hostName);
    log_debug("sendSrcdata(%s), sendSrcData->dataLen(%d)\n", sendSrcData->dataBuffer, sendSrcData->dataLen);

    memset(recDataBuffer, 0, HTTP_HEAD_SZIE);
    recData.dataBuffer = recDataBuffer;
    recData.dataLen = HTTP_HEAD_SZIE;

    retValue = telecom_request_handle(urlInfo, sendSrcData, &recData);
    return retValue;
}

