/************************************************************************
* Ȩ (C)2010, ͨѶɷ޹˾
*
* ļƣ zte_web_wan.c
* ļʶ
* ժҪ
* ˵
* ǰ汾 V0.1
*     ߣ zyt
* ڣ 2010-11-06
*
* ޸ļ¼1
* ޸ݣʼ汾
************************************************************************/

/**************************************************************************
* ޸ı : EC:617002790374
*    : chenjie10092374
* ޸ : 2014.6.13
* ޸ : ûֶҴʱϿʱܼʱֹԶŹ̵Ĵ
**************************************************************************/

/**************************************************************************
* ޸ı : EC:617002790374
*    : chenjie10092374
* ޸ : 2014.6.23
* ޸ : ûȡԶ
**************************************************************************/
/**************************************************************************
* ޸ı : EC:616000235589
*    : chenjie10092374
* ޸ : 2014.7.16
* ޸ : ʽ̱
**************************************************************************/
#include "zte_web_interface.h"

/************************************************************/
#define FEATRUE_WEB_DEBUG
#define FEATRUE_QMI_CONNECT

/************ALL the WAN CFG para****************************/
#define N_PPP_APN_MODEL            "apn_select"
#define V_PPP_APN_MODEL_AUTO       "auto"
#define V_PPP_APN_MODEL_MANUAL     "manual"
#define N_PPP_APN_NAME             "wan_apn"
#define N_PPP_DIAL_NUM             "wan_dial"
#define V_PPP_DNS_MODEL_AUTO       "auto"
#define V_PPP_DNS_MODEL_MANUAL     "manual"
#define N_PPP_PDP_TYPE             "pdp_type"
#define N_PPP_PDP_MODEL            "pdp_select"
#define V_PPP_PDP_MODEL_AUTO       "auto"
#define V_PPP_PDP_MODEL_MANUAL     "manual"
#define N_PPP_PDP_ADDR             "pdp_addr"
#define N_PPP_AUTH_MODEL           "ppp_auth_mode"
#define V_PPP_AUTH_MODEL_PAP       "pap"
#define V_PPP_AUTH_MODEL_CHAP      "chap"
#define N_PPP_USER_NAME            "ppp_username"
#define N_PPP_PASSWORD             "ppp_passtmp"
#define N_NET_SELECT               "net_select"
//#define N_NET_SELECT_NAME          "net_select_name"
#define N_NO_MODEM                 "modem_undetected"

#define TIME_STEP                         1
#define APNCONFIG_NUM_MAX                 10
#define APNCONFIG_ELEMENT_NUM             14
#define APNCONFIG_MEMORY                  1024
#define APNCONFIG_ELEMENT_MEMORY          64
#define IFSTREQUAL(str1, str2) (strcmp((str1), (str2))?0:1)
#define IFSTRNEQUAL(str1, str2, n) (strncmp((str1), (str2), (n))?0:1)



typedef struct {
	CHAR pre_mode[64];
	CHAR net_select_mode[64];
	CHAR net_select[64];
	CHAR m_netselect_save[64];
	CHAR m_netselect_contents[64];
	CHAR m_netselect_status[64];
} netSelectCfgNv;
/*************************function define******************************/

void apn_save_process_ex(webs_t wp);
void apn_delete_process_ex(webs_t wp);
void apn_set_default_with_profile_index_ex(webs_t wp);
void apn_set_default_process_ex(webs_t wp);
void apn_set_default_with_new_profile_ex(webs_t wp);
static void set_apn_to_cfg(APN_PROFILE *apn_profile);
static void set_ipv6_apn_to_cfg(IPV6_APN_PROFILE *apn_profile);
static void set_ipv4v6_apn_to_cfg(APN_PROFILE *apn_profile, IPV6_APN_PROFILE *ipv6_apn_profile);
static void get_apn_para_form_web(webs_t wp, APN_PROFILE *apn_profile);
static void get_ipv6_apn_para_form_web(webs_t wp, IPV6_APN_PROFILE *apn_profile);
static int zte_wan_auto_apn_set();
static int zte_wan_util_set_dial_roam_switch(const char_t *roam_set);


void zte_wan_connect_network(webs_t wp)
{
	char traffic_limit[NV_ITEM_STRING_LEN_10] = {0};
	char flux_month_total[NV_ITEM_STRING_LEN_50] = {0};
	char traffic_alined_delta[NV_ITEM_STRING_LEN_50] = {0};
	char traffic_month_total[NV_ITEM_STRING_LEN_50] = {0};
	long long int llflux_month_total = 0;
	long long int lltraffic_alined_delta = 0;
	long long int lltraffic_month_total = 0;

	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User connect network!\n"));

	sc_cfg_set("user_initiate_disconnect", "0");  //û״̬˳Ԥģʽ
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_PDP_ACT_REQ, 0, NULL, 0);

	sc_cfg_get("is_traffic_limit_on", &traffic_limit, sizeof(traffic_limit));
	sc_cfg_get("flux_month_total", &flux_month_total, sizeof(flux_month_total));
	sc_cfg_get("traffic_alined_delta", &traffic_alined_delta, sizeof(traffic_alined_delta));
	sc_cfg_get("traffic_month_total", &traffic_month_total, sizeof(traffic_month_total));

	llflux_month_total = atoll(&flux_month_total);
	lltraffic_alined_delta = atoll(&traffic_alined_delta);
	lltraffic_month_total = atoll(&traffic_month_total);

	if(llflux_month_total < 0 || llflux_month_total > LLONG_MAX-1){
        llflux_month_total = LLONG_MAX;
	}

	if(lltraffic_alined_delta < 0 || lltraffic_alined_delta > LLONG_MAX-1){
        lltraffic_alined_delta = LLONG_MAX;
	}

	if(lltraffic_month_total < 0 || lltraffic_month_total > LLONG_MAX-1){
        lltraffic_month_total = LLONG_MAX;
	}	

	if (0 == strcmp(&traffic_limit, "yes")
	    && llflux_month_total + lltraffic_alined_delta >= lltraffic_month_total * 1024 * 1024) {
		sc_cfg_set("keep_online_when_limited", "yes");
	}
	zte_write_result_to_web(wp, SUCCESS); //"success"
}

/*ֶ*/
void zte_wan_disconnect_network(webs_t wp)
{

	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User disconnect network!\n"));
	sc_cfg_set("user_initiate_disconnect", "1");   //ûϿ״̬Ԥģʽ

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_PDP_DEACT_REQ, 0, NULL, 0);
	zte_write_result_to_web(wp, SUCCESS);
}

/*ֶ*/
void zte_wan_set_network(webs_t wp)
{

	CHAR *pMccmnc       = NULL;
	CHAR *pNetType      = NULL;
	CHAR *pSubType      = NULL;
	CHAR curMccmnc[20]  = {0};
	CHAR curNetType[5]  = {0};
	CHAR curSubType[5]	= {0};

	pMccmnc     = websGetVar(wp, T("NetworkNumber"), T(""));
	pNetType    = websGetVar(wp, T("Rat"), T(""));
	pSubType	= websGetVar(wp, T("nSubrat"), T(""));

	if (('\0' == (*pMccmnc)) || ('\0' == (*pNetType))) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User set network %s!\n"), pMccmnc);
	slog(MISC_PRINT, SLOG_DEBUG,"LPC: wan_set_network, pSubType = %s \n", pSubType);
	(void)zte_web_read("current_rat", curNetType); //0:2G; 2:3G
	(void)zte_web_read("str_num_rplmn", curMccmnc);
	(void)zte_web_read("current_subrat", curSubType);

	if ((0 == strcmp(pMccmnc, curMccmnc)) && (0 == strcmp(pNetType, curNetType)) && (0 == strcmp(pSubType, curSubType))) {
		slog(MISC_PRINT, SLOG_DEBUG, "wan_set_network: to set network is equal to registered network."); /*lint !e26*/
		(void)zte_web_write("manual_netsel_flag", "1");
	} else {
		(void)zte_web_write("manual_netsel_flag", "");
	}
	(void)zte_web_write(NV_M_NETSELECT_CONTENTS, "");
	(void)zte_web_write("current_rat_tmp", pNetType);
	(void)zte_web_write("str_num_rplmn_tmp", pMccmnc);
	(void)zte_web_write("current_subrat_tmp", pSubType);
	//slog(MISC_PRINT,SLOG_DEBUG, "wan_set_network send message:ZUFI_MODULE_ID_AT_MAIN MSG_CMD_SET_NETWORK.");
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_NETWORK_SET_REQ, 0, NULL, 0);
	zte_write_result_to_web(wp, SUCCESS);
}


/*òģʽ*/
void zte_wan_set_connection_mode(webs_t wp)
{
	CHAR *pConnMode = NULL;
	CHAR *pRoamOption = NULL; //dial roam
	char_t ppp_status[CONFIG_DEFAULT_LENGTH] = {0};
	char traffic_limit[NV_ITEM_STRING_LEN_10] = {0};
	char flux_month_total[NV_ITEM_STRING_LEN_50] = {0};
	char traffic_alined_delta[NV_ITEM_STRING_LEN_50] = {0};
	char traffic_month_total[NV_ITEM_STRING_LEN_50] = {0};
	char pdp_dial_mode[NV_ITEM_STRING_LEN_10] = {0};

	long long int llflux_month_total = 0;
	long long int lltraffic_alined_delta = 0;
	long long int lltraffic_month_total = 0;	

	sc_cfg_get("ppp_status", &ppp_status, sizeof(ppp_status));


	pConnMode    = websGetVar(wp, "ConnectionMode", T(""));
	pRoamOption  = websGetVar(wp, T(NV_ROAM_SETTING_OPTION), NULL);

	if ('\0' == (*pConnMode)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User set connection mode %s!\n"), pConnMode);
	(void)zte_web_write(NV_DIAL_MODE, pConnMode);

	if (IFSTREQUAL(ppp_status, "ppp_disconnected")
	    && IFSTREQUAL(pConnMode, "manual_dial")) {
		sc_cfg_set("auto_reconnect", "0");
	}

	sc_cfg_get("is_traffic_limit_on", &traffic_limit, sizeof(traffic_limit));
	sc_cfg_get("flux_month_total", &flux_month_total, sizeof(flux_month_total));
	sc_cfg_get("traffic_alined_delta", &traffic_alined_delta, sizeof(traffic_alined_delta));
	sc_cfg_get("traffic_month_total", &traffic_month_total, sizeof(traffic_month_total));

	llflux_month_total = atoll(&flux_month_total);
	lltraffic_alined_delta = atoll(&traffic_alined_delta);
	lltraffic_month_total = atoll(&traffic_month_total);

	if(llflux_month_total < 0 || llflux_month_total > LLONG_MAX-1 ){
        llflux_month_total = LLONG_MAX;
	}

	if(lltraffic_alined_delta < 0 || lltraffic_alined_delta > LLONG_MAX-1){
        lltraffic_alined_delta = LLONG_MAX;
	}

	if(lltraffic_month_total < 0 || lltraffic_month_total > LLONG_MAX-1){
        lltraffic_month_total = LLONG_MAX;
	}	

	if (0 == strcmp(&traffic_limit, "yes")
	    && llflux_month_total + lltraffic_alined_delta >= lltraffic_month_total * 1024 * 1024) {
		sc_cfg_get(NV_DIAL_MODE, &pdp_dial_mode, sizeof(pdp_dial_mode));

		if (0 == strcmp(&pdp_dial_mode, "manual_dial")) {
			sc_cfg_set("auto_connect_when_limited", "no");
		} else if (0 == strcmp(&pdp_dial_mode, "auto_dial")) {
			sc_cfg_set("auto_connect_when_limited", "yes");
		}
	}
	//set dial roam switch
	if (-1 == zte_wan_util_set_dial_roam_switch(pRoamOption)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	//sc_cfg_save();
	zte_write_result_to_web(wp, SUCCESS);
	slog(MISC_PRINT, SLOG_DEBUG, "ZUFI_MODULE_ID_AT_MAIN!!!!set ppp_dial Mode:%s.\n", pConnMode);

}

/*Զѡʽ*/
void zte_wan_network_select(webs_t wp)
{
	char_t *netSelect = NULL;
	char_t *pre_mode = NULL;
	char_t ppp_status[CONFIG_DEFAULT_LENGTH] = {0};
	int tryCount = 0;
	netSelectCfgNv netSelectPreCfg = {0};
	char select_result[NV_ITEM_STRING_LEN_20] = {0};
	char buf[NV_ITEM_STRING_LEN_10] = {0};

	netSelect = websGetVar(wp, T("BearerPreference"), T(""));
	pre_mode = websGetVar(wp, T("pre_mode"), T(""));

	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User set network select %s!\n"), netSelect);
	if ('\0' == (*netSelect)) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	sc_cfg_get("ppp_status", &ppp_status, sizeof(ppp_status));
	if (ppp_status[0] != '\0') {
		if (!IFSTREQUAL(ppp_status, "ppp_disconnected") && !IFSTREQUAL(ppp_status, "ppp_ready")) {
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
	}

	(void)zte_web_read("pre_mode", netSelectPreCfg.pre_mode);
	(void)zte_web_read("net_select_mode", netSelectPreCfg.net_select_mode);
	(void)zte_web_read(N_NET_SELECT, netSelectPreCfg.net_select);
	(void)zte_web_read("m_netselect_save", netSelectPreCfg.m_netselect_save);
	(void)zte_web_read(NV_M_NETSELECT_CONTENTS, netSelectPreCfg.m_netselect_contents);
	(void)zte_web_read("m_netselect_status", netSelectPreCfg.m_netselect_status);

	(void)zte_web_write("pre_mode", pre_mode);
	(void)zte_web_write("net_select_mode", "auto_select");
	(void)zte_web_write(N_NET_SELECT, netSelect);
	(void)zte_web_write("m_netselect_save", "");
	(void)zte_web_write(NV_M_NETSELECT_CONTENTS, "");
	(void)zte_web_write("m_netselect_status", "");
	sc_cfg_set("net_select_result", "");
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_NET_SELECT_REQ, 0, NULL, 0);

	while (tryCount++ < 200) {
		memset(select_result, 0, sizeof(select_result));
		sc_cfg_get("net_select_result", select_result, sizeof(select_result));
		if (strcmp("", select_result) != 0) {
			break;
		}

		// 200*1000us
		usleep(200000);
	}

	slog(MISC_PRINT, SLOG_DEBUG,"wan_network_select: net_select_result = %s \n", select_result);
	if (strcmp("sucess", select_result) == 0) {
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		(void)zte_web_write("pre_mode", netSelectPreCfg.pre_mode);
		(void)zte_web_write("net_select_mode", netSelectPreCfg.net_select_mode);
		(void)zte_web_write(N_NET_SELECT, netSelectPreCfg.net_select);
		(void)zte_web_write("m_netselect_save", netSelectPreCfg.m_netselect_save);
		(void)zte_web_write(NV_M_NETSELECT_CONTENTS, netSelectPreCfg.m_netselect_contents);
		(void)zte_web_write("m_netselect_status", netSelectPreCfg.m_netselect_status);
		zte_write_result_to_web(wp, FAILURE);
	}

}

/*ֶ*/
void zte_wan_scan_network(webs_t wp)
{
	if (NULL == wp) {
		return;
	}

	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User scan network!\n"));

	(void)zte_web_write("net_select_mode", "manual_select");
	slog(MISC_PRINT, SLOG_NORMAL, "wan_scan_network send message ZUFI_MODULE_ID_AT_MAIN,MSG_CMD_WEB_REQ_NET_SELECT");
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_NET_SELECT_REQ, 0, NULL, 0);
	(void)zte_web_write("m_netselect_status", "manual_selecting");
	zte_write_result_to_web(wp, SUCCESS);

}

/**/
void zte_wan_data_limit_setting(webs_t wp)
{
	char *data_limit_switch = NULL;
	char *data_limit_type = NULL;
	char *data_limit_size = NULL;
	char *data_limit_percent = NULL;

	if (NULL == wp) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	data_limit_switch = websGetVar(wp, T("data_volume_limit_switch"), T(""));    /*0:disable;1:enable*/
	if (0 == strcmp(data_limit_switch, "0")) {
		slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User disable net data statistics!\n"));
		sc_cfg_set(NV_DATA_VOLUME_LIMIT_SWITCH, "0");
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_TRAFFIC_INFO_RESET, 0, NULL, 0);
		zte_write_result_to_web(wp, SUCCESS);
	} else if (0 == strcmp(data_limit_switch, "1")) {
		slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User enable net data statistics!\n"));
		data_limit_type = websGetVar(wp, T("data_volume_limit_unit"), T(""));    /*time/data*/
		data_limit_size = websGetVar(wp, T("data_volume_limit_size"), T(""));
		data_limit_percent = websGetVar(wp, T("data_volume_alert_percent"), T(""));    /*1-100*/

		//param validation check
		if ((0 != strcmp(data_limit_type, DATA_VOLUME_LIMIT_UNIT_TIME))
		    && (0 != strcmp(data_limit_type, DATA_VOLUME_LIMIT_UNIT_DATA))) {

			slog(MISC_PRINT, SLOG_ERR, "invalid value for data_limit_type:[%s]\n", data_limit_type); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}

		if ((0 == strcmp(data_limit_size, "")) || (0 == strcmp(data_limit_percent, ""))) {
			slog(MISC_PRINT, SLOG_ERR, "invalid value :[%s,%s]\n", data_limit_size, data_limit_percent); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}

		sc_cfg_set(NV_DATA_VOLUME_LIMIT_SWITCH, "1");
		sc_cfg_set(NV_DATA_VOLUME_LIMIT_UNIT, data_limit_type);
		sc_cfg_set(NV_DATA_VOLUME_LIMIT_SIZE, data_limit_size);
		sc_cfg_set(NV_DATA_VOLUME_ALERT_PERCENT, data_limit_percent);
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_TRAFFIC_INFO_RESET, 0, NULL, 0);
		zte_write_result_to_web(wp, SUCCESS);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "invalid value for data_limit_switch:[%s]\n", data_limit_switch); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
	}
}


/**********************************************************************
* Function:         apn_save_process_ex
* Description:      save the APN
* Input:            NULL
* Output:           NULL
* Return:           0 is invalid, 1 is valid
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2010/11/17   V1.0         maquan          first version
**********************************************************************/
void apn_save_process_ex(webs_t wp)
{
	int index_apn = 0;
	char currentApnIndex[8] = {0};
	APN_PROFILE newApn;
	IPV6_APN_PROFILE newIPV6Apn;
	memset(&newApn, 0, sizeof(APN_PROFILE));
	memset(&newIPV6Apn, 0, sizeof(IPV6_APN_PROFILE));

	slog(MISC_PRINT, SLOG_NORMAL, "come get_apn_para_form_web \n"); /*lint !e26*/
	get_apn_para_form_web(wp, &newApn);
	get_ipv6_apn_para_form_web(wp, &newIPV6Apn);

	index_apn = atoi(websGetVar(wp, "index", T("")));
	slog(MISC_PRINT, SLOG_DEBUG, "index_apn=%d \n", index_apn); /*lint !e26*/
	snprintf(currentApnIndex, sizeof(currentApnIndex) , "%d", index_apn);
	slog(MISC_PRINT, SLOG_DEBUG, "come set_apn_profile_by_index \n"); /*lint !e26*/

	set_apn_profile_by_index(index_apn, &newApn);
	set_apn_prof_aes_by_index(index_apn, &newApn);
	set_ipv6_apn_profile_by_index(index_apn, &newIPV6Apn);
	set_ipv6_apn_prof_aes_by_index(index_apn, &newIPV6Apn);

}

/**********************************************************************
* Function:         apn_delete_process_ex
* Description:      delete apn
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2010/11/17   V1.0         maquan          first version
* 2011/01/15   V1.0         qiuzhenhui      modify
**********************************************************************/
void apn_delete_process_ex(webs_t wp)
{
	char apn_default_index[APNCONFIG_ELEMENT_MEMORY] = {0};
	char apn_buf[APNCONFIG_ELEMENT_MEMORY] = {0};
	int i;

	int apn_index = atoi(websGetVar(wp, "index", T("")));
	if(apn_index<0 || apn_index> INT_MAX-1)
	{
	    apn_index = 0;
	}
	
	sc_cfg_get("apn_index", &apn_buf, sizeof(apn_buf));
	int apn_index_setdefault = atoi(&apn_buf);
	if(apn_index_setdefault<0 || apn_index_setdefault> INT_MAX-1)
	{
	    apn_index_setdefault = 0;
	}

	for (i = apn_index; i < APNCONFIG_NUM_MAX; i++) {
		char profile1[APNCONFIG_MEMORY] = {0};
		char profile2[APNCONFIG_MEMORY] = {0};
		char ipv6profile1[APNCONFIG_MEMORY] = {0};
		char ipv6profile2[APNCONFIG_MEMORY] = {0};
		char next_profile[APNCONFIG_MEMORY] = {0};
		char ipv6_next_profile[APNCONFIG_MEMORY] = {0};

		sprintf(profile1, "APN_config%d", i);
		sprintf(profile2, "APN_config%d", i + 1);

		sprintf(ipv6profile1, "ipv6_APN_config%d", i);
		sprintf(ipv6profile2, "ipv6_APN_config%d", i + 1);

		sc_cfg_get(profile2, &next_profile, sizeof(next_profile));
		sc_cfg_get(ipv6profile2, &ipv6_next_profile, sizeof(ipv6_next_profile));


#ifdef FEATRUE_WEB_DEBUG
		slog(MISC_PRINT, SLOG_DEBUG, "profile1=%s\n", profile1); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, "profile2=%s\n", profile2); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, "next_profile=%s\n", next_profile); /*lint !e26*/
#endif
		if (strcmp(next_profile, "")) {
			sc_cfg_set(profile1, next_profile);
		} else {
			sc_cfg_set(profile1, "");
		}


		if (strcmp(ipv6_next_profile, "")) {
			sc_cfg_set(ipv6profile1, ipv6_next_profile);
		} else {
			sc_cfg_set(ipv6profile1, "");
		}


	} //endof delete
	for (i = apn_index; i < APNCONFIG_NUM_MAX; i++) {
		char profile1[APNCONFIG_MEMORY] = {0};
		char profile2[APNCONFIG_MEMORY] = {0};
		char ipv6profile1[APNCONFIG_MEMORY] = {0};
		char ipv6profile2[APNCONFIG_MEMORY] = {0};
		char next_profile[APNCONFIG_MEMORY] = {0};
		char ipv6_next_profile[APNCONFIG_MEMORY] = {0};

		sprintf(profile1, "APN_configtmp%d", i);
		sprintf(profile2, "APN_configtmp%d", i + 1);

		sprintf(ipv6profile1, "ipv6_APN_configtmp%d", i);
		sprintf(ipv6profile2, "ipv6_APN_configtmp%d", i + 1);

		sc_cfg_get(profile2, &next_profile, sizeof(next_profile));
		sc_cfg_get(ipv6profile2, &ipv6_next_profile, sizeof(ipv6_next_profile));


#ifdef FEATRUE_WEB_DEBUG
		slog(MISC_PRINT, SLOG_DEBUG, "profile1tmp=%s\n", profile1); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, "profile2tmp=%s\n", profile2); /*lint !e26*/
		slog(MISC_PRINT, SLOG_DEBUG, "next_profiletmp=%s\n", next_profile); /*lint !e26*/
#endif
		if (strcmp(next_profile, "")) {
			sc_cfg_set(profile1, next_profile);
		} else {
			sc_cfg_set(profile1, "");
		}


		if (strcmp(ipv6_next_profile, "")) {
			sc_cfg_set(ipv6profile1, ipv6_next_profile);
		} else {
			sc_cfg_set(ipv6profile1, "");
		}


	} //endof delete
	if (0 < apn_index_setdefault - apn_index) {
		apn_index_setdefault -= 1;
		sprintf(apn_default_index, "%d", apn_index_setdefault);
		sc_cfg_set("apn_index", apn_default_index);
	} else if (apn_index_setdefault == apn_index) {
		apn_index_setdefault = 0;
		sprintf(apn_default_index, "%d", apn_index_setdefault);
		sc_cfg_set("apn_index", apn_default_index);
	}
#ifdef FEATRUE_WEB_DEBUG
    memset(apn_buf, 0, sizeof(apn_buf));
    sc_cfg_get("apn_index", apn_buf, sizeof(apn_buf));
    slog(MISC_PRINT, SLOG_DEBUG, "Del action apn_index=%s\n", apn_buf); /*lint !e26*/

#endif

}

/**********************************************************************
* Function:         apn_delete_process
* Description:      delete apn
* Input:            NULL
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2010/11/17   V1.0         maquan          first version
* 2011/01/15   V1.0         qiuzhenhui      modify
**********************************************************************/
void apn_set_default_with_profile_index_ex(webs_t wp)
{
	int index_apn = 0;
	char_t *pdp_type = NULL;

	pdp_type = websGetVar(wp, T("pdp_type"), T(""));

	APN_PROFILE  newProfile;
	IPV6_APN_PROFILE  newIpv6Profile;
	memset(&newProfile, 0, sizeof(APN_PROFILE));
	memset(&newIpv6Profile, 0, sizeof(IPV6_APN_PROFILE));
	char_t *apn_mode = NULL;

	index_apn = atoi(websGetVar(wp, "index", T("")));
	apn_mode = websGetVar(wp, T("apn_mode"), T(""));

	sc_cfg_set("auto_apn_index", websGetVar(wp, "auto_apn_index", T("0")));
	if (0 == strcmp(apn_mode, "auto")) {
		slog(MISC_PRINT, SLOG_DEBUG, "apn_mode=%s\n", apn_mode); /*lint !e26*/
		get_autoapn_profile(&newProfile);
		set_apn_to_cfg(&newProfile);
	} else {
		if (0 == strcmp(pdp_type, "IPv6")) {
			slog(MISC_PRINT, SLOG_DEBUG, "come to get_ipv6apn_profile_by_index"); /*lint !e26*/

			get_ipv6apn_profile_by_index(index_apn, &newIpv6Profile);
			set_ipv6_apn_to_cfg(&newIpv6Profile);

		} else if (0 == strcmp(pdp_type, "IPv4v6")) {

			slog(MISC_PRINT, SLOG_DEBUG, "come to get_ipv4v6apn_profile_by_index"); /*lint !e26*/
			get_ipv4v6apn_profile_by_index(index_apn, &newProfile, &newIpv6Profile);
			set_ipv4v6_apn_to_cfg(&newProfile, &newIpv6Profile);
		} else {
			slog(MISC_PRINT, SLOG_DEBUG, "come to get_ipv4apn_profile_by_index"); /*lint !e26*/
			get_apn_profile_by_index(index_apn, &newProfile);
			set_apn_to_cfg(&newProfile);
		}
		sc_cfg_set("apn_index", websGetVar(wp, "index", T("")));
	}


	//send message to MainControl to infrom modify apn
	//zte_send_message(ZUFI_MODULE_ID_AT_MAIN,MSG_CMD_WEB_REQ_APN_SET,0,0);
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_APN_SET_REQ, 0, NULL, 0);
}

/**********************************************************************
* Function:         get_apn_para_form_web
* Description:      get apn parametre from web
* Input:            wp
* Output:           apn para struct pointer
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2010/11/17   V1.0         maquan          first version
**********************************************************************/
static void get_apn_para_form_web(webs_t wp, APN_PROFILE *apn_profile)
{
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "NULL para input"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (zte_apn_param_check(wp, "ipv4") < 0) {
		slog(MISC_PRINT, SLOG_ERR, "ipv4 para input is no safe"); /*lint !e26*/
		return;
	}

	strncpy(apn_profile->profile_name, websGetVar(wp, T("profile_name"), T("")), sizeof(apn_profile->profile_name)-1);
	strncpy(apn_profile->apn_name, websGetVar(wp, T("wan_apn"), T("")), sizeof(apn_profile->apn_name)-1);
	strncpy(apn_profile->apn_select, websGetVar(wp, T("apn_select"), T("")), sizeof(apn_profile->apn_select)-1);
	strncpy(apn_profile->dial_num, websGetVar(wp, T("wan_dial"), T("")), sizeof(apn_profile->dial_num)-1);
	strncpy(apn_profile->ppp_auth_mode, websGetVar(wp, T("ppp_auth_mode"), T("")), sizeof(apn_profile->ppp_auth_mode)-1);
	strncpy(apn_profile->ppp_username, websGetVar(wp, T("ppp_username"), T("")), sizeof(apn_profile->ppp_username)-1);
	strncpy(apn_profile->ppp_passwd, websGetVar(wp, T("ppp_passtmp"), T("")), sizeof(apn_profile->ppp_passwd)-1);
    strncpy(apn_profile->pdp_type, websGetVar(wp, T("pdp_type"), T("")), sizeof(apn_profile->pdp_type)-1);
	strncpy(apn_profile->pdp_select, websGetVar(wp, T("pdp_select"), T("")), sizeof(apn_profile->pdp_select)-1);
	strncpy(apn_profile->pdp_addr, websGetVar(wp, T("pdp_addr"), T("")), sizeof(apn_profile->pdp_addr)-1);
	strncpy(apn_profile->dns_mode, websGetVar(wp, T("dns_mode"), T("")), sizeof(apn_profile->dns_mode)-1);
	strncpy(apn_profile->prefer_dns_manual, websGetVar(wp, T("prefer_dns_manual"), T("")), sizeof(apn_profile->prefer_dns_manual)-1);
	strncpy(apn_profile->standby_dns_manual, websGetVar(wp, T("standby_dns_manual"), T("")), sizeof(apn_profile->standby_dns_manual)-1);

	return;
}


static void get_ipv6_apn_para_form_web(webs_t wp, IPV6_APN_PROFILE *apn_profile)
{
	if (NULL == wp) {
		slog(MISC_PRINT, SLOG_ERR, "NULL para input"); /*lint !e26*/
		return;
	}

	if (zte_apn_param_check(wp, "ipv6") < 0) {
		slog(MISC_PRINT, SLOG_ERR, "ipv6 para input is no safe"); /*lint !e26*/
		return;
	}

	strncpy(apn_profile->profile_name, websGetVar(wp, T("profile_name"), T("")), sizeof(apn_profile->profile_name)-1);
	strncpy(apn_profile->apn_name, websGetVar(wp, T("ipv6_wan_apn"), T("")), sizeof(apn_profile->apn_name)-1);
	strncpy(apn_profile->apn_select, websGetVar(wp, T("apn_select"), T("")), sizeof(apn_profile->apn_select)-1);
	strncpy(apn_profile->dial_num, websGetVar(wp, T("wan_dial"), T("")), sizeof(apn_profile->dial_num)-1);
	strncpy(apn_profile->ppp_auth_mode, websGetVar(wp, T(NV_IPV6_PPP_AUTH_MODE), T("")), sizeof(apn_profile->ppp_auth_mode)-1);
	strncpy(apn_profile->ppp_username, websGetVar(wp, T("ipv6_ppp_username"), T("")), sizeof(apn_profile->ppp_username)-1);
	strncpy(apn_profile->ppp_passwd, websGetVar(wp, T("ipv6_ppp_passtmp"), T("")), sizeof(apn_profile->ppp_passwd)-1);
	strncpy(apn_profile->pdp_type, websGetVar(wp, T("pdp_type"), T("")), sizeof(apn_profile->pdp_type)-1);
	strncpy(apn_profile->pdp_select, websGetVar(wp, T("pdp_select"), T("")), sizeof(apn_profile->pdp_select)-1);
	strncpy(apn_profile->pdp_addr, websGetVar(wp, T("pdp_addr"), T("")), sizeof(apn_profile->pdp_addr)-1);
	strncpy(apn_profile->dns_mode, websGetVar(wp, T("ipv6_dns_mode"), T("")), sizeof(apn_profile->dns_mode)-1);
	strncpy(apn_profile->prefer_dns_manual, websGetVar(wp, T("ipv6_prefer_dns_manual"), T("")), sizeof(apn_profile->prefer_dns_manual)-1);
	strncpy(apn_profile->standby_dns_manual, websGetVar(wp, T("ipv6_standby_dns_manual"), T("")), sizeof(apn_profile->standby_dns_manual)-1);

	return;
}

int zte_apn_param_check(webs_t  wp, char * type)
{
	char *profile_name = NULL;
	char *wan_apn = NULL;
	char *ppp_username = NULL;
	char *ppp_passwd = NULL;

	if (0 == strcmp("ipv4", type)) {
		profile_name = websGetVar(wp, T("profile_name"), T(""));
		wan_apn = websGetVar(wp, T("wan_apn"), T(""));
		ppp_username = websGetVar(wp, T("ppp_username"), T(""));
		ppp_passwd = websGetVar(wp, T("ppp_passtmp"), T(""));
		if (DATA_NO_SAFE == zte_Safe_noSpecialChar(profile_name)
		    || DATA_NO_SAFE == zte_Safe_noSpecialChar(wan_apn)
		    || DATA_NO_SAFE == zte_Safe_noSpecialChar(ppp_username)
		    || DATA_NO_SAFE == zte_Safe_noSpecialChar(ppp_passwd)
		   ) {
			slog(MISC_PRINT, SLOG_ERR, "Get Data is no Safe:ivp4\n"); /*lint !e26*/
			return -1;
		} else {
			slog(MISC_PRINT, SLOG_DEBUG, "Get Data is Safe:ivp6\n"); /*lint !e26*/
			return 1;
		}
	} else if (0 == strcmp("ipv6", type)) {
		profile_name = websGetVar(wp, T("profile_name"), T(""));
		wan_apn = websGetVar(wp, T("ipv6_wan_apn"), T(""));
		ppp_username = websGetVar(wp, T("ipv6_ppp_username"), T(""));
		ppp_passwd = websGetVar(wp, T("ipv6_ppp_passtmp"), T(""));
		if (DATA_NO_SAFE == zte_Safe_noSpecialChar(profile_name)
		    || DATA_NO_SAFE == zte_Safe_noSpecialChar(wan_apn)
		    || DATA_NO_SAFE == zte_Safe_noSpecialChar(ppp_username)
		    || DATA_NO_SAFE == zte_Safe_noSpecialChar(ppp_passwd)
		   ) {
			slog(MISC_PRINT, SLOG_ERR, "Get Data is no Safe:ipv6\n"); /*lint !e26*/
			return -1;
		} else {
			slog(MISC_PRINT, SLOG_DEBUG, "Get Data is Safe:ipv6\n"); /*lint !e26*/
			return 1;
		}
	}
	slog(MISC_PRINT, SLOG_DEBUG, "Get Data is Safe:no ipv4 or ivp6\n"); /*lint !e26*/
	return 0;
}



/**********************************************************************
* Function:         set_apn_to_cfg
* Description:      set apn para to CFG
* Input:            apn parametre struct pointer
* Output:           NULL
* Return:           NULL
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2010/11/17   V1.0         maquan          first version
**********************************************************************/
static void set_apn_to_cfg(APN_PROFILE *apn_profile)
{

	if (NULL == apn_profile) {
		slog(MISC_PRINT, SLOG_ERR, " NULL para input!!"); /*lint !e26*/
		return;
	}
	slog(MISC_PRINT, SLOG_DEBUG, "wan_apn==%s", apn_profile->apn_name); /*lint !e26*/
	sc_cfg_set("m_profile_name", apn_profile->profile_name);
	sc_cfg_set("wan_apn", apn_profile->apn_name);
	sc_cfg_set("apn_select", apn_profile->apn_select);
	sc_cfg_set("wan_dial", apn_profile->dial_num);
	sc_cfg_set("ppp_auth_mode", apn_profile->ppp_auth_mode);
	sc_cfg_set("ppp_username", apn_profile->ppp_username);
	sc_cfg_set("ppp_passtmp", apn_profile->ppp_passwd);
	sc_cfg_set("pdp_type", apn_profile->pdp_type);
	sc_cfg_set("ipv6_pdp_type", apn_profile->pdp_type);
	sc_cfg_set("pdp_select", apn_profile->pdp_select);
	sc_cfg_set("pdp_addr", apn_profile->pdp_addr);
	apn_encrypt_code();

	return;
}

static void set_ipv6_apn_to_cfg(IPV6_APN_PROFILE *apn_profile)
{
	slog(MISC_PRINT, SLOG_DEBUG, "set_ipv6_apn_to_cfg"); /*lint !e26*/
	if (NULL == apn_profile) {
		slog(MISC_PRINT, SLOG_ERR, " NULL para input!!"); /*lint !e26*/
		return;
	}
	slog(MISC_PRINT, SLOG_DEBUG, "wan_apn==%s", apn_profile->apn_name); /*lint !e26*/
	sc_cfg_set("m_profile_name", apn_profile->profile_name);
	sc_cfg_set("ipv6_wan_apn", apn_profile->apn_name);
	sc_cfg_set("apn_select", apn_profile->apn_select);
	sc_cfg_set("wan_dial", apn_profile->dial_num);
	sc_cfg_set(NV_IPV6_PPP_AUTH_MODE, apn_profile->ppp_auth_mode);
	sc_cfg_set("ipv6_ppp_username", apn_profile->ppp_username);
	sc_cfg_set("ipv6_ppp_passtmp", apn_profile->ppp_passwd);
	sc_cfg_set("pdp_type", apn_profile->pdp_type);
	sc_cfg_set("ipv6_pdp_type", apn_profile->pdp_type);
	sc_cfg_set("pdp_select", apn_profile->pdp_select);
	sc_cfg_set("pdp_addr", apn_profile->pdp_addr);
	ipv6apn_encrypt_code();

	return;
}


static void set_ipv4v6_apn_to_cfg(APN_PROFILE *apn_profile, IPV6_APN_PROFILE *ipv6_apn_profile)
{

	if (NULL == apn_profile) {
		slog(MISC_PRINT, SLOG_ERR, " NULL para input!!"); /*lint !e26*/
		return;
	}
	sc_cfg_set("m_profile_name", apn_profile->profile_name);
	sc_cfg_set("wan_apn", apn_profile->apn_name);
	sc_cfg_set("apn_select", apn_profile->apn_select);
	sc_cfg_set("wan_dial", apn_profile->dial_num);
	sc_cfg_set("ppp_auth_mode", apn_profile->ppp_auth_mode);
	sc_cfg_set("ppp_username", apn_profile->ppp_username);
	sc_cfg_set("ppp_passtmp", apn_profile->ppp_passwd);
	sc_cfg_set("pdp_type", apn_profile->pdp_type);
	sc_cfg_set("ipv6_pdp_type", apn_profile->pdp_type);
	sc_cfg_set("pdp_select", apn_profile->pdp_select);
	sc_cfg_set("pdp_addr", apn_profile->pdp_addr);
	apn_encrypt_code();

	if (NULL == ipv6_apn_profile) {
		slog(MISC_PRINT, SLOG_ERR, " NULL para input!!"); /*lint !e26*/
		return;
	}
	sc_cfg_set("m_profile_name", ipv6_apn_profile->profile_name);
	sc_cfg_set("ipv6_wan_apn", ipv6_apn_profile->apn_name);
	sc_cfg_set("apn_select", ipv6_apn_profile->apn_select);
	sc_cfg_set("wan_dial", ipv6_apn_profile->dial_num);
	sc_cfg_set(NV_IPV6_PPP_AUTH_MODE, ipv6_apn_profile->ppp_auth_mode);
	sc_cfg_set("ipv6_ppp_username", ipv6_apn_profile->ppp_username);
	sc_cfg_set("ipv6_ppp_passtmp", ipv6_apn_profile->ppp_passwd);
	sc_cfg_set("pdp_type", apn_profile->pdp_type);
	sc_cfg_set("ipv6_pdp_type", ipv6_apn_profile->pdp_type);
	sc_cfg_set("pdp_select", ipv6_apn_profile->pdp_select);
	sc_cfg_set("pdp_addr", ipv6_apn_profile->pdp_addr);
	ipv6apn_encrypt_code();
	return;
}

/**********************************************************************
* Function:         zte_wan_data_statistics_clear_process
* Description:      to clear the statistics
* Input:            the web para
* Output:
* Return:
* Others:         add form uFi
* Modify Date   Version     Author          Modification
* -----------------------------------------------

**********************************************************************/
void zte_wan_data_statistics_clear_process(webs_t wp, char_t *path, char_t *query)
{
	long nowtime;
	if (NULL == wp) {
		return;
	}

	slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User clear net data statistics!\n"));
	/*start added by jhy Nov 28, 2013*/
	(void)zte_web_write("realtime_tx_thrpt", "0");
	(void)zte_web_write("realtime_rx_thrpt", "0");

	(void)zte_web_write("realtime_tx_bytes", "0");
	(void)zte_web_write("realtime_rx_bytes", "0");
	(void)zte_web_write("CTotal_vol", "0");
	(void)zte_web_write("realtime_time", "0");


	time(&nowtime);
	char lastConectedTimeStr[16] = {0};
	sprintf(lastConectedTimeStr, "%d", nowtime);
	sc_cfg_set("ppp_start_time", lastConectedTimeStr);
	sc_cfg_set("syn_ppp_total", "0");

	(void)zte_web_write("monthly_tx_bytes", "0");
	(void)zte_web_write("monthly_rx_bytes", "0");
	(void)zte_web_write("flux_month_total", "0");
	(void)zte_web_write("monthly_time", "0");
	(void)zte_web_write("MonthlyConTime_Last", "0");
	(void)zte_web_write("traffic_alined_delta", "0");
	(void)zte_web_write("duraConTime_before_time_modify", "0");

	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_TRAFFIC_INFO_RESET, 0, NULL, 0);
	slog(MISC_PRINT, SLOG_NORMAL, "wan_data_statistics_clear_process: send CURR_TOTAL_WIFI_DATA to mc success."); /*lint !e26*/
	zte_write_result_to_web(wp, SUCCESS);
}


/**********************************************************************
 * Function:         zte_form_multi_apn_proc_ex
 * Description:      to handle the auto or manual apn set for ipv4ipv6
 * Input:            the web para
 * Output:
 * Return:
 * Others:
 * Modify Date   Version     Author          Modification
 * -----------------------------------------------
 *
 **********************************************************************/

void zte_form_multi_apn_proc_ex(webs_t wp)
{
	char_t *apn_mode  = NULL;
	char_t *apn_action = NULL;
	//int result = 0;

	// Get the params from pages
	apn_mode = websGetVar(wp, T("apn_mode"), T(""));  /* auto | manual  */
	apn_action = websGetVar(wp, T("apn_action"), T(""));  // save | delete | set_default

	slog(MISC_PRINT, SLOG_DEBUG, "apn_mode:[%s], apn_action[%s] \n", apn_mode, apn_action); /*lint !e26*/

	//not to check apn_action,auto apn will not need it
	if ('\0' == *apn_mode) {
		slog(MISC_PRINT, SLOG_ERR, "apn_mode is empty. \n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}
	/* AUTO APN */
	if (0 == strcmp(ZTE_WEB_ACT_AUTO, apn_mode)) {
		sc_cfg_set("auto_apn_index", websGetVar(wp, "auto_apn_index", T("0")));
		if (0 == zte_wan_auto_apn_set()) {
			zte_write_result_to_web(wp, SUCCESS);
		} else {
			zte_write_result_to_web(wp, FAILURE);
		}
		return;
	} else if (0 == strcmp(ZTE_WEB_ACT_MANUAL, apn_mode)) {
		if (0 == strcmp(apn_action, ZTE_WEB_ACT_SAVE)) {
			slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User save apn! \n"));
			apn_save_process_ex(wp);
		} else if (0 == strcmp(apn_action, ZTE_WEB_ACT_SETDEFAULT)) {
			slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User set default apn! \n"));
			zte_web_write("apn_mode", ZTE_WEB_ACT_MANUAL);
			apn_set_default_process_ex(wp);
			//apn_set_default_with_profile_index_ex(wp);
		} else if (0 == strcmp(apn_action, ZTE_WEB_ACT_DELETE)) {
			slog(MISC_PRINT, SLOG_NORMAL, T("UFIx User delete apn! \n"));
			apn_delete_process_ex(wp);
		} else {
			slog(MISC_PRINT, SLOG_ERR, "invalid apn_action. \n"); /*lint !e26*/
			zte_write_result_to_web(wp, FAILURE);
			return;
		}
	} else {
		slog(MISC_PRINT, SLOG_ERR, "invalid apn_mode. \n"); /*lint !e26*/
		zte_write_result_to_web(wp, FAILURE);
		return;
	}


	zte_write_result_to_web(wp, SUCCESS);

	return;

}


static int zte_wan_auto_apn_set()
{
	//int count = 0;
	APN_PROFILE  newProfile;
	zte_web_write("apn_mode", ZTE_WEB_ACT_AUTO);
	memset(&newProfile, 0, sizeof(newProfile));
	slog(MISC_PRINT, SLOG_NORMAL,"LPC: wan_auto_apn_set enter! \n");
	get_autoapn_profile(&newProfile);
	set_apn_to_cfg(&newProfile);
	//send message to MainControl to infrom modify apn
#if 0	// kw 3
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_APN_SET_REQ, 0, NULL, 0);
	return 0;
#else
    return ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_APN_SET_REQ, 0, NULL, 0);
#endif
}



void apn_set_default_process_ex(webs_t wp)
{
	char_t *webAction = NULL;
	webAction = websGetVar(wp, T("set_default_flag"), T(""));
	slog(MISC_PRINT, SLOG_NORMAL, "goahead apn_set_default_process apn_action=%s.\n", webAction);

	if (0 == strcmp(webAction, APN_ONLY_SET_DEFAULT)) { //profile_name
		apn_set_default_with_profile_index_ex(wp);
	} else if (0 == strcmp(webAction, APN_SAVE_AND_SET_DEFAULT)) {
		apn_set_default_with_new_profile_ex(wp);
	} else {
		slog(MISC_PRINT, SLOG_DEBUG, "invalid set_default_flag[%s].", webAction);
		return ;
	}

}
void apn_set_default_with_new_profile_ex(webs_t wp)
{
	int index_apn = 0;
	APN_PROFILE newApn;
	IPV6_APN_PROFILE  newIpv6Profile;

	char_t *pdp_type = NULL;

	pdp_type = websGetVar(wp, T("pdp_type"), T(""));



	memset(&newApn, 0, sizeof(APN_PROFILE));
	memset(&newIpv6Profile, 0, sizeof(IPV6_APN_PROFILE));

	index_apn = atoi(websGetVar(wp, "index", T("")));

	get_apn_para_form_web(wp, &newApn);
	set_apn_profile_by_index(index_apn, &newApn);
	set_apn_prof_aes_by_index(index_apn, &newApn);

	get_ipv6_apn_para_form_web(wp, &newIpv6Profile);
	set_ipv6_apn_profile_by_index(index_apn, &newIpv6Profile);
	set_ipv6_apn_prof_aes_by_index(index_apn, &newIpv6Profile);

	if (0 == strcmp(pdp_type, "IPv6")) {
		set_ipv6_apn_to_cfg(&newIpv6Profile);
	} else if (0 == strcmp(pdp_type, "IPv4v6")) {
		set_ipv4v6_apn_to_cfg(&newApn, &newIpv6Profile);
	} else {
		set_apn_to_cfg(&newApn);
	}


	slog(MISC_PRINT, SLOG_NORMAL, "apn_set_default_with_new_profile_ex index_apn=%d", index_apn);

	sc_cfg_set("apn_index", websGetVar(wp, "index", T("")));
	//send message to MainControl to infrom modify apn
	ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_APN_SET_REQ, 0, NULL, 0);

}

/**********************************************************************
* Function:         zte_wan_util_set_dial_roam_switch
* Description:      to set the dial roam switch
* Input:            roam_set: to set value
* Output:
* Return:           -1:fail;0:success
* Others:
* Modify Date   Version     Author          Modification
* -----------------------------------------------
* 2012/09/19    V1.0        chenyi       first version
**********************************************************************/
static int zte_wan_util_set_dial_roam_switch(const char_t *roam_set)
{
	if (NULL == roam_set) {
		return 0;//user don't care it ,so return 0
	}

	if ('\0' == (*roam_set)) {
		slog(MISC_PRINT, SLOG_ERR, "dial roam set is empty."); /*lint !e26*/
		return -1;
	}

	if (ZTE_NVIO_DONE != zte_web_write(NV_ROAM_SETTING_OPTION, roam_set)) { /*lint !e605*/
		slog(MISC_PRINT, SLOG_ERR, "write nv [%s] fail.", NV_ROAM_SETTING_OPTION); /*lint !e26*/
		return -1;
	} else {
		ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_AT_CTL, MSG_CMD_ROAM_SET_REQ, 0, NULL, 0);
		return 0;
	}
}


void zte_wan_data_flow_calibration_manual(webs_t wp)
{
	char *p_data = NULL;
	float time = 0;
	char buf[NV_ITEM_STRING_LEN_50] = {0};
	unsigned long long data = 0;
	if (NULL == wp) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	p_data = websGetVar(wp, T("calibration_way"), NULL);

	slog(MISC_PRINT, SLOG_NORMAL,"wan_data_flow_calibration_manual calibration_way = %s\n", p_data);
	if (p_data == NULL) {
		zte_write_result_to_web(wp, FAILURE);
		return;
	}

	if (0 == strcmp(p_data, "time")) {
		p_data = websGetVar(wp, T("time"), NULL);
		if (p_data != NULL) {
			time = atof(p_data);
			sprintf(buf, "%ld", (long)(time * 60 * 60));
			sc_cfg_set("monthly_time", buf);
			slog(MISC_PRINT, SLOG_DEBUG,"wan_data_flow_calibration_manual time:value = %f, buf = %s\n", time, buf);
			zte_write_result_to_web(wp, SUCCESS);
			ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_TRAFFIC_INFO_RESET, 0, NULL, 0);
			return;
		}
	} else if (0 == strcmp(p_data, "data")) {
		p_data = websGetVar(wp, T("data"), NULL);
		if (p_data != NULL) {
			float data_tmp = 0;
			data_tmp = atof(p_data);
			//data = strtoll(p_data,NULL,10);
			data = (unsigned long long)(data_tmp * 1024 * 1024);
			errno = 0;
			long long ret_strtoll = strtoll(p_data, NULL, 10);
			if (errno == ERANGE)// kw ERRNO.NOT_CHECKED
			{
				slog(MISC_PRINT, SLOG_ERR,"strtoll errno %d: %s\n", errno, strerror(errno));
			}
			slog(MISC_PRINT, SLOG_DEBUG,"wan_data_flow_calibration_manual data:111 data = %lld, %lld\n", data, ret_strtoll);
			sprintf(buf, "%lld", data);
			sc_cfg_set("monthly_tx_bytes", "0");
			sc_cfg_set("monthly_rx_bytes", buf);
			sc_cfg_set("flux_month_total", buf);
			zte_write_result_to_web(wp, SUCCESS);
			//flux_call_cb(CB_MSG_MMI_TRAFFIC_INFO_RESET, NULL ,0);
			ipc_send_message(MODULE_ID_WEB_CGI, MODULE_ID_MMI, MSG_CMD_TRAFFIC_INFO_RESET, 0, NULL, 0);
			return;
		}
	}

	zte_write_result_to_web(wp, FAILURE);
}
