/**
 * 
 * @file      amt_func_test.c
 * @brief     
 *            This file is part of FTM.
 *            AMTӦò
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2020/11/25
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2020/11/25  1.0      liu.xin       Create file
 * ---------------------------------------------------------------------------
 * 
 * 
 */


#include <sys/msg.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h> 
#include <semaphore.h>
#include <time.h>
#include <sys/stat.h>
#include "softap_api.h"
#include "kwatch_msg.h"
#include "amt.h"
#include "amt_func_test.h"
#include "port_com.h"





static fd_set g_uart_fdsread;
static int g_uart_fd_max = 0;
static int g_fd_uart0 = -1;
static int g_fd_uart1 = -1;
static int g_fd_uart2 = -1;
static int g_close_uart = 0;





static void set_fd(int fd)
{
    FD_SET(fd, &g_uart_fdsread);
    if (fd >= g_uart_fd_max)
    {
        g_uart_fd_max = fd + 1;
    }
}

static void clr_fd(int fd)
{
    FD_CLR(fd, &g_uart_fdsread);
}

static int init_uart_device(char*uart_path)
{
   
    int fd = open(uart_path, O_RDWR);

    if (fd < 0)
    {
        AmtPrintf(AMT_ERROR "Failed to open \"%s\"!\n", uart_path);
        return -1;
    }

    uart_set(fd);
    return fd;
}

/**
 * @brief ȡuart ݵ̺߳
 * @param[in] args ̺߳
 * @return N/A
 * @note
 * @see 
 */
static void* ReadUartThread(void* args)
{
    int ret = -1;
    int read_len = 0;
    char *receive_buffer = malloc(MAX_UART_DATA_LENGTH);
	UNUSED(args);
    if (receive_buffer == NULL)
    {
        return NULL;
    }
    memset(receive_buffer,0,MAX_UART_DATA_LENGTH);
            
    while (!g_close_uart)
	{
	    ret = select(g_uart_fd_max, &g_uart_fdsread, NULL, NULL, NULL);
		if (ret <= 0)
	    {
	        AmtPrintf(AMT_ERROR "select error: %s!\n", strerror(errno));
		    continue;
	    }
			
	    if (g_fd_uart0 >= 0 && FD_ISSET(g_fd_uart0, &g_uart_fdsread))
	    {
	        memset(receive_buffer,0,MAX_UART_DATA_LENGTH);
			read_len = PortRecv(g_fd_uart0, (unsigned char *)receive_buffer, MAX_UART_DATA_LENGTH - 1, NO_WAIT);
		    if(read_len > 0)
			{
			    receive_buffer[read_len] = '\0';
				AmtPrintf(AMT_INFO "ttyS0 receive[%s]\n", receive_buffer);
				if(!strcmp(receive_buffer,"amt uart test\r\n"))
				{
				    PortSend(g_fd_uart0, "ttyS0 test OK!", strlen("ttyS0 test OK!"), WAIT_ALL);
				}
				else
				{
                    AmtPrintf(AMT_ERROR "ttyS0 input error!\n");
				}
			    
			}
		}
		if (g_fd_uart1 >= 0 && FD_ISSET(g_fd_uart1, &g_uart_fdsread))
		{
			memset(receive_buffer,0,MAX_UART_DATA_LENGTH);
			read_len = PortRecv(g_fd_uart1, (unsigned char *)receive_buffer, MAX_UART_DATA_LENGTH - 1, NO_WAIT);
			if(read_len > 0)
			{
			    receive_buffer[read_len] = '\0';
				AmtPrintf(AMT_INFO "ttyS1 receive[%s]\n", receive_buffer);
				if(!strcmp(receive_buffer,"amt uart test\r\n"))
				{
				    PortSend(g_fd_uart1, "ttyS1 test OK!", strlen("ttyS1 test OK!"), WAIT_ALL);
				}
				
				else
				{
                    AmtPrintf(AMT_ERROR "ttyS1 input error!\n");
				}
			}
		}
		if (g_fd_uart2 >= 0 && FD_ISSET(g_fd_uart2, &g_uart_fdsread))
		{
			memset(receive_buffer,0,MAX_UART_DATA_LENGTH);
			read_len = PortRecv(g_fd_uart2, (unsigned char *)receive_buffer, MAX_UART_DATA_LENGTH - 1, NO_WAIT);
			if(read_len > 0)
			{
			    receive_buffer[read_len] = '\0';
				AmtPrintf(AMT_INFO "ttyS2 receive[%s]\n", receive_buffer);
				if(!strcmp(receive_buffer,"amt uart test\r\n"))
				{
				    PortSend(g_fd_uart2, "ttyS2 test OK!", strlen("ttyS2 test OK!"), WAIT_ALL);
				}
				else
				{
                    AmtPrintf(AMT_ERROR "ttyS2 input error!\n");
				}
			}
		}
	}

    free(receive_buffer);
	receive_buffer = NULL;
    return NULL;
}




/**
 * @brief AMTԳʼ
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_FuncTest_Init(void)
{
    return 0;
}

/**
 * @brief AMTϢ
 * @param[in] msg_id FID
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_FuncTest_ProcessMsg(unsigned int msg_id, unsigned char *msg_buf, unsigned int msg_len)
{
    unsigned char result = 1; 
	
    switch(msg_id)
    {
        case FID_OPEN_UART:
		{
            //򿪴
             g_close_uart = 0;
             FD_ZERO(&g_uart_fdsread);
             g_fd_uart0 = init_uart_device(UART0_DEV);
			 AmtPrintf(AMT_INFO "g_fd_uart0 = %d.\n", g_fd_uart0);
			 if (g_fd_uart0 >= 0)
             {
                 set_fd(g_fd_uart0);
			 }
			 g_fd_uart1 = init_uart_device(UART1_DEV);
			 AmtPrintf(AMT_INFO "g_fd_uart1 = %d.\n", g_fd_uart1);
			 if (g_fd_uart1 >= 0)
             {
                 set_fd(g_fd_uart1);
			 }
			 g_fd_uart2 = init_uart_device(UART2_DEV);
			 AmtPrintf(AMT_INFO "g_fd_uart2 = %d.\n", g_fd_uart2);
			 if (g_fd_uart2 >= 0)
             {
                 set_fd(g_fd_uart2);
			 }
			 if((g_fd_uart0 == -1)&&(g_fd_uart1 == -1)&&(g_fd_uart2 == -1))
			 {
			     unsigned char ret = 1; 
			     if (Amt_CreateResponse(msg_id, (unsigned char*)&ret, sizeof(unsigned char)) == -1)
                 {
                     AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
                 }
                 else
                 {
                     AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
                 }
			 }
			 else
			 {
                 unsigned char ret = 0; 
			     if (Amt_CreateResponse(msg_id, (unsigned char*)&ret, sizeof(unsigned char)) == -1)
                 {
                     AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
                 }
                 else
                 {
                     AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
                 }
				 //̼߳

				 pthread_t uart_read_thread;
                 if (pthread_create(&uart_read_thread, NULL, ReadUartThread, NULL) != 0)
                 {
                     AmtPrintf(AMT_ERROR "Failed to create uart read thread!\n");
                     return -1;
                 }
				 
			}
            
            break;
		}
		case FID_CLOSE_UART:
		{
			AmtPrintf(AMT_INFO "receive FID_CLOSE_UART\n");
			g_close_uart = 1;
		    if (g_fd_uart0 >= 0)
            {
                close(g_fd_uart0);
            }
			if (g_fd_uart1 >= 0)
            {
                close(g_fd_uart1);
            }
			if (g_fd_uart2 >= 0)
            {
                close(g_fd_uart2);
            }
			if (Amt_CreateResponse(msg_id, NULL, 0) == -1)
            {
                AmtPrintf(AMT_ERROR "%s: Send data failure.\n", __FUNCTION__);
            }
            else
            {
                AmtPrintf(AMT_INFO "%s: Send data success.\n", __FUNCTION__);
            }
            break;
		}
		default:
			break;

	}
   	
    return 0;
}

/**
 * @brief AMTϢPC
 * @param[in] msg_id FID
 * @param[in] result ״̬
 * @param[in] msg_buf buffer
 * @param[in] msg_len buffer
 * @return ɹ0, ʧܷ-1
 * @note
 * @see 
 */
int Amt_FuncTest_SendMsg(unsigned int msg_id, int result, unsigned char *msg_buf, unsigned int msg_len)
{
    return 0;
}


