#include <sys/time.h>
#include <sys/types.h>
#include <string.h>
#include <dirent.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <errno.h>
#include <linux/rtc.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "rtc-service.h"
#include <softap_api.h>

int main(int argc, char **argv)
{
	int ret = -1;
	time_t cur_time = time(0);

	MSG_BUF stMsg = {0};
	int rtc_id = -1;
	int wlan_id = -1;

	unsigned int msgSize = sizeof(MSG_BUF) - sizeof(long);

	rtc_id = msgget(MODULE_ID_RTC_SERVICE, 0);
	stMsg.ulMagic = MSG_MAGIC_WORD;
	stMsg.lMsgType = MSG_TYPE_DEFAULT;
	stMsg.src_id = MODULE_ID_WEB_CGI;
	stMsg.dst_id = MODULE_ID_RTC_SERVICE;
	stMsg.usMsgCmd = RTC_MSG_SET_TIME;
	stMsg.usDataLen = sizeof(struct rtc_time);
	memcpy(stMsg.aucDataBuf, &cur_time, sizeof(time_t));

	printf("[rtc-clock] send  RTC_MSG_SET_TIME\n");
AGAIN:
	ret = msgsnd(rtc_id, &stMsg, msgSize, 0);
	if (ret < 0) {
		if (errno == EINTR) {
			goto AGAIN;
		}

		printf("send_message failed: msgsnd error code [%ld,%d]!\n", ret, errno); //dujiajiao modified, 20151223
		return -1;
	}
	//֪ͨʱ߻
	wlan_id = msgget(MODULE_ID_WIFI, 0);
	stMsg.ulMagic = MSG_MAGIC_WORD;
	stMsg.lMsgType = MSG_TYPE_DEFAULT;
	stMsg.src_id = MODULE_ID_WEB_CGI;  // һ
	stMsg.dst_id = MODULE_ID_WIFI;
	stMsg.usMsgCmd = MSG_CMD_RTC_TIME_UPDATE;
	stMsg.usDataLen = 0;

	printf("[rtc-clock] send  MSG_CMD_RTC_TIME_UPDATE\n");

AGAIN1:
	ret = msgsnd(wlan_id, &stMsg, msgSize, 0);
	if (ret < 0) {
		if (errno == EINTR) {
			goto AGAIN1;
		}

		printf("send_message failed: msgsnd error code [%ld,%d]!\n", ret, errno); //dujiajiao modified, 20151223
		return -1;
	}
	return 0;
}
