#include "parent_control_set.h"

//nv
#define DISABLE_NET_INTERVAL  "disable_net_interval"
#define ENABLE_NET_INTERVAL   "enable_net_interval"

#define DISABLE_NET_TIMER 61
#define ENABLE_NET_TIMER 62

//ȫֱڴ洢ÿϢǷùʱ䣬±0~6ֱӦ~
Time_Node global_disable_para[7] = {0};

unsigned long  val_disable = 0;
unsigned long  val_enable = 0;

int disble_timer_mark = 0;
int enable_timer_mark = 0;

static void disable_net_recall();
static void enable_net_recall();
static int calculate_disable_interval();

int get_msg_qid(int module_id)
{
	int msg_qid = -1;

	slog(MISC_PRINT, SLOG_ERR, "[get_msg_qid] module_id = %d\n", module_id);

AGAIN:
	msg_qid = msgget(module_id, IPC_CREAT | 0600);
	if (msg_qid == -1) {
		slog(MISC_PRINT, SLOG_ERR, "error!cannot get the destination message id!module_id=%d, errno=%d\n", module_id, errno);

		sleep(1);
		goto AGAIN;
	}

	return msg_qid;
}

//緢ͽϢ
static int send_to_net_for_disable_network()
{
	int iRet = -1;

	slog(MISC_PRINT, SLOG_ERR, "send_to_net_for_disable_network fail\n");

	iRet = ipc_send_message(MODULE_ID_PARENT_CONTROL_SET, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_START_NONET, 0, NULL, 0);
	if (iRet != 0)
		slog(MISC_PRINT, SLOG_ERR, "send_to_net_for_disable_network fail, iRet=%d %s\n", iRet, strerror(iRet));
	return iRet;
}

//緢ͿϢ
static int send_to_net_for_enable_network()
{
	int iRet = -1;

	slog(MISC_PRINT, SLOG_ERR, "send_to_net_for_enable_network\n");

	iRet = ipc_send_message(MODULE_ID_PARENT_CONTROL_SET, MODULE_ID_MAIN_CTRL, MSG_CMD_NET_STOP_NONET, 0, NULL, 0);
	if (iRet != 0)
		slog(MISC_PRINT, SLOG_ERR, "send_to_net_for_enable_network fail, iRet=%d %s\n", iRet, strerror(iRet));
	return iRet;
}

//* Description:     ϢID
//* Input:           ̵߳IDʶ
//* Output:          ϢID
int create_msg_qid(int module_id)
{
	int msg_qid = -1;

AGAIN:
	msg_qid = msgget(module_id, IPC_CREAT | 0600);
	if (msg_qid == -1) {
		slog(MISC_PRINT, SLOG_ERR, "create msg fail, module_id=%d, errno=%d\n", module_id, errno);
		sleep(1);
		goto AGAIN;
	}

	return msg_qid;
}

//ɾPCSʱ
static void DeleteTimer_PCS()
{
	rtc_timer_del(DISABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);
	rtc_timer_del(ENABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);

	if (send_to_net_for_enable_network() < 0) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]send_to_net_for_enable_network failure\n", __FUNCTION__);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "[%s]parent time control is closed, send_to_net_for_enable_network\n", __FUNCTION__);
	}
}

void set_disable_time_interval(int wday, int hour)
{
	if (global_disable_para[wday].TimeSet[hour].flag != 1)
		set_disable_time_interval(wday, hour - 1);
	else {
		global_disable_para[wday].TimeSet[hour].enable_interval += 60 * 60;
		slog(MISC_PRINT, SLOG_ERR, "[%s]wday:%d, hour:%d, interval: %ld\n", __FUNCTION__, wday, hour, global_disable_para[wday].TimeSet[hour].enable_interval);
	}
}

//ʱ洢ڶӦ
static int save_time(int wday, char *tptr)
{
	char time_str[64] = {0};
	char* outer_ptr = NULL;
	char* inner_ptr = NULL;
	int timeNum = 0;
	int hour = 0;
	int last_disable_hour = -2;
	//int last_disable_minute = 0; չ

	if (tptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]error!\n", __FUNCTION__);
		return -1;
	}
	memcpy(time_str, tptr, strlen(tptr));
	time_str[63]='\0';
	slog(MISC_PRINT, SLOG_ERR, "[%s]time_str:%s\n", __FUNCTION__, time_str);

	outer_ptr = strtok_r(time_str, ",", &inner_ptr);
	while (outer_ptr) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]wday:%d, index:%d, time:%s\n", __FUNCTION__, wday, timeNum, outer_ptr);
		/********************************
		       Ժչȷֵʱ
		       ĬһСʱ
		    ********************************/
		hour = atoi(outer_ptr);
		if(hour <= -1 || hour >=24)
		{
			outer_ptr = strtok_r(NULL, ",", &inner_ptr);
			slog(MISC_PRINT, SLOG_ERR, "[%s]wday:%d, index:%d, err time:%s, hour:%d\n", __FUNCTION__, wday, timeNum, outer_ptr, hour);
			continue;
		}
		//last_disable_hour == hour - 1 ˵ɻ
		if (last_disable_hour == hour - 1) {
			set_disable_time_interval(wday, hour - 1);
		} else {
			global_disable_para[wday].TimeSet[hour].flag = 1;
			//Ժַ֧ӵô˴չ
			//global_disable_para[wday].TimeSet[hour].minute[0] = 1;
			global_disable_para[wday].TimeSet[hour].enable_interval = 60 * 60;
			slog(MISC_PRINT, SLOG_ERR, "[%s]wday:%d, hour:%d, interval:%ld\n", __FUNCTION__, wday, hour, global_disable_para[wday].TimeSet[hour].enable_interval);
		}
		if (last_disable_hour == -2) {
			global_disable_para[wday].first_hour = hour + 1;
		}
		last_disable_hour = hour;
		outer_ptr = strtok_r(NULL, ",", &inner_ptr);
	}
	global_disable_para[wday].TimeNum = timeNum;
	slog(MISC_PRINT, SLOG_ERR, "[%s]wday:%d, total hour num is %d\n", __FUNCTION__, wday, timeNum);
	return 0;
}

//a+bݷֱ洢
static int save_data_to_global_para(char *ptr)
{
	char wtmp[2] = {0};
	char dtmp[64] = {0};
	int i = 0;
	int len = 0;
	//int sublen = 0;
	char* tmp = NULL;

	if (ptr == NULL) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]param error!\n", __FUNCTION__);
		return -1;
	}

	len = strlen(ptr);//ʵʳ
	slog(MISC_PRINT, SLOG_ERR, "[%s]ptr:%s, len:%d\n", __FUNCTION__, ptr, len);

	//˴+֮ǰַȡ
	snprintf(wtmp, sizeof(wtmp), "%s", ptr);
	slog(MISC_PRINT, SLOG_ERR, "[%s]week day is %s\n", __FUNCTION__, wtmp);

	tmp = ptr + 2;
	//sublen = len - 2;
	//ps_log("[%s]sublen:%d,*tmp:%s\n",__FUNCTION__,sublen,tmp);
	//˴+ַ֮
	snprintf(dtmp, sizeof(dtmp), "%s", tmp);
	slog(MISC_PRINT, SLOG_ERR, "[%s]limited hours are %s\n", __FUNCTION__, dtmp);

	for (i = 0; i < 7; i++) {
		if (atoi(wtmp) == i) {
			global_disable_para[i].first_hour = 1;
			slog(MISC_PRINT, SLOG_ERR, "[%s]data to be saved:week day=%d, hours=%s\n", __FUNCTION__, i, dtmp);
			save_time(i, dtmp);
			break;
		}
	}

	return 0;
}

//nvȡϢȫֱ
//time_limited=0+0,3,4,8,10,13,14,17,21;1+1,9,12,14,19,23;3+5,9,11,12,15,20,23;
static int get_param_from_nv(char *p_time_limited)
{
	char *outer_ptr = NULL;
	char *inner_ptr = NULL;
	char time_limited_str[PCS_NV_MAX_LEN] = {0};
	int iRet = -1;

	if (p_time_limited == NULL || *p_time_limited == '\0') {
		slog(MISC_PRINT, SLOG_ERR, "[%s]para is invalid.\n", __FUNCTION__);
		return -1;
	}
	memset(&global_disable_para, 0, 7 * sizeof(Time_Node));

	memcpy(time_limited_str, p_time_limited, strlen(p_time_limited));//Ҫֽtime_limited_str
	time_limited_str[PCS_NV_MAX_LEN-1]='\0';

	slog(MISC_PRINT, SLOG_ERR, "[%s]time_limited_str=%s\n", __FUNCTION__, time_limited_str);

	outer_ptr = strtok_r(time_limited_str, ";", &inner_ptr);
	while (outer_ptr) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]string spilt is %s\n", __FUNCTION__, outer_ptr);
		iRet = save_data_to_global_para(outer_ptr);
		if (iRet == -1) {
			slog(MISC_PRINT, SLOG_ERR, "[%s]save_data_to_global_para error\n", __FUNCTION__);
			return -1;
		}
		outer_ptr = strtok_r(NULL, ";", &inner_ptr);
	}
	return 0;
}

//ȡǰϵͳʱ
static int get_local_time(TM* CurrentTime)
{
	time_t CTime;

	time(&CTime);
	localtime_r(&CTime, CurrentTime);
	slog(MISC_PRINT, SLOG_ERR, "[%s]CurrentTime:tm_wday=%d, tm_hour=%d, tm_min=%d, tm_sec=%d\n", __FUNCTION__, CurrentTime->tm_wday, CurrentTime->tm_hour,
	     CurrentTime->tm_min, CurrentTime->tm_sec);
	return 0;
}

void find_the_latest_disable_hour(const int WeekDay, int *latest_disable_hour, unsigned long *interval, const int CurHour, const int min)
{
	//ǰһЧdisableʱڵǰʱ
	if (*latest_disable_hour > CurHour) {
		*interval = global_disable_para[WeekDay].TimeSet[*latest_disable_hour].enable_interval;
	} else if (global_disable_para[WeekDay].TimeSet[*latest_disable_hour].enable_interval / 3600 + *latest_disable_hour > CurHour) {
		//ǰdisableʱ
		*interval = global_disable_para[WeekDay].TimeSet[*latest_disable_hour].enable_interval - (CurHour - *latest_disable_hour) * 3600 - min * 60;
	} else if (*latest_disable_hour < 23) {
		//ѰӽǰʱЧdisableʱ
		*latest_disable_hour = *latest_disable_hour + global_disable_para[WeekDay].TimeSet[*latest_disable_hour].enable_interval / 3600 + 1;
		find_the_latest_disable_hour(WeekDay, latest_disable_hour, interval, CurHour, min);
	}
}

static int find_valid_disable_time(int WeekDay, int CurHour, int Curmin)
{
	int i = 0;
	int latest_disable_hour = -2;
	unsigned long interval = 0;
	unsigned long dis_interval = 0;
	char enable_time_interval[100] = {0};
	char disable_time_interval[100] = {0};

	slog(MISC_PRINT, SLOG_ERR, "[%s]enter hour %d\n", __FUNCTION__, global_disable_para[WeekDay].first_hour);
	//ȿǰǷӦڽʱΣʣʱǶ
	if (global_disable_para[WeekDay].first_hour - 1 >= 0) {
		latest_disable_hour = global_disable_para[WeekDay].first_hour - 1;
		find_the_latest_disable_hour(WeekDay, &latest_disable_hour, &interval, CurHour, Curmin);
		if (interval > 0) {
			if (latest_disable_hour > CurHour)
				dis_interval = (latest_disable_hour - CurHour) * 3600 - Curmin * 60;
			else
				dis_interval = 1;
			sprintf(enable_time_interval, "%ld", interval);
			sprintf(disable_time_interval, "%ld", dis_interval);
			sc_cfg_set(DISABLE_NET_INTERVAL, disable_time_interval);
			sc_cfg_set(ENABLE_NET_INTERVAL, enable_time_interval);
			val_enable = interval;
			val_disable = dis_interval;
			slog(MISC_PRINT, SLOG_ERR, "[%s] latest_disable_hour = %d, curhour = %d, curmin  = %d, val_enable = %ld,val_disable = %ld\n", __FUNCTION__, latest_disable_hour, CurHour, Curmin, val_enable, val_disable);
			return 0;
		}
	}

	slog(MISC_PRINT, SLOG_ERR, "[%s]cur day no set or cur time has already passed\n", __FUNCTION__);
	//ûûߵǰʱѾ˵ʱ
	for (i = 1; i <= 7; i++) {
		if (global_disable_para[(WeekDay + i) % 7].first_hour - 1 >= 0) {
			latest_disable_hour = global_disable_para[(WeekDay + i) % 7].first_hour - 1;

			dis_interval = i * 60 * 60 * 24 + (latest_disable_hour - CurHour) * 60 * 60 - Curmin * 60;
			interval = global_disable_para[(WeekDay + i) % 7].TimeSet[latest_disable_hour].enable_interval;

			sprintf(enable_time_interval, "%ld", interval);
			sprintf(disable_time_interval, "%ld", dis_interval);
			sc_cfg_set(DISABLE_NET_INTERVAL, disable_time_interval);
			sc_cfg_set(ENABLE_NET_INTERVAL, enable_time_interval);
			val_enable = interval;
			val_disable = dis_interval;
			//sc_timer_create(DISABLE_NET_TIMER, TIMER_FLAG_ONCE, dis_interval*1000, (void*)(*disable_net_recall), NULL);
			slog(MISC_PRINT, SLOG_ERR, "[%s] i = %d, latest_disable_hour = %d, curhour = %d, curmin  = %d, val_enable = %ld,val_disable = %ld\n", __FUNCTION__, i, latest_disable_hour, CurHour, Curmin, val_enable, val_disable);
			return 0;
		}
	}
	return -1;
}

//´νֹļʱ
static int calculate_disable_interval()
{
	int iRet = -1;
	TM CurTime = {0};
	int WeekDay = 0;
	int CurHour = 0;
	int CurMinute = 0;
	int CurSecond = 0;

	int DisableInterval = -1;
	int EnableInterval = -1;

	iRet = get_local_time(&CurTime);

	WeekDay = CurTime.tm_wday;
	CurHour = CurTime.tm_hour;
	CurMinute = CurTime.tm_min;
	CurSecond = CurTime.tm_sec;

	slog(MISC_PRINT, SLOG_ERR, "[%s]current day is %d\n", __FUNCTION__, WeekDay);
	iRet = find_valid_disable_time(WeekDay, CurHour, CurMinute);
	if (iRet < 0) {
		DeleteTimer_PCS();
		slog(MISC_PRINT, SLOG_ERR, "[%s]find_next_disable_time error\n", __FUNCTION__);
	}
	return iRet;
}

//˴enable
static void enable_net_recall()
{
	int iRet = -1;

	slog(MISC_PRINT, SLOG_ERR, "[%s]val_enable=%ld\n", __FUNCTION__, val_enable);

	if (send_to_net_for_enable_network() < 0) {
		slog(MISC_PRINT, SLOG_ERR, "[%s] send_to_net_for_enable_network failure!\n", __FUNCTION__);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "[%s]send_to_net_for_enable_network successfully!\n", __FUNCTION__);
	}

	/*  iRet = ipc_send_message(MODULE_ID_PARENT_CONTROL_SET, MODULE_ID_PARENT_CONTROL_SET, DISABLE_NET_TIMER, 0, NULL, 0);
	  if (iRet < 0){
	      slog(MISC_PRINT,SLOG_ERR,"[%s]enable_net_recall send msg failed!\n",__FUNCTION__);
	  }*/
}

static void disable_net_recall()
{
	int iRet = -1;

	slog(MISC_PRINT, SLOG_ERR, "[%s]val_disable = %d\n", __FUNCTION__, val_disable);

	if (send_to_net_for_disable_network() < 0) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]send_to_net_for_disable_network failure!\n", __FUNCTION__);
	} else {
		slog(MISC_PRINT, SLOG_ERR, "[%s]send_to_net_for_disable_network successfully!\n", __FUNCTION__);
	}

	/*  iRet = ipc_send_message(MODULE_ID_PARENT_CONTROL_SET, MODULE_ID_PARENT_CONTROL_SET, ENABLE_NET_TIMER, 0, NULL, 0);
	  if (iRet < 0){
	      slog(MISC_PRINT,SLOG_ERR,"[%s]disable_net_recall send msg failed!\n", __FUNCTION__);
	  }*/
}

//ҳʱô
void handle_parent_control_setting()
{
	int iRet = -1;
	char time_limited[PCS_NV_MAX_LEN] = {0};

	sc_cfg_get("time_limited", time_limited, sizeof(time_limited));

	slog(MISC_PRINT, SLOG_ERR, "[%s]time_limited is %s\n", __FUNCTION__, time_limited);

	memset(global_disable_para, 0, sizeof(Time_Node) * 7);

	//ɾʱ
	DeleteTimer_PCS();

	val_disable = 0;
	val_enable = 0;

	if (strcmp(time_limited, "") == 0) {
		slog(MISC_PRINT, SLOG_ERR, "[%s]no time is set,so delete two timers\n", __FUNCTION__);
		return;
	}

	iRet = get_param_from_nv(time_limited);
	if (iRet == -1) {
		slog(MISC_PRINT, SLOG_ERR, "[%s] get_param_from_nv is error\n", __FUNCTION__);
		return;
	}

	iRet = calculate_disable_interval(); //ʱ
	if (iRet < 0) {
		slog(MISC_PRINT, SLOG_ERR, "[%s] error\n", __FUNCTION__);
		return;
	}
	rtc_timer_add(val_disable, DISABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);
}

//յϢ
int parse_recieved_msg(MSG_BUF *pstMsg)
{
	if (NULL == pstMsg) {
		slog(MISC_PRINT, SLOG_ERR, "[parent control set] pstMsg is NULL\n");
		return -1;
	} else if (pstMsg->ulMagic != MSG_MAGIC_WORD) {
		slog(MISC_PRINT, SLOG_ERR, "[parent control set] pstMsg magic error\n");
		return -1;
	} else if (pstMsg->dst_id != MODULE_ID_PARENT_CONTROL_SET) {
		slog(MISC_PRINT, SLOG_ERR, "[parent control set] target is not wlan pstMsg->dst_id is %x\n", pstMsg->dst_id);
		return -1;
	}
	slog(MISC_PRINT, SLOG_ERR, "[parent control set] src_id=%x usMsgCmd=%x\n", pstMsg->src_id, pstMsg->usMsgCmd);

	//pc_wake_lock();
	RTC_DATA_BUF *buf;
	switch (pstMsg->src_id) {
	case MODULE_ID_WEB_CGI:
		if (pstMsg->usMsgCmd == MSG_CMD_PARENT_CONTROL_SET) {
			slog(MISC_PRINT, SLOG_ERR, "[parent control set]MSG_CMD_PARENT_CONTROL_SET\n");
			handle_parent_control_setting();
		} else if (pstMsg->usMsgCmd == MSG_CMD_PARENT_CONTROL_CLOSE) {
			slog(MISC_PRINT, SLOG_ERR, "[parent control set]MSG_CMD_PARENT_CONTROL_CLOSE\n");
			DeleteTimer_PCS();
		}
		break;
	case MODULE_ID_SNTP:
		//յsntpͬϢ
		if (pstMsg->usMsgCmd == MSG_CMD_SNTP_SUCCESS) {
			slog(MISC_PRINT, SLOG_ERR, "[parent control set]MSG_CMD_SNTP_REPLY\n");
			handle_parent_control_setting();
		}
		break;
	/*        case MODULE_ID_PARENT_CONTROL_SET:
	            //soft_timerʱʱԼϢ
	            if (pstMsg->usMsgCmd == ENABLE_NET_TIMER)
	            {
	                slog(MISC_PRINT,SLOG_ERR, "receive msg to enable_timer\n");
	                if (enable_timer_mark == 0){
	                 //   sc_timer_create(ENABLE_NET_TIMER, TIMER_FLAG_ONCE, val_enable * 1000, (void*)(*enable_net_recall), NULL);
	                    rtc_timer_add(val_enable , ENABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);
	                    enable_timer_mark = 1;
	                }
	            } else if (pstMsg->usMsgCmd == DISABLE_NET_TIMER){
	                slog(MISC_PRINT,SLOG_ERR, "receive msg to disable_timer\n");
	                if (calculate_disable_interval() == 0){
	                 //   sc_timer_create(DISABLE_NET_TIMER, TIMER_FLAG_ONCE, val_disable * 1000, (void*)(*disable_net_recall), NULL);
	                    rtc_timer_add(val_disable, DISABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);
	                    disable_net_recall();
	                  //  disble_timer_mark = 1;
	                }
	            }
	            break;*/
	case MODULE_ID_RTC_SERVICE:
		buf = pstMsg->aucDataBuf;
		slog(MISC_PRINT, SLOG_ERR, "buf.module = %d\n", buf->module);
		if (buf->module == ENABLE_NET_TIMER) {
			slog(MISC_PRINT, SLOG_ERR, "receive msg to enable_timer\n");
			if (calculate_disable_interval() == 0) {
				rtc_timer_add(val_disable, DISABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);
				enable_net_recall();
			}
		} else if (buf->module == DISABLE_NET_TIMER) {
			slog(MISC_PRINT, SLOG_ERR, "receive msg to disable_timer\n");
			rtc_timer_add(val_enable, ENABLE_NET_TIMER, MODULE_ID_PARENT_CONTROL_SET);
			disable_net_recall();
		}
	default:
		break;
	}

	//pc_wake_unlock();
	return 0;
}

/*************************
nv : time_limited ֹʱ,;Ϊ0~6(~), +ǰʾ죬ʾֹʱ
time_limited=0+0,3,4,8,10,13,14,17,21;1+1,9,12,14,19,23;3+5,9,11,12,15,20,23;
*************************/
int main(int args, char argv[])
{
	MSG_BUF RecvMsg = {0};
	int iRet = -1;
	int Ret = -1;
	int parent_msg_qid = 0;
	char time_limited[PCS_NV_MAX_LEN] = {0};

	//ʼӡ𣬲עᶯ̬ӡź
	loglevel_init();

	parent_msg_qid = create_msg_qid(MODULE_ID_PARENT_CONTROL_SET);

	slog(MISC_PRINT, SLOG_ERR, "[parent control set] main thread getpid = %d\n", getpid());

	//жtime_limitednvǷΪգΪգnetͻϢΪգá
	handle_parent_control_setting();

	//SNTPעϢҪSNTPɹ֪ͨ±Ӧ
	iRet = ipc_send_message2(MODULE_ID_PARENT_CONTROL_SET, MODULE_ID_SNTP, MSG_CMD_SNTP_REGISTER, 0, NULL, 0);
	if (iRet != 0) {
		slog(MISC_PRINT, SLOG_ERR, "[parent control set]ipc_send_message to sntp failed\n");
	}

	while (1) {
		memset(&RecvMsg, 0, sizeof(MSG_BUF));
		iRet = msgrcv(parent_msg_qid, &RecvMsg, sizeof(MSG_BUF) - sizeof(LONG), 0, 0);
		if (iRet == -1) {
			slog(MISC_PRINT, SLOG_ERR, "[parent control set]msgrcv error errno = %d, %s\n", errno, strerror(errno));
			continue;
		}
		parse_recieved_msg(&RecvMsg);
	}
	return 0;
}
