#if 0

#if defined(MODVERSIONS)
#include <linux/modversions.h>
#endif
#include <linux/version.h>
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 0)
#include <linux/config.h>
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 33)
#include <linux/autoconf.h>
#else
#include <generated/autoconf.h>
#endif
#include <linux/init.h>
#include <linux/errno.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/mii.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/spinlock.h>
#include <asm/dma.h>

#include "ip175d.h"

#define DRV_NAME	"ip175d"
#define DRV_VERSION	"1.3.0"
#define DRV_RELDATE	"2014-08-28"

static struct net_device* pNet_dev=NULL;

//#define TEST_REG
#ifdef TEST_REG
u16 RegList[32][32];
#endif

#define Write_Reg(phy,reg,val)	phy_write(phy,reg,val)	//modify this to MII interface
#define Read_Reg(phy,reg)	phy_read(phy,reg)	//modify this to MII interface
void phy_write(int phyaddr, int regaddr, int value)	//modify this to MII interface
{
#ifdef TEST_REG
	RegList[phyaddr][regaddr]=value;
#endif
}
u16 phy_read(int phyaddr, int regaddr)			//modify this to MII interface
{
#ifdef TEST_REG
	return RegList[phyaddr][regaddr];
#endif
	return 0;
}

void write_reg_bits(u16 phyaddr,u16 regaddr,u16 bitnum,u16 bitstart,u16 value)
{
    u16 reg_val=Read_Reg(phyaddr,regaddr);
    u16 bitmsk=0,i;
    for(i=0;i<bitnum;i++){
        bitmsk|=(u16)0x1<<(i);
    }
    reg_val &= ~(bitmsk<<bitstart);
    reg_val |= (value&bitmsk)<<bitstart;
	Write_Reg(phyaddr,regaddr,reg_val);
}

u16 read_reg_bits(u16 phyaddr,u16 regaddr,u16 bitnum,u16 bitstart)
{
    u16 reg_val=Read_Reg(phyaddr,regaddr);
    u16 bitmsk=0,i;
    for(i=0;i<bitnum;i++){
        bitmsk|=(u16)0x1<<(i);
    }
    return (reg_val>>bitstart)&bitmsk;
}


void VLAN_Set( struct _VLAN_setting *VLAN_setting )
{	u16 Valid=0x0,FVID=0x0,Reg_Val;
	int i,j,len=PBASE_VLAN_NUM;
//	printk("\nVLAN Mode=%d",VLAN_setting->cmd);
	if(VLAN_setting->vmode != VLAN_MODE_ALL_PBASE){
		len=TBASE_VLAN_NUM;
	}

	Reg_Val=Read_Reg(PHY22,VLAN_CLASS);
/*
	if(VLAN_setting->vmode)
	{	Reg_Val |= 0x003f;	}
	else
	{	Reg_Val &=~0x003f;	}
*/
//	printf("vmode=%x\n",VLAN_setting->vmode);
	Reg_Val |= VLAN_setting->vmode&0x3f;
	Reg_Val |= (VLAN_setting->cmode&0x3f) << 6;
	Write_Reg(PHY22,VLAN_CLASS,Reg_Val);	//set vlan mode

	for(i=0;i<MAX_PORT_NUM;i++){
//		printf("pvid %d=%d\n",i,VLAN_setting->PVID[i]);
		Reg_Val=(VLAN_setting->PVID[i] & 0x0fff);
		Write_Reg(PHY22,VLAN_INFO_0+i, Reg_Val );
	}                       //set PVID
	for(i=0;i<len;i++){
		Reg_Val = 0;
		if(VLAN_setting->VLAN_entry[i].qos_enable){
			Reg_Val |= 0x1<<i;
		}
	}
	Write_Reg(PHY22,VLAN_QU_NUM_EN,Reg_Val);
	for(i=0;i<(len/2);i++)
	{
//		printf("member %d=%x\n",i*2,VLAN_setting->VLAN_entry[i*2].member);
//		printf("member %d=%x\n",i*2+1,VLAN_setting->VLAN_entry[i*2+1].member);

		Reg_Val = (VLAN_setting->VLAN_entry[i*2].member&0x3f) |
					  ((VLAN_setting->VLAN_entry[i*2+1].member&0x3f)<<8);
//		reg_setting &=0x003f;
//		Reg_Val = ( Read_Reg(PHY23,VLAN_MEMBER_00+i/2) );
//		Reg_Val&= ~(0x00ff<< (8*(i%2)) );
//		Reg_Val|=reg_setting;
		Write_Reg(PHY23,VLAN_MEMBER_00+i,Reg_Val) ;	//set VLAN member

//		printf("AddTag %d=%x\n",i*2,VLAN_setting->VLAN_entry[i*2].AddTag);
//		printf("AddTag %d=%x\n",i*2+1,VLAN_setting->VLAN_entry[i*2+1].AddTag);

		Reg_Val = (VLAN_setting->VLAN_entry[i*2].AddTag&0x3f) |
						((VLAN_setting->VLAN_entry[i*2+1].AddTag&0x3f)<<8);
//		reg_setting &=0x003f;
//		reg_setting<<=(8*(i%2));
//		Reg_Val = ( Read_Reg(PHY23,VLAN_ADDTAG_00+i/2) );
//		Reg_Val&= ~(0x00ff<< (8*(i%2)) );
//		Reg_Val|=reg_setting;
		Write_Reg(PHY23,VLAN_ADDTAG_00+i,Reg_Val) ;	//set AddTag

//		printf("RmvTag %d=%x\n",i*2,VLAN_setting->VLAN_entry[i*2].RmvTag);
//		printf("RmvTag %d=%x\n",i*2+1,VLAN_setting->VLAN_entry[i*2+1].RmvTag);

		Reg_Val  = (VLAN_setting->VLAN_entry[i*2].RmvTag&0x3f) |
						((VLAN_setting->VLAN_entry[i*2+1].RmvTag&0x3f)<<8);
//		reg_setting &=0x003f;
//		reg_setting<<=(8*(i%2));
//		Reg_Val = ( Read_Reg(PHY23,VLAN_REMOVETAG_00+i/2) );
//		Reg_Val&= ~(0x00ff<< (8*(i%2)) );
//		Reg_Val|=reg_setting;
		Write_Reg(PHY23,VLAN_REMOVETAG_00+i,Reg_Val);	//set RemoveTag

		//Set VLAN MISC - QoS.
		Reg_Val = ((VLAN_setting->VLAN_entry[i*2].queue&0x3)<<2) |
					((VLAN_setting->VLAN_entry[i*2+1].queue&0x3)<<10);
		Write_Reg(PHY23,VLAN_MISC_00+i,Reg_Val);


		for(j=i*2;j<i*2+2;j++){
			if(VLAN_setting->vmode&(0x1<<j) || (j>=MAX_PORT_NUM)){
        		if(VLAN_setting->VLAN_entry[j].valid)
					{ Valid |= (0x0001<<j); }
//				printf("VID %d=%x\n",j,VLAN_setting->VLAN_entry[j].VID);
    			FVID = (VLAN_setting->VLAN_entry[j].VID&0x0fff);
//				printf("FID %d=%x\n",j,VLAN_setting->VLAN_entry[j].FID);
				FVID|=((VLAN_setting->VLAN_entry[j].FID&0x000f)<<12);
    			Write_Reg(PHY22, VLAN_FID_VID0+j ,FVID);    //set FID&VID
			}
		}

/*
		if(i<PBASE_VLAN_NUM)
		{	Reg_Val=(VLAN_setting->VLAN_entry[i].PVID & 0x0fff);
			Write_Reg(PHY22,VLAN_INFO_0+i, Reg_Val );
		}						//set PVID
*/
	}
	Write_Reg(PHY22,VLAN_VALID,Valid);			//set valid

	VLAN_setting->cmd &= VLAN_CMD_OKMASK;
	VLAN_setting->cmd |= VLAN_CMD_OK;	//command complete
}

void VLAN_Query( struct _VLAN_setting *VLAN_setting )
{	u16 Valid=0x0,FVID=0x0,Reg_Val;
	int i,len=PBASE_VLAN_NUM;
	VLAN_setting->vmode=( Read_Reg(PHY22,VLAN_CLASS)&0x3f );
	VLAN_setting->cmode=( Read_Reg(PHY22,VLAN_CLASS)&(0x3f<<6))>>6;
    if(VLAN_setting->vmode != VLAN_MODE_ALL_PBASE){
		        len=TBASE_VLAN_NUM;
	}
    for(i=0;i<MAX_PORT_NUM;i++){
		VLAN_setting->PVID[i] = Read_Reg(PHY22,VLAN_INFO_0+i)&0x0fff;
	}                       //set PVID

	for(i=0;i<len;i++)
	{
        if((i<PBASE_VLAN_NUM)&&(VLAN_setting->vmode&(0x1<<i))){
			Valid=Read_Reg(PHY22,VLAN_VALID);
			if(Valid & (0x0001<<i))
			{ VLAN_setting->VLAN_entry[i].valid=1; }	//query valid port

			FVID=Read_Reg(PHY22, VLAN_FID_VID0+i);
			VLAN_setting->VLAN_entry[i].VID= (FVID&0x0fff);	//query VID
			VLAN_setting->VLAN_entry[i].FID=((FVID&0xf000)>>12);//query FID
		}

		Reg_Val = ( Read_Reg(PHY23,VLAN_MEMBER_00+i/2) >> (8*(i%2)) );
		Reg_Val&= 0x00ff;
		VLAN_setting->VLAN_entry[i].member = Reg_Val;	//query VLAM member

		Reg_Val = ( Read_Reg(PHY23,VLAN_ADDTAG_00+i/2) >> (8*(i%2)) );
		Reg_Val&= 0x00ff;
		VLAN_setting->VLAN_entry[i].AddTag = Reg_Val;	//query add tag

		Reg_Val = ( Read_Reg(PHY23,VLAN_REMOVETAG_00+i/2) >> (8*(i%2)) );
		Reg_Val&= 0x00ff;
		VLAN_setting->VLAN_entry[i].RmvTag = Reg_Val;	//query remove tag
/*
		Reg_Val = Read_Reg(PHY22,VLAN_INFO_0);
		Reg_Val&= 0x0fff;				//query PVID
		if(i<PBASE_VLAN_NUM)				//(only 6 entries)
		{	VLAN_setting->VLAN_entry[i].PVID  = Reg_Val;	}
		else
		{	VLAN_setting->VLAN_entry[i].PVID  = 0x0;	}
*/
	}

	VLAN_setting->cmd &= VLAN_CMD_OKMASK;
	VLAN_setting->cmd |= VLAN_CMD_OK;	//command complete
}

#define exchange(a,b)	{		  \
							u16 t;\
							t = a;\
							a = b;\
							b = t;\
						}

void QoS_Set(struct _QoS_setting *QoS_setting)
{	u16 Reg2522=0,Reg2523=0,Reg2511=0,Reg2520=0;
	u16 Reg2500=0;
	u16 Regtmp=0;
	u16 i;

	if(!(QoS_setting->enable)){	//disable QoS function
		Write_Reg(PHY25,QOS_CTRL,0x0);	return;
	}
	else{
		if(QoS_setting->pri_cos_enable&0x3f){
			if(QoS_setting->pri_cos_enable == QoS_CLASS_COS_ALL_ENABLE){
				Reg2500 |= 0x3f<<8;
				Reg2500 |= 0x1 <14;
			}
			else{
				Reg2500 |= (QoS_setting->pri_cos_enable&0x3f)<<8;
				Reg2500 |= 0x1 <<14;
			}
			for(i=0;i<MAX_COS_PRI_NUM;i++){
				Regtmp |= (QoS_setting->cos_queue[i]&0xf)<<(2*(i%8));
				if(((i%8)==7)){
					Write_Reg(PHY25,QOS_TOS_PRI_0+(i/8),Regtmp);
					Regtmp=0;
				}
			}
		}
		if(QoS_setting->priority_class&QoS_CLASS_ACL_ENABLE){
			Reg2500 |= 0x1 << 7;
		}

		Write_Reg(PHY25,QOS_CTRL,Reg2500);
//		Write_Reg(PHY25,QOS_CTRL,0xff80);
	}

	QoS_setting->mode&=0x3;
//printk(KERN_ERR"\nQoS mode:%01x",QoS_setting->mode);
	Reg2522=0x0000;
	for(i=0;i<6;i++)
	{	Reg2522|= ( QoS_setting->mode<<(2*i) );	}

	for(i=0;i<QoS_MAX_QUEUE;i++)
	{	QoS_setting->queue_weight[i]&=0xf;
		Reg2523|= ( QoS_setting->queue_weight[i]<<(4*i) );
	}

	QoS_setting->type&=0x3;
	Reg2511|=(QoS_setting->type<<6);
	for(i=0;i<MAX_PROTOCOL_NUM;i++)
	{	if( QoS_setting->protocol[i].enable )
		{	Reg2511|= (0x01<<(0+i));		}
	}
	for(i=0;i<MAX_RANGE_NUM;i++)
	{	if( QoS_setting->range[i].enable )
		{	Reg2511|= (0x01<<(4+i));		}
	}

	for(i=0;i<MAX_PROTOCOL_NUM;i++)
	{	Write_Reg(PHY25,QOS_PRE_LOGI_0+i, QoS_setting->protocol[i].port );	}
	for(i=0;i<MAX_RANGE_NUM;i++)
	{	if(QoS_setting->range[i].s_port>QoS_setting->range[i].e_port)
		{ exchange(QoS_setting->range[i].s_port,QoS_setting->range[i].e_port); }
		Write_Reg(PHY25,QOS_USER_RG_LOW_0+(2*i),QoS_setting->range[i].s_port);
		Write_Reg(PHY25,QOS_USER_RG_HI_0 +(2*i),QoS_setting->range[i].e_port);
	}

	for(i=0;i<MAX_PROTOCOL_NUM;i++)
	{	QoS_setting->protocol[i].queue&=0x3;
		Reg2520|= ( QoS_setting->protocol[i].queue<<(0+i*2) );
	}
	for(i=0;i<MAX_RANGE_NUM;i++)
	{	QoS_setting->range[i].queue&=0x3;
		Reg2520|= ( QoS_setting->range[i].queue<<(8+i*2) );
	}

//printk(KERN_ERR" reg2522:%04x",Reg2522);
	Write_Reg(PHY25,QOS_SCH_CONFIG	,Reg2522);
	Write_Reg(PHY25,QOS_SCH_WEIGHT	,Reg2523);
	Write_Reg(PHY25,QOS_TCP_CTRL	,Reg2511);
	Write_Reg(PHY25,QOS_TCP_QU_MAP	,Reg2520);
	return;
}

void QoS_Query(struct _QoS_setting *QoS_setting)
{
	u16 Reg2500=0;
	u16 i,j;

	if(Read_Reg(PHY25,QOS_SCH_CONFIG)&0x2000)
		QoS_setting->enable = 1;
	Reg2500 = Read_Reg(PHY25,QOS_CTRL);

	QoS_setting->pri_cos_enable = (Reg2500&0x3f00)>>8;

	for(i=0;i<MAX_COS_PRI_NUM;){
		for(j=0;j<8;j++,i++)
			QoS_setting->cos_queue[i] =
				(Read_Reg(PHY25,QOS_TOS_PRI_0+(i/8))&(0x3<<(j*2)))>>(j*2);
	}

	QoS_setting->type = (Read_Reg(PHY25,QOS_TCP_CTRL)&0xc0)>>6;
	QoS_setting->mode = (Read_Reg(PHY25,QOS_SCH_CONFIG)&0xc00)>>10;
	for(i=0;i<QoS_MAX_QUEUE;i++)
		QoS_setting->queue_weight[i] = (Read_Reg(PHY25,QOS_SCH_WEIGHT)>>(i*4))&0xf;

	for(i=0;i<MAX_PROTOCOL_NUM;i++){
		QoS_setting->protocol[i].enable = Read_Reg(PHY25,QOS_TCP_CTRL)&(0x1<<i)? 1:0;
		QoS_setting->protocol[i].port = Read_Reg(PHY25,QOS_PRE_LOGI_0+i);
		QoS_setting->protocol[i].queue = (Read_Reg(PHY25,QOS_TCP_QU_MAP)>>(i*2))&0x3;
	}
	for(i=0;i<MAX_RANGE_NUM;i++){
		QoS_setting->range[i].enable = Read_Reg(PHY25,QOS_TCP_CTRL)&(0x1<<(i+4))? 1:0;
		QoS_setting->range[i].s_port = Read_Reg(PHY25,QOS_USER_RG_LOW_0+(i*2));
		QoS_setting->range[i].e_port = Read_Reg(PHY25,QOS_USER_RG_LOW_0+(i*2)+1);
	}
	return;
}

u16 MAC_LUT_hash(u8 *mac, u16 entry, u16 fid)
{
      u16 tmp;
      tmp = (fid<<3|mac[0]>>5)^
                      ((mac[0]&0x1f)<<4|mac[1]>>4)^
                      ((mac[1]&0x0f)<<5|mac[2]>>3)^
                      ((mac[2]&0x07)<<6|mac[3]>>2)^
                      ((mac[3]&0x03)<<7|mac[4]>>1)^
                      ((mac[4]&0x01)<<8|mac[5]);
      tmp = tmp << 2 | (entry&0x3);
      return tmp;
}

u16 IGMP_LUT_hash(u8 type,u8 *mac, u16 entry, u16 fid)
{
	u16 tmp;
	tmp =	fid^mac[0]^mac[1]^mac[2]^mac[3]^mac[4]^mac[5];//0x5F = 0x5E^0x00^0x01
	tmp =  (tmp<<2) | (entry&0x3);
	if (type==LUT_MAC_UNICAST){
		tmp |= (0x0<<10);
	}
	else{
		tmp |= (0x1<<10);
	}
	return tmp;
}

void IGMP_LUT_Set(struct _MAC_LUT_entry *MAC_LUT_setting)
{
	u16 Reg2114=0,Reg2116=0,Reg2117=0,Reg2118=0,Reg2119=0;
	u16 i,tmpMAC;

  tmpMAC=Read_Reg(PHY20,13);
  tmpMAC|=(0x1<<3);
  Write_Reg(PHY20,13,tmpMAC);

	//tmpMAC = (MAC_LUT_setting->MAC[4]<<8)|(MAC_LUT_setting->MAC[5]);
	tmpMAC = MAC_LUT_setting->MAC[4];	tmpMAC<<=8;
	tmpMAC|= MAC_LUT_setting->MAC[5];	
	Write_Reg(PHY21,MAC_ADDR0,tmpMAC);
	Reg2116 = MAC_LUT_setting->MAC[3]&0x7f;
	for(i=0;i<2;i++){
		Reg2116 |= (MAC_LUT_setting->timeout[i]&0x7)<<(8+i*3);
	}
	Reg2116 |= (MAC_LUT_setting->timeout[2]&0x3)<<14;
	Write_Reg(PHY21,MAC_ADDR1,Reg2116);

	Reg2117 = (MAC_LUT_setting->timeout[2]&0x4)>>2;
    for(i=0;i<3;i++){
		Reg2117 |= (MAC_LUT_setting->timeout[i+3]&0x7)<<(1+i*3);
	}
	Write_Reg(PHY21,MAC_ADDR2,Reg2117);

	Reg2118 |= (MAC_LUT_setting->filter_function&0x3)<<14;
  Reg2118 |= (MAC_LUT_setting->pri_function&0x3)<<12;
	Reg2118 |= (MAC_LUT_setting->queue&0x3)<<10;
	Reg2118 |= (MAC_LUT_setting->fid&0xf)<<6;
	Reg2118 |= (MAC_LUT_setting->phy_port&0x3f);

	Reg2119 = 0x1 | ((MAC_LUT_setting->valid&0x1)<<1);

	Reg2114 = IGMP_LUT_hash(MAC_LUT_setting->type,MAC_LUT_setting->MAC,MAC_LUT_setting->entry,MAC_LUT_setting->fid);

	Reg2114 |= (0x1)<<11;
	Reg2114 |= 0x8000;

    Write_Reg(PHY21,MAC_CONTROL,Reg2118);
    Write_Reg(PHY21,MAC_STATIC,Reg2119);
    Write_Reg(PHY21,MAC_COMMAND,Reg2114);
    return;
}

void IGMP_Entry_Set(u8 *GDA_MACaddr,u8 port_map,u8 add_entry)
{ struct _MAC_LUT_entry MAC_LUT_setting;
  u16 i;

//printk(KERN_ERR "\n IGMP_Entry_Set [%x][%x][%x]t[%x]",GDA_MACaddr[0],GDA_MACaddr[1],GDA_MACaddr[2],add_entry);    
	MAC_LUT_setting.type=LUT_IGMP_MULTICAST;// 0:unicast 1:multicast 2:IGMP
	MAC_LUT_setting.valid=add_entry;// in unicast: set 1 for static entry, in mcast& igmp: set 1 for valid.
	if(!add_entry)
	{  IGMP_LUT_Set(&MAC_LUT_setting);
	   return;
  }
	MAC_LUT_setting.entry=0;//bit 0~1: entry num(0~3)
	MAC_LUT_setting.fid=0;//0~15
	for(i=0;i<6;i++)
	{  MAC_LUT_setting.MAC[i]=*(GDA_MACaddr+i);
  }
	MAC_LUT_setting.age=4; //careless in Multicast
	MAC_LUT_setting.pri_function=0;//1:match DMAC 2:match SMAC 3:match either DMAC or SMAC
	//filter_function - 1:drop if SA match 2:ignore VLAN member 3:copy to mirror port if DA match
	MAC_LUT_setting.filter_function=0;
	MAC_LUT_setting.queue=0;//0~3
	MAC_LUT_setting.phy_port=port_map;//unicast- 0:drop 1~6: forward to port0~5
                           //multicast- bit0~5: forward to port0~5 enable/disable
                           //IGMP     - bit0~5: forward to port0~5 enable/disable
	for(i=0;i<MAX_PORT_NUM;i++)
    MAC_LUT_setting.timeout[i]=1; //MAX time to timeout

  IGMP_LUT_Set(&MAC_LUT_setting);
}


void MAC_LUT_Set(u8 lut_mode,struct _MAC_LUT_entry *MAC_LUT_setting)
{

	u16 Reg2114=0,Reg2118=0,Reg2119=0;
	u16 i,tmpMAC;

	for(i=0;i<3;i++){
		tmpMAC =((MAC_LUT_setting->MAC[i*2])<<8) | ((MAC_LUT_setting->MAC[i*2+1])&0xff);
		Write_Reg(PHY21,MAC_ADDR2-i,tmpMAC);
	}

	Reg2118 |= (MAC_LUT_setting->filter_function&0x3)<<14;
	Reg2118 |= (MAC_LUT_setting->pri_function&0x3)<<12;
	Reg2118 |= (MAC_LUT_setting->queue&0x3)<<10;
	Reg2118 |= (MAC_LUT_setting->fid&0xf)<<6;

	if(MAC_LUT_setting->type == LUT_MAC_UNICAST){
		Reg2118 |= (MAC_LUT_setting->phy_port&0x7)<<3;
		Reg2118 |= (MAC_LUT_setting->age&0x7);
		if (MAC_LUT_setting->valid)
			Reg2119 = 0x2;
	}
	else{
		Reg2118 |= (MAC_LUT_setting->phy_port&0x3f);
		if (MAC_LUT_setting->valid)
			Reg2119 = 0x2;
	}
	if(lut_mode == LUT_2K){
		Reg2114 = MAC_LUT_hash(MAC_LUT_setting->MAC,MAC_LUT_setting->entry,MAC_LUT_setting->fid);
	}
	else{
		Reg2114 = IGMP_LUT_hash(MAC_LUT_setting->type,MAC_LUT_setting->MAC,MAC_LUT_setting->entry,MAC_LUT_setting->fid);
	}
	Reg2114 |= (0x1)<<11;
	Reg2114 |= 0x8000;

	Write_Reg(PHY21,MAC_CONTROL,Reg2118);
	Write_Reg(PHY21,MAC_STATIC,Reg2119);
	Write_Reg(PHY21,MAC_COMMAND,Reg2114);
	return;
}


void MAC_LUT_Query(struct _MAC_LUT_entry *MAC_LUT_setting)
{
	u16 Reg2114=0;

	Reg2114 = MAC_LUT_hash(MAC_LUT_setting->MAC,MAC_LUT_setting->entry,MAC_LUT_setting->fid);
	Reg2114 |= (0x2)<<11;
	Reg2114 |= 0x8000;

	Write_Reg(PHY21,MAC_COMMAND,Reg2114);
	/*Make sure the data is valid*/
//	while(!(Read_Reg(PHY21,MAC_COMMAND)&0x2000))
//		break;

    MAC_LUT_setting->phy_port = (Read_Reg(PHY21,MAC_CONTROL)&0x0038)>>3;
	if (Read_Reg(PHY21,MAC_STATIC)&0x2){
		MAC_LUT_setting->valid = 1;
	}
	MAC_LUT_setting->pri_function = (Read_Reg(PHY21,MAC_CONTROL)&0x3000)>>12;
	MAC_LUT_setting->queue = (Read_Reg(PHY21,MAC_CONTROL)&0x0c00)>>10;
	return;
}

u8 MAC_Query_portno(u8 *MACaddr)
{ u8 port_no=0,i;
  struct _MAC_LUT_entry MAC_LUT_setting;
  for(i=0;i<6;i++)
  MAC_LUT_setting.MAC[i]=*(MACaddr+i);
  MAC_LUT_setting.entry=0;
  MAC_LUT_setting.fid=0;  
  MAC_LUT_Query(&MAC_LUT_setting);
  port_no=MAC_LUT_setting.phy_port;
  return port_no;
}

void IGMP_LUT_Query(struct _MAC_LUT_entry *MAC_LUT_setting)
{
	u16 Reg2114=0;
	u8 type=MAC_LUT_setting->type;
	Reg2114 = IGMP_LUT_hash(type,MAC_LUT_setting->MAC,MAC_LUT_setting->entry,MAC_LUT_setting->fid);
//printf("  midx:%03x",Reg2114);
	Reg2114 |= (0x2)<<11;
	Reg2114 |= 0x8000;

	Write_Reg(PHY21,MAC_COMMAND,Reg2114);
	/*Make sure the data is valid*/
//	while(!(Read_Reg(PHY21,MAC_COMMAND)&0x2000))
//		break;

//    MAC_LUT_setting->phy_port = (Read_Reg(PHY21,MAC_CONTROL)&0x0038)>>3;
    MAC_LUT_setting->phy_port = (Read_Reg(PHY21,MAC_CONTROL)&0x003f);
	if (Read_Reg(PHY21,MAC_STATIC)&0x2){
		MAC_LUT_setting->valid = 1;
	}
	MAC_LUT_setting->pri_function = (Read_Reg(PHY21,MAC_CONTROL)&0x3000)>>12;
	MAC_LUT_setting->queue = (Read_Reg(PHY21,MAC_CONTROL)&0x0c00)>>10;
	return;
}
u8 MAC_Query_portno_1k1k(u8 *MACaddr,u8 type)
{ u8 port_no=0,i;
  struct _MAC_LUT_entry MAC_LUT_setting;
//printk(KERN_ERR "\n MAC_Query_portno_1k1k [%x][%x][%x]t[%x]",MACaddr[0],MACaddr[1],MACaddr[2],type);  
  for(i=0;i<6;i++)
  MAC_LUT_setting.MAC[i]=*(MACaddr+i);
  MAC_LUT_setting.entry=0;
  MAC_LUT_setting.fid=0;  
  MAC_LUT_setting.type=type;  
  IGMP_LUT_Query(&MAC_LUT_setting);
  port_no=MAC_LUT_setting.phy_port;
  if(type==LUT_MAC_UNICAST)
	{port_no>>=3; }
  return port_no;
}


void LUT_Set(struct _LUT_setting *lut)
{
	u16 Reg2013=0;

	Reg2013 = Read_Reg(PHY20,LEARNING_CTRL_REG);
	Reg2013 &= ~(0x9);

	if(lut->lut_mode == LUT_2K){
		Reg2013 |= 0x1;
		Write_Reg(PHY20,LEARNING_CTRL_REG,Reg2013);
		MAC_LUT_Set(lut->lut_mode,&lut->lut_entry);
	}
	else{
		Reg2013 |= 0x9;
		Write_Reg(PHY20,LEARNING_CTRL_REG,Reg2013);
		if((lut->lut_entry.type == LUT_MAC_MULTICAST)||
			(lut->lut_entry.type == LUT_MAC_UNICAST))
			MAC_LUT_Set(lut->lut_mode,&lut->lut_entry);
		else if(lut->lut_entry.type==LUT_IGMP_MULTICAST)
			IGMP_LUT_Set(&lut->lut_entry);

	}
	return;
}

int get_valid_MAC_LUT_entry(int idx, u8 type, struct _MAC_LUT_entry *MAC_LUT_setting)
{
	int i, j, k, vidx=0xFFFF;
	u16 Reg2013=0, Reg2114=0;
	u16 LUT_data[5];
	u32 u32dat;

	if (idx > 0x7FF)	return -1;

	j = 0x800;
	Reg2013 = Read_Reg(PHY20, LEARNING_CTRL_REG);
	if (type == LUT_MAC_UNICAST)
	{
		if (Reg2013 & 0x8)
		{
			j = 0x400;
			if (idx >= 0x400)	return -1;
		}
	}
	else
	{
		if (Reg2013 & 0x8)
		{	if (idx < 0x400)	idx = 0x400;	}
		else
			return -1;
	}

	for (i=idx; i < j; i++)
	{
		Reg2114 = (i | 0x9000);
		Write_Reg(PHY21, MAC_COMMAND, Reg2114);
		do {
			Reg2114 = Read_Reg(PHY21, MAC_COMMAND);
		} while ((Reg2114 & 0x2000) == 0);

		for (k=0; k < 5; k++)
			LUT_data[k] = Read_Reg(PHY21, MAC_ADDR0+k);

		if (LUT_data[4] & 0x2)
		{
			if ( (type==LUT_MAC_UNICAST) ||
			     ( type==LUT_MAC_MULTICAST && !(LUT_data[4]&0x1) ) ||
			     ( type==LUT_IGMP_MULTICAST && (LUT_data[4]&0x1) ) )
			{	vidx = i;	break;	}
		}
		else
		{
			if (type==LUT_MAC_UNICAST && (LUT_data[3] & 0x7))
			{	vidx = i;	break;	}
		}
	}

	if (vidx < 0x800)
	{
		if (type == LUT_IGMP_MULTICAST)
		{
			MAC_LUT_setting->MAC[0] = 0x01;
			MAC_LUT_setting->MAC[1] = 0x00;
			MAC_LUT_setting->MAC[2] = 0x5E;
			MAC_LUT_setting->MAC[3] = (u8)(LUT_data[1] & 0x7F);
			MAC_LUT_setting->MAC[4] = (u8)(LUT_data[0] >> 8);
			MAC_LUT_setting->MAC[5] = (u8)(LUT_data[0] & 0xFF);

			u32dat = (u32)( ((LUT_data[2] << 16) | LUT_data[1]) >> 8 );
			for (i=0; i < MAX_PORT_NUM; i++)
			{
				MAC_LUT_setting->timeout[i] = (u8)(u32dat & 0x7);
				u32dat = u32dat >> 3;
			}
		}
		else
		{
			for (i=0; i < 6; i+=2)
			{
				MAC_LUT_setting->MAC[i] = (u8)(LUT_data[2-(i/2)] >> 8);
				MAC_LUT_setting->MAC[i+1] = (u8)(LUT_data[2-(i/2)] & 0xFF);
			}
		}

		MAC_LUT_setting->valid = (u8)((LUT_data[4] >> 1) & 0x1);
		MAC_LUT_setting->type  = type;
		MAC_LUT_setting->entry = (u8)(vidx & 0x3);
		MAC_LUT_setting->fid   = (u8)((LUT_data[3] >> 6) & 0xF);
		MAC_LUT_setting->filter_function = (u8)(LUT_data[3] >> 14);
		MAC_LUT_setting->pri_function = (u8)((LUT_data[3] >> 12) & 0x3);
		MAC_LUT_setting->queue = (u8)((LUT_data[3] >> 10) & 0x3);
		if (type == LUT_MAC_UNICAST)
		{
			MAC_LUT_setting->phy_port = (u8)((LUT_data[3] >> 3) & 0x7);
			MAC_LUT_setting->age = (u8)(LUT_data[3] & 0x7);
		}
		else
			MAC_LUT_setting->phy_port = (u8)(LUT_data[3] & 0x3F);

		return vidx;
	}
	else
		return -1;
}

void igmp_set_func(u16 func)
{
    Write_Reg(PHY21,IGMP_CTRL,func);
}
u16 igmp_get_func()
{
    Read_Reg(PHY21,IGMP_CTRL);
    return 0;
}
void igmp_set_router_port(u8 ports)
{
    write_reg_bits(PHY21,IGMP_RP_TIME,6,0,ports);
}
u8 igmp_get_router_port()
{
    read_reg_bits(PHY21,IGMP_RP_TIME,6,0);
    return 0;
}
void igmp_set_router_timeout(u16 timeout)
{
    u16 reg_val=Read_Reg(PHY21,IGMP_RP_TIME);
	reg_val &= 0x3f;
    reg_val|=timeout;
    Write_Reg(PHY21,IGMP_RP_TIME,reg_val);
}
u16 igmp_get_router_timeout()
{
    return Read_Reg(PHY21,IGMP_RP_TIME)&(~(0x3F));
}
void igmp_set_group_timeout(u16 timeout)
{
    Write_Reg(PHY21,IGMP_GROUP_TIME,timeout);
}
u16 igmp_get_group_timeout()
{
    return Read_Reg(PHY21,IGMP_GROUP_TIME);
}

void IGMP_Set(struct _IGMP_setting *igmp)
{
	igmp_set_func(igmp->func);
	igmp_set_router_port(igmp->router_port);
	igmp_set_router_timeout(igmp->rp_timeout);
	igmp_set_group_timeout(igmp->group_timeout);
}

void IGMP_Query(struct _IGMP_setting *igmp)
{
	igmp->func=igmp_get_func();
	igmp->router_port=igmp_get_router_port();
	igmp->rp_timeout=igmp_get_router_timeout();
	igmp->group_timeout=igmp_get_group_timeout();
}
void IGMP_Set_Entry(struct _IGMP_entry *igmp)
{
	IGMP_Entry_Set(igmp->mac,igmp->port,igmp->type);
}
u8 IGMP_Query_Entry(struct _IGMP_entry *igmp)
{
	u16 Reg2013 = Read_Reg(PHY20,LEARNING_CTRL_REG);
	if(igmp->type!=LUT_MAC_UNICAST && !(Reg2013&0x8) )
		return -EOPNOTSUPP;
	igmp->port=MAC_Query_portno_1k1k(igmp->mac,igmp->type);
	return 0;
}

void ACL_MF_Set(struct _ACL_MF_entry *ACL_MF_setting)
{
	u16 Reg2601=0,Reg2609=0,Reg2610=0,Reg2620=0,Reg2613=0,Reg2614=0,Reg2619;
	u16 tmpAddr,i;

	Reg2619 = Read_Reg(PHY26,MF_VALID);
	Reg2619 = Reg2619 &(~(0x1<< ACL_MF_setting->index));
	Reg2619 |= (ACL_MF_setting->valid)<< ACL_MF_setting->index;

	Reg2620 |= ACL_MF_setting->index;

	/* Setup Action*/
	switch(ACL_MF_setting->action){
		case ACL_ACTION_RATE_CONTROL:
			Reg2601 |= (0x1<<14);
			Write_Reg(PHY26,MF_CREDIT_SIZE,ACL_MF_setting->rate);
			Write_Reg(PHY26,MF_MBS,0x5EE);
			break;
		case ACL_ACTION_MONITOR_RATE:
			Reg2620 |= 0x0040;
			Write_Reg(PHY26,MF_ACCESS_CTRL,Reg2620);
			if(!(Read_Reg(PHY26,MF_OVERFLOW)&(0x1<<ACL_MF_setting->index))){
				ACL_MF_setting->traffic_count = Read_Reg(PHY26,MF_CNT_MSB);
				ACL_MF_setting->traffic_count = ACL_MF_setting->traffic_count << 16;
				ACL_MF_setting->traffic_count |= Read_Reg(PHY26,MF_CNT_LSB);
			}
			return;
		case ACL_ACTION_QUEUE_SET:
			Reg2609 |= (ACL_MF_setting->queue&0x7) << 9;
			break;
		case ACL_ACTION_MIRROR_PORT:
			Reg2609 |= (0x1<<13);
			break;
		case ACL_ACTION_FORWARD_CPU:
			Reg2609 |= (0x1<<12);
			break;
		case ACL_ACTION_DROP:
			Reg2601 |= (0x1<<15);
			break;
		default:
			break;
	}
	Reg2620 |= (0x1)<<3;
	Reg2620 |= (0x1)<<4;
	/* Setup Ethernet Type*/
	if(ACL_MF_setting->function&ACL_FILTER_ETHTYPE_ENABLE){
		Reg2609 |= (0x1<<15);
		Write_Reg(PHY26,MF_ET_VALUE,ACL_MF_setting->ether_type);
	}
	else{
		Reg2609 &= ~(0x1<<15);
	}
	/* Setup IP Protocol*/
	if(ACL_MF_setting->function&ACL_FILTER_IP_PROTOCOL_ENABLE){
		Reg2609 |= (0x1<<8);
		Reg2609 |= (ACL_MF_setting->ip_protocol&0xff);
	}
	else{
		Reg2609 &= ~(0x1<<8);
	}
	/* Setup VLAN/DSCP/ToS Aggregation */
	if((ACL_MF_setting->function&ACL_FILTER_VLAN_ENABLE)||
		(ACL_MF_setting->function&ACL_FILTER_COS_ENABLE)){
		Reg2614 |= (0x1<<7);
		/* Select VLAN */
		if(ACL_MF_setting->function&ACL_FILTER_VLAN_ENABLE){
			Reg2614 |= (0x1<<6);
			Reg2614 |= ACL_MF_setting->cos_type<<3;
		}
		else
			Reg2614 |= ACL_MF_setting->cos_type;
		Write_Reg(PHY26,MF_BEHAVIOR,Reg2614);
	}

	/* Setup Physical Port*/
	if(ACL_MF_setting->function&ACL_FILTER_PHYPORT_ENABLE){
		Reg2613 |= (0x1<<15);
		Reg2613 |= ((ACL_MF_setting->port_num&0x1f)<<10);
		Write_Reg(PHY26,MF_SP_PORTNUM,Reg2613);
	}

	/* Setup IP Addressed */
	if(ACL_MF_setting->function&ACL_FILTER_IP_ADDRESS_ENABLE){
		switch(ACL_MF_setting->ip_mac_type)
		{
			case ACL_FILTER_IP_SINGAL_SOURCE:
			case ACL_FILTER_IP_SINGAL_DESTINATION:
			case ACL_FILTER_IP_SINGAL_BOTH:
				if(ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_SINGAL_SOURCE ||
					ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_SINGAL_BOTH){
					Reg2601 |= 0x3 << 10;/*Enable IP field*/
					for(i=0;i<2;i++){
						tmpAddr = ACL_MF_setting->sip[i*2]<<8 | ACL_MF_setting->sip[i*2+1];
						Write_Reg(PHY26,MF_IM_SA1-i,tmpAddr);
					}
				}
				if(ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_SINGAL_DESTINATION ||
					ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_SINGAL_BOTH){
					Reg2601 |= 0x3 << 4;
					for(i=0;i<2;i++){
						tmpAddr = ACL_MF_setting->eip[i*2]<<8 | ACL_MF_setting->eip[i*2+1];
						Write_Reg(PHY26,MF_IM_DA1-i,tmpAddr);
					}
				}
				Reg2601 |= 0x3cf;
				break;

			case ACL_FILTER_IP_RANGE_SOURCE:
			case ACL_FILTER_IP_RANGE_DESTINATION:
			case ACL_FILTER_IP_RANGE_BOTH:

				Reg2601 |= 0x1 << 12;
				Reg2601 |= 0x1 << 11;
				Reg2601 |= 0x1 << 5;

				if((ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_RANGE_SOURCE) ||
					(ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_RANGE_BOTH) ){
					for(i=0;i<4;i++){
						if (ACL_MF_setting->sip[i] != ACL_MF_setting->eip[i])
							Reg2601 |= 0x1 << (9-i);
					}
					if(ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_RANGE_SOURCE)
						Reg2601 |= 0xf;
					Reg2601 |= 0x1 << 10;
				}
				if((ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_RANGE_DESTINATION) ||
					(ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_RANGE_BOTH) ){
					for(i=0;i<4;i++){
						if (ACL_MF_setting->sip[i] != ACL_MF_setting->eip[i])
							Reg2601 |= 0x1 << (3-i);
					}
					if(ACL_MF_setting->ip_mac_type == ACL_FILTER_IP_RANGE_DESTINATION)
						Reg2601 |= 0xf << 6;
					Reg2601 |= 0x1 << 4;
				}

    	        for(i=0;i<2;i++){
        	        tmpAddr = ACL_MF_setting->sip[i*2]<<8 | ACL_MF_setting->sip[i*2+1];
            	    Write_Reg(PHY26,MF_IM_SA1-i,tmpAddr);
	            }
    	        for(i=0;i<2;i++){
        	        tmpAddr = ACL_MF_setting->eip[i*2]<<8 | ACL_MF_setting->eip[i*2+1];
            	    Write_Reg(PHY26,MF_IM_DA1-i,tmpAddr);
	            }
				break;
		}/*For ip_mac_type switch statement*/
	}/*For IP Address enable if statement*/

	/*Setup MAC */
	if(ACL_MF_setting->function&ACL_FILTER_MAC_ENABLE){
		switch(ACL_MF_setting->ip_mac_type)
		{
            case ACL_FILTER_MAC_SMAC_ENABLE:
			case ACL_FILTER_MAC_DMAC_ENABLE:
			case ACL_FILTER_MAC_BOTH_ENABLE:
				if((ACL_MF_setting->ip_mac_type == ACL_FILTER_MAC_SMAC_ENABLE) ||
						(ACL_MF_setting->ip_mac_type == ACL_FILTER_MAC_BOTH_ENABLE)){
					Reg2601 |= (0x1<<11);
					for(i=0;i<3;i++){
						tmpAddr = ACL_MF_setting->sMAC[i*2]<<8 | ACL_MF_setting->sMAC[i*2+1];
						Write_Reg(PHY26,MF_IM_SA2-i,tmpAddr);
					}
				}
				if((ACL_MF_setting->ip_mac_type == ACL_FILTER_MAC_DMAC_ENABLE) ||
						(ACL_MF_setting->ip_mac_type == ACL_FILTER_MAC_BOTH_ENABLE)){
					Reg2601 |= (0x1<<5);
					for(i=0;i<3;i++){
						tmpAddr = ACL_MF_setting->dMAC[i*2]<<8 | ACL_MF_setting->dMAC[i*2+1];
						Write_Reg(PHY26,MF_IM_DA2-i,tmpAddr);
					}
				}
				break;
		}
	}

	/* Setup Logical Port */
	if(ACL_MF_setting->function&ACL_FILTER_LOGICAL_PORT_ENABLE){
		switch(ACL_MF_setting->logical_port_protocol)
		{
			case ACL_FILTER_LP_STCP:
			case ACL_FILTER_LP_SUDP:
				Reg2610 |= (0x1<<3);
				if (ACL_MF_setting->logical_port_protocol == ACL_FILTER_LP_SUDP)
					Reg2610 |= (0x1<<2);
				Write_Reg(PHY26,MF_LG_SP_NUM,ACL_MF_setting->s_port);
				break;
			case ACL_FILTER_LP_DTCP:
			case ACL_FILTER_LP_DUDP:
				Reg2610 |= (0x1<<1);
				if (ACL_MF_setting->logical_port_protocol == ACL_FILTER_LP_DUDP)
					Reg2610 |= 0x1;
				Write_Reg(PHY26,MF_LG_DP_NUM,ACL_MF_setting->e_port);
				break;

			case ACL_FILTER_LP_STCP_DTCP:
			case ACL_FILTER_LP_STCP_DUDP:
			case ACL_FILTER_LP_SUDP_DTCP:
			case ACL_FILTER_LP_SUDP_DUDP:
				Reg2610 |= (0x1<<3);
				Reg2610 |= (0x1<<1);
				if ((ACL_MF_setting->logical_port_protocol == ACL_FILTER_LP_SUDP_DTCP)||
						(ACL_MF_setting->logical_port_protocol == ACL_FILTER_LP_SUDP_DUDP))
					Reg2610 |= (0x1<<2);
				if ((ACL_MF_setting->logical_port_protocol == ACL_FILTER_LP_STCP_DUDP)||
						(ACL_MF_setting->logical_port_protocol == ACL_FILTER_LP_SUDP_DUDP))
					Reg2610 |= 0x1;
				Write_Reg(PHY26,MF_LG_SP_NUM,ACL_MF_setting->s_port);
				Write_Reg(PHY26,MF_LG_DP_NUM,ACL_MF_setting->e_port);
				break;

			case ACL_FILTER_LP_RANGE_STCP:
			case ACL_FILTER_LP_RANGE_SUDP:
			case ACL_FILTER_LP_RANGE_SBOTH:
			case ACL_FILTER_LP_RANGE_DTCP:
            case ACL_FILTER_LP_RANGE_DUDP:
			case ACL_FILTER_LP_RANGE_DBOTH:
			case ACL_FILTER_LP_RANGE_BOTH_TCP:
			case ACL_FILTER_LP_RANGE_BOTH_UDP:
			case ACL_FILTER_LP_RANGE_BOTH_BOTH:
				switch(ACL_MF_setting->logical_port_protocol)
				{
					case ACL_FILTER_LP_RANGE_STCP:
						Reg2610 |= (0x1<<3);
						Reg2610 |= (0x1<<2);
						break;
					case ACL_FILTER_LP_RANGE_SUDP:
						Reg2610 |= (0x1<<3);
						Reg2610 |= 0x1;
						break;
					case ACL_FILTER_LP_RANGE_SBOTH:
						Reg2610 |= (0x1<<3);
						Reg2610 |= (0x1<<2);
						Reg2610 |= 0x1;
						break;
					case ACL_FILTER_LP_RANGE_DTCP:
						Reg2610 |= (0x1<<1);
						Reg2610 |= (0x1<<2);
						break;
					case ACL_FILTER_LP_RANGE_DUDP:
						Reg2610 |= (0x1<<1);
						Reg2610 |= 0x1;
						break;
					case ACL_FILTER_LP_RANGE_DBOTH:
						Reg2610 |= (0x1<<1);
						Reg2610 |= (0x1<<2);
						Reg2610 |= 0x1;
						break;
					case ACL_FILTER_LP_RANGE_BOTH_TCP:
						Reg2610 |= (0x1<<1);
						Reg2610 |= (0x1<<3);
						Reg2610 |= (0x1<<2);
						break;
					case ACL_FILTER_LP_RANGE_BOTH_UDP:
						Reg2610 |= (0x1<<1);
						Reg2610 |= (0x1<<3);
						Reg2610 |= 0x1;
						break;
					case ACL_FILTER_LP_RANGE_BOTH_BOTH:
						Reg2610 |= (0x1<<1);
						Reg2610 |= (0x1<<3);
						Reg2610 |= (0x1<<2);
						Reg2610 |= 0x1;
						break;

				}

				Reg2610 |= (0x1<<4);
				if(ACL_MF_setting->s_port>ACL_MF_setting->e_port)
					exchange(ACL_MF_setting->e_port,ACL_MF_setting->s_port);

				Write_Reg(PHY26,MF_LG_SP_NUM,ACL_MF_setting->s_port);
				Write_Reg(PHY26,MF_LG_DP_NUM,ACL_MF_setting->e_port);
				break;

			default:
				break;
		}/*For logical_port_type switch statement*/

		Write_Reg(PHY26,MF_TCP_UDP,Reg2610);
	}/*For Logical Port enable if statement*/

	Write_Reg(PHY26,MF_VALID,Reg2619);
	Write_Reg(PHY26,MF_CLASS,Reg2601);
	Write_Reg(PHY26,MF_REG9,Reg2609);
	Write_Reg(PHY26,MF_ACCESS_CTRL,Reg2620);
	return;
}

void ACL_MF_Query(struct _ACL_MF_entry *ACL_MF_setting)
{
	u16 Reg2620=0;
	u16 i;

    Reg2620 |= ACL_MF_setting->index;
    Reg2620 |= (0x1)<<4;

	Write_Reg(PHY26,MF_ACCESS_CTRL,Reg2620);

	ACL_MF_setting->valid = Read_Reg(PHY26,MF_VALID)&(0x1<<ACL_MF_setting->index);
	if(Read_Reg(PHY26,MF_CLASS)&0x8000)
		ACL_MF_setting->action = ACL_ACTION_DROP;
	else{
		if(Read_Reg(PHY26,MF_CLASS)&0x4000){
			ACL_MF_setting->action = ACL_ACTION_RATE_CONTROL;
			ACL_MF_setting->rate = Read_Reg(PHY26,MF_CREDIT_SIZE);
		}
		else{
			switch(Read_Reg(PHY26,MF_REG9)&0x3000)
			{
				case 0x1000:
					ACL_MF_setting->action = ACL_ACTION_FORWARD_CPU;
					break;
				case 0x2000:
					ACL_MF_setting->action = ACL_ACTION_MIRROR_PORT;
					break;
			}
		}
		if(Read_Reg(PHY26,MF_REG9)&0xe00){
			ACL_MF_setting->action = ACL_ACTION_QUEUE_SET;
			ACL_MF_setting->queue = (Read_Reg(PHY26,MF_REG9)&0xe00)>>9;
		}
	}


	if(Read_Reg(PHY26,MF_REG9)&0x8000){
		ACL_MF_setting->function |= ACL_FILTER_ETHTYPE_ENABLE;
		ACL_MF_setting->ether_type = Read_Reg(PHY26,MF_ET_VALUE);
	}
	if(Read_Reg(PHY26,MF_REG9)&0x0100){
		ACL_MF_setting->function |= ACL_FILTER_IP_PROTOCOL_ENABLE;
		ACL_MF_setting->ip_protocol = Read_Reg(PHY26,MF_REG9)&0xff;
	}
	if(Read_Reg(PHY26,MF_SP_PORTNUM)&0x8000){
		ACL_MF_setting->function |= ACL_FILTER_PHYPORT_ENABLE;
		ACL_MF_setting->port_num = (Read_Reg(PHY26,MF_SP_PORTNUM)&0x7c00) >>10;
	}
	if(Read_Reg(PHY26,MF_BEHAVIOR)&0x0080){
		if(Read_Reg(PHY26,MF_BEHAVIOR)&0x0040)
			ACL_MF_setting->function |= ACL_FILTER_VLAN_ENABLE;
		else
			ACL_MF_setting->function |= ACL_FILTER_COS_ENABLE;

		if (ACL_MF_setting->function == ACL_FILTER_COS_ENABLE )
			ACL_MF_setting->cos_type = Read_Reg(PHY26,MF_BEHAVIOR)&0x003F;
		else
			ACL_MF_setting->cos_type = (Read_Reg(PHY26,MF_BEHAVIOR)&0x003F) >> 3;
	}
	switch(Read_Reg(PHY26,MF_TCP_UDP)&0x001f)
	{
		case 0x0002:
		case 0x0003:
		case 0x0008:
		case 0x000a:
		case 0x000b:
		case 0x000c:
		case 0x000e:
		case 0x000f:
			ACL_MF_setting->function |= ACL_FILTER_LOGICAL_PORT_ENABLE;
			switch(Read_Reg(PHY26,MF_TCP_UDP)&0x001f)
			{
				case 0x0002:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_DTCP;
					break;
				case 0x0003:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_DUDP;
					break;
				case 0x0008:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_STCP;
					break;
				case 0x000a:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_STCP_DTCP;
					break;
				case 0x000b:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_STCP_DUDP;
					break;
				case 0x000c:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_SUDP;
					break;
				case 0x000e:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_SUDP_DTCP;
					break;
				case 0x000f:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_SUDP_DUDP;
					break;
			}
			if(Read_Reg(PHY26,MF_TCP_UDP)&0x0008)
				ACL_MF_setting->s_port = Read_Reg(PHY26,MF_LG_SP_NUM)&0xffff;
			if(Read_Reg(PHY26,MF_TCP_UDP)&0x0002)
				ACL_MF_setting->e_port = Read_Reg(PHY26,MF_LG_DP_NUM)&0xffff;
			break;

		case 0x0013:
		case 0x0016:
		case 0x0017:
		case 0x0019:
		case 0x001b:
		case 0x001c:
		case 0x001d:
		case 0x001e:
		case 0x001f:
			ACL_MF_setting->function |= ACL_FILTER_LOGICAL_PORT_ENABLE;
			switch(Read_Reg(PHY26,MF_TCP_UDP)&0x001f)
			{
				case 0x0013:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_DUDP;
					break;
				case 0x0016:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_DTCP;
					break;
				case 0x0017:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_DBOTH;
					break;
				case 0x0019:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_SUDP;
					break;
				case 0x001b:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_BOTH_UDP;
					break;
				case 0x001c:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_STCP;
					break;
				case 0x001d:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_SBOTH;
					break;
				case 0x001e:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_BOTH_TCP;
					break;
				case 0x001f:
					ACL_MF_setting->logical_port_protocol = ACL_FILTER_LP_RANGE_BOTH_BOTH;
					break;
			}
			ACL_MF_setting->s_port = Read_Reg(PHY26,MF_LG_SP_NUM)&0xffff;
			ACL_MF_setting->e_port = Read_Reg(PHY26,MF_LG_DP_NUM)&0xffff;
			break;
	}

	switch(Read_Reg(PHY26,MF_CLASS)&0x1c30)
	{
		case 0x0800:/* sMAC */
			ACL_MF_setting->ip_mac_type = ACL_FILTER_MAC_SMAC_ENABLE;
			ACL_MF_setting->function |= ACL_FILTER_MAC_ENABLE;
            for(i=0;i<6;i++)
                ACL_MF_setting->sMAC[i] = (Read_Reg(PHY26,MF_IM_SA2-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
			break;
		case 0x0020:/* dMAC */
			ACL_MF_setting->ip_mac_type = ACL_FILTER_MAC_DMAC_ENABLE;
			ACL_MF_setting->function |= ACL_FILTER_MAC_ENABLE;
            for(i=0;i<6;i++)
                ACL_MF_setting->dMAC[i] = (Read_Reg(PHY26,MF_IM_DA2-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
			break;
		case 0x0820:/* Both sMAC & dMAC */
			ACL_MF_setting->ip_mac_type = ACL_FILTER_MAC_BOTH_ENABLE;
			ACL_MF_setting->function |= ACL_FILTER_MAC_ENABLE;
            for(i=0;i<6;i++)
                ACL_MF_setting->sMAC[i] = (Read_Reg(PHY26,MF_IM_SA2-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
            for(i=0;i<6;i++)
                ACL_MF_setting->dMAC[i] = (Read_Reg(PHY26,MF_IM_DA2-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
			break;
		case 0x0c00:/* source single IP */
			ACL_MF_setting->ip_mac_type = ACL_FILTER_IP_SINGAL_SOURCE;
			ACL_MF_setting->function |= ACL_FILTER_IP_ADDRESS_ENABLE;
    	    for(i=0;i<4;i++)
	            ACL_MF_setting->sip[i] = (Read_Reg(PHY26,MF_IM_SA1-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
			break;
		case 0x0030:/* Destination single IP */
			ACL_MF_setting->ip_mac_type = ACL_FILTER_IP_SINGAL_DESTINATION;
			ACL_MF_setting->function |= ACL_FILTER_IP_ADDRESS_ENABLE;
	        for(i=0;i<4;i++)
    	        ACL_MF_setting->eip[i] = (Read_Reg(PHY26,MF_IM_DA1-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
			break;
		case 0x0c30:
		case 0x1c30:
		case 0x1c20:
		case 0x1830:
			ACL_MF_setting->function |= ACL_FILTER_IP_ADDRESS_ENABLE;
			switch(Read_Reg(PHY26,MF_CLASS)&0x1c30)
			{
				case 0x0c30:/* source/destination single IP */
					ACL_MF_setting->ip_mac_type = ACL_FILTER_IP_SINGAL_BOTH;
					break;
				case 0x1c30:/* source/destination ranged IP */
					ACL_MF_setting->ip_mac_type = ACL_FILTER_IP_RANGE_BOTH;
					break;
				case 0x1c20:
					ACL_MF_setting->ip_mac_type = ACL_FILTER_IP_RANGE_SOURCE;
					break;
				case 0x1830:
					ACL_MF_setting->ip_mac_type = ACL_FILTER_IP_RANGE_DESTINATION;
					break;
			}
            for(i=0;i<4;i++)
                ACL_MF_setting->sip[i] = (Read_Reg(PHY26,MF_IM_SA1-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
            for(i=0;i<4;i++)
                ACL_MF_setting->eip[i] = (Read_Reg(PHY26,MF_IM_DA1-(i/2))&(0xff<<(((i+1)%2)*8)))>>(((i+1)%2)*8);
			break;
	}
	return;
}

void ACL_Set(struct _ACL_setting *ACL_setting)
{
	u16 i,Reg2511=0,Reg2006=0;

	if(ACL_setting->function == ACL_FUNC_PHYPORT){
		for(i=0;i<MAX_PORT_NUM;i++){
			if(ACL_setting->port_state[i]&0x1){
				Reg2006 |= (0x1<<(8+i));
			}
			if(ACL_setting->port_state[i]&0x2){
				Reg2006 |= (0x1<<i);
			}
		}
		Write_Reg(PHY20,PORT_STATE,Reg2006);
		return;
	}
	if(ACL_setting->function == ACL_FUNC_LOGICPORT){
	    ACL_setting->type&=0x3;
	    Reg2511|=(ACL_setting->type<<6);
	    for(i=0;i<MAX_PROTOCOL_NUM;i++){
			if( ACL_setting->protocol[i].enable ){
				Reg2511|= (0x01<<(0+i));
			}
		}
	    for(i=0;i<MAX_RANGE_NUM;i++){
   			if( ACL_setting->range[i].enable ){
				Reg2511|= (0x01<<(4+i));
			}
		}
	    for(i=0;i<MAX_PROTOCOL_NUM;i++){
			Write_Reg(PHY25,QOS_PRE_LOGI_0+i, ACL_setting->protocol[i].port );  }
	    for(i=0;i<MAX_RANGE_NUM;i++){
			if(ACL_setting->range[i].s_port>ACL_setting->range[i].e_port){
				exchange(ACL_setting->range[i].s_port,ACL_setting->range[i].e_port);
			}
			Write_Reg(PHY25,QOS_USER_RG_LOW_0+(2*i),ACL_setting->range[i].s_port);
			Write_Reg(PHY25,QOS_USER_RG_HI_0 +(2*i),ACL_setting->range[i].e_port);
		}
		Write_Reg(PHY25,QOS_TCP_CTRL    ,Reg2511);
		Write_Reg(PHY25,QOS_LP_DROP,ACL_setting->lp_drop&0x3f);
		return ;
	}
	if(ACL_setting->function == ACL_FUNC_MULTIFIELD){
		Write_Reg(PHY26,MF_CTRL,0x8000);
		for(i=0;i<ACL_MAX_MULTI_ENTRY_NUM;i++){
			ACL_setting->acl_mf_entry[i].index = (unsigned char)i;
			if(ACL_setting->acl_mf_entry[i].action)
				ACL_MF_Set(&ACL_setting->acl_mf_entry[i]);
		}
		return ;
	}

	return;
}

void ACL_Query(struct _ACL_setting *ACL_setting,int mfIndex)
{
    u16 i;

	if(ACL_setting->function == ACL_FUNC_PHYPORT){
		for(i=0;i<MAX_PORT_NUM;i++){
			if(Read_Reg(PHY20,PORT_STATE)&(0x1<<(8+i)))
				ACL_setting->port_state[i] |= 0x1;
			if(Read_Reg(PHY20,PORT_STATE)&(0x1<<i))
				ACL_setting->port_state[i] |= 0x2;
		}
	}

	if(ACL_setting->function == ACL_FUNC_LOGICPORT){
	    ACL_setting->type = (Read_Reg(PHY25,QOS_TCP_CTRL)&0xc0)>>6;
		ACL_setting->lp_drop = (Read_Reg(PHY25,QOS_LP_DROP)&0x3f);

		for(i=0;i<MAX_PROTOCOL_NUM;i++){
			ACL_setting->protocol[i].enable = Read_Reg(PHY25,QOS_TCP_CTRL)&(0x1<<i)? 1:0;
			ACL_setting->protocol[i].port = Read_Reg(PHY25,QOS_PRE_LOGI_0+i);
			ACL_setting->protocol[i].queue = (Read_Reg(PHY25,QOS_TCP_QU_MAP)>>(i*2))&0x3;
		}
		for(i=0;i<MAX_RANGE_NUM;i++){
			ACL_setting->range[i].enable = Read_Reg(PHY25,QOS_TCP_CTRL)&(0x1<<(i+4))? 1:0;
			ACL_setting->range[i].s_port = Read_Reg(PHY25,QOS_USER_RG_LOW_0+(i*2));
			ACL_setting->range[i].e_port = Read_Reg(PHY25,QOS_USER_RG_LOW_0+(i*2)+1);
		}
	}
	if(ACL_setting->function == ACL_FUNC_MULTIFIELD){
//		for(i=0;i<ACL_MAX_MULTI_ENTRY_NUM;i++){
    	    ACL_setting->acl_mf_entry[mfIndex].index = (unsigned char)mfIndex;
	        ACL_MF_Query(&ACL_setting->acl_mf_entry[mfIndex]);
//	    }
	}
	return;
}

void Mirror_Set(struct _Mirror_setting *Mirror_setting)
{	u16 Reg2020=Read_Reg(PHY20,PORT_MIRROR_0),Reg2021=0;
	if(!(Mirror_setting->enable))	//disable Mirror function
	{	Reg2020 &= ~0x8000;
		Write_Reg(PHY20,PORT_MIRROR_0,Reg2020);
		return;
	}
	else
	{	Reg2020 = 0x8000;
	}

	Mirror_setting->mode&=0x3;
	Reg2020 |= (Mirror_setting->mode<<13);

	Mirror_setting->rx_from%=MAX_MIRROR_PORT;
	Reg2020 |= (0x01<<Mirror_setting->rx_from);

	Mirror_setting->tx_from%=MAX_MIRROR_PORT;
	Reg2021 |= (0x01<<Mirror_setting->tx_from);

	Mirror_setting->to%=MAX_MIRROR_PORT;
	Reg2021 |= (Mirror_setting->to << 12);

	Write_Reg(PHY20,PORT_MIRROR_0,Reg2020);
	Write_Reg(PHY20,PORT_MIRROR_1,Reg2021);
}

void Mirror_Query(struct _Mirror_setting *Mirror_setting)
{	u16 Reg2020=Read_Reg(PHY20,PORT_MIRROR_0);
	u16 Reg2021=Read_Reg(PHY20,PORT_MIRROR_1);
	u8  i;
	if(Reg2020 & 0x8000)
	{	Mirror_setting->enable=1;	}

	Mirror_setting->mode=  ((Reg2020>>13)&0x3) ;

	for(i=0;i<MAX_MIRROR_PORT;i++)
	{
		if( Reg2020 & (0x01<<i) )
		{ Mirror_setting->rx_from=i; }
		if( Reg2021 & (0x01<<i) )
		{ Mirror_setting->tx_from=i; }
	}

	Mirror_setting->to = ((Reg2021>>12)&0x7);

}

void Datarate_Set(struct _Datarate_setting *Datarate_setting)
{	u16 Reg_cmd,Reg_BW_MBS=0xf000,i;

	for(i=0;i<MAX_PORT_NUM;i++)
	{
		if(Datarate_setting->tx_rate[i]>DATARATE_MAX_RATE)
		{Datarate_setting->tx_rate[i]=0;}
		Write_Reg(PHY21, BW_TI, 0x0001);
		Write_Reg(PHY21, BW_CREDIT_SIZE, Datarate_setting->tx_rate[i]*(32/8));//32/8bit
		Write_Reg(PHY21, BW_MBS, Reg_BW_MBS);
		Reg_cmd= (0x308|i) ; // ( start | write | tx | port )
		Write_Reg(PHY21, BW_SETTING, Reg_cmd);

		if(Datarate_setting->rx_rate[i]>DATARATE_MAX_RATE)
		{Datarate_setting->rx_rate[i]=0;}
		Write_Reg(PHY21, BW_TI, 0x0001);
		Write_Reg(PHY21, BW_CREDIT_SIZE, Datarate_setting->rx_rate[i]*(32/8));//32/8bit
		Write_Reg(PHY21, BW_MBS, Reg_BW_MBS);
		Reg_cmd= (0x300|i) ; // ( start | write | rx | port )
		Write_Reg(PHY21, BW_SETTING, Reg_cmd);
	}
}

void Datarate_Query(struct _Datarate_setting *Datarate_setting)
{	u16 Reg_cmd,Reg_CREDIT,i;
	for(i=0;i<MAX_PORT_NUM;i++)
	{
		Reg_cmd= (0x208|i) ; // ( start | read | tx | port )
		Write_Reg(PHY21, BW_SETTING, Reg_cmd);
		Reg_CREDIT=Read_Reg(PHY21, BW_CREDIT_SIZE);
		Datarate_setting->tx_rate[i]= ( Reg_CREDIT/(32/8) );

		Reg_cmd= (0x200|i) ; // ( start | read | tx | port )
		Write_Reg(PHY21, BW_SETTING, Reg_cmd);
		Reg_CREDIT=Read_Reg(PHY21, BW_CREDIT_SIZE);
		Datarate_setting->rx_rate[i]= ( Reg_CREDIT/(32/8) );
	}
}

void case_HWIGMP(void)
{
	Write_Reg(PHY20,LEARNING_CTRL_REG	,0x0028);//(1K unicast & 1K multicast)
	Write_Reg(PHY21,5		,0x0467);//(enable H/W IGMP & learn router port)
	Write_Reg(PHY21,6		,0x9640);//(router port timeout=300 seconds)
	Write_Reg(PHY21,7		,0x9601);//(IGMP timeout=300 seconds)
}


static int os_do_ioctl(struct net_device *dev, struct ifreq *ifr, int cmd)
{
//	struct mii_ioctl_data *mii = (struct mii_ioctl_data*)&ifr->ifr_data;
//	printk(KERN_ERR "\n IP175d IOCTL called! (%08x)\n",cmd);
	switch(cmd)
	{
	case	SIOCSMIIREG:	//WriteMDC
		{
		struct mii_ioctl_data *mii = (struct mii_ioctl_data*)&ifr->ifr_data;
		//printk(KERN_ERR"Phy:%d Reg:%d D:%04x",mii->phy_id,mii->reg_num,mii->val_in);
		Write_Reg(mii->phy_id,mii->reg_num,mii->val_in);
		}
		return 0;
		break;
	case	SIOCGMIIREG:	//ReadMDC
		{
		struct mii_ioctl_data *mii = (struct mii_ioctl_data*)&ifr->ifr_data;
		//printk(KERN_ERR"Phy:%d Reg:%d",mii->phy_id,mii->reg_num);
		mii->val_out=Read_Reg(mii->phy_id,mii->reg_num);
		//printk(KERN_ERR"D:%04x",mii->val_out);
		}
		return 0;
		break;
	case	SIOCVLAN:	//VLAN Setting
		{
		struct _VLAN_setting *VLAN_setting=ifr->ifr_data;
		if(VLAN_setting->cmd&CMD_WRITE)	//write
		 {	VLAN_Set(VLAN_setting);		 }
		else
		 {	VLAN_Query(VLAN_setting);	 }

		}
		return 0;
	case	SIOCQOS:	//QoS Setting
		{
		struct _QoS_setting *QoS_setting=ifr->ifr_data;
//		printk(KERN_ERR" QoS(0x%04x) called!!",SIOCQOS);
		if(QoS_setting->cmd&CMD_WRITE)	//write
		 {	QoS_Set(QoS_setting);		 }
		else
		 {	QoS_Query(QoS_setting);		 }
		}
		return 0;
	case	SIOCMIRROR:	//Mirror Setting
		{
		struct _Mirror_setting *Mirror_setting=ifr->ifr_data;
		if(Mirror_setting->cmd&CMD_WRITE)	//write
		 {	Mirror_Set(Mirror_setting);	 }
		else
		 {	Mirror_Query(Mirror_setting);	 }
		}
		return 0;
	case	SIOCDATARATE://Datarate Setting
		{
		struct _Datarate_setting *Datarate_setting=ifr->ifr_data;
		if(Datarate_setting->cmd&CMD_WRITE)	//write
		 {	Datarate_Set(Datarate_setting);	 }
		else
		 {	Datarate_Query(Datarate_setting);	 }
		}
		return 0;

  case  SIOCLUT:
  {
    struct _LUT_setting *lut = ifr->ifr_data;
    if(lut->cmd&CMD_WRITE)
        LUT_Set(lut);
  }
    return 0;

  case  SIOCACL:
  {
    struct  _ACL_setting *acl = ifr->ifr_data;
    if(acl->cmd&CMD_WRITE){
      ACL_Set(acl);
    }
  }
  return 0;

  case	SIOCHWIGMP:	//Hardware IGMP setting
	{
        struct _IGMP_setting *igmp=ifr->ifr_data;
        if(igmp->cmd&CMD_WRITE){
            IGMP_Set(igmp);
        }
        else{
            IGMP_Query(igmp);
        }
		return 0;
	};
   case SIOCIGMPENT:
	{
		struct _IGMP_entry *igmp=ifr->ifr_data;
        if(igmp->cmd&CMD_WRITE){
            IGMP_Set_Entry(igmp);
        }
        else{
            IGMP_Query_Entry(igmp);
        }		
		return 0;
	}
  }
  return -EOPNOTSUPP;
}
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3, 6, 0)
static netdev_tx_t ip175d_xmit(struct sk_buff *skb, struct net_device *dev)
{
	dev_kfree_skb(skb);
	return NETDEV_TX_OK;
}
#endif
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)
static const struct net_device_ops ip175d_dev_ops = {
	.ndo_do_ioctl = &os_do_ioctl,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3, 6, 0)
//fix linux panic in newer versions
	.ndo_start_xmit = &ip175d_xmit,
#endif	
};
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
static int linux_probe(struct net_device *dev)
#else
struct net_device * __init linux_probe(void)
#endif
{	u8 MACID[6]={0x00,0x00,0x00,0x00,0x17,0x5d};
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,5,0)
	struct net_device* dev;
	u16 register_err;
#endif


#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
	dev=init_etherdev(dev,0);	//get device name eth0
#else
	dev= alloc_etherdev(sizeof(*dev));	//get device name eth0
#endif
	if(!dev)
	{	printk("\ndriver allocation fail");
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
		return -ENOMEM;
#else
		return ERR_PTR(-ENOMEM);
#endif
	}
	pNet_dev=dev;
	strcpy(dev->name,DRV_NAME);
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 30)
	dev->netdev_ops		= &ip175d_dev_ops;
#else
	dev->do_ioctl		= &os_do_ioctl;
#endif
#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 23)
	SET_MODULE_OWNER(dev);
#endif
	memcpy(dev->dev_addr,MACID,sizeof(MACID));

	printk("\nModule load!");
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
	return 0;
#else
	register_err=register_netdev(dev);
	if( register_err )	//register netdevice fail
	{	printk("\nregister netdev fail");
		//release_region(dev->base_addr,2);
		free_netdev(dev);
		return(ERR_PTR(register_err));
	}
	return dev;
#endif
}
int __init init_module(void)
{
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
	return linux_probe(0);
#else
	linux_probe();
	return 0;
#endif
}
void __exit cleanup_module(void)
{
	printk(KERN_ERR "\nModule");
//	printk("\nModule(%s)",pNet_dev->name);
	unregister_netdev(pNet_dev);
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0)
	kfree(pNet_dev);
#else
	free_netdev(pNet_dev);
#endif
	printk(KERN_ERR " removed!\n");
}

//#define I3210
#ifdef I3210
module_init(init_module);
module_exit(cleanup_module);
#endif

#endif

