/******************************************************************************
*
*   Name:           switch.h
*
*   Description:    SIOC data structure + switch Header
*
*   Copyright:      (c) 2005-2050    IC Plus Corp.
*                   All rights reserved.  By DeNa + Chance
*
*******************************************************************************/
#ifndef _IP175D_H_
#define _IP175D_H_

#ifndef SIOCDEVPRIV
#define SIOCDEVPRIV		0x89f0
#define SIOCVLAN		SIOCDEVPRIV+0x0
#define SIOCQOS			SIOCDEVPRIV+0x1
#define SIOCMIRROR		SIOCDEVPRIV+0x2
#define SIOCDATARATE	SIOCDEVPRIV+0x3
#define SIOCLUT    	SIOCDEVPRIV+0x4
#define SIOCACL       	SIOCDEVPRIV+0x5

#define SIOCIGMPENT		SIOCDEVPRIV+0xe
#define SIOCHWIGMP		SIOCDEVPRIV+0xf
#endif
/*
#ifndef u32
typedef unsigned long   u32;
#endif
#ifndef u16
typedef unsigned short  u16;
#endif
#ifndef u8
typedef unsigned char   u8;
#endif
*/
#define CMD_WRITE		0x10
#define CMD_READ		0x00

#define MAX_PORT_NUM	6
#define MAX_VLAN_NUM	16
#define TBASE_VLAN_NUM	MAX_VLAN_NUM
#define PBASE_VLAN_NUM	6

struct _VLAN_entry
{
  unsigned char	valid;	//0->disable  !0->Enable
  unsigned int	VID;	//1~4093
  unsigned char	FID;	//0~15
  unsigned char	member;	// bit[5:0] -> P5~P0
  unsigned char	AddTag;	// bit[5:0] -> P5~P0
  unsigned char	RmvTag;	// bit[5:0] -> P5~P0
  unsigned char qos_enable;
  unsigned char queue;
//  unsigned int	PVID;	//1~4093
};

#define VLAN_CMD_TBASE	0x01
#define VLAN_CMD_PBASE	0x00
#define VLAN_CMD_MIX	0x02

#define VLAN_MODE_ALL_TBASE	0x3f
#define VLAN_MODE_ALL_PBASE 0x00

#define VLAN_CMD_OKMASK	0x3f
#define VLAN_CMD_OK	0x80

struct _VLAN_setting
{
  unsigned char	cmd;	//bit4->1:write 0:read , bit0->1:TagVLAN 0:PortBaseVLAN
  unsigned char	vmode;	//bit[5:0] in write mode:0->PortBaseVLAN !0->TagBase VLAN
  unsigned char cmode;  //bit[5:0] in vlan mode: 0 - VID classification 1 - PVID classification
  unsigned int PVID[MAX_PORT_NUM];
  struct _VLAN_entry VLAN_entry[MAX_VLAN_NUM];
};


#define QoS_QUEUE_0				0x00
#define QoS_QUEUE_1				0x01
#define QoS_QUEUE_2				0x02
#define QoS_QUEUE_3				0x03
#define QoS_MAX_QUEUE			4
struct _protocol_entry
{
  unsigned char  enable;		// 0: disable  !0: enable
  unsigned short port;			// TCP/UDP port number
  unsigned char  queue;			// queue0~3
};

struct _range_entry
{
  unsigned char  enable;		// 0: disable  !0: enable
  unsigned short s_port;		// TCP/UDP port range start number
  unsigned short e_port;		// TCP/UDP port range end number
  unsigned char  queue;			// queue0~3
};

#define QoS_CLASS_PORT0_ENABLE  0x1
#define QoS_CLASS_PORT1_ENABLE  0x2
#define QoS_CLASS_PORT2_ENABLE  0x4
#define QoS_CLASS_PORT3_ENABLE  0x8
#define QoS_CLASS_PORT4_ENABLE  0x10
#define QoS_CLASS_PORT5_ENABLE  0x20
#define QoS_CLASS_PORT_ALL_ENABLE	0x3f

#define QoS_CLASS_COS0_ENABLE   0x1
#define QoS_CLASS_COS1_ENABLE   0x2
#define QoS_CLASS_COS2_ENABLE   0x4
#define QoS_CLASS_COS3_ENABLE   0x8
#define QoS_CLASS_COS4_ENABLE   0x10
#define QoS_CLASS_COS5_ENABLE   0x20
#define QoS_CLASS_COS_ALL_ENABLE	0x3f

#define QoS_CLASS_ACL_ENABLE        0x1
#define QoS_CLASS_VLAN_ENABLE       0x2
#define QoS_CLASS_LP_ENABLE         0x4
//#define QoS_CLASS_PORT_ALL_ENABLE   0x8
//#define QoS_CLASS_COS_ALL_ENABLE    0x10

#define QoS_TYPE_DISABLE		0x00
#define QoS_TYPE_SOURCE			0x01
#define QoS_TYPE_DESTINATION	0x02
#define QoS_TYPE_SOURCEnDEST	0x03

#define QoS_MODE_WRR			0x00
#define QoS_MODE_WFQ			0x01
#define QoS_MODE_SPM			0x02
#define QoS_MODE_SP 			0x03
#define QoS_MODE_HIGH_PASS		QoS_MODE_SP

#define MAX_PROTOCOL_NUM		4
#define MAX_RANGE_NUM			2
#define MAX_VLAN_PRI_NUM        8
#define MAX_COS_PRI_NUM         64

struct _QoS_setting
{
  unsigned char	cmd;	//bit4->1:write 0:read
  unsigned char enable;	// 0:disable !0:enable
  unsigned char pri_port_enable;//bit0~5 => for port0~5 1:enable 0:disable port-based priority
  unsigned char pri_cos_enable;//bit0~5 => for port0~5 1:enable 0:disable CoS priority
  /*  priority_class:priority classification.for each bit 1:enable 0:disable
   *  bit0:user-defined(ACL) priority/VLAN table priority
   *  bit1:VLAN priority
   *  bit2:Logical-port priority
   *  bit3:port-based priority all port on/off
   *  bit4:COS-based priority all port on/off
   */
  unsigned char priority_class;
  unsigned char port_based_queue[MAX_PORT_NUM];
  unsigned char vlan_queue[MAX_VLAN_PRI_NUM];
  unsigned char cos_queue[MAX_COS_PRI_NUM];
  unsigned char type;	// 0:disable 1:SA 2:DA 3:DA+SA
  unsigned char mode;	// 0:WRR	3:High Priority first
  unsigned int  queue_weight[QoS_MAX_QUEUE];//weight for q0(low)~q3(high) (unit:packet)
  unsigned int  queue_rate[QoS_MAX_QUEUE];//WFQ:rate for q0(low)~q3(high) (unit:32 Kbps)
  struct _protocol_entry protocol[MAX_PROTOCOL_NUM];
  struct _range_entry range[MAX_RANGE_NUM];
};

#define MAC_LUT_ENABLE      0x1
#define MAC_LUT_DISABLE     0x0

#define LUT_MAC_UNICAST			0x0
#define LUT_MAC_MULTICAST		0x1
#define LUT_IGMP_MULTICAST		0x2

#define LUT_STATIC_ENTRY    0x2

#define MAC_LUT_PRI_DMAC		0x1
#define MAC_LUT_PRI_SMAC		0x2
#define MAC_LUT_PRI_BOTH		0x3

#define MAC_LUT_FILTER_SMAC             0x1
#define MAC_LUT_FILTER_IGNORE_VLAN      0x2
#define MAC_LUT_FILTER_MIRROR           0x3

struct _MAC_LUT_entry
{
	unsigned char valid;// in unicast: set 1 for static entry, in mcast& igmp: set 1 for valid.
	unsigned char type;// 0:unicast 1:multicast 2:IGMP
	unsigned char entry;//bit 0~1: entry num(0~3)
	unsigned char fid;//0~15
	unsigned char MAC[6];
	unsigned char age;
	unsigned char pri_function;//1:match DMAC 2:match SMAC 3:match either DMAC or SMAC
	//filter_function - 1:drop if SA match 2:ignore VLAN member 3:copy to mirror port if DA match
	unsigned char filter_function;
	unsigned char queue;//0~3
	unsigned char phy_port;//unicast- 0:drop 1~6: forward to port0~5
                           //multicast- bit0~5: forward to port0~5 enable/disable
                           //IGMP     - bit0~5: forward to port0~5 enable/disable
	unsigned char timeout[MAX_PORT_NUM];
};

#define LUT_2K					0x0
#define LUT_1K_1K				0x1

struct _LUT_setting
{
	unsigned char lut_mode;
	unsigned char cmd;
	struct _MAC_LUT_entry lut_entry;
};

/*
	func:
	bit 0 	- HW IGMP snooping                              1:en 0:dis
	bit 1 	- learn router port automatically 				1:en 0:dis
	bit 2 	- learn router port even if sip=0.0.0.0 		1:en 0:dis
	bit 3 	- broadcast "report pkt" to all ports			1:en 0:dis
	bit 4 	- discard "leave pkt"							1:en 0:dis
	bit 5~6 - filter mode for unknown IP multicast data		0:discard 1:to CPU 2:flood pkt 3:to router port
	bit 7	- broadcast IP multicast control pkt			1:en 0:dis
	bit 8	- broadcast unknown IGMP pkt					1:en 0:dis
	bit 9	- IP multicast data pkt forward to group member	1:en 0:dis
			  ports & router ports
	bit10	- Fast leave									1:en 0:dis
*/
void igmp_set_func(u16 func);
u16 igmp_get_func(void);

/*
	ports:
	bit 0~5	-	Default router ports,each bit refers to each port.
*/
void igmp_set_router_port(u8 ports);
u8 igmp_get_router_port(void);

/*
	Set timeout for router ports
	timeout = timeout unit * timeout scale(unit:s)
	bit 0~5 -   Set to 0.
	bit 6~7	-	timeout unit		0:1s 1:2s 2:4s 3:8s
	bit 8~15-	timeout scale
*/
void igmp_set_router_timeout(u16 timeout);
u16 igmp_get_router_timeout(void);
/*
	Set timeout for group ports
	timeout = timeout unit * timeout scale(unit:s)
	bit 0~1	-	timeout unit		0:1s 1:2s 2:4s 3:8s
	bit 8~15-	timeout scale
*/
void igmp_set_group_timeout(u16 timeout);
u16 igmp_get_group_timeout(void);

struct _IGMP_setting
{
    u8  cmd;
	u16	func;
	u8	router_port;
	u16 rp_timeout;
	u16 group_timeout;
};
#define IGMP_DEL_ENTRY  0
#define IGMP_ADD_ENTRY	1
struct _IGMP_entry
{
	u8 cmd;
	u8 type;
	u8 mac[6];
	u8 port;
};

#define ACL_MAX_MULTI_ENTRY_NUM 8
#define ACL_MAX_MACF_NUM        2048

#define ACL_FILTER_PHYPORT_ENABLE       0x1
#define ACL_FILTER_MAC_ENABLE           0x2
#define ACL_FILTER_ETHTYPE_ENABLE       0x4
#define ACL_FILTER_IP_PROTOCOL_ENABLE   0x8
#define ACL_FILTER_VLAN_ENABLE          0x10
#define ACL_FILTER_COS_ENABLE           0x20
#define ACL_FILTER_IP_ADDRESS_ENABLE    0x40
#define ACL_FILTER_LOGICAL_PORT_ENABLE  0x80

#define ACL_ACTION_RATE_CONTROL         0x1
#define ACL_ACTION_MONITOR_RATE         0x2
#define ACL_ACTION_QUEUE_SET            0x3
#define ACL_ACTION_MIRROR_PORT          0x4
#define ACL_ACTION_FORWARD_CPU          0x5
#define ACL_ACTION_DROP                 0x6
#define ACL_ACTION_FORWARD				0x7

#define ACL_QOS_QUEUE_DIABLE	0x0
#define ACL_QOS_QUEUE0			0x4
#define ACL_QOS_QUEUE1			0x5
#define ACL_QOS_QUEUE2			0x6
#define ACL_QOS_QUEUE3			0x7

#define ACL_FILTER_IP_MAC_DISABLE           0x0
#define ACL_FILTER_IP_SINGAL_SOURCE         0x1
#define ACL_FILTER_IP_SINGAL_DESTINATION    0x2
#define ACL_FILTER_IP_SINGAL_BOTH           0x3
#define ACL_FILTER_IP_RANGE_SOURCE          0x4
#define ACL_FILTER_IP_RANGE_DESTINATION     0x5
#define ACL_FILTER_IP_RANGE_BOTH            0x6
#define ACL_FILTER_MAC_SMAC_ENABLE          0x7
#define ACL_FILTER_MAC_DMAC_ENABLE          0x8
#define ACL_FILTER_MAC_BOTH_ENABLE          0x9

#define ACL_PHY_PORT0_ENABLE	0x1
#define ACL_PHY_PORT1_ENABLE	0x2
#define ACL_PHY_PORT2_ENABLE	0x4
#define ACL_PHY_PORT3_ENABLE	0x8
#define ACL_PHY_PORT4_ENABLE	0x10
#define ACL_PHY_PORT_ALL_ENABLE	0x1f

/* for logical port protocol */
#define ACL_FILTER_LP_STCP			0x1
#define ACL_FILTER_LP_SUDP          0x2
#define ACL_FILTER_LP_DTCP          0x3
#define ACL_FILTER_LP_DUDP			0x4
#define ACL_FILTER_LP_STCP_DTCP		0x5
#define ACL_FILTER_LP_STCP_DUDP		0x6
#define ACL_FILTER_LP_SUDP_DTCP		0x7
#define ACL_FILTER_LP_SUDP_DUDP		0x8
#define ACL_FILTER_LP_RANGE_STCP	0x9
#define ACL_FILTER_LP_RANGE_SUDP	0xa
#define ACL_FILTER_LP_RANGE_SBOTH	0xb
#define ACL_FILTER_LP_RANGE_DTCP	0xc
#define ACL_FILTER_LP_RANGE_DUDP	0xd
#define ACL_FILTER_LP_RANGE_DBOTH	0xe
#define ACL_FILTER_LP_RANGE_BOTH_TCP	0xf
#define ACL_FILTER_LP_RANGE_BOTH_UDP	0x10
#define ACL_FILTER_LP_RANGE_BOTH_BOTH	0x11

struct _ACL_MF_entry
{
	unsigned char 	index;
	unsigned char   valid;
	/*  function:This is for enable/disable each field 1:enable 0:disable
	 *  bit0:physical port  bit1:MAC
	 *  bit2:ethernet type  bit3:IP protocol
	 *  bit4:VLAN           bit5:DSCP/TOS
	 *  bit6:IP Address     bit7:Logical port
	 */
	unsigned char   function;
	unsigned char   port_num;
	unsigned short  ether_type;
	unsigned char   ip_protocol;

	unsigned char   action;
	unsigned char   queue;
	unsigned short  rate;// unit:8Kbps
	unsigned int	traffic_count;// unit:Bytes
	unsigned char   cos_type;//Class of Service Number:VLAN/DSCP/TOS
	unsigned short  ip_mac_type;//0:disable 1:source 2:desination 3:both - singal IP mode
								//4:source  5:destination   6:both       - ranged IP mode
								//7:source  8:destination   9:both       - MAC mode
	unsigned char 	logical_port_protocol;

    unsigned char   sMAC[6];
    unsigned char   dMAC[6];
    unsigned char   sip[4];
    unsigned char   eip[4];
    unsigned short  s_port;
    unsigned short  e_port;
};

#define ACL_FUNC_PHYPORT    0x1
#define ACL_FUNC_LOGICPORT  0x2
#define ACL_FUNC_MULTIFIELD 0x3

#define ACL_LP_USER0_DROP   0x1
#define ACL_LP_USER1_DROP   0x2
#define ACL_LP_PREDEF0_DROP 0x4
#define ACL_LP_PREDEF1_DROP 0x8
#define ACL_LP_PREDEF2_DROP 0x10
#define ACL_LP_PREDEF3_DROP 0x20
#define ACL_LP_ALL_DROP     0x3f

#define ACL_TYPE_DISABLE        0x00
#define ACL_TYPE_SOURCE         0x01
#define ACL_TYPE_DESTINATION    0x02
#define ACL_TYPE_SOURCEnDEST    0x03

struct _ACL_setting
{
	unsigned char cmd;
	unsigned char function;
	unsigned char port_state[MAX_PORT_NUM];//bit0:Forwarding bit1:Learning 1:enable 0:disable
	unsigned char type;
	unsigned char lp_drop;
    struct _protocol_entry protocol[MAX_PROTOCOL_NUM];
    struct _range_entry range[MAX_RANGE_NUM];

	struct _ACL_MF_entry acl_mf_entry[ACL_MAX_MULTI_ENTRY_NUM];
};


#define MAX_MIRROR_PORT		MAX_PORT_NUM

#define MIRROR_MODE_RX		0x0
#define MIRROR_MODE_TX		0x1
#define MIRROR_MODE_TX2RX	0x2
#define MIRROR_MODE_TXnRX	0x3
struct _Mirror_setting
{
  unsigned char	cmd;	// bit4->1:write 0:read
  unsigned char enable;	// 0:disable !0:enable
  unsigned char mode;	// 0:rx 1:tx 2:tx_to_rx 3:tx nad rx
  unsigned char tx_from;// mirror from which port's Tx (p0~p5)
  unsigned char rx_from;// mirror from which port's Rx (p0~p5)
  unsigned char to;		// mirror to which port p0~p5
};

#define DATARATE_MAX_RATE	3124
struct _Datarate_setting
{
  unsigned char	cmd;	// bit4->1:write 0:read
  unsigned short tx_rate[MAX_PORT_NUM];// per unit is 32Kbps (0~3124 0:full speed)
  unsigned short rx_rate[MAX_PORT_NUM];// per unit is 32Kbps (0~3124 0:full speed)
};
//////////////////////////under is switch ip175d register map/////////////

//PHY Control
#define		PHY0			0
#define		PHY_CTRL		0
#define		PHY_STATUS		1
#define		PHY_AN_ADV		4
#define		PHY_AN_LPA		5


//HU Table
#define 	PHY20 			20
#define		CONG_CTRL		5
#define		PORT_STATE		6
#define 	LEARNING_CTRL_REG 	13
#define		BF_STM_CTRL		16
#define		BF_STM_THR_0		17
#define		PORT_MIRROR_0		20
#define		PORT_MIRROR_1		21

//Rate Control
#define		PHY21			21//0x0B//21 original 0x11 for FPGA
#define     IGMP_CTRL       5
#define     IGMP_RP_TIME    6
#define     IGMP_GROUP_TIME 7
#define 	BW_TI			8
#define 	BW_MBS			9
#define 	BW_CREDIT_SIZE		10
#define 	BW_TIME			11
#define 	BW_SETTING		12
#define		LEARN_CONSTRAIN		13
#define		MAC_COMMAND		14
#define		MAC_ADDR0		15
#define		MAC_ADDR1		16
#define		MAC_ADDR2		17
#define		MAC_CONTROL		18
#define		MAC_STATIC		19
#define		CRC_COUNTER		25
//VLAN Control
#define 	PHY22			22

#define     VLAN_CLASS                  0
#define     VLAN_INGRESS                1
#define     VLAN_EGRESS                 2
#define     VLAN_INFO_0                 4
#define     VLAN_INFO_1                 VLAN_INFO_0+1
#define     VLAN_INFO_2                 VLAN_INFO_0+2
#define     VLAN_INFO_3                 VLAN_INFO_0+3
#define     VLAN_INFO_4                 VLAN_INFO_0+4
#define     VLAN_INFO_5                 VLAN_INFO_0+5
#define     VLAN_VALID                  10
#define     VLAN_QU_NUM_EN              11
#define     VLAN_STP_IDX_EN             12
#define     VLAN_REW_VALN_PRI_EN        13

#define     VLAN_FID_VID0               14
#define     VLAN_FID_VID1               VLAN_FID_VID0+1
#define     VLAN_FID_VID2               VLAN_FID_VID0+2
#define     VLAN_FID_VID3               VLAN_FID_VID0+3
#define     VLAN_FID_VID4               VLAN_FID_VID0+4
#define     VLAN_FID_VID5               VLAN_FID_VID0+5
#define     VLAN_FID_VID6               VLAN_FID_VID0+6
#define     VLAN_FID_VID7               VLAN_FID_VID0+7
#define     VLAN_FID_VID8               VLAN_FID_VID0+8
#define     VLAN_FID_VID9               VLAN_FID_VID0+9
#define     VLAN_FID_VID10              VLAN_FID_VID0+10
#define     VLAN_FID_VID11              VLAN_FID_VID0+11
#define     VLAN_FID_VID12              VLAN_FID_VID0+12
#define     VLAN_FID_VID13              VLAN_FID_VID0+13
#define     VLAN_FID_VID14              VLAN_FID_VID0+14
#define     VLAN_FID_VID15              VLAN_FID_VID0+15

#define     PHY23                       23
#define     VLAN_MEMBER_00              00
#define     VLAN_MEMBER_02              VLAN_MEMBER_00+1
#define     VLAN_MEMBER_04              VLAN_MEMBER_00+2
#define     VLAN_MEMBER_06              VLAN_MEMBER_00+3
#define     VLAN_MEMBER_08              VLAN_MEMBER_00+4
#define     VLAN_MEMBER_10              VLAN_MEMBER_00+5
#define     VLAN_MEMBER_12              VLAN_MEMBER_00+6
#define     VLAN_MEMBER_14              VLAN_MEMBER_00+7
#define     VLAN_ADDTAG_00              8
#define     VLAN_ADDTAG_02              VLAN_ADDTAG_00+1
#define     VLAN_ADDTAG_04              VLAN_ADDTAG_00+2
#define     VLAN_ADDTAG_06              VLAN_ADDTAG_00+3
#define     VLAN_ADDTAG_08              VLAN_ADDTAG_00+4
#define     VLAN_ADDTAG_10              VLAN_ADDTAG_00+5
#define     VLAN_ADDTAG_12              VLAN_ADDTAG_00+6
#define     VLAN_ADDTAG_14              VLAN_ADDTAG_00+7
#define     VLAN_REMOVETAG_00           16
#define     VLAN_REMOVETAG_02           VLAN_REMOVETAG_00+1
#define     VLAN_REMOVETAG_04           VLAN_REMOVETAG_00+2
#define     VLAN_REMOVETAG_06           VLAN_REMOVETAG_00+3
#define     VLAN_REMOVETAG_08           VLAN_REMOVETAG_00+4
#define     VLAN_REMOVETAG_10           VLAN_REMOVETAG_00+5
#define     VLAN_REMOVETAG_12           VLAN_REMOVETAG_00+6
#define     VLAN_REMOVETAG_14           VLAN_REMOVETAG_00+7
#define     VLAN_MISC_00                24
#define     VLAN_MISC_02                VLAN_MISC_00+1
#define     VLAN_MISC_04                VLAN_MISC_00+2
#define     VLAN_MISC_06                VLAN_MISC_00+3
#define     VLAN_MISC_08                VLAN_MISC_00+4
#define     VLAN_MISC_10                VLAN_MISC_00+5
#define     VLAN_MISC_12                VLAN_MISC_00+6
#define     VLAN_MISC_14                VLAN_MISC_00+7

#define		PHY25			25
#define		QOS_CTRL		0
#define		QOS_PORT_PRI		1
#define		QOS_TAG_PRI		2
#define		QOS_TOS_PRI_0		3
#define		QOS_TOS_PRI_1		QOS_TOS_PRI_0+1
#define		QOS_TOS_PRI_2		QOS_TOS_PRI_0+2
#define		QOS_TOS_PRI_3		QOS_TOS_PRI_0+3
#define		QOS_TOS_PRI_4		QOS_TOS_PRI_0+4
#define		QOS_TOS_PRI_5		QOS_TOS_PRI_0+5
#define		QOS_TOS_PRI_6		QOS_TOS_PRI_0+6
#define		QOS_TOS_PRI_7		QOS_TOS_PRI_0+7
#define		QOS_TCP_CTRL		11
#define		QOS_PRE_LOGI_0		12
#define		QOS_PRE_LOGI_1		QOS_PRE_LOGI_0+1
#define		QOS_PRE_LOGI_2		QOS_PRE_LOGI_0+2
#define		QOS_PRE_LOGI_3		QOS_PRE_LOGI_0+3
#define		QOS_USER_RG_LOW_0	16
#define		QOS_USER_RG_HI_0	17
#define		QOS_USER_RG_LOW_1	QOS_USER_RG_LOW_0+2
#define		QOS_USER_RG_HI_1	QOS_USER_RG_HI_0+2
#define		QOS_TCP_QU_MAP		20
#define		QOS_LP_DROP			21
#define		QOS_SCH_CONFIG		22
#define		QOS_SCH_WEIGHT		23

#define     PHY26                       26
#define     MF_CTRL                     0
#define     MF_CLASS                    1
#define     MF_IM_SA0                   2
#define     MF_IM_SA1                   MF_IM_SA0+1
#define     MF_IM_SA2                   MF_IM_SA0+2
#define     MF_IM_DA0                   5
#define     MF_IM_DA1                   MF_IM_DA0+1
#define     MF_IM_DA2                   MF_IM_DA0+2
#define     MF_ET_VALUE                 8
#define     MF_REG9                     9
#define     MF_TCP_UDP                  10
#define     MF_LG_SP_NUM                11
#define     MF_LG_DP_NUM                12
#define     MF_SP_PORTNUM               13
#define     MF_BEHAVIOR                 14
#define     MF_TI                       15
#define     MF_MBS                      16
#define     MF_CREDIT_SIZE              17
#define     MF_TSEL                     18
#define     MF_VALID                    19
#define     MF_ACCESS_CTRL              20
#define     MF_CNT_LSB                  21
#define     MF_CNT_MSB                  22
#define	    MF_OVERFLOW			23

#define     PHY27                       27//0x23
#define     QUEUE_MONITOR               9

#endif
