#ifndef _SI_ADT_H
#define _SI_ADT_H

#include "proslic.h"
#include "si3217x_intf.h"
#include "proslic_mlt.h"
#include "proslic_mlt_math.h"

#define DEBUG_SLIC_ON

#if 0
/* Basic info of the Si3217x chip */
#define NUMBER_OF_DEVICES                   1
#define NUMBER_OF_PROSLIC                   NUMBER_OF_DEVICES
#define CHAN_PER_DEVICE                     1
#define NUMBER_OF_CHAN                      (NUMBER_OF_DEVICES*CHAN_PER_DEVICE)
#endif
/* Basic info of the Si3217x chip */
#define MAX_PORT_NUM                        1   /* max port num */

#if 0
#define PROSLIC_DEVICE_TYPE                 SI3217X
#define PROSLIC_TG_TIMER_ENABLED            1
#define PROSLIC_TG_TIMER_DISABLED           0
#endif

/* slic line state */
#define N_STATES                            4 /* all phone state */ 
#define HOOKON                              0 /* had HookOn */
#define HOOKOFFING                          1 /* HookOn turn to HookOff. no finish */  
#define HOOKOFF                             2 /* had HookOff */
#define HOOKONING                           3 /* HookOff turn to HookOn. no finish */ 

/* slic line event */
#define EV_LOW                              0   /* onhook */
#define EV_HIGH                             1   /* offhook */
#define PULSE_FILTER_TIME                   1
#define FLASH_EV_FLG                        0x80

/* daa line event */                        
#define EV_RING_ON                          1
#define EV_RING_OFF                         0
#define EV_DAA_HOOK_ON                      0
#define EV_DAA_HOOK_OFF                     1
                                            
#if 0
#define MAX_IRQS_NUM                        36

#define  CHIP_ZARLINK                       0
#define  CHIP_SILICONLAB                    1
#endif

#define  MAX_RING_CNT                       20
#define  MAX_TEST_TIMEOUT                   6000        /* 1 Min */

#if 0
/* power manage for slic */
#define     NORMAL_POWER        0
#define     NO_BATTARY          1
#define     LOW_POWER           2
#define     SHUT_DOWN_POWER     3
#endif

/******** webҳ slic ********/
#define ELEC_HOOKON_VOLTAGE     (1<<0)
#define ELEC_LOOP_CURRENT       (1<<1)
#define ELEC_RING_VPK           (1<<2)

#define MAX_RING_VPK            87
#define MIN_RING_VPK            63
#define MAX_LOOP_CUR            33
#define MIN_LOOP_CUR            18
#define MAX_OPENCIRCUIT_VOL     60
#define MIN_OPENCIRCUIT_VOL     48

/*
    Ӧóߵ      0
              ߶ಿ  1
                            2
                        3
              Զ峡        4              
*/
enum {
    DB_SLC_SINGLEPHONE_SHORTLOOP = 0,
    DB_SLC_MULTIPHONES_SHORTLOOP = 1,
    DB_SLC_LONGLOOP              = 2,
    DB_SLC_ORIGINAL_FACTORY      = 3,
    DB_SLC_CUSTOMIZED            = 4
};

typedef struct
{
    u8 bCusRingVpk;
    u8 bCusDcVol;
    u8 bCusDcLoopCurr;
}ELECTRIC_CFG_CUSTOMIZED;
/*************************************/

#define DC_VOLTAGE_48V                      48  /* 48V */
#define DC_VOLTAGE_52V                      52  /* 52V */

#define DC_CURRENT_20MA                     20  /* 20mA */
#define DC_CURRENT_24MA                     24  /* 24mA */
#define DC_CURRENT_28MA                     28  /* 28mA */
#define DC_CURRENT_32MA                     32  /* 32mA */

#define RING_VOLTAGE_55VPK                  55  /* 40vrms */
#define RING_VOLTAGE_65VPK                  65  /* 45vrms */
#define RING_VOLTAGE_70VPK                  70  /* 50vrms */
#define RING_VOLTAGE_75VPK                  75  /* 55vrms */
#define RING_VOLTAGE_85VPK                  85  /* 60vrms */


typedef struct
{
    u8 flg;     /* chip select  */
    u8 cs;      /* chip select  */
    u8 chan;    /* channel      */
    u8 port;    /* logic port   */
    u8 type;    /*    */
    u8 tx;      /* tx tm   */
    u8 rx;      /* rx tm   */    
}USL_PORT_MAP;

typedef struct
{
    /* slic config */
    u16 hookoffmin;      /* HookOn-> HookOff complete time */
    u16 hookonmin;       /* HookOff-> HookOn complete time */
    u16 prehookoff;     /* HookOn->Pre Hookoff complete time */ 

    u16 flash_low_min;     /* low electric min time for Flash check */
    u16 flash_low_max;

    u16 flash_high_fix;    /* fix high electric interval len */

    u16 dial_high_min;     /* high electric interval min for dial check */
    u16 dial_high_max;

    u16 dial_low_min;      /* low electric interval min for dial check */
    u16 dial_low_max;      /* low electric interval max for dial check */   
 
    u16 RingQueneDelay;
} USL_CONFIG;

typedef struct
{
    ProSLICMLTType                      Mlt;
    ProSLIC_mlt_foreign_voltages_state  vState;
    ProSLIC_mlt_rmeas_state             rMeas;
    ProSLIC_mlt_capacitance_state       CapState;
    ProSLIC_mlt_ren_state               RenState;
} ProSLICMLT;

typedef struct
{
    u8              test_flg;      /* 112 test flg,if it isn't 0, it is undering line test. */
    u8              si_item;       /* 112 test item */
    u16             cnt;           /* 112 scan counter   */
    ProSLICMLT      *pstMlt;       /* temp value in testing */
    TestResult_t    *pstResult;    /* 112 test result pointer */
} LINE_TEST_PARA;

typedef enum
{
    NOPTC   = 0,
    HAVEPTC = 1,
} PTCDATA;

typedef struct
{
    u8 bPort;
    u8 bCusRingVpk;
    u8 bCusDcVol;
    u8 bCusDcLoopCurr;
    u8 bLineOpen100msEn;
    u8 bDisablePowerSave;
    u32 dwImpe;
    s32 i32Rxgain;                  /* from dsp to slic D-A */
    s32 i32Txgain;                  /* from slic to dsp A-D */
} SLCINF_CFG;

typedef struct
{
    PTCDATA ePTC;
    u32     generel_cfg;
    u32     ring;
    u32     dc;
    u32     tone;
    u32     Impe;
    u32     meter;
    u8      bLineOpen100msEn;
    u8      bDisablePowerSave;
    u8      a_u_law;
	u8      cid;
	u8      linestaus;
    u8      wide;
    u32     offset;
    s32     rxgain;                 /* from dsp to slic D-A */
    s32     txgain;                 /* from slic to dsp A-D */
}SILAB_CFG_CHIP_t;

typedef struct {
    u8                  hook_state;     /* ǰ·ժһ״̬ */
    u8                  pulse_dig;      /* պźŲ */
    u8                  bDialEn;        /* պʹ */
    u32                 low_len;        /* һʱ */
    u32                 high_len;       /* ժʱ */
    
    USL_CONFIG          stUslConf;      /* time para */
    SILAB_CFG_CHIP_t    *pPreCfg;       /* board chip cfg */
    LINE_TEST_PARA      stLineTestPara;
    proslicChanType_ptr ProObj;         /*  ָоƬṹָ */
}Port_t;

typedef enum {
    NONE          = 0,
    RINGING       = 1,
    PLAYING_TONE  = 2,
} slic_state;


typedef enum {
    A_LAW_INVENT_NONE   = 0,
    U_LAW               = 1,
    LINEAR_CODEC        = 2,
} E_A_U_LAW;

typedef struct {
    ramData slope_vlim;
    ramData slope_rfeed;
    ramData slope_ilim;
    ramData delta1;
    ramData delta2;
    ramData v_vlim;
    ramData v_rfeed;
    ramData v_ilim;
    ramData const_rfeed;
    ramData const_ilim;
    ramData i_vlim;
} Si3217x_Shot_DCfeed_Cfg;

typedef struct {
    ramData amp;
    ramData rtacth;
    ramData vbatr_expect;
    ramData vcm_ring;
    ramData vcm_ring_fixed;
} Si3217x_Shot_Ring_Cfg;

/* init BoardParmCfg para based boardtype */
void SlicCfgParaBasedBoardType(void);

/* init impendence cfg */
void slic_inf_precfg(SLCINF_CFG *ptCfg);

/* init the slic chip */
int InitSlicChip(void);

/* deinit the slic chip */
void DeinitSlicChip(void);

#endif /* _SI_ADT_H */
