/*
** Copyright (c) 2007-2016 by Silicon Laboratories
**
** $Id: si3217x_revb_registers.h 5419 2016-01-13 00:40:56Z nizajerk $
**
** Distributed by:
** Silicon Laboratories, Inc
**
** This file contains proprietary information.
** No dissemination allowed without prior written permission from
** Silicon Laboratories, Inc.
**/

#ifndef SI3217X_REVB_REGS_H
#define SI3217X_REVB_REGS_H

/*
** SI3217X RevB Unique SPI Registers
*/
enum SI3217X_REVB_REG
{
  SI3217X_REVB_REG_DAA_CNTL                = 74,
};

/*
** SI3217X_REVB_RAM
*/
enum SI3217X_REVB_RAM
{
  SI3217X_REVB_RAM_P_Q2_D                  = 15,
  SI3217X_REVB_RAM_P_Q3_D                  = 16,
  SI3217X_REVB_RAM_P_Q4_D                  = 17,
  SI3217X_REVB_RAM_P_Q5_D                  = 18,
  SI3217X_REVB_RAM_P_Q6_D                  = 19,
  SI3217X_REVB_RAM_METER_LPF_OUT_1         = 328,
  SI3217X_REVB_RAM_PMDIFF_D1               = 333,
  SI3217X_REVB_RAM_PMDIFF_D2               = 334,
  SI3217X_REVB_RAM_CAL_LKG_DWN_C0          = 385,
  SI3217X_REVB_RAM_CAL_LKG_DWN_V0          = 386,
  SI3217X_REVB_RAM_CAL_LKG_DWN_CN          = 387,
  SI3217X_REVB_RAM_CAL_LKG_DWN_VN          = 388,
  SI3217X_REVB_RAM_CAL_LKG_DWN_VLSB        = 389,
  SI3217X_REVB_RAM_CAL_LKG_DWN_ILSB        = 390,
  SI3217X_REVB_RAM_CAL_LKG_DWN_DACCODE     = 391,
  SI3217X_REVB_RAM_CAL_LKG_DWN_ICALC       = 392,
  SI3217X_REVB_RAM_MADC_VBAT_LAST          = 416,
  SI3217X_REVB_RAM_CALTMP_ILOOPX1          = 443,
  SI3217X_REVB_RAM_DIAG_V_TAR              = 459,
  SI3217X_REVB_RAM_MADC_ISNS_DIAG_STBY_OS  = 487,
  SI3217X_REVB_RAM_MADC_ISNS_DIAG_OS       = 488,
  SI3217X_REVB_RAM_DCDC_FSW_VTHLO          = 489,
  SI3217X_REVB_RAM_DCDC_FSW_VHYST          = 490,
  SI3217X_REVB_RAM_DCDC_FSW_STATE          = 491,
  SI3217X_REVB_RAM_UNUSED501               = 501,
  SI3217X_REVB_RAM_UNUSED502               = 502,
  SI3217X_REVB_RAM_CAL_TEMP11              = 503,
  SI3217X_REVB_RAM_UNUSED504               = 504,
  SI3217X_REVB_RAM_UNUSED505               = 505,
  SI3217X_REVB_RAM_UNUSED506               = 506,
  SI3217X_REVB_RAM_UNUSED507               = 507,
  SI3217X_REVB_RAM_UNUSED508               = 508,
  SI3217X_REVB_RAM_UNUSED509               = 509,
  SI3217X_REVB_RAM_UNUSED510               = 510,
  SI3217X_REVB_RAM_P_TH_Q1256              = 757,
  SI3217X_REVB_RAM_P_TH_Q34                = 758,
  SI3217X_REVB_RAM_COEF_Q1256              = 760,
  SI3217X_REVB_RAM_COEF_Q34                = 761,
  SI3217X_REVB_RAM_R_OFFLOAD               = 762,
  SI3217X_REVB_RAM_R_63                    = 763,
  SI3217X_REVB_RAM_MADC_ISNS_STDBY_OS      = 778,
  SI3217X_REVB_RAM_MADC_ISNS_OS            = 779,
  SI3217X_REVB_RAM_CAL_LKG_TSETTLE         = 792,
  SI3217X_REVB_RAM_CAL_LKG_IREF100         = 793,
  SI3217X_REVB_RAM_CAL_LKG_LIM100UA        = 794,
  SI3217X_REVB_RAM_CAL_LKG_VREF25          = 795,
  SI3217X_REVB_RAM_CAL_LKG_VLSB_0_INV      = 796,
  SI3217X_REVB_RAM_CAL_LKG_RDCSNS_EFF      = 797,
  SI3217X_REVB_RAM_CAL_LKG_RDCOFF_EFF      = 798,
  SI3217X_REVB_RAM_CAL_LKG_CODE_OS         = 799,
  SI3217X_REVB_RAM_CAL_LKG_VMAX_THR        = 800,
  SI3217X_REVB_RAM_MADC_VBAT_HYST          = 870,
  SI3217X_REVB_RAM_STDBY_THRLO             = 872,
  SI3217X_REVB_RAM_STDBY_THRHI             = 873,
  SI3217X_REVB_RAM_MADC_VBAT_SCALE0        = 885,
  SI3217X_REVB_RAM_MADC_VBAT_SCALE1        = 886,
  SI3217X_REVB_RAM_MADC_ITR_SCALE          = 892,
  SI3217X_REVB_RAM_CAL_LKG_CODE_OS_COMP    = 911,
  SI3217X_REVB_RAM_DCDC_FSW_NORM           = 921,
  SI3217X_REVB_RAM_DCDC_FSW_NORM_LO        = 922,
  SI3217X_REVB_RAM_DCDC_FSW_RINGING        = 923,
  SI3217X_REVB_RAM_DCDC_FSW_RINGING_LO     = 924,
  SI3217X_REVB_RAM_DCDC_DIN_LIM            = 925,
  SI3217X_REVB_RAM_DCDC_VOUT_LIM           = 926,
  SI3217X_REVB_RAM_DAA_DTMF_IN_SCALE       = 928,
  SI3217X_REVB_RAM_PM_GAIN                 = 961,
  SI3217X_REVB_RAM_UNUSED968               = 968,
  SI3217X_REVB_RAM_UNUSED969               = 969,
  SI3217X_REVB_RAM_UNUSED970               = 970,
  SI3217X_REVB_RAM_UNUSED971               = 971,
  SI3217X_REVB_RAM_UNUSED972               = 972,
  SI3217X_REVB_RAM_UNUSED973               = 973,
  SI3217X_REVB_RAM_UNUSED974               = 974,
  SI3217X_REVB_RAM_UNUSED975               = 975,
  SI3217X_REVB_RAM_UNUSED976               = 976,
  SI3217X_REVB_RAM_UNUSED977               = 977,
  SI3217X_REVB_RAM_UNUSED978               = 978,
  SI3217X_REVB_RAM_UNUSED979               = 979,
  SI3217X_REVB_RAM_UNUSED980               = 980,
  SI3217X_REVB_RAM_UNUSED981               = 981,
  SI3217X_REVB_RAM_UNUSED982               = 982,
  SI3217X_REVB_RAM_UNUSED983               = 983,
  SI3217X_REVB_RAM_UNUSED984               = 984,
  SI3217X_REVB_RAM_UNUSED985               = 985,
  SI3217X_REVB_RAM_UNUSED986               = 986,
  SI3217X_REVB_RAM_UNUSED987               = 987,
  SI3217X_REVB_RAM_UNUSED988               = 988,
  SI3217X_REVB_RAM_UNUSED989               = 989,
  SI3217X_REVB_RAM_UNUSED990               = 990,
  SI3217X_REVB_RAM_UNUSED991               = 991,
  SI3217X_REVB_RAM_UNUSED992               = 992,
  SI3217X_REVB_RAM_UNUSED993               = 993,
  SI3217X_REVB_RAM_UNUSED994               = 994,
  SI3217X_REVB_RAM_UNUSED995               = 995,
  SI3217X_REVB_RAM_UNUSED996               = 996,
  SI3217X_REVB_RAM_UNUSED997               = 997,
  SI3217X_REVB_RAM_UNUSED998               = 998,
  SI3217X_REVB_RAM_UNUSED999               = 999,
  SI3217X_REVB_RAM_UNUSED1000              = 1000,
  SI3217X_REVB_RAM_UNUSED1001              = 1001,
  SI3217X_REVB_RAM_UNUSED1002              = 1002,
  SI3217X_REVB_RAM_UNUSED1003              = 1003,
  SI3217X_REVB_RAM_UNUSED1004              = 1004,
  SI3217X_REVB_RAM_UNUSED1005              = 1005,
  SI3217X_REVB_RAM_UNUSED1006              = 1006,
  SI3217X_REVB_RAM_UNUSED1007              = 1007,
  SI3217X_REVB_RAM_UNUSED1008              = 1008,
  SI3217X_REVB_RAM_UNUSED1009              = 1009,
  SI3217X_REVB_RAM_UNUSED1014              = 1014,
  SI3217X_REVB_RAM_UNUSED1015              = 1015,
  SI3217X_REVB_RAM_UNUSED1017              = 1017,
  SI3217X_REVB_RAM_UNUSED1018              = 1018,
  SI3217X_REVB_RAM_UNUSED1019              = 1019,
  SI3217X_REVB_RAM_UNUSED1020              = 1020,
  SI3217X_REVB_RAM_UNUSED1021              = 1021,
  SI3217X_REVB_RAM_DAC_OFFSET              = 1280,
  SI3217X_REVB_RAM_ADC_CAL                 = 1306,
  SI3217X_REVB_RAM_VOC_DAC                 = 1311,
  SI3217X_REVB_RAM_CHAN_ZERO               = 1316,
  SI3217X_REVB_RAM_CHAN_TOG                = 1317,
  SI3217X_REVB_RAM_CHAN_POP                = 1318,
  SI3217X_REVB_RAM_BIAS                    = 1321,
  SI3217X_REVB_RAM_SLIC_DIAG_CLR           = 1353,
  SI3217X_REVB_RAM_METER_LPF_OUT           = 1366,
  SI3217X_REVB_RAM_METER_PK                = 1367,
  SI3217X_REVB_RAM_METER_FREQ              = 1368,
  SI3217X_REVB_RAM_MADC_ITIP_RAW           = 1404,
  SI3217X_REVB_RAM_MADC_IRING_RAW          = 1405,
  SI3217X_REVB_RAM_MADC_BATSCALE_SCHED     = 1408,
  SI3217X_REVB_RAM_CAL_HVIC_CNTL           = 1409,
  SI3217X_REVB_RAM_PD_PM_RAMP              = 1425,
  SI3217X_REVB_RAM_PD_PM_SINE              = 1426,
  SI3217X_REVB_RAM_PD_DISCROPA             = 1429,
  SI3217X_REVB_RAM_PM_DAC_CHEN_B           = 1431,
  SI3217X_REVB_RAM_PM_CHEN_B               = 1435,
  SI3217X_REVB_RAM_PM_GAIN_EN_B            = 1440,
  SI3217X_REVB_RAM_MADC_LOOP_MAN           = 1445,
  SI3217X_REVB_RAM_HVIC_CNTL_MAN           = 1451,
  SI3217X_REVB_RAM_CAL_DCADC_CNTL          = 1455,
  SI3217X_REVB_RAM_LKG_UPT_STBY            = 1464,
  SI3217X_REVB_RAM_LKG_UPR_STBY            = 1465,
  SI3217X_REVB_RAM_LKG_DNT_STBY            = 1466,
  SI3217X_REVB_RAM_LKG_DNR_STBY            = 1467,
  SI3217X_REVB_RAM_CAL_GPIO0_CTRL          = 1470,
  SI3217X_REVB_RAM_VBAT_DAC                = 1484,
  SI3217X_REVB_RAM_STDBY_SET               = 1494,
  SI3217X_REVB_RAM_STDBY_CLR               = 1495,
  SI3217X_REVB_RAM_CAL_HVIC_TR             = 1498,
  SI3217X_REVB_RAM_PM_SINE_MAN             = 1500,
  SI3217X_REVB_RAM_PM_SINE_VAL             = 1501,
  SI3217X_REVB_RAM_PM_RAMP_MAN             = 1502,
  SI3217X_REVB_RAM_PM_RAMP_VAL             = 1503,
  SI3217X_REVB_RAM_PM_GAIN_MAN             = 1504,
  SI3217X_REVB_RAM_PM_GAIN_VAL             = 1505,
  SI3217X_REVB_RAM_BATSEL_MAN              = 1519,
  SI3217X_REVB_RAM_HVIC_MAN                = 1520,
  SI3217X_REVB_RAM_PD_ISNS                 = 1521,
  SI3217X_REVB_RAM_DISCR_FORCE             = 1526,
  SI3217X_REVB_RAM_CAP_LB_ON               = 1529,
  SI3217X_REVB_RAM_LKG_STBY_OFFSET         = 1537,
  SI3217X_REVB_RAM_PD_CCMDET               = 1544,
  SI3217X_REVB_RAM_DCDC_SWTHRESH           = 1549,
  SI3217X_REVB_RAM_DCDC_CCMTHRESH          = 1550,
  SI3217X_REVB_RAM_DCDC_FSW                = 1552,
  SI3217X_REVB_RAM_DCDC_SWFET              = 1555,
  SI3217X_REVB_RAM_DCDC_VREF               = 1556,
  SI3217X_REVB_RAM_DCDC_TESTMODE           = 1559,
  SI3217X_REVB_RAM_DCDC_CCMDET_FILT        = 1562,
  SI3217X_REVB_RAM_DCDC_DIN_MAN            = 1566,
  SI3217X_REVB_RAM_DCDC_DIN_VAL            = 1567,
  SI3217X_REVB_RAM_PD_BJTDRV               = 1572,
  SI3217X_REVB_RAM_PD_DCDC_DIG             = 1593,
  SI3217X_REVB_RAM_PD_OCLO_IDAC            = 1594,
};

#endif

