/*
** Copyright (c) 2013 by Silicon Laboratories
**
** $Id: mlt_comm_regs.h 4551 2014-10-27 20:57:24Z nizajerk $
**
*/
/*! \file mlt_comm_regs.h
**
**  \brief Register/RAM map abstracted for MLT
**
**  \author Silicon Laboratories, Inc.
**
**  \attention
**  This file contains proprietary information. 
**  No dissemination allowed without prior written permission
**  from Silicon Laboratories, Inc.
**
**  This file is auto generated. Do no modify.
**
*/
#ifndef MLT_COMM_REGS_H
#define MLT_COMM_REGS_H


/*
** MLT_COMM Unique SPI Registers
*/
enum MLT_COMM_REG {
MLT_COMM_REG_ID                          = 0,
MLT_COMM_REG_RESET                       = 1,
MLT_COMM_REG_MSTREN                      = 2,
MLT_COMM_REG_MSTRSTAT                    = 3,
MLT_COMM_REG_RAMSTAT                     = 4,
MLT_COMM_REG_RAM_ADDR_HI                 = 5,
MLT_COMM_REG_RAM_DATA_B0                 = 6,
MLT_COMM_REG_RAM_DATA_B1                 = 7,
MLT_COMM_REG_RAM_DATA_B2                 = 8,
MLT_COMM_REG_RAM_DATA_B3                 = 9,
MLT_COMM_REG_RAM_ADDR_LO                 = 10,
MLT_COMM_REG_PCMMODE                     = 11,
MLT_COMM_REG_PCMTXLO                     = 12,
MLT_COMM_REG_PCMTXHI                     = 13,
MLT_COMM_REG_PCMRXLO                     = 14,
MLT_COMM_REG_PCMRXHI                     = 15,
MLT_COMM_REG_IRQ                         = 16,
MLT_COMM_REG_IRQ0                        = 17,
MLT_COMM_REG_IRQ1                        = 18,
MLT_COMM_REG_IRQ2                        = 19,
MLT_COMM_REG_IRQ3                        = 20,
MLT_COMM_REG_IRQ4                        = 21,
MLT_COMM_REG_IRQEN1                      = 22,
MLT_COMM_REG_IRQEN2                      = 23,
MLT_COMM_REG_IRQEN3                      = 24,
MLT_COMM_REG_IRQEN4                      = 25,
MLT_COMM_REG_CALR0                       = 26,
MLT_COMM_REG_CALR1                       = 27,
MLT_COMM_REG_CALR2                       = 28,
MLT_COMM_REG_CALR3                       = 29,
MLT_COMM_REG_LINEFEED                    = 30,
MLT_COMM_REG_POLREV                      = 31,
MLT_COMM_REG_SPEEDUP_DIS                 = 32,
MLT_COMM_REG_SPEEDUP                     = 33,
MLT_COMM_REG_LCRRTP                      = 34,
MLT_COMM_REG_OFFLOAD                     = 35,
MLT_COMM_REG_BATSELMAP                   = 36,
MLT_COMM_REG_BATSEL                      = 37,
MLT_COMM_REG_RINGCON                     = 38,
MLT_COMM_REG_RINGTALO                    = 39,
MLT_COMM_REG_RINGTAHI                    = 40,
MLT_COMM_REG_RINGTILO                    = 41,
MLT_COMM_REG_RINGTIHI                    = 42,
MLT_COMM_REG_LOOPBACK                    = 43,
MLT_COMM_REG_DIGCON                      = 44,
MLT_COMM_REG_RA                          = 45,
MLT_COMM_REG_ZCAL_EN                     = 46,
MLT_COMM_REG_ENHANCE                     = 47,
MLT_COMM_REG_OMODE                       = 48,
MLT_COMM_REG_OCON                        = 49,
MLT_COMM_REG_O1TALO                      = 50,
MLT_COMM_REG_O1TAHI                      = 51,
MLT_COMM_REG_O1TILO                      = 52,
MLT_COMM_REG_O1TIHI                      = 53,
MLT_COMM_REG_O2TALO                      = 54,
MLT_COMM_REG_O2TAHI                      = 55,
MLT_COMM_REG_O2TILO                      = 56,
MLT_COMM_REG_O2TIHI                      = 57,
MLT_COMM_REG_FSKDAT                      = 58,
MLT_COMM_REG_FSKDEPTH                    = 59,
MLT_COMM_REG_TONDTMF                     = 60,
MLT_COMM_REG_TONDET                      = 61,
MLT_COMM_REG_TONEN                       = 62,
MLT_COMM_REG_GCI_CI                      = 63,
MLT_COMM_REG_GLOBSTAT1                   = 64,
MLT_COMM_REG_GLOBSTAT2                   = 65,
MLT_COMM_REG_USERSTAT                    = 66,
MLT_COMM_REG_GPIO                        = 67,
MLT_COMM_REG_GPIO_CFG1                   = 68,
MLT_COMM_REG_GPIO_CFG2                   = 69,
MLT_COMM_REG_GPIO_CFG3                   = 70,
MLT_COMM_REG_DIAG1                       = 71,
MLT_COMM_REG_DIAG2                       = 72,
MLT_COMM_REG_CM_CLAMP                    = 73,
MLT_COMM_REG_PMCON                       = 75,
MLT_COMM_REG_AUTO                        = 80,
MLT_COMM_REG_JMPEN                       = 81,
MLT_COMM_REG_JMP0LO                      = 82,
MLT_COMM_REG_JMP0HI                      = 83,
MLT_COMM_REG_JMP1LO                      = 84,
MLT_COMM_REG_JMP1HI                      = 85,
MLT_COMM_REG_JMP2LO                      = 86,
MLT_COMM_REG_JMP2HI                      = 87,
MLT_COMM_REG_JMP3LO                      = 88,
MLT_COMM_REG_JMP3HI                      = 89,
MLT_COMM_REG_JMP4LO                      = 90,
MLT_COMM_REG_JMP4HI                      = 91,
MLT_COMM_REG_JMP5LO                      = 92,
MLT_COMM_REG_JMP5HI                      = 93,
MLT_COMM_REG_JMP6LO                      = 94,
MLT_COMM_REG_JMP6HI                      = 95,
MLT_COMM_REG_JMP7LO                      = 96,
MLT_COMM_REG_JMP7HI                      = 97,
MLT_COMM_REG_PDN                         = 98,
MLT_COMM_REG_PDN_STAT                    = 99,
MLT_COMM_REG_PDN2                        = 100,
MLT_COMM_REG_PDN2_STAT                   = 101,
MLT_COMM_REG_M1_OSC_LO                   = 112,
MLT_COMM_REG_M1_OSC_HI                   = 113,
MLT_COMM_REG_BITCNT_LO                   = 114,
MLT_COMM_REG_BITCNT_HI                   = 115,
MLT_COMM_REG_PCLK_MULT                   = 116,
MLT_COMM_REG_RAM_DATA_16                 = 117,
MLT_COMM_REG_BYPASS_ADDR_LO              = 118,
MLT_COMM_REG_BYPASS_ADDR_HI              = 119,
MLT_COMM_REG_PC_LO                       = 120,
MLT_COMM_REG_PC_HI                       = 121,
MLT_COMM_REG_PC_SHAD_LO                  = 122,
MLT_COMM_REG_PC_SHAD_HI                  = 123,
MLT_COMM_REG_PASS_LO                     = 124,
MLT_COMM_REG_PASS_HI                     = 125,
MLT_COMM_REG_TEST_CNTL                   = 126,
MLT_COMM_REG_TEST_MODE                   = 127,
};

/*
** MLT_COMM_RAM
*/
enum MLT_COMM_RAM {
MLT_COMM_RAM_IRNGNG_SENSE                = 0,
MLT_COMM_RAM_MADC_VTIPC                  = 1,
MLT_COMM_RAM_MADC_VRINGC                 = 2,
MLT_COMM_RAM_MADC_VBAT                   = 3,
MLT_COMM_RAM_MADC_VLONG                  = 4,
MLT_COMM_RAM_UNUSED5                     = 5,
MLT_COMM_RAM_MADC_VDC                    = 6,
MLT_COMM_RAM_MADC_ILONG                  = 7,
MLT_COMM_RAM_MADC_ITIP                   = 8,
MLT_COMM_RAM_MADC_IRING                  = 9,
MLT_COMM_RAM_MADC_ILOOP                  = 10,
MLT_COMM_RAM_VDIFF_SENSE                 = 11,
MLT_COMM_RAM_VTIP                        = 12,
MLT_COMM_RAM_VRING                       = 13,
MLT_COMM_RAM_P_Q1_D                      = 14,
MLT_COMM_RAM_P_Q1                        = 20,
MLT_COMM_RAM_DIAG_EX1                    = 21,
MLT_COMM_RAM_DIAG_EX2                    = 22,
MLT_COMM_RAM_DIAG_LPF_MADC               = 23,
MLT_COMM_RAM_DIAG_DMM_I                  = 24,
MLT_COMM_RAM_DIAG_DMM_V                  = 25,
MLT_COMM_RAM_OSC1FREQ                    = 26,
MLT_COMM_RAM_OSC1AMP                     = 27,
MLT_COMM_RAM_OSC1PHAS                    = 28,
MLT_COMM_RAM_OSC2FREQ                    = 29,
MLT_COMM_RAM_OSC2AMP                     = 30,
MLT_COMM_RAM_OSC2PHAS                    = 31,
MLT_COMM_RAM_TESTB0_1                    = 32,
MLT_COMM_RAM_TESTB1_1                    = 33,
MLT_COMM_RAM_TESTB2_1                    = 34,
MLT_COMM_RAM_TESTA1_1                    = 35,
MLT_COMM_RAM_TESTA2_1                    = 36,
MLT_COMM_RAM_TESTB0_2                    = 37,
MLT_COMM_RAM_TESTB1_2                    = 38,
MLT_COMM_RAM_TESTB2_2                    = 39,
MLT_COMM_RAM_TESTA1_2                    = 40,
MLT_COMM_RAM_TESTA2_2                    = 41,
MLT_COMM_RAM_TESTB0_3                    = 42,
MLT_COMM_RAM_TESTB1_3                    = 43,
MLT_COMM_RAM_TESTB2_3                    = 44,
MLT_COMM_RAM_TESTA1_3                    = 45,
MLT_COMM_RAM_TESTA2_3                    = 46,
MLT_COMM_RAM_TESTPKO                     = 47,
MLT_COMM_RAM_TESTABO                     = 48,
MLT_COMM_RAM_TESTWLN                     = 49,
MLT_COMM_RAM_TESTAVBW                    = 50,
MLT_COMM_RAM_TESTPKFL                    = 51,
MLT_COMM_RAM_TESTAVFL                    = 52,
MLT_COMM_RAM_TESTPKTH                    = 53,
MLT_COMM_RAM_TESTAVTH                    = 54,
MLT_COMM_RAM_DAC_IN_SYNC1                = 55,
MLT_COMM_RAM_BYPASS_REG                  = 56,
MLT_COMM_RAM_LCRMASK_CNT                 = 57,
MLT_COMM_RAM_DAC_IN_SYNC                 = 58,
MLT_COMM_RAM_TEMP                        = 59,
MLT_COMM_RAM_TEMP_ISR                    = 60,
MLT_COMM_RAM_P_Q2                        = 61,
MLT_COMM_RAM_P_Q3                        = 62,
MLT_COMM_RAM_P_Q4                        = 63,
MLT_COMM_RAM_P_Q5                        = 64,
MLT_COMM_RAM_P_Q6                        = 65,
MLT_COMM_RAM_ILOOP_FILT                  = 66,
MLT_COMM_RAM_ILONG_FILT                  = 67,
MLT_COMM_RAM_VBAT_FILT                   = 68,
MLT_COMM_RAM_VDIFF_FILT                  = 69,
MLT_COMM_RAM_VCM_FILT                    = 70,
MLT_COMM_RAM_VBAT_CNT                    = 71,
MLT_COMM_RAM_V_VLIM_SCALED               = 72,
MLT_COMM_RAM_V_VLIM_TRACK                = 73,
MLT_COMM_RAM_V_VLIM_MODFEED              = 74,
MLT_COMM_RAM_DIAG_P_OUT                  = 75,
MLT_COMM_RAM_DIAG_COUNT                  = 76,
MLT_COMM_RAM_ROW0_MAG                    = 77,
MLT_COMM_RAM_ROW1_MAG                    = 78,
MLT_COMM_RAM_ROW2_MAG                    = 79,
MLT_COMM_RAM_ROW3_MAG                    = 80,
MLT_COMM_RAM_COL0_MAG                    = 81,
MLT_COMM_RAM_COL1_MAG                    = 82,
MLT_COMM_RAM_COL2_MAG                    = 83,
MLT_COMM_RAM_COL3_MAG                    = 84,
MLT_COMM_RAM_ROW0_2ND_Y1                 = 85,
MLT_COMM_RAM_ROW1_2ND_Y1                 = 86,
MLT_COMM_RAM_ROW2_2ND_Y1                 = 87,
MLT_COMM_RAM_ROW3_2ND_Y1                 = 88,
MLT_COMM_RAM_COL0_2ND_Y1                 = 89,
MLT_COMM_RAM_COL1_2ND_Y1                 = 90,
MLT_COMM_RAM_COL2_2ND_Y1                 = 91,
MLT_COMM_RAM_COL3_2ND_Y1                 = 92,
MLT_COMM_RAM_ROW0_2ND_Y2                 = 93,
MLT_COMM_RAM_ROW1_2ND_Y2                 = 94,
MLT_COMM_RAM_ROW2_2ND_Y2                 = 95,
MLT_COMM_RAM_ROW3_2ND_Y2                 = 96,
MLT_COMM_RAM_COL0_2ND_Y2                 = 97,
MLT_COMM_RAM_COL1_2ND_Y2                 = 98,
MLT_COMM_RAM_COL2_2ND_Y2                 = 99,
MLT_COMM_RAM_COL3_2ND_Y2                 = 100,
MLT_COMM_RAM_DTMF_IN                     = 101,
MLT_COMM_RAM_DTMFDTF_D2_1                = 102,
MLT_COMM_RAM_DTMFDTF_D1_1                = 103,
MLT_COMM_RAM_DTMFDTF_OUT_1               = 104,
MLT_COMM_RAM_DTMFDTF_D2_2                = 105,
MLT_COMM_RAM_DTMFDTF_D1_2                = 106,
MLT_COMM_RAM_DTMFDTF_OUT_2               = 107,
MLT_COMM_RAM_DTMFDTF_D2_3                = 108,
MLT_COMM_RAM_DTMFDTF_D1_3                = 109,
MLT_COMM_RAM_DTMFDTF_OUT_3               = 110,
MLT_COMM_RAM_DTMFDTF_OUT                 = 111,
MLT_COMM_RAM_DTMFLPF_D2_1                = 112,
MLT_COMM_RAM_DTMFLPF_D1_1                = 113,
MLT_COMM_RAM_DTMFLPF_OUT_1               = 114,
MLT_COMM_RAM_DTMFLPF_D2_2                = 115,
MLT_COMM_RAM_DTMFLPF_D1_2                = 116,
MLT_COMM_RAM_DTMFLPF_OUT_2               = 117,
MLT_COMM_RAM_DTMF_ROW                    = 118,
MLT_COMM_RAM_DTMFHPF_D2_1                = 119,
MLT_COMM_RAM_DTMFHPF_D1_1                = 120,
MLT_COMM_RAM_DTMFHPF_OUT_1               = 121,
MLT_COMM_RAM_DTMFHPF_D2_2                = 122,
MLT_COMM_RAM_DTMFHPF_D1_2                = 123,
MLT_COMM_RAM_DTMFHPF_OUT_2               = 124,
MLT_COMM_RAM_DTMF_COL                    = 125,
MLT_COMM_RAM_ROW_POWER                   = 126,
MLT_COMM_RAM_COL_POWER                   = 127,
MLT_COMM_RAM_GP_TIMER                    = 128,
MLT_COMM_RAM_SPR_INTERP_DIF              = 129,
MLT_COMM_RAM_SPR_INTERP_DIF_OUT          = 130,
MLT_COMM_RAM_SPR_INTERP_INT              = 131,
MLT_COMM_RAM_SPR_CNT                     = 132,
MLT_COMM_RAM_ROW0_Y1                     = 133,
MLT_COMM_RAM_ROW0_Y2                     = 134,
MLT_COMM_RAM_ROW1_Y1                     = 135,
MLT_COMM_RAM_ROW1_Y2                     = 136,
MLT_COMM_RAM_ROW2_Y1                     = 137,
MLT_COMM_RAM_ROW2_Y2                     = 138,
MLT_COMM_RAM_ROW3_Y1                     = 139,
MLT_COMM_RAM_ROW3_Y2                     = 140,
MLT_COMM_RAM_COL0_Y1                     = 141,
MLT_COMM_RAM_COL0_Y2                     = 142,
MLT_COMM_RAM_COL1_Y1                     = 143,
MLT_COMM_RAM_COL1_Y2                     = 144,
MLT_COMM_RAM_COL2_Y1                     = 145,
MLT_COMM_RAM_COL2_Y2                     = 146,
MLT_COMM_RAM_COL3_Y1                     = 147,
MLT_COMM_RAM_COL3_Y2                     = 148,
MLT_COMM_RAM_ROWMAX_MAG                  = 149,
MLT_COMM_RAM_COLMAX_MAG                  = 150,
MLT_COMM_RAM_ROW0_2ND_MAG                = 151,
MLT_COMM_RAM_COL0_2ND_MAG                = 152,
MLT_COMM_RAM_ROW_THR                     = 153,
MLT_COMM_RAM_COL_THR                     = 154,
MLT_COMM_RAM_OSC1_Y                      = 155,
MLT_COMM_RAM_OSC2_Y                      = 156,
MLT_COMM_RAM_OSC1_X                      = 157,
MLT_COMM_RAM_OSC1_COEFF                  = 158,
MLT_COMM_RAM_OSC2_X                      = 159,
MLT_COMM_RAM_OSC2_COEFF                  = 160,
MLT_COMM_RAM_RXACIIR_D2_1                = 161,
MLT_COMM_RAM_RXACIIR_OUT_1               = 162,
MLT_COMM_RAM_RXACIIR_D2_2                = 163,
MLT_COMM_RAM_RXACIIR_D1_2                = 164,
MLT_COMM_RAM_RXACIIR_OUT_2               = 165,
MLT_COMM_RAM_RXACIIR_D2_3                = 166,
MLT_COMM_RAM_RXACIIR_D1_3                = 167,
MLT_COMM_RAM_RXACIIR_OUT                 = 168,
MLT_COMM_RAM_RXACIIR_OUT_3               = 169,
MLT_COMM_RAM_TXACCOMB_D1                 = 170,
MLT_COMM_RAM_TXACCOMB_D2                 = 171,
MLT_COMM_RAM_TXACCOMB_D3                 = 172,
MLT_COMM_RAM_TXACSINC_OUT                = 173,
MLT_COMM_RAM_TXACHPF_D1_2                = 174,
MLT_COMM_RAM_TXACHPF_D2_1                = 175,
MLT_COMM_RAM_TXACHPF_D2_2                = 176,
MLT_COMM_RAM_TXACHPF_OUT                 = 177,
MLT_COMM_RAM_TXACHPF_OUT_1               = 178,
MLT_COMM_RAM_TXACHPF_OUT_2               = 179,
MLT_COMM_RAM_TXACIIR_D2_1                = 180,
MLT_COMM_RAM_TXACIIR_OUT_1               = 181,
MLT_COMM_RAM_TXACIIR_D2_2                = 182,
MLT_COMM_RAM_TXACIIR_D1_2                = 183,
MLT_COMM_RAM_TXACIIR_OUT_2               = 184,
MLT_COMM_RAM_TXACIIR_D2_3                = 185,
MLT_COMM_RAM_TXACIIR_D1_3                = 186,
MLT_COMM_RAM_TXACIIR_OUT_3               = 187,
MLT_COMM_RAM_TXACIIR_OUT                 = 188,
MLT_COMM_RAM_ECIIR_D1                    = 189,
MLT_COMM_RAM_ECIIR_D2                    = 190,
MLT_COMM_RAM_EC_DELAY1                   = 191,
MLT_COMM_RAM_EC_DELAY2                   = 192,
MLT_COMM_RAM_EC_DELAY3                   = 193,
MLT_COMM_RAM_EC_DELAY4                   = 194,
MLT_COMM_RAM_EC_DELAY5                   = 195,
MLT_COMM_RAM_EC_DELAY6                   = 196,
MLT_COMM_RAM_EC_DELAY7                   = 197,
MLT_COMM_RAM_EC_DELAY8                   = 198,
MLT_COMM_RAM_EC_DELAY9                   = 199,
MLT_COMM_RAM_EC_DELAY10                  = 200,
MLT_COMM_RAM_EC_DELAY11                  = 201,
MLT_COMM_RAM_ECHO_EST                    = 202,
MLT_COMM_RAM_EC_OUT                      = 203,
MLT_COMM_RAM_TESTFILT_OUT_1              = 204,
MLT_COMM_RAM_TESTFILT_D1_1               = 205,
MLT_COMM_RAM_TESTFILT_D2_1               = 206,
MLT_COMM_RAM_TESTFILT_OUT_2              = 207,
MLT_COMM_RAM_TESTFILT_D1_2               = 208,
MLT_COMM_RAM_TESTFILT_D2_2               = 209,
MLT_COMM_RAM_TESTFILT_OUT_3              = 210,
MLT_COMM_RAM_TESTFILT_D1_3               = 211,
MLT_COMM_RAM_TESTFILT_D2_3               = 212,
MLT_COMM_RAM_TESTFILT_PEAK               = 213,
MLT_COMM_RAM_TESTFILT_ABS                = 214,
MLT_COMM_RAM_TESTFILT_MEANACC            = 215,
MLT_COMM_RAM_TESTFILT_COUNT              = 216,
MLT_COMM_RAM_TESTFILT_NO_OFFSET          = 217,
MLT_COMM_RAM_RING_X                      = 218,
MLT_COMM_RAM_RING_Y                      = 219,
MLT_COMM_RAM_RING_INT                    = 220,
MLT_COMM_RAM_RING_Y_D1                   = 221,
MLT_COMM_RAM_RING_DIFF                   = 222,
MLT_COMM_RAM_RING_DELTA                  = 223,
MLT_COMM_RAM_WTCHDOG_CNT                 = 224,
MLT_COMM_RAM_RING_WAVE                   = 225,
MLT_COMM_RAM_UNUSED226                   = 226,
MLT_COMM_RAM_ONEKHZ_COUNT                = 227,
MLT_COMM_RAM_TX2100_Y1                   = 228,
MLT_COMM_RAM_TX2100_Y2                   = 229,
MLT_COMM_RAM_TX2100_MAG                  = 230,
MLT_COMM_RAM_RX2100_Y1                   = 231,
MLT_COMM_RAM_RX2100_Y2                   = 232,
MLT_COMM_RAM_RX2100_MAG                  = 233,
MLT_COMM_RAM_TX2100_POWER                = 234,
MLT_COMM_RAM_RX2100_POWER                = 235,
MLT_COMM_RAM_TX2100_IN                   = 236,
MLT_COMM_RAM_RX2100_IN                   = 237,
MLT_COMM_RAM_RINGTRIP_COUNT              = 238,
MLT_COMM_RAM_RINGTRIP_DC1                = 239,
MLT_COMM_RAM_RINGTRIP_DC2                = 240,
MLT_COMM_RAM_RINGTRIP_AC1                = 241,
MLT_COMM_RAM_RINGTRIP_AC2                = 242,
MLT_COMM_RAM_RINGTRIP_AC_COUNT           = 243,
MLT_COMM_RAM_RINGTRIP_DC_COUNT           = 244,
MLT_COMM_RAM_RINGTRIP_AC_RESULT          = 245,
MLT_COMM_RAM_RINGTRIP_DC_RESULT          = 246,
MLT_COMM_RAM_RINGTRIP_ABS                = 247,
MLT_COMM_RAM_TXACEQ_OUT                  = 248,
MLT_COMM_RAM_LCR_DBI_CNT                 = 249,
MLT_COMM_RAM_BAT_DBI_CNT                 = 250,
MLT_COMM_RAM_LONG_DBI_CNT                = 251,
MLT_COMM_RAM_TXACEQ_DELAY3               = 252,
MLT_COMM_RAM_TXACEQ_DELAY2               = 253,
MLT_COMM_RAM_TXACEQ_DELAY1               = 254,
MLT_COMM_RAM_RXACEQ_DELAY3               = 255,
MLT_COMM_RAM_RXACEQ_DELAY2               = 256,
MLT_COMM_RAM_RXACEQ_DELAY1               = 257,
MLT_COMM_RAM_RXACEQ_IN                   = 258,
MLT_COMM_RAM_TXDCCOMB_D1                 = 259,
MLT_COMM_RAM_TXDCCOMB_D2                 = 260,
MLT_COMM_RAM_TXDCSINC_OUT                = 261,
MLT_COMM_RAM_RXACDIFF_D1                 = 262,
MLT_COMM_RAM_DC_NOTCH_1                  = 263,
MLT_COMM_RAM_DC_NOTCH_2                  = 264,
MLT_COMM_RAM_DC_NOTCH_OUT                = 265,
MLT_COMM_RAM_DC_NOTCH_SCALED             = 266,
MLT_COMM_RAM_V_FEED_IN                   = 267,
MLT_COMM_RAM_I_TAR                       = 268,
MLT_COMM_RAM_CONST_VLIM                  = 269,
MLT_COMM_RAM_UNITY                       = 270,
MLT_COMM_RAM_TXACNOTCH_1                 = 271,
MLT_COMM_RAM_TXACNOTCH_2                 = 272,
MLT_COMM_RAM_TXACNOTCH_OUT               = 273,
MLT_COMM_RAM_ZSYNTH_1                    = 274,
MLT_COMM_RAM_ZSYNTH_2                    = 275,
MLT_COMM_RAM_ZSYNTH_OUT_1                = 276,
MLT_COMM_RAM_TXACD2_1_0                  = 277,
MLT_COMM_RAM_TXACD2_1_1                  = 278,
MLT_COMM_RAM_TXACD2_1_2                  = 279,
MLT_COMM_RAM_TXACD2_1_3                  = 280,
MLT_COMM_RAM_TXACD2_1_4                  = 281,
MLT_COMM_RAM_TXACD2_1_5                  = 282,
MLT_COMM_RAM_TXACD2_1_OUT                = 283,
MLT_COMM_RAM_TXACD2_2_0                  = 284,
MLT_COMM_RAM_TXACD2_2_1                  = 285,
MLT_COMM_RAM_TXACD2_2_2                  = 286,
MLT_COMM_RAM_TXACD2_2_3                  = 287,
MLT_COMM_RAM_TXACD2_2_4                  = 288,
MLT_COMM_RAM_TXACD2_2_5                  = 289,
MLT_COMM_RAM_TXACD2_2_OUT                = 290,
MLT_COMM_RAM_TXACD2_3_0                  = 291,
MLT_COMM_RAM_TXACD2_3_1                  = 292,
MLT_COMM_RAM_TXACD2_3_2                  = 293,
MLT_COMM_RAM_TXACD2_3_3                  = 294,
MLT_COMM_RAM_TXACD2_3_4                  = 295,
MLT_COMM_RAM_TXACD2_3_5                  = 296,
MLT_COMM_RAM_TXACD2_3_OUT                = 297,
MLT_COMM_RAM_RXACI2_1_1                  = 298,
MLT_COMM_RAM_RXACI2_1_2                  = 299,
MLT_COMM_RAM_RXACI2_1_3                  = 300,
MLT_COMM_RAM_RXACI2_1_4                  = 301,
MLT_COMM_RAM_RXACI2_1_OUT                = 302,
MLT_COMM_RAM_RXACI2_2_1                  = 303,
MLT_COMM_RAM_RXACI2_2_2                  = 304,
MLT_COMM_RAM_RXACI2_2_3                  = 305,
MLT_COMM_RAM_RXACI2_2_4                  = 306,
MLT_COMM_RAM_RXACI2_2_OUT                = 307,
MLT_COMM_RAM_RXACI2_3_1                  = 308,
MLT_COMM_RAM_RXACI2_3_2                  = 309,
MLT_COMM_RAM_RXACI2_3_3                  = 310,
MLT_COMM_RAM_RXACI2_3_4                  = 311,
MLT_COMM_RAM_RXACI2_3_OUT                = 312,
MLT_COMM_RAM_TXACCOMP1                   = 313,
MLT_COMM_RAM_TXACCOMP_OUT                = 314,
MLT_COMM_RAM_RXACCOMP1                   = 315,
MLT_COMM_RAM_RXACCOMP_OUT                = 316,
MLT_COMM_RAM_RXACHPF_D1_2                = 317,
MLT_COMM_RAM_RXACHPF_D2_1                = 318,
MLT_COMM_RAM_RXACHPF_D2_2                = 319,
MLT_COMM_RAM_RXACHPF_OUT                 = 320,
MLT_COMM_RAM_RXACHPF_OUT_1               = 321,
MLT_COMM_RAM_RXACHPF_OUT_2               = 322,
MLT_COMM_RAM_RXACEQ_OUT                  = 323,
MLT_COMM_RAM_METER_I_1                   = 324,
MLT_COMM_RAM_METER_I_OUT                 = 325,
MLT_COMM_RAM_METER_LPF_1                 = 326,
MLT_COMM_RAM_METER_LPF_2                 = 327,
MLT_COMM_RAM_METER_BP_1                  = 329,
MLT_COMM_RAM_METER_BP_2                  = 330,
MLT_COMM_RAM_METER_BP_OUT                = 331,
MLT_COMM_RAM_METER_SRC_OUT               = 332,
MLT_COMM_RAM_RING_LPF_1                  = 335,
MLT_COMM_RAM_RING_LPF_2                  = 336,
MLT_COMM_RAM_RING_LPF_OUT                = 337,
MLT_COMM_RAM_RING_INTERP_DIFF            = 338,
MLT_COMM_RAM_RING_INTERP_DIFF_OUT        = 339,
MLT_COMM_RAM_RING_INTERP_INT             = 340,
MLT_COMM_RAM_RING_INTERP_INT_OUT         = 341,
MLT_COMM_RAM_V_ILIM_TRACK                = 342,
MLT_COMM_RAM_V_RFEED_TRACK               = 343,
MLT_COMM_RAM_LF_SPEEDUP_CNT              = 344,
MLT_COMM_RAM_DC_SPEEDUP_CNT              = 345,
MLT_COMM_RAM_AC_SPEEDUP_CNT              = 346,
MLT_COMM_RAM_LCR_SPEEDUP_CNT             = 347,
MLT_COMM_RAM_CM_SPEEDUP_CNT              = 348,
MLT_COMM_RAM_DC_SPEEDUP_MASK             = 349,
MLT_COMM_RAM_ZSYNTH_IN                   = 350,
MLT_COMM_RAM_I_TAR_SAVE                  = 351,
MLT_COMM_RAM_UNUSED352                   = 352,
MLT_COMM_RAM_UNUSED353                   = 353,
MLT_COMM_RAM_COUNTER_VTR                 = 354,
MLT_COMM_RAM_I_RING_AVG                  = 355,
MLT_COMM_RAM_COUNTER_IRING               = 356,
MLT_COMM_RAM_COMP_RATIO                  = 357,
MLT_COMM_RAM_MADC_VBAT_DIV2              = 358,
MLT_COMM_RAM_VDIFF_PK_T                  = 359,
MLT_COMM_RAM_PEAK_CNT                    = 360,
MLT_COMM_RAM_CM_DBI_CNT                  = 361,
MLT_COMM_RAM_VCM_LAST                    = 362,
MLT_COMM_RAM_VBATL_SENSE                 = 363,
MLT_COMM_RAM_VBATH_SENSE                 = 364,
MLT_COMM_RAM_VBATR_SENSE                 = 365,
MLT_COMM_RAM_BAT_SETTLE_CNT              = 366,
MLT_COMM_RAM_VBAT_TGT                    = 367,
MLT_COMM_RAM_VBAT_REQ                    = 368,
MLT_COMM_RAM_VCM_HIRES                   = 369,
MLT_COMM_RAM_VCM_LORES                   = 370,
MLT_COMM_RAM_ILOOP1                      = 371,
MLT_COMM_RAM_ILONG2                      = 372,
MLT_COMM_RAM_ITIP1                       = 373,
MLT_COMM_RAM_IRING1                      = 374,
MLT_COMM_RAM_CAL_TEMP1                   = 375,
MLT_COMM_RAM_CAL_TEMP2                   = 376,
MLT_COMM_RAM_CAL_TEMP3                   = 377,
MLT_COMM_RAM_CAL_TEMP4                   = 378,
MLT_COMM_RAM_CAL_TEMP5                   = 379,
MLT_COMM_RAM_CAL_TEMP6                   = 380,
MLT_COMM_RAM_CAL_TEMP7                   = 381,
MLT_COMM_RAM_CMRR_DIVISOR                = 382,
MLT_COMM_RAM_CMRR_REMAINDER              = 383,
MLT_COMM_RAM_CMRR_Q_PTR                  = 384,
MLT_COMM_RAM_CAL_ONHK_Z                  = 393,
MLT_COMM_RAM_CAL_LB_SETTLE               = 394,
MLT_COMM_RAM_CAL_DECLPF_V0               = 395,
MLT_COMM_RAM_CAL_DECLPF_V1               = 396,
MLT_COMM_RAM_CAL_DECLPF_V2               = 397,
MLT_COMM_RAM_CAL_GOERTZEL_V0             = 398,
MLT_COMM_RAM_CAL_GOERTZEL_V1             = 399,
MLT_COMM_RAM_CAL_DECLPF_Y                = 400,
MLT_COMM_RAM_CAL_GOERTZEL_Y              = 401,
MLT_COMM_RAM_P_HVIC                      = 402,
MLT_COMM_RAM_VBATL_MIRROR                = 403,
MLT_COMM_RAM_VBATH_MIRROR                = 404,
MLT_COMM_RAM_VBATR_MIRROR                = 405,
MLT_COMM_RAM_DIAG_EX1_OUT                = 406,
MLT_COMM_RAM_DIAG_EX2_OUT                = 407,
MLT_COMM_RAM_DIAG_DMM_V_OUT              = 408,
MLT_COMM_RAM_DIAG_DMM_I_OUT              = 409,
MLT_COMM_RAM_DIAG_P                      = 410,
MLT_COMM_RAM_DIAG_LPF_V                  = 411,
MLT_COMM_RAM_DIAG_LPF_I                  = 412,
MLT_COMM_RAM_DIAG_TONE_FLAG              = 413,
MLT_COMM_RAM_ILOOP1_LAST                 = 414,
MLT_COMM_RAM_RING_ENTRY_VOC              = 415,
MLT_COMM_RAM_OSC1_X_SAVE                 = 417,
MLT_COMM_RAM_EZSYNTH_1                   = 418,
MLT_COMM_RAM_EZSYNTH_2                   = 419,
MLT_COMM_RAM_ZSYNTH_OUT                  = 420,
MLT_COMM_RAM_UNUSED421                   = 421,
MLT_COMM_RAM_CAL_SUBSTATE                = 422,
MLT_COMM_RAM_DIAG_EX1_DC_OUT             = 423,
MLT_COMM_RAM_DIAG_EX1_DC                 = 424,
MLT_COMM_RAM_EZSYNTH_B1                  = 425,
MLT_COMM_RAM_EZSYNTH_B2                  = 426,
MLT_COMM_RAM_EZSYNTH_A1                  = 427,
MLT_COMM_RAM_EZSYNTH_A2                  = 428,
MLT_COMM_RAM_ILOOP1_FILT                 = 429,
MLT_COMM_RAM_AC_PU_DELTA1_CNT            = 430,
MLT_COMM_RAM_AC_PU_DELTA2_CNT            = 431,
MLT_COMM_RAM_UNUSED432                   = 432,
MLT_COMM_RAM_UNUSED433                   = 433,
MLT_COMM_RAM_UNUSED434                   = 434,
MLT_COMM_RAM_AC_DAC_GAIN_SAVE            = 435,
MLT_COMM_RAM_RING_FLUSH_CNT              = 436,
MLT_COMM_RAM_UNUSED437                   = 437,
MLT_COMM_RAM_DIAG_VAR_OUT                = 438,
MLT_COMM_RAM_I_VBAT                      = 439,
MLT_COMM_RAM_CALTMP_LOOPCNT              = 441,
MLT_COMM_RAM_CALTMP_LOOPINC              = 442,
MLT_COMM_RAM_CALTMP_CODEINC              = 444,
MLT_COMM_RAM_CALTMP_TAUINC               = 445,
MLT_COMM_RAM_CALTMP_TAU                  = 446,
MLT_COMM_RAM_CAL_TEMP8                   = 447,
MLT_COMM_RAM_PATCHID                     = 448,
MLT_COMM_RAM_UNUSED449                   = 449,
MLT_COMM_RAM_UNUSED450                   = 450,
MLT_COMM_RAM_UNUSED451                   = 451,
MLT_COMM_RAM_CAL_LB_OFFSET_FWD           = 452,
MLT_COMM_RAM_CAL_LB_OFFSET_RVS           = 453,
MLT_COMM_RAM_COUNT_SPEEDUP               = 454,
MLT_COMM_RAM_SWEEP_COUNT                 = 455,
MLT_COMM_RAM_AMP_RAMP                    = 456,
MLT_COMM_RAM_DIAG_LPF_MADC_D             = 457,
MLT_COMM_RAM_DIAG_HPF_MADC               = 458,
MLT_COMM_RAM_TXDEC_OUT                   = 460,
MLT_COMM_RAM_TXDEC_D1                    = 461,
MLT_COMM_RAM_TXDEC_D2                    = 462,
MLT_COMM_RAM_RXDEC_D1                    = 463,
MLT_COMM_RAM_RXDEC_D2                    = 464,
MLT_COMM_RAM_OSCINT1_D2_1                = 465,
MLT_COMM_RAM_OSCINT1_D1_1                = 466,
MLT_COMM_RAM_OSCINT1_OUT_1               = 467,
MLT_COMM_RAM_OSCINT1_D2_2                = 468,
MLT_COMM_RAM_OSCINT1_D1_2                = 469,
MLT_COMM_RAM_OSCINT1_OUT                 = 470,
MLT_COMM_RAM_OSCINT2_D2_1                = 471,
MLT_COMM_RAM_OSCINT2_D1_1                = 472,
MLT_COMM_RAM_OSCINT2_OUT_1               = 473,
MLT_COMM_RAM_OSCINT2_D2_2                = 474,
MLT_COMM_RAM_OSCINT2_D1_2                = 475,
MLT_COMM_RAM_OSCINT2_OUT                 = 476,
MLT_COMM_RAM_OSC1_Y_SAVE                 = 477,
MLT_COMM_RAM_OSC2_Y_SAVE                 = 478,
MLT_COMM_RAM_PWRSAVE_CNT                 = 479,
MLT_COMM_RAM_VBATR_PK                    = 480,
MLT_COMM_RAM_SPEEDUP_MASK_CNT            = 481,
MLT_COMM_RAM_VCM_RING_FIXED              = 482,
MLT_COMM_RAM_DELTA_VCM                   = 483,
MLT_COMM_RAM_MADC_VTIPC_DIAG_OS          = 484,
MLT_COMM_RAM_MADC_VRINGC_DIAG_OS         = 485,
MLT_COMM_RAM_MADC_VLONG_DIAG_OS          = 486,
MLT_COMM_RAM_PWRSAVE_DBI_CNT             = 492,
MLT_COMM_RAM_COMP_RATIO_SAVE             = 493,
MLT_COMM_RAM_CAL_TEMP9                   = 494,
MLT_COMM_RAM_CAL_TEMP10                  = 495,
MLT_COMM_RAM_DAC_OFFSET_TEMP             = 496,
MLT_COMM_RAM_CAL_DAC_CODE                = 497,
MLT_COMM_RAM_DCDAC_OFFSET                = 498,
MLT_COMM_RAM_VDIFF_COARSE                = 499,
MLT_COMM_RAM_RXACIIR_OUT_4               = 500,
MLT_COMM_RAM_UNUSED511                   = 511,
MLT_COMM_RAM_MINUS_ONE                   = 512,
MLT_COMM_RAM_ILOOPLPF                    = 513,
MLT_COMM_RAM_ILONGLPF                    = 514,
MLT_COMM_RAM_BATLPF                      = 515,
MLT_COMM_RAM_VDIFFLPF                    = 516,
MLT_COMM_RAM_VCMLPF                      = 517,
MLT_COMM_RAM_TXACIIR_B0_1                = 518,
MLT_COMM_RAM_TXACIIR_B1_1                = 519,
MLT_COMM_RAM_TXACIIR_A1_1                = 520,
MLT_COMM_RAM_TXACIIR_B0_2                = 521,
MLT_COMM_RAM_TXACIIR_B1_2                = 522,
MLT_COMM_RAM_TXACIIR_B2_2                = 523,
MLT_COMM_RAM_TXACIIR_A1_2                = 524,
MLT_COMM_RAM_TXACIIR_A2_2                = 525,
MLT_COMM_RAM_TXACIIR_B0_3                = 526,
MLT_COMM_RAM_TXACIIR_B1_3                = 527,
MLT_COMM_RAM_TXACIIR_B2_3                = 528,
MLT_COMM_RAM_TXACIIR_A1_3                = 529,
MLT_COMM_RAM_TXACIIR_A2_3                = 530,
MLT_COMM_RAM_TXACHPF_B0_1                = 531,
MLT_COMM_RAM_TXACHPF_B1_1                = 532,
MLT_COMM_RAM_TXACHPF_A1_1                = 533,
MLT_COMM_RAM_TXACHPF_B0_2                = 534,
MLT_COMM_RAM_TXACHPF_B1_2                = 535,
MLT_COMM_RAM_TXACHPF_B2_2                = 536,
MLT_COMM_RAM_TXACHPF_A1_2                = 537,
MLT_COMM_RAM_TXACHPF_A2_2                = 538,
MLT_COMM_RAM_TXACHPF_GAIN                = 539,
MLT_COMM_RAM_TXACEQ_C0                   = 540,
MLT_COMM_RAM_TXACEQ_C1                   = 541,
MLT_COMM_RAM_TXACEQ_C2                   = 542,
MLT_COMM_RAM_TXACEQ_C3                   = 543,
MLT_COMM_RAM_TXACGAIN                    = 544,
MLT_COMM_RAM_RXACGAIN                    = 545,
MLT_COMM_RAM_RXACEQ_C0                   = 546,
MLT_COMM_RAM_RXACEQ_C1                   = 547,
MLT_COMM_RAM_RXACEQ_C2                   = 548,
MLT_COMM_RAM_RXACEQ_C3                   = 549,
MLT_COMM_RAM_RXACIIR_B0_1                = 550,
MLT_COMM_RAM_RXACIIR_B1_1                = 551,
MLT_COMM_RAM_RXACIIR_A1_1                = 552,
MLT_COMM_RAM_RXACIIR_B0_2                = 553,
MLT_COMM_RAM_RXACIIR_B1_2                = 554,
MLT_COMM_RAM_RXACIIR_B2_2                = 555,
MLT_COMM_RAM_RXACIIR_A1_2                = 556,
MLT_COMM_RAM_RXACIIR_A2_2                = 557,
MLT_COMM_RAM_RXACIIR_B0_3                = 558,
MLT_COMM_RAM_RXACIIR_B1_3                = 559,
MLT_COMM_RAM_RXACIIR_B2_3                = 560,
MLT_COMM_RAM_RXACIIR_A1_3                = 561,
MLT_COMM_RAM_RXACIIR_A2_3                = 562,
MLT_COMM_RAM_ECFIR_C2                    = 563,
MLT_COMM_RAM_ECFIR_C3                    = 564,
MLT_COMM_RAM_ECFIR_C4                    = 565,
MLT_COMM_RAM_ECFIR_C5                    = 566,
MLT_COMM_RAM_ECFIR_C6                    = 567,
MLT_COMM_RAM_ECFIR_C7                    = 568,
MLT_COMM_RAM_ECFIR_C8                    = 569,
MLT_COMM_RAM_ECFIR_C9                    = 570,
MLT_COMM_RAM_ECIIR_B0                    = 571,
MLT_COMM_RAM_ECIIR_B1                    = 572,
MLT_COMM_RAM_ECIIR_A1                    = 573,
MLT_COMM_RAM_ECIIR_A2                    = 574,
MLT_COMM_RAM_DTMFDTF_B0_1                = 575,
MLT_COMM_RAM_DTMFDTF_B1_1                = 576,
MLT_COMM_RAM_DTMFDTF_B2_1                = 577,
MLT_COMM_RAM_DTMFDTF_A1_1                = 578,
MLT_COMM_RAM_DTMFDTF_A2_1                = 579,
MLT_COMM_RAM_DTMFDTF_B0_2                = 580,
MLT_COMM_RAM_DTMFDTF_B1_2                = 581,
MLT_COMM_RAM_DTMFDTF_B2_2                = 582,
MLT_COMM_RAM_DTMFDTF_A1_2                = 583,
MLT_COMM_RAM_DTMFDTF_A2_2                = 584,
MLT_COMM_RAM_DTMFDTF_B0_3                = 585,
MLT_COMM_RAM_DTMFDTF_B1_3                = 586,
MLT_COMM_RAM_DTMFDTF_B2_3                = 587,
MLT_COMM_RAM_DTMFDTF_A1_3                = 588,
MLT_COMM_RAM_DTMFDTF_A2_3                = 589,
MLT_COMM_RAM_DTMFDTF_GAIN                = 590,
MLT_COMM_RAM_DTMFLPF_B0_1                = 591,
MLT_COMM_RAM_DTMFLPF_B1_1                = 592,
MLT_COMM_RAM_DTMFLPF_B2_1                = 593,
MLT_COMM_RAM_DTMFLPF_A1_1                = 594,
MLT_COMM_RAM_DTMFLPF_A2_1                = 595,
MLT_COMM_RAM_DTMFLPF_B0_2                = 596,
MLT_COMM_RAM_DTMFLPF_B1_2                = 597,
MLT_COMM_RAM_DTMFLPF_B2_2                = 598,
MLT_COMM_RAM_DTMFLPF_A1_2                = 599,
MLT_COMM_RAM_DTMFLPF_A2_2                = 600,
MLT_COMM_RAM_DTMFLPF_GAIN                = 601,
MLT_COMM_RAM_DTMFHPF_B0_1                = 602,
MLT_COMM_RAM_DTMFHPF_B1_1                = 603,
MLT_COMM_RAM_DTMFHPF_B2_1                = 604,
MLT_COMM_RAM_DTMFHPF_A1_1                = 605,
MLT_COMM_RAM_DTMFHPF_A2_1                = 606,
MLT_COMM_RAM_DTMFHPF_B0_2                = 607,
MLT_COMM_RAM_DTMFHPF_B1_2                = 608,
MLT_COMM_RAM_DTMFHPF_B2_2                = 609,
MLT_COMM_RAM_DTMFHPF_A1_2                = 610,
MLT_COMM_RAM_DTMFHPF_A2_2                = 611,
MLT_COMM_RAM_DTMFHPF_GAIN                = 612,
MLT_COMM_RAM_POWER_GAIN                  = 613,
MLT_COMM_RAM_GOERTZEL_GAIN               = 614,
MLT_COMM_RAM_MODEM_GAIN                  = 615,
MLT_COMM_RAM_HOTBIT1                     = 616,
MLT_COMM_RAM_HOTBIT0                     = 617,
MLT_COMM_RAM_ROW0_C1                     = 618,
MLT_COMM_RAM_ROW1_C1                     = 619,
MLT_COMM_RAM_ROW2_C1                     = 620,
MLT_COMM_RAM_ROW3_C1                     = 621,
MLT_COMM_RAM_COL0_C1                     = 622,
MLT_COMM_RAM_COL1_C1                     = 623,
MLT_COMM_RAM_COL2_C1                     = 624,
MLT_COMM_RAM_COL3_C1                     = 625,
MLT_COMM_RAM_ROW0_C2                     = 626,
MLT_COMM_RAM_ROW1_C2                     = 627,
MLT_COMM_RAM_ROW2_C2                     = 628,
MLT_COMM_RAM_ROW3_C2                     = 629,
MLT_COMM_RAM_COL0_C2                     = 630,
MLT_COMM_RAM_COL1_C2                     = 631,
MLT_COMM_RAM_COL2_C2                     = 632,
MLT_COMM_RAM_COL3_C2                     = 633,
MLT_COMM_RAM_SLOPE_VLIM                  = 634,
MLT_COMM_RAM_SLOPE_RFEED                 = 635,
MLT_COMM_RAM_SLOPE_ILIM                  = 636,
MLT_COMM_RAM_SLOPE_RING                  = 637,
MLT_COMM_RAM_SLOPE_DELTA1                = 638,
MLT_COMM_RAM_SLOPE_DELTA2                = 639,
MLT_COMM_RAM_V_VLIM                      = 640,
MLT_COMM_RAM_V_RFEED                     = 641,
MLT_COMM_RAM_V_ILIM                      = 642,
MLT_COMM_RAM_CONST_RFEED                 = 643,
MLT_COMM_RAM_CONST_ILIM                  = 644,
MLT_COMM_RAM_I_VLIM                      = 645,
MLT_COMM_RAM_DC_DAC_GAIN                 = 646,
MLT_COMM_RAM_VDIFF_TH                    = 647,
MLT_COMM_RAM_TXDEC_B0                    = 648,
MLT_COMM_RAM_TXDEC_B1                    = 649,
MLT_COMM_RAM_TXDEC_B2                    = 650,
MLT_COMM_RAM_TXDEC_A1                    = 651,
MLT_COMM_RAM_TXDEC_A2                    = 652,
MLT_COMM_RAM_ZSYNTH_B0                   = 653,
MLT_COMM_RAM_ZSYNTH_B1                   = 654,
MLT_COMM_RAM_ZSYNTH_B2                   = 655,
MLT_COMM_RAM_ZSYNTH_A1                   = 656,
MLT_COMM_RAM_ZSYNTH_A2                   = 657,
MLT_COMM_RAM_RXACHPF_B0_1                = 658,
MLT_COMM_RAM_RXACHPF_B1_1                = 659,
MLT_COMM_RAM_RXACHPF_A1_1                = 660,
MLT_COMM_RAM_RXACHPF_B0_2                = 661,
MLT_COMM_RAM_RXACHPF_B1_2                = 662,
MLT_COMM_RAM_RXACHPF_B2_2                = 663,
MLT_COMM_RAM_RXACHPF_A1_2                = 664,
MLT_COMM_RAM_RXACHPF_A2_2                = 665,
MLT_COMM_RAM_RXACHPF_GAIN                = 666,
MLT_COMM_RAM_MASK7LSB                    = 667,
MLT_COMM_RAM_RXDEC_B0                    = 668,
MLT_COMM_RAM_RXDEC_B1                    = 669,
MLT_COMM_RAM_RXDEC_B2                    = 670,
MLT_COMM_RAM_RXDEC_A1                    = 671,
MLT_COMM_RAM_RXDEC_A2                    = 672,
MLT_COMM_RAM_OSCINT1_B0_1                = 673,
MLT_COMM_RAM_OSCINT1_B1_1                = 674,
MLT_COMM_RAM_OSCINT1_B2_1                = 675,
MLT_COMM_RAM_OSCINT1_A1_1                = 676,
MLT_COMM_RAM_OSCINT1_A2_1                = 677,
MLT_COMM_RAM_OSCINT1_B0_2                = 678,
MLT_COMM_RAM_OSCINT1_B1_2                = 679,
MLT_COMM_RAM_OSCINT1_B2_2                = 680,
MLT_COMM_RAM_OSCINT1_A1_2                = 681,
MLT_COMM_RAM_OSCINT1_A2_2                = 682,
MLT_COMM_RAM_OSCINT2_B0_1                = 683,
MLT_COMM_RAM_OSCINT2_B1_1                = 684,
MLT_COMM_RAM_OSCINT2_B2_1                = 685,
MLT_COMM_RAM_OSCINT2_A1_1                = 686,
MLT_COMM_RAM_OSCINT2_A2_1                = 687,
MLT_COMM_RAM_OSCINT2_B0_2                = 688,
MLT_COMM_RAM_OSCINT2_B1_2                = 689,
MLT_COMM_RAM_OSCINT2_B2_2                = 690,
MLT_COMM_RAM_OSCINT2_A1_2                = 691,
MLT_COMM_RAM_OSCINT2_A2_2                = 692,
MLT_COMM_RAM_UNUSED693                   = 693,
MLT_COMM_RAM_UNUSED694                   = 694,
MLT_COMM_RAM_UNUSED695                   = 695,
MLT_COMM_RAM_RING_LPF_B0                 = 696,
MLT_COMM_RAM_RING_LPF_B1                 = 697,
MLT_COMM_RAM_RING_LPF_B2                 = 698,
MLT_COMM_RAM_RING_LPF_A1                 = 699,
MLT_COMM_RAM_RING_LPF_A2                 = 700,
MLT_COMM_RAM_LCRDBI                      = 701,
MLT_COMM_RAM_LONGDBI                     = 702,
MLT_COMM_RAM_VBAT_TIMER                  = 703,
MLT_COMM_RAM_LF_SPEEDUP_TIMER            = 704,
MLT_COMM_RAM_DC_SPEEDUP_TIMER            = 705,
MLT_COMM_RAM_AC_SPEEDUP_TIMER            = 706,
MLT_COMM_RAM_LCR_SPEEDUP_TIMER           = 707,
MLT_COMM_RAM_CM_SPEEDUP_TIMER            = 708,
MLT_COMM_RAM_VCM_TH                      = 709,
MLT_COMM_RAM_AC_SPEEDUP_TH               = 710,
MLT_COMM_RAM_SPR_SIG_0                   = 711,
MLT_COMM_RAM_SPR_SIG_1                   = 712,
MLT_COMM_RAM_SPR_SIG_2                   = 713,
MLT_COMM_RAM_SPR_SIG_3                   = 714,
MLT_COMM_RAM_SPR_SIG_4                   = 715,
MLT_COMM_RAM_SPR_SIG_5                   = 716,
MLT_COMM_RAM_SPR_SIG_6                   = 717,
MLT_COMM_RAM_SPR_SIG_7                   = 718,
MLT_COMM_RAM_SPR_SIG_8                   = 719,
MLT_COMM_RAM_SPR_SIG_9                   = 720,
MLT_COMM_RAM_SPR_SIG_10                  = 721,
MLT_COMM_RAM_SPR_SIG_11                  = 722,
MLT_COMM_RAM_SPR_SIG_12                  = 723,
MLT_COMM_RAM_SPR_SIG_13                  = 724,
MLT_COMM_RAM_SPR_SIG_14                  = 725,
MLT_COMM_RAM_SPR_SIG_15                  = 726,
MLT_COMM_RAM_SPR_SIG_16                  = 727,
MLT_COMM_RAM_SPR_SIG_17                  = 728,
MLT_COMM_RAM_SPR_SIG_18                  = 729,
MLT_COMM_RAM_COUNTER_VTR_VAL             = 730,
MLT_COMM_RAM_CONST_028                   = 731,
MLT_COMM_RAM_CONST_032                   = 732,
MLT_COMM_RAM_CONST_038                   = 733,
MLT_COMM_RAM_CONST_046                   = 734,
MLT_COMM_RAM_COUNTER_IRING_VAL           = 735,
MLT_COMM_RAM_GAIN_RING                   = 736,
MLT_COMM_RAM_RING_HYST                   = 737,
MLT_COMM_RAM_COMP_Z                      = 738,
MLT_COMM_RAM_CONST_115                   = 739,
MLT_COMM_RAM_CONST_110                   = 740,
MLT_COMM_RAM_CONST_105                   = 741,
MLT_COMM_RAM_CONST_100                   = 742,
MLT_COMM_RAM_CONST_095                   = 743,
MLT_COMM_RAM_CONST_090                   = 744,
MLT_COMM_RAM_CONST_085                   = 745,
MLT_COMM_RAM_V_RASUM_IDEAL               = 746,
MLT_COMM_RAM_CONST_ONE                   = 747,
MLT_COMM_RAM_VCM_OH                      = 748,
MLT_COMM_RAM_VCM_RING                    = 749,
MLT_COMM_RAM_VCM_HYST                    = 750,
MLT_COMM_RAM_VOV_GND                     = 751,
MLT_COMM_RAM_VOV_BAT                     = 752,
MLT_COMM_RAM_VOV_RING_BAT                = 753,
MLT_COMM_RAM_CM_DBI                      = 754,
MLT_COMM_RAM_RTPER                       = 755,
MLT_COMM_RAM_P_TH_HVIC                   = 756,
MLT_COMM_RAM_COEF_P_HVIC                 = 759,
MLT_COMM_RAM_BAT_HYST                    = 764,
MLT_COMM_RAM_BAT_DBI                     = 765,
MLT_COMM_RAM_VBATL_EXPECT                = 766,
MLT_COMM_RAM_VBATH_EXPECT                = 767,
MLT_COMM_RAM_VBATR_EXPECT                = 768,
MLT_COMM_RAM_BAT_SETTLE                  = 769,
MLT_COMM_RAM_VBAT_IRQ_TH                 = 770,
MLT_COMM_RAM_MADC_VTIPC_OS               = 771,
MLT_COMM_RAM_MADC_VRINGC_OS              = 772,
MLT_COMM_RAM_MADC_VBAT_OS                = 773,
MLT_COMM_RAM_MADC_VLONG_OS               = 774,
MLT_COMM_RAM_UNUSED775                   = 775,
MLT_COMM_RAM_MADC_VDC_OS                 = 776,
MLT_COMM_RAM_MADC_ILONG_OS               = 777,
MLT_COMM_RAM_MADC_ILOOP_OS               = 780,
MLT_COMM_RAM_MADC_ILOOP_SCALE            = 781,
MLT_COMM_RAM_UNUSED782                   = 782,
MLT_COMM_RAM_UNUSED783                   = 783,
MLT_COMM_RAM_DC_ADC_OS                   = 784,
MLT_COMM_RAM_CAL_UNITY                   = 785,
MLT_COMM_RAM_UNUSED786                   = 786,
MLT_COMM_RAM_UNUSED787                   = 787,
MLT_COMM_RAM_ACADC_OFFSET                = 788,
MLT_COMM_RAM_ACDAC_OFFSET                = 789,
MLT_COMM_RAM_CAL_DCDAC_CODE              = 790,
MLT_COMM_RAM_CAL_DCDAC_15MA              = 791,
MLT_COMM_RAM_CAL_LB_TSQUELCH             = 801,
MLT_COMM_RAM_CAL_LB_TCHARGE              = 802,
MLT_COMM_RAM_CAL_LB_TSETTLE0             = 803,
MLT_COMM_RAM_CAL_GOERTZEL_DLY            = 804,
MLT_COMM_RAM_CAL_GOERTZEL_ALPHA          = 805,
MLT_COMM_RAM_CAL_DECLPF_K                = 806,
MLT_COMM_RAM_CAL_DECLPF_B1               = 807,
MLT_COMM_RAM_CAL_DECLPF_B2               = 808,
MLT_COMM_RAM_CAL_DECLPF_A1               = 809,
MLT_COMM_RAM_CAL_DECLPF_A2               = 810,
MLT_COMM_RAM_CAL_ACADC_THRL              = 811,
MLT_COMM_RAM_CAL_ACADC_THRH              = 812,
MLT_COMM_RAM_CAL_ACADC_TSETTLE           = 813,
MLT_COMM_RAM_DTROW0TH                    = 814,
MLT_COMM_RAM_DTROW1TH                    = 815,
MLT_COMM_RAM_DTROW2TH                    = 816,
MLT_COMM_RAM_DTROW3TH                    = 817,
MLT_COMM_RAM_DTCOL0TH                    = 818,
MLT_COMM_RAM_DTCOL1TH                    = 819,
MLT_COMM_RAM_DTCOL2TH                    = 820,
MLT_COMM_RAM_DTCOL3TH                    = 821,
MLT_COMM_RAM_DTFTWTH                     = 822,
MLT_COMM_RAM_DTRTWTH                     = 823,
MLT_COMM_RAM_DTROWRTH                    = 824,
MLT_COMM_RAM_DTCOLRTH                    = 825,
MLT_COMM_RAM_DTROW2HTH                   = 826,
MLT_COMM_RAM_DTCOL2HTH                   = 827,
MLT_COMM_RAM_DTMINPTH                    = 828,
MLT_COMM_RAM_DTHOTTH                     = 829,
MLT_COMM_RAM_RXPWR                       = 830,
MLT_COMM_RAM_TXPWR                       = 831,
MLT_COMM_RAM_RXMODPWR                    = 832,
MLT_COMM_RAM_TXMODPWR                    = 833,
MLT_COMM_RAM_FSKFREQ0                    = 834,
MLT_COMM_RAM_FSKFREQ1                    = 835,
MLT_COMM_RAM_FSKAMP0                     = 836,
MLT_COMM_RAM_FSKAMP1                     = 837,
MLT_COMM_RAM_FSK01                       = 838,
MLT_COMM_RAM_FSK10                       = 839,
MLT_COMM_RAM_VOCDELTA                    = 840,
MLT_COMM_RAM_VOCLTH                      = 841,
MLT_COMM_RAM_VOCHTH                      = 842,
MLT_COMM_RAM_RINGOF                      = 843,
MLT_COMM_RAM_RINGFR                      = 844,
MLT_COMM_RAM_RINGAMP                     = 845,
MLT_COMM_RAM_RINGPHAS                    = 846,
MLT_COMM_RAM_RTDCTH                      = 847,
MLT_COMM_RAM_RTACTH                      = 848,
MLT_COMM_RAM_RTDCDB                      = 849,
MLT_COMM_RAM_RTACDB                      = 850,
MLT_COMM_RAM_RTCOUNT                     = 851,
MLT_COMM_RAM_LCROFFHK                    = 852,
MLT_COMM_RAM_LCRONHK                     = 853,
MLT_COMM_RAM_LCRMASK                     = 854,
MLT_COMM_RAM_LCRMASK_POLREV              = 855,
MLT_COMM_RAM_LCRMASK_STATE               = 856,
MLT_COMM_RAM_LCRMASK_LINECAP             = 857,
MLT_COMM_RAM_LONGHITH                    = 858,
MLT_COMM_RAM_LONGLOTH                    = 859,
MLT_COMM_RAM_IRING_LIM                   = 860,
MLT_COMM_RAM_AC_PU_DELTA1                = 861,
MLT_COMM_RAM_AC_PU_DELTA2                = 862,
MLT_COMM_RAM_DIAG_LPF_8K                 = 863,
MLT_COMM_RAM_DIAG_LPF_128K               = 864,
MLT_COMM_RAM_DIAG_INV_N                  = 865,
MLT_COMM_RAM_DIAG_GAIN                   = 866,
MLT_COMM_RAM_DIAG_G_CAL                  = 867,
MLT_COMM_RAM_DIAG_OS_CAL                 = 868,
MLT_COMM_RAM_SPR_GAIN_TRIM               = 869,
MLT_COMM_RAM_AC_DAC_GAIN                 = 871,
MLT_COMM_RAM_AC_DAC_GAIN0                = 874,
MLT_COMM_RAM_EZSYNTH_B0                  = 875,
MLT_COMM_RAM_UNUSED877                   = 877,
MLT_COMM_RAM_UNUSED879                   = 879,
MLT_COMM_RAM_AC_ADC_GAIN                 = 880,
MLT_COMM_RAM_ILOOP1LPF                   = 881,
MLT_COMM_RAM_RING_FLUSH_TIMER            = 882,
MLT_COMM_RAM_ALAW_BIAS                   = 883,
MLT_COMM_RAM_MADC_VTRC_SCALE             = 884,
MLT_COMM_RAM_MADC_VLONG_SCALE            = 887,
MLT_COMM_RAM_MADC_VLONG_SCALE_RING       = 888,
MLT_COMM_RAM_UNUSED889                   = 889,
MLT_COMM_RAM_MADC_VDC_SCALE              = 890,
MLT_COMM_RAM_MADC_ILONG_SCALE            = 891,
MLT_COMM_RAM_UNUSED893                   = 893,
MLT_COMM_RAM_VDIFF_SENSE_SCALE           = 894,
MLT_COMM_RAM_VDIFF_SENSE_SCALE_RING      = 895,
MLT_COMM_RAM_VOV_RING_GND                = 896,
MLT_COMM_RAM_CAL_LB_OSC1_FREQ            = 898,
MLT_COMM_RAM_CAL_DCDAC_9TAU              = 899,
MLT_COMM_RAM_CAL_MADC_9TAU               = 900,
MLT_COMM_RAM_ADAP_RING_MIN_I             = 901,
MLT_COMM_RAM_SWEEP_STEP                  = 902,
MLT_COMM_RAM_SWEEP_STEP_SAVE             = 903,
MLT_COMM_RAM_SWEEP_REF                   = 904,
MLT_COMM_RAM_AMP_STEP                    = 905,
MLT_COMM_RAM_RXACGAIN_SAVE               = 906,
MLT_COMM_RAM_AMP_RAMP_INIT               = 907,
MLT_COMM_RAM_DIAG_HPF_GAIN               = 908,
MLT_COMM_RAM_DIAG_HPF_8K                 = 909,
MLT_COMM_RAM_DIAG_ADJ_STEP               = 910,
MLT_COMM_RAM_UNUSED912                   = 912,
MLT_COMM_RAM_MADC_SCALE_INV              = 913,
MLT_COMM_RAM_UNUSED914                   = 914,
MLT_COMM_RAM_PWRSAVE_TIMER               = 915,
MLT_COMM_RAM_OFFHOOK_THRESH              = 916,
MLT_COMM_RAM_SPEEDUP_MASK_TIMER          = 917,
MLT_COMM_RAM_DC_HOLD_DAC_OS              = 927,
MLT_COMM_RAM_NOTCH_B0                    = 929,
MLT_COMM_RAM_NOTCH_B1                    = 930,
MLT_COMM_RAM_NOTCH_B2                    = 931,
MLT_COMM_RAM_NOTCH_A1                    = 932,
MLT_COMM_RAM_NOTCH_A2                    = 933,
MLT_COMM_RAM_METER_LPF_B0                = 934,
MLT_COMM_RAM_METER_LPF_B1                = 935,
MLT_COMM_RAM_METER_LPF_B2                = 936,
MLT_COMM_RAM_METER_LPF_A1                = 937,
MLT_COMM_RAM_METER_LPF_A2                = 938,
MLT_COMM_RAM_METER_SIG_0                 = 939,
MLT_COMM_RAM_METER_SIG_1                 = 940,
MLT_COMM_RAM_METER_SIG_2                 = 941,
MLT_COMM_RAM_METER_SIG_3                 = 942,
MLT_COMM_RAM_METER_SIG_4                 = 943,
MLT_COMM_RAM_METER_SIG_5                 = 944,
MLT_COMM_RAM_METER_SIG_6                 = 945,
MLT_COMM_RAM_METER_SIG_7                 = 946,
MLT_COMM_RAM_METER_SIG_8                 = 947,
MLT_COMM_RAM_METER_SIG_9                 = 948,
MLT_COMM_RAM_METER_SIG_10                = 949,
MLT_COMM_RAM_METER_SIG_11                = 950,
MLT_COMM_RAM_METER_SIG_12                = 951,
MLT_COMM_RAM_METER_SIG_13                = 952,
MLT_COMM_RAM_METER_SIG_14                = 953,
MLT_COMM_RAM_METER_SIG_15                = 954,
MLT_COMM_RAM_METER_BP_B0                 = 955,
MLT_COMM_RAM_METER_BP_B1                 = 956,
MLT_COMM_RAM_METER_BP_B2                 = 957,
MLT_COMM_RAM_METER_BP_A1                 = 958,
MLT_COMM_RAM_METER_BP_A2                 = 959,
MLT_COMM_RAM_PM_AMP_THRESH               = 960,
MLT_COMM_RAM_PWRSAVE_DBI                 = 962,
MLT_COMM_RAM_DCDC_ANA_SCALE              = 963,
MLT_COMM_RAM_VOV_BAT_PWRSAVE_LO          = 964,
MLT_COMM_RAM_VOV_BAT_PWRSAVE_HI          = 965,
MLT_COMM_RAM_AC_ADC_GAIN0                = 966,
MLT_COMM_RAM_SCALE_KAUDIO                = 967,
MLT_COMM_RAM_UNUSED1022                  = 1022,
MLT_COMM_RAM_UNUSED1023                  = 1023,
MLT_COMM_RAM_DAC_IN                      = 1281,
MLT_COMM_RAM_ADC_OUT                     = 1282,
MLT_COMM_RAM_PASS1                       = 1283,
MLT_COMM_RAM_TX_AC_INT                   = 1284,
MLT_COMM_RAM_RX_AC_DIFF                  = 1285,
MLT_COMM_RAM_INDIRECT_WR                 = 1286,
MLT_COMM_RAM_INDIRECT_RD                 = 1287,
MLT_COMM_RAM_BYPASS_OUT                  = 1288,
MLT_COMM_RAM_ACC                         = 1289,
MLT_COMM_RAM_INDIRECT_RAM_A              = 1290,
MLT_COMM_RAM_INDIRECT_RAM_B              = 1291,
MLT_COMM_RAM_HOT_BIT1                    = 1292,
MLT_COMM_RAM_HOT_BIT0                    = 1293,
MLT_COMM_RAM_PASS0_ROW_PWR               = 1294,
MLT_COMM_RAM_PASS0_COL_PWR               = 1295,
MLT_COMM_RAM_PASS0_ROW                   = 1296,
MLT_COMM_RAM_PASS0_COL                   = 1297,
MLT_COMM_RAM_PASS0_ROW_REL               = 1298,
MLT_COMM_RAM_PASS0_COL_REL               = 1299,
MLT_COMM_RAM_PASS0_ROW_2ND               = 1300,
MLT_COMM_RAM_PASS0_COL_2ND               = 1301,
MLT_COMM_RAM_PASS0_REV_TW                = 1302,
MLT_COMM_RAM_PASS0_FWD_TW                = 1303,
MLT_COMM_RAM_CAL_CM_BAL_TEST             = 1305,
MLT_COMM_RAM_TONE1                       = 1307,
MLT_COMM_RAM_TONE2                       = 1308,
MLT_COMM_RAM_RING_TRIG                   = 1309,
MLT_COMM_RAM_VCM_DAC                     = 1310,
MLT_COMM_RAM_RING_DAC                    = 1312,
MLT_COMM_RAM_VRING_CROSSING              = 1313,
MLT_COMM_RAM_UNUSED_REG290               = 1314,
MLT_COMM_RAM_LINEFEED_SHADOW             = 1315,
MLT_COMM_RAM_ROW_DIGIT                   = 1319,
MLT_COMM_RAM_COL_DIGIT                   = 1320,
MLT_COMM_RAM_PQ1_IRQ                     = 1322,
MLT_COMM_RAM_PQ2_IRQ                     = 1323,
MLT_COMM_RAM_PQ3_IRQ                     = 1324,
MLT_COMM_RAM_PQ4_IRQ                     = 1325,
MLT_COMM_RAM_PQ5_IRQ                     = 1326,
MLT_COMM_RAM_PQ6_IRQ                     = 1327,
MLT_COMM_RAM_LCR_SET                     = 1328,
MLT_COMM_RAM_LCR_CLR                     = 1329,
MLT_COMM_RAM_RTP_SET                     = 1330,
MLT_COMM_RAM_LONG_SET                    = 1331,
MLT_COMM_RAM_LONG_CLR                    = 1332,
MLT_COMM_RAM_VDIFF_IRQ                   = 1333,
MLT_COMM_RAM_MODFEED_SET                 = 1334,
MLT_COMM_RAM_MODFEED_CLR                 = 1335,
MLT_COMM_RAM_LF_SPEEDUP_SET              = 1336,
MLT_COMM_RAM_LF_SPEEDUP_CLR              = 1337,
MLT_COMM_RAM_DC_SPEEDUP_SET              = 1338,
MLT_COMM_RAM_DC_SPEEDUP_CLR              = 1339,
MLT_COMM_RAM_AC_SPEEDUP_SET              = 1340,
MLT_COMM_RAM_AC_SPEEDUP_CLR              = 1341,
MLT_COMM_RAM_LCR_SPEEDUP_SET             = 1342,
MLT_COMM_RAM_LCR_SPEEDUP_CLR             = 1343,
MLT_COMM_RAM_CM_SPEEDUP_SET              = 1344,
MLT_COMM_RAM_CM_SPEEDUP_CLR              = 1345,
MLT_COMM_RAM_MODEMPASS0                  = 1346,
MLT_COMM_RAM_RX2100_PASS1_PWR            = 1347,
MLT_COMM_RAM_RX2100_PASS1_THR            = 1348,
MLT_COMM_RAM_TX2100_PASS1_PWR            = 1349,
MLT_COMM_RAM_TX2100_PASS1_THR            = 1350,
MLT_COMM_RAM_TXMDM_TRIG                  = 1351,
MLT_COMM_RAM_RXMDM_TRIG                  = 1352,
MLT_COMM_RAM_TX_FILT_CLR                 = 1354,
MLT_COMM_RAM_TX_DC_INT                   = 1355,
MLT_COMM_RAM_RX_DC_MOD_IN                = 1356,
MLT_COMM_RAM_DSP_ACCESS                  = 1357,
MLT_COMM_RAM_PRAM_ADDR                   = 1358,
MLT_COMM_RAM_PRAM_DATA                   = 1359,
MLT_COMM_RAM_IND_RAM_A_BASE              = 1360,
MLT_COMM_RAM_IND_RAM_A_ADDR              = 1361,
MLT_COMM_RAM_IND_RAM_A_MOD               = 1362,
MLT_COMM_RAM_IND_RAM_B_BASE              = 1363,
MLT_COMM_RAM_IND_RAM_B_ADDR              = 1364,
MLT_COMM_RAM_IND_RAM_B_MOD               = 1365,
MLT_COMM_RAM_USER_B0                     = 1369,
MLT_COMM_RAM_USER_B1                     = 1370,
MLT_COMM_RAM_USER_B2                     = 1371,
MLT_COMM_RAM_USER_B3                     = 1372,
MLT_COMM_RAM_USER_B4                     = 1373,
MLT_COMM_RAM_USER_B5                     = 1374,
MLT_COMM_RAM_USER_B6                     = 1375,
MLT_COMM_RAM_USER_B7                     = 1376,
MLT_COMM_RAM_FLUSH_AUDIO_CLR             = 1377,
MLT_COMM_RAM_FLUSH_DC_CLR                = 1378,
MLT_COMM_RAM_SPR_CLR                     = 1379,
MLT_COMM_RAM_GPI1                        = 1381,
MLT_COMM_RAM_GPI2                        = 1382,
MLT_COMM_RAM_GPI3                        = 1383,
MLT_COMM_RAM_GPO1                        = 1385,
MLT_COMM_RAM_GPO2                        = 1386,
MLT_COMM_RAM_GPO3                        = 1387,
MLT_COMM_RAM_GPO1_OE                     = 1389,
MLT_COMM_RAM_GPO2_OE                     = 1390,
MLT_COMM_RAM_GPO3_OE                     = 1391,
MLT_COMM_RAM_BATSEL_L_SET                = 1392,
MLT_COMM_RAM_BATSEL_H_SET                = 1393,
MLT_COMM_RAM_BATSEL_R_SET                = 1394,
MLT_COMM_RAM_BATSEL_CLR                  = 1395,
MLT_COMM_RAM_VBAT_IRQ                    = 1396,
MLT_COMM_RAM_MADC_VTIPC_RAW              = 1397,
MLT_COMM_RAM_MADC_VRINGC_RAW             = 1398,
MLT_COMM_RAM_MADC_VBAT_RAW               = 1399,
MLT_COMM_RAM_MADC_VLONG_RAW              = 1400,
MLT_COMM_RAM_UNUSED_REG377               = 1401,
MLT_COMM_RAM_MADC_VDC_RAW                = 1402,
MLT_COMM_RAM_MADC_ILONG_RAW              = 1403,
MLT_COMM_RAM_MADC_ILOOP_RAW              = 1406,
MLT_COMM_RAM_MADC_DIAG_RAW               = 1407,
MLT_COMM_RAM_CALR3_DSP                   = 1410,
MLT_COMM_RAM_PD_MADC                     = 1411,
MLT_COMM_RAM_UNUSED_REG388               = 1412,
MLT_COMM_RAM_PD_BIAS                     = 1413,
MLT_COMM_RAM_PD_DC_ADC                   = 1414,
MLT_COMM_RAM_PD_DC_DAC                   = 1415,
MLT_COMM_RAM_PD_DC_SNS                   = 1416,
MLT_COMM_RAM_PD_DC_COARSE_SNS            = 1417,
MLT_COMM_RAM_PD_VBAT_SNS                 = 1418,
MLT_COMM_RAM_PD_DC_BUF                   = 1419,
MLT_COMM_RAM_PD_AC_ADC                   = 1420,
MLT_COMM_RAM_PD_AC_DAC                   = 1421,
MLT_COMM_RAM_PD_AC_SNS                   = 1422,
MLT_COMM_RAM_PD_CM_SNS                   = 1423,
MLT_COMM_RAM_PD_CM                       = 1424,
MLT_COMM_RAM_PD_SUM                      = 1427,
MLT_COMM_RAM_PD_LKGDAC                   = 1428,
MLT_COMM_RAM_PD_HVIC                     = 1430,
MLT_COMM_RAM_CMDAC_CHEN_B                = 1432,
MLT_COMM_RAM_SUM_CHEN_B                  = 1433,
MLT_COMM_RAM_TRNRD_CHEN_B                = 1434,
MLT_COMM_RAM_DC_BUF_CHEN_B               = 1436,
MLT_COMM_RAM_AC_SNS_CHEN_B               = 1437,
MLT_COMM_RAM_DC_SNS_CHEN_B               = 1438,
MLT_COMM_RAM_LB_MUX_CHEN_B               = 1439,
MLT_COMM_RAM_CMDAC_EN_B                  = 1441,
MLT_COMM_RAM_RA_EN_B                     = 1442,
MLT_COMM_RAM_RD_EN_B                     = 1443,
MLT_COMM_RAM_VCTL                        = 1444,
MLT_COMM_RAM_UNUSED_REG422               = 1446,
MLT_COMM_RAM_HVIC_STATE                  = 1447,
MLT_COMM_RAM_HVIC_STATE_OBSERVE          = 1448,
MLT_COMM_RAM_HVIC_STATE_MAN              = 1449,
MLT_COMM_RAM_HVIC_STATE_READ             = 1450,
MLT_COMM_RAM_VCMDAC_SCALE_MAN            = 1452,
MLT_COMM_RAM_CAL_ACADC_CNTL              = 1453,
MLT_COMM_RAM_CAL_ACDAC_CNTL              = 1454,
MLT_COMM_RAM_CAL_DCDAC_CNTL              = 1456,
MLT_COMM_RAM_CAL_TRNRD_CNTL              = 1457,
MLT_COMM_RAM_CAL_TRNRD_DACT              = 1458,
MLT_COMM_RAM_CAL_TRNRD_DACR              = 1459,
MLT_COMM_RAM_LKG_UPT_ACTIVE              = 1460,
MLT_COMM_RAM_LKG_UPR_ACTIVE              = 1461,
MLT_COMM_RAM_LKG_DNT_ACTIVE              = 1462,
MLT_COMM_RAM_LKG_DNR_ACTIVE              = 1463,
MLT_COMM_RAM_CAL_LKG_EN_CNTL             = 1468,
MLT_COMM_RAM_CAL_PUPD_CNTL               = 1469,
MLT_COMM_RAM_CAL_AC_RCAL                 = 1471,
MLT_COMM_RAM_CAL_DC_RCAL                 = 1472,
MLT_COMM_RAM_KAC_MOD                     = 1473,
MLT_COMM_RAM_KAC_SEL                     = 1474,
MLT_COMM_RAM_SEL_RING                    = 1475,
MLT_COMM_RAM_CMDAC_FWD                   = 1476,
MLT_COMM_RAM_CMDAC_RVS                   = 1477,
MLT_COMM_RAM_CAL_INC_STATE               = 1478,
MLT_COMM_RAM_CAL_DCDAC_COMP              = 1479,
MLT_COMM_RAM_BAT_SWITCH                  = 1480,
MLT_COMM_RAM_CH_IRQ                      = 1481,
MLT_COMM_RAM_ILOOP_CROSSING              = 1482,
MLT_COMM_RAM_VOC_FAILSAFE                = 1483,
MLT_COMM_RAM_GENERIC_0                   = 1486,
MLT_COMM_RAM_GENERIC_1                   = 1487,
MLT_COMM_RAM_GENERIC_2                   = 1488,
MLT_COMM_RAM_GENERIC_3                   = 1489,
MLT_COMM_RAM_GENERIC_4                   = 1490,
MLT_COMM_RAM_GENERIC_5                   = 1491,
MLT_COMM_RAM_GENERIC_6                   = 1492,
MLT_COMM_RAM_GENERIC_7                   = 1493,
MLT_COMM_RAM_QHI_SET                     = 1496,
MLT_COMM_RAM_QHI_CLR                     = 1497,
MLT_COMM_RAM_RDC_SUM                     = 1499,
MLT_COMM_RAM_FLUSH_AUDIO_MAN             = 1506,
MLT_COMM_RAM_FLUSH_DC_MAN                = 1507,
MLT_COMM_RAM_TIP_RING_CNTL               = 1508,
MLT_COMM_RAM_SQUELCH_SET                 = 1509,
MLT_COMM_RAM_SQUELCH_CLR                 = 1510,
MLT_COMM_RAM_CAL_STATE_MAN               = 1511,
MLT_COMM_RAM_RINGING_BW                  = 1514,
MLT_COMM_RAM_AUDIO_MAN                   = 1515,
MLT_COMM_RAM_HVIC_STATE_SPARE            = 1516,
MLT_COMM_RAM_RINGING_FAST_MAN            = 1517,
MLT_COMM_RAM_VCM_DAC_MAN                 = 1518,
MLT_COMM_RAM_GENERIC_8                   = 1522,
MLT_COMM_RAM_GENERIC_9                   = 1523,
MLT_COMM_RAM_GENERIC_10                  = 1524,
MLT_COMM_RAM_GENERIC_11                  = 1525,
MLT_COMM_RAM_GENERIC_12                  = 1527,
MLT_COMM_RAM_GENERIC_13                  = 1528,
MLT_COMM_RAM_DC_HOLD_DAC                 = 1530,
MLT_COMM_RAM_OFFHOOK_CMP                 = 1531,
MLT_COMM_RAM_PWRSAVE_SET                 = 1532,
MLT_COMM_RAM_PWRSAVE_CLR                 = 1533,
MLT_COMM_RAM_PD_WKUP                     = 1534,
MLT_COMM_RAM_SPEEDUP_MASK_SET            = 1535,
MLT_COMM_RAM_SPEEDUP_MASK_CLR            = 1536,
MLT_COMM_RAM_PD_DCDC                     = 1538,
MLT_COMM_RAM_UNUSED_REG515               = 1539,
MLT_COMM_RAM_PD_UVLO                     = 1540,
MLT_COMM_RAM_PD_OVLO                     = 1541,
MLT_COMM_RAM_PD_OCLO                     = 1542,
MLT_COMM_RAM_PD_SWDRV                    = 1543,
MLT_COMM_RAM_DCDC_UVHYST                 = 1545,
MLT_COMM_RAM_DCDC_UVTHRESH               = 1546,
MLT_COMM_RAM_DCDC_OVTHRESH               = 1547,
MLT_COMM_RAM_DCDC_OITHRESH               = 1548,
MLT_COMM_RAM_DCDC_STATUS                 = 1551,
MLT_COMM_RAM_DCDC_SWDRV_POL              = 1553,
MLT_COMM_RAM_DCDC_UVPOL                  = 1554,
MLT_COMM_RAM_DCDC_VREF_MAN               = 1557,
MLT_COMM_RAM_DCDC_VREF_CTRL              = 1558,
MLT_COMM_RAM_DCDC_RNGTYPE                = 1560,
MLT_COMM_RAM_DCDC_DIN_FILT               = 1561,
MLT_COMM_RAM_DCDC_DOUT                   = 1563,
MLT_COMM_RAM_UNUSED_REG540               = 1564,
MLT_COMM_RAM_DCDC_OIMASK                 = 1565,
MLT_COMM_RAM_DCDC_SC_SET                 = 1568,
MLT_COMM_RAM_WAKE_HOLD                   = 1569,
MLT_COMM_RAM_PD_AC_SQUELCH               = 1570,
MLT_COMM_RAM_PD_REF_OSC                  = 1571,
MLT_COMM_RAM_PWRSAVE_MAN                 = 1573,
MLT_COMM_RAM_PWRSAVE_SEL                 = 1574,
MLT_COMM_RAM_PWRSAVE_CTRL_LO             = 1575,
MLT_COMM_RAM_PWRSAVE_CTRL_HI             = 1576,
MLT_COMM_RAM_PWRSAVE_HVIC_LO             = 1577,
MLT_COMM_RAM_PWRSAVE_HVIC_HI             = 1578,
MLT_COMM_RAM_DSP_PROM_MISR               = 1579,
MLT_COMM_RAM_DSP_CROM_MISR               = 1580,
MLT_COMM_RAM_RAMBIST_ERROR               = 1583,
MLT_COMM_RAM_DCDC_ANA_VREF               = 1584,
MLT_COMM_RAM_DCDC_ANA_GAIN               = 1585,
MLT_COMM_RAM_DCDC_ANA_TOFF               = 1586,
MLT_COMM_RAM_DCDC_ANA_TONMIN             = 1587,
MLT_COMM_RAM_DCDC_ANA_TONMAX             = 1588,
MLT_COMM_RAM_DCDC_ANA_DSHIFT             = 1589,
MLT_COMM_RAM_DCDC_ANA_LPOLY              = 1590,
MLT_COMM_RAM_DCDC_ANA_PSKIP              = 1591,
MLT_COMM_RAM_PD_DCDC_ANA                 = 1592,
MLT_COMM_RAM_PWRPEND_SET                 = 1595,
MLT_COMM_RAM_PD_CM_BUF                   = 1596,
};

#endif
