#include <linux/module.h>
#include "ddrnet.h"
#ifdef USE_DDRNET_PACKET
#define PSB_DATA_PTR_LEN 4

#define TAG_SIZE                4
        
static unsigned char B_TAG[TAG_SIZE]           =       {0xaa, 0xaa, 0x55, 0x55};
static unsigned char E_TAG[TAG_SIZE]           =       {0x55, 0x55, 0xaa, 0xaa};



//u32 g_ddrnet_tx = 0;
//u32 g_ddrnet_tx_drop = 0;
//u32 g_ddrnet_tx_free = 0;
//u32 g_ddrnet_tx_free_drop = 0;
extern struct ddrnet_queue free_psb_que;
extern struct ddrnet_queue free_psb_que_free;

extern struct semaphore  freepsb_que_sem;
extern struct timer_list freepsb_wrap_timer;
extern struct spinlock g_psbuf_nr_lock;
extern u32 g_ddrnet_psbuf_nr;



u32 g_ddrnet_wrap_num = 10;
module_param(g_ddrnet_wrap_num, int, 0644);
u32 g_ddrnet_time_interval = 10;
module_param(g_ddrnet_time_interval, int, 0644);

u32 g_ddrnet_skb_timer_nr = 0;
module_param(g_ddrnet_skb_timer_nr, int, 0444);
u32 g_ddrnet_freepsb_timer_nr = 0;
module_param(g_ddrnet_freepsb_timer_nr, int, 0444);
u32 g_ddrnet_skb_pkg_unfull_nr = 0;
module_param(g_ddrnet_skb_pkg_unfull_nr, int, 0444);



void ddrnet_skb_Wrap_TimerCallBack(u32 hnd)
{
    struct  ddrnet *dev = (struct ddrnet *)hnd;	
    up(&dev->skb_que_sem);
    g_ddrnet_skb_timer_nr++;
    //printk("#########ddrnet_skb_Wrap_TimerCallBack#########\n");
}
void ddrnet_freepsb_Wrap_TimerCallBack(u32 hnd)
{
    up(&freepsb_que_sem);
    g_ddrnet_freepsb_timer_nr++;
    //printk("#########ddrnet_freepsb_Wrap_TimerCallBack#########\n");
}
s32 ddrnet_freepsb_pkg_xmit(struct ddrnet_package* pkg)
{
    int ret = 0;    
    T_ZDrvRpMsg_Msg msg = { .actorID = PS_ID,
                           .chID = ICP_CHANNEL_DEV_BUFFREE,
                           .flag = RPMSG_WRITE_INT,
                           .buf = NULL,
                           /*.len = sizeof(struct ddrnet_package)*/ };

    msg.buf = pkg;	
    msg.len = sizeof(u32) + pkg->pkg_length * PSB_DATA_PTR_LEN + TAG_SIZE * 2;
    do
    {
        ret = zDrvRpMsg_WriteLockIrq(&msg);
        if(ret <= 0)
        {
            printk("ddrnet_freepsb_pkg_xmit faile ret : %d\n", ret);
            msleep(100);
        }

    }while(ret <= 0);
    return ret;
}


s32 ddrnet_skb_pkg_xmit(struct ddrnet * dev, struct ddrnet_package* pkg)
{
    int ret = 0;  
    T_ZDrvRpMsg_Msg msg;
    memset(&msg, 0, sizeof(T_ZDrvRpMsg_Msg));
    msg.actorID = dev->actor_id;
    msg.chID = dev->channel_id;
    msg.flag |= RPMSG_WRITE_INT;

    msg.buf = pkg;
    //msg.len = sizeof(struct ddrnet_package);
    msg.len = sizeof(u32) + pkg->pkg_length * DDRNET_SKB_PACKET_UNIT_SIZE + TAG_SIZE * 2;
    do
    {
        ret = zDrvRpMsg_WriteLockIrq(&msg);
        if(ret <= 0)
        {
            printk("ddrnet_skb_pkg_xmit faile ret : %d\n", ret);
            msleep(100);
        }
    }while(ret <= 0);
    
    return ret;

}

s32 ddrnet_skb_wrap_thread(void * __dev)
{
    struct ddrnet *dev = (struct ddrnet *)__dev;
    struct ddrnet_queue* que = &dev->skb_que;
    struct ddrnet_queue* que_free = &dev->skb_que_free;
    struct ddrnet_package pkg = {0};
    struct ddrnet_skb_packet* pkt = NULL;
    struct list_head* phead = NULL;
    struct list_head* plist = NULL;
    u8 loop = 0;
    u8 cursor = 0;
    u32 spin_flag = 0;
    
    struct sched_param param = { .sched_priority = 1 };
    param.sched_priority = 37;
    //sched_setscheduler(current, SCHED_FIFO, &param);
    
    while(1) {
        down(&dev->skb_que_sem);
        spin_lock_irqsave(&que->lock, spin_flag);
        if(que->qlen <= 0)
        {
            spin_unlock_irqrestore(&que->lock, spin_flag);
            continue;
        }
        spin_unlock_irqrestore(&que->lock, spin_flag);
        //cursor = 0;
        memcpy(pkg.contents, B_TAG, TAG_SIZE);
        cursor = TAG_SIZE; 
        phead = &que->queue;
        for(loop = 0; loop < g_ddrnet_wrap_num/*WRAP_PACKET_THRESHHOLD*/; loop++)
        {
            
            spin_lock_irqsave(&que->lock, spin_flag);
            if(ddrnet_is_list_empty(phead))
            {
                spin_unlock_irqrestore(&que->lock, spin_flag);
                break;
            }
            pkt = list_first_entry(phead, struct ddrnet_skb_packet, list);

            ddrnet_list_delete(&pkt->list);
            que->qlen--;
            spin_unlock_irqrestore(&que->lock, spin_flag);
            
            memcpy(pkg.contents + cursor, &pkt->packet, DDRNET_SKB_PACKET_UNIT_SIZE);
            //printk("wrap thread, skb head:data %x:%x, skb %#x\n ", pkt->packet.skb_head, pkt->packet.skb_data, pkt->packet.skb);
            cursor += DDRNET_SKB_PACKET_UNIT_SIZE;
            
            spin_lock_irqsave(&que_free->lock, spin_flag);
            ddrnet_list_insert_tail(&pkt->list, &que_free->queue);
            que_free->qlen++;
            spin_unlock_irqrestore(&que_free->lock, spin_flag);   
        }            
        pkg.pkg_length = loop;
        if(loop < g_ddrnet_wrap_num)
            g_ddrnet_skb_pkg_unfull_nr++;
            //printk("########### skb big package not full, volume : %d ########\n", loop);
        memcpy(pkg.contents + cursor, E_TAG, TAG_SIZE);
        ddrnet_skb_pkg_xmit(dev, &pkg);
        //g_ddrnet_tx++;
        //printk("g_ddrnet_tx  %d\n", g_ddrnet_tx);
    }
    return 0;
}
int ddrnet_freepsb_wrap_thread(void)
{
    struct ddrnet_queue* que = &free_psb_que;
    struct ddrnet_queue* que_free = &free_psb_que_free;
    struct ddrnet_package pkg = {0};
    struct ddrnet_psbuf_packet* pkt = NULL;
    struct list_head* phead = NULL;
    struct list_head* plist = NULL;
    void* phy_addr = NULL;
    u8 loop = 0;
    u8 cursor = 0;
    u32 spin_flag = 0;
    int ret = 0;

    struct sched_param param = { .sched_priority = 1 };
    param.sched_priority = 37;
    sched_setscheduler(current, SCHED_FIFO, &param);
    
    while(1) {
        down(&freepsb_que_sem);
        spin_lock_irqsave(&que->lock, spin_flag);
        if(que->qlen <= 0)
        {
            spin_unlock_irqrestore(&que->lock, spin_flag);
            continue;
        }
        spin_unlock_irqrestore(&que->lock, spin_flag);
        cursor = 0;
        memcpy(pkg.contents, B_TAG, TAG_SIZE);
        cursor += TAG_SIZE; 
        phead = &que->queue;
        for(loop = 0; loop < g_ddrnet_wrap_num/*WRAP_FREE_PACKET_THRESHHOLD*/; loop++)
        {
            spin_lock_irqsave(&que->lock, spin_flag);
            
            if(ddrnet_is_list_empty(phead))
            {
                spin_unlock_irqrestore(&que->lock, spin_flag);
                break;
            }
            //plist = get_next(phead);
            pkt = list_first_entry(phead, struct ddrnet_psbuf_packet, list);
            plist = &pkt->list;
            ddrnet_list_delete(plist);
            
            que->qlen--;
            spin_unlock_irqrestore(&que->lock, spin_flag);
            
            //pkt = LIST_CONTAINOR(plist, struct ddrnet_skb_packet, list);
            //phy_addr = (void *)virtaddr_to_phys(pkt->packet);
            memcpy(pkg.contents + cursor, &pkt->packet, PSB_DATA_PTR_LEN);
            cursor += PSB_DATA_PTR_LEN;

            spin_lock_irqsave(&que_free->lock, spin_flag);
            ddrnet_list_insert_tail(plist, &que_free->queue);
            que_free->qlen++;
            spin_unlock_irqrestore(&que_free->lock, spin_flag);                        
        }
        pkg.pkg_length = loop;
        memcpy(pkg.contents + cursor, E_TAG, TAG_SIZE);
        ret = ddrnet_freepsb_pkg_xmit(&pkg);
        if(ret > 0)
        {
            //g_ddrnet_tx_free++;
            spin_lock_irqsave(&g_psbuf_nr_lock, spin_flag);
            if(g_ddrnet_psbuf_nr < loop)
                printk("g_ddrnet_psbuf_nr state err.");
            g_ddrnet_psbuf_nr = g_ddrnet_psbuf_nr - loop;
            spin_unlock_irqrestore(&g_psbuf_nr_lock, spin_flag);
        }
        //printk("g_ddrnet_tx_free  %d\n", g_ddrnet_tx_free);
    }        
    
    return 0;
}

s32 ddrnet_skb_packet_enqueue(struct ddrnet* dev, struct T_ToExt_info* buf)
{
    struct ddrnet_queue* que = &dev->skb_que;
    struct ddrnet_queue* que_free = &dev->skb_que_free;
    struct list_head* phead = &que_free->queue;
    struct list_head* plist = NULL;
    u8 timer_flag = 0;
    struct ddrnet_skb_packet* skb_packet = NULL;

    struct T_ToExt_info* skb_info = buf;
    u32 spin_flag = 0;
    spin_lock_irqsave(&que_free->lock, spin_flag);
    if(que->qlen >= DDRNET_PACKET_QUEUE_COUNT || ddrnet_is_list_empty(&que_free->queue))
    {
        spin_unlock_irqrestore(&que_free->lock, spin_flag);
        return -1;
    }
    //plist = get_next(phead);
    skb_packet = list_first_entry(phead, struct ddrnet_skb_packet, list);
    plist = &skb_packet->list;
    ddrnet_list_delete(plist);
    que_free->qlen--;
    spin_unlock_irqrestore(&que_free->lock, spin_flag);
    
    memcpy(&skb_packet->packet, skb_info, sizeof(*skb_info));
    //printk("skb enqueue addr %#x:%#x, skb %#x\n", skb_packet->packet.skb_head, skb_packet->packet.skb_data, skb_packet->packet.skb);

    spin_lock_irqsave(&que->lock, spin_flag);    
    phead = &que->queue;
    ddrnet_list_insert_tail(plist, phead);
    que->qlen++;
    timer_flag = que->qlen%g_ddrnet_wrap_num;/*WRAP_PACKET_THRESHHOLD*/
    spin_unlock_irqrestore(&que->lock, spin_flag);
    
    if((PACKET_SIZE_LIMIT < skb_info->datalen) && !(skb_get_last_pkg(buf->skb)))
    {
        if(que->qlen >= g_ddrnet_wrap_num/*WRAP_PACKET_THRESHHOLD*/)
        {
            up(&dev->skb_que_sem);
        }
        else{
            if(timer_flag == 1)
                mod_timer(&dev->wrap_timer, jiffies + msecs_to_jiffies(g_ddrnet_time_interval)/*DDRNET_WRAP_TIMER_OUT_MS*/);
        }
    }
    else
    {
        up(&dev->skb_que_sem);
    }

    return sizeof(struct T_ToExt_info);
}
s32 ddrnet_freepsb_packet_enqueue(void *addr)
{
    
    struct list_head* phead = &free_psb_que_free.queue;
    struct list_head* plist = NULL;
    struct ddrnet_psbuf_packet* psb_packet = NULL;
    u32 spin_flag = 0;    
    u8 timer_flag = 0;
    spin_lock_irqsave(&free_psb_que_free.lock, spin_flag);

    if(free_psb_que.qlen >= DDRNET_PACKET_QUEUE_COUNT || ddrnet_is_list_empty(phead))
    {
        spin_unlock_irqrestore(&free_psb_que_free.lock, spin_flag);
        return -1;
    }
    //plist = get_next(phead);
    psb_packet = list_first_entry(phead, struct ddrnet_psbuf_packet, list);
    plist = &psb_packet->list;
    ddrnet_list_delete(plist);
    free_psb_que_free.qlen --;    
    spin_unlock_irqrestore(&free_psb_que_free.lock, spin_flag);
    
    spin_lock_irqsave(&free_psb_que.lock, spin_flag);    
    phead = &free_psb_que.queue;
    psb_packet->packet = (void *)(*(u32 *)(addr));
    ddrnet_list_insert_tail(plist, phead);    
    free_psb_que.qlen++;
    spin_unlock_irqrestore(&free_psb_que.lock, spin_flag);

    
    if(free_psb_que.qlen >= g_ddrnet_wrap_num/*WRAP_FREE_PACKET_THRESHHOLD*/)
    {
        up(&freepsb_que_sem);
    }
    else
    {
        timer_flag = free_psb_que.qlen%g_ddrnet_wrap_num;/*WRAP_FREE_PACKET_THRESHHOLD*/
        if(timer_flag == 1)
            mod_timer(&freepsb_wrap_timer, jiffies + msecs_to_jiffies(g_ddrnet_time_interval) /*WRAP_FREE_PACKET_THRESHHOLD*/);
    }

     return PSB_DATA_PTR_LEN;
}
#endif

