/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Interface header file for the audio driver
 *
 * Revision Information:
 *   File name: \dwddrvif\inc\aud_drv.h
 *   Version: \main\34
 *   Date: 2007-10-03 09:23:08
 *   Responsible: soerenek
 *   Comment:
 *     added HW available for I2S1
 */

#if !defined (_AUD_INTERFACES)
#define _AUD_INTERFACES

#if !defined (_WIN32) /* QQQQ Problem with including bastypes.h in the test suite - fix this later */
#include "bastypes.h"
//#include "scttypes.h" /* QQQQ For including SDL_Pid - scttypes.h ought to be included in the file that includes aud_drv.h */
#include "base_api.h"
#endif /* QQQQ */

/*changed by wangjun for NV change.[20090214]*/
#include "aud_nv.h"  //#include "eep.h"

/* Temporarily inserted to protect the old I2S interface until it is no longer used */
#define aud_old_I2S_interface

/******************************************************************************
*
*                            Feature defines
*
******************************************************************************/
#if defined(AUD_EXTERNAL_RINGER) && !defined(AUD_EXTERNAL_RINGER_MA2)
 #define AUD_EXTERNAL_RINGER_MA3
#endif

/******************************************************************************
*
*                             Type defines
*
******************************************************************************/
/* QQQQ UINT8, UINT16, UINT32, SINT8, SINT16, and SINT32 should not be used  *
 *      - remove the defines when they are not used any longer               */
 #if 0       //huojishan 200801.01
#if !defined (UNITEST) /* UINT8 and UINT16 are already defined in Microsoft Visual Studio which is used for Unitest UMAC test environment build */
 #if !defined (UINT8)
  typedef unsigned char  UINT8;
 #endif

 #if !defined (UINT16)
  typedef unsigned short UINT16;
 #endif
#endif /* UNITEST */

#if !defined (UINT32)
 #if defined (_WIN32)
  typedef unsigned int   UINT32;
 #else
  typedef unsigned long  UINT32;
 #endif
#endif /* UINT32 */

#if !defined (SINT8)
 typedef signed char     SINT8;
#endif

#if !defined (SINT16)
 typedef signed short    SINT16;
#endif

#if !defined (SINT32)
 #if !defined (_WIN32)
  typedef signed long    SINT32;
 #else
  typedef signed int     SINT32;
 #endif
#endif /* SINT32 */

#if defined (_WIN32) /* QQQQ Problem with including bastypes.h in the test suite - fix this later */
 #if !defined (U8)
  typedef unsigned char  U8;
 #endif
 #if !defined (U16)
  typedef unsigned short U16;
 #endif
 #if !defined (U32)
  typedef unsigned int   U32;
 #endif
 #if !defined (S8)
  typedef signed char    S8;
 #endif
 #if !defined (S16)
  typedef signed short   S16;
 #endif
 #if !defined (S32)
  typedef signed int     S32;
 #endif
#endif /* QQQQ _WIN32 */
#endif

/* Defines/includes for PC/target builds */
#if defined (_WIN32)
#define SDL_Pid U8
#define SDL_boolean BOOL
#endif /* _WIN32 */

#define DWD_HUGE 
#define DWD_AUDIO_FAR

/* Return codes */
#define  aud_rc_ok                      0
#define  aud_rc_resource_in_use        -1
#define  aud_rc_resource_conflict      -2
#define  aud_rc_handle_not_used        -3
#define  aud_rc_no_hw_support          -4
#define  aud_rc_sharing_violation      -5 
#define  aud_rc_parameter_out_of_range -6 
#define  aud_rc_audio_driver_disabled  -7
#define  aud_rc_missing_dsp_resources  -8
#define  aud_rc_format_not_supported   -10
#define  aud_rc_no_playback            -11
#define  aud_rc_unknown_position       -12
#define  aud_rc_request_error          -13
#define  aud_rc_syntax_error           -14
#define  aud_rc_tone_error             -15
#define  aud_rc_storage_problems       -16
#define  aud_rc_performance_problems   -17
#define  aud_rc_ram_buffer_used        -18
#define  aud_rc_suspend_resume_error   -19
#define  aud_rc_info                   -20
#define  aud_rc_playback_finish        -21
#define  aud_rc_playback_started       -22
#define  aud_rc_playback_stopped       -23
#define  aud_rc_playback_suspended     -24
#define  aud_rc_playback_loop          -25
#define  aud_rc_recording_finish       -26
#define  aud_rc_recording_started      -27
#define  aud_rc_user_event             -28
#define  aud_rc_elapsed_time           -29
#define  aud_rc_total_playtime         -30
#define  aud_rc_not_supported          -31
#define  aud_rc_mapi                   -32
#define  aud_rc_current_frame          -33
#define  aud_rc_backwardforward_info   -34
#define  aud_rc_path_removal_success   -35
#define  aud_rc_path_addition_success  -36
#define  aud_rc_path_addition_conflict -37
#define  aud_rc_path_removal_error     -38
#define  aud_rc_user_message           -39
#define  aud_rc_encoding_started       -40
#define  aud_rc_encoding_stopped       -41
#define  aud_rc_encoder_suspended      -42
#define  aud_rc_I2S_started            -43
#define  aud_rc_I2S_stopped            -44
#define  aud_rc_I2S_setup_error        -45
#define  aud_rc_path_in_use            -46
/* !!! Please inform the MobileAnalyzer decoding maintainer (HHE) when adding new return codes */

/* Used for defining which HW is present in the system in question - must be updated when aud_resource_enum is updated */
#define  AUD_HW_AVAILABLE_SPEECH              0x00000001  
#define  AUD_HW_AVAILABLE_TONE_GENERATOR      0x00000002
#define  AUD_HW_AVAILABLE_RINGER              0x00000004
#define  AUD_HW_AVAILABLE_EXTERNAL_VIBRATOR   0x00000008
#define  AUD_HW_AVAILABLE_EXTERNAL_AMPLIFIER  0x00000010
#define  AUD_HW_AVAILABLE_FM_RADIO            0x00000020
#define  AUD_HW_AVAILABLE_RECORDING_VM        0x00000040
#define  AUD_HW_AVAILABLE_PLAYBACK_VM         0x00000080
#define  AUD_HW_AVAILABLE_PLAYBACK_MP3        0x00000100
#define  AUD_HW_AVAILABLE_I2S_PCM             0x00000200
#define  AUD_HW_AVAILABLE_INTERNAL_MIDI       0x00000400
#define  AUD_HW_AVAILABLE_TTY                 0x00000800
#define  AUD_HW_AVAILABLE_PLAYBACK_PCM        0x00001000
#define  AUD_HW_AVAILABLE_RECORD_PCM          0x00002000
#define  AUD_HW_AVAILABLE_MAPI                0x00004000
#define  AUD_HW_AVAILABLE_INBAND              0x00008000
#define  AUD_HW_ABAILABLE_SMPOWER_BACKSPEAKER 0x00010000
#define  AUD_HW_AVAILABLE_SBC_ENCODER         0x00020000
#define  AUD_HW_AVAILABLE_I2S2_RX             0x00040000
#define  AUD_HW_AVAILABLE_I2S2_TX             0x00080000

#define  AUD_HW_AVAILABLE_I2S1_RX            			0x00000000
#define  AUD_HW_AVAILABLE_I2S1_TX            			0x00000000
#define  AUD_HW_AVAILABLE_I2S1_BLUETOOTH            0x00400000
/* Test handles - update this list when the list above is updated */
#define  AUD_TEST_HANDLE                        0xFF
#define  AUD_SPEECH_TEST_HANDLE                 0xFE
#define  AUD_TONE_GENERATOR_TEST_HANDLE         0xFD
#define  AUD_AMPLIFIER_TEST_HANDLE              0xFC
#define  AUD_RINGER_TEST_HANDLE                 0xFB
#define  AUD_FM_RADIO_TEST_HANDLE               0xFA
#define  AUD_RECORDING_VM_TEST_HANDLE           0xF9
#define  AUD_PLAYBACK_VM_TEST_HANDLE            0xF8
#define  AUD_PLAYBACK_MP3_TEST_HANDLE           0xF7
#define  AUD_TTY_TEST_HANDLE                    0xF6
#define  AUD_VIBRATOR_TEST_HANDLE               0xF5
#define  AUD_MIDI_PLAYER_TEST_HANDLE            0xF4
#define  AUD_PCM_CHANNEL_TEST_HANDLE            0xF3
#define  AUD_PLAYBACK_PCM_TEST_HANDLE           0xF2
#define  AUD_RECORD_PCM_TEST_HANDLE             0xF1
#define  AUD_MAPI_TEST_HANDLE                   0xF0
#define  AUD_INBAND_TEST_HANDLE                 0xEF
#define  AUD_SMPOWER_BACKSPEAKER_TEST_HANDLE    0xEE
#define  AUD_SBC_ENCODER_TEST_HANDLE            0xED
#define  AUD_I2S2_RX_TEST_HANDLE                0xEC
#define  AUD_I2S2_TX_TEST_HANDLE                0xEB

/* For compatility reasons with atcptst */
#define AUD_MIC             1
#define AUD_EARPIECE        2

/******************************************************************************
*
*                     External enumerations and structures
*
******************************************************************************/

/* Resources */
typedef enum {
    aud_resource_speech, /* 0 */
    aud_resource_tone_generator,
    aud_resource_ringer,         /* This Does NOT include the vibrator */
    aud_resource_vibrator,
    aud_resource_amplifier,      /* External amplifier for speaker phone */
    aud_resource_radio, /* 5 */
    aud_resource_record_vm,
    aud_resource_playback_vm,
    aud_resource_playback_mp3,
    aud_resource_PCM_channel, /* Replaced by I2S2_Rx and I2S2_Tx (05-12-2006) */
    aud_resource_midi_player, /* 10 */
    aud_resource_tty,
    aud_resource_playback_pcm,
    aud_resource_record_pcm,
    aud_resource_mapi,
    aud_resource_inband, /* 15 */ /* Virtual resource used to indicate whether non-baseband audio is active. */
    aud_resource_smpower_backspeaker, /* SM power only if other devices input audio through SP power gain. */
    aud_resource_sbc_encoder, /*SBC Encoder */
    aud_resource_I2S2_Rx,
    aud_resource_I2S2_Tx,
    aud_resource_end
} aud_resource_enum; /* When adding more resources, also add them to the defines at the top of this file, and notify PhoneTool group */

/* Priorities for resource allocation */
typedef enum {
    aud_priority_normal,
    aud_priority_high,
    aud_priority_end
} aud_priority_enum;

/* Mute-related enumerations */
typedef enum {
    aud_mute_enable,
    aud_mute_disable,
    aud_mute_end
} aud_mute_enum;

typedef enum {
    aud_mute_left_channel_dac,
    aud_mute_right_channel_dac,
    aud_mute_dac_end
} aud_mute_dac_enum;

typedef enum {
    aud_direction_uplink, /* 0 */
    aud_direction_downlink,
    aud_direction_updownlink,
    aud_direction_downlink_left,
    aud_direction_downlink_right,
    aud_direction_uplink_speech, /* 5 */
    aud_direction_downlink_speech,
    aud_direction_updownlink_speech,
    aud_direction_end
} aud_direction_enum;

typedef enum {
    aud_direction_resource_uplink,
    aud_direction_resource_downlink,
    aud_direction_resource_updownlink,
    aud_direction_resource_end
} aud_ul_dl_direction_enum;

/* Path-related enumerations */
typedef enum {
    aud_disable_path,
    aud_enable_path,
    aud_audio_path_end
} aud_audio_path_enum;

typedef enum {
    aud_handset_mic, /* 0 */
    aud_headset_mic,
    aud_I2S1_rx,  /*Now used for any kind of bluetooth device connection*/
    aud_tty_uplink,
    aud_hfcarkit_mic,
    aud_I2S1_inband_rx, /* 5 */
    aud_handset_mic_42dB,
    aud_handset_dthf_uplink,
    aud_mic_mute,
    aud_handset_mic_slidedown,
    aud_handset_mic_loopback, /* 10 */
    aud_I2S1_rx_loopback,
    aud_media_to_uplink,
    aud_media_to_uplink_hifi,
    aud_stereo_mic,
    aud_scheduler_8kHz, /* 15 */
    aud_scheduler_16kHz,
    aud_scheduler_48kHz,
    aud_external_stereo_input,
    aud_headset_mic_42dB,
    aud_uplink_source_end
} aud_uplink_source_enum; /* When adding more paths, remember to notify the PhoneTool group */

typedef enum {
    aud_normal_earpiece, /* 0 */
    aud_mono_headset,
    aud_stereo_headset,
    aud_backspeaker,
    aud_I2S1_tx,
    aud_tty_downlink, /* 5 */
    aud_mono_headset_external_ringer,
    aud_stereo_headset_external_ringer,
    aud_backspeaker_path_downlink,
    aud_earpiece_path_downlink,
    aud_backspeaker_external_ringer, /* 10 */
    aud_hfcarkit_speaker,
    aud_I2S1_inband_tx, /*Special path used for routing inband audio (like ringtones) to the bt headset*/
    aud_backspeaker_stereo,
    aud_fmradio_backspeaker,
    aud_fmradio_headset, /* 15 */
    aud_companion_mono_headset,
    aud_companion_stereo_headset,
    aud_companion_mono_backspeaker,
    aud_companion_stereo_backspeaker,
    aud_smpower_backspeaker, /* 20 */ /*Special path to backspeaker for non baseband audio*/
    aud_normal_earpiece_loopback,
    aud_I2S1_tx_loopback,
    aud_media_to_downlink_mute,
    aud_sidetone_loopback,
    aud_I2S2_external, /* 25 */
    aud_tmp_downlink_path, /* To be replaced when a new path is added. Preserved for PhoneTool compatibility. */
    aud_downlink_source_end
} aud_downlink_source_enum; /* When adding more paths, remember to notify the PhoneTool group */

/* Enable/disable enumerations */
typedef enum {
    aud_enable,
    aud_disable,
    aud_enable_disable_end
} aud_enable_disable_enum;

/* Volume enumerations */
typedef enum {
    aud_ringer_volume_off,
    aud_ringer_volume_1,
    aud_ringer_volume_2,
    aud_ringer_volume_3,
    aud_ringer_volume_4,
    aud_ringer_volume_5,
    aud_ringer_volume_in_call,
    aud_ringer_volume_init,    /* Only for internal use in audio driver */
    aud_ringer_volume_end
} aud_ringer_volume_enum;

typedef enum {
    aud_speech_volume_1,
    aud_speech_volume_2,
    aud_speech_volume_3,
    aud_speech_volume_4,
    aud_speech_volume_5,
    aud_speech_volume_6,
    aud_speech_volume_7,
    aud_speech_volume_8,
    aud_speech_volume_9,
    aud_speech_volume_10,
    aud_speech_volume_special,    /* For test purpose only */
    aud_speech_volume_end
} aud_speech_volume_enum;

typedef enum {
    aud_volume_0=0,
    aud_volume_1=1,
    aud_volume_2,
    aud_volume_3,
    aud_volume_4,
    aud_volume_5,
    aud_volume_6,
    aud_volume_7,
    aud_volume_8,
    aud_volume_9,
    aud_volume_10,
    aud_volume_11,
    aud_volume_12,
    aud_volume_13,
    aud_volume_14,
    aud_volume_15,
    aud_volume_16,
    aud_volume_17,
    aud_volume_18,
    aud_volume_19,
    aud_volume_20,
    aud_volume_21,
    aud_volume_22,
    aud_volume_23,
    aud_volume_24,
    aud_volume_25,
    aud_volume_26,
    aud_volume_27,
    aud_volume_28,
    aud_volume_29,
    aud_volume_30,
    aud_volume_31,
    aud_volume_32,
    aud_volume_33,
    aud_volume_34,
    aud_volume_35,
    aud_volume_36,
    aud_volume_37,
    aud_volume_38,
    aud_volume_39,
    aud_volume_40,
    aud_volume_41,
    aud_volume_42,
    aud_volume_43,
    aud_volume_44,
    aud_volume_45,
    aud_volume_46,
    aud_volume_47,
    aud_volume_48,
    aud_volume_49,
    aud_volume_50,
    aud_volume_51,
    aud_volume_52,
    aud_volume_53,
    aud_volume_54,
    aud_volume_55,
    aud_volume_56,
    aud_volume_57,
    aud_volume_58,
    aud_volume_59,
    aud_volume_60,
    aud_volume_61,
    aud_volume_62,
    aud_volume_63,
    aud_volume_64,
    aud_volume_65,
    aud_volume_66,
    aud_volume_67,
    aud_volume_68,
    aud_volume_69,
    aud_volume_70,
    aud_volume_71,
    aud_volume_72,
    aud_volume_73,
    aud_volume_74,
    aud_volume_75,
    aud_volume_76,
    aud_volume_77,
    aud_volume_78,
    aud_volume_79,
    aud_volume_80,
    aud_volume_81,
    aud_volume_82,
    aud_volume_83,
    aud_volume_84,
    aud_volume_85,
    aud_volume_86,
    aud_volume_87,
    aud_volume_88,
    aud_volume_89,
    aud_volume_90,
    aud_volume_91,
    aud_volume_92,
    aud_volume_93,
    aud_volume_94,
    aud_volume_95,
    aud_volume_96,
    aud_volume_97,
    aud_volume_98,
    aud_volume_99,
    aud_volume_100,
    aud_volume_special,    /* For test purpose only */
    aud_volume_end
} aud_volume_enum;

/* Tone enumerations */
typedef enum {
    aud_tone_DTMF_0, /* 0 */
    aud_tone_DTMF_1,
    aud_tone_DTMF_2,
    aud_tone_DTMF_3,
    aud_tone_DTMF_4,
    aud_tone_DTMF_5, /* 5 */
    aud_tone_DTMF_6,
    aud_tone_DTMF_7,
    aud_tone_DTMF_8,
    aud_tone_DTMF_9,
    aud_tone_DTMF_hash, /* 10 */
    aud_tone_DTMF_asterix,
    aud_tone_key_tone_1,  // Not in use.
    aud_tone_key_tone_2,  // Not in use.
    aud_tone_key_tone_3,  // Not in use.
    aud_tone_key_tone_4,  /* 15 */ /* Not in use. */
    aud_tone_key_tone_5,  // Not in use.
    aud_tone_sv_subscriber_busy,
    aud_tone_sv_congestion,
    aud_tone_sv_radio_path_ack,
    aud_tone_sv_radio_path_not_avail, /* 20 */
    aud_tone_sv_error_info,
    aud_tone_sv_call_waiting,
    aud_tone_info_free_tone,
    aud_tone_info_connection,
    aud_tone_info_disconnect, /* 25 */
    aud_tone_info_device_in,
    aud_tone_info_device_out,
    aud_tone_info_msg_full,
    aud_tone_info_ussd,
    aud_tone_info_minutte_minder, /* 30 */
    aud_tone_info_error_1,
    aud_tone_info_error_2,
    aud_tone_info_sms_in_call,
    aud_tone_info_broadcast_in_call,
    aud_tone_info_alarm_in_call, /* 35 */
    aud_tone_info_low_bat_in_call,
    aud_tone_info_power_off,  
    aud_tone_info_power_on,   
    aud_tone_info_single_beep,
    aud_tone_info_positive_acknowledgement, /* 40 */
    aud_tone_info_negative_acknowledgement,
    aud_tone_info_auto_redial,
    aud_tone_info_network_attention,
    aud_tone_info_dial_tone,
    aud_tone_info_low_bat, /* 45 */
    aud_tone_id_end
} aud_tone_id_enum;

typedef enum {
    aud_single_user_tone,
    aud_dual_user_tone,
    aud_triple_user_tone,
    aud_tone_type_end
} aud_tone_type_enum;

/* Tone generator structures */
typedef struct {
    U16 freq1;
    S16 amp1;
    U16 duration;
} aud_single_user_tone_type;

typedef struct {
    U16 freq1;
    S16 amp1;
    U16 freq2;
    S16 amp2;
    U16 duration;
} aud_dual_user_tone_type;

typedef struct {
    U16 freq1;
    S16 amp1;
    U16 freq2;
    S16 amp2;
    U16 freq3;
    S16 amp3;
    U16 duration;
} aud_triple_user_tone_type;

/* Ringer enumerations */
typedef enum {
    aud_ringer_info_power_off, /* 0 */
    aud_ringer_info_power_on,
    aud_ringer_info_low_bat,
    aud_ringer_info_connection,
    aud_ringer_info_error_1,
    aud_ringer_info_error_2, /* 5 */
    aud_ringer_info_device_in,
    aud_ringer_info_device_out,
    aud_ringer_info_msg_full,
    aud_ringer_message_1,
    aud_ringer_message_2, /* 10 */
    aud_ringer_message_3,
    aud_ringer_message_4,
    aud_ringer_message_5,
    aud_ringer_message_6,
    aud_ringer_message_7, /* 15 */
    aud_ringer_message_8,
    aud_ringer_message_9,
    aud_ringer_message_10,
    aud_ringer_broadcast_1,
    aud_ringer_broadcast_2, /* 20 */
    aud_ringer_broadcast_3,
    aud_ringer_broadcast_4,
    aud_ringer_broadcast_5,
    aud_ringer_broadcast_6,
    aud_ringer_broadcast_7, /* 25 */
    aud_ringer_broadcast_8,
    aud_ringer_broadcast_9,
    aud_ringer_broadcast_10,
    aud_ringer_alarm_1,
    aud_ringer_alarm_2, /* 30 */
    aud_ringer_alarm_3,
    aud_ringer_alarm_4,
    aud_ringer_alarm_5,
    aud_ringer_alarm_6,
    aud_ringer_alarm_7, /* 35 */
    aud_ringer_alarm_8,
    aud_ringer_alarm_9,
    aud_ringer_alarm_10,
    aud_ringer_1,
    aud_ringer_2, /* 40 */
    aud_ringer_3,
    aud_ringer_4,
    aud_ringer_5,
    aud_ringer_6,
    aud_ringer_7, /* 45 */
    aud_ringer_8,
    aud_ringer_9,
    aud_ringer_10,
    aud_ringer_11,
    aud_ringer_12, /* 50 */
    aud_ringer_13,
    aud_ringer_14,
    aud_ringer_15,
    aud_ringer_16,
    aud_ringer_17, /* 55 */
    aud_ringer_18,
    aud_ringer_19,
    aud_ringer_20,
    aud_ringer_21,
    aud_ringer_22, /* 60 */
    aud_ringer_23,
    aud_ringer_24,
    aud_ringer_25,
    aud_ringer_26,
    aud_ringer_27, /* 65 */
    aud_ringer_28,
    aud_ringer_29,
    aud_ringer_30,
    aud_ringer_31,
    aud_ringer_32, /* 70 */
    aud_ringer_33,
    aud_ringer_34,
    aud_ringer_35,
    aud_ringer_36,
    aud_ringer_37, /* 75 */
    aud_ringer_38,
    aud_ringer_39,
    aud_ringer_40,
    aud_ringer_41,
    aud_ringer_42, /* 80 */
    aud_ringer_43,
    aud_ringer_44,
    aud_ringer_45,
    aud_ringer_46,
    aud_ringer_47, /* 85 */
    aud_ringer_48,
    aud_ringer_49,
    aud_ringer_50,
    aud_ringer_game_1,
    aud_ringer_game_2, /* 90 */
    aud_ringer_game_3,
    aud_ringer_game_4,
    aud_ringer_game_5,
    aud_ringer_game_6,
    aud_ringer_game_7, /* 95 */
    aud_ringer_game_8,
    aud_ringer_game_9,
    aud_ringer_game_10,
    aud_ringer_camera_1,
    aud_ringer_prod_test_1, /* 100 */
    aud_ringer_prod_test_2,
    aud_ringer_prod_test_3,
    aud_ringer_prod_test_4,
    ringer_test_01,
    ringer_test_02, /* 105 */
    ringer_test_03,
    ringer_test_04,
    ringer_test_05,
    ringer_test_06,
    ringer_test_07, /* 110 */
    ringer_test_08,
    ringer_test_09,
    ringer_test_10,
    ringer_test_11,
    ringer_test_12, /* 115 */
    ringer_test_13,
    ringer_test_14,
    ringer_test_15,
    ringer_test_16,
    ringer_test_17, /* 120 */
    ringer_test_18,
    ringer_test_19,
    ringer_test_20,
    ringer_test_21,
    ringer_test_22, /* 125 */
    ringer_test_23,
    ringer_test_24,
    ringer_test_25,
    ringer_test_26,
    ringer_test_rambuff,
    
    aud_ringer_tone_id_end
} aud_ringer_tone_id_enum;

typedef enum {
    aud_ringer_device_sound,
    aud_ringer_device_vibrator,           /* Not used anymore (the functions for starting/stopping vibrator should be used) */
    aud_ringer_device_sound_and_vibrator, /* Not used anymore (the functions for starting/stopping vibrator should be used) */
    aud_ringer_device_end
} aud_ringer_device_enum;

typedef enum {
    aud_format_smaf,            /* MA2/MA3 NB: SMAF is not just SMAF. With the MA3 came extentions 
                                   to the SMAF, which cannot be played on a MA2 */
    aud_format_midi,            /* MA2/MA3 NB: Be aware that MIDI is many different formats, 
                                   only following formats are supported: SP-MIDI, SMF format 0 and 1 */
    aud_format_smaf_phrase_l1,  /* MA3/MA2 */
    aud_format_rmd,             /* MA3 */
    aud_format_imelody,         /* MA2/MA3 */
    aud_format_buzzer,          /* Buzzer */
    aud_format_wav,             /* wav */
    aud_format_mp3,             /* mp3 */
    aud_format_smafaudio,       /* pcm data in smaf header container*/
    aud_format_end
} aud_format_enum;

/* Vibrator enumerations */
typedef enum {
    Aud_vibrator_mode_async_1,
    Aud_vibrator_mode_async_2,
    Aud_vibrator_mode_sync_1,
    Aud_vibrator_mode_sync_2,
    aud_vibmode_end
} aud_vibrator_mode_enum;

typedef enum {
    aud_vibrator_on, /* 0 */
    aud_vibrator_async_blinking1,
    aud_vibrator_async_blinking2,
    aud_vibrator_async_blinking3,
    aud_vibrator_async_blinking4,
    aud_vibrator_async_blinking5, /* 5 */
    aud_vibrator_async_blinking6,
    aud_vibrator_async_blinking7,
    aud_vibrator_async_blinking8,
    aud_vibrator_async_blinking9,
    aud_vibrator_async_blinking10, /* 10 */
    aud_vibrator_async_blinking11,
    aud_vibrator_async_blinking12,
    aud_vibrator_async_blinking13,
    aud_vibrator_async_blinking14,
    aud_vibrator_async_blinking15, /* 15 */
    aud_vibrator_async_blinking16,
    aud_vibrator_sync1, 
    aud_vibrator_sync2,
    aud_vibrator_sync3,
    aud_vibrator_sync4, /* 20 */
    aud_vib_mode_end
} aud_vib_mode;

typedef enum {
    Aud_vibrator_on_200ms,
    Aud_vibrator_on_300ms,
    Aud_vibrator_on_400ms,
    Aud_vibrator_on_600ms,
    Aud_vibrator_on_800ms,
    Aud_vibrator_on_1000ms,
    Aud_vibrator_on,
    Aud_vibrator_on_end
} aud_vibrator_on_enum;

typedef enum {
    Aud_vibrator_off_200ms,
    Aud_vibrator_off_300ms,
    Aud_vibrator_off_400ms,
    Aud_vibrator_off_600ms,
    Aud_vibrator_off,
    Aud_vibrator_off_end
} aud_vibrator_off_enum;

/* FM radio enumerations */
typedef enum {
    aud_fm_radio_rssi_0,
    aud_fm_radio_rssi_1,
    aud_fm_radio_rssi_2,
    aud_fm_radio_rssi_3,
    aud_fm_radio_rssi_4,
    aud_fm_radio_rssi_5,
    aud_fm_radio_rssi_6,
    aud_fm_radio_rssi_7,
    aud_fm_radio_rssi_8,
    aud_fm_radio_rssi_9,
    aud_fm_radio_rssi_enum_end
} aud_fm_radio_rssi_enum;

typedef enum {
    aud_fm_radio_seek_off,  /* Station preset */
    aud_fm_radio_seek_up,   /* Auto seek up */
    aud_fm_radio_seek_down, /* Auto seek down */
    aud_fm_radio_seek_enum_end
} aud_fm_radio_seek_mode_enum;

typedef enum {
    aud_fm_radio_rssi_info, /* SDL message contains RSSI level */
    aud_fm_radio_seek_info, /* SDL message contains station seek result */
    aud_fm_radio_rds_info,  /* SDL message contains RDS data - only used for module testing */
    aud_fm_radio_freq_info, /* SDL message contains frequency returned during seeking */
    aud_fm_radio_sdl_opcodes_end
} aud_fm_radio_sdl_opcodes_enum;

/* Voice memo enumerations */
typedef enum {
    aud_vm_mode_standby,
    aud_vm_mode_tch,
    aud_vm_mode_end
} aud_vm_mode_enum;

typedef enum {
    aud_dsp_format_fr,
    aud_dsp_format_amr,
    aud_dsp_format_pcm,
    aud_dsp_format_amr_if2,
    aud_dsp_format_end
} aud_dsp_format_enum;

typedef enum {
    aud_media_ffs,
    aud_media_mmc,
    aud_media_ram,
    aud_media_test_ram,
    aud_media_I2S,
    aud_media_mmf,        /* Support for Multimedia framework */
    aud_media_mmf_test,   /* Support for Multimedia framework */
    aud_media_vr,
    aud_media_fs_cdrive,  /*FS_FTL_DEVICE1 RW mode*/
    aud_media_fs_edrive, /*FS_FTL_DEVICE2, RO only */
    aud_media_fs_fdrive,  /*FS_FTL_DEVICE1 RW mode*/
    aud_media_end
} aud_media_enum;

typedef enum {
    aud_amr_475, /* 0 */
    aud_amr_515,
    aud_amr_590,
    aud_amr_670,
    aud_amr_740,
    aud_amr_795, /* 5 */
    aud_amr_102,
    aud_amr_122,
    aud_amr_end
} aud_amr_bitrate;


/* PCM player/recorder enumerations */
typedef enum {
    aud_pcm_mode_mono,
    aud_pcm_mode_dual_mono,
    aud_pcm_mode_stereo,
    aud_pcm_mode_end
} aud_pcm_mode_enum;

typedef enum {
    aud_pcm_rate_1,
    aud_pcm_rate_2,
    aud_pcm_rate_3,
    aud_pcm_rate_4,
    aud_pcm_rate_5,
    aud_pcm_rate_6,
    aud_pcm_rate_7,
    aud_pcm_rate_8,
    aud_pcm_rate_9,
    aud_pcm_rate_end
} aud_pcm_sample_rate_enum;

typedef enum {
    aud_pcm_format_pcm,
    aud_pcm_format_adpcm,
    aud_pcm_format_wave,
    aud_pcm_format_end
} aud_pcm_format_enum;

/* Yamaha Music API (mapi) enumerations */
typedef enum {
    aud_mapi_getmode, /* 0 */
    aud_mapi_setmode,
    aud_mapi_resetmode,
    aud_mapi_initialize,
    aud_mapi_terminate,
    aud_mapi_checkload, /* 5 */
    aud_mapi_checkunload,
    aud_mapi_getcontentsdata,
    aud_mapi_getphraselist,
    aud_mapi_realtime_midiopen,
    aud_mapi_realtime_midisendchmessage, /* 10 */
    aud_mapi_realtime_starttimer,
    aud_mapi_realtime_stoptimer,
    aud_mapi_realtime_midiclose,
    aud_mapi_realtime_midisendsysexmessage,
    aud_mapi_realtime_midisetapivolume, /* 15 */
    aud_mapi_realtime_midigetchvolume,
    aud_mapi_phrase_audioload,
    aud_mapi_phrase_audioopen,
    aud_mapi_phrase_audiostandby,
    aud_mapi_phrase_audiocontrol, /* 20 */
    aud_mapi_phrase_audiostart,
    aud_mapi_phrase_audiostop,
    aud_mapi_phrase_audioclose,
    aud_mapi_phrase_audiounload,
    aud_mapi_phrase_getposition, /* 25 */
    aud_mapi_phrase_setevhandler,
    aud_mapi_phrase_getlink,
    aud_mapi_phrase_setlink,
    aud_mapi_phrase_kill,
    aud_mapi_phrase_setdata, /* 30 */
    aud_mapi_phrase_seek,
    aud_mapi_phrase_getlength,
    aud_mapi_phrase_setvolume,
    aud_mapi_phrase_setpanpot,
    aud_mapi_phrase_play, /* 35 */
    aud_mapi_phrase_stop,
    aud_mapi_phrase_removedata,
    aud_mapi_phrase_getstatus,
    aud_mapi_phrase_pause,
    aud_mapi_phrase_restart, /* 40 */
    aud_mapi_melody_control,
    aud_mapi_melody_openarginit,
    aud_mapi_melody_open,
    aud_mapi_melody_standby,
    aud_mapi_melody_waitready, /* 45 */
    aud_mapi_melody_start,
    aud_mapi_melody_stop,
    aud_mapi_melody_seek,
    aud_mapi_melody_close,
    aud_mapi_melody_load, /* 50 */
    aud_mapi_melody_unload,
    aud_mapi_devicecontrol,
    aud_mapi_melody_end
} aud_mapi_if_enum;

/* SBC Encoder enumerations */
typedef enum {
    aud_sbc_mono,
    aud_sbc_dual_channel,
    aud_sbc_stereo,
    aud_sbc_joint_stereo,
    aud_sbc_channel_mode_end
} aud_sbc_encoder_channel_mode_enum;

typedef enum {
    aud_sbc_sample_rate_16_khz,
    aud_sbc_sample_rate_32_khz,  
    aud_sbc_sample_rate_44_1_khz,
    aud_sbc_sample_rate_48_khz,
    aud_sbc_sample_rate_end
} aud_sbc_encoder_sample_rate_enum;

typedef enum {
    aud_sbc_number_of_blocks_4,
    aud_sbc_number_of_blocks_8,
    aud_sbc_number_of_blocks_12,
    aud_sbc_number_of_blocks_16,
    aud_sbc_number_of_blocks_end
} aud_sbc_encoder_number_of_blocks_enum;

typedef enum {
    aud_sbc_internal_data_encoding_mode,
    aud_sbc_external_data_encoding_mode,
    aud_sbc_data_mode_end
} aud_sbc_encoder_data_mode_enum;

/* I2S enumerations */
typedef enum {
    aud_dai_mode_normal,
    aud_dai_mode_codec_test,
    aud_dai_mode_acoustic_test,
    aud_dai_mode_loopback,
    aud_dai_mode_end
} aud_dai_mode_enum;

#if defined (aud_old_I2S_interface)
typedef enum {
    aud_I2Sx_mode1,   /* Mode 1: 16 bit 8 kHz Master, Burst Mode, Mono */
    aud_I2Sx_mode2,   /* Mode 2: 16 bit 8 kHz Slave, Burst Mode, Mono */
    aud_I2Sx_mode3,   /* Mode 3: 16 bit 8 kHz Master, Normal Mode, Mono */
    aud_I2Sx_mode4,   /* Mode 4: 16 bit 8 kHz Slave, Normal Mode, Mono */
    aud_I2Sx_mode5,   /* Mode 5: 16 bit 16 kHz Master, Normal Mode, Mono */
    aud_I2Sx_mode6,   /* Mode 6: 16 bit 16 kHz Slave, Normal Mode, Mono */
    aud_I2Sx_mode7,   /* Mode 7: 16 bit 32 kHz Master, Normal Mode, Mono */
    aud_I2Sx_mode8,   /* Mode 8: 16 bit 32 kHz Master, Normal Mode, Stereo */
    aud_I2Sx_mode9,   /* Mode 9: 16 bit 32 kHz Slave, Normal Mode, Mono*/ 
    aud_I2Sx_mode10,   /* Mode 10: 16 bit 44.1 kHz Master, Normal Mode, Mono */
    aud_I2Sx_mode11,   /* Mode 11: 16 bit 44.1 kHz Master, Normal Mode, Stereo */
    aud_I2Sx_mode12,  /* Mode 12: 16 bit 44.1 kHz Slave, Normal Mode, Mono */
    aud_I2Sx_mode13,  /* Mode 13: 16 bit 48 kHz Master, Normal Mode, Mono */
    aud_I2Sx_mode14,  /* Mode 14: 16 bit 48 kHz Master, Normal Mode, Stereo */
    aud_I2Sx_mode15,  /* Mode 15: 16 bit 48 kHz Slave, Normal Mode, Mono */
    aud_I2S2_mode_dai, /* set up the I2S2 to dai mode*/   
    aud_I2Sx_mode16,  /* Mode 16: 16bit 8 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode17,  /* Mode 17: 16bit 11.025 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode18,  /* Mode 18: 16bit 12 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode19,  /* Mode 19: 16bit 16 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode20,  /* Mode 20: 16bit 22.05 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode21,  /* Mode 21: 16bit 24 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode22,  /* Mode 22: 16bit 32 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode23,  /* Mode 23: 16bit 44.1 kHz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode24,  /* Mode 24: 16bit 48k Hz, Slave, Normal mode, Stereo*/
    aud_I2Sx_mode25,  /* Mode 25: 16bit 8kHz, Master, Normal mode, DualMono*/
    aud_I2Sx_mode_end
} aud_I2Sx_mode_enum;
#endif /* aud_old_I2S_interface */

typedef enum {
    aud_I2S2_clk0,
    aud_I2S2_clk1,
    aud_I2S_clk_end
} aud_I2S_clk_enum;

typedef enum { /* Changes in this enum will change the validation matrix */
    aud_I2S_master,
    aud_I2S_slave,
    aud_I2S_Master_Slave_end
} aud_I2S_Master_Slave_enum;

typedef enum { /* Changes in this enum will change the validation matrix */
    aud_I2S_samplerate_08000,
    aud_I2S_samplerate_11025,
    aud_I2S_samplerate_12000,
    aud_I2S_samplerate_16000,
    aud_I2S_samplerate_22050,
    aud_I2S_samplerate_24000,
    aud_I2S_samplerate_32000,
    aud_I2S_samplerate_44100,
    aud_I2S_samplerate_48000,
    aud_I2S_samplerate_end
} aud_I2S_samplerate_enum;

typedef enum {
    aud_I2S_sample_width_16,
    aud_I2S_sample_width_18,
    aud_I2S_sample_width_20,
    aud_I2S_sample_width_24,
    aud_I2S_sample_width_32,
    aud_I2S_sample_width_end
} aud_I2S_sample_width_enum;

typedef enum { /* Changes in this enum will change the validation matrix */
    aud_I2S_transmission_mode_PCM,
    aud_I2S_transmission_mode_normal, /* Normal I2S */
    aud_I2S_transmission_mode_end
} aud_I2S_transmission_mode_emum;

typedef enum {
    aud_I2S_setting_normal,
    aud_I2S_setting_special_case1,
    aud_I2S_setting_special_case2,
    aud_I2S_setting_end
} aud_I2S_setting_enum;

typedef enum { /* Changes in this enum will change the validation matrix */
    aud_I2S_mode_mono,
    aud_I2S_mode_dual_mono,
    aud_I2S_mode_stereo,
    aud_I2S_mode_end
} aud_I2S_mode_enum;

typedef enum { /* Changes in this enum will change the validation matrix */
    aud_I2S_entry_point_MMS,
    aud_I2S_entry_point_MMS_FB, /* located at the frame-based part of the voiceband processing system */
    aud_I2S_entry_point_External,
    aud_I2S_entry_point_DAI,
    aud_I2S_entry_point_end
} aud_I2S_entry_point_enum;

typedef enum {
    aud_8_KHz,
    aud_16_KHz,
    aud_sample_rate_end
}aud_sample_rate_enum;

#if defined (aud_old_I2S_interface)
typedef enum {
    aud_disable_pcm_channel,
    aud_enable_pcm_channel,
    aud_enable_pcm_channel_and_Dai,
    aud_enable_pcm_channel_externalmode,
    aud_audio_pcm_end
} aud_audio_pcm_enum;

typedef enum {
    aud_pcm_direction_rx,
    aud_pcm_direction_tx,
    aud_pcm_direction_rx_tx,
    aud_pcm_direction_end
} aud_pcm_direction_enum;
#endif /* aud_old_I2S_interface */

/* smaf enumerations */
typedef enum {
    aud_smaf_err_ok, /* 0 */
    aud_smf_err_initialize_failed,
    aud_smf_err_create_failed,
    aud_smf_err_load_failed,
    aud_smf_err_open_failed,
    aud_smf_err_evhand_failed, /* 5 */
    aud_smf_err_standby_failed,
    aud_smf_err_seek_failed,
    aud_smf_err_control_failed,
    aud_smf_err_start_failed,
    aud_smf_err_stop_failed, /* 10 */
    aud_smf_err_close_failed,
    aud_smf_err_unload_failed,
    aud_smf_err_delete_failed,
    aud_smf_err_invalid_parameters,
    aud_smf_err_wrong_state /* 15 */
} aud_smaf_error_enum;

/* DSP info */
typedef enum {
    aud_dsp_tch_mode, 
    aud_dsp_pdch_mode,
    aud_dsp_idle_mode,
    aud_dsp_bb_off_mode,
    aud_dsp_bb_off_tch_26_mode,
    aud_dsp_mode_end
} aud_dsp_info_enum;

/* Accessory enumeration (deprecated) */
typedef enum {
    aud_accessory_normal, /* 0 */
    aud_accessory_headset,
    aud_accessory_back_speaker_normal_mic,
    aud_accessory_midi_louder_speaker,
    aud_accessory_bt_headset,
    aud_accessory_stereo_phones, /* 5 */
    aud_accessory_car_kit,
    aud_accessory_end
} aud_accessory_enum;

/* Layer 1 info (deprecated) */
typedef enum {
    aud_layer1_tch_mode, 
    aud_layer1_pdch_mode,
    aud_layer1_idle_mode,
    aud_layer1_bb_off_mode,
    aud_layer1_bb_off_tch_26_mode,
    aud_layer1_mode_end
} aud_layer1_info_enum;

/* Resource capability enumerations (deprecated) */
typedef enum {
    uplink_paths_supported, //deprecated
    downlink_paths_supported, //deprecated
    resource_conflict, //deprecated
    features_supported //deprecated
} aud_resource_capability_enum; //this enum is only used by deprecated function AUD_get_resource_capability

/* Test ram buffer enumerations */
typedef enum {
    aud_testrambufferstatus_free, /* ram buffer is free to allocate */
    aud_testrambufferstatus_busy, /* ram buffer is used by players */
    aud_testrambufferstatus_copy, /* copying is ongoing */
    aud_testrambufferstatus_idle, /* ram buffer is allocated and copied but not used */
    aud_testrambufferstatus_end
} aud_testrambuffer_status_enum;

/* Callback function type definitions */
typedef int (*ptr_GetAudioBufferFunction)( 
    /* audiobuffer */ U8 **,
    /* size        */ U16 *, 
    /* user_data   */ void *user_data);
typedef void (*ptr_SetVbOnStatusFunction)(
    /* Status */ U8);
typedef void (*ptr_FmRadioRdsCallbackFunction)(
    /* rds_buffer */ U8 *,
    /* num_bytes  */ U16);

/* Structures for acoustic test */
#define AUD_MAX_MIC_FREQ_NUM		3
typedef struct {
    U16 freq_mid;
    U16 UpperLimit;
    U16 LowerLimit;
} InputMicVal_Type;

typedef struct {
    U16 actest_no_of_freq;
    U16 actest_no_of_freq_outoflim;
    U16 actest_scal;
    U16 actest_ppeak;
    U16 actest_npeak;
    U16 actest_level_f1;
    U16 actest_level_f2;
    U16 actest_level_f3;
    U16 actest_level_f4;
    U16 actest_level_f5;
    U16 actest_level_f6;
} T_DSP_CMD_ACOUSTIC_TEST_RESULT_PAR;  

/******************************************************************************
*
*                            Global variables
*
******************************************************************************/
extern U8 aud_mon_gaim_setting[2];

#if defined (VMS_PRESENT)
extern ptr_GetAudioBufferFunction getAudioBuffer;
#endif 

#if defined (MP3_PRESENT)
extern ptr_GetAudioBufferFunction mp3_getAudioBuffer;
#endif 

#define AUD_GLOBAL_TONE_DUR_INTER_DEFAULT_VALUE 10
extern U16 aud_global_tone_dur_inter;


#ifdef _OS_WIN
#define DISABLE_CLOCK 
#define ENABLE_CLOCK 

#define ATOMIC_BEGIN  
#define ATOMIC_END  
#else
#define DISABLE_CLOCK   ZOSS_DISABLE_IRQ();
#define ENABLE_CLOCK    ZOSS_ENABLE_IRQ();

#define ATOMIC_BEGIN    ZOSS_DISABLE_IRQ();
#define ATOMIC_END      ZOSS_ENABLE_IRQ();
#endif

#ifndef MAX
#define MAX(A,B) ( (A) > (B) ? (A) : (B) )
#endif

/******************************************************************************
*
*                   Prototypes for interface functions
*
******************************************************************************/

/* Resource allocation */
S8 AUD_allocate_resource(U16 id, aud_resource_enum resource, aud_priority_enum priority);
S8 AUD_release_resource(U8 handle);

/* Path control */
U32 AUD_get_downlnk_parallel_path_configuration(aud_downlink_source_enum path);
U32 AUD_get_uplink_parallel_path_configuration(aud_uplink_source_enum path);
S8 AUD_add_uplinkpath(aud_uplink_source_enum path);
S8 AUD_remove_uplinkpath(aud_uplink_source_enum path);
S8 AUD_add_downlinkpath(aud_downlink_source_enum path);
S8 AUD_remove_downlinkpath(aud_downlink_source_enum path);
S8 AUD_Pathupdate_Enable(void);
S8 AUD_Pathupdate_Disable(void);
S8 AUD_set_eq_vol_threshold(aud_downlink_source_enum path, aud_volume_enum eq_volume_threshold);

/* Volume control */
S8 AUD_set_resource_volume(U8 handle, aud_volume_enum volume);
S8 AUD_set_master_volume(aud_volume_enum volume);
S8 AUD_mute_resource(U8 handle, aud_mute_enum enable_disable, 
    aud_ul_dl_direction_enum direction);
S8 AUD_mute_master(aud_mute_enum enable_disable); 

/* Speech */
S8 AUD_speech_enable(U8 handle);
S8 AUD_speech_disable(U8 handle);
S8 AUD_set_EC_NR(U8 EC_on, U8 NR_on);

/* Tone generator */
S8 AUD_tone_start(U8 handle, aud_tone_id_enum tone_id, 
    U16 nof_repeats, S16 mix_factor);
S8 AUD_tone_start_user_tone(U8 handle, void *tone_data, aud_tone_type_enum type, 
    U32 nof_tones, U16 nof_repeats, S16 mix_factor);
S8 AUD_tone_stop(U8 handle);
S8 AUD_tone_suspend(U8 handle, U8 slot_id);
S8 AUD_tone_resume(U8 handle, U8 slot_id);
S8 AUD_tone_get_total_playtime(U8 handle, aud_tone_id_enum tone_id, void *tone_data,
    U32 nof_tones, aud_tone_type_enum type);
S8 AUD_tone_get_play_position(U8 handle);
S8 AUD_tone_set_play_position(U8 handle, U32 pos);

/* Ringer */
S8 AUD_ringer_start(U8 handle, aud_ringer_tone_id_enum tone_id, 
    U16 nof_repeats, aud_ringer_device_enum device);
S8 AUD_ringer_start_user_tone(U8 handle, U8 DWD_HUGE *ringer_data, 
    U32 size, aud_format_enum format, U16 nof_repeats, 
    aud_ringer_device_enum device, U8 channel, U8 channel_volume);
S8 AUD_ringer_stop(U8 handle, U8 channel);
S8 AUD_ringer_set_channel_volume(U8 handle, U8 channel_volume, U8 channel);
S8 AUD_ringer_suspend(U8 handle, U8 SlotID, U8 channel);
S8 AUD_ringer_resume(U8 handle, U8 SlotID, U8 channel);
S8 AUD_ringer_stop_suspend(U8 handle, U8 SlotID, U8 channel);
S8 AUD_ringer_get_total_playtime(U8 handle, U8 DWD_HUGE *data, U32 data_size,  
    aud_format_enum format, aud_ringer_tone_id_enum tone_id);
S8 AUD_ringer_get_playposition(U8 handle);
S8 AUD_ringer_set_playposition(U8 handle, U8 channel, U32 offset);

/* Vibrator */
void AUD_vibrator_enable(aud_vib_mode mode, U8 channel);  
void AUD_vibrator_pause(void);   
void AUD_vibrator_disable(void);

/* FM Radio */
S8 AUD_radio_enable(U8 handle);
S8 AUD_radio_disable(U8 handle);
S8 AUD_radio_rssi_subscribe(U8 handle, aud_fm_radio_rssi_enum lower_threshold, 
    aud_fm_radio_rssi_enum upper_threshold);
S8 AUD_radio_rds_subscribe(U8 handle, ptr_FmRadioRdsCallbackFunction pCbFunc);
S8 AUD_radio_set_station(U8 handle, aud_fm_radio_seek_mode_enum seekmode, 
    U32 frequency, aud_fm_radio_rssi_enum detect_level, U8 force_mono);
S8 AUD_radio_get_frequency(U8 handle);

/* Voice memo */
S8 AUD_vm_start_recording(
    U8 handle, 
    aud_vm_mode_enum vm_mode, 
    aud_media_enum media_type,
    aud_dsp_format_enum format, 
    U8 rate, 
    U16 DWD_HUGE *file_handle, 
    U32 buffer_size, 
    U32 offset);
S8 AUD_vm_stop_recording(U8 handle);
S8 AUD_vm_start_playback(
    U8 handle, 
    aud_vm_mode_enum vm_mode, 
    aud_media_enum media_type,
    aud_dsp_format_enum format, 
    U16 DWD_HUGE *file_handle, 
    U32 buffer_size,
    U16 nof_repeats, 
    U32 offset);
S8 AUD_vm_stop_playback(U8 handle);
void Aud_vms_set_getbuffer_function(U8 handle, ptr_GetAudioBufferFunction func, 
    void * user_data);
S8 AUD_vm_suspend(U8 handle, U8 slot_id);
S8 AUD_vm_resume(U8 handle, U8 slot_id);
S8 AUD_vm_get_total_playtime(
    U8 handle, 
    aud_media_enum media_type, 
    aud_dsp_format_enum format, 
    U16 DWD_HUGE *file_handle, 
    U32 buffer_size, 
    U32 offset);
S8 AUD_vm_get_play_position(U8 handle);
S8 AUD_vm_set_play_position(
    U8 handle, 
    U32 pos, 
    U16 DWD_HUGE *file_handle, 
    U32 buffer_size);
S8 AUD_vm_stop_suspend(U8 handle, U8 slot_id);

/* MP3 Player */
S8 AUD_mp3_start(U8 handle, aud_media_enum media_type, U16 DWD_HUGE *file_handle,
    U32 buffer_size, U32 id_offset, U32 start_frame, U16 nof_repeats);
S8 AUD_mp3_stop(U8 handle);
S8 AUD_mp3_suspend(U8 handle, U16 slot_id);
S8 AUD_mp3_resume(U8 handle, U16 slot_id);
S8 AUD_mp3_fastforward(U8 handle, U32 frame, U16 slot_id);
S8 AUD_mp3_backward(U8 handle, U32 frame, U16 slot_id);
void Aud_mp3_set_getbuffer_function(U8 handle, ptr_GetAudioBufferFunction func, 
    void * user_data);
S8 Aud_mp3_get_current_frame(U8 handle, U16 slot_id);
S8 AUD_mp3_get_total_playtime(U8 handle, aud_media_enum media_type, 
    U16 DWD_HUGE *file_handle, U32 buffer_size, 
    U32 id_offset );
S8 AUD_mp3_get_play_position(U8 handle);
S8 AUD_mp3_set_play_position(U8 handle, U32 pos, U16 DWD_HUGE *file_handle, 
    U32 buffer_size);
S8 AUD_mp3_stop_suspend(U8 handle, U8 SlotID);

/* TTY */
S8 AUD_tty_enable(U8 handle);
S8 AUD_tty_disable(U8 handle);
S8 AUD_tty_set_negotiation(U8 handle,U8 on_off);

/* PCM player/recorder */
S8 AUD_pcm_intern_start_playback(
    U8 handle, 
    aud_pcm_mode_enum mode, 
    aud_pcm_sample_rate_enum sample_rate, 
    U8 bit_rate, 
    aud_media_enum media_type, 
    aud_pcm_format_enum format,
    U16 DWD_HUGE *file_handle, 
    U32 buffer_size, 
    U16 nof_repeats,
    U32 start_offset);
S8 AUD_pcm_intern_stop_playback(U8 handle);
S8 AUD_pcm_intern_start_recording(
    U8 handle, 
    aud_pcm_sample_rate_enum sample_rate, 
    aud_media_enum media_type, 
    aud_pcm_format_enum format,
    U16 DWD_HUGE *file_handle, 
    U32 buffer_size,
    U32 start_offset);
S8 AUD_pcm_intern_stop_recording(U8 handle);
S8 AUD_pcm_intern_getbuffer_function(U8 handle, ptr_GetAudioBufferFunction func, 
    void * user_data);
S8 AUD_pcm_intern_suspend(U8 handle, U8 slot_id);
S8 AUD_pcm_intern_resume(U8 handle, U8 slot_id);
S8 AUD_pcm_intern_stop_suspend(U8 handle, U8 slot_id);
S8 AUD_pcm_intern_get_total_playtime(U8 handle, aud_media_enum media_type, 
    aud_pcm_format_enum format, aud_pcm_sample_rate_enum sample_rate, 
    aud_pcm_mode_enum mode, U8 bit_rate,
    U16 DWD_HUGE *file_handle, U32 buffer_size, U32 offset);
S8 AUD_pcm_intern_get_play_position(U8 handle);
S8 AUD_pcm_intern_set_play_position(U8 handle, U32 pos, 
    U16 DWD_HUGE *file_handle, U32 buffer_size);

/* Yamaha Music API (mapi) */
S8 AUD_mapi(U8 handle, aud_mapi_if_enum func_id, U32 parm1, U32 parm2,
    U32 parm3, U32 parm4, U32 parm5, U32 parm6, U32 parm7);

/* Inband resource, used for non-baseband audio */
/**
 * AUD_non_baseband_resource_start
 * 
 * This function activates the inband virtual resource, used for non-baseband audio.
 * Only use this when aud_resource_inband is allocated. The resource is virtual,
 * so the usecase is non-baseband audio output on whatever paths are enabled.
 * 
 * @param handle (generated by AUD_allocate_resource)
 * @see AUD_allocate_resource
 * @return signed 8bit integer (error code)
 */
S8 AUD_non_baseband_resource_start(U8 handle);

/**
 * AUD_non_baseband_resource_stop
 * 
 * This function deactivates the inband virtual resource, used for non-baseband audio.
 * Only use this when aud_resource_inband is allocated. The resource is virtual,
 * so the usecase is non-baseband audio output on whatever paths are enabled.
 * 
 * @param handle (generated by AUD_allocate_resource)
 * @see AUD_allocate_resource
 * @return signed 8bit integer (error code)
 */
S8 AUD_non_baseband_resource_stop(U8 handle);

/* SM Power */
/**
 * AUD_SMPower_enable
 * 
 * This function is to trigger the power-on of the SM Power Gain Amplifier
 * Only use this when allocating the aud_resource_smpower. The resource is virtual,
 * so the usecase is an external device outputting through SM power.
 * 
 * @param handle (generated by AUD_allocate_resource)
 * @see AUD_allocate_resource
 * @return signed 8bit integer (error code)
 */
S8 AUD_SMPower_enable(U8 handle);
/**
 * AUD_SMPower_disable
 * 
 * This function is to trigger the power-off of the SM Power Gain Amplifier
 * Only use this when allocating the aud_resource_smpower. The resource is virtual,
 * so the usecase is an external device outputting through SM power.
 * 
 * @param handle (generated by AUD_allocate_resource)
 * @see AUD_allocate_resource
 * @return signed 8bit integer (error code)
 */
S8 AUD_SMPower_disable(U8 handle);

/* SBC Encoder */
S8 AUD_sbc_encoder_start (U8 handle,
    aud_sbc_encoder_data_mode_enum data_mode,
    aud_sbc_encoder_channel_mode_enum channel_mode,
    aud_sbc_encoder_sample_rate_enum sample_rate,
    aud_sbc_encoder_number_of_blocks_enum no_of_blocks,
    U8 bitpool);
S8 AUD_sbc_encoder_stop(U8 handle);
S8 AUD_sbc_encoder_suspend(U8 handle, U8 slot_id);
S8 AUD_sbc_encoder_resume (U8 handle, U8 slot_id);
S8 AUD_sbc_encoder_set_getinputbuffer_function(U8 handle,
    ptr_GetAudioBufferFunction input_buffer_function,
    void * user_data);
S8 AUD_sbc_encoder_set_getoutputbuffer_function(U8 handle,
    ptr_GetAudioBufferFunction output_buffer_function,
    void * user_data);

/* I2S2 Rx and Tx*/
#if defined (aud_old_I2S_interface)
S8 AUD_configure_pcm_channel(U8 handle, aud_I2Sx_mode_enum mode);
S8 AUD_pcm_channel_routing(U8 handle, U8 input_to_uplink, U8 input_to_downlink, 
    U8 output_from_uplink, U8 output_from_downlink);
S8 AUD_pcm_channel_enable(U8 handle, aud_pcm_direction_enum direction);
S8 AUD_pcm_channel_disable(U8 handle);
#endif /* aud_old_I2S_interface */
S8 AUD_I2S_enable_resource(U8 handle);
S8 AUD_I2S_disable_resource (U8 handle);
S8 AUD_I2S_setup_clock(aud_I2S_clk_enum clock,
    aud_I2S_Master_Slave_enum Master_Slave,
    aud_I2S_samplerate_enum samplerate,
    aud_I2S_sample_width_enum sample_width,
    aud_I2S_transmission_mode_emum transmission_mode,
    aud_I2S_setting_enum settings,
    aud_I2S_mode_enum I2S_mode);
S8 AUD_I2S_setup_resource(U8 handle,
    aud_I2S_clk_enum clock,
    aud_I2S_entry_point_enum entry_point);

/* I2S1 */
S8 AUD_configure_bluetooth(U8 handle, aud_I2Sx_mode_enum mode);

/* 3D stereo */
S8 AUD_3D_mode_enable(void);
S8 AUD_3D_mode_disable(void);

/* Interrupts */
void AUD_tone_handle_int(void);
void AUD_TONE_int_handler(int vector);
void AUD_poak_int2_handle_int(void);
void AUD_POAK_INT2_int_handler(int vector);
void AUD_TEAK_INT5_int_handler(int vector);
void AUD_teak_int5_handle_int(void);
void AUD_TEAK_INT4_int_handler(int vector);
void AUD_teak_int4_handle_int(void);
void AUD_TEAK_INT6_int_handler(int vector);
void AUD_teak_int6_handle_int(void);
void AUD_TEAK_INT7_int_handler(int vector);
void AUD_teak_int7_handle_int(void);
void AUD_hal_fm_radio_lisr_int_handler(int vector); /* LISR for FM Radio interrupt */

/* Misc functions */
U32 AUD_info_hw_available(void);
void AUD_misc_dsp_info(aud_dsp_info_enum dsp_info); /* Only to be used on interface between DSP and AUD */
S8 Aud_set_vb_on_status_function(ptr_SetVbOnStatusFunction func);

/* Misc functions */
void aud_drv_check_timeout(void);
void aud_dai_mode(aud_dai_mode_enum dai_mode);
void aud_drv_restart_hf(void);

/* Test functions */
U16 AUD_ptest_generic_func(void *func_req_ptr); /* generic ATCP test interface */
U16 AUD_ptest_generic_func_memaligned(void *func_req_ptr);

/* FFT analysis */
S8 AUD_FFT_Start(U16 NoOfFrames, U16 AverageExponent, U16 RefLevel, U16 QFormat,
    InputMicVal_Type *pMicVal);
S8 AUD_FFT_GetResult(T_DSP_CMD_ACOUSTIC_TEST_RESULT_PAR **pFFT_Result);

/* Audio Dispatcher - should only be used in aud_intf.c and aud_op.c */
void AudioDispatcher(
    SDL_Pid sender,
    U8   event,
    U16  caller_id,
    U32  parm1,
    U32  parm2,
    U32  parm3, 
    U32  parm4,
    U32  parm5,
    U32  parm6,
    U32  parm7, 
    U32  parm8,
    U8  *ptr1,
    U8  *ptr2);

/******************************************************************************
*
*                          Deprecated functions
*
******************************************************************************/
/* Do not remove the following functions here - file is shared between EGold, SGold and other systems */
/* This is old stuff that has to be removed when Apoxi has cleaned out their inclusion of old files - depending on this */

S8 AUD_media_to_uplink(U8 enable_disable); /* deprecated - use new path aud_media_to_uplink instead */
S8 AUD_media_to_downlink(U8 enable_disable); /* deprecated - use new path aud_media_to_downlink_mute instead */
U32 AUD_get_resource_capability(aud_resource_enum resource, aud_resource_capability_enum capability);
S8 AUD_key_tone(aud_tone_id_enum key_tone, S16 mix_factor);
S8 AUD_amp_enable(U8 handle);
S8 AUD_amp_disable(U8 handle);
S8 AUD_vibrator_start(U8 handle, aud_vibrator_mode_enum mode,  
    aud_vibrator_on_enum on, aud_vibrator_off_enum off);
S8 AUD_vibrator_stop(U8 handle);
void AUD_misc_set_accessory(aud_accessory_enum accessory);
void AUD_misc_set_vmic(U8 status);
S8 AUD_set_volume(U8 handle, aud_volume_enum volume);
S8 AUD_speech_set_volume(U8 handle, aud_speech_volume_enum volume);
S8 AUD_ringer_set_volume(U8 handle,aud_ringer_volume_enum volume);
void AUD_init(void);
S8 AUD_radio_init(U8 handle);
S8 AUD_radio_config(U8 handle, void * aud_radio_config_data);
S8 AUD_radio_read_current_status(U8 handle);
S8 AUD_radio_mute(U8 handle,U8 mute);
S8 AUD_speech_mute(U8 handle,aud_mute_enum status,aud_direction_enum direction);
#ifdef USE_VOICE_SUPPORT
void AUD_misc_layer1_info(aud_layer1_info_enum layer1_info); /* Only to be used on interface between AUD and Layer1 */
#endif
#endif /* _AUD_INTERFACES */
/* End of file. */
