/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        wujinlei
 * Date:          2013-5-16
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/
#include "drvs_general.h"
#include "drvs_dma.h"
#include "drvs_ref_cfg.h"
#include "drvs_pm.h"
#include "drvs_gpio.h"
#include "drvs_pcu.h"
#include "drvs_uicc.h"

//#include <mach/gpio.h>
#include <linux/uicc_agt_client.h>
#include "uicc_stub.h"

#include "uicc.h"
#include "uicc_ctrl.h"
extern VOID udelay(UINT32  us);
extern void uicc_insert_isr(void);
extern void uicc_remove_isr(void);
extern SINT32 pcu_ClearInt(UINT32 intLine);

extern  hotplugCallback_func uicc_hotplugCallback;
typedef VOID* T_ZDrvGpio_Pin;
extern ushort err_type_chtimeout;
 
UINT32 g_testsiminorout = 0;// 1 means out,0 means in
static int totalrecover = 0;

#define SIM_DETECT_THREAD_PRI 16
ZOSS_THREAD_ID vsim_detect_thread = NULL;

#define SIM_HISR_THREAD_STACK_SIZE 4096

T_Drv_Hisr s_simHalHisr =
{
    0
};

static T_Drv_Hisr *s_simHisr =
{
	0
};

#ifdef UICC_ENABLE_IN_OUT_DETECTION
extern T_UICC_CARD_TYPE card_type_ctrl[3];
extern UINT8 Vsim_Flag;
//satic T_ZDrvGpio_Pin s_uicc_insert_detect;  
static UINT32 s_uicc_insert_detect = 0;
#endif

static volatile UINT8 uiccPlugEvent = 0;
volatile UINT8 uiccPlugFlag  = UICC_SIM_PLUGIN;
static volatile UINT8 uiccRecovFlag  = 0;


static inline void uicc_setPlugEvent(UINT8 value)
{
	uiccPlugEvent = value;
}

static inline UINT8 uicc_getPlugEvent(void)
{
	return uiccPlugEvent;
}

static void uiccRecover_handler(void)
{
	uicc_setPlugEvent(1);
	
	zDrv_HisrActivate(&s_simHalHisr);
	
	uiccRecovFlag = 1;
}

static UINT8 uiccStatus_get(void)
{
	return uiccPlugFlag;
}

//extern SINT32 zDrvZx234290_RestartByTc(void);
VOID simHal_Hisr(SINT32 arg)
{
#ifdef UICC_ENABLE_IN_OUT_DETECTION
    UINT32 temp = 0;
    zDrv_HisrInitSem(&s_simHalHisr);    
    while (1)
    {
		zDrv_HisrWaitSem(&s_simHalHisr);
		if (err_type_chtimeout == 1)
		{
			uicc_remove_isr();
			zDrvPow_ActiveSleep(300);
			uicc_insert_isr();
			err_type_chtimeout = 0;
			totalrecover++;
			zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "sim card chtimeout error.recover cnt = %d\n!",totalrecover);
			uiccramlog_Printf("sim card chtimeout error.recover cnt = %d\n!",totalrecover);
		}
		else
		{
			
		if(!uicc_getPlugEvent())
			continue;
		uicc_setPlugEvent(0);
		
		zDrvPow_ActiveSleep(600);
		//udelay(200000);		
/*		zDrvGpio_SetFunc(s_uicc_insert_detect, UICC_GPIO_FUN_GPIO);
		zDrvGpio_SetDirection(s_uicc_insert_detect, GPIO_IN);
		temp = zDrvGpio_GetInputValue(s_uicc_insert_detect);

		zDrvGpio_SetFunc(s_uicc_insert_detect, UICC_GPIO_EXT_INT);*/	    
		//zx29_gpio_config(UICC_GPIO,UICC_GPIO_FUN_GPIO);
		//gpio_direction_input(UICC_GPIO);
		temp = gpio_get_value(UICC_GPIO);

		//zx29_gpio_config(UICC_GPIO,UICC_GPIO_EXT_INT);
		
		if(temp == SIM_OUT)//remove
		{
			zDrvInt_SetLineLevel(UICC_EXT_INT, SIM_IN_LEVEL);

			if (VSIM_CARD == card_type_ctrl[0] ||UICC_ESIM_CARD == card_type_ctrl[0] )
			{
				zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "VSIM_CARD or ESIM_CARD  == card_type_ctrl,ignore SIM_isr");
				
				if(uiccPlugFlag != UICC_SIM_PLUGOUT)
				{
					uiccPlugFlag = UICC_SIM_PLUGOUT;
				}	
				
				uiccRecovFlag = 0;

				pcu_ClearInt(UICC_EXT_INT);
				zDrvInt_UnmaskIrq(UICC_EXT_INT);

				continue;
			}
			
			if(uiccPlugFlag == UICC_SIM_PLUGOUT){
				
				zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "sim allready removed!");
			}else{
				uicc_remove_isr();
				#if 0
				if(VSIM_CARD == card_type_ctrl)
				{
					uicc_insert_isr();
				}
				#endif
				if(uicc_hotplugCallback)
					uicc_hotplugCallback(UICC_SIM_PLUGOUT);
			 	uiccPlugFlag = UICC_SIM_PLUGOUT;
				zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "sim removed!");
			}
		}
		else if(temp == SIM_IN)  //insert
		{
			zDrvInt_SetLineLevel(UICC_EXT_INT,SIM_OUT_LEVEL);

			if (VSIM_CARD == card_type_ctrl[0] ||UICC_ESIM_CARD == card_type_ctrl[0] )
			{
				zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "VSIM_CARD or ESIM_CARD == card_type_ctrl,ignore SIM_isr");
				
				if(uiccPlugFlag != UICC_SIM_PLUGIN)
				{
					uiccPlugFlag = UICC_SIM_PLUGIN;
				}	
				
				uiccRecovFlag = 0;

				pcu_ClearInt(UICC_EXT_INT);
				zDrvInt_UnmaskIrq(UICC_EXT_INT);

				continue;
			}

			if(uiccPlugFlag == UICC_SIM_PLUGIN){
				zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "sim allready interted!");
				if(uiccRecovFlag)
				{
				       #if 0
					if(VSIM_CARD == card_type_ctrl)
					{
						uicc_remove_isr();
					}
					#endif
					uicc_insert_isr();
				}
			}else{
				if(uicc_hotplugCallback)
			 		uicc_hotplugCallback(UICC_SIM_PLUGIN);	
				else{
					#if 0
					if(VSIM_CARD == card_type_ctrl)
					{
						uicc_remove_isr();
					}
					#endif
					uicc_insert_isr();
				}
				uiccPlugFlag = UICC_SIM_PLUGIN;				
			 	zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "new sim interted!");
			}
		}
		else
		{
			zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "sim state err");
		}
		uiccRecovFlag = 0;
		
        pcu_ClearInt(UICC_EXT_INT);
		zDrvInt_UnmaskIrq(UICC_EXT_INT);
		}

	}
#else
	zDrv_HisrInitSem(&s_simHalHisr);    
	while (1)
	{
		zDrv_HisrWaitSem( &s_simHalHisr);
		uicc_remove_isr();
		zDrvPow_ActiveSleep(300);
		uicc_insert_isr();
		zOss_Printf(SUBMDL_FS, PRINT_LEVEL_NORMAL, "sim card error.recover\n!");
	}
#endif

}

/******************************************************************************
 * Function:		sim_HisrCreate
 * Description:	This function is used to create a HISR for servicing the USB interrupts.
 * Parameters:
 *   Input:
 *				device - pointer to a device HAL structure
 *
 *   Output:	None
 *
 * Returns:
 *			pointer to the HISR handle
 *
 * Others:
 ******************************************************************************/
T_Drv_Hisr* sim_HisrCreate(void)
{
    SINT32 Status = 0;

    Status = zDrv_HisrCreate(&s_simHalHisr, "s_simHalHisr", SIM_HISR_THREAD_STACK_SIZE, SIM_DETECT_THREAD_PRI, simHal_Hisr, NULL);

    if (Status < 0)
    {
        return NULL;
    }

	uicc_setRecover_callback(uiccRecover_handler);	
	uicc_getSimStatu_callback(uiccStatus_get);
    return(&s_simHalHisr);
}

#ifndef SOC_USIM
/*******************************************************************************
 * Function: zDrvUICC_ConfigForDetectSIM
 * Description:gsm simȲж
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
#ifdef UICC_ENABLE_IN_OUT_DETECTION

void UICC_usim_in_or_out_lisr(void)
{
   	zDrvInt_MaskIrq(UICC_EXT_INT);
   	uicc_setPlugEvent(1);
	zDrv_HisrActivate(&s_simHalHisr);
    
}
#endif
/*******************************************************************************
 * Function: zDrvUICC_ConfigForDetectSIM
 * Description:gsm simȲж
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/

UINT8 zDrvUICC_ConfigForDetectSIM(VOID)
{
#ifdef UICC_ENABLE_IN_OUT_DETECTION
    UINT32 temp = 0;// 1 means in,0 means out
    int ret = 0;

	if(s_uicc_insert_detect == 0)
	{
//	s_uicc_insert_detect = zDrvGpio_Request(UICC_GPIO_NAME);
		ret = gpio_request(UICC_GPIO,UICC_GPIO_NAME);
		if(ret)
			return -1;
	
		s_uicc_insert_detect = 1;
	}

//	zDrvGpio_PullUpDown(s_uicc_insert_detect, GPIO_NO_ACTION);
	zx29_gpio_pd_pu_set(UICC_GPIO, IO_CFG_PULL_DISABLE);
	zDrvPow_ActiveSleep(20);//udelay(20000);
/*	zDrvGpio_SetFunc(s_uicc_insert_detect, UICC_GPIO_FUN_GPIO);
	zDrvGpio_SetDirection(s_uicc_insert_detect, GPIO_IN);
	temp = zDrvGpio_GetInputValue(s_uicc_insert_detect);*/
	zx29_gpio_config(UICC_GPIO,UICC_GPIO_FUN_GPIO);
	gpio_direction_input(UICC_GPIO);
	temp = gpio_get_value(UICC_GPIO);

	zDrvPcu_SetWakeInt(UICC_EXT_INT, 0);
	zDrvInt_DelayUnmaskAdd(UICC_EXT_INT);
//	zDrvGpio_SetFunc(s_uicc_insert_detect, UICC_GPIO_EXT_INT);
	zx29_gpio_config(UICC_GPIO,UICC_GPIO_EXT_INT);

	if (temp == SIM_OUT){
       //͵ƽ޿ȴ   
	 //zDrvPcu_SetIntLevel(EX3_INT, INT_POSEDGE);
     s_simHisr = sim_HisrCreate();
     if(s_simHisr != NULL){
		ret = zDrvInt_InstallIsr(UICC_EXT_INT, (void *)UICC_usim_in_or_out_lisr, "Sim_inout",SIM_IN_LEVEL); 
		if (ret < 0)
		{
			return DRV_ERROR;
		}
		#if 0
		if(VSIM_CARD == card_type_ctrl ||(UICC_VSIM_AUTO == card_type_ctrl))
		{
			if(vsim_detect_thread == NULL)
				vsim_detect_thread = zOss_CreateThread("UICC_VSIM_DETECT_THREAD",vsim_Hisr,0,512,7,1,1);
		}
		#endif
     }
		uiccPlugFlag = UICC_SIM_PLUGOUT;//UICC_SIM_PLUGIN;
    }else{	
    	//ߵƽпȴγ
		//zDrvPcu_SetIntLevel(EX3_INT,INT_LOWLEVEL);
		s_simHisr = sim_HisrCreate();
		if(s_simHisr != NULL){
			ret = zDrvInt_InstallIsr(UICC_EXT_INT, (void *)UICC_usim_in_or_out_lisr, "Sim_inout",SIM_OUT_LEVEL);
			if (ret < 0)
			{
				return DRV_ERROR;
			}

			#if 0
			if(VSIM_CARD == card_type_ctrl ||(UICC_VSIM_AUTO == card_type_ctrl))
			{
			if(vsim_detect_thread == NULL)
				vsim_detect_thread = zOss_CreateThread("UICC_VSIM_DETECT_THREAD",vsim_Hisr,0,512,7,1,1);
			}
			#endif
		}
	
		uiccPlugFlag = UICC_SIM_PLUGIN;//UICC_SIM_PLUGOUT;
    }
#else
	s_simHisr = sim_HisrCreate();
	if (s_simHisr == NULL)
	{
		return DRV_ERROR;
	}
#endif
	return uiccPlugFlag;
}
#else
/*******************************************************************************
 * Function: zDrvUICC_ConfigForDetectSocSIM
 * Description:soc simȲж
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 VOID zDrvUICC_ConfigForDetectSocSIM(VOID)
{
#ifdef UICC_ENABLE_IN_OUT_DETECTION
	return;
#endif
}
#endif

