/**************************************************************************
*
*                  Copyright (c) 2014 ZTE Corporation.
*
***************************************************************************
* ģ   : mpuģ
*    : tos_mpu_cp15.S
* ļ : 
* ʵֹ : mpu
*      : 
*      : V1.0
*  : 2014/04/10
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/
.code 32
.text

/**************************************************************************
* ֲʵ
**************************************************************************/
.global mpu_RegionNumSet
.type mpu_RegionNumSet, %function
.align 4
mpu_RegionNumSet:                           //set region number, select region
	mcr		p15, 0, r0, c6, c2, 0
	bx		lr

.global mpu_RegionBaseSet
.type mpu_RegionBaseSet, %function
.align 4
mpu_RegionBaseSet:                          //set region base address				
	bic		r0, r0, #0x1f
	mcr		p15, 0, r0, c6, c1, 0
	bx		lr
	
.global mpu_RegionBaseGet
.type mpu_RegionBaseGet, %function
.align 4
mpu_RegionBaseGet:                          //get region base address
	mrc		p15, 0, r0, c6, c1, 0
	bx		lr

.global mpu_RegionAttrSet
.type mpu_RegionAttrSet, %function
.align 4
mpu_RegionAttrSet:                          //set region attribution
	mcr		p15, 0, r0, c6, c1, 4
	bx		lr

.global mpu_RegionAttrGet
.type mpu_RegionAttrGet, %function
.align 4
mpu_RegionAttrGet:                          //get region attribution 
	mrc		p15, 0, r0, c6, c1, 4
	bx		lr

.global mpu_RegionSizeSet
.type mpu_RegionSizeSet, %function
.align 4
mpu_RegionSizeSet:                          //set region size
	push 	{r1, lr}
	mrc		p15, 0, r1, c6, c1, 2
	bic		r1, r1, #0x3e
	orr		r1, r1, r0, lsl #1
	mcr		p15, 0, r1, c6, c1, 2
	pop		{r1, pc}
    
.global mpu_RegionSizeGet
.type mpu_RegionSizeGet, %function
.align 4
mpu_RegionSizeGet:                          //get region size and enable reg	
	mrc		p15, 0, r0, c6, c1, 2 
	bx		lr

.global mpu_SubRegionSet
.type mpu_SubRegionSet, %function
.align 4
mpu_SubRegionSet:                           //sub-region set
	push 	{r1, lr}
	mrc		p15, 0, r1, c6, c1, 2
	bic		r1, r1, #0xff00
	orr		r1, r1, r0, lsl #8
	dsb
	mcr		p15, 0, r1, c6, c1, 2
	isb
	pop		{r1, pc}

.global mpu_RegionSwitch
.type mpu_RegionSwitch, %function
.align 4
mpu_RegionSwitch:                           //region switch
	push 	{r1, lr}
	mrc		p15, 0, r1, c6, c1, 2
	bic		r1, r1, #0x1
	orr		r1, r1, r0
	dsb
	mcr		p15, 0, r1, c6, c1, 2
	isb
	pop		{r1, pc}


.global mpu_RegionMaxNum
.type mpu_RegionMaxNum, %function           //get region max num
.align 4
mpu_RegionMaxNum:
    mrc     p15, 0, r0, c0, c0, 4
    mov     r0, r0, lsr #8
    bx      lr

.global mpu_DFSRValueGet
.type mpu_DFSRValueGet, %function           //get DFSR
.align 4
mpu_DFSRValueGet:
    mrc     p15, 0, r0, c5, c0, 0
    bx      lr

.global mpu_DFARValueGet
.type mpu_DFARValueGet, %function           //get DFAR
.align 4
mpu_DFARValueGet:
    mrc     p15, 0, r0, c6, c0, 0
    bx      lr

.global mpu_IFSRValueGet
.type mpu_IFSRValueGet, %function           //get IFSR
.align 4
mpu_IFSRValueGet:
    mrc     p15, 0, r0, c5, c0, 1
    bx      lr

.global mpu_IFARValueGet
.type mpu_IFARValueGet, %function           //get IFAR
.align 4
mpu_IFARValueGet:
    mrc     p15, 0, r0, c6, c0, 2
    bx      lr

/**************************************************************************
* ȫֺʵ
**************************************************************************/
.global zTos_MpuSwitch
.type zTos_MpuSwitch, %function
.align 4
zTos_MpuSwitch:                             //mpu switch
	push 	{r1, lr}
	mrc		p15, 0, r1, c1, c0, 0
	bic		r1, r1, #0x1
	orr		r1, r1, r0
	dsb
	mcr		p15, 0, r1, c1, c0, 0
	isb
	pop		{r1, pc}
    
