/**
 * @file Hal_codec_tlv3100.c
 * @brief Implementation of Sanechips Audio Codec Function
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author Author: Xinqiang Xu <xu.xinqiang@sanechips.com.cn>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
 
/*******************************************************************************
 *							 Include header files							   *
 ******************************************************************************/
#include "drvs_general.h"
#include "drvs_i2c.h"
#include "drvs_pm.h"
#include "drvs_codec.h"
#include "drvs_pow.h"
#include "drvs_ramlog.h"
#ifdef _CONFIG_USE_CODEC_TLV3100
#include "hal_codec_tlv3100.h"

/*******************************************************************************
 *							   Macro definitions							   *
 ******************************************************************************/
#define TLV3100_I2C_SADD            0x18
#define I2C_SADD            TLV3100_I2C_SADD
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/


/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/

/*******************************************************************************
 *						   Local variable definitions						   *
 ******************************************************************************/



#ifdef _USE_REF_AUDIO_ON_7520
 T_ZDrvI2c_Device s_codecI2CDev = {
	0,
	I2C_SADD,
	100 * 1000,
	100,
	1,
	I2C_REG_DEV | I2C_M_COMBINE,
	NULL
};
#else
 T_ZDrvI2c_Device s_codecI2CDev = {
	1,
	I2C_SADD,
	100 * 1000,
	100,
	1,
	I2C_REG_DEV | I2C_M_COMBINE,
	NULL
};
#endif




/*
* according to actual hardware disign
*/
/* micrp use for handset, miclp and miclm use for handset */
static T_Codec_Reg_Para  handsetInPathPara[] = {
	/* page1 reg47:MIC PGA 0x14 */
	{
		0, 1, 47, \
		CODEC_P1_REG47_MICPGA_CTRL_BY_D06_VAL | CODEC_P1_REG47_MICPGA_20DB_VAL, \
		CODEC_P1_REG47_MICPGA_CTRL_MASK | CODEC_P1_REG47_MICPGA_GAIN_MASK
	},
	/* page1 reg48:Delta-Sigma Mono ADC Channel Fine-Gain Input Selection for P-Terminal 0x40*/
	{
		0, 1, 48, \
		CODEC_P1_REG48_MIC1LP_SEL_10KR_VAL, \
		CODEC_P1_REG48_ADC_MIC1LP_SEL_MASK | CODEC_P1_REG48_ADC_MIC1RP_SEL_MASK | \
		CODEC_P1_REG48_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg49:ADC Input Selection for M-Terminal */
	{
		0, 1, 49, \
		CODEC_P1_REG49_MIC1LM_SEL_10KR_VAL, \
		CODEC_P1_REG49_ADC_CM_SEL_MASK | CODEC_P1_REG49_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg50:Input CM Setting */
	{
		0, 1, 50, \
		0, \
		CODEC_P1_REG50_MIC1_TO_CM_MASK
	},
	/* page0 reg81:ADC Digital Mic  0x80 */
	{
		0, 0, 81, \
		CODEC_P0_REG81_ADC_PWON_VAL | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_1FS_VAL, \
		CODEC_P0_REG81_ADC_PW_MASK | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_CTRL_MASK
	},
	/* page0 reg82:ADC Digital Volume Control Fine Adjust */
	{
		0, 0, 82, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_0DB_VAL, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_MASK
	},
	/* page0 reg83:ADC Digital Volume Control Coarse Adjust */
	{
		0, 0, 83, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_0DB_VAL, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_MASK
	}
};

static T_Codec_Reg_Para  headsetInPathPara[] = {
	/* page1 reg47:MIC PGA 0x14 */
	{
		0, 1, 47, \
		CODEC_P1_REG47_MICPGA_CTRL_BY_D06_VAL | CODEC_P1_REG47_MICPGA_20DB_VAL, \
		CODEC_P1_REG47_MICPGA_CTRL_MASK | CODEC_P1_REG47_MICPGA_GAIN_MASK
	},
	/* page1 reg48:Delta-Sigma Mono ADC Channel Fine-Gain Input Selection for P-Terminal 0x40*/
	{
		0, 1, 48, \
		CODEC_P1_REG48_MIC1RP_SEL_10KR_VAL, \
		CODEC_P1_REG48_ADC_MIC1LP_SEL_MASK | CODEC_P1_REG48_ADC_MIC1RP_SEL_MASK | \
		CODEC_P1_REG48_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg49:ADC Input Selection for M-Terminal */
	{
		0, 1, 49, \
		CODEC_P1_REG49_MIC1LM_SEL_10KR_VAL, \
		CODEC_P1_REG49_ADC_CM_SEL_MASK | CODEC_P1_REG49_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg50:Input CM Setting */
	{
		0, 1, 50, \
		0, \
		CODEC_P1_REG50_MIC1_TO_CM_MASK
	},
	/* page0 reg81:ADC Digital Mic  0x80 */
	{
		0, 0, 81, \
		CODEC_P0_REG81_ADC_PWON_VAL | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_1FS_VAL, \
		CODEC_P0_REG81_ADC_PW_MASK | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_CTRL_MASK
	},
	/* page0 reg82:ADC Digital Volume Control Fine Adjust */
	{
		0, 0, 82, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_0DB_VAL, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_MASK
	},
	/* page0 reg83:ADC Digital Volume Control Coarse Adjust */
	{
		0, 0, 83, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_0DB_VAL, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_MASK
	}
};

/* use for mic1lpMic1lm */
static T_Codec_Reg_Para  speakerInPathPara[] = {
	/* page1 reg47:MIC PGA 0x14 */
	{
		0, 1, 47, \
		CODEC_P1_REG47_MICPGA_CTRL_BY_D06_VAL | CODEC_P1_REG47_MICPGA_10DB_VAL, \
		CODEC_P1_REG47_MICPGA_CTRL_MASK | CODEC_P1_REG47_MICPGA_GAIN_MASK
	},
	/* page1 reg48:Delta-Sigma Mono ADC Channel Fine-Gain Input Selection for P-Terminal 0x40 */
	{
		0, 1, 48, \
		CODEC_P1_REG48_MIC1LP_SEL_10KR_VAL, \
		CODEC_P1_REG48_ADC_MIC1LP_SEL_MASK | CODEC_P1_REG48_ADC_MIC1RP_SEL_MASK | \
		CODEC_P1_REG48_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg49:ADC Input Selection for M-Terminal */
	{
		0, 1, 49, \
		CODEC_P1_REG49_MIC1LM_SEL_10KR_VAL, \
		CODEC_P1_REG49_ADC_CM_SEL_MASK | CODEC_P1_REG49_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg50:Input CM Setting */
	{
		0, 1, 50, \
		0, \
		CODEC_P1_REG50_MIC1_TO_CM_MASK
	},
	/* page0 reg81:ADC Digital Mic  0x80 */
	{
		0, 0, 81, \
		CODEC_P0_REG81_ADC_PWON_VAL | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_1FS_VAL, \
		CODEC_P0_REG81_ADC_PW_MASK | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_CTRL_MASK
	},
	/* page0 reg82:ADC Digital Volume Control Fine Adjust */
	{
		0, 0, 82, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_0DB_VAL, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_MASK
	},
	/* page0 reg83:ADC Digital Volume Control Coarse Adjust */
	{
		0, 0, 83, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_0DB_VAL, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_MASK
	}
};

 T_Codec_Reg_Para  inPathResetPara[] = {
	/* page1 reg47:MIC PGA 0x14 */
	{
		0, 1, 47, \
		CODEC_P1_REG47_MICPGA_UNCTRL_BY_D06_VAL | CODEC_P1_REG47_MICPGA_0DB_VAL, \
		CODEC_P1_REG47_MICPGA_CTRL_MASK | CODEC_P1_REG47_MICPGA_GAIN_MASK
	},
	/* page1 reg48:Delta-Sigma Mono ADC Channel Fine-Gain Input Selection for P-Terminal 0x40 */
	{
		0, 1, 48, \
		CODEC_P1_REG48_MIC1LP_UNSEL_VAL | CODEC_P1_REG48_MIC1RP_UNSEL_VAL | CODEC_P1_REG48_MIC1LM_UNSEL_VAL, \
		CODEC_P1_REG48_ADC_MIC1LP_SEL_MASK | CODEC_P1_REG48_ADC_MIC1RP_SEL_MASK | \
		CODEC_P1_REG48_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg49:ADC Input Selection for M-Terminal */
	{
		0, 1, 49, \
		CODEC_P1_REG49_CM_UNSEL_VAL | CODEC_P1_REG49_MIC1LM_UNSEL_VAL, \
		CODEC_P1_REG49_ADC_CM_SEL_MASK | CODEC_P1_REG49_ADC_MIC1LM_SEL_MASK
	},
	/* page0 reg81:ADC Digital Mic  0x80 */
	{
		0, 0, 81, \
		CODEC_P0_REG81_ADC_PWOFF_VAL | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_1FS_VAL, \
		CODEC_P0_REG81_ADC_PW_MASK | CODEC_P0_REG81_ADC_VOLCTRL_SSTEP_CTRL_MASK
	},
	/* page0 reg82:ADC Digital Volume Control Fine Adjust */
	{
		0, 0, 82, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_0DB_VAL, \
		CODEC_P0_REG82_ADC_DIGVOL_FINE_MASK
	},
	/* page0 reg83:ADC Digital Volume Control Coarse Adjust */
	{
		0, 0, 83, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_0DB_VAL, \
		CODEC_P0_REG83_ADC_DIGVOL_COARSE_MASK
	}
};

/* fm  analog loop input channel */
static T_Codec_Reg_Para  fmAnalogInPathPara[] = {
	/* page1 reg46: MICBIAS 0x0a */
	{
		0, 1, 46, \
		CODEC_P1_REG46_MICBIAS_PWON_CTRL2_VAL | CODEC_P1_REG46_MICBIAS_OUT_PW2V_VAL, \
		CODEC_P1_REG46_MICBIAS_PWON_CTRL_MASK | CODEC_P1_REG46_MICBIAS_OUT_CTRL_MASK
	} ,
	/* page1 reg47:MIC PGA 0x14 */
	{
		0, 1, 47, \
		CODEC_P1_REG47_MICPGA_CTRL_BY_D06_VAL | CODEC_P1_REG47_MICPGA_20DB_VAL, \
		CODEC_P1_REG47_MICPGA_CTRL_MASK | CODEC_P1_REG47_MICPGA_GAIN_MASK
	},
	/* page1 reg48:Delta-Sigma Mono ADC Channel Fine-Gain Input Selection for P-Terminal 0x40 */
	{
		0, 1, 48, \
		CODEC_P1_REG48_MIC1LP_SEL_10KR_VAL | CODEC_P1_REG48_MIC1RP_SEL_10KR_VAL, \
		CODEC_P1_REG48_ADC_MIC1LP_SEL_MASK | CODEC_P1_REG48_ADC_MIC1RP_SEL_MASK | \
		CODEC_P1_REG48_ADC_MIC1LM_SEL_MASK
	},
	/* page1 reg49:ADC Input Selection for M-Terminal */
	{
		0, 1, 49, \
		CODEC_P1_REG49_MIC1LM_SEL_10KR_VAL, \
		CODEC_P1_REG49_ADC_CM_SEL_MASK | CODEC_P1_REG49_ADC_MIC1LM_SEL_MASK
	}
};

static T_Codec_Reg_Para headsetFmAnalogOutPathPara[] = {
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWON_VAL | \
		CODEC_P1_REG31_HPR_PWON_VAL , \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		0x06, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL | CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL | \
		CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK

	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_VAL | CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK | \
		CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_TO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_TO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		0x7f, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL | CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};

static T_Codec_Reg_Para speakerFmAnalogOutPathPara[] = {
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		0x04, \
		0xff
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		CODEC_P1_REG32_WRITE_ONLY_VAL | CODEC_P1_REG32_SPKPM_PWON_VAL, \
		CODEC_P1_REG32_WRITE_ONLY_VAL_MASK | CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		0x3e, \
		0xff
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_VAL | CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK | \
		CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		0x7f, \
		0xff
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		0x7f, \
		0xff
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		CODEC_P1_REG38_LAVOL_TO_SPK_VAL | CODEC_P1_REG38_LAVOL_CTRL_FORSPK_0DB_VAL, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		0x02, \
		0xff
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		0x02, \
		0xff
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_18DB_VAL | CODEC_P1_REG42_SPK_DRV_UNMUTE_VAL, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_MASK | CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		0x00, \
		0xff
	}
};

/* use for HP */
static T_Codec_Reg_Para receiverOutPathPara_voice[] = {
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		0x06, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LDATA_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LDATA_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/* page0 reg65:DAC Left Volume Control DIGITAL (1DB-> 2DB) */
	{
		0, 0, 65, \
		CODEC_P0_REG65_DAC_LCHN_VOL_1DB_VAL, \
		CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	/* page0 reg66:DAC Right Volume Control DIGITAL (1DB-> 2DB) */
	{
		0, 0, 66, \
		CODEC_P0_REG66_DAC_RCHN_VOL_1DB_VAL, \
		CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL | CODEC_P1_REG33_HPDRI_PWON_76_2MS_VAL | \
		CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control*/
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_LCHN_MIXER_VAL | CODEC_P1_REG35_DACR_ROUTE_RCHN_MIXER_VAL | \
		CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_TO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_TO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		0x7f, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver Analog(6DB -> 5DB max 8) */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_7DB_VAL | CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver Analog(6DB -> 5DB max 8)*/
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_7DB_VAL | CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	},
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWON_VAL | \
		CODEC_P1_REG31_HPR_PWON_VAL , \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	}
};

static T_Codec_Reg_Para receiverOutPathPara[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL*/
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/*
	//page0 reg65:DAC Left Volume Control
	{   0,0,65,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_3DB_VAL,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	//page0 reg66:DAC Right Volume Control
	{   0,0,66,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_3DB_VAL,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	*/
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWON_VAL | \
		CODEC_P1_REG31_HPR_PWON_VAL , \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		0x06, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL | CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL | \
		CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_HPL_DRV_VAL |  CODEC_P1_REG35_DACR_ROUTE_HPR_DRV_VAL | \
		CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_TO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_TO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		0x7f, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL | CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};

/*use for HP*/
static T_Codec_Reg_Para headsetOutPathPara_voice[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LDATA_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LDATA_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_DIS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/* page0 reg65:DAC Left Volume Control */
	{
		0, 0, 65, \
		CODEC_P0_REG65_DAC_LCHN_VOL_12DB_VAL, \
		CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	/* page0 reg66:DAC Right Volume Control */
	{
		0, 0, 66, \
		CODEC_P0_REG66_DAC_RCHN_VOL_12DB_VAL, \
		CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWON_VAL | \
		CODEC_P1_REG31_HPR_PWON_VAL , \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		0x06, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL | CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL | \
		CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_HPL_DRV_VAL |  CODEC_P1_REG35_DACR_ROUTE_HPR_DRV_VAL | \
		CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_TO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_TO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		0x7f, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL | CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};

static T_Codec_Reg_Para headsetOutPathPara[] = {
	/* page0 reg63: DAC Data-Path Setup  */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/*
    //page0 reg65:DAC Left Volume Control
    {   0,0,65,\
        CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_3DB_VAL,\
        CODEC_P0_REG65_DAC_LCHN_VOL_MASK
    },
    //page0 reg66:DAC Right Volume Control
    {   0,0,66,\
        CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_3DB_VAL,\
        CODEC_P0_REG66_DAC_RCHN_VOL_MASK
    },
    */
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWON_VAL | \
		CODEC_P1_REG31_HPR_PWON_VAL , \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		0x06, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL | CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL | \
		CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_HPL_DRV_VAL |  CODEC_P1_REG35_DACR_ROUTE_HPR_DRV_VAL | \
		CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_TO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_TO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		0x7f, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL | CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};

static T_Codec_Reg_Para headsetAndSpeakerOutPathPara[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/*
	{   0,0,65,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_6DB_VAL,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	{   0,0,66,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_6DB_VAL,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	*/
	/* page1 reg31:	Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWON_VAL | \
		CODEC_P1_REG31_HPR_PWON_VAL , \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		CODEC_P1_REG32_WRITE_ONLY_VAL | CODEC_P1_REG32_SPKPM_PWON_VAL, \
		CODEC_P1_REG32_WRITE_ONLY_VAL_MASK | CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:	HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_AFT_VAL | CODEC_P1_REG33_HPDRI_PWON_15_3MS_VAL | \
		CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_LCHN_MIXER_VAL | CODEC_P1_REG35_DACR_ROUTE_RCHN_MIXER_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_TO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_0DB_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_TO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_0DB_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		CODEC_P1_REG38_LAVOL_TO_SPK_VAL | CODEC_P1_REG38_LAVOL_CTRL_FORSPK_0DB_VAL, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_UNMUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_UNMUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL | CODEC_P1_REG42_SPK_DRV_UNMUTE_VAL, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_MASK | CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | \
		CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};

static T_Codec_Reg_Para outPathResetPara[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWOFF_VAL | CODEC_P0_REG63_LDAC_EQU_LDATA_VAL | CODEC_P0_REG63_RDAC_PWOFF_VAL | \
		CODEC_P0_REG63_RDAC_EQU_RDATA_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/*
	//page0 reg65:DAC Left Volume Control
	{   0,0,65,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_0DB_VAL,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	//page0 reg66:DAC Right Volume Control
	{   0,0,66,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_0DB_VAL,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	*/
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWOFF_VAL | CODEC_P1_REG31_HPL_PWOFF_VAL, \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		CODEC_P1_REG32_SPKPM_PWOFF_VAL, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_SIMU_VAL | CODEC_P1_REG33_HPDRI_PWON_304MS_VAL | CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_0MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_NONE_VAL | CODEC_P1_REG35_MIC1LP_INPUT_UNROUTE_LCHN_VAL | \
		CODEC_P1_REG35_MIC1RP_INPUT_UNROUTE_RCHN_VAL | CODEC_P1_REG35_DACR_ROUTE_NONE_VAL | \
		CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK | \
		CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_UNTO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_MUTE_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_UNTO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_MUTE_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		CODEC_P1_REG38_LAVOL_UNTO_SPK_VAL | CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MUTE_VAL, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_MUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_MUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL | CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};

static T_Codec_Reg_Para outPathResetPara_voice[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWOFF_VAL | CODEC_P0_REG63_LDAC_EQU_LDATA_VAL | CODEC_P0_REG63_RDAC_PWOFF_VAL | \
		CODEC_P0_REG63_RDAC_EQU_RDATA_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/* page0 reg65:DAC Left Volume Control */
	{
		0, 0, 65, \
		CODEC_P0_REG65_DAC_LCHN_VOL_0DB_VAL, \
		CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	/* page0 reg66:DAC Right Volume Control */
	{
		0, 0, 66, \
		CODEC_P0_REG66_DAC_RCHN_VOL_0DB_VAL, \
		CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		CODEC_P1_REG31_HP_OUT_1_35V_VAL | CODEC_P1_REG31_HPL_PWOFF_VAL | CODEC_P1_REG31_HPL_PWOFF_VAL, \
		CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK | \
		CODEC_P1_REG31_HPR_PW_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		CODEC_P1_REG32_SPKPM_PWOFF_VAL, \
		CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		CODEC_P1_REG33_HPDRI_REVSEQ_SIMU_VAL | CODEC_P1_REG33_HPDRI_PWON_304MS_VAL | CODEC_P1_REG33_HPDRI_RAMPUP_3_9MS_VAL, \
		CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | \
		CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_0MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_NONE_VAL | CODEC_P1_REG35_MIC1LP_INPUT_UNROUTE_LCHN_VAL | \
		CODEC_P1_REG35_MIC1RP_INPUT_UNROUTE_RCHN_VAL | CODEC_P1_REG35_DACR_ROUTE_NONE_VAL | \
		CODEC_P1_REG35_HPL_OUTPUT_UNROUTE_HPR_DRV_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_MIC1LP_INPUT_ROUTE_LCHN_MIXER_MASK | \
		CODEC_P1_REG35_MIC1RP_INPUT_ROUTE_RCHN_MIXER_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK | \
		CODEC_P1_REG35_HPL_OUTUT_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		CODEC_P1_REG36_LAVOL_UNTO_HPL_VAL | CODEC_P1_REG36_LAVOL_CTRL_FORHPL_MUTE_VAL, \
		CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		CODEC_P1_REG37_RAVOL_UNTO_HPR_VAL | CODEC_P1_REG37_RAVOL_CTRL_FORHPR_MUTE_VAL, \
		CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		CODEC_P1_REG38_LAVOL_UNTO_SPK_VAL | CODEC_P1_REG38_LAVOL_CTRL_FORSPK_MUTE_VAL, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		CODEC_P1_REG40_HPL_DRV_PGA_0DB_VAL | CODEC_P1_REG40_HPL_DRV_MUTE_VAL, \
		CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK | CODEC_P1_REG40_HPL_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		CODEC_P1_REG41_HPR_DRV_PGA_0DB_VAL | CODEC_P1_REG41_HPR_DRV_MUTE_VAL, \
		CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK | CODEC_P1_REG41_HPR_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_MUTE_VAL | CODEC_P1_REG42_SPK_DRV_SGAIN_6DB_VAL, \
		CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK | CODEC_P1_REG42_SPK_DRV_SGAIN_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_0US_VAL | CODEC_P1_REG44_HPL_DRV_AS_HEADPHONE_VAL | CODEC_P1_REG44_HPR_DRV_AS_HEADPHONE_VAL, \
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};
#if 0
static UINT8 outPathParaMask[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | \
		CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK},
	/* page0 reg65:DAC Left Volume Control */
	{CODEC_P0_REG65_DAC_LCHN_VOL_MASK},
	/* page0 reg66:DAC Right Volume Control */
	{CODEC_P0_REG66_DAC_RCHN_VOL_MASK},
	/* page1 reg31:  Headphone Drivers */
	{CODEC_P1_REG31_HP_OUT_VOL_MASK | CODEC_P1_REG31_HPL_PW_MASK},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{CODEC_P1_REG32_SPKPM_PW_MASK},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{CODEC_P1_REG33_HPDRI_REVSEQ_MASK | CODEC_P1_REG33_HPDRI_PWON_TIME_MASK | CODEC_P1_REG33_HPDRI_RAMPUP_TIME_MASK },
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK},
	/* page1 reg36: Left Analog Vol to HPL */
	{CODEC_P1_REG36_LAVOL_TO_HPL_CTRL_MASK | CODEC_P1_REG36_LAVOL_HPL_GAIN_MASK},
	/* page1 reg37: Right Analog Vol to HPR */
	{CODEC_P1_REG37_RAVOL_TO_HPR_CTRL_MASK | CODEC_P1_REG37_RAVOL_HPR_GAIN_MASK},
	/* page1 reg38: Left Analog Vol to SPK */
	{CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK},
	/* page1 reg39: Reserved */
	{0x00},
	/* page1 reg40: HPL Driver */
	{CODEC_P1_REG40_HPL_DRV_PGA_CTRL_MASK},
	/* page1 reg41: HPR Driver */
	{CODEC_P1_REG41_HPR_DRV_PGA_CTRL_MASK},
	/* page1 reg42: SPK Driver */
	{CODEC_P1_REG42_SPK_DRV_SGAIN_MASK },
	/* page1 reg43: Reserved */
	{0x00},
	/* page1 reg44: HP Driver Control */
	{
		CODEC_P1_REG44_HP_DRV_DEBOUNCE_US_CTRL_MASK | CODEC_P1_REG44_HPL_DRV_AS_CTRL_MASK | \
		CODEC_P1_REG44_HPR_DRV_AS_CTRL_MASK
	}
};
#endif
/* use for SPK */
static T_Codec_Reg_Para speakerOutPathPara_voice[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LDATA_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LDATA_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_DIS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/* page0 reg65:DAC Left Volume Control */
	{
		0, 0, 65, \
		CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_1DB5_VAL, \
		CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	/* page0 reg66:DAC Right Volume Control */
	{
		0, 0, 66, \
		CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_1DB5_VAL, \
		CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		0x04, \
		0xff
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		CODEC_P1_REG32_WRITE_ONLY_VAL | CODEC_P1_REG32_SPKPM_PWON_VAL, \
		CODEC_P1_REG32_WRITE_ONLY_VAL_MASK | CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		0x3e, \
		0xff
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_LCHN_MIXER_VAL | CODEC_P1_REG35_DACR_ROUTE_RCHN_MIXER_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		0x7f, \
		0xff
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		0x7f, \
		0xff
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		CODEC_P1_REG38_LAVOL_TO_SPK_VAL | CODEC_P1_REG38_LAVOL_CTRL_FORSPK_0DB_VAL, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		0x02, \
		0xff
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		0x02, \
		0xff
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_18DB_VAL | CODEC_P1_REG42_SPK_DRV_UNMUTE_VAL, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_MASK | CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		0x00, \
		0xff
	}
};

 UINT8 speakerOutIirHpfPara[2][20] = {
	/* Sample Rate16000Hz,   IIR Cut Freq  1000Hz */
	/* page8 reg2: Left DAC FILTER MSBs OF N0 Coefficient */
	0x7f,
	/* page8 reg3: Left DAC FILTER LSBs OF N0 Coefficient */
	0xff,
	/* page8 reg4: Left DAC FILTER MSBs OF N1 Coefficient */
	0x80,
	/* page8 reg5: Left DAC FILTER LSBs OF N1 Coefficient */
	0x01,
	/* page8 reg6: Left DAC FILTER MSBs OF N2 Coefficient */
	0x7f,
	/* page8 reg7: Left DAC FILTER LSBs OF N2 Coefficient */
	0xff,
	/* page8 reg8: Left DAC FILTER MSBs OF D1 Coefficient */
	0x5d,
	/* page8 reg9: Left DAC FILTER LSBs OF D1 Coefficient */
	0x98,
	/* page8 reg10: Left DAC FILTER MSBs OF D2 Coefficient */
	0xb5,
	/* page8 reg11: Left DAC FILTER LSBs OF D2 Coefficient */
	0xe0,
	/* page8 reg66: Right DAC FILTER MSBs OF N0 Coefficient */
	0x7f,
	/* page8 reg67: Right DAC FILTER LSBs OF N0 Coefficient */
	0xff,
	/* page8 reg68:  Right DAC  FILTER MSBs OF N1 Coefficient */
	0x80,
	/* page8 reg69: Right DAC  FILTER LSBs OF N1 Coefficient */
	0x01,
	/* page8 reg70: Right DAC  FILTER MSBs OF N2 Coefficient */
	0x7f,
	/* page8 reg71: Right DAC FILTER LSBs OF N2 Coefficient */
	0xff,
	/* page8 reg72: Right DAC FILTER MSBs OF D1 Coefficient */
	0x5d,
	/* page8 reg73: Right DAC FILTER MSBs OF D1 Coefficient */
	0x98,
	/* page8 reg74: Right DAC FILTER MSBs OF D2 Coefficient */
	0xb5,
	/* page8 reg75: Right DAC FILTER LSBs OF D2 Coefficient */
	0xe0,
	
	/* Sample Rate:44100Hz,   IIR Cut Freq  1000Hz */
	/* page8 reg2: Left DAC FILTER MSBs OF N0 Coefficient */
	0x7f,
	/* page8 reg3: Left DAC FILTER LSBs OF N0 Coefficient */
	0xff,
	/* page8 reg4: Left DAC FILTER MSBs OF N1 Coefficient */
	0x80,
	/* page8 reg5: Left DAC FILTER LSBs OF N1 Coefficient */
	0x01,
	/* page8 reg6: Left DAC FILTER MSBs OF N2 Coefficient */
	0x7f,
	/* page8 reg7: Left DAC FILTER LSBs OF N2 Coefficient */
	0xff,
	/* page8 reg8: Left DAC FILTER MSBs OF D1 Coefficient */
	0x73,
	/* page8 reg9: Left DAC FILTER LSBs OF D1 Coefficient */
	0x43,
	/* page8 reg10: Left DAC FILTER MSBs OF D2 Coefficient */
	0x97,
	/* page8 reg11: Left DAC FILTER LSBs OF D2 Coefficient */
	0x28,
	/* page8 reg66: Right DAC FILTER MSBs OF N0 Coefficient */
	0x7f,
	/* page8 reg67: Right DAC FILTER LSBs OF N0 Coefficient */
	0xff,
	/* page8 reg68:	Right DAC  FILTER MSBs OF N1 Coefficient */
	0x80,
	/* page8 reg69: Right DAC  FILTER LSBs OF N1 Coefficient */
	0x01,
	/* page8 reg70: Right DAC  FILTER MSBs OF N2 Coefficient */
	0x7f,
	/* page8 reg71: Right DAC FILTER LSBs OF N2 Coefficient */
	0xff,
	/*page8 reg72: Right DAC FILTER MSBs OF D1 Coefficient */
	0x73,
	/* page8 reg73: Right DAC FILTER MSBs OF D1 Coefficient */
	0x43,
	/* page8 reg74: Right DAC FILTER MSBs OF D2 Coefficient */
	0x97,
	/* page8 reg75: Right DAC FILTER LSBs OF D2 Coefficient */
	0x28
};

static T_Codec_Reg_Para speakerOutPathPara[] = {
	/* page0 reg63: DAC Data-Path Setup */
	{
		0, 0, 63, \
		/* bits */
		CODEC_P0_REG63_LDAC_PWON_VAL | CODEC_P0_REG63_LDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_RDAC_PWON_VAL | \
		CODEC_P0_REG63_RDAC_EQU_LRMIXER_VAL | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_1FS_VAL, \
		/* mask */
		CODEC_P0_REG63_LDAC_PW_MASK | CODEC_P0_REG63_LDAC_EQU_CTRL_MASK | CODEC_P0_REG63_RDAC_PW_MASK | \
		CODEC_P0_REG63_RDAC_EQU_CTRL_MASK | CODEC_P0_REG63_DAC_VOLCTR_SSTEP_CTRL_MASK
	},
	/* page0 reg64:DAC VOLUME CONTROL */
	{
		0, 0, 64, \
		/* bits */
		CODEC_P0_REG64_DAC_LRCHN_VOLCTRL_INDEP_VAL, \
		/* mask */
		CODEC_P0_REG64_DAC_RCHN_VOLCTRL_MASK
	},
	/*
	//page0 reg65:DAC Left Volume Control
	{   0,0,65,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_MINUS_3DB_VAL,\
	    CODEC_P0_REG65_DAC_LCHN_VOL_MASK
	},
	//page0 reg66:DAC Right Volume Control
	{   0,0,66,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_MINUS_3DB_VAL,\
	    CODEC_P0_REG66_DAC_RCHN_VOL_MASK
	},
	*/
	/* page1 reg31:  Headphone Drivers */
	{
		0, 1, 31, \
		0x04, \
		0xff
	},
	/* page1 reg34:  Output Driver PGA Ramp-Down Period Control */
	{
		0, 1, 34, \
		CODEC_P1_REG34_SPK_PWON_WAIT_19_8MS_VAL, \
		CODEC_P1_REG34_SPK_PWON_WAIT_MS_CTRL_MASK
	},
	/* page1 reg32:   Class-D Speaker Amplifier */
	{
		0, 1, 32, \
		CODEC_P1_REG32_WRITE_ONLY_VAL | CODEC_P1_REG32_SPKPM_PWON_VAL, \
		CODEC_P1_REG32_WRITE_ONLY_VAL_MASK | CODEC_P1_REG32_SPKPM_PW_MASK
	},
	/* page1 reg33:  HP Output Drivers POP Removal Settings */
	{
		0, 1, 33, \
		0x3e, \
		0xff
	},
	/* page1 reg35:  DAC_L and DAC_R Output Mixer Routing */
	{
		0, 1, 35, \
		CODEC_P1_REG35_DACL_ROUTE_LCHN_MIXER_VAL | CODEC_P1_REG35_DACR_ROUTE_RCHN_MIXER_VAL, \
		CODEC_P1_REG35_DACL_ROUTE_CTRL_MASK | CODEC_P1_REG35_DACR_ROUTE_CTRL_MASK
	},
	/* page1 reg36: Left Analog Vol to HPL */
	{
		0, 1, 36, \
		0x7f, \
		0xff
	},
	/* page1 reg37: Right Analog Vol to HPR */
	{
		0, 1, 37, \
		0x7f, \
		0xff
	},
	/* page1 reg38: Left Analog Vol to SPK */
	{
		0, 1, 38, \
		CODEC_P1_REG38_LAVOL_TO_SPK_VAL | CODEC_P1_REG38_LAVOL_CTRL_FORSPK_0DB_VAL, \
		CODEC_P1_REG38_LAVOL_TO_SPK_CTRL_MASK | CODEC_P1_REG38_LAVOL_SPK_GAIN_MASK
	},
	/* page1 reg40: HPL Driver */
	{
		0, 1, 40, \
		0x02, \
		0xff
	},
	/* page1 reg41: HPR Driver */
	{
		0, 1, 41, \
		0x02, \
		0xff
	},
	/* page1 reg42: SPK Driver */
	{
		0, 1, 42, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_18DB_VAL | CODEC_P1_REG42_SPK_DRV_UNMUTE_VAL, \
		CODEC_P1_REG42_SPK_DRV_SGAIN_MASK | CODEC_P1_REG42_SPK_DRV_MUTE_CTRL_MASK
	},
	/* page1 reg44: HP Driver Control */
	{
		0, 1, 44, \
		0x00, \
		0xff
	}
};



/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/

/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/


/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
SINT32 zDrvCodec_GetInPathParaInfo(T_CodecPathParaInfo *pathinfo,T_ZDrvCodec_InDevice dev,BOOL onoff)
{
    if(onoff) {
		switch(dev) {
            case AUDIO_INPUT_HANDSET:  
                pathinfo->pRegPara = handsetInPathPara;
                pathinfo->arraySize = sizeof(handsetInPathPara)/sizeof(T_Codec_Reg_Para);
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInPath AUDIO_INPUT_HANDSET!\n");
                break;
            case AUDIO_INPUT_HEADSET:  
	            pathinfo->pRegPara = headsetInPathPara;
                pathinfo->arraySize = sizeof(headsetInPathPara)/sizeof(T_Codec_Reg_Para);
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInPath AUDIO_INPUT_HEADSET!\n");
                break;
            case AUDIO_INPUT_SPEAKER:
                pathinfo->pRegPara = speakerInPathPara;
                pathinfo->arraySize = sizeof(speakerInPathPara)/sizeof(T_Codec_Reg_Para);
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInPath AUDIO_INPUT_SPEAKER!\n");
                break;
            case AUDIO_INPUT_FM_ANATODIG:
				pathinfo->pRegPara = fmAnalogInPathPara;
				pathinfo->arraySize = sizeof(fmAnalogInPathPara) / sizeof(T_Codec_Reg_Para);
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInPath AUDIO_INPUT_FM_ANATODIG!\n");
                break;
            default:
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInPath device not support!\n");
                return DRV_ERROR;
        }
       
    }else {
			pathinfo->pRegPara = inPathResetPara;
			pathinfo->arraySize = sizeof(inPathResetPara) / sizeof(T_Codec_Reg_Para);
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetInPath off dev=%d,!\n", dev);
		}
	 return DRV_SUCCESS;

}
SINT32 zDrvCodec_GetOutPathParaInfo(T_CodecPathParaInfo *pathinfo,T_ZDrvCodec_OutDevice dev,T_ZDrvCodec_SourceType sourcetype,BOOL onoff)
{
	 if(onoff) {
		switch (dev) {
            case AUDIO_OUTPUT_HEADSET:				
				if (sourcetype == VOICE_SOURCE) 
				{
	                pathinfo->pRegPara = headsetOutPathPara_voice;
	                pathinfo->arraySize = sizeof(headsetOutPathPara_voice)/sizeof(T_Codec_Reg_Para);
	                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec Voice SetOutPath AUDIO_OUTPUT_HEADSET!\n ");
				}
				else
				{
	                pathinfo->pRegPara = headsetOutPathPara;
	                pathinfo->arraySize = sizeof(headsetOutPathPara)/sizeof(T_Codec_Reg_Para);
	                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath AUDIO_OUTPUT_HEADSET!\n ");
				}
                break;
            case AUDIO_OUTPUT_SPEAKER:
				if (sourcetype == VOICE_SOURCE) 
				{
	                pathinfo->pRegPara = speakerOutPathPara_voice;
	                pathinfo->arraySize = sizeof(speakerOutPathPara_voice)/sizeof(T_Codec_Reg_Para);
	                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec Voice SetOutPath AUDIO_OUTPUT_SPEAKER!\n ");
				}
				else
				{
	                pathinfo->pRegPara = speakerOutPathPara;
	                pathinfo->arraySize = sizeof(speakerOutPathPara)/sizeof(T_Codec_Reg_Para);
	                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath AUDIO_OUTPUT_SPEAKER!\n ");
				}
                break;
            case AUDIO_OUTPUT_RECEIVER://LOUT  connect to headset
				if (sourcetype == VOICE_SOURCE) 
				{
	                pathinfo->pRegPara = receiverOutPathPara_voice; //lineoutOutPathPara_voice
	                pathinfo->arraySize = sizeof(receiverOutPathPara_voice)/sizeof(T_Codec_Reg_Para);
	                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec Voice SetOutPath AUDIO_OUTPUT_RECEIVER!\n ");
				}
				else
				{
	                pathinfo->pRegPara = receiverOutPathPara; //lineoutOutPathPara_voice
	                pathinfo->arraySize = sizeof(receiverOutPathPara)/sizeof(T_Codec_Reg_Para);
	                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath AUDIO_OUTPUT_RECEIVER!\n ");
				}
                break;
            
            case AUDIO_OUTPUT_FM_ANATOANA_HEADSET:
				pathinfo->pRegPara = headsetFmAnalogOutPathPara;
				pathinfo->arraySize = sizeof(headsetFmAnalogOutPathPara) / sizeof(T_Codec_Reg_Para);
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath AUDIO_OUTPUT_FM_ANATOANA_HEADSET!\n");
                break;
			
            case AUDIO_OUTPUT_HEADSET_SPEAKER:
				pathinfo->pRegPara  = headsetAndSpeakerOutPathPara;
				pathinfo->arraySize = sizeof(headsetAndSpeakerOutPathPara) / sizeof(T_Codec_Reg_Para);
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath AUDIO_OUTPUT_HEADSET_SPEAKER!\n");
                break;
            case AUDIO_OUTPUT_FM_ANATODIG_SPEAKER:
				pathinfo->pRegPara = speakerFmAnalogOutPathPara;
				pathinfo->arraySize = sizeof(speakerFmAnalogOutPathPara) / sizeof(T_Codec_Reg_Para);
				zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath AUDIO_OUTPUT_FM_ANATOANA_SPEAKER!\n");
                break;
           // case AUDIO_OUTPUT_FM_ANATOANA_HEADSET:
           //     break;
           // case AUDIO_OUTPUT_FM_ANATOANA_SPEAKER:
           //     break;
			//case AUDIO_OUTPUT_BLUETOOTH:
            //    break;
            default:
                zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath device not support!\n");
                return DRV_ERROR;
        }
 	}else{
			if (sourcetype == VOICE_SOURCE) 
			{
                pathinfo->pRegPara = outPathResetPara_voice; 
                pathinfo->arraySize = sizeof(outPathResetPara_voice)/sizeof(T_Codec_Reg_Para);
			}
			else
			{
                pathinfo->pRegPara = outPathResetPara; 
                pathinfo->arraySize = sizeof(outPathResetPara)/sizeof(T_Codec_Reg_Para);
			}
			zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "codec SetOutPath off dev=%d,!\n", dev);

	}	
    return DRV_SUCCESS;

}


#endif




