/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Header file for path control
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_path_control.h
 *   Version: \main\18
 *   Date: 2007-10-02 09:08:14
 *   Responsible: soerenek
 *   Comment:
 *     merged steon changes
 */

#if !defined (_AUD_PATH_CONTROL_H_)
#define _AUD_PATH_CONTROL_H_

//#define  STEON2_PROJECT;//huojishan 2008.01.01

/*******************************************************************************
*
*                              Type definitions
*
*******************************************************************************/
typedef enum { /* 5bit resolution for gain_lna1 and gain_lna2 in afe_tx_ctrl1 (SGold3) */
    afe_0db_gain, /* 0 */
    afe_3db_gain,
    afe_6db_gain,
    afe_9db_gain,
    afe_12db_gain,
    afe_15db_gain, /* 5 */
    afe_18db_gain,
    afe_21db_gain,
    afe_24db_gain,
    afe_27db_gain,
    afe_30db_gain, /* 10 */
    afe_33db_gain,
    afe_36db_gain,
    afe_39db_gain,
    afe_42db_gain,
    afe_45db_gain, /* 15 */
    afe_48db_gain,
    afe_gain_end
} aud_path_afe_tx_gain_enum;

typedef struct {
    u8 path[aud_uplink_source_end+1]; //aud_uplink_source_enum
    S16 total;
} aud_path_uplink_buffer_type;

typedef struct {
    u8 path[aud_downlink_source_end+1]; //aud_downlink_source_enum
    S16 total;
} aud_path_downlink_buffer_type;

typedef struct { /* don't care result type - reflects actual aud_data structure */
    aud_uplink_parms_type    uplink_parms;
    aud_downlink_parms_type  downlink_parms;
} aud_path_settings_result_type; /* used to store the path setting - from don't care concept */

/*******************************************************************************
*
*                          Externally visible variables
*
*******************************************************************************/
extern aud_path_settings_result_type aud_path_settings_result; /* used to store the path setting - from don't care concept */

/*******************************************************************************
*
*             Public functions implemented in aud_path_control.c
*
*******************************************************************************/
BOOL aud_path_dispatcher(aud_event_enum event, void* p_data); /* dispatcher */
void aud_path_init(void);
void aud_enable_path_and_resource(aud_resource_enum res, aud_SM_state_enum state, BOOL use_power);
void aud_disable_path_and_resource(aud_resource_enum res, aud_SM_state_enum state, BOOL use_power);
void aud_program_afe_rx_gain(unsigned char gain);
#ifdef STEON2_PROJECT
void aud_setup_i2s1_vb_on_parameters(U16 csel, U16 den0, U16 den1, U16 num0, U16 num1, U16 rxconf, U16 txconf);
#else
void aud_setup_i2s1_vb_on_parameters(U16 csel, U16 den0, U16 den1, U16 num0, U16 num1, U16 rxconf, U16 txconf, U16 hwmode, U16 chnmode);
#endif
/* these functions could be private if it wasn't for the i2s implementation (BlueTooth production test) */
void aud_downlinkpath_update_buffers(U32 parm1,U32 parm2,U32 parm3,U32 parm4,U32 parm5,U32 parm6,U32 parm7,U32 parm8);
void aud_uplinkpath_update_buffers(U32 parm1,U32 parm2,U32 parm3,U32 parm4,U32 parm5,U32 parm6,U32 parm7,U32 parm8);
void aud_calculate_uplink_resulting_path(void);
void aud_calculate_downlink_resulting_path(void);
/* getter functions implemented in aud_path_control.c */
word aud_get_vb_on_ratesw(void);
U8   aud_get_number_of_active_uplink_paths(void);
U8   aud_get_number_of_active_downlink_paths(void);
aud_uplink_source_enum   aud_get_uplink_path_with_priority(U8 priority);
aud_downlink_source_enum aud_get_downlink_path_with_priority(U8 priority);

/*******************************************************************************
*
*               Public functions implemented in aud_path_tst.c
*
*******************************************************************************/
U32 aud_test_path_generic_func(void *p_function_request, BOOL *p_processed ); /* dispatcher for path-related opcodes (for testing) */

#endif

