/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  This source file contains functions for debug purposes.
 * Others:        
 * Version:       v0.1
 * Author:        knm
 * Date:          2005-11-08
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/


/****************************************************************************
*                                              Include files
****************************************************************************/
#include "uicc_stub.h"
    
#ifdef TRAP_HANDLING   
  #include "trap.h"
#endif
    
#include "uicc.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_drv.h"
#include "uicc_trc.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
#ifndef UICC_NO_DEBUG
  ubyte log_data[UICC_MAX_LOG_STORE_SIZE+1];

  ubyte *UICC_log_data_ptr = &log_data[1];
  /* Pointer for storing debug information in connection with exception 
     or TRAP handling. Note that the first byte is used to store the local 
     ID number and can as such not be used for debug information. */
#endif

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
* Function:... UICC_raise_exception
* Parameters:. trap_id:  The identification number defined in trap.h.
*              local_id: Local identification number defined in uicc_trc.h 
* Returns:.... 
* Description: Function for raising an exception (non fatal logging of suspicious
*              scenario.
* Created:.... 19.11.02 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
#ifndef UICC_NO_DEBUG
void UICC_raise_exception(ushort  trap_id,
                          ubyte   local_id,
                          ubyte   log_data_size)
{
#ifdef TRAP_HANDLING   
  ushort size;

  if(log_data_size > (TRAP_MAX_SIZEOF_LOG_DATA-1))
    size = (TRAP_MAX_SIZEOF_LOG_DATA-1);
  else
    size = log_data_size;
 
  log_data[0] = local_id;
  TRAP_store_exception(trap_id, size+1, &log_data[0]);
#else
  trap_id = local_id;  
#endif  
}
#endif

/*******************************************************************************
* Function:... UICC_raise_exception
* Parameters:. trap_id:  The identification number defined in trap.h.
*              local_id: Local identification number defined in uicc_trc.h 
* Returns:.... None.
* Description: Function for raising an exception (non fatal logging of suspicious
*              scenario.
* Created:.... 19.11.02 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
#ifndef UICC_NO_DEBUG
void UICC_generate_sw_trap(ushort  trap_id, 
                           ubyte   local_id,
                           ubyte   log_data_size)
{
#ifdef TRAP_HANDLING
  ushort size;

  if(log_data_size > (TRAP_MAX_SIZEOF_LOG_DATA-1))
    size = (TRAP_MAX_SIZEOF_LOG_DATA-1);
  else
    size = log_data_size;

  log_data[0] = local_id;
  memcpy(&TRAP_log_data[1], &log_data[0], size+1);
  TRAP_envoke_sw_trap(trap_id);
#else
  trap_id = local_id;  
#endif  
}
#endif

                                                 /* End of file.              */
