/* ANP: Assumption: host system defines 'XENV' and 'SDL_SIMULATION'. This is true in UMTS case. */
/* To find the 'else' and 'endif' clause search for: 'SDTENV && SDL_SIMULATION'                   */

/******************************************************************************
*
*                               (C) Danish Wireless Design
*
* $RCSfile: sctpred.h,v $
*
* $Author: pbo $
* $Revision: 1.4 $
* $Date: 2001/07/18 13:01:54 $
*
* Description:
*
*******************************************************************************/

#ifndef X_SCTPRED_H
#define X_SCTPRED_H


/* This file contains implementation of the predefined data types
   except PId. The functions defined here can be found in the file
   sctpred.c.
*/

/*
FILE INDEX
00   Some utility macros
01   Typedef, Default value, Literals
02   Prototypes and macros for the operators of the data types
03   Read and Write functions
04   Generator String
05   Generator Array  (array that cannot become array in C)
06   Generator Powerset  (limited and discrete component type)
07   Generator Powerset  (general component type)
*/

/****+***************************************************************
00   Some utility macros
********************************************************************/

/* Macros used in the generator implementations */

#ifndef XENUM_TYPE
#define XENUM_TYPE int
#endif

#ifndef XNOUSE_OPFUNCS
#define T_SDL_OPFUNCS(P) , P
#else
#define T_SDL_OPFUNCS(P)
#endif


#ifdef XECSOP
#define xReportStringError(S1,S2)   xSDLOpError(S1,S2);
#else
#define xReportStringError(S1,S2)
#endif


/****+***************************************************************
01   Typedef, Default value, Literals
********************************************************************/
/****+***************************************************************
     NEW FOR TAU 4.2
********************************************************************/
/*
FILE INDEX
01   Assignment macros
02   SDL predefined data types
03   Utility functions
04   Read and Write functions
*/

#ifndef xOffsetOf
#define xOffsetOf(type, field)  ((xptrint) &((type *) 0)->field)
#endif

/****+***************************************************************
     Type info nodes
********************************************************************/
/*---+---------------------------------------------------------------
     Boolean
-------------------------------------------------------------------*/
/*xlb20080717
#if !defined(X_COMPACT_BOOL)
typedef int     SDL_boolean;
#else
typedef unsigned char     SDL_boolean;
#endif
*/
#define xDef_SDL_Boolean(V)       (*(V) = (SDL_Boolean)0)
#define yDef_SDL_Boolean(V)       xDef_SDL_Boolean(V)
#define yAssF_SDL_Boolean(V,E,A)  (V = E)
#define yEqF_SDL_Boolean(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Boolean(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Boolean         xSrtN_SDL_Boolean

#define SDL_False 0
#define SDL_false 0
#define SDL_True  1
#define SDL_true  1


/*---+---------------------------------------------------------------
     Character
-------------------------------------------------------------------*/

typedef char    SDL_Character;
typedef char    SDL_character;

#define xDef_SDL_Character(V)       (*(V) = '\000')
#define yDef_SDL_Character(V)       xDef_SDL_Character(V)
#define yAssF_SDL_Character(V,E,A)  (V = E)
#define yEqF_SDL_Character(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Character(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Character         xSrtN_SDL_Character

/* predefined literals for non-printable characters,
   other literals as in C */
#define SDL_NUL '\000'
#define SDL_SOH '\001'
#define SDL_STX '\002'
#define SDL_ETX '\003'
#define SDL_EOT '\004'
#define SDL_ENQ '\005'
#define SDL_ACK '\006'
#define SDL_BEL '\007'
#define SDL_BS  '\010'
#define SDL_HT  '\011'
#define SDL_LF  '\012'
#define SDL_VT  '\013'
#define SDL_FF  '\014'
#define SDL_CR  '\015'
#define SDL_SO  '\016'
#define SDL_SI  '\017'
#define SDL_DLE '\020'
#define SDL_DC1 '\021'
#define SDL_DC2 '\022'
#define SDL_DC3 '\023'
#define SDL_DC4 '\024'
#define SDL_NAK '\025'
#define SDL_SYN '\026'
#define SDL_ETB '\027'
#define SDL_CAN '\030'
#define SDL_EM  '\031'
#define SDL_SUB '\032'
#define SDL_ESC '\033'
#define SDL_IS4 '\034'
#define SDL_IS3 '\035'
#define SDL_IS2 '\036'
#define SDL_IS1 '\037'
#define SDL_DEL '\177'
#define SDL_E_NUL '\200'
#define SDL_E_SOH '\201'
#define SDL_E_STX '\202'
#define SDL_E_ETX '\203'
#define SDL_E_EOT '\204'
#define SDL_E_ENQ '\205'
#define SDL_E_ACK '\206'
#define SDL_E_BEL '\207'
#define SDL_E_BS  '\210'
#define SDL_E_HT  '\211'
#define SDL_E_LF  '\212'
#define SDL_E_VT  '\213'
#define SDL_E_FF  '\214'
#define SDL_E_CR  '\215'
#define SDL_E_SO  '\216'
#define SDL_E_SI  '\217'
#define SDL_E_DLE '\220'
#define SDL_E_DC1 '\221'
#define SDL_E_DC2 '\222'
#define SDL_E_DC3 '\223'
#define SDL_E_DC4 '\224'
#define SDL_E_NAK '\225'
#define SDL_E_SYN '\226'
#define SDL_E_ETB '\227'
#define SDL_E_CAN '\230'
#define SDL_E_EM  '\231'
#define SDL_E_SUB '\232'
#define SDL_E_ESC '\233'
#define SDL_E_IS4 '\234'
#define SDL_E_IS3 '\235'
#define SDL_E_IS2 '\236'
#define SDL_E_IS1 '\237'


/*---+---------------------------------------------------------------
     Null
-------------------------------------------------------------------*/

typedef LONG     SDL_Null;

#define xDef_SDL_Null(V)       (*(V) = (SDL_Null)0)
#define yDef_SDL_Null(V)       xDef_SDL_Null(V)
#define yAssF_SDL_Null(V,E,A)  (V = E)
#define yEqF_SDL_Null(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Null(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Null         xSrtN_SDL_Null

#define SDL_NullValue  0

#ifndef ANY_SDL_Null
#define ANY_SDL_Null           (SDL_Null)0
#endif




/*---+---------------------------------------------------------------
     Charstring
-------------------------------------------------------------------*/

typedef CHAR   *SDL_Charstring;
typedef CHAR   *SDL_charstring;


#define xDef_SDL_Charstring(V)       (*(V) = (SDL_Charstring)0)
#define yDef_SDL_Charstring(V)       xDef_SDL_Charstring(V)
#define yAssF_SDL_Charstring(V,E,A) (V = E)
#define yEqF_SDL_Charstring(E1,E2)   xEq_SDL_Charstring(E1,E2)
#define yNEqF_SDL_Charstring(E1,E2)  (! xEq_SDL_Charstring(E1,E2))
#define ySrtN_SDL_Charstring         xSrtN_SDL_Charstring

#define SDL_CHARSTRING_LIT(P1, P2)   P1


/*---+---------------------------------------------------------------
     Duration
-------------------------------------------------------------------*/
#if 0
#ifndef _TIMESPEC_
#define _TIMESPEC_
typedef long      timespec;
#endif
#endif
//typedef SDL_Duration  SDL_duration;

/*Name:KangShuJie Date:2008.01.25 Reason:windowsWaring̫*/
#ifdef _OS_WIN
extern SDL_Duration SDL_Duration_Lit(SINT32 s, SINT32 ns);
#endif
/*End KangShuJie*/
#define xDef_SDL_Duration(V)      ( *(V) = 0)
#define yDef_SDL_Duration(V)       xDef_SDL_Duration(V)
#define yAssF_SDL_Duration(V,E,A) (V = E)
#define yEqF_SDL_Duration(E1,E2)   xEq_SDL_Duration(E1,E2)
#define yNEqF_SDL_Duration(E1,E2)  (! xEq_SDL_Duration(E1,E2))
#define ySrtN_SDL_Duration         xSrtN_SDL_Duration

#define SDL_DURATION_LIT(R,I,D)    SDL_Duration_Lit(I,D)

/*Date:2008-2-19  Name: Dongzhi  Reason:GSMTUΪUMTSTU*/
//xlb20080717#define CLOCK_TICK       10000000
//#define CLOCK_TICK       4615385      /* TDMA frame duration in ns */
#define TDMA_CLOCK_TICK  4615385      /* TDMA frame duration in ns */
#define SDT_TICKPERSEC   217          /* well, actually: 216,66664861111261574061535494872 */


/*---+---------------------------------------------------------------
     Integer
-------------------------------------------------------------------*/

#if !defined(X_LONG_INT)
typedef LONG  SDL_Integer;
typedef LONG  SDL_integer;
#else
typedef LONG  SDL_Integer;
typedef LONG  SDL_integer;
#endif

#define xDef_SDL_Integer(V)       (*(V) = (SDL_Integer)0)
#define yDef_SDL_Integer(V)       xDef_SDL_Integer(V)
#define yAssF_SDL_Integer(V,E,A)  (V = E)
#define yEqF_SDL_Integer(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Integer(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Integer         xSrtN_SDL_Integer

#define SDL_INTEGER_LIT(I)        I
/* Literals as in C */

#ifdef XVALIDATOR
#define xMax_SDL_Integer 2147483647
#endif


/*---+---------------------------------------------------------------
     Natural
-------------------------------------------------------------------*/

#if !defined(X_LONG_INT)
typedef LONG  SDL_Natural;
typedef LONG  SDL_natural;
#else
typedef LONG  SDL_Natural;
typedef LONG  SDL_natural;
#endif

#define xDef_SDL_Natural(V)       (*(V) = (SDL_Natural)0)
#define yDef_SDL_Natural(V)       xDef_SDL_Natural(V)
#define yAssF_SDL_Natural(V,E,A)  (V = E)
#define yEqF_SDL_Natural(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Natural(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Natural         xSrtN_SDL_Natural


/*---+---------------------------------------------------------------
     PId
-------------------------------------------------------------------*/

#define ySrtN_SDL_PId             xSrtN_SDL_PId
/* see sctsdl.c and scttypes.h for implementation of PId */


#ifndef XNOUSEOFREAL
/*---+---------------------------------------------------------------
     Real
-------------------------------------------------------------------*/

typedef double   SDL_Real;
typedef double   SDL_real;

#define xDef_SDL_Real(V)       (*(V) = 0.0)
#define yDef_SDL_Real(V)       xDef_SDL_Real(V)
#define yAssF_SDL_Real(V,E,A)  (V = E)
#define yEqF_SDL_Real(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Real(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Real         xSrtN_SDL_Real

#define SDL_REAL_LIT(R,I,D)    R
/* Literals as in C */
#endif


/*---+---------------------------------------------------------------
     Time
-------------------------------------------------------------------*/


//typedef SDL_Time  SDL_time;

#define xDef_SDL_Time(V)       (*(V) = SDL_Time_Lit(0, 0))
#define yDef_SDL_Time(V)       xDef_SDL_Time(V)
#define yAssF_SDL_Time(V,E,A)  (V = E)
#define yEqF_SDL_Time(E1,E2)   xEq_SDL_Time(E1,E2)
#define yNEqF_SDL_Time(E1,E2)  (! xEq_SDL_Time(E1,E2))
#define ySrtN_SDL_Time         xSrtN_SDL_Time

#define SDL_TIME_LIT(R,I,D)    SDL_Duration_Lit(I,D)
#define SDL_Time_Lit(I,D)      SDL_Duration_Lit(I,D)

#ifdef XVALIDATOR
extern SDL_Time xMaxTime;
#endif




/*---+---------------------------------------------------------------
     ASN1 coder and generic data model
-------------------------------------------------------------------*/

/* These types are used by the generic data model, but also by the SDL
   encoders/decoders in the old data model */

typedef enum
{
  /*SDL - standard types*/
  type_SDL_Integer=128,
  type_SDL_Real=129,
  type_SDL_Natural=130,
  type_SDL_Boolean=131,
  type_SDL_Character=132,
  type_SDL_Time=133,
  type_SDL_Duration=134,
  type_SDL_Pid=135,
  type_SDL_Charstring=136,
  type_SDL_Bit=137,
  type_SDL_Bit_string=138,
  type_SDL_Octet=139,
  type_SDL_Octet_string=140,
  type_SDL_IA5String=141,
  type_SDL_NumericString=142,
  type_SDL_PrintableString=143,
  type_SDL_VisibleString=144,
  type_SDL_NULL=145,
  type_SDL_Object_identifier=146,

  /* SDL - standard ctypes */
  type_SDL_ShortInt=150,
  type_SDL_LongInt=151,
  type_SDL_UnsignedShortInt=152,
  type_SDL_UnsignedInt=153,
  type_SDL_UnsignedLongInt=154,
  type_SDL_Float=155,
  type_SDL_Charstar=156,
  type_SDL_Voidstar=157,
  type_SDL_Voidstarstar=158,

  /* SDL - user defined types */
  type_SDL_Syntype=170,
  type_SDL_Inherits=171,
  type_SDL_Enum=172,
  type_SDL_Struct=173,
  type_SDL_Union=174,
  type_SDL_UnionC=175,
  type_SDL_Choice=176,
  type_SDL_ChoicePresent=177,
  type_SDL_Powerset=178,
  type_SDL_GPowerset=179,
  type_SDL_Bag=180,
  type_SDL_String=181,
  type_SDL_LString=182,
  type_SDL_Array=183,
  type_SDL_Carray=184,
  type_SDL_GArray=185,
  type_SDL_Own=186,
  type_SDL_Oref=187,
  type_SDL_Ref=188,
  type_SDL_Userdef=189,
  type_SDL_EmptyType=190,
  type_SDL_ComBuf=191,

  /* SDL - signals */
  type_SDL_Signal=200,
  type_SDL_SignalId=201

} tSDLTypeClass;




#ifndef T_CONST
#define T_CONST const
#endif

#ifndef T_SDL_EXTRA_COMP
#define T_SDL_EXTRA_COMP
#define T_SDL_EXTRA_VALUE
#endif

#ifndef T_SDL_USERDEF_COMP
#define T_SDL_USERDEF_COMP
#endif

#ifdef T_SDL_NAMES
#define T_SDL_Names(P) , P
#else
#define T_SDL_Names(P)
#endif

#ifdef T_SIGNAL_SDL_NAMES
#define T_Signal_SDL_Names(P) , P
#else
#define T_Signal_SDL_Names(P)
#endif

#ifdef T_SDL_INFO
#define T_SDL_Info(P) , P
#else
#define T_SDL_Info(P)
#endif

#define NEEDSFREE(P)    (((tSDLTypeInfo *)(P))->OpNeeds & (unsigned char)1)
#define NEEDSEQUAL(P)   (((tSDLTypeInfo *)(P))->OpNeeds & (unsigned char)2)
#define NEEDSASSIGN(P)  (((tSDLTypeInfo *)(P))->OpNeeds & (unsigned char)4)


/* Types used to represent a general String and GPowerset. */
typedef struct xString_ystruct  *xString_yptr;
typedef struct xString_ystruct {
  xString_yptr  Suc;
  int           Data;
} xString_yrec;
typedef struct {
  xString_yptr  First;
  xString_yptr  Last;
  int           Length;
  int           IsAssigned;
} xString_Type;

struct tSDLFuncInfo;

/* ------- General type information for SDL types ------- */
typedef T_CONST struct tSDLTypeInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
#ifndef XNOUSE_OPFUNCS
  struct tSDLFuncInfo *OpFuncs;
#endif
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
#ifdef XREADANDWRITEF
  xIdNode         FatherScope;
  xSortIdNode     SortIdNode;
#endif
} tSDLTypeInfo;


/* ------------------ Enumeration type ------------------ */

typedef T_CONST struct {
  int             LiteralValue;
  char           *LiteralName;
} tSDLEnumLiteralInfo;

typedef T_CONST struct tSDLEnumInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
#ifndef XNOUSE_OPFUNCS
  struct tSDLFuncInfo *OpFuncs;
#endif
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
#ifdef XREADANDWRITEF
  xIdNode         FatherScope;
  xSortIdNode     SortIdNode;
#endif
  tSDLTypeInfo   *CompOrFatherSort;
#ifdef XREADANDWRITEF
  int             NoOfLiterals;
  tSDLEnumLiteralInfo *LiteralList;
#endif
} tSDLEnumInfo;

/* ---------- Syntype, Inherits, Own, Oref, Ref --------- */
typedef T_CONST struct tSDLGenInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLTypeInfo   *CompOrFatherSort;
} tSDLGenInfo;


/* ---------------------- Powerset ---------------------- */
typedef T_CONST struct tSDLPowersetInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLTypeInfo   *CompSort;
  int             Length;
  int             LowestValue;
} tSDLPowersetInfo;


/* ----------------------- Struct ----------------------- */
typedef int (*tGetFunc) XPP((void *));
typedef void (*tAssFunc) XPP((void *, int));

typedef T_CONST struct {
  xptrint         OffsetPresent; /* 0 if not optional */
  void           *DefaultValue;
} tSDLFieldOptInfo;

typedef T_CONST struct {
  tGetFunc        GetTag;
  tAssFunc        AssTag;
} tSDLFieldBitFInfo;


typedef T_CONST struct {
  tSDLTypeInfo   *CompSort;
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  xptrint         Offset;        /* ~0 for bitfield */
  tSDLFieldOptInfo *ExtraInfo;
} tSDLFieldInfo;

typedef T_CONST struct tSDLStructInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLFieldInfo  *Components;
  int             NumOfComponents;
} tSDLStructInfo;


/* -------------------- Choice, Union ------------------- */
typedef T_CONST struct {
  tSDLTypeInfo        *CompSort;
#ifdef T_SDL_NAMES
  char                *Name;
#endif
} tSDLChoiceFieldInfo;

typedef T_CONST struct tSDLChoiceInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLChoiceFieldInfo *Components;
  int                  NumOfComponents;
  xptrint              OffsetToUnion;
  xptrint              TagSortSize;
} tSDLChoiceInfo;


/* ------------------- Array, CArray -------------------- */
typedef T_CONST struct tSDLArrayInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLTypeInfo   *CompSort;
  int             Length;
} tSDLArrayInfo;


/* ----------------------- GArray ----------------------- */
typedef T_CONST struct tSDLGArrayInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLTypeInfo   *IndexSort;
  tSDLTypeInfo   *CompSort;
  xptrint         yrecSize;
  xptrint         yrecIndexOffset;
  xptrint         yrecDataOffset;
  xptrint         arrayDataOffset;
} tSDLGArrayInfo;


/* ----- GPowerset, Bag, String, Object_Identifier ------ */
typedef T_CONST struct tSDLGenListInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLTypeInfo   *CompSort;
  xptrint         yrecSize;
  xptrint         yrecDataOffset;
} tSDLGenListInfo;


/* ---------------------- LString ----------------------- */
typedef T_CONST struct tSDLLStringInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  tSDLTypeInfo   *CompSort;
  int             MaxLength;
  xptrint         DataOffset;
} tSDLLStringInfo;


/* ---------------------- Userdef ----------------------- */
/* used for user defined types #ADT(T(h)) */
typedef T_CONST struct tSDLUserdefInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SDL_NAMES
  char           *Name;
#endif
  T_SDL_USERDEF_COMP
} tSDLUserdefInfo;


/* ----------------------- Signal ----------------------- */
typedef T_CONST struct {
  tSDLTypeInfo       *ParaSort;
  xptrint             Offset;
} tSDLSignalParaInfo;

typedef T_CONST struct tSDLSignalInfoS {
  tSDLTypeClass   TypeClass;
  unsigned char   OpNeeds;
  xptrint         SortSize;
  struct tSDLFuncInfo *OpFuncs;
  T_SDL_EXTRA_COMP
#ifdef T_SIGNAL_SDL_NAMES
  char           *Name;
#endif
  tSDLSignalParaInfo *Param;
  int             NoOfPara;
} tSDLSignalInfo;

typedef struct tSDLFuncInfo {
  void *(*AssFunc) XPP((void *, void *, int));
  SDL_Boolean (*EqFunc) XPP((void *, void *));
  void (*FreeFunc) XPP((void **));
} tSDLFuncInfo;


/* Types used to represent a general Bag. */
typedef struct xBag_ystruct  *xBag_yptr;
typedef struct xBag_ystruct {
  xBag_yptr     Suc;
  int           NoOfItems;
  int           Data;
} xBag_yrec;
typedef struct {
  xBag_yptr     First;
  xBag_yptr     Last;
  int           Length;
  int           IsAssigned;
} xBag_Type;


extern tSDLTypeInfo ySDL_SDL_Integer;
extern tSDLTypeInfo ySDL_SDL_Real;
extern tSDLTypeInfo ySDL_SDL_Natural;
extern tSDLTypeInfo ySDL_SDL_Boolean;
extern tSDLTypeInfo ySDL_SDL_Character;
extern tSDLTypeInfo ySDL_SDL_Time;
extern tSDLTypeInfo ySDL_SDL_Duration;
extern tSDLTypeInfo ySDL_SDL_PId;
extern tSDLTypeInfo ySDL_SDL_Charstring;
extern tSDLTypeInfo ySDL_SDL_Bit;
extern tSDLTypeInfo ySDL_SDL_Bit_String;
extern tSDLTypeInfo ySDL_SDL_Octet;
extern tSDLTypeInfo ySDL_SDL_Octet_String;
extern tSDLTypeInfo ySDL_SDL_IA5String;
extern tSDLTypeInfo ySDL_SDL_NumericString;
extern tSDLTypeInfo ySDL_SDL_PrintableString;
extern tSDLTypeInfo ySDL_SDL_VisibleString;
extern tSDLTypeInfo ySDL_SDL_Null;
extern tSDLGenListInfo ySDL_SDL_Object_Identifier;

/* End section with type info nodes */

extern LONG         GenericGetValue   XPP((DWORD, VOID *));
extern VOID        GenericSetValue   XPP((DWORD, VOID *, LONG));


/****+***************************************************************
01
********************************************************************/

/* Macros used in assign functions */

/* XASS_1_2_3 should be read:
1 = AC  : always copy
1 = MR  : may reuse (take pointer if temporary object)
1 = AR  : always reuse (take pointer)
2 = ASS : new object assigned to "variable"
2 = TMP : new object temporary
3 = FR  : call free for old value refered to by variable
3 = NF  : do not call free for old value
*/
#define XASS_AC_ASS_FR  (int)25  /* 1+8+16 */
#define XASS_MR_ASS_FR  (int)26  /* 2+8+16 */  /* = XASS */
#define XASS_AR_ASS_FR  (int)28  /* 4+8+16 */

#define XASS_AC_TMP_FR  (int)17  /* 1+0+16 */
#define XASS_MR_TMP_FR  (int)18  /* 2+0+16 */  /* = XASSMAKE */
#define XASS_AR_TMP_FR  (int)20  /* 4+0+16 */

#define XASS_AC_ASS_NF  (int)9   /* 1+8+0  */
#define XASS_MR_ASS_NF  (int)10  /* 2+8+0  */
#define XASS_AR_ASS_NF  (int)12  /* 4+8+0  */

#define XASS_AC_TMP_NF  (int)1   /* 1+0+0  */  /* = XASS2MAKE */
#define XASS_MR_TMP_NF  (int)2   /* 2+0+0  */  /* = XASSMAKE */
#define XASS_AR_TMP_NF  (int)4   /* 4+0+0  */

#define SHOULD_COPY(P)          (P & (int)1)
#define MAY_REUSE(P)            (P & (int)2)
#define SHOULD_REUSE(P)         (P & (int)4)
#define SHOULD_RESULT_BE_ASS(P) (P & (int)8)
#define SHOULD_FREE_OLD(P)      (P & (int)16)

#define SET_ASS_NF(P)           ((P & (int)15) | (int)8)
#define SET_NF(P)               (P & (int)15)



/*---+---------------------------------------------------------------
     Bit
-------------------------------------------------------------------*/

typedef BYTE SDL_Bit;

#define yAssF_SDL_Bit(V,E,A)  (V = E)
#define yEqF_SDL_Bit(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Bit(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Bit         xSrtN_SDL_Bit

#define SDL_BIT_LIT(I)        I

#define xNot_SDL_Bit(B)       (!(B))
#define xAnd_SDL_Bit(B1,B2)   ((B1)&(B2))
#define xOr_SDL_Bit(B1,B2)    ((B1)|(B2))
#define xXor_SDL_Bit(B1,B2)   ((B1)^(B2))
#define xImpl_SDL_Bit(B1,B2)  ((B1)<=(B2))

#ifndef ANY_SDL_Bit
#define ANY_SDL_Bit           (SDL_Bit)(GETINTRAND % 2)
#endif


/*---+---------------------------------------------------------------
     Octet
-------------------------------------------------------------------*/

typedef BYTE SDL_Octet;

#define xDef_SDL_Octet(V)       (*(V) = (SDL_Octet)0)
#define yAssF_SDL_Octet(V,E,A)  (V = E)
#define yEqF_SDL_Octet(E1,E2)   ((E1) == (E2))
#define yNEqF_SDL_Octet(E1,E2)  ((E1) != (E2))
#define ySrtN_SDL_Octet         xSrtN_SDL_Octet

extern SDL_Bit *yAddr_SDL_Octet XPP((SDL_Octet *, SDL_Integer));
extern SDL_Bit xExtr_SDL_Octet XPP((SDL_Octet, SDL_Integer));

#define xLT_SDL_Octet(B1,B2)  ((B1)<(B2))
#define xLE_SDL_Octet(B1,B2)  ((B1)<=(B2))
#define xGT_SDL_Octet(B1,B2)  ((B1)>(B2))
#define xGE_SDL_Octet(B1,B2)  ((B1)>=(B2))

#define xNot_SDL_Octet(B)       (SDL_Octet)(~(B))
#define xAnd_SDL_Octet(B1,B2)   ((B1)&(B2))
#define xOr_SDL_Octet(B1,B2)    ((B1)|(B2))
#define xXor_SDL_Octet(B1,B2)   ((B1)^(B2))
#define xImpl_SDL_Octet(B1,B2)  xNot_SDL_Octet(xAnd_SDL_Octet((B1),xNot_SDL_Octet(B2)))
#define xShiftL_SDL_Octet(B,I)  (SDL_Octet)(((B)<<(I)) & 0xFF)
#define xShiftR_SDL_Octet(B,I)  ((B)>>(I))
#define xPlus_SDL_Octet(B1,B2)  (SDL_Octet)(((B1)+(B2)) & 0xFF)
#define xMinus_SDL_Octet(B1,B2) (SDL_Octet)((B1)-(B2))
#define xMult_SDL_Octet(B1,B2)  (SDL_Octet)(((B1)*(B2)) & 0xFF)
#define xI2O_SDL_Octet(I)       (SDL_Octet)(I)
#define xO2I_SDL_Octet(B)       (SDL_Integer)(B)

#ifndef XEINTDIV
#define xDiv_SDL_Octet(B1,B2)   ((B1)/(B2))
#define xMod_SDL_Octet(B1,B2)   ((B1)%(B2))
#define xRem_SDL_Octet(B1,B2)   ((B1)%(B2))
#else
extern SDL_Octet xDiv_SDL_Octet XPP((SDL_Octet, SDL_Octet));
extern SDL_Octet xMod_SDL_Octet XPP((SDL_Octet, SDL_Octet));
extern SDL_Octet xRem_SDL_Octet XPP((SDL_Octet, SDL_Octet));
#endif

extern SDL_Octet xBitStr_SDL_Octet XPP((SDL_Charstring));
extern SDL_Octet xHexStr_SDL_Octet XPP((SDL_Charstring));

#ifndef ANY_SDL_Octet
#define ANY_SDL_Octet           (SDL_Octet)(GETINTRAND % 256)
#endif



#ifndef XNOUSEOFOCTETBITSTRING
/*---+---------------------------------------------------------------
     Bit_String
-------------------------------------------------------------------*/

typedef struct {
  int             Length;
  xbool           IsAssigned;
  unsigned char * Bits;
} SDL_Bit_String;

#define xDef_SDL_Bit_String(V) \
  {(*V).Length = 0; (*V).IsAssigned = (xbool)1; (*V).Bits = 0;}
#define yDef_SDL_Bit_String(V)       xDef_SDL_Bit_String(V)
#define yAssF_SDL_Bit_String(V,E,A)  xAss_SDL_Bit_String(&(V),E,A)
#define yEqF_SDL_Bit_String(E1,E2)   xEq_SDL_Bit_String(E1,E2)
#define yNEqF_SDL_Bit_String(E1,E2)  (! xEq_SDL_Bit_String(E1,E2))
#define ySrtN_SDL_Bit_String         xSrtN_SDL_Bit_String

#define yFree_SDL_Bit_String(P)  xFree_SDL_Bit_String(P)
extern void xAss_SDL_Bit_String XPP((SDL_Bit_String *, SDL_Bit_String, int));
extern SDL_Boolean xEq_SDL_Bit_String XPP((SDL_Bit_String, SDL_Bit_String));
extern void xFree_SDL_Bit_String XPP((void **));
extern SDL_Bit * yAddr_SDL_Bit_String XPP((SDL_Bit_String *, SDL_Integer));
extern SDL_Bit xExtr_SDL_Bit_String XPP((SDL_Bit_String, SDL_Integer));
extern SDL_Bit_String xNot_SDL_Bit_String XPP((SDL_Bit_String));
extern SDL_Bit_String xAnd_SDL_Bit_String XPP((SDL_Bit_String, SDL_Bit_String));
extern SDL_Bit_String xOr_SDL_Bit_String XPP((SDL_Bit_String, SDL_Bit_String));
extern SDL_Bit_String xXor_SDL_Bit_String XPP((SDL_Bit_String, SDL_Bit_String));
extern SDL_Bit_String xImpl_SDL_Bit_String XPP((SDL_Bit_String, SDL_Bit_String));
extern SDL_Bit_String xMkString_SDL_Bit_String XPP((SDL_Bit));
extern SDL_Integer xLength_SDL_Bit_String XPP((SDL_Bit_String));
extern SDL_Bit xFirst_SDL_Bit_String XPP((SDL_Bit_String));
extern SDL_Bit xLast_SDL_Bit_String XPP((SDL_Bit_String));
extern SDL_Bit_String xConcat_SDL_Bit_String XPP((SDL_Bit_String, SDL_Bit_String));
extern SDL_Bit_String xSubString_SDL_Bit_String XPP((SDL_Bit_String, SDL_Integer, SDL_Integer));
extern SDL_Bit_String xBitStr_SDL_Bit_String XPP((SDL_Charstring));

SDL_Bit_String xHexStr_SDL_Bit_String XPP((SDL_Charstring));



#ifndef ANY_SDL_Bit_String
#define ANY_SDL_Bit_String \
   xConcat_SDL_Bit_String \
     (xMkString_SDL_Bit_String(((unsigned char)(GETINTRAND%2))), \
      xMkString_SDL_Bit_String(((unsigned char)(GETINTRAND%2))) \
     )
#endif

#endif  /* XNOUSEOFOCTETBITSTRING */


#ifndef XNOUSEOFOCTETBITSTRING
/*---+---------------------------------------------------------------
     Octet_String
-------------------------------------------------------------------*/

/* An error in the implementation of Octet_String was introduced
   in SDT 3.2, when Octet_String was first supported.
   Octet_Strings should be indexed from 1, not from 0 as the
   SDL Suite implementation assumes. Note that Bit_Strings are indexed
   from 0. The inconsistancy between Octet_Strings and Bit_Strings
   in SDL is inherited from ASN.1.
   In SDT 3.6 this indexing error for Octet_Strings is corrected.
   To obtain the Octet_String behaviour from SDT3.2 - SDT3.5,
   OCTET_STRING_START_INDEX_0 should be defined, for example by
   uncommenting the #define below. It is not necessary to recompile
   the kernel for this to take effect.
   This change will effect the behaviour of indexing of
   Octet_Strings and the start parameter in operator SubString.
*/
/* #define OCTET_STRING_START_INDEX_0 */

typedef SDL_Bit_String SDL_Octet_String;

#define xDef_SDL_Octet_String(V) \
  {(*V).Length = 0; (*V).IsAssigned = (xbool)1; (*V).Bits = 0;}
#define yDef_SDL_Octet_String(V)       xDef_SDL_Octet_String(V)
#define yAssF_SDL_Octet_String(V,E,A)  xAss_SDL_Bit_String(&(V),E,A)
#define yEqF_SDL_Octet_String(E1,E2)   xEq_SDL_Bit_String(E1,E2)
#define yNEqF_SDL_Octet_String(E1,E2)  (! xEq_SDL_Bit_String(E1,E2))
#define ySrtN_SDL_Octet_String         xSrtN_SDL_Octet_String

#define yFree_SDL_Octet_String(P)  xFree_SDL_Bit_String(P)
#define xFree_SDL_Octet_String(P)  xFree_SDL_Bit_String(P)
#define xAss_SDL_Octet_String(V,E,A)  xAss_SDL_Bit_String(V,E,A)
#define xEq_SDL_Octet_String(V,E,A)  xEq_SDL_Bit_String(V,E,A)
#ifdef OCTET_STRING_START_INDEX_0
#define yAddr_SDL_Octet_String(B1,B2) yAddr_SDL_Bit_String(B1,B2)
#define xExtr_SDL_Octet_String(B1,B2) xExtr_SDL_Bit_String(B1,B2)
#else
#define yAddr_SDL_Octet_String(B1,B2) yAddr_SDL_Bit_String(B1,B2-1)
#define xExtr_SDL_Octet_String(B1,B2) xExtr_SDL_Bit_String(B1,B2-1)
#endif
#define xMkString_SDL_Octet_String(B)  xMkString_SDL_Bit_String(B)
#define xLength_SDL_Octet_String(B)  xLength_SDL_Bit_String(B)
#define xFirst_SDL_Octet_String(B)  xFirst_SDL_Bit_String(B)
#define xLast_SDL_Octet_String(B)  xLast_SDL_Bit_String(B)
#define xConcat_SDL_Octet_String(B1,B2)  xConcat_SDL_Bit_String(B1,B2)
#ifdef OCTET_STRING_START_INDEX_0
#define xSubString_SDL_Octet_String(B1,B2,B3)  xSubString_SDL_Bit_String(B1,B2,B3)
#else
#define xSubString_SDL_Octet_String(B1,B2,B3)  xSubString_SDL_Bit_String(B1,B2-1,B3)
#endif
extern SDL_Octet_String xBitStr_SDL_Octet_String XPP((SDL_Charstring));
extern SDL_Octet_String xHexStr_SDL_Octet_String XPP((SDL_Charstring));
extern SDL_Bit_String xBit_String_SDL_Octet_String XPP((SDL_Octet_String));
extern SDL_Octet_String xOctet_String_SDL_Octet_String XPP((SDL_Bit_String));

#ifndef ANY_SDL_Octet_String
#define ANY_SDL_Octet_String \
   xConcat_SDL_Octet_String \
     (xMkString_SDL_Octet_String(((unsigned char)(GETINTRAND%256))), \
      xMkString_SDL_Octet_String(((unsigned char)(GETINTRAND%256))) \
     )
#endif

#endif  /* XNOUSEOFOCTETBITSTRING */



/*---+---------------------------------------------------------------
     Object_Identifier
-------------------------------------------------------------------*/

typedef struct SDL_Object_Identifier_ystruct *SDL_Object_Identifier_yptr;
typedef struct SDL_Object_Identifier_ystruct {
  SDL_Object_Identifier_yptr Suc;
  SDL_Natural Data;
} SDL_Object_Identifier_yrec;
typedef struct {
  SDL_Object_Identifier_yptr First;
  SDL_Object_Identifier_yptr Last;
  int Length;
  int IsAssigned;
} SDL_Object_Identifier;

#define xDef_SDL_Object_Identifier(V) \
  {(*V).First = 0; (*V).Last = 0; (*V).Length = 0; (*V).IsAssigned = (xbool)1;}
#define yDef_SDL_Object_Identifier(V)       xDef_SDL_Object_Identifier(V)
#define yAssF_SDL_Object_Identifier(V,E,A)  yAss_SDL_Object_Identifier(&(V),E,A)
#define yEqF_SDL_Object_Identifier(E1,E2)   yEq_SDL_Object_Identifier(E1,E2)
#define yNEqF_SDL_Object_Identifier(E1,E2)  (! yEq_SDL_Object_Identifier(E1,E2))
#define ySrtN_SDL_Object_Identifier         xSrtN_SDL_Object_Identifier

extern SDL_Object_Identifier yEmptystring_SDL_Object_Identifier XPP((void));
extern SDL_Object_Identifier yMkString_SDL_Object_Identifier XPP((SDL_Natural));
extern SDL_Integer yLength_SDL_Object_Identifier XPP((SDL_Object_Identifier));
extern SDL_Natural yFirst_SDL_Object_Identifier XPP((SDL_Object_Identifier));
extern SDL_Natural yLast_SDL_Object_Identifier XPP((SDL_Object_Identifier));
extern SDL_Object_Identifier yConcat_SDL_Object_Identifier
    XPP((SDL_Object_Identifier, SDL_Object_Identifier));
extern SDL_Object_Identifier ySubString_SDL_Object_Identifier
    XPP((SDL_Object_Identifier, SDL_Integer, SDL_Integer));
extern SDL_Natural yExtr_SDL_Object_Identifier
    XPP((SDL_Object_Identifier, SDL_Integer));
extern SDL_Natural *yAddr_SDL_Object_Identifier
    XPP((SDL_Object_Identifier *, SDL_Integer));

extern void yAss_SDL_Object_Identifier
    XPP((SDL_Object_Identifier *, SDL_Object_Identifier, int));
extern SDL_Boolean yEq_SDL_Object_Identifier
    XPP((SDL_Object_Identifier, SDL_Object_Identifier));
extern void yFree_SDL_Object_Identifier XPP((void **));

#ifndef ANY_SDL_Object_Identifier
#define ANY_SDL_Object_Identifier  \
   yConcat_SDL_Object_Identifier(yMkString_SDL_Object_Identifier(ANY_SDL_Natural), \
     yMkString_SDL_Object_Identifier(ANY_SDL_Natural))
#endif


/*---+---------------------------------------------------------------
     GenericAssignSort
-------------------------------------------------------------------*/

extern void        GenericFreeSort   XPP((void **, tSDLTypeInfo *));
extern SDL_Boolean GenericEqualSort  XPP((void *, void *, tSDLTypeInfo *));
extern VOID *      GenericAssignSort XPP((VOID *, VOID *, LONG, tSDLTypeInfo *));
// #define GenericAssignSort(Addr,Expr,AssName,dummy)  *(Addr) = *(Expr)








/****+***************************************************************
02   Prototypes and macros for the operators of the data types
********************************************************************/

/*---+---------------------------------------------------------------
     yInit_Predefined
-------------------------------------------------------------------*/

#ifndef XOPTSORT
extern void yInit_Predefined XPP((void));
#endif


/*---+---------------------------------------------------------------
     Boolean
-------------------------------------------------------------------*/

#define xNot_SDL_Boolean(B)       (!(B))
#define xAnd_SDL_Boolean(B1,B2)   ((B1)&&(B2))
#define xOr_SDL_Boolean(B1,B2)    ((B1)||(B2))
#define xXor_SDL_Boolean(B1,B2)   ((B1)!=(B2))
#define xImpl_SDL_Boolean(B1,B2)  ((B1)<=(B2))
#define ANY_SDL_Boolean           (SDL_Boolean)(GETINTRAND % 2)

/*---+---------------------------------------------------------------
     Character
-------------------------------------------------------------------*/

#define xLT_SDL_Character(C1,C2)  ((C1)<(C2))
#define xLE_SDL_Character(C1,C2)  ((C1)<=(C2))
#define xGT_SDL_Character(C1,C2)  ((C1)>(C2))
#define xGE_SDL_Character(C1,C2)  ((C1)>=(C2))
#define xChr_SDL_Character(I)  ((SDL_Character)xMod_SDL_Integer(I,128))
#define xNum_SDL_Character(C)  ((SDL_Integer)C)
#define ANY_SDL_Character         xChr_SDL_Character(GETINTRAND)


/*---+---------------------------------------------------------------
     Charstring
-------------------------------------------------------------------*/

/*-- yFree_SDL_Charstring -----------------------------------------*/
#define yFree_SDL_Charstring(P)  xFree_SDL_Charstring(P)
extern void xFree_SDL_Charstring XPP((void **));
/* function in sctos.c */

/*-- xAss_SDL_Charstring ------------------------------------------*/
extern void xAss_SDL_Charstring  XPP((
  SDL_Charstring *CVar,
  SDL_Charstring  CExpr,
  int             AssType ));

/*-- xEq_SDL_Charstring -------------------------------------------*/
extern SDL_Boolean xEq_SDL_Charstring  XPP((
  SDL_Charstring C1,
  SDL_Charstring C2 ));

/*-- xMod_SDL_Charstring ------------------------------------------*/
/* No longer used by generated code */
extern SDL_Charstring xMod_SDL_Charstring XPP((
  SDL_Charstring  C,
  SDL_Integer     Index,
  SDL_Character   Value ));

/*-- yAddr_SDL_Charstring ------------------------------------------*/
extern SDL_Character * yAddr_SDL_Charstring XPP((
  SDL_Charstring *C,
  SDL_Integer     Index ));

/*-- xExtr_SDL_Charstring -----------------------------------------*/
extern SDL_Character xExtr_SDL_Charstring XPP((
  SDL_Charstring  C,
  SDL_Integer     Index ));

/*-- xMkString_SDL_Charstring -------------------------------------*/
extern SDL_Charstring xMkString_SDL_Charstring XPP((
  SDL_Character C ));

/*-- xLength_SDL_Charstring ---------------------------------------*/
extern SDL_Integer xLength_SDL_Charstring XPP((
  SDL_Charstring  C ));

/*-- xFirst_SDL_Charstring ----------------------------------------*/
extern SDL_Character xFirst_SDL_Charstring XPP((
  SDL_Charstring  C ));

/*-- xLast_SDL_Charstring -----------------------------------------*/
extern SDL_Character xLast_SDL_Charstring XPP((
  SDL_Charstring  C ));

/*-- xConcat_SDL_Charstring ---------------------------------------*/
extern SDL_Charstring xConcat_SDL_Charstring XPP((
  SDL_Charstring  C1,
  SDL_Charstring  C2 ));

/*-- xSubString_SDL_Charstring ------------------------------------*/
extern SDL_Charstring xSubString_SDL_Charstring XPP((
  SDL_Charstring  C,
  SDL_Integer     Start,
  SDL_Integer     SubLength ));

#define ANY_SDL_Charstring \
   xConcat_SDL_Charstring \
     (xMkString_SDL_Charstring( ((SDL_Character)(1+GETINTRAND%127)) ), \
      xMkString_SDL_Charstring( ((SDL_Character)(1+GETINTRAND%127)) ) \
     )


/*---+---------------------------------------------------------------
     Duration
-------------------------------------------------------------------*/

/*-- xPlus_SDL_Duration -------------------------------------------*/

#define xPlus_SDL_Duration(D1,D2) ((D1) + (D2))

/*-- xMinus_SDL_Duration ------------------------------------------*/

#define xMinus_SDL_Duration(D1,D2) ((D1) - (D2))

/*-- xMonMinus_SDL_Duration ---------------------------------------*/

#define xMonMinus_SDL_Duration(D) (-(D))

/*-- xMult_SDL_Duration -------------------------------------------*/
#ifndef XNOUSEOFREAL
extern SDL_Duration xMult_SDL_Duration  XPP((
  SDL_Duration D,
  SDL_Real     R ));
#endif

/*-- xMultRD_SDL_Duration -----------------------------------------*/
#define xMultRD_SDL_Duration(R,D) xMult_SDL_Duration(D, R)

/*-- xDiv_SDL_Duration --------------------------------------------*/
#ifndef XNOUSEOFREAL
extern SDL_Duration xDiv_SDL_Duration  XPP((
  SDL_Duration D,
  SDL_Real     R ));
#endif

#define xGT_SDL_Duration(P1, P2)  xLT_SDL_Time(P2, P1)
#define xGE_SDL_Duration(P1, P2)  xLE_SDL_Time(P2, P1)
#define xLT_SDL_Duration(P1, P2)  xLT_SDL_Time(P1, P2)
#define xLE_SDL_Duration(P1, P2)  xLE_SDL_Time(P1, P2)

/*-- xEq_SDL_Duration ---------------------------------------------*/

#define xEq_SDL_Duration(D1,D2) ((D1) == (D2))

#define ANY_SDL_Duration \
   SDL_Duration_Lit(GETINTRAND, GETINTRAND % 1000000000)


/*---+---------------------------------------------------------------
     Integer
-------------------------------------------------------------------*/

#define xMonMinus_SDL_Integer(I)   (-(I))
#define xPlus_SDL_Integer(I1,I2)   ((I1)+(I2))
#define xMinus_SDL_Integer(I1,I2)  ((I1)-(I2))
#define xMult_SDL_Integer(I1,I2)   ((I1)*(I2))

/*-- xDiv_SDL_Integer ---------------------------------------------*/
#ifdef XEINTDIV
extern SDL_Integer xDiv_SDL_Integer XPP((
  SDL_Integer  i,
  SDL_Integer  k ));
#else
#define xDiv_SDL_Integer(i,k) ((i)/(k))
#endif

/*-- xMod_SDL_Integer ---------------------------------------------*/
#define xMod_SDL_Integer(i_, k_) ((i_) % (k_))


/*-- xRem_SDL_Integer ---------------------------------------------*/
#ifdef XEINTDIV
extern SDL_Integer xRem_SDL_Integer XPP((
  SDL_Integer  i,
  SDL_Integer  k ));
#else
#define xRem_SDL_Integer(i,k) ((i)%(k))
#endif

#define xLT_SDL_Integer(I1,I2)  ((I1)<(I2))
#define xLE_SDL_Integer(I1,I2)  ((I1)<=(I2))
#define xGT_SDL_Integer(I1,I2)  ((I1)>(I2))
#define xGE_SDL_Integer(I1,I2)  ((I1)>=(I2))

/*-- xFix_SDL_Integer ---------------------------------------------*/
#ifdef XEFIXOF
extern SDL_Integer xFix_SDL_Integer XPP((
  SDL_Real     Re ));
#else
#define xFix_SDL_Integer(Re)   ((SDL_Integer)Re)
#endif

/* -- xFloat_SDL_Integer ------------------------------------------*/
#ifndef XNOUSEOFREAL
#define xFloat_SDL_Integer(I)   ((SDL_Real)I)
#endif

#define ANY_SDL_Integer         (SDL_Integer)(GETINTRAND - GETINTRAND_MAX/2)


/*---+---------------------------------------------------------------
     Natural
-------------------------------------------------------------------*/

/*-- xTest_SDL_Natural --------------------------------------------*/
#ifdef XTESTF
extern xbool xTest_SDL_Natural  XPP((
  void * N ));
#endif

/*-- xTstA_SDL_Natural --------------------------------------------*/
#ifdef XERANGE
extern SDL_Natural xTstA_SDL_Natural XPP(( SDL_Natural  N ));
#define yTstA_SDL_Natural(N)  xTstA_SDL_Natural(N)
#else
#define xTstA_SDL_Natural(N)  N
#define yTstA_SDL_Natural(N)  N
#endif

/*-- xTstI_SDL_Natural --------------------------------------------*/
#ifdef XEINDEX
extern SDL_Natural xTstI_SDL_Natural XPP(( SDL_Natural  N ));
#define yTstI_SDL_Natural(N)  xTstI_SDL_Natural(N)
#else
#define xTstI_SDL_Natural(N)  N
#define yTstI_SDL_Natural(N)  N
#endif

#define ANY_SDL_Natural         (SDL_Natural)(GETINTRAND)


/*---+---------------------------------------------------------------
     PId
-------------------------------------------------------------------*/

#define ANY_SDL_PId             SDL_NULL


/*---+---------------------------------------------------------------
     Real
-------------------------------------------------------------------*/

#define xMonMinus_SDL_Real(R)   (-(R))
#define xPlus_SDL_Real(R1,R2)   ((R1)+(R2))
#define xMinus_SDL_Real(R1,R2)  ((R1)-(R2))
#define xMult_SDL_Real(R1,R2)   ((R1)*(R2))

/*-- xDiv_SDL_Real ------------------------------------------------*/
#ifndef XNOUSEOFREAL
#ifdef XEREALDIV
extern SDL_Real xDiv_SDL_Real XPP((
  SDL_Real     i,
  SDL_Real     k ));
#else
#define xDiv_SDL_Real(i,k) ((i)/(k))
#endif
#endif

#define xLT_SDL_Real(R1,R2)  ((R1)<(R2))
#define xLE_SDL_Real(R1,R2)  ((R1)<=(R2))
#define xGT_SDL_Real(R1,R2)  ((R1)>(R2))
#define xGE_SDL_Real(R1,R2)  ((R1)>=(R2))

#define ANY_SDL_Real         (SDL_Real)(GETINTRAND - GETINTRAND_MAX/2)


/*---+---------------------------------------------------------------
     Time
-------------------------------------------------------------------*/

/*-- xPlus_SDL_Time -----------------------------------------------*/
#define xPlus_SDL_Time(P1, P2)  ((P1) + (P2))

/*-- xPlusDT_SDL_Time ---------------------------------------------*/
#define xPlusDT_SDL_Time(P1, P2)  ((P1) + (P2))

/*-- xMinusD_SDL_Time ---------------------------------------------*/
#define xMinusD_SDL_Time(P1, P2) ((P1) - (P2))

/*-- xMinusT_SDL_Time ---------------------------------------------*/
#define xMinusT_SDL_Time(P1, P2) ((P1) - (P2))

/*-- xEq_SDL_Time -------------------------------------------------*/
#define xEq_SDL_Time(P1, P2) ((P1) == (P2))

/*-- xLT_SDL_Time -------------------------------------------------*/
#define xLT_SDL_Time(T1, T2) ((T1) < (T2))

/*-- xLE_SDL_Time -------------------------------------------------*/
#define xLE_SDL_Time(T1, T2) ((T1) <= (T2))

/*-- xGT_SDL_Time -------------------------------------------------*/
#define xGT_SDL_Time(P1, P2) ((P1) > (P2))

/*-- xGE_SDL_Time -------------------------------------------------*/
#define xGE_SDL_Time(P1, P2) ((P1) >= (P2))

#define ANY_SDL_Time \
   SDL_Time_Lit(GETINTRAND, GETINTRAND % 1000000000)


/****+***************************************************************
03   Read and Write functions
********************************************************************/
#ifdef XREADANDWRITEF

/*-- xRead_SDL_Boolean --------------------------------------------*/
#define xRead_SDL_Boolean(Addr)  xReadSort(Addr, xSrtN_SDL_Boolean)

/*-- xWri_SDL_Boolean ---------------------------------------------*/
#define xWri_SDL_Boolean(Value)  xWriteSort(Value, xSrtN_SDL_Boolean)

/*-- xRead_SDL_Character ------------------------------------------*/
extern int xRead_SDL_Character XPP((void *));

/*-- xWri_SDL_Character -------------------------------------------*/
extern char * xWri_SDL_Character XPP((void *));

/*-- xRead_SDL_Charstring -----------------------------------------*/
extern int xRead_SDL_Charstring XPP((void *));

/*-- xWri_SDL_Charstring ------------------------------------------*/
extern char * xWri_SDL_Charstring XPP((void *));

/*-- xRead_SDL_Duration -------------------------------------------*/
extern int xRead_SDL_Duration XPP((void *));

/*-- xWri_SDL_Duration --------------------------------------------*/
extern char * xWri_SDL_Duration XPP((void *));

/*-- xRead_SDL_Integer --------------------------------------------*/
extern int xRead_SDL_Integer XPP((void *));

/*-- xWri_SDL_Integer ---------------------------------------------*/
extern char * xWri_SDL_Integer XPP((void *));

/*-- xRead_SDL_Real -----------------------------------------------*/
extern int xRead_SDL_Real XPP((void *));

/*-- xWri_SDL_Real ------------------------------------------------*/
extern char * xWri_SDL_Real XPP((void *));

/*-- xRead_SDL_Time -----------------------------------------------*/
extern int xRead_SDL_Time XPP((void *));

/*-- xWri_SDL_Time ------------------------------------------------*/
extern char * xWri_SDL_Time XPP((void *));



/* Help functions, also used by sctutil.c and sctmon.c */
/*-- xReadSDL_Time ------------------------------------------------*/
extern int xReadSDL_Time XPP((SDL_Time *));

/*-- xWriteSDL_Time -----------------------------------------------*/
extern char * xWriteSDL_Time XPP((SDL_Time, int));


#endif
   /* XREADANDWRITEF */



#ifndef XNO_LONG_MACROS

/****+***************************************************************
04   Generator String
********************************************************************/

/* typedef for String type ----------------------------------------*/

#define String_Type(SORT, COMPONENTSORT) \
   typedef struct XCAT(SORT,_ystruct)  * XCAT(SORT,_yptr); \
   typedef struct XCAT(SORT,_ystruct) { \
     XCAT(SORT,_yptr)   Suc; \
     COMPONENTSORT      Data; \
   } XCAT(SORT,_yrec); \
   typedef struct { \
     XCAT(SORT,_yptr) First; \
     XCAT(SORT,_yptr) Last; \
     int              Length; \
     xbool            IsAssigned; \
   } SORT;


/* String operator prototypes -------------------------------------*/

#define String_prototypes(SORT, COMPONENTSORT) \
  extern SORT XCAT(yEmptystring_,SORT) XPP((void)); \
  extern SORT XCAT(yMkString_,SORT) XPP((COMPONENTSORT)); \
  extern SDL_Integer XCAT(yLength_,SORT) XPP((SORT)); \
  extern COMPONENTSORT XCAT(yFirst_,SORT) XPP((SORT)); \
  extern COMPONENTSORT XCAT(yLast_,SORT) XPP((SORT)); \
  extern SORT XCAT(yConcat_,SORT) XPP((SORT, SORT)); \
  extern SORT XCAT(ySubString_,SORT) \
     XPP((SORT, SDL_Integer, SDL_Integer)); \
  extern COMPONENTSORT XCAT(yExtr_,SORT) XPP((SORT, SDL_Integer)); \
  extern COMPONENTSORT *XCAT(yAddr_,SORT) XPP((SORT *, SDL_Integer)); \
  \
  extern XCAT(SORT,_yptr)  XCAT(yGetAvail_,SORT) XPP((void)); \
  extern void XCAT(yAppend_,SORT) XPP((SORT *result, SORT S)); \
  \
  extern char * XCAT(yWri_,SORT) XPP((void * S)); \
  extern int XCAT(yRead_,SORT) XPP((void * Result));



/* String operator implementations --------------------------------*/

/*-- yEmptystring_SORT (String)------------------------------------*/
#define String_Emptystring(SORT, COMPONENTSORT) \
  extern SORT XCAT(yEmptystring_,SORT) XPP((void)) \
  { \
    SORT Result; \
    Result.First = (XCAT(SORT,_yptr))0; \
    Result.Last = (XCAT(SORT,_yptr))0; \
    Result.Length = 0; \
    Result.IsAssigned = (xbool)0; \
    return Result; \
  }


/*-- yMkString_SORT (String)---------------------------------------*/
#define String_MkString(SORT, COMPONENTSORT) \
  extern XCAT(SORT,_yptr) XCAT(yGetAvail_,SORT) XPP((void)) \
  { \
    XCAT(SORT,_yptr) Item; \
    if (XCAT(yAvail_,SORT) != (XCAT(SORT,_yptr))0) { \
      Item = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = XCAT(yAvail_,SORT)->Suc; \
    } else { \
      Item = (XCAT(SORT,_yptr))xAlloc((unsigned)sizeof(XCAT(SORT,_yrec))); \
    } \
    Item->Suc = (XCAT(SORT,_yptr))0; \
    XCAT(yDef_,COMPONENTSORT)(&Item->Data); \
    return Item; \
  } \
  \
  extern SORT XCAT(yMkString_,SORT) \
    XPP_PROTO( (COMPONENTSORT Component) ) \
    XPP_NOPROTO( (Component) COMPONENTSORT Component; ) \
  { \
    SORT Result; \
    Result.First = XCAT(yGetAvail_,SORT)(); \
    Result.Last = Result.First; \
    Result.Length = 1; \
    Result.IsAssigned = (xbool)0; \
    XCAT(yAssF_,COMPONENTSORT)(Result.First->Data, Component, XASS); \
    return Result; \
  }


/*-- yLength_SORT (String)-----------------------------------------*/
#define String_Length(SORT, COMPONENTSORT) \
  extern SDL_Integer XCAT(yLength_,SORT) \
    XPP_PROTO( (SORT S) ) \
    XPP_NOPROTO( (S) SORT S; ) \
  { \
    if (! S.IsAssigned && S.First != (XCAT(SORT,_yptr))0) { \
      XCAT(yFree_,SORT)((void **)&S); \
    } \
    return S.Length; \
  }

/*-- yFirst_SORT (String)------------------------------------------*/
#define String_First(SORT, COMPONENTSORT) \
  extern COMPONENTSORT XCAT(yFirst_,SORT) \
    XPP_PROTO( (SORT S) ) \
    XPP_NOPROTO( (S) SORT S; ) \
  { \
    COMPONENTSORT Result; \
    if (S.Length > 0) { \
      Result = S.First->Data; \
      if (! S.IsAssigned) { \
        XCAT(yFree_,SORT)((void **)&S); \
      } \
    } else { \
      xReportStringError("First in String sort", "Length is zero") \
      (void)memset((void *)(&Result), 0, sizeof(COMPONENTSORT)); \
      XCAT(yDef_,COMPONENTSORT)(&Result); \
    } \
    return Result; \
  }


/*-- yLast_SORT (String)-------------------------------------------*/
#define String_Last(SORT, COMPONENTSORT) \
  extern COMPONENTSORT XCAT(yLast_,SORT) \
    XPP_PROTO( (SORT S) ) \
    XPP_NOPROTO( (S) SORT S; ) \
  { \
    COMPONENTSORT Result; \
    if (S.Length > 0) { \
      Result = S.Last->Data; \
      if (! S.IsAssigned) { \
        XCAT(yFree_,SORT)((void **)&S); \
      } \
    } else { \
      xReportStringError("Last in String sort", "Length is zero") \
      (void)memset((void *)(&Result), 0, sizeof(COMPONENTSORT)); \
      XCAT(yDef_,COMPONENTSORT)(&Result); \
    } \
    return Result; \
  }


/*-- yConcat_SORT (String)-----------------------------------------*/
#define String_Concat(SORT, COMPONENTSORT) \
  extern void XCAT(yAppend_,SORT) \
    XPP_PROTO( (SORT *result, SORT S) ) \
    XPP_NOPROTO( (result, S) SORT *result; SORT S; ) \
  { \
    XCAT(SORT,_yptr)  TempSVar, TempExpr; \
    \
    (*result).Length = (*result).Length + S.Length; \
    if (S.IsAssigned) { \
      TempExpr = S.First; \
      TempSVar = XCAT(yGetAvail_,SORT)(); \
      if ((*result).First == (XCAT(SORT,_yptr))0) \
        (*result).First = TempSVar; \
      else \
        (*result).Last->Suc = TempSVar; \
      XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
      \
      while (TempExpr->Suc != (XCAT(SORT,_yptr))0) { \
        TempExpr = TempExpr->Suc; \
        TempSVar->Suc = XCAT(yGetAvail_,SORT)(); \
        TempSVar = TempSVar->Suc; \
        XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
      } \
      (*result).Last = TempSVar; \
    } else { \
      if ((*result).First == (XCAT(SORT,_yptr))0) \
        (*result).First = S.First; \
      else \
        (*result).Last->Suc = S.First; \
      (*result).Last = S.Last; \
    } \
  } \
  \
  \
  extern SORT XCAT(yConcat_,SORT) \
    XPP_PROTO( (SORT S1, SORT S2) ) \
    XPP_NOPROTO( (S1, S2) SORT S1; SORT S2; ) \
  { \
    SORT result; \
    \
    result.First = (XCAT(SORT,_yptr))0; \
    result.Last = (XCAT(SORT,_yptr))0; \
    result.Length = 0; \
    result.IsAssigned = (xbool)0; \
    if (S1.Length == 0) { \
      if (S2.Length == 0) \
        return result; \
      else if (! S2.IsAssigned) \
        return S2; \
      else { \
        XCAT(yAppend_,SORT)(&result, S2); \
      } \
    } else if (S2.Length == 0) { \
      if (! S1.IsAssigned) \
        return S1; \
      else { \
        XCAT(yAppend_,SORT)(&result, S1);  \
      } \
    } else { \
      XCAT(yAppend_,SORT)(&result, S1); \
      XCAT(yAppend_,SORT)(&result, S2); \
    } \
    \
    return result; \
  }


/*-- ySubstring_SORT (String)--------------------------------------*/
#define String_Substring(SORT, COMPONENTSORT) \
  extern SORT XCAT(ySubString_,SORT) \
    XPP_PROTO( (SORT S, SDL_Integer Start, SDL_Integer SubLength) ) \
    XPP_NOPROTO( (S, Start, SubLength) SORT S; SDL_Integer Start; SDL_Integer SubLength; ) \
  { \
    SORT result; \
    XCAT(SORT,_yptr)  TempSVar, TempExpr; \
    int I; \
    \
    result.First = (XCAT(SORT,_yptr))0; \
    result.Last = (XCAT(SORT,_yptr))0; \
    result.Length = 0; \
    result.IsAssigned = (xbool)0; \
    if ( S.Length <= 0 ) { \
      xReportStringError("SubString in string sort", "Length is zero" ) \
    } else if ( Start <= 0 ) { \
      xReportStringError("SubString in string sort", \
                         "Start is less than or equal to zero" ) \
    } else if ( SubLength <= 0 ) { \
      xReportStringError("SubString in string sort", \
                         "SubLength is less than or equal to zero" ) \
    } else if ( Start+SubLength-1 > S.Length ) { \
      xReportStringError("SubString in string sort", \
        "Start+Substring-1 length is greater than string length" ) \
    } else { \
      TempExpr = S.First; \
      for (I=1; I<Start; I++) TempExpr = TempExpr->Suc; \
      TempSVar = XCAT(yGetAvail_,SORT)(); \
      result.First = TempSVar; \
      XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
      \
      for (I=2; I<=SubLength; I++) { \
        TempExpr = TempExpr->Suc; \
        TempSVar->Suc = XCAT(yGetAvail_,SORT)(); \
        TempSVar = TempSVar->Suc; \
        XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
      } \
      result.Last = TempSVar; \
      result.Length = SubLength; \
    } \
    if (! S.IsAssigned && S.First != (XCAT(SORT,_yptr))0) { \
      XCAT(yFree_,SORT)((void **)&S); \
    } \
    return result; \
  }



/*-- yModify_SORT (String)-----------------------------------------*/
#define String_Modify(SORT, COMPONENTSORT) \
  extern COMPONENTSORT *XCAT(yAddr_,SORT) \
    XPP_PROTO( (SORT *S, SDL_Integer Index) ) \
    XPP_NOPROTO( (S, Index) SORT *S; SDL_Integer Index; ) \
  { \
    COMPONENTSORT *result; \
    XCAT(SORT,_yptr) Temp; \
    if ((*S).Length == 0) { \
      xReportStringError("Modify of component of string sort", \
                         "String is empty. Returns default value" ) \
      result = (COMPONENTSORT *)xAlloc((xptrint)sizeof(COMPONENTSORT)); \
      XCAT(yDef_,COMPONENTSORT)(result); \
      return result; \
    } else { \
      if (Index > (*S).Length) { \
        xReportStringError("Modify of component of string sort", \
                           "Index > string length. Index set to 1" ) \
        Index = 1; \
      } \
      if (Index <= (SDL_Integer)0) { \
        xReportStringError("Modify of component of string sort", \
                           "Index <= 0. Index set to 1" ) \
        Index = 1; \
      } \
      Temp = (*S).First; \
      for (; Index>1; Index--) Temp = Temp->Suc; \
      if (! (*S).IsAssigned && (*S).First != (XCAT(SORT,_yptr))0) { \
        XCAT(yFree_,SORT)((void **)S); \
      } \
      return &Temp->Data; \
    } \
  }


/*-- yExtr_SORT (String)--------------------------------------------*/
#define String_Extract(SORT, COMPONENTSORT) \
  extern COMPONENTSORT XCAT(yExtr_,SORT) \
    XPP_PROTO( (SORT S, SDL_Integer Index) ) \
    XPP_NOPROTO( (S, Index) SORT S; SDL_Integer Index; ) \
  { \
    COMPONENTSORT result; \
    XCAT(SORT,_yptr) Temp; \
    if (S.Length == 0) { \
      xReportStringError("Extract in string sort", \
                         "String is empty. Returns default value" ) \
      (void)memset((void *)(&result), 0, sizeof(COMPONENTSORT)); \
      XCAT(yDef_,COMPONENTSORT)(&result); \
      return result; \
    } else { \
      if (Index > S.Length) { \
        xReportStringError("Extract in string sort", \
                           "Index > string length. Index set to 1" ) \
        Index = 1; \
      } \
      if (Index <= (SDL_Integer)0) { \
        xReportStringError("Extract in string sort", \
                           "Index <= 0. Index set to 1" ) \
        Index = 1; \
      } \
      Temp = S.First; \
      for (; Index>1; Index--) Temp = Temp->Suc; \
      if (! S.IsAssigned && S.First != (XCAT(SORT,_yptr))0) { \
        XCAT(yFree_,SORT)((void **)&S); \
      } \
      return Temp->Data; \
    } \
  }


/*-- yAss_SORT (String)--------------------------------------------*/
#define String_Assign(SORT, COMPONENTSORT) \
  static XCAT(SORT,_yptr)  XCAT(yAvail_,SORT) = (XCAT(SORT,_yptr))0; \
  extern void XCAT(yAss_,SORT) \
    XPP_PROTO( (SORT * SVar, SORT SExpr, int AssType) ) \
    XPP_NOPROTO( (SVar, SExpr, AssType)  SORT * SVar; SORT SExpr; int AssType; ) \
  { \
    XCAT(SORT,_yptr)  TempSVar, TempExpr; \
    \
    if ((*SVar).First == SExpr.First) \
      return; \
    if (AssType == XASS && (*SVar).First != (XCAT(SORT,_yptr))0) { \
      XCAT(yFree_,SORT)((void **)SVar); \
    } \
    if ( (SExpr.IsAssigned || AssType == XASS2MAKE) && \
         SExpr.First != (XCAT(SORT,_yptr))0) { \
      TempExpr = SExpr.First; \
      TempSVar = XCAT(yGetAvail_,SORT)(); \
      (*SVar).First = TempSVar; \
      XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
      \
      TempExpr = TempExpr->Suc; \
      while (TempExpr != (XCAT(SORT,_yptr))0) { \
        TempSVar->Suc = XCAT(yGetAvail_,SORT)(); \
        TempSVar = TempSVar->Suc; \
        XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
        TempExpr = TempExpr->Suc; \
      } \
      (*SVar).Last = TempSVar; \
    } else { \
      (*SVar).First = SExpr.First; \
      (*SVar).Last = SExpr.Last; \
    } \
    (*SVar).Length = SExpr.Length; \
    (*SVar).IsAssigned = (xbool)1; \
  }


/*-- yEq_SORT (String)---------------------------------------------*/
#define String_Equal(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yEq_,SORT) \
    XPP_PROTO( (SORT Expr1, SORT Expr2) ) \
    XPP_NOPROTO( (Expr1, Expr2) SORT Expr1; SORT Expr2; ) \
  { \
    XCAT(SORT,_yptr)  Temp1, Temp2; \
    SDL_Boolean  Result; \
    \
    Result = SDL_True; \
    if (Expr1.Length != Expr2.Length) \
      Result = SDL_False; \
    Temp1 = Expr1.First; \
    Temp2 = Expr2.First; \
    while (Result && Temp1 != (XCAT(SORT,_yptr))0) { \
      if (XCAT(yNEqF_,COMPONENTSORT)(Temp1->Data, Temp2->Data) ) \
        Result = SDL_False; \
      Temp1 = Temp1->Suc; \
      Temp2 = Temp2->Suc; \
    } \
    if (! Expr1.IsAssigned && Expr1.First != (XCAT(SORT,_yptr))0) { \
      XCAT(yFree_,SORT)((void **)&Expr1); \
    } \
    if (! Expr2.IsAssigned && Expr2.First != (XCAT(SORT,_yptr))0) { \
      XCAT(yFree_,SORT)((void **)&Expr2); \
    } \
    return Result; \
  }

/*-- yDef_SORT (String)--------------------------------------------*/
#define String_Default(SORT, COMPONENTSORT) \
  extern void XCAT(yDef_,SORT) \
    XPP_PROTO( (SORT *S) ) \
    XPP_NOPROTO( (S) SORT *S; ) \
  { \
    (*S).First = (XCAT(SORT,_yptr))0; \
    (*S).Last = (XCAT(SORT,_yptr))0; \
    (*S).Length = 0; \
    (*S).IsAssigned = (xbool)1; \
  }


/*-- yFree_SORT (String)-------------------------------------------*/
#ifdef XFREEFUNCS
#define String_Free(SORT, COMPONENTSORT, HASCOMPFREE) \
  extern void XCAT(yFree_,SORT) \
    XPP_PROTO( (void ** C) ) \
    XPP_NOPROTO( (C) void ** C; ) \
  { \
    XCAT(SORT,_yptr)  Temp; \
    if (HASCOMPFREE) { \
      for (Temp =  (*(SORT *)C).First; \
           Temp != (XCAT(SORT,_yptr))0; \
           Temp =  Temp->Suc) { \
        XCAT(yFree_,COMPONENTSORT)((void **)&Temp->Data); \
      } \
    } \
    if ((*(SORT *)C).First != (XCAT(SORT,_yptr))0) { \
      (*(SORT *)C).Last->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = (*(SORT *)C).First; \
    } \
  }
#else
#define String_Free(SORT, COMPONENTSORT, HASCOMPFREE) \
  extern void XCAT(yFree_,SORT) \
    XPP_PROTO( (void ** C) ) \
    XPP_NOPROTO( (C) void ** C; ) \
  { \
    if ((*(SORT *)C).First != (XCAT(SORT,_yptr))0) { \
      (*(SORT *)C).Last->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = (*(SORT *)C).First; \
    } \
  }
#endif


/*-- yWri_SORT (String)-------------------------------------------*/
#define String_Write(SORT, COMPONENTSORT) \
  extern char * XCAT(yWri_,SORT) \
    XPP_PROTO( (void * S) ) \
    XPP_NOPROTO( (S) void * S; ) \
  { \
    XCAT(SORT,_yptr) Temp, TempLast; \
  static  char       CTemp[MAX_WRI_LENGTH]; \
    \
    strcpy(CTemp, "(. "); \
    TempLast = (*(SORT *)S).Last; \
    for (Temp = (*(SORT *)S).First; \
         Temp != (XCAT(SORT,_yptr))0; \
         Temp = Temp->Suc) { \
      xSafeStrcat(CTemp, \
             xWriteSort((void *)(&Temp->Data), XCAT(ySrtN_,COMPONENTSORT))); \
      if (strlen(CTemp) == MAX_WRI_LENGTH - 1) \
        return CTemp; \
      if (Temp != TempLast) \
        xSafeStrcat(CTemp, ", "); \
    } \
    xSafeStrcat(CTemp, " .)"); \
    return CTemp; \
  }


/*-- yRead_SORT (String)------------------------------------------*/
#define String_Read(SORT, COMPONENTSORT) \
  extern int XCAT(yRead_,SORT) \
    XPP_PROTO( (void * Result) ) \
    XPP_NOPROTO( (Result) void * Result; ) \
  { \
    COMPONENTSORT Item; \
    xxToken       Token; \
    char          strVar[256]; \
    int           Res; \
    \
    (*(SORT *)Result).First = (XCAT(SORT,_yptr))0; \
    (*(SORT *)Result).Last = (XCAT(SORT,_yptr))0; \
    (*(SORT *)Result).Length = 0; \
    (*(SORT *)Result).IsAssigned = (int)0; \
    Token = xScanToken(strVar); \
    if (Token != xxLParDot && Token != xxQuestionMark && Token != xxEoln) { \
      xPrintString("String value should start with (.\n"); \
      return 0; \
    } \
    if (Token != xxLParDot) xUngetToken(Token, strVar); \
    \
    while (Token != xxRParDot) { \
      sprintf(strVar, " (%s) : ", XCAT(ySrtN_,COMPONENTSORT)->Name); \
      (void)memset((void *)(&Item), 0, sizeof(COMPONENTSORT)); \
      Res = xReadOneParameter(XCAT(ySrtN_,COMPONENTSORT), strVar, (void *)&Item); \
      if (Res == 0) return 0; \
      if (Res == 2) { \
        Token = xScanToken(strVar); \
        if (Token == xxRParDot) break; \
        return 0; \
      } \
      XCAT(yAppend_,SORT)((SORT *)Result, XCAT(yMkString_,SORT)(Item)); \
      Token = xScanToken(strVar); \
      if (Token != xxRParDot) xUngetToken(Token, strVar); \
    } \
    (*(SORT *)Result).IsAssigned = (int)1; \
    return 1; \
  }

/****+***************************************************************
05   Generator Array  (array that cannot become array in C)
********************************************************************/

/* typedef for Array type -----------------------------------------*/

#define Array_Type(SORT, INDEXSORT, COMPONENTSORT) \
   typedef struct XCAT(SORT,_ystruct)  * XCAT(SORT,_yptr); \
   typedef struct XCAT(SORT,_ystruct) { \
     XCAT(SORT,_yptr)   Suc; \
     INDEXSORT          Index; \
     COMPONENTSORT      Data; \
   } XCAT(SORT,_yrec); \
   typedef struct { \
     XCAT(SORT,_yptr) First; \
     XCAT(SORT,_yptr) Last; \
     xbool            IsAssigned; \
     COMPONENTSORT    Data; \
   } SORT;


/* Array operator prototypes --------------------------------------*/

#define Array_prototypes(SORT, INDEXSORT, COMPONENTSORT) \
  extern SORT XCAT(yMake_,SORT) XPP((COMPONENTSORT)); \
  extern COMPONENTSORT XCAT(yExtr_,SORT) XPP((SORT, INDEXSORT)); \
  extern COMPONENTSORT *XCAT(yAddr_,SORT) XPP((SORT *, INDEXSORT)); \
  \
  extern XCAT(SORT,_yptr) XCAT(yGetAvail_,SORT) XPP((void)); \
  extern COMPONENTSORT XCAT(yExtrInner_,SORT) \
         XPP((SORT S, INDEXSORT Index)); \
  \
  extern char * XCAT(yWri_,SORT) XPP((void * S)); \
  extern int XCAT(yRead_,SORT) XPP((void * Result));


/* Array operator implementations ---------------------------------*/

/*-- yMake_SORT (Array)--------------------------------------------*/
#define Array_Make(SORT, INDEXSORT, COMPONENTSORT) \
  extern SORT XCAT(yMake_,SORT) \
    XPP_PROTO( (COMPONENTSORT Component) ) \
    XPP_NOPROTO( (Component) COMPONENTSORT Component; ) \
  { \
    SORT Result; \
    Result.First = (XCAT(SORT,_yptr))0; \
    Result.Last = (XCAT(SORT,_yptr))0; \
    Result.IsAssigned = (xbool)0; \
    XCAT(yAssF_,COMPONENTSORT)(Result.Data, Component, XASSMAKE); \
    return Result; \
  }


/*-- yModify_SORT (Array)------------------------------------------*/
#define Array_Modify(SORT, INDEXSORT, COMPONENTSORT) \
  extern XCAT(SORT,_yptr) XCAT(yGetAvail_,SORT) XPP((void)) \
  { \
    XCAT(SORT,_yptr) Item; \
    if (XCAT(yAvail_,SORT) != (XCAT(SORT,_yptr))0) { \
      Item = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = XCAT(yAvail_,SORT)->Suc; \
    } else { \
      Item = (XCAT(SORT,_yptr))xAlloc((unsigned)sizeof(XCAT(SORT,_yrec))); \
    } \
    Item->Suc = (XCAT(SORT,_yptr))0; \
    return Item; \
  } \
  \
  extern COMPONENTSORT *XCAT(yAddr_,SORT) \
    XPP_PROTO( (SORT *S, INDEXSORT Index) ) \
    XPP_NOPROTO( (S, Index) SORT *S; INDEXSORT Index; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    Temp = (*S).First; \
    while ( Temp != (XCAT(SORT,_yptr))0  && \
            XCAT(yNEqF_,INDEXSORT)(Temp->Index, Index) ) \
      Temp = Temp->Suc; \
    if (Temp != (XCAT(SORT,_yptr))0) \
      return &Temp->Data; \
    if ((*S).First == (XCAT(SORT,_yptr))0) { \
      (*S).First = XCAT(yGetAvail_,SORT)(); \
      (*S).Last = (*S).First; \
    } else { \
      (*S).Last->Suc = XCAT(yGetAvail_,SORT)(); \
      (*S).Last = (*S).Last->Suc; \
    } \
    XCAT(yAssF_,INDEXSORT)((*S).Last->Index, Index, XASS); \
    XCAT(yAssF_,COMPONENTSORT)((*S).Last->Data, (*S).Data, XASS); \
    return &(*S).Last->Data; \
  }


/*-- yExtr_SORT (Array)---------------------------------------------*/
#define Array_Extract(SORT, INDEXSORT, COMPONENTSORT) \
  \
  extern COMPONENTSORT XCAT(yExtrInner_,SORT) \
    XPP_PROTO( (SORT S, INDEXSORT Index) ) \
    XPP_NOPROTO( (S, Index) SORT S; INDEXSORT Index; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    Temp = S.First; \
    while ( Temp != (XCAT(SORT,_yptr))0  && \
            XCAT(yNEqF_,INDEXSORT)(Temp->Index, Index) ) \
      Temp = Temp->Suc; \
    if (Temp != (XCAT(SORT,_yptr))0) \
      return Temp->Data; \
    else \
      return S.Data; \
  } \
  \
  extern COMPONENTSORT XCAT(yExtr_,SORT) \
    XPP_PROTO( (SORT S, INDEXSORT Index) ) \
    XPP_NOPROTO( (S, Index) SORT S; INDEXSORT Index; ) \
  { \
    COMPONENTSORT result; \
    result = XCAT(yExtrInner_,SORT)(S, Index); \
    if (! S.IsAssigned && S.First != (XCAT(SORT,_yptr))0) \
      XCAT(yFree_,SORT)((void **)&S); \
    return result; \
  }


/*-- yAss_SORT (Array)---------------------------------------------*/
#define Array_Assign(SORT, INDEXSORT, COMPONENTSORT) \
  static XCAT(SORT,_yptr)  XCAT(yAvail_,SORT) = (XCAT(SORT,_yptr))0; \
  extern void XCAT(yAss_,SORT) \
    XPP_PROTO( (SORT * SVar, SORT SExpr, int AssType) ) \
    XPP_NOPROTO( (SVar, SExpr, AssType)  SORT * SVar; SORT SExpr; int AssType; ) \
  { \
    XCAT(SORT,_yptr)  TempSVar, TempExpr, PrevExpr; \
    \
    if ((*SVar).First != SExpr.First) {\
      if (AssType == XASS && (*SVar).First != (XCAT(SORT,_yptr))0) \
        XCAT(yFree_,SORT)((void **)SVar); \
      if ( (SExpr.IsAssigned || AssType == XASS2MAKE) && \
           SExpr.First != (XCAT(SORT,_yptr))0) { \
        TempExpr = SExpr.First; \
        TempSVar = XCAT(yGetAvail_,SORT)(); \
        (*SVar).First = TempSVar; \
        XCAT(yAssF_,INDEXSORT)(TempSVar->Index, TempExpr->Index, XASS); \
        XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
        \
        TempExpr = TempExpr->Suc; \
        while (TempExpr != (XCAT(SORT,_yptr))0) { \
          TempSVar->Suc = XCAT(yGetAvail_,SORT)(); \
          TempSVar = TempSVar->Suc; \
          XCAT(yAssF_,INDEXSORT)(TempSVar->Index, TempExpr->Index, XASS); \
          XCAT(yAssF_,COMPONENTSORT)(TempSVar->Data, TempExpr->Data, XASS); \
          TempExpr = TempExpr->Suc; \
        } \
        (*SVar).Last = TempSVar; \
      } else { \
        (*SVar).First = SExpr.First; \
        (*SVar).Last = SExpr.Last; \
      } \
    } \
    XCAT(yAssF_,COMPONENTSORT)((*SVar).Data, SExpr.Data, XASS); \
    (*SVar).IsAssigned = (xbool)1; \
    \
    PrevExpr = (*SVar).First; \
    while ( PrevExpr != (XCAT(SORT,_yptr))0 && \
            XCAT(yEqF_,COMPONENTSORT)(PrevExpr->Data, (*SVar).Data) ) { \
      (*SVar).First = PrevExpr->Suc; \
      PrevExpr->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = PrevExpr; \
      PrevExpr = (*SVar).First; \
    } \
    if ( PrevExpr != (XCAT(SORT,_yptr))0 ) { \
      while ( PrevExpr->Suc != (XCAT(SORT,_yptr))0 ) { \
        TempExpr = PrevExpr->Suc; \
        if ( XCAT(yEqF_,COMPONENTSORT)(TempExpr->Data, (*SVar).Data) ) { \
          PrevExpr->Suc = TempExpr->Suc; \
          TempExpr->Suc = XCAT(yAvail_,SORT); \
          XCAT(yAvail_,SORT) = TempExpr; \
        } else { \
          PrevExpr = TempExpr; \
        } \
      } \
    } \
    (*SVar).Last = PrevExpr; \
  }


/*-- yEq_SORT (Array)----------------------------------------------*/
#define Array_Equal(SORT, INDEXSORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yEq_,SORT) \
    XPP_PROTO( (SORT Expr1, SORT Expr2) ) \
    XPP_NOPROTO( (Expr1, Expr2) SORT Expr1; SORT Expr2; ) \
  { \
    XCAT(SORT,_yptr)  Temp; \
    SDL_Boolean  Result; \
    \
    Result = XCAT(yEqF_,COMPONENTSORT)(Expr1.Data, Expr2.Data); \
    if (Result) { \
      Temp = Expr1.First; \
      while (Result && Temp != (XCAT(SORT,_yptr))0) { \
        if (XCAT(yNEqF_,COMPONENTSORT) \
             (Temp->Data, XCAT(yExtrInner_,SORT)(Expr2, Temp->Index)) ) \
          Result = SDL_False; \
        Temp = Temp->Suc; \
      } \
      Temp = Expr2.First; \
      while (Result && Temp != (XCAT(SORT,_yptr))0) { \
        if (XCAT(yNEqF_,COMPONENTSORT) \
             (Temp->Data, XCAT(yExtrInner_,SORT)(Expr1, Temp->Index)) ) \
          Result = SDL_False; \
        Temp = Temp->Suc; \
      } \
    } \
    \
    if (! Expr1.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&Expr1); \
    if (! Expr2.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&Expr2); \
    return Result; \
  }

/*-- yDef_SORT (Array)---------------------------------------------*/
#define Array_Default(SORT, INDEXSORT, COMPONENTSORT) \
  extern void XCAT(yDef_,SORT) \
    XPP_PROTO( (SORT *S) ) \
    XPP_NOPROTO( (S) SORT *S; ) \
  { \
    (*S).First = (XCAT(SORT,_yptr))0; \
    (*S).Last = (XCAT(SORT,_yptr))0; \
    XCAT(yDef_,COMPONENTSORT)(&(*S).Data); \
    (*S).IsAssigned = (xbool)1; \
  }


/*-- yFree_SORT (Array)--------------------------------------------*/
#ifdef XFREEFUNCS
#define Array_Free(SORT, INDEXSORT, HASINDEXFREE, COMPONENTSORT, HASCOMPFREE) \
  extern void XCAT(yFree_,SORT) \
    XPP_PROTO( (void ** C) ) \
    XPP_NOPROTO( (C) void ** C; ) \
  { \
    XCAT(SORT,_yptr)  Temp; \
    if (HASCOMPFREE || HASINDEXFREE) { \
      for (Temp =  (*(SORT *)C).First; \
           Temp != (XCAT(SORT,_yptr))0; \
           Temp =  Temp->Suc) { \
        if (HASCOMPFREE) \
          XCAT(yFree_,COMPONENTSORT)((void **)&Temp->Data); \
        if (HASINDEXFREE) \
          XCAT(yFree_,INDEXSORT)((void **)&Temp->Index); \
      } \
      if (HASCOMPFREE) \
        XCAT(yFree_,COMPONENTSORT)((void **)&(*(SORT *)C).Data); \
    } \
    if ((*(SORT *)C).First != (XCAT(SORT,_yptr))0) { \
      (*(SORT *)C).Last->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = (*(SORT *)C).First; \
    } \
  }
#else
#define Array_Free(SORT, INDEXSORT, HASINDEXFREE, COMPONENTSORT, HASCOMPFREE) \
  extern void XCAT(yFree_,SORT) \
    XPP_PROTO( (void ** C) ) \
    XPP_NOPROTO( (C) void ** C; ) \
  { \
    if ((*(SORT *)C).First != (XCAT(SORT,_yptr))0) { \
      (*(SORT *)C).Last->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = (*(SORT *)C).First; \
    } \
  }
#endif


/*-- yWri_SORT (Array)---------------------------------------------*/
#define Array_Write(SORT, INDEXSORT, COMPONENTSORT) \
  extern char * XCAT(yWri_,SORT) \
    XPP_PROTO( (void * S) ) \
    XPP_NOPROTO( (S) void * S; ) \
  { \
    XCAT(SORT,_yptr) ArrPtr; \
  static  char       CTemp[MAX_WRI_LENGTH]; \
    \
    strcpy(CTemp, "(: (others:"); \
    xSafeStrcat(CTemp, \
       xWriteSort((void *)(&(*(SORT *)S).Data), XCAT(ySrtN_,COMPONENTSORT))); \
    xSafeStrcat(CTemp, ")"); \
    for (ArrPtr =  (*(SORT *)S).First; \
         ArrPtr != (XCAT(SORT,_yptr))0; \
         ArrPtr =  ArrPtr->Suc) { \
      xSafeStrcat(CTemp, ", ("); \
      xSafeStrcat(CTemp, \
               xWriteSort((void *)(&ArrPtr->Index), XCAT(ySrtN_,INDEXSORT))); \
      xSafeStrcat(CTemp, ":"); \
      xSafeStrcat(CTemp, \
            xWriteSort((void *)(&ArrPtr->Data), XCAT(ySrtN_,COMPONENTSORT))); \
      xSafeStrcat(CTemp, ")"); \
    } \
    xSafeStrcat(CTemp, " :)"); \
    return CTemp; \
  }


/*-- yRead_SORT (Array)--------------------------------------------*/
#define Array_Read(SORT, INDEXSORT, COMPONENTSORT) \
  extern int XCAT(yRead_,SORT) \
    XPP_PROTO( (void * Result) ) \
    XPP_NOPROTO( (Result) void * Result; ) \
  { \
    INDEXSORT     Index; \
    COMPONENTSORT Item; \
    xxToken       Token; \
    char          strVar[256]; \
    xbool         IsOthers; \
    int           Res; \
    \
    XCAT(yDef_,SORT)((SORT *)Result); \
    Token = xScanToken(strVar); \
    if (Token != xxLParColon && Token != xxQuestionMark && Token != xxEoln) { \
      xPrintString("Array value should start with (:\n"); \
      return 0; \
    } \
    if (Token != xxLParColon) xUngetToken(Token, strVar); \
    \
    IsOthers = (xbool)1; \
    while (Token != xxRParColon) { \
      Token = xScanToken(strVar); \
      if (Token == xxLPar) Token = xScanToken(strVar); \
      if (! IsOthers) { \
        if (Token == xxEoln || Token == xxQuestionMark) { \
          sprintf(strVar, " Index (%s) : ", XCAT(ySrtN_,INDEXSORT)->Name); \
          xPrintString(strVar); \
          Token = xScanToken(strVar); \
        } \
        if (Token == xxRParColon) break; \
        xUngetToken(Token, strVar); \
        (void)memset((void *)(&Index), 0, sizeof(INDEXSORT)); \
        if ( ! xReadSort((void *)&Index, XCAT(ySrtN_,INDEXSORT))) { \
          xPrintString("Illegal index value\n"); \
          return 0; \
        } \
        Token = xScanToken(strVar); \
      } else { \
        if (Token == xxEoln || Token == xxQuestionMark) { \
          xPrintString(" others"); \
        } else if (Token == xxId) { \
          if (xfEqualIdString(strVar, "others") != 2) { \
            xPrintString("others expected\n"); \
            return 0; \
          } \
          Token = xScanToken(strVar); \
        } else { \
          xPrintString("others expected\n"); \
          return 0; \
        } \
      } \
      if (Token != xxColon) xUngetToken(Token, strVar); \
      if (IsOthers) \
        sprintf(strVar, " Others component (%s) : ", XCAT(ySrtN_,COMPONENTSORT)->Name); \
      else \
        sprintf(strVar, " Component (%s) : ", XCAT(ySrtN_,COMPONENTSORT)->Name); \
      (void)memset((void *)(&Item), 0, sizeof(COMPONENTSORT)); \
      Res = xReadOneParameter(XCAT(ySrtN_,COMPONENTSORT), strVar, (void *)&Item); \
      if (Res == 0) { \
        xPrintString("Illegal component value\n"); \
        return 0; \
      } \
      if (IsOthers) \
        XCAT(yAss_,SORT)((SORT *)Result, XCAT(yMake_,SORT)(Item), XASS); \
      else \
        XCAT(yAssF_,COMPONENTSORT)( \
            (* XCAT(yAddr_,SORT)((SORT *)Result, Index)) , Item, XASS); \
      \
      Token = xScanToken(strVar); \
      if (Token == xxRPar) Token = xScanToken(strVar); \
      if (Token == xxComma) Token = xScanToken(strVar); \
      if (Token != xxRParColon) xUngetToken(Token, strVar); \
      IsOthers = (xbool)0; \
    } \
    (*(SORT *)Result).IsAssigned = (int)1; \
    return 1; \
  }


/****+***************************************************************
06   Generator Powerset  (limited and discrete component type)
********************************************************************/

/* typedef for Powerset type --------------------------------------*/

#define Powerset_Type(SORT, COMPONENTSORT, LOW, HIGH) \
  typedef struct { \
    unsigned long A[(HIGH-LOW)/32+1]; \
  } SORT;

  /* unsigned long is assumed to be 32 bits */


#define Powerset_prototypes(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SORT XCAT(yEmpty_,SORT) XPP((void)); \
  extern SDL_Boolean XCAT(yIn_,SORT) XPP((COMPONENTSORT, SORT)); \
  extern SORT XCAT(yIncl_,SORT) XPP((COMPONENTSORT, SORT)); \
  extern SORT XCAT(yDel_,SORT) XPP((COMPONENTSORT, SORT)); \
  extern SDL_Boolean XCAT(yLT_,SORT) XPP((SORT, SORT)); \
  extern SDL_Boolean XCAT(yGT_,SORT) XPP((SORT, SORT)); \
  extern SDL_Boolean XCAT(yLE_,SORT) XPP((SORT, SORT)); \
  extern SDL_Boolean XCAT(yGE_,SORT) XPP((SORT, SORT)); \
  extern SORT XCAT(yAnd_,SORT) XPP((SORT, SORT)); \
  extern SORT XCAT(yOr_,SORT) XPP((SORT, SORT)); \
  \
  extern SDL_Integer XCAT(yCard_,SORT) XPP((SORT)); \
  extern COMPONENTSORT XCAT(yElement_,SORT) XPP((SORT, SDL_Integer));


/*-- yEmpty_SORT (Powerset)----------------------------------------*/
#define Powerset_Empty(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SORT XCAT(yEmpty_,SORT) XPP((void)) \
  { \
    SORT PS; \
    int Item; \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) \
      PS.A[Item] = 0; \
    return PS; \
  }


/*-- yIn_SORT (Powerset)-------------------------------------------*/
#define Powerset_In(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SDL_Boolean XCAT(yIn_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    if (Item < LOW || Item > HIGH) return SDL_False; \
    Item = Item - LOW; \
    if ( ((unsigned long)1 << Item%32) & PS.A[Item/32] ) \
      return SDL_True; \
    return SDL_False; \
  }


/*-- yIncl_SORT (Powerset)-----------------------------------------*/
#define Powerset_Incl(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SORT XCAT(yIncl_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    if (Item < LOW || Item > HIGH) return PS; \
    Item = Item - LOW; \
    PS.A[Item/32] = ((unsigned long)1 << Item%32) | PS.A[Item/32]; \
    return PS; \
  }


/*-- yDel_SORT (Powerset)------------------------------------------*/
#define Powerset_Del(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SORT XCAT(yDel_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    if (Item < LOW || Item > HIGH) return PS; \
    Item = Item - LOW; \
    PS.A[Item/32] = ~((unsigned long)1 << Item%32) & PS.A[Item/32]; \
    return PS; \
  }


/*-- yAnd_SORT (Powerset)------------------------------------------*/
#define Powerset_And(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SORT XCAT(yAnd_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    SORT PS; \
    int Item; \
    \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) \
      PS.A[Item] = PS1.A[Item] & PS2.A[Item]; \
    return PS; \
  }


/*-- yOr_SORT (Powerset)-------------------------------------------*/
#define Powerset_Or(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SORT XCAT(yOr_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    SORT PS; \
    int Item; \
    \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) \
      PS.A[Item] = PS1.A[Item] | PS2.A[Item]; \
    return PS; \
  }


/*-- yLE_SORT (Powerset)-------------------------------------------*/
#define Powerset_LE(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SDL_Boolean XCAT(yLE_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    int Item; \
    \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( (PS2.A[Item] | PS1.A[Item]) ^ PS2.A[Item] ) \
        return SDL_False; \
    } \
    return SDL_True; \
  }


/*-- yLT_SORT (Powerset)-------------------------------------------*/
#define Powerset_LT(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SDL_Boolean XCAT(yLT_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    int Item; \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( (PS2.A[Item] | PS1.A[Item]) ^ PS2.A[Item] ) \
        return SDL_False; \
    } \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( PS2.A[Item] ^ PS1.A[Item] ) \
        return SDL_True; \
    } \
    return SDL_False; \
  }


/*-- yGE_SORT (Powerset)-------------------------------------------*/
#define Powerset_GE(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SDL_Boolean XCAT(yGE_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    int Item; \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( (PS1.A[Item] | PS2.A[Item]) ^ PS1.A[Item] ) \
        return SDL_False; \
    } \
    return SDL_True; \
  }


/*-- yGT_SORT (Powerset)-------------------------------------------*/
#define Powerset_GT(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SDL_Boolean XCAT(yGT_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    int Item; \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( (PS1.A[Item] | PS2.A[Item]) ^ PS1.A[Item] ) \
        return SDL_False; \
    } \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( PS1.A[Item] ^ PS2.A[Item] ) \
        return SDL_True; \
    } \
    return SDL_False; \
  }


/*-- yEq_SORT (Powerset)-------------------------------------------*/
#define Powerset_Equal(SORT, COMPONENTSORT, LOW, HIGH) \
  extern SDL_Boolean XCAT(yEq_,SORT) \
    XPP_PROTO( (SORT Expr1, SORT Expr2) ) \
    XPP_NOPROTO( (Expr1, Expr2) SORT Expr1; SORT Expr2; ) \
  { \
    int Item; \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) { \
      if ( Expr1.A[Item] ^ Expr2.A[Item] ) \
        return SDL_False; \
    } \
    return SDL_True; \
  }


/*-- yDef_SORT (Powerset)------------------------------------------*/
#define Powerset_Default(SORT, COMPONENTSORT, LOW, HIGH) \
  extern void XCAT(yDef_,SORT) \
    XPP_PROTO( (SORT *S) ) \
    XPP_NOPROTO( (S) SORT *S; ) \
  { \
    int Item; \
    for (Item=0; Item<=(HIGH-LOW)/32; Item++) \
      (*S).A[Item] = (unsigned long)0; \
  }



/****+***************************************************************
07   Generator Powerset  (general component type)
********************************************************************/

/* typedef for GPowerset type -------------------------------------*/

#define GPowerset_Type(SORT, COMPONENTSORT) \
   typedef struct XCAT(SORT,_ystruct)  * XCAT(SORT,_yptr); \
   typedef struct XCAT(SORT,_ystruct) { \
     XCAT(SORT,_yptr)   Suc; \
     COMPONENTSORT      Data; \
   } XCAT(SORT,_yrec); \
   typedef struct { \
     XCAT(SORT,_yptr) First; \
     XCAT(SORT,_yptr) Last; \
     int              Length; \
     xbool            IsAssigned; \
   } SORT;


#define GPowerset_prototypes(SORT, COMPONENTSORT) \
  extern SORT XCAT(yEmpty_,SORT) XPP((void)); \
  extern SDL_Boolean XCAT(yIn_,SORT) XPP((COMPONENTSORT, SORT)); \
  extern SORT XCAT(yIncl_,SORT) XPP((COMPONENTSORT, SORT)); \
  extern SORT XCAT(yDel_,SORT) XPP((COMPONENTSORT, SORT)); \
  extern SDL_Boolean XCAT(yLT_,SORT) XPP((SORT, SORT)); \
  extern SDL_Boolean XCAT(yGT_,SORT) XPP((SORT, SORT)); \
  extern SDL_Boolean XCAT(yLE_,SORT) XPP((SORT, SORT)); \
  extern SDL_Boolean XCAT(yGE_,SORT) XPP((SORT, SORT)); \
  extern SORT XCAT(yAnd_,SORT) XPP((SORT, SORT)); \
  extern SORT XCAT(yOr_,SORT) XPP((SORT, SORT)); \
  extern SDL_Integer XCAT(yCard_,SORT) XPP((SORT)); \
  extern COMPONENTSORT XCAT(yElement_,SORT) XPP((SORT, SDL_Integer)); \
  \
  extern SORT XCAT(yCopyList_,SORT) XPP((SORT PS)); \
  extern SDL_Boolean XCAT(yInInner_,SORT) \
            XPP((COMPONENTSORT Item, SORT PS)); \
  extern XCAT(SORT,_yptr) XCAT(yGetAvail_,SORT) XPP((void)); \
  \
  extern char * XCAT(yWri_,SORT) XPP((void * PS)); \
  extern int XCAT(yRead_,SORT) XPP((void * Result));


/*-- yEmpty_SORT (GPowerset)---------------------------------------*/
#define GPowerset_Empty(SORT, COMPONENTSORT) \
  extern XCAT(SORT,_yptr) XCAT(yGetAvail_,SORT) XPP((void)) \
  { \
    XCAT(SORT,_yptr) Item; \
    if (XCAT(yAvail_,SORT) != (XCAT(SORT,_yptr))0) { \
      Item = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = XCAT(yAvail_,SORT)->Suc; \
    } else { \
      Item = (XCAT(SORT,_yptr))xAlloc((unsigned)sizeof(XCAT(SORT,_yrec))); \
    } \
    Item->Suc = (XCAT(SORT,_yptr))0; \
    return Item; \
  } \
  \
  extern SORT XCAT(yEmpty_,SORT) XPP((void)) \
  { \
    SORT Result; \
    Result.First = (XCAT(SORT,_yptr))0; \
    Result.Last = (XCAT(SORT,_yptr))0; \
    Result.Length = 0; \
    Result.IsAssigned = (xbool)0; \
    return Result; \
  }


/*-- yIn_SORT (GPowerset)------------------------------------------*/
#define GPowerset_In(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yInInner_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    SDL_Boolean Result; \
    Result = SDL_False; \
    for (Temp=PS.First; \
         Temp!=(XCAT(SORT,_yptr))0 && !Result; \
         Temp=Temp->Suc) \
      if ( XCAT(yEqF_,COMPONENTSORT)(Temp->Data, Item) ) \
        Result = SDL_True; \
    return Result; \
  } \
  \
  extern SDL_Boolean XCAT(yIn_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    SDL_Boolean Result; \
    Result = XCAT(yInInner_,SORT)(Item, PS); \
    if (! PS.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS); \
    return Result; \
  }


/*-- yIncl_SORT (GPowerset)----------------------------------------*/
#define GPowerset_Incl(SORT, COMPONENTSORT) \
  extern SORT XCAT(yCopyList_,SORT) \
    XPP_PROTO( (SORT PS) ) \
    XPP_NOPROTO( (PS)  SORT PS; ) \
  { \
    XCAT(SORT,_yptr) TempPS, TempRes; \
    SORT Result; \
    Result = PS; \
    Result.IsAssigned = (xbool)0; \
    if (PS.First != (XCAT(SORT,_yptr))0 ) { \
      TempPS = PS.First; \
      TempRes = XCAT(yGetAvail_,SORT)(); \
      XCAT(yAssF_,COMPONENTSORT)(TempRes->Data, TempPS->Data, XASS); \
      Result.First = TempRes; \
      while (TempPS->Suc != (XCAT(SORT,_yptr))0) { \
        TempPS = TempPS->Suc; \
        TempRes->Suc = XCAT(yGetAvail_,SORT)(); \
        TempRes = TempRes->Suc; \
        XCAT(yAssF_,COMPONENTSORT)(TempRes->Data, TempPS->Data, XASS); \
      } \
      Result.Last = TempRes; \
    } \
    return Result; \
  } \
  \
  extern SORT XCAT(yIncl_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    SORT Result; \
    if (PS.IsAssigned) \
      Result = XCAT(yCopyList_,SORT)(PS); \
    else \
      Result = PS; \
    if (! XCAT(yInInner_,SORT)(Item, Result) ) { \
      if (Result.Last == (XCAT(SORT,_yptr))0) { \
        Result.Last = XCAT(yGetAvail_,SORT)(); \
        Result.First = Result.Last; \
      } else { \
        Result.Last->Suc = XCAT(yGetAvail_,SORT)(); \
        Result.Last = Result.Last->Suc; \
      } \
      XCAT(yAssF_,COMPONENTSORT)(Result.Last->Data, Item, XASS); \
      Result.Length++; \
    } \
    return Result; \
  }


/*-- yDel_SORT (GPowerset)-----------------------------------------*/
#define GPowerset_Del(SORT, COMPONENTSORT) \
  extern SORT XCAT(yDel_,SORT) \
    XPP_PROTO( (COMPONENTSORT Item, SORT PS) ) \
    XPP_NOPROTO( (Item, PS)  COMPONENTSORT Item; SORT PS; ) \
  { \
    SORT Result; \
    XCAT(SORT,_yptr) Temp, Prev; \
    if (PS.IsAssigned) \
      Result = XCAT(yCopyList_,SORT)(PS); \
    else \
      Result = PS; \
    if ( Result.First != (XCAT(SORT,_yptr))0 ) { \
      Prev = Result.First; \
      if ( XCAT(yEqF_,COMPONENTSORT)(Prev->Data, Item) ) { \
        Result.First = Prev->Suc; \
        if (Result.Last == Prev) Result.Last = (XCAT(SORT,_yptr))0; \
        Prev->Suc = XCAT(yAvail_,SORT); \
        XCAT(yAvail_,SORT) = Prev; \
        Result.Length--; \
        return Result; \
      } \
      for (Temp=Prev->Suc; \
           Temp!=(XCAT(SORT,_yptr))0; \
           Temp=Temp->Suc) { \
        if ( XCAT(yEqF_,COMPONENTSORT)(Temp->Data, Item) ) {\
          Prev->Suc = Temp->Suc; \
          if (Result.Last == Temp) Result.Last = Prev; \
          Temp->Suc = XCAT(yAvail_,SORT); \
          XCAT(yAvail_,SORT) = Temp; \
          Result.Length--; \
          return Result; \
        } \
        Prev = Temp; \
      } \
    } \
    return Result; \
  }


/*-- yAnd_SORT (GPowerset)-----------------------------------------*/
#define GPowerset_And(SORT, COMPONENTSORT) \
  extern SORT XCAT(yAnd_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    SORT Result; \
    XCAT(SORT,_yptr) Temp; \
    Result = XCAT(yEmpty_,SORT)(); \
    for (Temp=PS1.First; Temp!=(XCAT(SORT,_yptr))0; Temp=Temp->Suc) \
      if ( XCAT(yInInner_,SORT)(Temp->Data, PS2) ) { \
        if (Result.First == (XCAT(SORT,_yptr))0) { \
          Result.First = XCAT(yGetAvail_,SORT)(); \
          Result.Last = Result.First; \
        } else { \
          Result.Last->Suc = XCAT(yGetAvail_,SORT)(); \
          Result.Last = Result.Last->Suc; \
        } \
        XCAT(yAssF_,COMPONENTSORT)(Result.Last->Data, Temp->Data, XASS); \
        Result.Length++; \
      } \
    if (! PS1.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS1); \
    if (! PS2.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS2); \
    return Result; \
  }


/*-- yOr_SORT (GPowerset)------------------------------------------*/
#define GPowerset_Or(SORT, COMPONENTSORT) \
  extern SORT XCAT(yOr_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    SORT Result; \
    XCAT(SORT,_yptr) Temp; \
    if (PS2.IsAssigned) \
      Result = XCAT(yCopyList_,SORT)(PS2); \
    else \
      Result = PS2; \
    for (Temp=PS1.First; Temp!=(XCAT(SORT,_yptr))0; Temp=Temp->Suc) \
      if ( ! XCAT(yInInner_,SORT)(Temp->Data, Result) ) { \
        if (Result.First == (XCAT(SORT,_yptr))0) { \
          Result.First = XCAT(yGetAvail_,SORT)(); \
          Result.Last = Result.First; \
        } else { \
          Result.Last->Suc = XCAT(yGetAvail_,SORT)(); \
          Result.Last = Result.Last->Suc; \
        } \
        XCAT(yAssF_,COMPONENTSORT)(Result.Last->Data, Temp->Data, XASS); \
        Result.Length++; \
      } \
    if (! PS1.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS1); \
    return Result; \
  }


/*-- yLE_SORT (GPowerset)------------------------------------------*/
#define GPowerset_LE(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yLE_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    SDL_Boolean Result; \
    Result = PS1.Length <= PS2.Length; \
    for (Temp=PS1.First; \
         Temp!=(XCAT(SORT,_yptr))0 && Result; \
         Temp=Temp->Suc) \
      if ( ! XCAT(yInInner_,SORT)(Temp->Data, PS2) ) \
        Result = SDL_False; \
    if (! PS1.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS1); \
    if (! PS2.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS2); \
    return Result; \
  }


/*-- yLT_SORT (GPowerset)------------------------------------------*/
#define GPowerset_LT(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yLT_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    SDL_Boolean Result; \
    Result = PS1.Length < PS2.Length; \
    for (Temp=PS1.First; \
         Temp!=(XCAT(SORT,_yptr))0 && Result; \
         Temp=Temp->Suc) \
      if ( ! XCAT(yInInner_,SORT)(Temp->Data, PS2) ) \
        Result = SDL_False; \
    if (! PS1.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS1); \
    if (! PS2.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&PS2); \
    return Result; \
  }


/*-- yGE_SORT (GPowerset)------------------------------------------*/
#define GPowerset_GE(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yGE_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    return XCAT(yLE_,SORT)(PS2, PS1); \
  }


/*-- yGT_SORT (GPowerset)------------------------------------------*/
#define GPowerset_GT(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yGT_,SORT) \
    XPP_PROTO( (SORT PS1, SORT PS2) ) \
    XPP_NOPROTO( (PS1, PS2)  SORT PS1; SORT PS2; ) \
  { \
    return XCAT(yLT_,SORT)(PS2, PS1); \
  }


/*-- yAss_SORT (GPowerset)-----------------------------------------*/
#define GPowerset_Assign(SORT, COMPONENTSORT) \
  static XCAT(SORT,_yptr)  XCAT(yAvail_,SORT) = (XCAT(SORT,_yptr))0; \
  extern void XCAT(yAss_,SORT) \
    XPP_PROTO( (SORT * SVar, SORT SExpr, int AssType) ) \
    XPP_NOPROTO( (SVar, SExpr, AssType)  SORT * SVar; SORT SExpr; int AssType; ) \
  { \
    if ((*SVar).First == SExpr.First) { \
      (*SVar).IsAssigned = (xbool)1; \
      return; \
    } \
    if (AssType == XASS && (*SVar).First != (XCAT(SORT,_yptr))0) { \
      XCAT(yFree_,SORT)((void **)SVar); \
    } \
    if ( (SExpr.IsAssigned || AssType == XASS2MAKE) && \
         SExpr.First != (XCAT(SORT,_yptr))0) { \
      *SVar = XCAT(yCopyList_,SORT)(SExpr); \
    } else { \
      (*SVar).First = SExpr.First; \
      (*SVar).Last = SExpr.Last; \
      (*SVar).Length = SExpr.Length; \
    } \
    (*SVar).IsAssigned = (xbool)1; \
  }


/*-- yEq_SORT (GPowerset)------------------------------------------*/
#define GPowerset_Equal(SORT, COMPONENTSORT) \
  extern SDL_Boolean XCAT(yEq_,SORT) \
    XPP_PROTO( (SORT Expr1, SORT Expr2) ) \
    XPP_NOPROTO( (Expr1, Expr2) SORT Expr1; SORT Expr2; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    SDL_Boolean Result; \
    Result = Expr1.Length == Expr2.Length; \
    for (Temp=Expr1.First; \
         Temp!=(XCAT(SORT,_yptr))0 && Result; \
         Temp=Temp->Suc) \
      if ( ! XCAT(yInInner_,SORT)(Temp->Data, Expr2) ) \
        Result = SDL_False; \
    if (! Expr1.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&Expr1); \
    if (! Expr2.IsAssigned) \
      XCAT(yFree_,SORT)((void **)&Expr2); \
    return Result; \
  }


/*-- yDef_SORT (GPowerset)-----------------------------------------*/
#define GPowerset_Default(SORT, COMPONENTSORT) \
  extern void XCAT(yDef_,SORT) \
    XPP_PROTO( (SORT *S) ) \
    XPP_NOPROTO( (S) SORT *S; ) \
  { \
    (*S).First = (XCAT(SORT,_yptr))0; \
    (*S).Last = (XCAT(SORT,_yptr))0; \
    (*S).Length = 0; \
    (*S).IsAssigned = (xbool)1; \
  }


/*-- yFree_SORT (GPowerset)---------------------------------------*/
#ifdef XFREEFUNCS
#define GPowerset_Free(SORT, COMPONENTSORT, HASCOMPFREE) \
  extern void XCAT(yFree_,SORT) \
    XPP_PROTO( (void ** C) ) \
    XPP_NOPROTO( (C) void ** C; ) \
  { \
    XCAT(SORT,_yptr)  Temp; \
    if (HASCOMPFREE) { \
      for (Temp =  (*(SORT *)C).First; \
           Temp != (XCAT(SORT,_yptr))0; \
           Temp =  Temp->Suc) { \
        XCAT(yFree_,COMPONENTSORT)((void **)&Temp->Data); \
      } \
    } \
    if ((*(SORT *)C).First != (XCAT(SORT,_yptr))0) { \
      (*(SORT *)C).Last->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = (*(SORT *)C).First; \
    } \
  }
#else
#define GPowerset_Free(SORT, COMPONENTSORT, HASCOMPFREE) \
  extern void XCAT(yFree_,SORT) \
    XPP_PROTO( (void ** C) ) \
    XPP_NOPROTO( (C) void ** C; ) \
  { \
    if ((*(SORT *)C).First != (XCAT(SORT,_yptr))0) { \
      (*(SORT *)C).Last->Suc = XCAT(yAvail_,SORT); \
      XCAT(yAvail_,SORT) = (*(SORT *)C).First; \
    } \
  }
#endif


/*-- yCard_SORT (GPowerset)---------------------------------------*/
#define GPowerset_Card(SORT, COMPONENTSORT) \
  extern SDL_Integer XCAT(yCard_,SORT) \
    XPP_PROTO( (SORT PS) ) \
    XPP_NOPROTO( (PS)  SORT PS; ) \
  { \
    return PS.Length; \
  }


/*-- yElement_SORT (GPowerset)------------------------------------*/
#define GPowerset_Element(SORT, COMPONENTSORT) \
  extern COMPONENTSORT XCAT(yElement_,SORT) \
    XPP_PROTO( (SORT PS, SDL_Integer Index) ) \
    XPP_NOPROTO( (PS, Index)  SORT PS; SDL_Integer Index; ) \
  { \
    XCAT(SORT,_yptr) Temp; \
    int Number = 0; \
    COMPONENTSORT Result; \
    for (Temp=PS.First; \
         Temp!=(XCAT(SORT,_yptr))0 && ++Number<Index; \
         Temp=Temp->Suc) ; \
    if (Number == Index && Temp != (XCAT(SORT,_yptr))0) \
      return Temp->Data; \
    xReportStringError("Element in Powerset sort", "Index out of range") \
    (void)memset((void *)(&Result), 0, sizeof(COMPONENTSORT)); \
    XCAT(yDef_,COMPONENTSORT)(&Result); \
    return Result; \
  }


/*-- yWri_SORT (GPowerset)----------------------------------------*/
#define GPowerset_Write(SORT, COMPONENTSORT) \
  extern char * XCAT(yWri_,SORT) \
    XPP_PROTO( (void * PS) ) \
    XPP_NOPROTO( (PS) void * PS; ) \
  { \
    XCAT(SORT,_yptr) Temp, TempLast; \
  static  char       CTemp[MAX_WRI_LENGTH]; \
    \
    strcpy(CTemp, "[ "); \
    TempLast = (*(SORT *)PS).Last; \
    for (Temp = (*(SORT *)PS).First; \
         Temp != (XCAT(SORT,_yptr))0; \
         Temp = Temp->Suc) { \
      xSafeStrcat(CTemp, \
             xWriteSort((void *)(&Temp->Data), XCAT(ySrtN_,COMPONENTSORT))); \
      if (strlen(CTemp) == MAX_WRI_LENGTH - 1) \
        return CTemp; \
      if (Temp != TempLast) \
        xSafeStrcat(CTemp, ", "); \
    } \
    xSafeStrcat(CTemp, " ]"); \
    return CTemp; \
  }


/*-- yRead_SORT (GPowerset)---------------------------------------*/
#define GPowerset_Read(SORT, COMPONENTSORT) \
  extern int XCAT(yRead_,SORT) \
    XPP_PROTO( (void * Result) ) \
    XPP_NOPROTO( (Result) void * Result; ) \
  { \
    COMPONENTSORT Item; \
    xxToken       Token; \
    char          strVar[256]; \
    int           Res; \
    \
    (*(SORT *)Result).First = (XCAT(SORT,_yptr))0; \
    (*(SORT *)Result).Last = (XCAT(SORT,_yptr))0; \
    (*(SORT *)Result).Length = 0; \
    (*(SORT *)Result).IsAssigned = (int)0; \
    Token = xScanToken(strVar); \
    if (Token != xxLBracket && Token != xxQuestionMark && Token != xxEoln) { \
      xPrintString("Powerset value should start with [\n"); \
      return 0; \
    } \
    if (Token != xxLBracket) xUngetToken(Token, strVar); \
    \
    while (Token != xxRBracket) { \
      sprintf(strVar, " (%s) : ", XCAT(ySrtN_,COMPONENTSORT)->Name); \
      (void)memset((void *)(&Item), 0, sizeof(COMPONENTSORT)); \
      Res = xReadOneParameter(XCAT(ySrtN_,COMPONENTSORT), strVar, (void *)&Item); \
      if (Res == 0) return 0; \
      if (Res == 2) { \
        Token = xScanToken(strVar); \
        if (Token == xxRBracket) break; \
        return 0; \
      } \
      *(SORT *)Result = XCAT(yIncl_,SORT)(Item, *(SORT *)Result); \
      Token = xScanToken(strVar); \
      if (Token != xxRBracket) xUngetToken(Token, strVar); \
    } \
    (*(SORT *)Result).IsAssigned = (int)1; \
    return 1; \
  }
#endif
   /* XNO_LONG_MACROS */




#endif
   /* X_SCTPRED_H */

/*******************************************************************************
* History log:
*===============================================================================
* $Log: sctpred.h,v $
* Revision 1.4  2001/07/18 13:01:54  pbo
* New Release UGLOBE_2
*
* Revision 3.0  2001/07/18 11:29:36  pbo
* DUM_2
*
* Revision 2.0  2001/06/12 11:52:25  pbo
* DUM_1
*
* Revision 1.1.1.1  2001/03/28 13:37:25  pbo
* Initial version
*
*******************************************************************************/

