/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : oss_clib.c
* ļ : 
* ʵֹ : ossCӿ
*      : 
*      : V1.0
*  : 2013/01/12
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 
*    : 
* ޸ : 
* ޸ : 
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#if defined _OS_TOS || defined _OS_OSE
#include "drv_api.h"
#elif defined (_OS_LINUX)
#include <linux/time.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************
* 궨
**************************************************************************/

/**************************************************************************
* ⲿ
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
 
/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/

/**************************************************************************
* ȫֺʵ
**************************************************************************/

#if defined _OS_OSE || defined _OS_WIN

/**************************************************************************
* ƣmem_memcpy
* ڴ濽
* ˵(IN) dest_ptr:ָĿڴָ
                 src_ptr:ָԴڴָ
                 size:ֽ
*   ֵ
* ˵
**************************************************************************/
VOID *mem_memcpy(VOID *dest_ptr, const VOID *src_ptr, UINT32 size, const CHAR *file, UINT32 line)
{
    if(size == 0)
    {
        return dest_ptr;
    }
    zOss_AssertEx(dest_ptr != NULL, NULL);
    zOss_AssertEx(src_ptr != NULL, NULL);

    return memcpy(dest_ptr, src_ptr, size);
}

/**************************************************************************
* ƣmem_memset
* ڴ渳ֵ
* ˵(IN) dest_ptr:ҪֵĿڴָ
                 value:ֵ
                 size:ֵֽ
*   ֵdest_ptrָ
* ˵
**************************************************************************/
VOID *mem_memset(VOID *dest_ptr, SINT32 value, UINT32 size, const CHAR *file, UINT32 line)
{
    if (size == 0)
    {
        return dest_ptr;
    }

    zOss_AssertEx(dest_ptr != NULL, NULL);

    return memset(dest_ptr, value, size);
}

/**************************************************************************
* ƣmem_memmove
* ڴ渴
* ˵(IN)    dest_ptr:Ŀڴָ
                    src_ptr:Դڴָ
                    count:Ƶֽڸ
*   ֵĿڴָ
* ˵
**************************************************************************/
VOID* mem_memmove(VOID* dest_ptr, const VOID* src_ptr, UINT32 count)
{
    if(count == 0)
    {
        return  dest_ptr;
    }
    zOss_AssertEx(dest_ptr != NULL, NULL);
    zOss_AssertEx(src_ptr != NULL, NULL);

    return memmove( dest_ptr, src_ptr, count);
}

/**************************************************************************
* ƣmem_memcmp
* ڴȽ
* ˵(IN)    f_buf_ptr:һڴָ
                    s_buf_ptr: ڶڴָ
                    count:Ƚϵֽڸ
*   ֵ
* ˵
**************************************************************************/
SINT32 mem_memcmp(const VOID *f_buf_ptr, const VOID* s_buf_ptr, UINT32 count)
{
    if(count == 0)
    {
        return 0;
    }
    zOss_AssertEx(f_buf_ptr != NULL, -1);
    zOss_AssertEx(s_buf_ptr != NULL, -1);    

    return memcmp(f_buf_ptr, s_buf_ptr, count);
}
#endif

#ifdef _OS_OSE
/**************************************************************************
* :     شӹԪ197011յUTCʱ0ʱ00
* ˵:     
*   ()  void
*   ()  t:  ӹԪ197011յUTCʱ0ʱ00
                    òΪNULL
*   ֵ:     ӹԪ197011յUTCʱ0ʱ00
* ˵:     void
**************************************************************************/
ZOSS_TIME_T zOss_Time(ZOSS_TIME_T *t)
{
#ifdef _USE_CP_RTC
    struct tm           timeTab = {0};
    T_ZDrvRtc_TimeDate  rtc     = {0};
    ZOSS_TIME_T         secNum  = 0;
    SINT32              ret     = 0;

    ret = Rtc_GetDateTime(&rtc);
    if (ret != 0)
    {
        return 0x00;
    }

    timeTab.tm_sec  = rtc.second;
    timeTab.tm_min  = rtc.minute;
    timeTab.tm_hour = rtc.hour;
    timeTab.tm_mday = rtc.day;
    timeTab.tm_mon  = rtc.month - 1;
    timeTab.tm_year = rtc.year - 1900;

    secNum = (ZOSS_TIME_T)mktime(&timeTab);
    if (t)
    {
        *t = secNum;
    }

    return secNum;
#else
    return 0x00;
#endif
}
#endif

#ifdef _OS_LINUX
/**************************************************************************
* :     شӹԪ197011յUTCʱ0ʱ00
* ˵:     
*   ()  void
*   ()  t:  ӹԪ197011յUTCʱ0ʱ00
                    òΪNULL
*   ֵ:     ӹԪ197011յUTCʱ0ʱ00
* ˵:     void
**************************************************************************/
ZOSS_TIME_T zOss_Time(ZOSS_TIME_T *t)
{
    return 0x00;
}

time_t time(time_t *__timer)
{
    return jiffies;
}

#ifndef USE_CPPS_KO
int raise(int signo)
{
    return 0x00;
}
#endif
#endif

#if defined (_OS_TOS) || defined (_OS_OSE) || defined (_OS_LINUX)
/**************************************************************************
* :     intתΪַ
* ˵:     
*   ()  num:    Ҫת
                str:    ַĵַ
                radix:  
*   ()  void
*   ֵ:     ɹ:شַĵַ;ʧ:NULL
* ˵:     ÷μ׼itoa()
**************************************************************************/
char *itoa(int num, char *str, int radix)
{
    char            string[]    = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    char            *ptr        = str;
    char            *gptr       = str;
    unsigned int    pnum        = 0;
    int             i           = 0;
    int             j           = 0;
    int             n           = 0;
    
    if (radix < 2 || radix > 36 || str == NULL)
    {
        return NULL;
    }
    
    if (num < 0 && radix == 10)
    {
        *ptr = '-';
        ptr++;
        gptr = ptr;
        i = 1;
        pnum = (unsigned int)(-num);
    }
    else
    {
        i = 0;
        pnum = (unsigned int)num;
    }
    
    while (pnum || gptr == ptr)
    {
        *ptr = string[(unsigned)(pnum % (unsigned int)radix)];
        ptr++;
        pnum /= (unsigned int)radix;
        
        if (pnum < (unsigned int)radix)
        {
            if (pnum != 0)
            {
                *ptr = string[pnum];
                ptr++;
            }
            *ptr = '\0';
            break;
        }
    }
    
    j = (ptr - str) - 1;
    
    for (n = 0; n < (ptr - gptr) / 2; n++)
    {
        char temp = str[i];
        str[i] = str[j];
        str[j--] = temp;
        i++;
    }
    
    return str;
}

#endif

#ifdef _OS_WIN
/**************************************************************************
* :  zOss_Time
* :  شӹԪ197011յUTCʱ0ʱ00
             
* ˵:  (IN) t:This parameter may be NULL, in which case the return value is not stored
*   ֵ:ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵:
**************************************************************************/
ZOSS_TIME_T zOss_Time(ZOSS_TIME_T *t)
{
    return (ZOSS_TIME_T)time((long *)t);
}
#endif

#ifdef _OS_LINUX
char *strtok_r(char *s, const char *delim, char **last)
{
	char *spanp;
	int c, sc;
	char *tok;


	if (s == NULL && (s = *last) == NULL)
		return (NULL);

	/*
	 * Skip (span) leading delimiters (s += strspn(s, delim), sort of).
	 */
cont:
	c = *s++;
	for (spanp = (char *)delim; (sc = *spanp++) != 0;) {
		if (c == sc)
			goto cont;
	}

	if (c == 0) {		/* no non-delimiter characters */
		*last = NULL;
		return (NULL);
	}
	tok = s - 1;

	/*
	 * Scan token (scan for delimiters: s += strcspn(s, delim), sort of).
	 * Note that delim must have one NUL; we stop if we see that, too.
	 */
	for (;;) {
		c = *s++;
		spanp = (char *)delim;
		do {
			if ((sc = *spanp++) == c) {
				if (c == 0)
					s = NULL;
				else
					s[-1] = 0;
				*last = s;
				return (tok);
			}
		} while (sc != 0);
	}
	/* NOTREACHED */
}

char *strtok(char *s, const char *delim)
{
	static char *last;

	return strtok_r(s, delim, &last);
}

void perror(const char *s)
{
	
}
  
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/

#ifdef __cplusplus
 }
#endif


