/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_except_csky.c
* ļ : 
* ʵֹ : TOS 3.0 cskycpu쳣ģ
*      : 
*      : V1.0
*  : 2011/11/03
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include <cyg/infra/cyg_type.h>
#include <cyg/kernel/kapi.h>
#include <cyg/infra/diag.h>
#include <cyg/hal/hal_intr.h>
#include <errno.h>

#include "oss_api.h"
#include "tos_except_csky.h"
#include "tos_mmu_csky.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* ⲿ
**************************************************************************/
extern void cyg_user_idle(void);
extern int zte_sys_err_hnd(int user_called, int ecode, int extra);

/**************************************************************************
* 궨
**************************************************************************/
#define EXCEPT_LOCK()   ZOSS_SAVE_IRQ(old_intr)
#define EXCEPT_UNLOCK() ZOSS_RESTORE_IRQ(old_intr)

/**************************************************************************
* ݽṹ
**************************************************************************/
enum {
    TOS_EXCEPT_NONE         = -1,
    TOS_EXCEPT_CPU_START    = 0,
    TOS_EXCEPT_CPU_END      = 127,
    TOS_EXCEPT_ASSERT       = 128
};

/**************************************************************************
* ֲԭ
**************************************************************************/

/**************************************************************************
* ȫֳ/
**************************************************************************/
static tos_except_t    tos_except             = {0};
tos_except_register_t  *tos_except_register   = NULL;


/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* :     cksy쳣
* ˵:     
*   ()  data:               쳣
                exception_number:   쳣
                info:               쳣ʱCPU context
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void tos_except_handler( cyg_addrword_t  data,
                                cyg_code_t      exception_number,
                                cyg_addrword_t  info)
{
    tos_except.nr = exception_number;
    switch (exception_number) 
    {
    case CYGNUM_HAL_VECTOR_TLBMISMATCH:
        {
            tos_csky_mmu_tlb_mismatch((HAL_SavedRegisters *)info);
            break;
        }
    default:
        {
            break;
        }
    }
    
    zOss_ASSERT(0);
}


/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* :     ʧܻص
* ˵:     
*   ()  exp:    Աʽ
                file:   Եļ
                line:   Եк
*   ()  void
*   ֵ:     void
* ˵:     úֻӦzOss_ASSERTʧܵ±
**************************************************************************/
void tos_assert_failed(const char *exp, const char *file, const char *func, int line)
{
    cyg_uint32 old_intr;
    
    EXCEPT_LOCK();
    if (tos_except.nr == TOS_EXCEPT_NONE)
    {
        tos_except.nr = TOS_EXCEPT_ASSERT;
    }
    tos_except.exp     = exp;
    tos_except.file    = file;
    tos_except.func    = func;
    tos_except.line    = line;
    
#if 1
# ifdef _USE_MULTI_CORE_RAMDUMP
    zOss_RamdumpHandle(1, 1, 1);
# else
    zte_sys_err_hnd(1, 1, 1);
# endif
#else
    while (tos_except.trace_flag == FALSE) 
    {
        HAL_BREAK();
    }
#endif
}


/**************************************************************************
* :     쳣ĳʼ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ʼ
* ˵:     ο׼errnoĶ
**************************************************************************/
int zOss_ExceptInit(void)
{
    cyg_code_t cnt = 0;
    cyg_uint32 old_intr;

    EXCEPT_LOCK();
    tos_except.nr      = TOS_EXCEPT_NONE;
    tos_except.exp     = NULL;
    tos_except.file    = NULL;
    tos_except.func    = NULL;
    tos_except.line    = -1;
    EXCEPT_UNLOCK();
    for (cnt = CYGNUM_HAL_VECTOR_RESET; cnt < CYGNUM_HAL_VECTOR_SYS; cnt++) 
    {
        if (cnt == CYGNUM_HAL_VECTOR_AUTOVEC)
        {
            continue;
        }
        
        cyg_exception_set_handler(cnt,                  /* exception_number */
                                  tos_except_handler,   /* new_handler      */
                                  0x00,                 /* new_data         */
                                  NULL,                 /* old_handler      */
                                  NULL);                /* old_data         */
    }

    return ENOERR;
}


/**************************************************************************
* :     ȡ쳣Ĵڴַ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     쳣Ĵڴַ
* ˵:     void
**************************************************************************/
tos_except_register_t *tos_dump_except_register(void)
{
    return tos_except_register;
}


/**************************************************************************
* :     TOS 3.0ϵͳidle߳
* ˵:     
*   ()  loop_count:     idle߳ѭĴ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_idle_thread(cyg_uint32 loop_count)
{
    cyg_user_idle();
}


/**************************************************************************
* :     fatal쳣
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_fatal_except_handler(void)
{
    cyg_uint32 old_intr;

    EXCEPT_LOCK();

    pool_print_leak(0x00);
    pool_print_free();
    pool_print_alloc_fail();
    pool_print_alloc_statistic();
    pool_trace_leak_end(0x00);

    HAL_BREAK();
}

char *ramdump_error_log_exp(char *mem)
{
	return mem;
}

#ifdef __cplusplus
}
#endif

