/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name:  hal_init_evb.c
 * File Mark:
 * Description:  hal layer  initialization
 * Others:
 * Version:       1.0
 * Author:        lmf
 * Date:
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
  ********************************************************************************/

/****************************************************************************
*                                              Include files
****************************************************************************/
#include "drv_api.h"

/****************************************************************************
*                                              Local Macros
****************************************************************************/
/*define the numbers of device that will be init firstly.*/
#define HAL_DEV_INIT_NUM_MAX       64
/****************************************************************************
*                                              Local Types
****************************************************************************/

typedef struct
{
    SINT32 (*Init)(VOID);
}
T_Hal_DevRegister;


/****************************************************************************
*                                              Local Constants
****************************************************************************/

/****************************************************************************
*                                              Local Function Prototypes
****************************************************************************/
/*---------------------------Init------------------------------------*/
extern SINT32 zDrvTDpram_Initiate(VOID);
extern SINT32 zDrvWDpram_Initiate(VOID);
extern SINT32 zDrvRtc_Initiate(VOID);
extern SINT32 zDrvSys_Initiate(VOID);
extern SINT32 zDrvTimer_Initiate(VOID);
extern SINT32 zDrvDma_Initiate(VOID);
extern SINT32 zDrvVoice_Initiate(VOID);
extern SINT32 zDrvI2c_Initiate(VOID);
extern SINT32 zDrvSsp_Initiate(VOID);
extern SINT32 zDrvUart_Initiate(VOID);
extern SINT32 zDrvComm_Initiate(VOID);
extern SINT32 zDrvSd_Initiate(VOID);
extern SINT32 zDrvEDCP_Initiate(VOID);
extern SINT32 zDrvCipher_Initiate(VOID);
extern SINT32 zDrvNand_Initiate(VOID);
extern SINT32 zDrvPmic_Initiate(VOID);
extern SINT32 zDrvNand_Initiate(VOID);
extern SINT32 zDrvRamLog_Initiate(VOID);
extern SINT32 zDrvRpMsg_Initiate(VOID);
extern SINT32 zDrvGpio_Initiate(VOID);
extern SINT32 zDrvCipher_Initiate(VOID);
extern SINT32 zDrvLed_Initiate(VOID);
extern SINT32 zDrvPcu_Initiate(VOID);
extern SINT32 zDrvWdt_Initiate(VOID);
//#if defined(_USE_PSM)
extern SINT32 zDrvPow_Initiate(VOID);
//#endif
extern SINT32 zDrvChg_Initialize(VOID);
extern SINT32 zDrvKpd_Initiate(VOID);
extern SINT32 zDrvUICC_Initiate(VOID);

extern VOID sdio_wifi_init(VOID);
extern SINT32 dhd_wifi_power_init(VOID);
extern SINT32 zDrvSys_PreInit(VOID);
extern SINT32 zDrvSysSpinlock_Initiate(VOID);
extern SINT32 zDrvLinux_Initiate(VOID);
extern SINT32 zDrvRndisnet_Initiate(void);
extern SINT32 zDrvTsc_Initiate(VOID);
extern SINT32 zDrvDdrNet_Initiate(void);
extern SINT32 zDrvLcd_Initiate(VOID);
extern SINT32 zDrvFm_Initiate(VOID);
extern SINT32 zDrvVib_Initiate(VOID);
extern SINT32 zDrvFlashlight_Initiate(VOID);
extern SINT32 zDrvCam_Initiate(VOID);
extern SINT32 zDrvVOU_Initiate(VOID);
extern SINT32 zDrvComm_Initiate(VOID);


//extern SINT32 zDrvTest_Initiate(void);
/****************************************************************************
*                                             Global Constants
****************************************************************************/

/****************************************************************************
*                                             Global Variables
****************************************************************************/
static T_Hal_DevRegister gHal_ProductDev_RegisterTbl[] =
{
	zDrvSysSpinlock_Initiate,
    zDrvPcu_Initiate,
//    zDrvGpio_Initiate,
    zDrvRamLog_Initiate,
    zDrvComm_Initiate, 
    zDrvSys_Initiate,
    zDrvTimer_Initiate,
//    zDrvDma_Initiate,
//    zDrvSsp_Initiate,
//    zDrvLcd_Initiate,
//    zDrvI2c_Initiate,
//    zDrvNand_Initiate,
//    zDrvPmic_Initiate,  /*FPGA_TEST,ûPMIC*/
//    zDrvUart_Initiate,
    zDrvRpMsg_Initiate,
    zDrvUICC_Initiate,
    #if PS_RAT_TDD
    zDrvTDpram_Initiate,
    #endif
    #if PS_RAT_FDD	
    zDrvWDpram_Initiate,
    #endif
//    zDrvRtc_Initiate,
    zDrvCipher_Initiate,
   // dhd_wifi_power_init,
//	zDrvSd_Initiate,
	//sdio_wifi_init,
	//zDrvLed_Initiate,
  zDrvEDCP_Initiate, /*FPGA_TEST,EDCPĴȷϹԴʱȷ*/
//#ifdef _USE_PSM_CHARGER_TEST
//	zDrvChg_Initialize,
//#endif
//	zDrvKpd_Initiate,
#ifdef _WDT_RST
    zDrvWdt_Initiate,
#endif
#if defined _USE_TEAKAUD
	//zDrvVoice_Initiate,
#endif
	//zDrvFm_Initiate,
	//zDrvVib_Initiate,

#if defined(_USE_PSM)
    zDrvPow_Initiate,
#endif
//	zDrvTsc_Initiate,

	//zDrvTest_Initiate,
//    zDrvDdrNet_Initiate,
    //zDrvFlashlight_Initiate,
#if defined(_USE_CAMERA)
	zDrvCam_Initiate,
#endif
#if defined(_USE_VOU)
	zDrvVOU_Initiate,
#endif
    {NULL}
};


static UINT32 gHal_ProductDev_Num = (sizeof(gHal_ProductDev_RegisterTbl) / sizeof(
        T_Hal_DevRegister)) - 1;

/****************************************************************************
*                                             Global Function Prototypes
****************************************************************************/

/****************************************************************************
*                                             Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: zDrv_Product_Halinit
 * Description: ͺŻص豸HALʼ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
SINT32 zDrv_Product_Halinit(VOID)
{
    UINT32 dev_index = 0;
    SINT32 nRet;

    /*if (gHal_ProductDev_Num > HAL_DEV_INIT_NUM_MAX)
    {
        return DRV_ERROR;
    }*/

    for (; dev_index < gHal_ProductDev_Num; dev_index++)
    {

        if (gHal_ProductDev_RegisterTbl[dev_index].Init != NULL)
        {

            nRet = gHal_ProductDev_RegisterTbl[dev_index].Init();
            if (nRet != DRV_SUCCESS)
            {
                zOss_RamLog("Hal_init_evb:init fail,dev_index=%d!\n", dev_index);
                zOss_RamLog("Hal_init_evb:ret=%d!\n", nRet);
                zOss_ASSERT(0);
                return nRet;
            }
        }
    }
    return DRV_SUCCESS;
}
