/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:
 * Others:
 * Version:       0.1
 * Author:        shideyou
 * Date:          2013-7-8
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_ICP_H
#define _DRVS_ICP_H

#include "ram_config.h"
#include "drvs_rpmsg.h"
/*******************************************************************************
*                                  Macro                                       *
*******************************************************************************/

/*******************************************************************************
*                                  Types                                       *
*******************************************************************************/
#if 0
typedef enum _T_HalIcp_MsgActor
{
    ICP_MSG_ACTOR_M0,
    ICP_MSG_ACTOR_PHY,
    ICP_MSG_ACTOR_ARM = ICP_MSG_ACTOR_PHY,
    MAX_ICP_MSG_ACTOR
} T_HalIcp_MsgActor;

typedef enum _T_HalIcp_ModuleId
{
    ICP_ARM0_MODULE_ID_BASE,    // 0
	ICP_ARM0_MODULE_ID_DRV = ICP_ARM0_MODULE_ID_BASE,   
    ICP_ARM0_MODULE_ID_PSM,     // 1
    ICP_ARM0_MODULE_ID_OS,      // 2
    ICP_ARM0_MODULE_ID_LTEPS,   // 3
    ICP_ARM0_MODULE_ID_TDPS,    // 4
    ICP_ARM0_MODULE_ID_WPS,     // 5
    ICP_ARM0_MODULE_ID_LTEPSM,  // 6
    ICP_ARM0_MODULE_ID_TDPSM,   // 7
    ICP_ARM0_MODULE_ID_WPSM,    // 8
    MAX_ICP_ARM0_MODULE_ID = ICP_ARM0_MODULE_ID_WPSM,

    ICP_ARM1_MODULE_ID_BASE,    // 9
    ICP_ARM1_MODULE_ID_DRV = ICP_ARM1_MODULE_ID_BASE,
    ICP_ARM1_MODULE_ID_PSM,     // 10
    ICP_ARM1_MODULE_ID_OS,      // 11
    ICP_ARM1_MODULE_ID_LTEPHY,  // 12 
    ICP_ARM1_MODULE_ID_TDPHY,   // 13
    ICP_ARM1_MODULE_ID_WPHY,    // 14
    ICP_ARM1_MODULE_ID_LTEPSM,  // 15
    ICP_ARM1_MODULE_ID_TDPSM,   // 16
    ICP_ARM1_MODULE_ID_WPSM,    // 17
    MAX_ICP_ARM1_MODULE_ID = ICP_ARM1_MODULE_ID_WPSM,

    ICP_M0_MODULE_ID_BASE,      // 18
    ICP_M0_MODULE_ID_DRV = ICP_M0_MODULE_ID_BASE,
	ICP_M0_MODULE_ID_PSM,       // 19
	ICP_M0_MODULE_ID_OS,        // 20
    MAX_ICP_M0_MODULE_ID = ICP_M0_MODULE_ID_OS,

    MAX_ICP_MODULE_ID           // 21
} T_HalIcp_ModuleId;

typedef enum _T_HalIcp_CallbackType
{
    ICP_ISR_CALLBACK,
    ICP_HISR_CALLBACK,

    MAX_ICP_CALLBACK_TYPE
}T_HalIcp_CallbackType;
#endif
typedef struct _T_HalIcp_Dword
{
    UINT32 low_word;
    UINT32 high_word;
} T_HalIcp_Dword;

typedef struct _T_HalIcp_Msg
{
    UINT32 SrcModId;
    UINT32 desModId;
    T_HalIcp_Dword     IntInfo;
    UINT32 sfn;
    VOID *pBuf;
    UINT32 len;
} T_HalIcp_Msg;
#if 0
typedef VOID (*T_HalIcp_CallbackFunction)(const T_HalIcp_Msg *pMsg);


/*******************************************************************************
*                           Function Prototypes                                *
*******************************************************************************/
/*******************************************************************************
* Function: zDrvIcp_RegCallback
* Description: This function is used for registing callback functions;
* Parameters:
*	Input:
*		me: which module regists callback function.
*		from: which is this function for.
*		callback: the callback function.
*		callbackType: where is this function, isr or hisr.
*		
*	Output:None
*
* Returns:
*	DRV_SUCCESS
*	DRV_ERROR
*
* Others:
********************************************************************************/
SINT32 zDrvIcp_RegCallback(UINT32 me, 
									UINT32 from, 
										T_HalIcp_CallbackFunction callback, 
											T_HalIcp_CallbackType callbackType);

/*******************************************************************************
* Function: zDrvIcp_SendMsg
* Description: This function is used for sending ICP MSG;
* Parameters:
*   Input:
*       pMsg: the msg which will be sent
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully send msg.
*   DRV_ERROR: fail to send msg.
*
*
* Others:
********************************************************************************/
SINT32 zDrvIcp_SendMsg(const T_HalIcp_Msg *pMsg);

/*******************************************************************************
* Function: zDrvIcp_SendMsg_Psm
* Description: This function is used for sending ICP MSG during interrupt disabled;
* Parameters:
*   Input:
*       pMsg: the msg which will be sent
*   Output:None
*
* Returns:
*   DRV_SUCCESS: successfully send msg.
*   DRV_ERROR: fail to send msg.
*
*
* Others:
********************************************************************************/
SINT32 zDrvIcp_SendMsg_Psm(const T_HalIcp_Msg *pMsg);


/*******************************************************************************
* Function: zDrvIcp_Mask
* Description: This function is used for mask ICP interrupt from another core;
* Parameters:
*   Input:
*       actor: which core.
*       bit_map: which interrupts will be masked.
*   Output:None
*
* Returns:
*   None
*
*
* Others:
********************************************************************************/
SINT32 zDrvIcp_Mask(T_HalIcp_MsgActor actor, T_HalIcp_Dword bit_map);

 /*******************************************************************************
 * Function: zDrvIcp_Unmask
 * Description: This function is used for unmask ICP interrupt from another core;
 * Parameters:
 *	 Input:
 *		 actor: which core.
 *		 bit_map: which interrupts will be unmasked.
 *	 Output:None
 *
 * Returns:
 *	 None
 *
 *
 * Others:
 ********************************************************************************/
 SINT32 zDrvIcp_Unmask(T_HalIcp_MsgActor actor, T_HalIcp_Dword bit_map);

 /*******************************************************************************
* Function: zDrvIcp_GetState
* Description: This function is used for getting state;
* Parameters:
*   Input:
*       actor: which core.
*   Output:None
*       pState: the current state.
*
* Returns:
*   DRV_ERR_INVALID_PARAM
*   DRV_SUCCESS
*
* Others:
********************************************************************************/
 SINT32 zDrvIcp_GetState(T_HalIcp_MsgActor actor, T_HalIcp_Dword *pState);

 /*******************************************************************************
* Function: zDrvIcp_ClearState
* Description: This function is used for clear state;
* Parameters:
*   Input:
*       actor: which core.
*       bit_map: which bits' state will be clear, 0-not clear, 1-clear.
*   Output:None
*
* Returns:
*   None
*
*
* Others:
********************************************************************************/
 SINT32 zDrvIcp_ClearState(T_HalIcp_MsgActor actor, T_HalIcp_Dword bit_map);
#endif
#endif /* _DRVS_ICP_H */

