/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:   drvs_pow.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.3.0
 * Author:        wangxia
 * Date:          2009-6-10
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_POW_H
#define _DRVS_POW_H

/****************************************************************************
*                                           Include files
****************************************************************************/

/****************************************************************************
*                                              macro define
****************************************************************************/
//#define _USE_PSM
//#define _USE_PSM_DEBUG

#ifdef	_OS_LINUX
#define PSM_CPU_CP   0
#else
#define PSM_CPU_CP   1
#endif

#ifdef _CPU_DFS_ON
#define PSM_CPU_DFS   1
#else
#define PSM_CPU_DFS   0
#endif

#ifdef _AXI_DFS_ON
#define PSM_AXI_DFS   1
#else
#define PSM_AXI_DFS   0
#endif

#ifdef _AXI_DFS_ON_HW
#define PSM_AXI_DFS_HW	 1	//axi change by hw
#else
#define PSM_AXI_DFS_HW	 0
#endif

#ifdef _DDR_DFS_ON
#define PSM_DDR_DFS   1
  #if PSM_DDR_DFS
  #define PSM_DDR_DFS_HW	 1  //ddr change by hw
  #endif
#else
#define PSM_DDR_DFS   0
#define PSM_DDR_DFS_HW	 0
#endif

#ifdef _VCORE_DVS_ON
#define PSM_VCORE_DVS 1
#else
#define PSM_VCORE_DVS 0
#endif


#define POW_IDLE_TIMEOUT_MS                 (1)
#define POW_IDLE_TIMEOUT_TCPIP              (5*1000*POW_IDLE_TIMEOUT_MS)

#define ICP2M0_PSM_AT_CMD_VALID             0x49435001
#define ICP2M0_PSM_AXI_DFS                  0x49435002

/****************************************************************************
*                                             Global Variables
****************************************************************************/


/****************************************************************************
*                                           Types
****************************************************************************/
typedef enum
{
/*PS wake int dis reg1 begin*/
    PS_RM_INT_DIS=1,
    UART0_RXD_INT_DIS=2,
    SD0_DATA1_INT_DIS=3,
    PS_TIMER1_INT_DIS,
    PS_TIMER2_INT_DIS,
    ICP_AP2PS_INT_DIS,
    USB2_POWERDWN_UP_INT_DIS,
    USB2_POWERDWN_DOWN_INT_DIS,
    HSIC_POWERDWN_UP_INT_DIS,
    HSIC_POWERDWN_DOWN_INT_DIS,
    ICP_PHY2PS_INT_DIS,
    ICP_M02PS_INT_DIS,
    RM_RTC_ALARM_INT_DIS,
    RM_RTC_TIMER_INT_DIS,
    RM_KEYPAD_INT_DIS,
    SD1_DATA1_INT_DIS,
    UART0_CTS_INT_DIS,
    SPCU_PW_INT_DIS,
    GSM_LPM_INT_DIS,
    TD_LPM_TIMER_IND3_DIS=24,
    TD_LPM_TIMER_IND4_DIS,
    LTE_LPM_TIMER_IND2_DIS,
    LTE_LPM_TIMER_IND4_DIS,
    LTE_LPM_TIMER_IND5_DIS,
    WD_LPM_TIMER_IND3_DIS,
    WD_LPM_TIMER_IND4_DIS,
    FRM_INT_ARM_32K_DIS=31,
/*PS wake int dis reg1 end*/
/*PS wake int dis reg2 begin*/
    EXTERNAL_INT0_DIS=34,
    EXTERNAL_INT1_DIS,
    EXTERNAL_INT2_DIS,
    EXTERNAL_INT3_DIS,
    EXTERNAL_INT4_DIS,
    EXTERNAL_INT5_DIS,
    EXTERNAL_INT6_DIS,
    EXTERNAL_INT7_DIS,
    EXTERNAL_8IN1_INT0_DIS,
    EXTERNAL_8IN1_INT1_DIS,
    EXTERNAL_8IN1_INT2_DIS,
    EXTERNAL_8IN1_INT3_DIS,
    EXTERNAL_8IN1_INT4_DIS,
    EXTERNAL_8IN1_INT5_DIS,
    EXTERNAL_8IN1_INT6_DIS,
    EXTERNAL_8IN1_INT7_DIS=49,

    INVALID_WAKE_DIS_BIT
/*PS wake int dis reg2 end*/
}T_ZDrvPow_PsIntWakeDis;

typedef enum
{
    PS_WAKE_INT,
    PS_DIS_WAKE_INT,

    INVALID_PS_WAKE_EN
}T_ZDrvPow_PsWakeIntDis;


typedef enum
{
    IDLE_FLAG_UICC =0,
    IDLE_FLAG_USBENUM =1,
    IDLE_FLAG_VOICE =2,
    IDLE_FLAG_I2S=3,
    IDLE_FLAG_AP2CP=4,
    IDLE_FLAG_SLEEP=5,
    IDLE_FLAG_WIFI=6,
    IDLE_FLAG_KPD=7,
    IDLE_FLAG_TCPIP=8,
    IDLE_FLAG_NAND=9,
    IDLE_FLAG_CHARGER=10,
    IDLE_FLAG_LCD=11,
    IDLE_FLAG_LED=12,
    IDLE_FLAG_WIFI_IOCTRL=13,
    IDLE_FLAG_WIFI_XMIT=14,
    IDLE_FLAG_LAN=15,
    IDLE_FLAG_HOSTENUM=16,
    IDLE_FLAG_BLG=17,
    IDLE_FLAG_UART=18,
    IDLE_FLAG_TD_ICP=19,/*ֹʹ֡ж֡жϵڼ*/
    IDLE_FLAG_W_ICP=20,
    IDLE_FLAG_LTE_ICP=21,
    IDLE_FLAG_CAMERA=22,
    IDLE_FLAG_SD=23,
    IDLE_FLAG_PMIC=24,
    IDLE_FLAG_I2C=25,
    IDLE_FLAG_VSIM = 26,
    IDLE_FLAG_EDCP=27,
    IDLE_FLAG_TDM,    
    IDLE_FLAG_MAX

}T_ZDrvPow_IdleFlag;

/*plat begin*/
typedef enum
{
    TD_PHY =0,
    WD_PHY =1,
    LTE_PHY =2,
    PHY_ID_MAX

}T_ZDrvPow_PhyId;

typedef enum
{
    POW_BOOT_DEFAULT,       /* ʼֵ                           */
    POW_SYSINIT_FINISH,     /* ϵͳʼ,ͺŻSysEntry  */
    POW_BOOT_FINISH         /* ɣͺŻִ       */
}T_ZDrvPow_BootStage;           /* ׶        */
/*plat begin*/

/*sleep begin*/
typedef struct _T_ZDrvPow_Opt
{
    VOID (*pow_RefBeforeSleep)(VOID);
    VOID (*pow_RefAfterSleep)(VOID);
}T_ZDrvPow_Opt;

typedef enum
{
    KERNEL_SLEEP_MODE,
    BOOT_SLEEP_MODE,
    LOSSCOVERAGE_SLEEP_MODE,
    AIRPLANE_SLEEP_MODE,
    DEEP_SLEEP_MODE,
    MAX_SLEEP_MODE
}T_ZDrvPow_SleepMode;

typedef enum
{
    FPI_CLK_32K = 0,
    FPI_CLK_52M = 1,
    FPI_INVALID_CLK
}T_ZDrvPow_FpiClk;

typedef enum
{
    ARM_PS_WAKE = 0,
    ARM_PS_SLEEP = 1,
    ARM_PS_INVALID_FLAG
}T_ZDrvPow_PsSleepFlag;

 /*sleep end*/

 /*freq begin*/
typedef enum
{
#if defined (_CHIP_ZX297520V2)
    MAIN_CLK=0,
    AON_MPLL_624M,
    AON_DPLL_491M52,
    MATRIX_MPLL_312M,
    AON_MPLL_208M,
    MATRIX_MPLL_104M,
    MATRIX_MPLL_78M,
    MATRIX_MPLL_52M=7,
#else
    MAIN_CLK=0,
    AON_MPLL_624M,
    MATRIX_MPLL_312M,
    MATRIX_MPLL_156M,
#endif    
    CORE_INVALID_FREQ
}T_ZDrvPow_CoreFreq;

typedef enum
{
#if defined (_CHIP_ZX297520V2)
    AXI_26M,
    AXI_39M,
    AXI_52M,
    AXI_78M,
    AXI_104M,
    AXI_122M88,
    AXI_156M,
#else
    AXI_6M5=0,
    AXI_26M,
    AXI_39M,
    AXI_52M,
    AXI_78M,
    AXI_104M,
    AXI_124M8,
    AXI_156M=7,
#endif

    AXI_INVALID_FREQ
}T_ZDrvPow_AxiFreq;
typedef enum
{
    VCORE_0V800,
    VCORE_0V825,
    VCORE_0V850,
    VCORE_0V875,
    VCORE_0V900,
    VCORE_INVALID_VOL
}T_ZDrvPow_Vcore;

typedef enum
{
    CLK26M=26000000,
    CLK624M=624000000,
#if defined (_CHIP_ZX297520V2)
#else
	CLK156M=156000000,
#endif
    CLK312M=312000000,
    CLK208M=208000000,
    CLK78M=78000000,

    CLK_INVALID_FREQ
}T_ZDrvPow_PsFreqConst;

#define DOWN_CPUFREQ   CLK156M
#define UP_CPUFREQ     CLK312M
#define PULL_CPUFREQ   CLK624M
#if PSM_DDR_DFS_HW 
 typedef enum
 {
	 DDR_156M  = 0, //Ҫ¿ƵʵƵΪӺ
	 DDR_208M = 0x4f,
	 DDR_312M = 0x9d,
	 DDR_400M = 0xc8,    
	 DDR_CLKEND
 }T_zDrvPow_DDRCLK;
#else
typedef enum
{
#if defined (_CHIP_ZX297520V2)
	DDR_13M = 0,
	DDR_52M = 1,
	DDR_100M = 2,    
	DDR_104M = 3,
	DDR_156M = 4,
	DDR_208M = 5,
	DDR_312M = 6,
	DDR_400M = 7,    
	DDR_416M = 8,
    
#else
    DDR_156M ,
    DDR_208M ,
    DDR_312M ,
	DDR_400M ,    
#endif
    DDR_CLKEND
}T_zDrvPow_DDRCLK;
#endif

 /*freq end*/

/*gate begin*/
typedef enum
{
    /*ps power domain*/
    GSM_RAM_PWR = 0,
    GSM_DSP_PWR = 1,
    EDCP_PWR = 4,
    /*3/4bits reserved*/
    USB_CTRL_PWR = 8,
    USB_HSIC_PWR = 9,

    PS_ALL_PWR = 10,

    MAX_PWR = 11

}T_ZDrvPow_PwrId;

typedef enum
{
    POW_ENABLE = 0,
    POW_DISABLE = 1,

    POW_ENABLE_ALL
}T_ZDrvPow_PwrEn;
/*gate end*/

#ifdef _USE_WAKELOCK
/*wakelock begin*/
typedef struct _T_ZDrvWakeLock_Entry
{
    struct list_head node;  /* node*/
    char name[32];
    BOOL active:1;
    UINT32 active_count;
    UINT32 relax_count;
}T_ZDrvWakeLock_Entry;

typedef struct _T_zDrvWakeLock_TAB
{
    struct list_head devList;
    ZOSS_SEMAPHORE_ID  opMutex;
    UINT32 devListCount;
}T_zDrvWakeLock_TAB;

typedef void * T_ZDrvWakeLock_Handle;
/*wakelock end*/
#endif

/****************************************************************************
*                                           function
****************************************************************************/
#ifdef _USE_WAKELOCK
/*wakelock begin*/
T_ZDrvWakeLock_Handle zDrvWakeLock_Register(const char *name);
VOID zDrvWakeLock_Lock(T_ZDrvWakeLock_Handle handle);
VOID zDrvWakeLock_Unlock(T_ZDrvWakeLock_Handle handle);
BOOL zDrvWakeLock_DevStatue(VOID);
/*wakelock end*/
#endif

typedef VOID (*psm_uartWakeExtApHook)(VOID);                /*uart wake ext ap hook       */
typedef VOID (*psm_usbWakeExtApHook)(VOID);                 /*usb wake ext ap hook       */

typedef SINT32 (*pm_callback_fn)(void);

extern SINT32 zx_pm_register_callback(pm_callback_fn enter_cb, pm_callback_fn exit_cb);

VOID zDrvPow_SetWakeExtApHookOpt(psm_uartWakeExtApHook uartWakeExtApHook, psm_usbWakeExtApHook usbWakeExtApHook);


/*plat begin*/
SINT32 zDrvPow_GetLteSleepFlag(VOID);/*Эջ7510һ*/
VOID zDrvPow_ClearPhySleepFlag(VOID);
SINT32 zDrvPow_GetPhySleepFlag(T_ZDrvPow_PhyId phyId);
BOOL zDrvPow_PsmGetCampon(VOID);
VOID zDrvPow_SetBootStage(T_ZDrvPow_BootStage stage);
BOOL zDrvPow_PsmIdleFlag(VOID);
VOID zDrvPow_DpramSendCmdWakePhy(T_ZDrvPow_PhyId phyId);
VOID zDrvPow_Icp2ZspDebugInfo(T_ZDrvPow_PhyId phyId,SINT32 dwIcp);
BOOL zDrvPow_UmtsSleep(VOID);
VOID zDrvPow_ChangeRRCFreForGSM(VOID);
UINT32 zDrvPow_Sleep_Func(T_ZDrvPow_SleepMode sleep_mode, UINT32 sleep_time);
SINT32 zDrvPow_SetDevActive(T_ZDrvPow_IdleFlag devId);
SINT32 zDrvPow_SetDevIdle(T_ZDrvPow_IdleFlag devId);
UINT32 zDrvPow_PsmIdleFlagGet(VOID);
UINT32 zDrvPow_PsmDeepSleepCnt(VOID);

/*plat end*/

 /*sleep begin*/
SINT32 zDrvPow_SetOpt(T_ZDrvPow_Opt* pPowOpt);
UINT32 zDrvPow_PsmDeepSleep(UINT32 ps_sleep_time);
UINT32 zDrvPow_ChargerSleep(UINT32 sleep_time);
VOID zDrvPow_KernelSleep(VOID);
UINT32 zDrvPow_BootSleep(UINT32 sleep_time);
VOID zDrvPow_ActiveSleep(UINT32 ms);
SINT32 zDrvPow_SetPcuWakeInt(T_ZDrvPow_PsIntWakeDis intId,T_ZDrvPow_PsWakeIntDis intDis);
SINT32 zDrvPow_PSM_Init(VOID);
VOID zDrvPow_ChargerOnSleepInit(VOID);
VOID zDrvPow_ChargerOnSleepOperation(VOID);
 /*sleep end*/

/*freq begin*/
UINT32 zDrvPow_GetPsCoreFreq(VOID);

SINT32 zDrvPow_SetArmPsCoreFreq(T_ZDrvPow_PsFreqConst workFreq);
SINT32 zDrvPow_SetPsDdrFreq(T_zDrvPow_DDRCLK freq);
/*freq end*/

SINT32 zDrvPow_GetTdSfnFlag(VOID);
VOID zDrvPow_PcuSetWakeSource(UINT32 *wake_source);
VOID zDrvPow_PsmLed(BOOL onOff);
/*power partition control*/
SINT32 zDrvpow_SetPwrGate(T_ZDrvPow_PwrId partId, T_ZDrvPow_PwrEn ena);

#endif/*_DRVS_POW_H*/

