#include "drvs_general.h"
#include "drvs_voiceprocess.h"
#include "hal_audio_data.h"

#define RING_SIZE      2560//640*4
#define MAX_MIX_SIZE   640

Mix_Info mixTxInfo = {0};

SINT32 voice_MixerDataTx(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata);
//SINT32 voice_MixerDataRx(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata);
SINT32 Tx_RingWrite(const VOID *pBuf, UINT32 uiLen);
//SINT32 Rx_RingWrite(const VOID *pBuf, UINT32 uiLen);
SINT32 Tx_RingRead(VOID *pBuf, UINT32 uiLen);
//SINT32 Rx_RingRead(VOID *pBuf, UINT32 uiLen);
SINT32 zDrvVp_AudioDataWrite(const VOID *pBuf, UINT32 uiLen);
SINT32 zDrvVp_AudioDataOpen(UINT32 audioType, UINT32 sampleRate);
SINT32 zDrvVp_AudioDataClose(void);

SINT32 voice_MixerDataTx(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata)
{
	SINT32 ret = DRV_SUCCESS;
	UINT32 size16 = size / sizeof(SINT16);
    UINT8 pBuf[MAX_MIX_SIZE] = {0};
    UINT32 readBytes = 0;
    UINT32 freeBytes = 0;
    mixTxInfo.mixFlag = 1;

    if((mixTxInfo.audioBufferTx == NULL) || (size > MAX_MIX_SIZE))
    {
        mixTxInfo.mixFlag = 0;
        return DRV_ERROR;
    }

    readBytes = Tx_RingRead(pBuf, size);
    
    if(readBytes < size)
    {
        freeBytes = size - readBytes;
        zOss_Memset(pBuf + readBytes, 0, freeBytes);
        printf("---readBytes < size\n");
    }
	
	ret = voice_MixerData((SINT16 *)pvdata, (SINT16 *)pBuf, size16, (SINT16 *)pmixdata);
	if (ret != DRV_SUCCESS)
	{
        mixTxInfo.mixFlag = 0;
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_MixerData failed");
		return ret;
	}

    mixTxInfo.mixFlag = 0;
    
	return ret;
}
#if 0
SINT32 voice_MixerDataRx(UINT8 *pvdata, UINT32 size, UINT8 *pmixdata)
{
	SINT32 ret = DRV_SUCCESS;
	UINT32 size16 = size / sizeof(SINT16);
    UINT8 pBuf[640];
    UINT32 readBytes = 0;
    UINT32 freeBytes = 0;

    if(size > 640)
        return DRV_ERROR;

    readBytes = Rx_RingRead(pBuf, size);
    if(readBytes < size)
    {
        freeBytes = size - readBytes;
        zOss_Memset(pBuf + readBytes, 0, freeBytes);
    }
	
	ret = voice_MixerData((SINT16 *)pvdata, (SINT16)pBuf, size16, (SINT16 *)pmixdata);
	if (ret != DRV_SUCCESS)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "voice_MixerData failed\n");
		return ret;
	}

	//zOss_Memcpy(pmixdata + msize, pvdata + msize, size16 - msize);

	return ret;
}
#endif
SINT32 Tx_RingWrite(const VOID *pBuf, UINT32 uiLen)//д봫Ƶ
{
    SINT32 ret = DRV_SUCCESS;
    UINT32 writeBytes = 0;

    while(hal_RingFreeBytes(mixTxInfo.audioBufferTx) < uiLen)
    {
        zDrvVp_Status(&mixTxInfo.voice_fs, &mixTxInfo.voice_status);
        if(mixTxInfo.voice_status == VP_I2S_IDLE)
            return DRV_ERR_NOT_OPENED;
        zOss_Sleep(20);
    }
    
    writeBytes = hal_RingWrite(mixTxInfo.audioBufferTx, (UINT8 *)pBuf, uiLen);
    
    return ret;
}
#if 0
SINT32 Rx_RingWrite(const VOID *pBuf, UINT32 uiLen)//д봫Ƶ
{
    SINT32 ret = DRV_SUCCESS;
    UINT32 writeBytes = 0;

    if(hal_RingFreeBytes(audioBufferRx) < uiLen)
        return DRV_ERROR;
    
    writeBytes = hal_RingWrite(audioBufferRx, (UINT8 *)pBuf, uiLen);
    
    return ret;
}
#endif
SINT32 Tx_RingRead(VOID *pBuf, UINT32 uiLen)
{
    SINT32 ret = DRV_SUCCESS;
    UINT32 readBytes = 0;

    while(hal_RingIsEmpty(mixTxInfo.audioBufferTx))
    {
        zDrvVp_Status(&mixTxInfo.voice_fs, &mixTxInfo.voice_status);
        if(mixTxInfo.voice_status == VP_I2S_IDLE)
            return DRV_ERR_NOT_OPENED;
        zOss_Sleep(20);
    }
    
    readBytes = hal_RingRead(mixTxInfo.audioBufferTx, pBuf, uiLen);
    
    return readBytes;
}
#if 0
SINT32 Rx_RingRead(VOID *pBuf, UINT32 uiLen)
{
    SINT32 ret = DRV_SUCCESS;
    UINT32 readBytes = 0;

    while(hal_RingIsEmpty(audioBufferRx))
        zOss_Sleep(20);
    
    readBytes = hal_RingRead(audioBufferRx, pBuf, uiLen);
    
    return readBytes;
}
#endif
SINT32 zDrvVp_AudioDataWrite(const VOID *pBuf, UINT32 uiLen)
{
#if 0
    if(audioType == AUDIO_MIX_RX)
        Rx_RingWrite(pBuf, uiLen);
    else if(audioType == AUDIO_MIX_TX)
        Tx_RingWrite(pBuf, uiLen);
    else 
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_AudioDataWrite err! audioType is invalid\n");
        return DRV_ERROR;
    }
#endif
    int ret = DRV_SUCCESS;
    ret = Tx_RingWrite(pBuf, uiLen);

    return ret;
}

SINT32 zDrvVp_AudioDataOpen(UINT32 audioType, UINT32 sampleRate)
{
    zDrvVp_Status(&mixTxInfo.voice_fs, &mixTxInfo.voice_status);
    printf("zDrvVp_AudioDataOpen voice_fs=%d, voice_status=%d\n", mixTxInfo.voice_fs, mixTxInfo.voice_status);

    if(mixTxInfo.voice_status == VP_I2S_IDLE)
    {
        printf("zDrvVp_AudioDataOpen err! voice_status is VP_I2S_IDLE\n");
        return DRV_ERR_NOT_OPENED;
    }
    
    if(sampleRate != mixTxInfo.voice_fs)
    {
        printf("zDrvVp_AudioDataOpen err! samplerate is invalid\n");
		return DRV_ERR_INVALID_PARAM;
    }
#if 0
    if(audioType == AUDIO_MIX_RX)
    {
        audioBufferRx = hal_RingCreate(RING_SIZE);
    
        if(audioBufferRx == NULL)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "+++zDrvVp_AudioDataOpen err! audioBufferRX is NULL\n");
    		return DRV_ERROR;
        }
    }
#endif
    if(audioType == AUDIO_MIX_TX)
    {
        mixTxInfo.audioBufferTx = hal_RingCreate(RING_SIZE);
    
        if(mixTxInfo.audioBufferTx == NULL)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_AudioDataOpen err! audioBufferTX is NULL\n");
    		return DRV_ERR_MEM_ALLOC;
        }
    }
    else 
    {
        zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvVp_AudioDataOpen err! audioType is invalid\n");
        return DRV_ERR_INVALID_PARAM;
    }

    printf("zDrvVp_AudioDataOpen sucess\n");

    return DRV_SUCCESS;
}

SINT32 zDrvVp_AudioDataClose(void)
{
    //hal_RingDelete(audioBufferRx);//rxûʱԣչʱûǷֿ
    //audioBufferRx = NULL;
    if(mixTxInfo.audioBufferTx != NULL)
    {
        while(mixTxInfo.audioBufferTx->readPos != mixTxInfo.audioBufferTx->writePos)
        {
            zDrvVp_Status(&mixTxInfo.voice_fs, &mixTxInfo.voice_status);
            if(mixTxInfo.voice_status == VP_I2S_IDLE)
                break;
            zOss_Sleep(20);
        }
        while(mixTxInfo.mixFlag == 1)
        {
            zDrvVp_Status(&mixTxInfo.voice_fs, &mixTxInfo.voice_status);
            if(mixTxInfo.voice_status == VP_I2S_IDLE)
                break;
            zOss_Sleep(5);
        }
        
        hal_RingDelete(mixTxInfo.audioBufferTx);
        mixTxInfo.audioBufferTx = NULL;
    }
    printf("zDrvVp_AudioDataClose sucess\n");
    
    return DRV_SUCCESS;
}

