/*****************************************************************************
 *汾 (C)2008ͨѶɷ޹˾
 *  ģ	    ź
 *  ļ	   os_sema.c
 *  ʵֹ     ź
 *  		    
 *  汾		    v1.0
 *  	    2010.10.10
 *  ˵	    
 *****************************************************************************/

/**************************************************************************
                          ͷļ 
 **************************************************************************/

#include    "os_type.h"
#include    "os_pub.h"
#include    "os_mem.h"
#include    "os_mutex.h"
#include    "os_sema.h"
//#include	<semaphore.h>
#include	<stdio.h>

/**************************************************************************
 *                          غ                                                                           *
 **************************************************************************/
#define sema_context(sid)   ((OSA_SEMA_CONTEXT *)sid)
#define sema_info(sid)      (sema_context(sid)->info)
#define sema_lock(sid)      tp_os_mutex_get( sema_context(sid)->mutex, OS_WAIT_FOREVER )
#define sema_unlock(sid)    tp_os_mutex_put( sema_context(sid)->mutex )


/**************************************************************************
 *                                                                                                     *
 **************************************************************************/
typedef struct
{
    OS_MUTEX_ID         mutex;
    sem_t				sem_t;
    OS_SEMA_INFO        info;
} OSA_SEMA_CONTEXT;


/****************************************************************************
 *                          غԭ
 ****************************************************************************/
static SINT32 sema_context_add( OSA_SEMA_CONTEXT **p_context ,int value);
static VOID   sema_context_remove( OSA_SEMA_CONTEXT *p_context );

/****************************************************************************
 *                          ȫֺ
 ****************************************************************************/
/**************************************************************************
* ƣ tp_os_sema_create
* һź
* ˵ nameļź
				init_countļźĳʼֵ
*   ֵ	  ɹ򷵻źıʶţ򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_SEMA_ID tp_os_sema_create( CHAR *name, UINT32 init_count )
{
    OSA_SEMA_CONTEXT    *p_context = NULL;

    TP_OS_ASSERTEx( NULL != name, OS_SEMA_INVALID_ID );

    if ( OS_SUCCESS != sema_context_add( &p_context ,(int)init_count) )
    {
        return OS_SEMA_INVALID_ID;
    }
    strncpy( p_context->info.name, name, OS_MAX_NAME_LEN-1 );
    p_context->info.available_count = init_count;

    return p_context->info.id;
}

/**************************************************************************
* ƣ tp_os_sema_delete
* ɾһָļźеȴüź߳ȴ״̬
* ˵sidźıʶ
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_sema_delete( OS_SEMA_ID sid )
{
    OSA_SEMA_CONTEXT  *p_context = NULL;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != sid, OS_FAILURE );

    sema_context_remove( sema_context(sid) );

    return OS_SUCCESS;

}
/**************************************************************************
* ƣ tp_os_sema_get
* õһź
* ˵sidźıʶ
                               timeoutָʾźĵȴʱ䣬λΪ
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_sema_get( OS_SEMA_ID sid, UINT32 timeout )
{
    //printf("tp_os_sema_get begin!\n");
    OSA_SEMA_CONTEXT    *p_context = NULL;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != sid, OS_FAILURE );
    if (OS_SEMA_INVALID_ID == sid)
    {
        printf("semephore id is invalid!\n");
    }
    p_context = sema_context(sid);
    //printf("tp_os_sema_get semephore id is 0x%x\n",(int)sid);

    while(sem_wait(&(p_context->sem_t))==-1)
    {
        printf("sem_wait(&(p_context->sem_t))==-1\n");
    }
    //printf("tp_os_sema_get semephore id successed is 0x%x\n",(int)sid);
    return OS_SUCCESS;
    
    //return sem_wait(&(p_context->sem_t));
}
/**************************************************************************
* ƣ tp_os_sema_put
* ͷһź
* ˵sidźıʶ
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_sema_put( OS_SEMA_ID sid )
{
    OSA_SEMA_CONTEXT    *p_context = NULL;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != sid, OS_FAILURE );
    p_context = sema_context(sid);

    return sem_post(&p_context->sem_t);
}

/**************************************************************************
* ƣ tp_os_sema_count_get
* ȡָźĵǰֵ
* ˵sidźıʶ
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_sema_count_get( OS_SEMA_ID sid, UINT32 *count_ptr )
{
    OSA_SEMA_CONTEXT    *p_context = NULL;
    OS_SEMA_INFO        info;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != sid, OS_FAILURE );
    TP_OS_ASSERTEx( NULL != count_ptr, OS_FAILURE );
    p_context = sema_context(sid);
    return sem_getvalue(&p_context->sem_t,(int*)count_ptr);
}

/**************************************************************************
* ƣ tp_os_sema_info_get
* ȡָźϢ
* ˵sidźıʶ
                               info_ptrźϢĴ洢ṹ
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
OS_STATUS tp_os_sema_info_get( OS_SEMA_ID sid, OS_SEMA_INFO *info_ptr )
{
    OSA_SEMA_CONTEXT  *p_context = NULL;

    TP_OS_ASSERTEx( OS_SEMA_INVALID_ID != sid, OS_FAILURE );
    TP_OS_ASSERTEx( NULL != info_ptr, OS_FAILURE );
    p_context = (OSA_SEMA_CONTEXT *)sid;

    sema_lock( sid );

    tp_os_mem_cpy( info_ptr, &p_context->info, sizeof(OS_SEMA_INFO) );
    sema_unlock( sid );

    return OS_SUCCESS;
}

/**************************************************************************
* ƣ sema_context_add
* 
* ˵
*   ֵ	  ɹ򷵻OS_SUCCESS򷵻OS_FAILURE
* ˵ ѡ
**************************************************************************/
static SINT32 sema_context_add( OSA_SEMA_CONTEXT **p_context ,int value)
{
    OSA_SEMA_CONTEXT    *p_sema_context = NULL;

    p_sema_context = (OSA_SEMA_CONTEXT *)tp_os_mem_malloc( sizeof(OSA_SEMA_CONTEXT) );
    if ( NULL == p_sema_context )
    {
        return OS_FAILURE;
    }
    tp_os_mem_set( p_sema_context, 0, sizeof(OSA_SEMA_CONTEXT) );
    sem_init(&p_sema_context->sem_t,0,value);
    p_sema_context->info.id = (OS_MUTEX_ID)p_sema_context;
    //printf("create semephore id is 0x%x!\n",(int)p_sema_context->info.id);
    *p_context = p_sema_context;
    return OS_SUCCESS;
}

/**************************************************************************
* ƣ sema_context_remove
* 
* ˵
*   ֵ	  
* ˵ ѡ
**************************************************************************/
static VOID sema_context_remove( OSA_SEMA_CONTEXT *p_context )
{
    sem_destroy( &p_context->sem_t);
    tp_os_mem_free( p_context );
    p_context = NULL;
    return ;
}
