/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Contains dispatcher and functions for volume control
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_volume.h
 *   Version: \main\6
 *   Date: 2007-10-01 15:59:20
 *   Responsible: johansek
 *   Comment:
 *     Added Steon2 changes under project define.
 */
#if !defined (_AUD_VOLUME_H_)
#define _AUD_VOLUME_H_

/*******************************************************************************
*
*                              Type definitions
*
*******************************************************************************/
typedef struct {
    aud_volume_enum           volume_level; /* must always contain the volume set by application - not affected by muting */
    aud_mute_enum             resource_muted_UL;
    aud_mute_enum             resource_muted_DL;
} aud_resource_volume_type; /* contains resource volume and mute state */

typedef enum
{
    afe_earpc_gainMinus54db,
    afe_earpc_gainMinus48db,
    afe_earpc_gainMinus42db,
    afe_earpc_gainMinus36db,
    afe_earpc_gainMinus30db,
    afe_earpc_gainMinus24db,
    afe_earpc_gainMinus18db,
    afe_earpc_gainMinus12db,
    afe_earpc_gainMinus6db,
    afe_earpc_gain0db,
    afe_earpc_gain_end
} aud_afe_earpc_gain_enum;
   
/*******************************************************************************
*
*                Public functions implemented in aud_volume.c
*
*******************************************************************************/
/* public functions implemented in aud_volume.c */
BOOL aud_volume_dispatcher(aud_event_enum event, void* p_data); /* dispatcher */
void aud_volume_init(void);
void aud_update_resource_gain(aud_resource_enum resource); /* when a resource is activated, update the gain cells */
word aud_calc_side_tone_volume(aud_volume_enum vol_step);
/* getter functions implemented in aud_volume.c */
aud_mute_enum aud_get_master_mute_status(void);
aud_volume_enum aud_get_master_volume(void);
aud_afe_earpc_gain_enum aud_get_master_volume_analog(void);
U16 aud_get_master_volume_digital(void);
aud_mute_enum aud_get_resource_mute_status_uplink(aud_resource_enum resource);
aud_mute_enum aud_get_resource_mute_status_downlink(aud_resource_enum resource);
aud_volume_enum aud_get_resource_volume(aud_resource_enum resource);

#if defined (STEON2_PROJECT)
/* gain control exceptions for the Steon2 project */
void aud_steon2_exceptions(void);
#endif /* STEON2_PROJECT */

/*******************************************************************************
*
*              Public functions implemented in aud_volume_tst.c
*
*******************************************************************************/
extern U32 aud_test_volume_generic_func(void *p_function_request, BOOL *p_processed ); /* dispatcher for volume-related opcodes (for testing) */

#endif

