/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:io_request.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _IO_REQUEST_H
#define _IO_REQUEST_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_list.h"
#include "ring_queue.h"
#include "request_queue.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/
/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum _T_DONE_STATE {
    REQUEST_SUCCESS = 0,
    REQUEST_NODEV,
    REQUEST_ERROR,
}T_DONE_STATE;

typedef enum _T_IO_HND_STATE
{
    IO_REQUEST_UNCREATED = 0,
    IO_REQUEST_CREATED,
    IO_REQUEST_FORCE_EXIT,
}
T_IO_HND_STATE;

typedef enum _T_IO_REQUEST_STATE
{
    IO_REQUEST_STOP = 0,
    IO_REQUEST_START,
    IO_REQUEST_START_TO_SUSPEND,
    IO_REQUEST_STOP_TO_SUSPEND,
}
T_IO_REQUEST_STATE;


typedef enum _T_IO_REQUEST_DIRECTION
{
    IO_REQUEST_READ = 0,
    IO_REQUEST_WRITE,
    IO_REQUEST_READ_WRITE,
}
T_IO_REQUEST_DIRECTION;


typedef enum _T_IO_REQUEST_BLOCK_TYPE
{
    IO_REQUEST_NO_WAIT = 0,
    IO_REQUEST_WAIT_FOREVER,
}
T_IO_REQUEST_BLOCK_TYPE;

typedef struct _T_IO_RequestOps
{
    SINT32 (*hal_enable)(VOID *reqHndData);
    SINT32 (*hal_disable)(VOID *reqHndData);
    SINT32 (*start_request)(VOID *reqHndData, T_IO_REQUEST_DIRECTION reqDirection);
    VOID  (*free_request) (VOID *reqHndData, T_IO_REQUEST_DIRECTION reqDirection, T_Request *req);
    SINT32 (*request_done)(VOID *reqHndData, T_Request *req, T_DONE_STATE doneState);
}
T_IO_RequestOps;

typedef struct _T_Request_SgList
{
    UINT8 *reqBuffer;
    UINT32 reqCount;
}
T_Request_SgList;


typedef struct _T_IO_RequestHnd T_IO_RequestHnd;

typedef SINT32 (*RequestDoneHnd)(T_IO_RequestHnd *, T_Request_SgList *, T_DONE_STATE);


typedef struct _T_IO_RequestHnd
{
    struct list_head node;	/* node*/
    UINT8 *name;
    T_IO_REQUEST_DIRECTION reqDirection;
    UINT32 reqSize;
    volatile T_IO_HND_STATE hndState;
    UINT32 isSuspend;
    UINT32 halEnabled;
    T_IO_RequestOps *ops;
    VOID *reqHndData;

    /*read*/
    UINT32 readReqCount;
    T_Request_Queue *readQ;
    T_Ring_Queue *readDoneBuffer;
    T_IO_REQUEST_STATE readReqState;
    ZOSS_SEMAPHORE_ID readReqSem;
    RequestDoneHnd readDoneFn;
    T_Request_SgList readSgList;
    UINT32 readSgListMaxCount;
    UINT32 readFreeCnt;

    /*write*/
    UINT32 writeReqCount;
    T_Request_Queue *writeQ;
    T_IO_REQUEST_STATE writeReqState;
    ZOSS_SEMAPHORE_ID writeReqSem;
    RequestDoneHnd writeDoneFn;
    T_Request_SgList writeSgList;
    UINT32 writeSgListMaxCount;
    UINT32 writeFreeCnt;

}
T_IO_RequestHnd;


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/*******************************************************************************
 * Function: IORequest_Create
 * Description:create the IO request handle, configure the params.
 * Input:
 * Output:None
 *
 * Returns:
    DRV_SUCCESS: success.
    DRV_ERROR: error.
 * Others:.
 ********************************************************************************/
T_IO_RequestHnd * IORequest_Create(UINT8* name,
                                   T_IO_REQUEST_DIRECTION reqDirection, UINT32 reqSize,
                                   VOID *reqHndData, T_IO_RequestOps *ops,
                                   UINT32 readReqCount, UINT32 readSgListMaxCount,
                                   UINT32 writeReqCount, UINT32 writeSgListMaxCount);

/*******************************************************************************
 * Function: IORequest_SubmitReadRequest
 * Description:submit the read request.
 * Input:
 *        reqHnd: the handle of request.
 *        req: the submit request.
 * Output:None
 *
 * Returns:
 *         DRV_SUCCESS: success
 ********************************************************************************/
SINT32 IORequest_SubmitReadRequest(T_IO_RequestHnd *reqHnd, T_Request *req);

/*******************************************************************************
 * Function: IORequest_FetchDoneRequest
 * Description:fetch the completed read request.
 * Input:
 *        reqHnd: the handle of request.
 *        blockType: the block type of this operation. no wait or wait forever.
 * Output:None
 *        req: the complete read request.
 * Returns:
 *         DRV_SUCCESS: success
 *         DRV_ERROR_AGAIN: no wait, need fetch again.
 *         DRV_ERROR_ABORT: force exit.
 * Others:
 ********************************************************************************/
SINT32 IORequest_FetchDoneRequest(T_IO_RequestHnd *reqHnd, T_Request *req, T_IO_REQUEST_BLOCK_TYPE blockType);

/*******************************************************************************
 * Function: IORequest_SubmitWriteRequest
 * Description:submit the write request.
 * Input:
 *        reqHnd: the handle of request.
 *        req: the submit request.
 *        blockType: the block type of this operation. no wait or wait forever.
 * Output:None
 *
 * Returns:
 *         DRV_SUCCESS: success
 *         DRV_ERROR_AGAIN: no wait, submit again.
 *         DRV_ERROR_ABORT: force exit.
 * Others:
 ********************************************************************************/
SINT32 IORequest_SubmitWriteRequest(T_IO_RequestHnd *reqHnd, T_Request *req, T_IO_REQUEST_BLOCK_TYPE blockType);

/*******************************************************************************
 * Function: IORequest_WaitRequestDone
 * Description:wait the write request done.
 * Input:
 *        reqHnd: the handle of request.
 * Output:None
 *
 * Returns:
 *         DRV_SUCCESS: success
 *         DRV_ERROR_ABORT: force exit.
 * Others:
 ********************************************************************************/
SINT32 IORequest_WaitRequestDone(T_IO_RequestHnd *reqHnd);

/*******************************************************************************
 * Function: IORequest_GetSgList
 * Description:get the current requests scatter list.
 * Input:
 * Output:None
 *
 * Returns:
	T_Request_SgList* : success.
	NULL: error
 * Others:
 ********************************************************************************/
T_Request_SgList* IORequest_GetSgList(T_IO_RequestHnd *reqHnd, T_IO_REQUEST_DIRECTION reqDirection);

/*******************************************************************************
 * Function: IORequest_Done
 * Description:has complete the request, take next proccess .
 * Input:
 * Output:None
 *
 * Returns:
    DRV_SUCCESS: success.
    DRV_ERROR: error.
 * Others:ע:ô˽ӿڵȼһģڵӿڣɱϡ
 ********************************************************************************/
SINT32 IORequest_Done(T_IO_RequestHnd *reqHnd, T_IO_REQUEST_DIRECTION reqDirection);

/*******************************************************************************
 * Function: IORequest_Suspend
 * Description:suspend the request process, stop the hal operation.
 * Input:
 * Output:None
 *
 * Returns:
    DRV_SUCCESS: success.
    DRV_ERROR: error.
 * Others:
 ********************************************************************************/
SINT32 IORequest_Suspend(T_IO_RequestHnd *reqHnd);

/*******************************************************************************
 * Function: IORequest_Resume
 * Description:resume the request process, and restart the stopped hal operation.
 * Input:
 * Output:None
 *
 * Returns:
    DRV_SUCCESS: success.
    DRV_ERROR: error.
 * Others:
 ********************************************************************************/
VOID IORequest_Resume(T_IO_RequestHnd *reqHnd);

/*******************************************************************************
 * Function: IORequest_ForceExit
 * Description: force the higher process exit.
 * Input:
 * Output:None
 *
 * Returns:
    DRV_SUCCESS: success.
    DRV_ERROR: error.
 * Others:
 ********************************************************************************/
VOID IORequest_ForceExit(T_IO_RequestHnd *reqHnd);
/*******************************************************************************
 * Function: IORequest_CancelExit
 * Description: cancel exit mode, alloc higher process enter iorequest module.
 * Input:
 * Output:None
 *
 * Returns:
 * Others:
 ********************************************************************************/
VOID IORequest_CancelExit(T_IO_RequestHnd *reqHnd);
/*******************************************************************************
 * Function: IORequest_Destroy
 * Description:release the IO Request Handle, and inform the higher layer.
 * Input:
 * Output:None
 *
 * Returns:

 * Others:ע:ͷreqHndռ䣬ú״̬.
 		ϲȷʱȫ󣬲ſͷŸÿռ䡣
 ********************************************************************************/
VOID IORequest_Destroy(T_IO_RequestHnd *reqHnd);

/*******************************************************************************
 * Function: IORequest_Print
 * Description:print the debug info.
 * Input:
 * Output:None
 *
 * Returns:

 * Others:
 ********************************************************************************/
VOID IORequest_Print(T_IO_RequestHnd *reqHnd);

/*******************************************************************************
 * Function: IORequest_PrintAll
 * Description:print the debug info.
 * Input:
 * Output:None
 *
 * Returns:

 * Others:
 ********************************************************************************/
VOID IORequest_PrintAll(VOID);

#endif/*_IO_REQUEST_H*/

