/************************************************************************
* Ȩ(C)2007,ͨѶɷ޹˾
* ģ   PCMƵģ
* ļƣ zte_pcmdriver.c    
* ļʶ 
* ժҪ PCMƵģ麯ʵ
*
* ޸      汾     ޸ı       ޸       ޸      
* ----------------------------------------------------------------------
* 2010/1/13     1.0                       ΰ                        
************************************************************************/

/**************************************************************************
*                        ͷļ                                      *
**************************************************************************/
#include "pub.h"
#include "oss_api.h"
#include "zMsp_Com.h"
#include "zte_pcmdriver.h"

/**************************************************************************
*                                                                    *
**************************************************************************/
/* Ƶ״̬ */
typedef enum
{
    PCM_AUDIO_STATE_IDLE = 0,    /* ״̬        */
    PCM_AUDIO_STATE_OPEN,        /* Ѿ      */
    PCM_AUDIO_STATE_PLAY         /* ״̬      */ 
}PCM_AUDIO_PLAY_STATE;

typedef enum
{
    EV_PCM_START_PLAY = 0,
    EV_PCM_START_PLAY_EX,
    EV_PCM_REPEAT_PLAY,
    EV_PCM_INPUT_DATA,
    EV_PCM_STOP_PLAY,
    EV_PCM_PLAY_END,
    EV_PCM_PLAY_ERR
}PCM_MSG_INFO;

typedef enum
{
    PCM_PLAY_INFO_END,
    PCM_PLAY_INFO_ERR
}PCM_PLAY_INFO;

typedef enum
{
    PCM_RET_ERR,
    PCM_RET_NO_ERR
}PCM_RET_E;

#define PCM_PHYBUF_SIZE    960

#define PCM_OUTPUT_THREAD_PRIORITY    20

#define PCM_OUTPUT_THREAD_STACK_SIZE (1*1024)

#define PCM_OUTPUT_CTRL_SEMP      "pcm_output_ctrl_semp"       /* PCM̳߳ʼź */

#define PCM_AUDIO_OUTPUT_THREAD   "pcm_audio_output_thread"    /* PCMƵ߳     */

#define PCM_DATALIST_MUTEX        " pcm_datalist_mutext "      /* PCM          */

#define PCM_INTERFACE_MUTEX       "pcm_interface_mutex"        /* PCMӿڻ */
/**************************************************************************
*                                                                      *
**************************************************************************/


/**************************************************************************
*                                                                 *
**************************************************************************/
typedef struct _T_PCMDATA_NODE
{
    T_ZOss_Node tNode;
    VOID * data;
    UINT32 uiDataLen;
}T_PCMDATA_NODE;

typedef struct _T_INPUT_DATA_INFO
{
    VOID * pInputData;
    UINT32 uiDataLen;
}T_INPUT_DATA_INFO;

/* PCMƵģϢ */
typedef struct _T_PCM_Audio_ControlParam
{
    UINT32                  uiAudioFd;           /* Ƶ豸ID               */
    
    UINT32                  uiOffset;            /* PCMݿʼλ      */
    UINT32                  uiPlayTimes;         /* Ŵ                 */
    
    VOID *                  pPhyBuf;             /* Buf        */
    UINT32                  uiPhyBufSize;        /* ײbufferС */
    
    UINT32                  uiCurBufSize;        /* ǰŵbufferС */
    UINT32                  uiCurUsedBufSize;    /* ǰŵbufferѲŵĴС */
    VOID *                  pCurBuf;             /* ǰŵbuffer */
    
    T_PCMDATA_NODE          *pFirstNode;         /* һڵ */
    BOOL                    bFirstNodeUsed;      /* һڵ㱣ѭ */
    
    T_ZOss_List             *pDataList;          /* PCMŵ */
    ZOSS_MUTEX_ID           pDataListMutex;      /* Ļ */
    
    ZOSS_MUTEX_ID           pInterfaceMutex;     /* ӿڣԤ̵߳ */
    
    ZOSS_THREAD_ID          pPcmOutputThread;    /* PCM߳ID            */
    ZOSS_SEMAPHORE_ID       pPcmOutputCtrlSemp;  /* PCMź            */
    
    T_ZDrvAudio_Channel     tChannel;            /* Ƶ豸ͨ         */
    T_ZDrvAudio_SampleRate  tSampleRate;         /* Ƶ               */
}T_PCM_Audio_ControlParam;


/**************************************************************************
*                           ֲԭ                                  *
**************************************************************************/
static T_ZDrvAudio_SampleRate PCM_GetSampleRate(DD_PCM_SAMPLERATE eSampleRate);

static T_ZDrvAudio_Channel PCM_GetChannel(DD_PCM_CHANNEL eChannel);

static T_MSP_CHANNEL_OUTPUT PCM_GetChannelOutput(DD_PCM_CHANNEL_OUTPUT eChannelOutput);

static T_MSP_OUTPUT_VOLUME_LEVEL PCM_GetOutputVol(DD_PCM_VOL_LEVEL eVol);

static VOID PCM_DrvNotifyCB(T_ZDrvAudio_Info tStatus);

static VOID PCM_Aduio_OutputThreadEntry(SINT32 iArg);

static SINT32 PCM_ProcStartPlayMsg(VOID);

static SINT32 PCM_ProcStartPlayExMsg(VOID);

static SINT32 PCM_GetPcmBuffer(VOID);

static VOID   PCM_GetPcmBufferData(VOID);

static SINT32 PCM_GetDataListNode(VOID);

static SINT32 PCM_BufferPlay(VOID);

static SINT32 PCM_AddPcmDataNode(VOID *pBuffer, UINT32 uiBufSize);

static SINT32 PCM_InitData(VOID);

static VOID PCM_UnInitData(VOID);

static VOID PCM_ClearInputData(VOID);

static VOID   PCM_NotifyUser(PCM_PLAY_INFO ePlayInfo);

/**************************************************************************
*                           ȫֱ                                      *
**************************************************************************/
static BOOL                     g_bPCMListEnd    = TRUE;
static BOOL                     g_bBufPlayEnd    = TRUE;
static BOOL                     g_bNeedRepeatPlay= FALSE;
static PCM_RET_E                g_eErrorCode     = PCM_RET_NO_ERR;
static T_INPUT_DATA_INFO        g_tInputDataInfo = {0};
static T_PCM_Audio_ControlParam g_tPCMCtrlParam  = {0};
static PCM_AUDIO_PLAY_STATE     g_tPCMPlayState  = PCM_AUDIO_STATE_IDLE;
/**************************************************************************
*                     ȫֺʵ                                      *
**************************************************************************/
/**
* ƣ PCM_Audio_Init
*  PCMƵģʼ
* ˵ 
*   ֵ 豸ɹ0;򷵻-1
* ˵ 
*/
SINT32 PCM_Audio_Init(void)
{
    return 0;
}

/**
* ƣ PCM_Audio_Release
*  ͷPCMƵģ
* ˵ 
*   ֵ ͷ豸ɹ0;򷵻-1
* ˵ 
*/
SINT32 PCM_Audio_Release(void)
{
    return 0;
}

/**
* ƣ PCM_Audio_Open_Buffer
*  PCMbuffer
* ˵ 
*   ֵ ɹ0;򷵻-1
* ˵ 
*/
SINT32 PCM_Audio_Open_Buffer(PCM_PLAY_PARAM tPcmPlayParam, VOID *pPcmBuffer, UINT32 uiBufSize)
{
    SINT32                    iRet           = -1;
    SINT32                    iAudioFd       = -1;
    T_ZDrvAudio_SampleRate    tSampleRate    = 0;
    T_MSP_CHANNEL_OUTPUT      tChannelOutput = 0;
    T_MSP_OUTPUT_VOLUME_LEVEL tVol           = 0;
    
    zOss_Printf(1, 1, "PCMOpenBufferӿ!");
    
    if (PCM_AUDIO_STATE_IDLE != g_tPCMPlayState)
    {
        zMspCom_Print();
        return -1;
    }
    
    if (NULL == pPcmBuffer)
    {
        return -1;
    }
    
    iRet = PCM_InitData();
    if (iRet < 0)
    {
        return -1;
    }
    
    iRet = PCM_AddPcmDataNode(pPcmBuffer, uiBufSize);
    if (iRet < 0)
    {
        zMspCom_Print();
        PCM_UnInitData();
        return -1;
    }
    
    iAudioFd = zMspCom_AudioOpen();
    if (iAudioFd < 0)
    {
        zMspCom_Print();
        PCM_UnInitData();
        return -1;
    }
    
    g_tPCMCtrlParam.uiAudioFd = (UINT32)iAudioFd;
    
    tSampleRate = PCM_GetSampleRate(tPcmPlayParam.eSampleRate);
    g_tPCMCtrlParam.tSampleRate = tSampleRate;
    
    /* ò */
    iRet = zDrv_Ioctl(g_tPCMCtrlParam.uiAudioFd, IOCTL_AUDIO_SET_SAMPLE, (VOID *)&tSampleRate);
    if (iRet < 0)
    { 
        zMspCom_Print();
        PCM_UnInitData();
        zMspCom_AudioClose();
        g_tPCMCtrlParam.uiAudioFd = 0;
        return -1;
    }
    
    /* ֪ͨص */
    iRet = zDrv_Ioctl(g_tPCMCtrlParam.uiAudioFd, IOCTL_AUDIO_SET_CALLBACK, (VOID *)PCM_DrvNotifyCB);
    if (iRet < 0)
    {  
        PCM_UnInitData();
        zMspCom_AudioClose();
        g_tPCMCtrlParam.uiAudioFd = 0;
        return -1;
    }
    
    /* ͨ */
    tChannelOutput = PCM_GetChannelOutput(tPcmPlayParam.eChannelOutput);
    iRet = zMspCom_SetOutputChannel(tChannelOutput);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        PCM_UnInitData();
        zMspCom_AudioClose();
        g_tPCMCtrlParam.uiAudioFd = 0;
        return -1;
    }
    
    /*  */
    tVol = PCM_GetOutputVol(tPcmPlayParam.eVol);
    iRet = zMspCom_SetOutputVol(tVol);
    if (iRet != MSP_COM_OP_SUCCESS)
    {
        PCM_UnInitData();
        zMspCom_AudioClose();
        g_tPCMCtrlParam.uiAudioFd = 0;
        return -1;
    }
    
    g_tPCMCtrlParam.tChannel = PCM_GetChannel(tPcmPlayParam.eChannel);
    
    g_tPCMPlayState = PCM_AUDIO_STATE_OPEN;
    
    zOss_Printf(1, 1, "ɹ˳PCMOpenBufferӿ");
    
    return 0;
}

/**
* ƣ PCM_Audio_Play
*  PCMݿʼ
* ˵ 
*   ֵ ɹ0;򷵻-1
* ˵ ʼɶʹ
*/
SINT32 PCM_Audio_Play(UINT32 uiOffset, UINT32 uiRepeatCount)
{
    SINT32                 iRet        = -1;
    
    zOss_Printf(1, 1, "PCMPlayӿ");
    
    if (PCM_AUDIO_STATE_OPEN != g_tPCMPlayState)
    {
        zMspCom_Print();
        return -1;
    }
    
    g_eErrorCode = PCM_RET_NO_ERR;
    g_bBufPlayEnd = FALSE;
    g_bPCMListEnd = FALSE;
    
    g_tPCMCtrlParam.uiOffset    = uiOffset;
    g_tPCMCtrlParam.uiPlayTimes = uiRepeatCount;
    
    if ((uiRepeatCount > 1) || (0 == uiRepeatCount))
    {
        g_bNeedRepeatPlay = TRUE;
    }
    
    /* PCM߳ */		
    g_tPCMCtrlParam.pPcmOutputThread = zOss_CreateThread(PCM_AUDIO_OUTPUT_THREAD,
                                                         PCM_Aduio_OutputThreadEntry,
                                                         0,
                                                         PCM_OUTPUT_THREAD_STACK_SIZE,
                                                         PCM_OUTPUT_THREAD_PRIORITY,
                                                         0,
                                                         1);
    if (NULL == g_tPCMCtrlParam.pPcmOutputThread)
    {
        return -1;
    }
    
    zOss_GetSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp, ZOSS_WAIT_FOREVER);
    
    if (PCM_RET_NO_ERR != g_eErrorCode)
    {
        return -1;
    }
    
    /* һstartӿ̷߳һʼ */
    /* ߳Լ                            */
    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_START_PLAY);
    if(iRet != MSP_COM_OP_SUCCESS)
    {		
        return -1;
    }
    
    zOss_GetSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp, ZOSS_WAIT_FOREVER);
    
    if (PCM_RET_NO_ERR != g_eErrorCode)
    {
        zMspCom_Print();
        g_eErrorCode = PCM_RET_NO_ERR;
        return -1;
    }
    
    
    g_tPCMPlayState = PCM_AUDIO_STATE_PLAY;
    
    zOss_Printf(1, 1, "ɹ˳PCMPlayӿ");
    return 0;
}



/**
* ƣ PCM_Audio_Data_Input
*  PCM
* ˵ 
*   ֵ ɹ0;򷵻-1
* ˵ ʼɶʹ
*/
SINT32 PCM_Audio_Data_Input(VOID *pDataBuf, UINT32 uiDataLen)
{
    SINT32 iRet = -1;
    
    zOss_Printf(1, 1, "PCMDataInPutӿ");
    
    if (PCM_AUDIO_STATE_PLAY != g_tPCMPlayState)
    {
        zMspCom_Print();
        return -1;
    }
    
    if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
    {
        zOss_GetMutex(g_tPCMCtrlParam.pInterfaceMutex, ZOSS_WAIT_FOREVER);
    }
    
    if (PCM_AUDIO_STATE_PLAY != g_tPCMPlayState)
    {
        zMspCom_Print();
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    if (NULL == pDataBuf)
    {
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    g_tInputDataInfo.pInputData = pDataBuf;
    g_tInputDataInfo.uiDataLen  = uiDataLen;
    
    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_INPUT_DATA);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    zOss_GetSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp, ZOSS_WAIT_FOREVER);
    
    if (PCM_RET_NO_ERR != g_eErrorCode)
    {
        zMspCom_Print();
        g_eErrorCode = PCM_RET_NO_ERR;
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
    {
        zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
    }
    
    zOss_Printf(1, 1, "ɹ˳PCMDataInputӿ");
    
    return 0;
}

/**
* ƣ PCM_Audio_Stop
*  PCMֹͣ
* ˵ (IN)
*   ֵ ɹ0;򷵻-1
* ˵ 
*/
SINT32 PCM_Audio_Stop(VOID)
{
    SINT32 iRet = -1;
    
    zOss_Printf(1, 1, "PCMStopӿ");
    
    if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
    {
        zOss_GetMutex(g_tPCMCtrlParam.pInterfaceMutex, ZOSS_WAIT_FOREVER);
    }
    
    if (PCM_AUDIO_STATE_PLAY != g_tPCMPlayState)
    {
        zMspCom_Print();
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    g_bBufPlayEnd = TRUE;
    
    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_STOP_PLAY);
    if(iRet != MSP_COM_OP_SUCCESS)
    {
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    /* ȴ߳˳ */
    zOss_GetSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp, ZOSS_WAIT_FOREVER);
    
    g_tPCMCtrlParam.pPcmOutputThread = NULL;
    
    g_tPCMPlayState = PCM_AUDIO_STATE_OPEN;
    
    if (PCM_RET_NO_ERR != g_eErrorCode)
    {
        zMspCom_Print();
        g_eErrorCode = PCM_RET_NO_ERR;
        
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        return -1;
    }
    
    if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
    {
        zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
    }
    
    zOss_Printf(1, 1, "ɹ˳PCMStopӿ");
    
    return 0;
}

/**
* ƣ PCM_Audio_Close
*  PCMƵģر
* ˵ (IN)
*   ֵ ɹ0;򷵻-1
* ˵ 
*/
SINT32 PCM_Audio_Close(VOID)
{
    zOss_Printf(1, 1, "PCMCloseӿ");
    
    if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
    {
        zOss_GetMutex(g_tPCMCtrlParam.pInterfaceMutex, ZOSS_WAIT_FOREVER);
    }
    
    if (PCM_AUDIO_STATE_OPEN != g_tPCMPlayState)
    {
        if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
        }
        
        zMspCom_Print();
        return -1;
    }
    
    zMspCom_AudioClose();
    
    PCM_UnInitData();
    
    g_tPCMPlayState = PCM_AUDIO_STATE_IDLE;
    
    if(NULL != g_tPCMCtrlParam.pInterfaceMutex)
    {
        zOss_PutMutex(g_tPCMCtrlParam.pInterfaceMutex);
    }
    
    zOss_Printf(1, 1, "ɹ˳PCMCloseӿ");
    
    return 0;
}


/**************************************************************************
*                      ֲʵ                                      *
**************************************************************************/
static T_ZDrvAudio_SampleRate PCM_GetSampleRate(DD_PCM_SAMPLERATE eSampleRate)
{
    T_ZDrvAudio_SampleRate tSampleRate;
    
    switch (eSampleRate)
    {
    case DD_PCMRATE_8_KHZ:
        {
            tSampleRate = AUDIO_RATE_8_KHZ;
            break;
        }
        
    case DD_PCMRATE_11_KHZ:
        {
            tSampleRate = AUDIO_RATE_11_025_KHZ;
            break;
        }
        
    case DD_PCMRATE_16_KHZ:
        {
            tSampleRate = AUDIO_RATE_16_KHZ;
            break;
        }
        
    case DD_PCMRATE_44_1_KHZ:
        {
            tSampleRate = AUDIO_RATE_44_1_KHZ;
            break;
        }
        
    default:
        {
            tSampleRate = MAX_AUDIO_RATE;
            break;
        }
    }
    
    return tSampleRate;
    
    
}

static UINT32 PCM_GetMaxBufferSize(T_ZDrvAudio_SampleRate eSampleRate)
{
    UINT32 uiBufferSize = 0;
    
    switch (eSampleRate)
    {
    case AUDIO_RATE_8_KHZ:
        {
            uiBufferSize = (8000/50)*2*3;
            break;
        }
        
    case AUDIO_RATE_11_025_KHZ:
        {
            uiBufferSize = (11050/50)*2*3;
            break;
        }
        
    case AUDIO_RATE_16_KHZ:
        {
            uiBufferSize = (16000/50)*2*3;
            break;
        }
        
    case AUDIO_RATE_44_1_KHZ:
        {
            uiBufferSize = (44100/50)*2*3;
            break;
        }
        
    default:
        {
            uiBufferSize = (44100/50)*2*3;
            break;
        }
    }
    
    return uiBufferSize;
        
}

static T_MSP_CHANNEL_OUTPUT PCM_GetChannelOutput(DD_PCM_CHANNEL_OUTPUT eChannelOutput)
{
    T_MSP_CHANNEL_OUTPUT tChannelOutput;
    
    switch(eChannelOutput)
    {
    case DD_PCM_OUTPUT_RECEIVER:
        {
            tChannelOutput = MSP_CHANNEL_OUTPUT_RECEIVER;
            break;
        }
        
    case DD_PCM_OUTPUT_SPEAKER:
        {
            tChannelOutput = MSP_CHANNEL_OUTPUT_SPEAKER;
            break;
        }
        
    case DD_PCM_OUTPUT_HEADPHONE:
        {
            tChannelOutput = MSP_CHANNEL_OUTPUT_HEADPHONE;
            break;
        }
        
    case DD_PCM_OUTPUT_SPEAKER_HEADPHONE:
        {
            tChannelOutput = MSP_CHANNEL_OUTPUT_SPEAKER_HEADPHONE;
            break;
        }
        
    case DD_PCM_OUTPUT_BLUETOOTH:
        {
            tChannelOutput = MSP_CHANNEL_OUTPUT_BLUETOOTH;
            break;
        }
        
    default:
        {
            tChannelOutput = MSP_CHANNEL_OUTPUT_SPEAKER;
            break;
        }
    }
    
    return tChannelOutput;
}

static T_MSP_OUTPUT_VOLUME_LEVEL PCM_GetOutputVol(DD_PCM_VOL_LEVEL eVol)
{
    T_MSP_OUTPUT_VOLUME_LEVEL tVol;
    
    switch(eVol)
    {
    case PCM_VOL_LEV_0:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_0;
            break;
        }
        
    case PCM_VOL_LEV_1:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_1;
            break;
        }
        
    case PCM_VOL_LEV_2:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_2;
            break;
        }
        
    case PCM_VOL_LEV_3:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_3;
            break;
        }
        
    case PCM_VOL_LEV_4:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_4;
            break;
        }
        
    case PCM_VOL_LEV_5:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_5;
            break;
        }
        
    default:
        {
            tVol = MSP_OUTPUT_VOLUME_LEVEL_3;
            break;
        }
    }
    
    return tVol;
}



static T_ZDrvAudio_Channel PCM_GetChannel(DD_PCM_CHANNEL eChannel)
{
    T_ZDrvAudio_Channel tChannel;
    
    switch (eChannel)
    {
    case PCM_MONO_CHANNEL:
        {
            tChannel = AUDIO_MONO_CHANNEL;
            break;
        }
        
    case PCM_DUAL_CHANNEL:
        {
            tChannel = AUDIO_DUAL_CHANNEL;
            break;
        }
        
    default:
        {
            tChannel = AUDIO_MONO_CHANNEL;
            break;
        }
    }
    
    return tChannel;
    
}


static VOID PCM_DrvNotifyCB(T_ZDrvAudio_Info tStatus)
{
    SINT32 iRet = -1;
    
    switch (tStatus)
    {
    case AUDIO_INFO_PLAY_END:
        {
            if (g_bNeedRepeatPlay)
            {	
                g_tPCMCtrlParam.uiPlayTimes--;
                
                if (g_tPCMCtrlParam.uiPlayTimes > 0)
                {				
                    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_REPEAT_PLAY);
                    if(iRet != MSP_COM_OP_SUCCESS)
                    {
                        return;
                    }				
                }
                else
                {
                    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_PLAY_END);
                    if(iRet != MSP_COM_OP_SUCCESS)
                    {
                        return;
                    }	
                }
            }
            else
            {
                iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_PLAY_END);
                if(iRet != MSP_COM_OP_SUCCESS)
                {
                    return;
                }	
                
            }
            
            break;
        }
        
    default:
        {
            iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_PLAY_ERR);
            if(iRet != MSP_COM_OP_SUCCESS)
            {
                return;
            }	
            
            break;
        }
    }
    
    return;
}

static VOID PCM_Aduio_OutputThreadEntry(SINT32 iArg)
{
    BOOL                   bQuit       = FALSE;
    SINT32                 iRet        = -1;
    UINT32                 uiMsgId     = 0;
    T_ZDrvAudio_PlayParam  tPlayParam  = {0};
    
    tPlayParam.channel    = g_tPCMCtrlParam.tChannel;
    tPlayParam.buffersize = PCM_GetMaxBufferSize(g_tPCMCtrlParam.tSampleRate);
    zOss_Printf(1,1,"tPlayParam.buffersize : %d",tPlayParam.buffersize);
    
    /* ʼ */
    iRet = zDrv_Ioctl(g_tPCMCtrlParam.uiAudioFd, IOCTL_AUDIO_PLAY_START, (VOID *)&tPlayParam);
    if (iRet < 0)
    {  
        zMspCom_Print();
        g_eErrorCode = PCM_RET_ERR;
        zOss_PutSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
        
        return;
    } 
    
    zOss_PutSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
    
    
    /* Ϣѭ */
    while ((!bQuit) && (MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsgId, ZOSS_WAIT_FOREVER)))
    {        
        switch(uiMsgId)
        {
        case EV_PCM_START_PLAY:
            {
                iRet = PCM_ProcStartPlayMsg();
                if (iRet < 0)
                {
                    zMspCom_Print();
                    /* һβųʱٷϢ֪ͨûֵͨ˵ */
                    /* ûȶϢͷֵδ */
                    g_eErrorCode = PCM_RET_ERR;				
                }
                else
                {
                    if (!g_bBufPlayEnd)
                    {
                        iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_START_PLAY_EX);
                        if(iRet != MSP_COM_OP_SUCCESS)
                        {
                            g_eErrorCode = PCM_RET_ERR;
                        }
                    }
                    
                }
                
                zOss_PutSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
                
                break;
            }
            
        case EV_PCM_START_PLAY_EX:
            {
                iRet = PCM_ProcStartPlayExMsg();
                if (iRet < 0)
                {
                    zMspCom_Print();
                    PCM_NotifyUser(PCM_PLAY_INFO_ERR);
                    
                    break;
                }
                
                if (!g_bBufPlayEnd)
                {
                    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_START_PLAY_EX);
                    if(iRet != MSP_COM_OP_SUCCESS)
                    {
                        PCM_NotifyUser(PCM_PLAY_INFO_ERR);
                    }
                }
                
                break;
            }
            
        case EV_PCM_REPEAT_PLAY:
            {
                g_bBufPlayEnd = FALSE;
                
                g_tPCMCtrlParam.pCurBuf          = NULL;
                g_tPCMCtrlParam.uiCurBufSize     = 0;
                g_tPCMCtrlParam.uiCurUsedBufSize = 0;
                
                g_tPCMCtrlParam.bFirstNodeUsed = FALSE;
                g_tPCMCtrlParam.pFirstNode     = NULL;
                
                iRet = PCM_ProcStartPlayExMsg();
                if (iRet < 0)
                {
                    zMspCom_Print();
                    PCM_NotifyUser(PCM_PLAY_INFO_ERR);
                    
                    break;
                }
                
                if (!g_bBufPlayEnd)
                {
                    iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_START_PLAY_EX);
                    if(iRet != MSP_COM_OP_SUCCESS)
                    {
                        PCM_NotifyUser(PCM_PLAY_INFO_ERR);
                    }
                }				
                
                
                break;
                
            }
            
        case EV_PCM_INPUT_DATA:
            {
                zOss_Printf(1, 1, "PCMյһݴϢ");
                iRet = PCM_AddPcmDataNode(g_tInputDataInfo.pInputData, g_tInputDataInfo.uiDataLen);
                if (iRet < 0)
                {
                    zMspCom_Print();
                    g_eErrorCode = PCM_RET_ERR;
                }
                
                zOss_PutSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
                
                break;
            }
            
        case EV_PCM_PLAY_END:
            {
                if (g_bBufPlayEnd)
                {
                    g_bPCMListEnd = TRUE;
                    PCM_NotifyUser(PCM_PLAY_INFO_END);
                }
                
                break;
            }
            
        case EV_PCM_PLAY_ERR:
            {
                PCM_NotifyUser(PCM_PLAY_INFO_ERR);
                
                break;
            }
            
        case EV_PCM_STOP_PLAY:
            {
                bQuit = TRUE;
                
                break;
            }
            
        default:
            {
                break;
            }	
        }
    }
    
    iRet = zDrv_Ioctl(g_tPCMCtrlParam.uiAudioFd, IOCTL_AUDIO_PLAY_STOP, NULL);
    if (iRet < 0)
    {
        zMspCom_Print();
        g_eErrorCode = PCM_RET_ERR;
    }
    
    /* дգOpen */
    PCM_ClearInputData();
    
    g_tPCMCtrlParam.pCurBuf          = NULL;
    g_tPCMCtrlParam.uiCurBufSize     = 0;
    g_tPCMCtrlParam.uiCurUsedBufSize = 0;
    
    g_tPCMCtrlParam.pFirstNode       = NULL;
    g_tPCMCtrlParam.bFirstNodeUsed   = FALSE;
    
    g_bBufPlayEnd   = TRUE;	
    g_bPCMListEnd   = TRUE;
    g_bNeedRepeatPlay = FALSE;
    
    g_tPCMPlayState = PCM_AUDIO_STATE_OPEN;
    
    //ȡϢеʣϢTOS߳˳ʱʣϢ
    
    while(MSP_COM_OP_SUCCESS == zMspCom_RecvMsg(&uiMsgId, ZOSS_NO_WAIT))
    {
        zOss_Printf(1, 1, " AAAAAAAA zMspCom_RecvMsg : %d ", uiMsgId);
        uiMsgId = 0;
    }
    
    zOss_Printf(1, 1, " AAAAAAAA PCM_Aduio_OutputThreadEntry quit");
    zOss_PutSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
    
    return;
}


static SINT32 PCM_ProcStartPlayMsg(VOID)
{
    SINT32 iRet = -1;
    
    iRet = PCM_GetPcmBuffer();
    if (iRet < 0)
    {
        zMspCom_Print();
        return -1;
    }
    
    PCM_GetPcmBufferData();
    
    iRet = PCM_BufferPlay();
    if (iRet < 0)
    {
        zMspCom_Print();
        return -1;
    }
    
    return 0;
}

static SINT32 PCM_ProcStartPlayExMsg(VOID)
{
    SINT32 iRet = -1;
    
    iRet = PCM_GetPcmBuffer();
    if (iRet < 0)
    {
        zMspCom_Print();
        return -1;
    }
    
    PCM_GetPcmBufferData();
    
    iRet = PCM_BufferPlay();
    if (iRet < 0)
    {
        zMspCom_Print();
        return -1;
    }
    
    return 0;
}

static SINT32 PCM_GetPcmBuffer(VOID)
{
    SINT32              iRet         = -1;
    T_ZDrvAudio_BufInfo audioBufInfo = {0};
    
    audioBufInfo.buf        = NULL;
    audioBufInfo.buffersize = 0;
    iRet = zDrv_Ioctl(g_tPCMCtrlParam.uiAudioFd, IOCTL_AUDIO_GET_BUFFER, (VOID*)&audioBufInfo);
    if ((iRet < 0) || (NULL == audioBufInfo.buf))
    {
        return -1;
    }
    
    g_tPCMCtrlParam.pPhyBuf      = audioBufInfo.buf;
    g_tPCMCtrlParam.uiPhyBufSize = audioBufInfo.buffersize;
    
    return 0;
}


static VOID   PCM_GetPcmBufferData(VOID)
{
    SINT32 iRet          = -1;
    SINT32 iLeftPcmSize = 0;
    
    if (NULL == g_tPCMCtrlParam.pCurBuf)
    {
        iRet = PCM_GetDataListNode();
        
        if (iRet < 0)
        {
            g_bBufPlayEnd = TRUE;
            
            g_tPCMCtrlParam.pCurBuf          = NULL;
            g_tPCMCtrlParam.uiCurBufSize     = 0;
            g_tPCMCtrlParam.uiCurUsedBufSize = 0;
            
            zOss_Memset(g_tPCMCtrlParam.pPhyBuf, 0, g_tPCMCtrlParam.uiPhyBufSize);
            
            return;	    
        }
        
    }
    
    iLeftPcmSize = g_tPCMCtrlParam.uiCurBufSize - g_tPCMCtrlParam.uiCurUsedBufSize;
    
    if (iLeftPcmSize <= 0)
    {
        zOss_Memset(g_tPCMCtrlParam.pPhyBuf, 0, g_tPCMCtrlParam.uiPhyBufSize);
        
        g_tPCMCtrlParam.pCurBuf          = NULL;
        g_tPCMCtrlParam.uiCurBufSize     = 0;
        g_tPCMCtrlParam.uiCurUsedBufSize = 0;
    }
    else if (iLeftPcmSize > g_tPCMCtrlParam.uiPhyBufSize)
    {
        zOss_Memcpy(g_tPCMCtrlParam.pPhyBuf, (VOID *)((CHAR *)g_tPCMCtrlParam.pCurBuf + g_tPCMCtrlParam.uiCurUsedBufSize), g_tPCMCtrlParam.uiPhyBufSize);
        
        g_tPCMCtrlParam.uiCurUsedBufSize += g_tPCMCtrlParam.uiPhyBufSize;
    }
    else
    {
        zOss_Memcpy(g_tPCMCtrlParam.pPhyBuf, (VOID *)((CHAR *)g_tPCMCtrlParam.pCurBuf + g_tPCMCtrlParam.uiCurUsedBufSize), iLeftPcmSize);
        
        if (g_tPCMCtrlParam.uiPhyBufSize > iLeftPcmSize)
        {
            zOss_Memset((VOID *)((CHAR *)g_tPCMCtrlParam.pPhyBuf + iLeftPcmSize), 0, g_tPCMCtrlParam.uiPhyBufSize - iLeftPcmSize);
        }
        
        g_tPCMCtrlParam.pCurBuf          = NULL;
        g_tPCMCtrlParam.uiCurBufSize     = 0;
        g_tPCMCtrlParam.uiCurUsedBufSize = 0;
    }
    
    return;
    
}


static SINT32   PCM_GetDataListNode(VOID)
{
    T_PCMDATA_NODE *pPcmDataNode = NULL;
    
    zOss_GetMutex(g_tPCMCtrlParam.pDataListMutex, ZOSS_WAIT_FOREVER);
    
    if (NULL == g_tPCMCtrlParam.pDataList)
    {
        zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
        
        return -1;
    }
    
    /* һڵ㴫OpenʱݣҪ棬ֱCloseʱͷ */
    if (!g_tPCMCtrlParam.bFirstNodeUsed)
    {
        pPcmDataNode = (T_PCMDATA_NODE *)zOss_ListFirst(g_tPCMCtrlParam.pDataList);
        if (NULL == pPcmDataNode)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
            
            return -1;
        }
        
        g_tPCMCtrlParam.pFirstNode     = pPcmDataNode;
        g_tPCMCtrlParam.bFirstNodeUsed = TRUE;
        
        zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
        
        g_tPCMCtrlParam.pCurBuf          = pPcmDataNode->data;
        g_tPCMCtrlParam.uiCurBufSize     = pPcmDataNode->uiDataLen;
        g_tPCMCtrlParam.uiCurUsedBufSize = 0;			
    }
    else
    {
        if (NULL != g_tPCMCtrlParam.pFirstNode)
        {
            pPcmDataNode = (T_PCMDATA_NODE *)zOss_ListNext((T_ZOss_Node *)g_tPCMCtrlParam.pFirstNode);
            if (NULL == pPcmDataNode)
            {
                zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
                
                return -1;
            }
            
            g_tPCMCtrlParam.pCurBuf          = pPcmDataNode->data;
            g_tPCMCtrlParam.uiCurBufSize     = pPcmDataNode->uiDataLen;
            g_tPCMCtrlParam.uiCurUsedBufSize = 0;	
            
            zOss_ListDelete(g_tPCMCtrlParam.pDataList, (T_ZOss_Node *)pPcmDataNode);
            
            zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
            
            zOss_Free(pPcmDataNode);
        }
        else
        {
            zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
            
            return -1;
        }
        
    }
    
    return 0;
}


static SINT32 PCM_BufferPlay(VOID)
{
    
    SINT32 iWriteLen       = -1;
    
    iWriteLen = zDrv_Write(g_tPCMCtrlParam.uiAudioFd, g_tPCMCtrlParam.pPhyBuf, g_tPCMCtrlParam.uiPhyBufSize);
    if (iWriteLen < 0)
    {
        return -1;
    }
    
    return 0;
}

static SINT32 PCM_AddPcmDataNode(VOID *pBuffer, UINT32 uiBufSize)
{
    SINT32         iRet = -1;
    T_PCMDATA_NODE *pPcmDataNode = NULL;
    
    if (NULL == pBuffer)
    {
        return -1;
    }
    
    pPcmDataNode = (T_PCMDATA_NODE *)zOss_Malloc(sizeof(T_PCMDATA_NODE));
    if (NULL == pPcmDataNode)
    {
        return -1;
    }
    zOss_Memset(pPcmDataNode, 0, sizeof(T_PCMDATA_NODE));
    
    pPcmDataNode->data = pBuffer;
    pPcmDataNode->uiDataLen = uiBufSize;
    
    zOss_GetMutex(g_tPCMCtrlParam.pDataListMutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(g_tPCMCtrlParam.pDataList, (T_ZOss_Node *)pPcmDataNode);
    zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
    
    if ((g_bPCMListEnd) && (NULL != g_tPCMCtrlParam.pPcmOutputThread))
    {
        g_bPCMListEnd = FALSE;
        g_bBufPlayEnd = FALSE;
        iRet = zMspCom_PostMsg(g_tPCMCtrlParam.pPcmOutputThread, EV_PCM_START_PLAY_EX);
        if(iRet != MSP_COM_OP_SUCCESS)
        {
            return -1;
        }
        
    }
    
    return 0;
}

static SINT32 PCM_InitData(VOID)
{
    ZOSS_MUTEX_ID  pTmpMutesID = NULL;
    
    pTmpMutesID = g_tPCMCtrlParam.pInterfaceMutex;   
    zOss_Memset(&g_tPCMCtrlParam, 0, sizeof(T_PCM_Audio_ControlParam));
    g_tPCMCtrlParam.pInterfaceMutex = pTmpMutesID;
    
    g_tPCMCtrlParam.pPcmOutputCtrlSemp = zOss_CreateSemaphore(PCM_OUTPUT_CTRL_SEMP, 0);
    if (NULL == g_tPCMCtrlParam.pPcmOutputCtrlSemp)
    {
        return -1;
    }
    
    g_tPCMCtrlParam.pDataList = zOss_Malloc(sizeof(T_ZOss_List));
    if (NULL == g_tPCMCtrlParam.pDataList)
    {
        zOss_DeleteSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
        g_tPCMCtrlParam.pPcmOutputCtrlSemp = NULL;
        
        return -1;
    }
    
    zOss_Memset(g_tPCMCtrlParam.pDataList, 0, sizeof(T_ZOss_List));
    
    g_tPCMCtrlParam.pDataListMutex = zOss_CreateMutex(PCM_DATALIST_MUTEX, ZOSS_NO_INHERIT);
    if (NULL == g_tPCMCtrlParam.pDataListMutex)
    {	
        zOss_DeleteSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
        g_tPCMCtrlParam.pPcmOutputCtrlSemp = NULL;
        
        zOss_Free(g_tPCMCtrlParam.pDataList);
        g_tPCMCtrlParam.pDataList = NULL;
        
        return -1;
    }
    
    if(g_tPCMCtrlParam.pInterfaceMutex == NULL)
    {
        g_tPCMCtrlParam.pInterfaceMutex = zOss_CreateMutex(PCM_INTERFACE_MUTEX, ZOSS_NO_INHERIT);
        if(NULL == g_tPCMCtrlParam.pInterfaceMutex)
        {
            zOss_DeleteMutex(g_tPCMCtrlParam.pInterfaceMutex);
            zOss_DeleteSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
            g_tPCMCtrlParam.pPcmOutputCtrlSemp = NULL;
            
            zOss_Free(g_tPCMCtrlParam.pDataList);
            g_tPCMCtrlParam.pDataList = NULL;
            
            return -1;
        }
    }
    
    g_tPCMCtrlParam.bFirstNodeUsed   = FALSE;
    
    g_tPCMCtrlParam.pCurBuf          = NULL;
    g_tPCMCtrlParam.uiCurBufSize     = 0;
    g_tPCMCtrlParam.uiCurUsedBufSize = 0;
    
    
    return 0;
}

static VOID PCM_UnInitData(VOID)
{
    zOss_GetMutex(g_tPCMCtrlParam.pDataListMutex, ZOSS_WAIT_FOREVER);
    
    if (NULL != g_tPCMCtrlParam.pDataList)
    {
        T_PCMDATA_NODE *pPcmDataNode = (T_PCMDATA_NODE *)zOss_ListFirst(g_tPCMCtrlParam.pDataList);
        
        while (NULL != pPcmDataNode)
        {
            zOss_ListDelete(g_tPCMCtrlParam.pDataList, (T_ZOss_Node *)pPcmDataNode);
            
            zOss_Free(pPcmDataNode);
            
            pPcmDataNode = NULL;
            
            pPcmDataNode = (T_PCMDATA_NODE *)zOss_ListFirst(g_tPCMCtrlParam.pDataList);
            
        }
        
        
        zOss_Free(g_tPCMCtrlParam.pDataList);
        
        g_tPCMCtrlParam.pDataList = NULL;
    }
    
    zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
    
    zOss_DeleteMutex(g_tPCMCtrlParam.pDataListMutex);
    
    g_tPCMCtrlParam.pDataListMutex = NULL;
    
    if (NULL != g_tPCMCtrlParam.pPcmOutputCtrlSemp)
    {
        zOss_DeleteSemaphore(g_tPCMCtrlParam.pPcmOutputCtrlSemp);
        g_tPCMCtrlParam.pPcmOutputCtrlSemp = NULL;
    }
    
    zOss_Memset(&g_tPCMCtrlParam, 0, sizeof(T_PCM_Audio_ControlParam));
    
    g_tPCMCtrlParam.bFirstNodeUsed = FALSE;
    
    return;
}

static VOID PCM_ClearInputData(VOID)
{
    zOss_GetMutex(g_tPCMCtrlParam.pDataListMutex, ZOSS_WAIT_FOREVER);
    
    if (NULL != g_tPCMCtrlParam.pDataList)
    {
        T_PCMDATA_NODE *pFirstNode   = NULL;
        T_PCMDATA_NODE *pPcmDataNode = NULL;
        
        pFirstNode = (T_PCMDATA_NODE *)zOss_ListFirst((T_ZOss_List *)g_tPCMCtrlParam.pDataList);
        if (NULL == pFirstNode)
        {
            zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
            
            return;       
        }
        
        pPcmDataNode = (T_PCMDATA_NODE *)zOss_ListNext((T_ZOss_Node *)pFirstNode);
        
        while (NULL != pPcmDataNode)
        {
            zOss_ListDelete(g_tPCMCtrlParam.pDataList, (T_ZOss_Node *)pPcmDataNode);
            
            zOss_Free(pPcmDataNode);
            
            pPcmDataNode = NULL;
            
            pPcmDataNode = (T_PCMDATA_NODE *)zOss_ListNext((T_ZOss_Node *)pFirstNode);
            
        }
        
    }
    
    zOss_PutMutex(g_tPCMCtrlParam.pDataListMutex);
    
    return;
    
}


static VOID   PCM_NotifyUser(PCM_PLAY_INFO ePlayInfo)
{
    switch (ePlayInfo)
    {
    case PCM_PLAY_INFO_END:
        {
            /* ֪ͨϲûŽ */
            zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_END);            
            
            break;
        }
        
    case PCM_PLAY_INFO_ERR:
        {
            zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_ERR);
            
            break;
        }
        
    default:
        {
            zMspCom_NotifyUser(MSP_MODULE_AUDIO, MSP_PLAY_ERR);
            
            break;
        }
    }
    
    return;
}




