/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS 
*    : taskmgt.c
* ļ : 
* ʵֹ : ģ
*      : xiaxinguo
*      : V1.0
*  : 2007-07-16
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : chenxingfang
* ޸ : 2012-09-17
* ޸ : ʽ淶PC-LINT߲ EC:617001782014
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : chenxingfang
* ޸ : 2012-09-27
* ޸ : ߲ EC:617001782003
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "sup_task.h"
#include "osa.h"
#include "sup.h"
#include "ThreadPriority.h"
#include "osa.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
/* ģϢ */
#define EV_TASK_END         (UINT32)(EV_ZOSS_SCHE_BASE + 0) /* ˳Ϣ     */
#define EV_TASK_CRE         (UINT32)(EV_ZOSS_SCHE_BASE + 1) /* 񴴽Ϣ     */

/**************************************************************************
* ݽṹ
**************************************************************************/
static struct
{
    Task_SEND_HOOK          send_to;
    Task_SEND_DATA_HOOK     send_data_to;
    Task_GET_ALL_ID_HOOK    get_all_id;
    Task_GET_ID_HOOK        get_id;
    Task_GET_THAKNAME_HOOK  get_name;
}gSche_Task_Hook; 

typedef struct 
{
    ZOSS_TASK_ID    task_id;
    UINT32          msg_id;
    UINT32          arg;
    T_TIMER_NODE    *pTimerNode;
}T_Task_Arg;

/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID Sche_DefTaskEntry(SINT32 arg);      /* ߳ں     */
static UINT32 Sche_AddTCB(T_ZOss_TCB *ptTcb);   /* TCBƺ    */
static UINT32 Sche_RemoveTCB(T_ZOss_TCB *pDelTcb);
static T_ZOss_TCB *Sche_GetTCB(const ZOSS_TASK_ID taskId);
static VOID TaskTimer_CallBack(T_Task_Arg *task_arg);
static BOOL Timer_IgnoreTaskMsg(ZOSS_TIMER_ID timerId);

/**************************************************************************
* ȫֳ/
**************************************************************************/
ZOSS_SEMAPHORE_ID                      gSche_SaticTaskInitSema = NULL;
__tcm_data UINT32                      gTask_TaskNum           = 0;
__tcm_data static T_ZOss_TCB           *gSche_TCBHeadPtr       = NULL;
__tcm_data static T_ZOss_TCB           *gSche_TCBTailPtr       = NULL;
__tcm_data static UINT32               gSche_MaxTCBLen         = 0;
__tcm_data static ZOSS_MUTEX_ID        gSche_TCBMutex          = NULL;
__tcm_data static ZOSS_MUTEX_ID        gSche_TRFMutex          = NULL;
__tcm_data static ZOSS_MUTEX_ID        gSche_CreMutex          = NULL;
__tcm_data static T_ZOss_List          gSche_TRF_List;
__tcm_data static BOOL                 gSche_IsTaskInit        = FALSE;
__tcm_data static UINT32               gSche_pDataRegion_Test  = 0x5a5a5a5a;
__tcm_data static T_ZOss_TRF           *gSche_ThreadItemTab    = NULL;   
__tcm_data static UINT32               gSche_Max_TaskTab_Num   = 0;
__tcm_data static UINT32               gSche_Max_Thread_Num    = 0;
__tcm_data static UINT32               gSche_Max_MsgQueue_Len  = 0;
__tcm_data static UINT32               gSche_DeadLoop_Time     = 0;
__tcm_data static UINT32               gSche_TaskNum           = 0;
__tcm_data static T_ZOss_TaskTabItem   *gSche_TaskItemTab      = NULL;
extern BOOL         gOsa_SwapTimeFlag;
extern ZOSS_TASK_ID gExcep_DaemonTask;
extern ZOSS_TASK_ID         *gSysm_TaskIDTab;

#ifdef _USE_SDL
__tcm_data tasksdl_desc  *tasksdl_table = NULL; 
extern const UINT32 nof_signalcode;
extern struct signalcode_desc signalcode_table[];
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* ƣSCHE_Init
* ʼģ
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 SCHE_Init(VOID)
{
    T_ZOss_TRF      *pTRF       = NULL;
    T_OSS_PARAM     *pPlatCfg   = NULL;
    ZOSS_THREAD_ID  threadId    = NULL;
    UINT32          i           = 0;
    UINT32          nRet        = ZOSS_ERROR;
    UINT32          priority[8] = {THR1_PRI, THR2_PRI, THR3_PRI, THR4_PRI, THR5_PRI, THR6_PRI, THR7_PRI, THR8_PRI}; 
    UINT32          *stSize     = NULL;
    
    if (gSche_IsTaskInit)            
    {
        return ZOSS_SUCCESS;
    }
    
    /*  */
    pPlatCfg = zOss_GetOssCfg();
    gSche_Max_TaskTab_Num = pPlatCfg->TaskCfg.max_task_num;
    if (gSche_Max_TaskTab_Num < 1)
    {
        return ZOSS_ERROR;
    }
    gSche_Max_Thread_Num = pPlatCfg->TaskCfg.max_schthread_num;
    if (!gSche_Max_Thread_Num || gSche_Max_Thread_Num > sizeof(priority)/sizeof(priority[0]))
    {
        return ZOSS_ERROR;
    }
    gSche_TaskItemTab = pPlatCfg->SysmCfg.pSysm_TaskItemTab;
    gSche_TaskNum = pPlatCfg->SysmCfg.task_num;
    
    gSche_Max_MsgQueue_Len = pPlatCfg->TaskCfg.max_msg_queue_len;
    if (gSche_Max_MsgQueue_Len < 1)
    {
        return ZOSS_ERROR;
    }
    gSche_DeadLoop_Time = pPlatCfg->TaskCfg.deadloop_time;
    
    /* ̬ռ */
    if (gSche_ThreadItemTab == 0)
    {
        gSche_ThreadItemTab = (T_ZOss_TRF *)zOss_Malloc(sizeof(T_ZOss_TRF) * gSche_Max_Thread_Num);
        if (gSche_ThreadItemTab == NULL)
        {
            return ZOSS_ERROR;
        }
        zOss_Memset((UINT8 *)gSche_ThreadItemTab, 0, sizeof(T_ZOss_TRF) * gSche_Max_Thread_Num);
    }
        
    /*  */
    gSche_TCBMutex = zOss_CreateMutex("gSche_TCBMutex", ZOSS_INHERIT);   /* TCB */
    if (NULL == gSche_TCBMutex)
    {
        return ZOSS_ERROR;
    }
    gSche_TRFMutex = zOss_CreateMutex("gSche_TRFMutex", ZOSS_INHERIT);   /* TRF */
    if (NULL == gSche_TRFMutex)
    {
        return ZOSS_ERROR;
    }
    gSche_CreMutex = zOss_CreateMutex("gSche_CreMutex", ZOSS_INHERIT);   /* Create */
    if (NULL == gSche_CreMutex)
    {
        return ZOSS_ERROR;
    }
    
    zOss_ListInit(&gSche_TRF_List);          /* ʼTRF */
    
    stSize = (UINT32 *)zOss_Malloc(gSche_Max_Thread_Num * sizeof(UINT32));
    if (!stSize)
        return ZOSS_ERROR;

    for (i = 0; i < gSche_Max_Thread_Num; i++)
    {
        stSize[i] = 4096;
    }
    
    for (i = 0; i < gSche_TaskNum; i++)
    {
        if ((gSche_TaskItemTab + i)->process_no > 0 && (gSche_TaskItemTab + i)->process_no <= gSche_Max_Thread_Num)
        {
            if ((gSche_TaskItemTab + i)->stack_size > stSize[(gSche_TaskItemTab + i)->process_no - 1])
            {
                stSize[(gSche_TaskItemTab + i)->process_no - 1] = (gSche_TaskItemTab + i)->stack_size;
            }
        }
    }

    for (i = 0; i < gSche_Max_Thread_Num; i++)  /* ߳ */
    {
        pTRF = &gSche_ThreadItemTab[i];
        sprintf((char *)pTRF->thread_name, "thread%lu", i + 1);
        pTRF->priority = priority[i];
        pTRF->pno = 1;
        
        /* ߳ */
        threadId = zOss_CreateThread(pTRF->thread_name, Sche_DefTaskEntry, (SINT32)pTRF, stSize[i], pTRF->priority, 1, 0);
        if (threadId == ZOSS_INVALID_THREAD_ID)
        {
            zOss_Free((VOID *)stSize);
            return ZOSS_ERROR;
        }
        
        zOss_ListInit(&pTRF->TCBReady);      /* ʼ */
        zOss_ListInit(&pTRF->TCBStopped);    /* ʼͣ */
        zOss_ListInit(&pTRF->TCBIdle);       /* ʼ */
        pTRF->thread_id = threadId;
        zOss_ListAdd(&gSche_TRF_List, &(pTRF->node));
        nRet = Sche_SetTaskID(threadId, pTRF);
        if (nRet == ZOSS_ERROR)
        {
            zOss_Free((VOID *)stSize);
            return ZOSS_ERROR;
        }
    }
    
    zOss_Free((VOID *)stSize);
    
    
    /* ߳ */
    for (i = 0; i < gSche_Max_Thread_Num; i++)
    {
        pTRF = &gSche_ThreadItemTab[i];
        nRet = zOss_ResumeThread(pTRF->thread_id);
        if (nRet == ZOSS_ERROR)
        {
            return ZOSS_ERROR;
        }
    }
    
    gSche_MaxTCBLen  = 0;
    gSche_IsTaskInit = TRUE;
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_Task_HookSet
* SDLػص
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_Task_HookSet(UINT8 type, VOID *HookFunc)
{
    switch (type)
    {
    case ZOSS_SETHOOK_SEND:
        {
            gSche_Task_Hook.send_to = (Task_SEND_HOOK)HookFunc;           
            break;
        }
    case ZOSS_SETHOOK_SEND_DATA:
        {
            gSche_Task_Hook.send_data_to = (Task_SEND_DATA_HOOK)HookFunc;
            break;
        }
    case ZOSS_SETHOOK_GET_ALL_ID:
        {
            gSche_Task_Hook.get_all_id = (Task_GET_ALL_ID_HOOK)HookFunc;
            break;
        }
    case ZOSS_SETHOOK_GET_ID:
        {
            gSche_Task_Hook.get_id = (Task_GET_ID_HOOK)HookFunc;
            break;
        }
    case ZOSS_SETHOOK_GET_NAME:
        {
            gSche_Task_Hook.get_name = (Task_GET_THAKNAME_HOOK)HookFunc;
            break;
        }
    default:
        {
            return ZOSS_ERROR;
        }
    }
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_CreateTask
* úڴһ
* ˵(IN)
            thread_name: 
            entry: ִеں
            stack_size: ջСλֽڣ,ĬֵΪ0
            priority: ߳ȼ0-31, pnoΪ0ʱãֵԽȼԽ
            private_data_len: ˽ݵĴС
            pno:̱߳(1-8)
            is_static:Ƿ̬
           (OUT)
*   ֵID,ʧܷZOSS_INVALID_TASK_ID
* ˵
**************************************************************************/
ZOSS_TASK_ID zOss_CreateTask_EX(const CHAR      *task_name,
                                FUNC_TASKENTRY  task_entry, 
                                UINT32          stack_size,
                                UINT32          priority,
                                UINT32          private_data_len,
                                UINT8           pno,
                                UINT8           is_static)
{
    ZOSS_THREAD_ID  threadId        = NULL;
    ZOSS_TASK_ID    testtaskId      = NULL;
    UINT8           *pDataRegion    = NULL;
    T_ZOss_TCB      *pTCB           = NULL;
    T_ZOss_TRF      *pTRF           = NULL;
    UINT32          nRet            = ZOSS_ERROR;
    UINT32          status          = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)               /* Ƿѳʼ */
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    zOss_AssertEx(NULL != task_name && NULL != task_entry, ZOSS_INVALID_TASK_ID);
    zOss_AssertEx(0 < stack_size && pno <= gSche_Max_Thread_Num, ZOSS_INVALID_TASK_ID);

    if (strlen((char *)task_name) > ZOSS_MAX_TASKNAME_LEN)
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    if (ZOSS_SUCCESS != zOss_GetMutex(gSche_CreMutex, ZOSS_WAIT_FOREVER))
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    testtaskId = zOss_GetTaskID(task_name);
    zOss_ASSERT(ZOSS_INVALID_TASK_ID == testtaskId);
    if (ZOSS_INVALID_TASK_ID != testtaskId)
    {
        zOss_PutMutex(gSche_CreMutex);
        return ZOSS_INVALID_TASK_ID;
    }
    
    /* ƿTCB */
    pTCB = (T_ZOss_TCB *)zOss_Malloc(sizeof(T_ZOss_TCB));
    if (NULL == pTCB)
    {
        zOss_PutMutex(gSche_CreMutex);
        return ZOSS_INVALID_TASK_ID;
    }
    zOss_Memset((UINT8 *)pTCB, 0, sizeof(T_ZOss_TCB));
    
    /* û˽ݿռ */
    if (0 == private_data_len)
    {
        pDataRegion = NULL;
    }
    else
    {
        private_data_len = ALIGN_TO(private_data_len, sizeof(UINT32));
        pDataRegion = (UINT8 *)zOss_Malloc(private_data_len + 4);  /* û */
        if (NULL == pDataRegion)
        {
            zOss_PutMutex(gSche_CreMutex);
            zOss_Free(pTCB);
            return ZOSS_INVALID_TASK_ID;
        }
        zOss_Memset(pDataRegion, 0, private_data_len);
        *(UINT32 *)((UINT32)pDataRegion + private_data_len) = gSche_pDataRegion_Test;
    }
    
    /* TCBϢ */
    zOss_ListInit(&pTCB->msg_queue);
    pTCB->taskData = pDataRegion;
    strncpy((char *)pTCB->task_name,(const char *)task_name,ZOSS_MAX_TASKNAME_LEN);
    pTCB->task_name[ZOSS_MAX_TASKNAME_LEN] = '\0';
    pTCB->taskEntry = task_entry;
    pTCB->HookEntry[0] = NULL;
    pTCB->HookEntry[1] = NULL;
    pTCB->HookEntry[2] = NULL;
    pTCB->state = ZOSS_STATUS_INIT;
    pTCB->priority = priority;
    pTCB->stack_size = stack_size;
    pTCB->private_data_len = private_data_len;
    pTCB->task_time = 0;
    pTCB->sender_task_id = NULL;
    pTCB->thread_no = pno;
    pTCB->type = SCHE_OSS_TASK;
    pTCB->reserved[0] = is_static;
    pTCB->malloc_size = 0xFFFFFFFF; /* mallocδʵ */
    
    if (pno == 0)                   /* Ƕռ̣߳Ҫһ߳ */
    {
        /* ̵߳ǼǱ */
        pTRF = (T_ZOss_TRF *)zOss_Malloc(sizeof(T_ZOss_TRF));
        if (NULL == pTRF)
        {
            zOss_PutMutex(gSche_CreMutex);
            if (0 != private_data_len)
            {
                zOss_Free(pDataRegion);
            }
            zOss_Free((UINT8 *)pTCB);
            return ZOSS_INVALID_TASK_ID;
        }
        zOss_Memset((UINT8 *)pTRF, 0, sizeof(T_ZOss_TRF));
        
        /* ߳ */
        threadId = zOss_CreateThread(task_name, Sche_DefTaskEntry, (SINT32)pTRF, stack_size, priority, 1, 0);
        if (threadId == ZOSS_INVALID_THREAD_ID)          /* ʧͷſռ */
        {
            zOss_PutMutex(gSche_CreMutex);
            SCHE_printf("Fail!\n");
            if (0 != private_data_len)
            {
                zOss_Free(pDataRegion);
            }
            zOss_Free((UINT8 *)pTCB);
            zOss_Free((UINT8 *)pTRF);
            return ZOSS_INVALID_TASK_ID;
        }
        
        /* ʼ */
        zOss_ListInit(&pTRF->TCBReady);
        zOss_ListInit(&pTRF->TCBStopped);
        zOss_ListInit(&pTRF->TCBIdle);
        
        /* ̵߳ǼǱд߳Ϣ */
        pTRF->priority = priority;
        pTRF->thread_id = threadId;
        pTRF->pno = 0;
        
        /* ߳ */
        pTCB->thread_id = threadId;
        
        nRet = Sche_SetTaskID(threadId, pTRF);
        if (nRet == ZOSS_ERROR)
        {
            zOss_PutMutex(gSche_CreMutex);
            
            SCHE_printf("Fail!\n");
            if (0 != private_data_len)
            {
                zOss_Free(pDataRegion);
            }
            zOss_Free((UINT8 *)pTCB);
            zOss_Free((UINT8 *)pTRF);
            return ZOSS_INVALID_TASK_ID;
        }
        
        /* ̵߳ǼǱTRF */
        if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TRFMutex, ZOSS_WAIT_FOREVER))
        {
            zOss_ListAdd(&gSche_TRF_List, &(pTRF->node));
            
            /* ߳ */
            nRet = zOss_ResumeThread(threadId);
            if (nRet == ZOSS_ERROR)            /* ʧͷſռ */
            {
                zOss_PutMutex(gSche_CreMutex);
                SCHE_printf("Fail!\n");
                if (0 != private_data_len)
                {
                    zOss_Free(pDataRegion);
                }
                zOss_Free((UINT8 *)pTCB);
                status = zOss_DeleteThread(threadId);
                if (status == ZOSS_SUCCESS)
                {
                    zOss_ListDelete(&gSche_TRF_List, &(pTRF->node));
                    zOss_Free((UINT8 *)pTRF);
                }
                zOss_PutMutex(gSche_TRFMutex);
                return ZOSS_INVALID_TASK_ID;
            }
            zOss_PutMutex(gSche_TRFMutex);
        }
    }
    else                                /* Ƕռʱݵ̺߳ŽӦ߳ */
    {
        pTRF = &gSche_ThreadItemTab[pno - 1];
        pTCB->thread_id = pTRF->thread_id;
    }
    
    /* ƿpTaskInfoҵб */
    nRet = Sche_AddTCB(pTCB);
    if (nRet == ZOSS_ERROR)             /* ʧʾ */
    {
        zOss_PutMutex(gSche_CreMutex);
        SCHE_printf("Fail!\n");
        if (0 != private_data_len)
        {
            zOss_Free(pDataRegion);
        }
        zOss_Free((UINT8 *)pTCB);
        if (pno == 0)                   /* Ƕռ߳Ҫɾ߳ */
        {
            status = zOss_DeleteThread(threadId);
            if (status == ZOSS_SUCCESS )
            {
                if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TRFMutex, ZOSS_WAIT_FOREVER))
                {
                    zOss_ListDelete(&gSche_TRF_List, &(pTRF->node));
                    nRet = zOss_PutMutex(gSche_TRFMutex);
                    if (nRet == ZOSS_ERROR)
                    {
                        return NULL;
                    }
                }
                zOss_Free((UINT8 *)pTRF);
            }
        }
        
        return ZOSS_INVALID_TASK_ID;
    }
    
    pTCB->time = zOss_GetTickCount();
    pTCB->task_id = (ZOSS_TASK_ID)pTCB;
    
    zOss_PutMutex(gSche_CreMutex);
    
    /* ̷߳񴴽Ϣ */
    zOss_TaskSend(EV_TASK_CRE, NULL, 0, (ZOSS_TASK_ID)pTCB);
    return pTCB;
}

ZOSS_TASK_ID zOss_CreateTask(const CHAR      *task_name,
                             FUNC_TASKENTRY  task_entry, 
                             UINT32          stack_size,
                             UINT32          priority,
                             UINT32          private_data_len,
                             UINT8           pno)
{
    ZOSS_TASK_ID    taskID  = NULL;
    UINT32          nRet    = 0;
    
    taskID = zOss_CreateTask_EX(task_name, task_entry, stack_size, priority, private_data_len, pno, 0);
    if (taskID != ZOSS_INVALID_TASK_ID)
    {
        nRet = zOss_TaskSend(EV_INIT, NULL, 0, taskID);
        zOss_AssertEx(nRet != ZOSS_ERROR, ZOSS_INVALID_TASK_ID);
    }
    return taskID;
}

/**************************************************************************
* ƣzOss_DeleteTask
* úɾһ
* ˵(IN)
            task_id:ID,Ϊ0ɾǰ
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ɾᴦ굱ǰϢ
**************************************************************************/
UINT32 zOss_DeleteTask(ZOSS_TASK_ID task_id)
{
    T_ZOss_TCB  *pTCB   = NULL;
    UINT32      status  = ZOSS_ERROR;
    UINT32      nore    = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)               /* Ƿѳʼ            */
    {
        return ZOSS_ERROR;
    }
    
    if (NULL == task_id)                         /* IDΪɾǰ    */
    {
        task_id = zOss_GetSelfTaskID();          /* ȡǰID              */
        if (task_id == ZOSS_INVALID_TASK_ID)
        {
            return ZOSS_ERROR;
        }
    }
    
    pTCB = (T_ZOss_TCB *)task_id;                /* ȡTCB               */
    
    if (pTCB->type != SCHE_OSS_TASK)
    {
        return ZOSS_ERROR;
    }
    
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))   /* ź           */
    {
        if (task_id == pTCB->task_id)                                       /* Ƿ     */
        {
            status = zOss_TaskSend(EV_TASK_END, NULL, 0, task_id);          /* ̷߳ɾϢ */
            pTCB->task_id = NULL;
        }
        else
        {
            zOss_PutMutex(gSche_TCBMutex);
            return ZOSS_ERROR;
        }
        nore = zOss_PutMutex(gSche_TCBMutex);
        if (nore == ZOSS_ERROR)
        {
            return ZOSS_ERROR;
        }
    }
    
    return status;
}

/**************************************************************************
*ƣzOss_PauseTask
*ִͣ
*˵task_id:ͣID
*ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
*˵
**************************************************************************/
UINT32 zOss_PauseTask(ZOSS_TASK_ID task_id)
{
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣzOss_ResumTask
* ָ,ת̬
* ˵(IN)
            task_id:ָID
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_ResumeTask(ZOSS_TASK_ID task_id)
{
    return ZOSS_ERROR;
}

/**************************************************************************
*ƣzOss_GetTaskInfo
*ȡϢ
*˵(IN)
           task_id:ID,Ϊ0ȡǰϢ
           task_info:ƿָ룬ָŸϢĴ洢飬ڵ
                     ǰʼ
           (OUT)
*  ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
*˵
**************************************************************************/
UINT32 zOss_GetTaskInfo(ZOSS_TASK_ID task_id, T_ZOss_TCB *task_info)
{
    T_ZOss_TCB  *pTCB   = NULL;
    UINT32      nore    = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)             /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    zOss_AssertEx(NULL != task_info, ZOSS_ERROR);
    
    if (ZOSS_INVALID_TASK_ID == task_id)       /* IDΪȡǰϢ */
    {
        task_id = zOss_GetSelfTaskID();
        if (task_id == ZOSS_INVALID_TASK_ID)
        {
            return ZOSS_ERROR;
        }
    }
    
    pTCB = (T_ZOss_TCB *)task_id;              /* ȡTCB */
    
    if (pTCB->type != SCHE_OSS_TASK)
    {
        return ZOSS_ERROR;
    }
    
    /* ź */
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        if (task_id == pTCB->task_id)       /*      */
        {
            *task_info = *pTCB;             /* ȡϢ */
            nore = zOss_PutMutex(gSche_TCBMutex);
            if (nore == ZOSS_ERROR)
            {
                return ZOSS_ERROR;
            }
            return ZOSS_SUCCESS;
        }
        zOss_PutMutex(gSche_TCBMutex);
    }
    
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣzOss_GetAllTaskInfo
* ȡǰзSDLϢ
* ˵(IN)
*           (OUT) pMonTaskInfo: Ϣŵַ
*   ֵ
* ˵˺ڴռ䣬ʹͷţڴй¶
**************************************************************************/
VOID zOss_GetAllTaskInfo(T_ZOss_Mon_Task *pMonTaskInfo)
{
#ifdef _USE_MONITOR
    T_ZOss_Mon_Task  taskInfo   = {0};
    T_ZOss_TCB      *TCBNode    = NULL;
    UINT32          cnt         = 0;

    if (pMonTaskInfo == NULL)
    {
        return;
    }
    
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        taskInfo.num = gSche_MaxTCBLen;
        taskInfo.ele = (T_ZOss_Mon_Task_Ele *)zOss_GetUB(taskInfo.num * sizeof(T_ZOss_Mon_Task_Ele));
        zOss_AssertExN(taskInfo.ele != NULL);
        TCBNode = gSche_TCBHeadPtr;
        for (cnt = 0; cnt < taskInfo.num ; cnt++)
        {
            taskInfo.ele[cnt].name          = TCBNode->task_name;
            taskInfo.ele[cnt].handle        = (UINT32)TCBNode->task_id;
            taskInfo.ele[cnt].thread_handle = (UINT32)TCBNode->thread_id;
            taskInfo.ele[cnt].status        = TCBNode->run_status;  
            TCBNode = TCBNode->next;
        }
        zOss_PutMutex(gSche_TCBMutex);

        pMonTaskInfo->num = taskInfo.num;
        pMonTaskInfo->ele = taskInfo.ele;
    }
#endif    
}

/**************************************************************************
* ƣzOss_GetAllTaskID
* ȡIDSDL
* ˵(IN)
            task_id_arr:IDָ룬ڵǰʼ
            (OUT)
*   ֵɹ򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_GetAllTaskID(ZOSS_TASK_ID *task_id_arr)
{
    T_ZOss_TCB  *pCurTCB    = NULL;
    UINT32      tasknum     = 0;
    UINT32      sdltasknum  = 0;
    UINT32      nore        = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    zOss_AssertEx(NULL != task_id_arr, ZOSS_ERROR);
    
    /* ź */
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        /* ȡһID */
        if (NULL != gSche_TCBHeadPtr)   /* Ϊ */
        {
            pCurTCB = gSche_TCBHeadPtr;
            while (NULL != pCurTCB)
            {
                if (pCurTCB == (T_ZOss_TCB *)pCurTCB->task_id)
                {
                    *task_id_arr = pCurTCB->task_id;
                    tasknum++;
                }
                pCurTCB = pCurTCB->next;
                task_id_arr++;
            }
        }
        
        /* ȡSDLID */
        if (gSche_Task_Hook.get_all_id != NULL)
        {
            sdltasknum = gSche_Task_Hook.get_all_id(task_id_arr);
        }
        
        nore = zOss_PutMutex(gSche_TCBMutex);
        if (nore == ZOSS_ERROR)
        {
            return ZOSS_ERROR;
        }
        return (tasknum + sdltasknum);
    }
    return 0;
}

/**************************************************************************
* ƣzOss_TaskSend
* 첽Ϣ
* ˵(IN)
            msg:ϢID
            msg_buf:Ϣջ
            msg_len:Ϣ
            task_id:ĿID
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ӿжʹ
**************************************************************************/
__tcm_func UINT32 zOss_TaskSend(UINT32 msg_id, const VOID *buf, UINT16 msg_len, ZOSS_TASK_ID task_id)
{
    UINT32              nRet    = ZOSS_ERROR;
    T_ZOss_TaskMsgHead  *pMsg   = NULL;
    T_ZOss_TCB          *pTCB   = NULL;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    zOss_AssertEx(NULL != task_id, ZOSS_ERROR);
    
    if (gSche_Task_Hook.send_to != NULL)
    {
        nRet = gSche_Task_Hook.send_to(msg_id, buf, msg_len, task_id, zOss_GetSelfTaskID());
        if (nRet == ZOSS_SUCCESS)
        {
            return ZOSS_SUCCESS;
        }
    }
    
    /* λĿ */
    pTCB = (T_ZOss_TCB *)task_id;           /* ȡĿTCB    */
    if (task_id != pTCB->task_id)           /* 񲻴           */
    {
        return ZOSS_ERROR;
    }
    
    /* Ϣռ */
    pMsg = (T_ZOss_TaskMsgHead *)zOss_GetUB(msg_len + SCHE_M_TASKMSGHEAD_LEN);
    if (NULL == pMsg)
    {
        return ZOSS_ERROR;
    }
    /* дϢͷ */
    pMsg->t_task_id     = task_id;
    pMsg->s_task_id     = zOss_GetSelfTaskID();
    pMsg->send_state    = ZOSS_MSGSENDTYPE_MSG;
    pMsg->msgID         = msg_id;
    pMsg->msgLen        = msg_len;
    if (msg_len > 0 && buf != NULL)
    {
        zOss_Memcpy((UINT8 *)(pMsg + 1), (UINT8 *)buf, msg_len);
    }
    /* Ϣ */
    nRet = zOss_TaskSendDataEx(pMsg);
   
    return nRet;
}

/**************************************************************************
* ƣzOss_TaskSendData
* 첽Ϣ
* ˵(IN)
            msg:ϢID
            msg_buf:Ϣջ
            msg_len:Ϣ
            task_id:ĿID
            (OUT)
*   ֵ ɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ӿжʹ ֻ
            Ϣָ룬Ϣûͷ
**************************************************************************/
CODE_BEGIN(.PLAT_TCM_CODE)
__tcm_func UINT32 zOss_TaskSendData(UINT32 msg_id, VOID *buf, UINT16 msg_len, ZOSS_TASK_ID task_id)
{
    UINT32              nRet    = ZOSS_ERROR;
    T_ZOss_TaskMsgHead  *pMsg   = NULL;
    T_ZOss_TaskMsg      *pBuf   = NULL;
    T_ZOss_TCB          *pTCB   = NULL;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    zOss_AssertEx(NULL != task_id, ZOSS_ERROR);
    
    if (gSche_Task_Hook.send_to != NULL)
    {
        nRet = gSche_Task_Hook.send_to(msg_id, buf, msg_len, task_id, zOss_GetSelfTaskID());
        if (nRet == ZOSS_SUCCESS)
        {
            if (buf != NULL)
            {
                if (ZOSS_SUCCESS != zOss_RetUB(buf))
                {
                    return ZOSS_ERROR;
                }
            }
            return ZOSS_SUCCESS;
        }
    }
    
    /* λĿ */
    pTCB = (T_ZOss_TCB *)task_id;           /* ȡĿTCB    */
    if (task_id != pTCB->task_id)           /* 񲻴           */
    {
        return ZOSS_ERROR;
    }
    
    /* Ϣռ */
    pMsg = (T_ZOss_TaskMsgHead *)zOss_GetUB(SCHE_M_TASKMSGEX_LEN + SCHE_M_TASKMSGHEAD_LEN);
    if (NULL == pMsg)
    {
        return ZOSS_ERROR;
    }
    pBuf = (T_ZOss_TaskMsg *)(pMsg + 1);
    
    /* дϢͷ */
    pMsg->t_task_id     = task_id;
    pMsg->s_task_id     = zOss_GetSelfTaskID();
    pMsg->send_state    = ZOSS_MSGSENDTYPE_DATA;
    pMsg->msgID         = msg_id;
    pMsg->msgLen        = SCHE_M_TASKMSGEX_LEN;
    pBuf->msgbuf        = buf;
    pBuf->msgLenEX      = msg_len;
    
    /* Ϣ */
    nRet = zOss_TaskSendDataEx(pMsg);
    
    return nRet;
}
CODE_END

/**************************************************************************
* ƣzOss_TaskSendDataEx
* 񴫵Ϣ
* ˵(IN)
            buf:Ϣջ
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ӿжʹ
**************************************************************************/
__tcm_func UINT32 zOss_TaskSendDataEx(T_ZOss_TaskMsgHead *buf)
{
    UINT32          nRet        = ZOSS_ERROR;
    T_ZOss_TCB      *pTCB       = NULL;
    T_ZOss_TRF      *pTRF       = NULL;
    ZOSS_THREAD_ID  threadId    = NULL;
#if ZOSS_CAPT_MSG
    UINT32          i           = 0;
    T_ZOss_TCB      *pSTCB      = NULL;
    T_ZOss_SDLTCB   *pSSTCB     = NULL;
    UINT8           fleg[3]     = {0};
#endif

    zOss_AssertEx(buf != NULL, ZOSS_ERROR);

    if (gSche_IsTaskInit == FALSE || buf->t_task_id == NULL 
        || buf->send_state > ZOSS_MSGSENDTYPE_TIMER || buf->send_state < ZOSS_MSGSENDTYPE_MSG)
    {
        zOss_RetUB(buf);
        return ZOSS_ERROR;
    }
    
    if (buf->send_state == ZOSS_MSGSENDTYPE_DATA && gSche_Task_Hook.send_data_to != NULL)
    {
        nRet = gSche_Task_Hook.send_data_to(buf->msgID, ((T_ZOss_TaskMsg *)(buf + 1))->msgbuf,
                ((T_ZOss_TaskMsg *)(buf + 1))->msgLenEX, buf->t_task_id, buf->s_task_id);
    }
    else if (buf->send_state == ZOSS_MSGSENDTYPE_MSG && gSche_Task_Hook.send_to != NULL)
    {
        nRet = gSche_Task_Hook.send_to(buf->msgID, buf + 1, buf->msgLen, buf->t_task_id, buf->s_task_id);
    }
    if (nRet == ZOSS_SUCCESS)
    {
        zOss_RetUB(buf);
        return ZOSS_SUCCESS;
    }
    
    /* λĿ */
    pTCB = (T_ZOss_TCB *)buf->t_task_id;        /* ȡĿTCB            */
    if (buf->t_task_id == pTCB->task_id)        /*                      */
    {
        threadId = pTCB->thread_id;             /* ȡĿڵ߳ID   */
    }
    else
    {
        zOss_RetUB(buf);
        return ZOSS_ERROR;
    }
    
#if ZOSS_CAPT_MSG
    /* Ϣ */
    if (buf->s_task_id != NULL)                 /* ԴΪ߳   */
    {
        pSTCB = (T_ZOss_TCB *)buf->s_task_id;
        if (pSTCB->type == SCHE_OSS_TASK)       /*ԴΪSDL */
        {
            for (i = 0; i < 3; i++)
            {
                if (pSTCB->dire[i] == ZOSS_MSGDIRE_OUT || pSTCB->dire[i] == ZOSS_MSGDIRE_INOUT)
                {
                    fleg[i] = 1;
                    nRet = pSTCB->HookEntry[i](buf, ZOSS_MSGDIRE_OUT);
                }
            }
        }
        else if (pSTCB->type == SCHE_SDL_TASK)  /* ԴΪSDL  */
        {
            pSSTCB = (T_ZOss_SDLTCB *)buf->s_task_id;
            for (i = 0; i < 3; i++)
            {
                if (pSSTCB->dire[i] == ZOSS_MSGDIRE_OUT || pSSTCB->dire[i] == ZOSS_MSGDIRE_INOUT)
                {
                    fleg[i] = 1;
                    nRet = pSSTCB->HookEntry[i](buf, ZOSS_MSGDIRE_OUT);
                }
            }
        }
        if (fleg[2] == 1)
        {
            zOss_RetUB((UINT8 *)buf);
            return ZOSS_SUCCESS;
        }
    }
    
    /* Ϣ */
    for (i = 0; i < 3; i++)
    {
        if (fleg[i] == 0 && (pTCB->dire[i] == ZOSS_MSGDIRE_IN || pTCB->dire[i] == ZOSS_MSGDIRE_INOUT))
        {
            fleg[i] = 1;
            nRet = pTCB->HookEntry[i](buf, ZOSS_MSGDIRE_IN);
        }
    }
    if (fleg[2] == 1)
    {
        zOss_RetUB((UINT8 *)buf);
        return ZOSS_SUCCESS;
    }
    
#endif
    /* Ϣ */
    if (buf->msgID == EV_TASK_CRE || buf->msgID == EV_TASK_END || buf->msgID == EV_INIT || buf->msgID == EV_POWERON)
    {
        nRet = zOss_SendMsg(threadId, (UINT8 *)buf, buf->msgLen + SCHE_M_TASKMSGHEAD_LEN, ZOSS_WAIT_FOREVER);
        if (nRet == ZOSS_ERROR)
        {
            zOss_RetUB((UINT8 *)buf);
        }
        return nRet;
    }
    
    /* ߳Ϣ */
    if (buf->s_task_id == NULL)
    {
        nRet = zOss_SendMsg(threadId, (UINT8 *)buf, buf->msgLen + SCHE_M_TASKMSGHEAD_LEN, ZOSS_WAIT_FOREVER);
        if (nRet == ZOSS_ERROR)
        {
            zOss_RetUB((UINT8 *)buf);
        }
        return nRet;
    }
    
    /* ͨϢ */
    if (threadId == zOss_GetCurThreadID())
    {
        /* ͬһ߳ */
        zOss_ListAdd(&pTCB->msg_queue, &(buf->node));
        if (pTCB->run_status == ZOSS_STATE_IDLE)
        {
            pTRF = &gSche_ThreadItemTab[pTCB->thread_no - 1];
            zOss_ListDelete(&(pTRF->TCBIdle), &(pTCB->node));
            zOss_ListAdd(&(pTRF->TCBReady), &(pTCB->node));
            pTCB->run_status = ZOSS_STATE_READY;
        }
        return ZOSS_SUCCESS;
    }
    else
    {
        /* ͬһ߳ */
        nRet = zOss_SendMsg(threadId, (UINT8 *)buf, buf->msgLen + SCHE_M_TASKMSGHEAD_LEN, ZOSS_WAIT_FOREVER);
        if (nRet == ZOSS_ERROR)
        {
            zOss_RetUB((UINT8 *)buf);
        }
        return nRet;
    }
}

/**************************************************************************
* ƣSche_TaskSend
* 첽Ϣ,ר
* ˵(IN)
            msg_id:ϢID
            buf:Ϣ
            msg_len:Ϣ
            s_task_id:ԴID
            t_task_id:ĿID
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ӿжʹ 
**************************************************************************/
__tcm_func UINT32 Sche_TaskSend(UINT32 msg_id, VOID *buf, UINT16 msg_len, ZOSS_TASK_ID s_task_id, ZOSS_TASK_ID t_task_id)
{
    UINT32              nRet = ZOSS_ERROR;
    T_ZOss_TaskMsgHead *pMsg = NULL;

    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    /* Ϣռ */
    pMsg = (T_ZOss_TaskMsgHead *)zOss_GetUB(msg_len + SCHE_M_TASKMSGHEAD_LEN);
    zOss_AssertEx(NULL != pMsg, ZOSS_ERROR);
    
    /* дϢͷ */
    pMsg->send_state    = ZOSS_MSGSENDTYPE_MSG;
    pMsg->msgID         = msg_id;
    pMsg->msgLen        = msg_len;
    pMsg->s_task_id     = s_task_id;
    pMsg->t_task_id     = t_task_id;
    
    if (msg_len > 0 && buf != NULL)
    {
        zOss_Memcpy((UINT8 *)(pMsg + 1), (UINT8 *)buf, msg_len);
    }
    
    /* Ϣ */
    nRet = zOss_TaskSendDataEx(pMsg);
    return nRet;
}

/**************************************************************************
* ƣSche_TaskSendData
* 첽Ϣ,ר
* ˵(IN)
            msg_id:ϢID
            buf:Ϣ
            msg_len:Ϣ
            s_task_id:ԴID
            t_task_id:ĿID
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ӿжʹ 
**************************************************************************/
__tcm_func UINT32 Sche_TaskSendData(UINT32 msg_id, VOID *buf, UINT16 msg_len, ZOSS_TASK_ID s_task_id, ZOSS_TASK_ID t_task_id)
{
    UINT32              nRet    = ZOSS_ERROR;
    T_ZOss_TaskMsgHead  *pMsg   = NULL;
    T_ZOss_TaskMsg      *pBuf   = NULL;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    /* Ϣռ */
    pMsg = (T_ZOss_TaskMsgHead *)zOss_GetUB(SCHE_M_TASKMSGEX_LEN + SCHE_M_TASKMSGHEAD_LEN);

    zOss_AssertEx(NULL != pMsg, ZOSS_ERROR);

    pBuf = (T_ZOss_TaskMsg *)(pMsg + 1);
    
    /* дϢͷ */
    pMsg->send_state    = ZOSS_MSGSENDTYPE_DATA;
    pMsg->msgID         = msg_id;
    pMsg->msgLen        = SCHE_M_TASKMSGEX_LEN;
    pMsg->s_task_id     = s_task_id;
    pMsg->t_task_id     = t_task_id;
    
    pBuf->msgbuf = buf;
    pBuf->msgLenEX = msg_len;
    
    /* Ϣ */
    nRet = zOss_TaskSendDataEx(pMsg);
    return nRet;
}

/**************************************************************************
* ƣSche_InterruptTaskSend
* жи첽Ϣ
* ˵(IN)
            msg:ϢID
            msg_buf:Ϣջ,ڷʱ,ĿڴϢͷ
            msg_len:Ϣ
            task_id:ĿID
            (OUT)
*   ֵɹZOSS_SUCCESS򷵻ZOSS_ERROR
* ˵ӿжʹ
**************************************************************************/
UINT32 Sche_InterruptTaskSend(UINT32 msg_id, T_ZOss_TaskMsgHead *pMsg, UINT16 msg_len, ZOSS_TASK_ID task_id)
{
    UINT32          nRet        = ZOSS_ERROR;
    T_ZOss_TCB      *pTCB       = NULL;
    ZOSS_THREAD_ID  threadId    = NULL;
    
    zOss_AssertEx(NULL != task_id && NULL != pMsg, ZOSS_ERROR);
    
    /* λĿ */
    pTCB = (T_ZOss_TCB *)task_id;            /* ȡĿTCB */
    if (task_id == pTCB->task_id)
    {
        threadId = pTCB->thread_id;          /* ȡĿڵ߳ID */
    }
    else
    {
        return ZOSS_ERROR;
    }
    
    /* ϢͷϢ */
    pMsg->t_task_id     = task_id;
    pMsg->s_task_id     = (ZOSS_TASK_ID)zOss_GetCurThreadID();
    pMsg->send_state    = ZOSS_MSGSENDTYPE_INTER;
    pMsg->msgID         = msg_id;
    pMsg->msgLen        = msg_len;
    
    /* Ϣ */
    nRet = zOss_SendMsg(threadId, (UINT8 *)pMsg, msg_len, ZOSS_NO_WAIT);
    return nRet;
}

/**************************************************************************
* ƣSche_getBufPoint
* ͷָȡbufָ
* ˵(IN)
            phead:ͷָ
            (OUT)
*   ֵ VOID ͵ָ룬ָϢݣʧܣ򷵻 ZOSS_NULL
* ˵ҪϢͨѶ
**************************************************************************/
VOID *Sche_getBufPoint(T_ZOss_TaskMsgHead *phead)
{
    T_ZOss_TaskMsg *pBuf = NULL;
    
    zOss_AssertEx(phead != NULL, NULL);
    
    if (phead->send_state == ZOSS_MSGSENDTYPE_MSG)
    {
        return ((CHAR *)phead + SCHE_M_TASKMSGHEAD_LEN);
    }
    else if (phead->send_state == ZOSS_MSGSENDTYPE_DATA)
    {
        pBuf = (T_ZOss_TaskMsg *)((CHAR *)phead + SCHE_M_TASKMSGHEAD_LEN);
        return (pBuf->msgbuf);
    }
    else
    {
        return NULL;
    }
}

/**************************************************************************
* ƣSche_getBufLength
* ͷָȡbuf
* ˵(IN)
            phead:ͷָ
            (OUT)
*   ֵ buf
* ˵ҪϢͨѶ
**************************************************************************/
UINT32 Sche_getBufLength(T_ZOss_TaskMsgHead *phead)
{
    T_ZOss_TaskMsg *pBuf = NULL;
    
    zOss_AssertEx(phead != NULL, 0);
    
    if (phead->send_state == ZOSS_MSGSENDTYPE_MSG)
    {
        return (phead->msgLen);
    }
    else if (phead->send_state == ZOSS_MSGSENDTYPE_DATA)
    {
        pBuf = (T_ZOss_TaskMsg *)((CHAR *)phead + SCHE_M_TASKMSGHEAD_LEN);
        return (pBuf->msgLenEX);
    }
    else
    {
        return 0;
    }
}

/**************************************************************************
* ƣzOss_SetState
* 趨״̬
* ˵(IN)
            next_state:״̬
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_SetState(UINT8 next_state)
{
    T_ZOss_TCB      *pTCB   = NULL;
    ZOSS_TASK_ID    taskId  = NULL;
    UINT32          nore    = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    taskId = zOss_GetSelfTaskID();          /* ȡǰID   */
    if (ZOSS_INVALID_TASK_ID == taskId)
    {
        return ZOSS_ERROR;
    }
    
    pTCB = (T_ZOss_TCB *)taskId;            /* ȡTCB    */
    if (pTCB->type != SCHE_OSS_TASK)
    {
        return ZOSS_ERROR;
    }
    
    /* ź */
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        if (taskId != pTCB->task_id)        /* 񲻴       */
        {
            zOss_PutMutex(gSche_TCBMutex);
            return ZOSS_ERROR;
        }
        
        pTCB->state = next_state;           /* ״̬         */
        nore = zOss_PutMutex(gSche_TCBMutex);
        if (nore == ZOSS_ERROR)
        {
            return ZOSS_ERROR;
        }
        return ZOSS_SUCCESS;
    }
    return ZOSS_ERROR;
}

#if ZOSS_CAPT_MSG
/**************************************************************************
* ƣzOss_RegTaskSendHook
* 趨Ϣͻص
* ˵(IN)
            task_id:IDΪ0Ϊǰ
            intercept_Entry:صָ
            hooktype:ص
            dire:   ZOSS_SETHOOKFLAG_MONI  :Ϣ
                    ZOSS_SETHOOKFLAG_TRACK : Ը
                    ZOSS_SETHOOKFLAG_INTER : Ϣػ
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵SDLʱtask_idΪ0
**************************************************************************/
UINT32 zOss_RegTaskSendHook(ZOSS_TASK_ID task_id, UINT8 hooktype, UINT8 dire, TASK_SEND_HOOK intercept_Entry)
{
    T_ZOss_TCB      *pTCB       = NULL;
    T_ZOss_SDLTCB   *pSDLTCB    = NULL;
    UINT32          nore        = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    if (hooktype < 1 || hooktype > 3)
    {
        return ZOSS_ERROR;
    }
    
    if (intercept_Entry != NULL && (dire < 1 || dire > 3))
    {
        return ZOSS_ERROR;
    }
    
    if (intercept_Entry == NULL)
    {
        dire = 0;
    }
    
    if (NULL == task_id)                    /* IDΪ趨ǰ */
    {
        task_id = zOss_GetSelfTaskID();
        if (ZOSS_INVALID_TASK_ID == task_id)
        {
            return ZOSS_ERROR;
        }
    }
    pTCB = (T_ZOss_TCB *)task_id;           /* ȡTCB    */
    
    if (pTCB->type == SCHE_OSS_TASK)        /* ÷SDL    */
    {
        /* ź */
        if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
        {
            if (task_id != pTCB->task_id)   /* 񲻴       */
            {
                zOss_PutMutex(gSche_TCBMutex);

                return ZOSS_ERROR;
            }
            pTCB->HookEntry[hooktype - 1] = intercept_Entry;
            pTCB->dire[hooktype - 1] = dire;
            nore = zOss_PutMutex(gSche_TCBMutex);
            if (nore == ZOSS_ERROR)
            {
                return ZOSS_ERROR;
            }
            return ZOSS_SUCCESS;
        }
    }
    else if (pTCB->type == SCHE_SDL_TASK)   /* SDL */
    {
        pSDLTCB = (T_ZOss_SDLTCB *)task_id;
        pSDLTCB->HookEntry[hooktype - 1] = intercept_Entry;
        pSDLTCB->dire[hooktype - 1] = dire;
        return ZOSS_SUCCESS;
    }
    return ZOSS_ERROR;
}
#endif

/**************************************************************************
* ƣzOss_GetSelfTaskID
* ȡǰID
* ˵(IN)
            (OUT)
*   ֵID
* ˵֧SDL
**************************************************************************/
__tcm_func ZOSS_TASK_ID zOss_GetSelfTaskID(VOID)
{
    ZOSS_THREAD_ID  threadId    = NULL;
    T_ZOss_TCB      *pTCB       = NULL;
    T_ZOss_TRF      *pTRF       = NULL;
    
    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    threadId = zOss_GetCurThreadID();       /* ȡǰ߳ID   */
    if (threadId == NULL)
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    pTRF = (T_ZOss_TRF *)Sche_GetTaskID(threadId);
    if (pTRF == NULL)
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    if (pTRF->thread_id == threadId)
    {
        pTCB = (T_ZOss_TCB *)zOss_ListFirst(&(pTRF->TCBReady));
        
        if (NULL != pTCB)
        {
            return (ZOSS_TASK_ID)pTCB;  /* ֹɱʱ񲻵id */
        }
    }
    return ZOSS_INVALID_TASK_ID;
}

/**************************************************************************
* ƣzOss_GetTaskID
* ͨȡID
* ˵(IN)
            task_name:
            (OUT)
*   ֵID
* ˵ԻȡSDLID
**************************************************************************/
__tcm_func ZOSS_TASK_ID zOss_GetTaskID(const CHAR *task_name)
{
    T_ZOss_TCB  *pCurTCB    = NULL;
    UINT32      nore        = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)            /* Ƿѳʼ */
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    zOss_AssertEx(NULL != task_name, ZOSS_INVALID_TASK_ID);
    
    /* ź */
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        pCurTCB = gSche_TCBHeadPtr;
        while (NULL != pCurTCB)
        {
            if (0 == strcmp((char*)task_name, (char *)pCurTCB->task_name) && pCurTCB == (T_ZOss_TCB *)pCurTCB->task_id)
            {
                zOss_PutMutex(gSche_TCBMutex);
                return (ZOSS_TASK_ID)pCurTCB;
            }
            pCurTCB = pCurTCB->next;
        }
        nore = zOss_PutMutex(gSche_TCBMutex);
        if (nore == ZOSS_ERROR)
        {
            return ZOSS_INVALID_TASK_ID;
        }
    }
    
    if (gSche_Task_Hook.get_id != NULL)
    {
        return gSche_Task_Hook.get_id(task_name);
    }
    
    return ZOSS_INVALID_TASK_ID;
}

/**************************************************************************
* ƣzOss_GetTaskName
* ͨIDȡ
* ˵(IN)
            task_id:ID
            (OUT)
*   ֵ
* ˵
**************************************************************************/
__tcm_func CHAR *zOss_GetTaskName(ZOSS_TASK_ID task_id)
{
    T_ZOss_TCB  *pCurTCB    = NULL;
    CHAR        *task_name  = NULL;

    if (gSche_IsTaskInit == FALSE)            /* Ƿѳʼ */
    {
        return NULL;
    }

    zOss_AssertEx(NULL != task_id, NULL);
 
    if (gSche_Task_Hook.get_name != NULL)
    {
        task_name = gSche_Task_Hook.get_name(task_id);
        if (task_name != NULL)
        {
            return task_name;
        }
    }

    pCurTCB = (T_ZOss_TCB *)task_id;

    if (pCurTCB == (T_ZOss_TCB *)pCurTCB->task_id)
    {
        return pCurTCB->task_name;
    }

    return NULL;
}

/**************************************************************************
* ƣzOss_Sender
* ȡϢԴID
* ˵(IN)
            (OUT)
*   ֵϢԴID
* ˵
**************************************************************************/
__tcm_func ZOSS_TASK_ID zOss_Sender(VOID)
{
    T_ZOss_TCB *pTCB = NULL;
    
    pTCB = (T_ZOss_TCB *)zOss_GetSelfTaskID();      /* ȡǰTCB */
    if (pTCB == NULL)
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    if (pTCB->type != SCHE_OSS_TASK)
    {
        return ZOSS_INVALID_TASK_ID;
    }
    
    return pTCB->sender_task_id;
}

/**************************************************************************
* ƣSche_DeadLoop
* ѭ
* ˵(IN)
            task_id_arr:ѭIDĿռ
            (OUT)
*   ֵѭID
* ˵
**************************************************************************/
UINT32 Sche_DeadLoop(ZOSS_TASK_ID *task_id_arr)
{
    T_ZOss_TCB  *pCurTCB            = NULL;
    UINT32      Curtask_time        = 0;
    UINT32      i                   = 0;
    UINT32      deadloop_task_num   = 0;
    UINT32      nore                = ZOSS_ERROR;
    
    if (gSche_IsTaskInit == FALSE)                  /* Ƿѳʼ */
    {
        return ZOSS_ERROR;
    }
    
    zOss_AssertEx(NULL != task_id_arr, ZOSS_ERROR);
    
    /* ź */
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        Curtask_time    = Osa_HwTimeRead();
        pCurTCB         = gSche_TCBHeadPtr;
        while (NULL != pCurTCB)
        {
            if (pCurTCB->run_status == ZOSS_STATE_STOPPED || pCurTCB->task_time == 0)
            {
                pCurTCB = pCurTCB->next;
                continue;
            }
            
            /* ȡִʱ */
            i = Curtask_time - pCurTCB->task_time;
            
            /* жǷʱ */
            if (i >= gSche_DeadLoop_Time * 1000 * 1000)
            {
                *task_id_arr = pCurTCB->task_id;
                task_id_arr++;
                deadloop_task_num++;
            }
            pCurTCB = pCurTCB->next;
        }
        nore = zOss_PutMutex(gSche_TCBMutex);
        if (nore == ZOSS_ERROR)
        {
            return ZOSS_ERROR;
        }
    }
    
    return deadloop_task_num;
}

/**************************************************************************
* ƣzOss_TaskInit
* ̬
* ˵(IN)
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_TaskInit(VOID)
{
    ZOSS_TASK_ID        task_id                 = NULL;
    UINT32              task_index              = 0;
    UINT32              i                       = 0;
    T_OSS_PARAM         *pPlatCfg               = NULL;
    T_ZOss_TaskTabItem  *TaskTab                = NULL;
    UINT32              uiSche_Max_TaskTab_Num  = 0;
    
    pPlatCfg = zOss_GetOssCfg();
    TaskTab = pPlatCfg->SysmCfg.pSysm_TaskItemTab;
    uiSche_Max_TaskTab_Num = pPlatCfg->SysmCfg.task_num;
    gSche_SaticTaskInitSema = zOss_CreateSemaphore("static_task", 0);
#ifdef _USE_HAL_HRDTST
    if (zDrvComm_GetPowerOnState() == POWER_ON_HDT_TEST)
    {
        for ( ; task_index < uiSche_Max_TaskTab_Num; task_index++)
        {
            if ((1 == TaskTab->is_use) && (TRUE == TaskTab->hardTestFlag))
            {
                task_id = zOss_CreateTask_EX(TaskTab->task_name, TaskTab->task_entry,
                                             TaskTab->stack_size, TaskTab->priority, 
                                             TaskTab->private_data_len, TaskTab->process_no, 1);
                
                if (task_id == ZOSS_INVALID_TASK_ID)
                {
                    return ZOSS_ERROR;
                }
                else
                {
                    gSysm_TaskIDTab[task_index] = task_id;     /* ǼID */
                    gTask_TaskNum++;
                }
            }
            TaskTab++;
        }
    }
    else
    {
#endif
#ifdef _USE_SDL
        tasksdl_table  = (tasksdl_desc *)zOss_Malloc((nof_signalcode * sizeof(tasksdl_desc)));
        if (tasksdl_table == NULL)
        {
            return ZOSS_ERROR;
        }
        memset(tasksdl_table, 0, (nof_signalcode * sizeof(tasksdl_desc)));
#endif
        for ( ; task_index < uiSche_Max_TaskTab_Num; task_index++)
        {
#ifdef _USE_HAL_HRDTST
            if ((1 == TaskTab->is_use) && ( FALSE == TaskTab->hardTestFlag))
#else
            if (1 == TaskTab->is_use)
#endif
            {
                task_id = zOss_CreateTask_EX(TaskTab->task_name, TaskTab->task_entry,
                                             TaskTab->stack_size, TaskTab->priority, 
                                             TaskTab->private_data_len, TaskTab->process_no, 1);
                        
                if (task_id == ZOSS_INVALID_TASK_ID)
                {
                    return ZOSS_ERROR;
                }
                else
                {
                    gSysm_TaskIDTab[task_index] = task_id;     /* ǼID */
                    gTask_TaskNum++; 
                }
            }
#ifdef _USE_SDL
            for (i = 0; i < nof_signalcode; i++)
            {
                if (strcmp((const char *)TaskTab->task_name, (const char *)signalcode_table[i].task_name) == 0)
                {
                    tasksdl_table[i].selfid     = signalcode_table[i].selfid;
                    tasksdl_table[i].task_id    = task_id;
                    break;
                }
            }
#endif
            TaskTab++;
        }
#ifdef _USE_HAL_HRDTST
    }
#endif

    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_SetTaskTimer
* : /ʱĿϢ;
            ʱΪο,ָʱ, öʱָϢԶͷŶʱռԴ().
* ˵: (IN)
            time_len:ʱ, λms
            msg_id:ʱ,͸öʱϢ
            arg:Ӳ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
            desk_task:ָĿĿΪʱöʱ
            bPeriod:Ƿ
            (OUT)
*   ֵ: ɹ:ӦĶʱID; ʧ:ZOSS_INVALID_TIMER_ID
* ˵: 
**************************************************************************/
ZOSS_TIMER_ID zOss_SetTaskTimer(UINT32 time_len, UINT32 msg_id, UINT32 arg, ZOSS_TASK_ID desk_task_id, BOOL bPeriod)
{
    T_TIMER_NODE    *pTimerNode = NULL;
    T_Task_Arg      *ptTaskArg  = NULL;
    UINT32          status      = 0;

    if (gSche_IsTaskInit == FALSE)          /* Ƿѳʼ */
    {
        return ZOSS_INVALID_TIMER_ID;
    }

    if(desk_task_id == NULL)
    {
        desk_task_id = zOss_GetSelfTaskID();
        zOss_AssertEx(NULL != desk_task_id, ZOSS_INVALID_TIMER_ID);
    }
    
    ptTaskArg = (T_Task_Arg *)zOss_Malloc(sizeof(T_Task_Arg));
    if (NULL == ptTaskArg)
    {
        return ZOSS_INVALID_TIMER_ID;
    }
    
    ptTaskArg->task_id  = desk_task_id;
    ptTaskArg->msg_id   = msg_id;
    ptTaskArg->arg      = arg;

    pTimerNode = (T_TIMER_NODE *)zOss_CreateTimer("TaskTimer", (ZOSS_TIMER_FUN)TaskTimer_CallBack, (SINT32)ptTaskArg, bPeriod);
    
    if (ZOSS_INVALID_TIMER_ID == pTimerNode)
    {
        zOss_Free(ptTaskArg);
    }
    else
    {
        ptTaskArg->pTimerNode = pTimerNode;
        pTimerNode->attached = (VOID *)ptTaskArg;
        status = zOss_StartTimer(pTimerNode, time_len, NULL, 0);
        
        if (status == ZOSS_ERROR)
        {
            zOss_KillTimer(pTimerNode);
            zOss_Free(ptTaskArg);
            pTimerNode = ZOSS_INVALID_TIMER_ID;
        }
    }
    return (ZOSS_TIMER_ID)pTimerNode;
}

/**************************************************************************
* : zOss_SetRelativeTimer
* : ÷ʱ;
            ʱΪο,ָʱ, öʱָϢԶͷŶʱռԴ.
* ˵: (IN)
            time_len:ʱ, λms
            msg_id:ʱ,͸öʱϢ
            arg:Ӳ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
            (OUT)
*   ֵ: ɹ:ӦĶʱID; ʧ:ZOSS_INVALID_TIMER_ID
* ˵: ڵ
**************************************************************************/
ZOSS_TIMER_ID zOss_SetRelativeTimer(UINT32 time_len, UINT32 msg_id, UINT32 arg)
{
    return zOss_SetTaskTimer(time_len, msg_id, arg, NULL, FALSE);
}

/**************************************************************************
* : zOss_SetRelativeTimerByTaskId
* : ÷ʱĿϢ;
            ʱΪο,ָʱ, öʱָϢԶͷŶʱռԴ.
* ˵: (IN)
            time_len:ʱ, λms
            msg_id:ʱ,͸öʱϢ
            arg:Ӳ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
            desk_task:ָĿĿΪʱöʱ
            (OUT)
*   ֵ: ɹ:ӦĶʱID; ʧ:ZOSS_INVALID_TIMER_ID
* ˵: 
**************************************************************************/
ZOSS_TIMER_ID zOss_SetRelativeTimerByTaskId(UINT32 time_len, UINT32 msg_id, UINT32 arg, ZOSS_TASK_ID desk_task_id)
{
    return zOss_SetTaskTimer(time_len, msg_id, arg, desk_task_id, FALSE);
}

/**************************************************************************
* : zOss_SetLoopTimer
* : ʱ;
            ʱΪο,ָʱ, öʱָϢ
* ˵: (IN)
            time_len:ʱ, λms
            msg_id:ʱ,͸öʱϢ
            arg:Ӳ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
            (OUT)
*   ֵ: ɹ:ӦĶʱʶ; ʧ:ZOSS_INVALID_TIMER_ID
* ˵: ڵ.
**************************************************************************/
ZOSS_TIMER_ID zOss_SetLoopTimer(UINT32 time_len, UINT32 msg_id, UINT32 arg)
{
    return zOss_SetTaskTimer(time_len, msg_id, arg, NULL, TRUE);
}

/**************************************************************************
* : zOss_SetLoopTimerByTaskId
* : ʱĿϢ;
            ʱΪο,ָʱ, öʱָϢ
* ˵: (IN)
            time_len:ʱ, λms
            msg_id:ʱ,͸öʱϢ
            arg:Ӳ,ݸںbufβδʱmsg_lenֵΪ4(sizeof(UINT32/arg))
            desk_task:ָĿĿΪʱöʱ
            (OUT)
*   ֵ: ɹ:ӦĶʱID; ʧ:ZOSS_INVALID_TIMER_ID
* ˵: 
**************************************************************************/
ZOSS_TIMER_ID zOss_SetLoopTimerByTaskId(UINT32 time_len, UINT32 msg_id, UINT32 arg, ZOSS_TASK_ID desk_task_id)
{
    return zOss_SetTaskTimer(time_len, msg_id, arg, desk_task_id, TRUE);
}

/**************************************************************************
* ƣSche_SetTaskID
* õ߳Ϣ
* ˵(IN) 
            threadId: ߳id
            taskId:Ϣָ
            (OUT)
*   ֵZOSS_ERRORʧܣZOSS_SUCCESSóɹ
* ˵ѡ
**************************************************************************/
UINT32 Sche_SetTaskID(ZOSS_THREAD_ID threadId, VOID *taskId)
{
    T_ZOsa_ThreadUserArea *ptArea = NULL;
    
    zOss_AssertEx(threadId != NULL && taskId != NULL, ZOSS_ERROR);    
    ptArea = Osa_GetThreadUserArea(threadId, TRUE);
    if (NULL == ptArea)
    {
        return ZOSS_ERROR;
    }
    else
    {
        ptArea->ptrf = taskId;
        return ZOSS_SUCCESS;
    }
}

/**************************************************************************
* ƣSche_GetTaskID
* õ߳Ϣ
* ˵: (IN)
            threadId: ߳id
            (OUT)
*   ֵNULL ʧ
* ˵ѡ
**************************************************************************/
__tcm_func VOID *Sche_GetTaskID(ZOSS_THREAD_ID threadId)
{
    T_ZOsa_ThreadUserArea *ptArea = NULL;
    
    zOss_AssertEx(threadId != NULL, NULL);
    ptArea = Osa_GetThreadUserArea(threadId, FALSE);
    
    if (NULL == ptArea)
    {
        return NULL;
    }
    else
    {
        return ptArea->ptrf;
    }
}

/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* ƣSche_DefTaskEntry
* ȱʡ
* ˵(IN)
            arg:ָ
            (OUT)
*   ֵ
* ˵ѡ
**************************************************************************/
__tcm_func static VOID Sche_DefTaskEntry(SINT32 arg)
{
    T_ZOss_TCB              *pTCB       = NULL;
    T_ZOss_TRF              *pTRF       = NULL;
    T_ZOss_TaskMsgHead      *msgPtr     = NULL;
    T_ZOss_TaskMsg          *bufPtr     = NULL;
    T_ZOsa_ThreadUserArea   *pUa        = NULL;
    ZOSS_THREAD_ID          threadId    = NULL;
    VOID                    *buf        = NULL;
    UINT32                  msgLen      = 0;
    UINT32                  nRet        = ZOSS_ERROR;
    UINT32                  nore        = ZOSS_ERROR;
#ifndef _OS_WIN
    UINT32  tempTaskTime    = 0;
    UINT32  taskTimeLen     = 0;
#endif
    
    pTRF = (T_ZOss_TRF *)arg;
    zOss_AssertExN(NULL != pTRF);
    
    pUa = Osa_GetThreadUserArea(zOss_GetCurThreadID(), FALSE);
    zOss_AssertExN(NULL != pUa);

    /* Ϣַ */
    while (1)
    {
        /* ȡϢ */
        nRet = zOss_RecvMsg((VOID **)&msgPtr, &msgLen, ZOSS_WAIT_FOREVER);
        zOss_AssertExN(nRet != ZOSS_ERROR);
        
        do
        {
            if (msgPtr->send_state > 4)
            {
                zOss_ASSERT(0);
                break;
            }

            pTCB = (T_ZOss_TCB *)msgPtr->t_task_id;         /* ȡĿTCB   */
            
            switch (msgPtr->msgID)
            {
            case EV_TASK_END:                               /* ɾϢ        */
                {
                    if (NULL == Sche_GetTCB(msgPtr->t_task_id))
                    {
                        break;
                    }
                    pTCB->task_id = NULL;
                    switch (pTCB->run_status)
                    {
                    case ZOSS_STATE_STOPPED:
                        {
                            zOss_ListDelete(&(pTRF->TCBStopped), &(pTCB->node));
                            break;
                        }
                    case ZOSS_STATE_IDLE:
                        {
                            zOss_ListDelete(&(pTRF->TCBIdle), &(pTCB->node));
                            break;
                        }
                    case ZOSS_STATE_READY:
                        {
                            zOss_ListDelete(&(pTRF->TCBReady), &(pTCB->node));
                            break;
                        }
                    default:
                        {
                            break;
                        }
                    }
                    Sche_RemoveTCB(pTCB);
                    if (pTCB->taskData != NULL)
                    {
                        zOss_Free(pTCB->taskData);
                    }

                    while (zOss_ListCount(&pTCB->msg_queue) > 0)
                    {
                        buf = (VOID *)zOss_ListFirst(&pTCB->msg_queue);
                        zOss_AssertExN(buf != NULL);
                        zOss_ListDelete(&pTCB->msg_queue, (T_ZOss_Node *)buf);
                        zOss_RetUB(buf);
                    }
                    zOss_Free(pTCB);
                    nore = zOss_RetUB(msgPtr);
                    if (nore == ZOSS_ERROR)
                    {
                        return;
                    }
                    if (pTRF->pno == 0)
                    {
                        if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TRFMutex, ZOSS_WAIT_FOREVER))
                        {
                            zOss_ListDelete(&gSche_TRF_List, &(pTRF->node));
                            zOss_PutMutex(gSche_TRFMutex);
                        }
                        zOss_Free(pTRF);
                        zOss_ExitThread();
                    }              
                    break;
                }
                
            case EV_TASK_CRE:                          /* 񴴽Ϣ  */
                {
                    if (pTCB->task_id == msgPtr->t_task_id)
                    {
                        zOss_ListAdd(&(pTRF->TCBIdle), &(pTCB->node));
                        pTCB->run_status = ZOSS_STATE_IDLE;
                    }
                    zOss_RetUB(msgPtr);             
                    break;
                }
                
            default:                                   /* ͨϢ      */
                {
                    if (pTCB->task_id == msgPtr->t_task_id)
                    {
                        zOss_ListAdd(&pTCB->msg_queue, &(msgPtr->node));
                        if (pTCB->run_status == ZOSS_STATE_IDLE)
                        {
                            zOss_ListDelete(&(pTRF->TCBIdle), &(pTCB->node));
                            zOss_ListAdd(&(pTRF->TCBReady), &(pTCB->node));
                            pTCB->run_status = ZOSS_STATE_READY;
                        }
                    }
                    else
                    {
                        zOss_RetUB((UINT8 *)msgPtr);
                    }              
                    break;
                }
            }
        }while (ZOSS_SUCCESS == zOss_RecvMsg((VOID **)&msgPtr, &msgLen, ZOSS_NO_WAIT));
        
        /* Ϣ */
        while (0 != zOss_ListCount(&(pTRF->TCBReady)))
        {
            pTCB = (T_ZOss_TCB *)zOss_ListFirst(&(pTRF->TCBReady));     /* ȡĵһ */
            if (pTCB->task_id == NULL)                                  /* ѱɾ */
            {
                pTCB->run_status = ZOSS_STATE_STOPPED;
                zOss_ListDelete(&(pTRF->TCBReady), &(pTCB->node));
                zOss_ListAdd(&(pTRF->TCBStopped), &(pTCB->node));
            }
            else
            {
                msgPtr = (T_ZOss_TaskMsgHead *)zOss_ListFirst(&pTCB->msg_queue);   /* ȡϢеĵһϢ */
                zOss_AssertExN(msgPtr != NULL);
                zOss_ListDelete(&pTCB->msg_queue, (T_ZOss_Node *)msgPtr);
                
                /* ʱϢ */
                if (msgPtr->send_state == ZOSS_MSGSENDTYPE_TIMER)
                {
                    /* ʱѾɾͣ */
                    if (Timer_IgnoreTaskMsg((ZOSS_TIMER_ID)(msgPtr->s_task_id)))
                    {
                        zOss_RetUB((UINT8 *)msgPtr);
                        zOss_ListDelete(&(pTRF->TCBReady), &(pTCB->node));
                        if (zOss_ListCount(&pTCB->msg_queue) == 0)          /* ϢΪ     */
                        {
                            pTCB->run_status = ZOSS_STATE_IDLE;
                            zOss_ListAdd(&(pTRF->TCBIdle), &(pTCB->node));
                        }
                        else                                            /* ϢвΪ   */
                        {
                            pTCB->run_status = ZOSS_STATE_READY;
                            zOss_ListAdd(&(pTRF->TCBReady), &(pTCB->node));
                        }
                        continue;
                    }
                    msgPtr->s_task_id = NULL;
                }
                /* ¼ϢϢ     */
                pTCB->msg_id = msgPtr->msgID;
                pTCB->sender_task_id = msgPtr->s_task_id;
                /* ״̬     */
                pTCB->run_status = ZOSS_STATE_RUN;
                /* 趨ʼʱ */
                if (gOsa_SwapTimeFlag && gExcep_DaemonTask != NULL)
                {
                    pTCB->task_time = Osa_HwTimeRead(); //zOss_GetTickCount();
                }
                pUa->curtaskid  = pTCB->task_id;
#if ZOSS_SELF_MIMO
                
                /* ˽߽ */
                if (NULL != pTCB->taskData && *(UINT32 *)((UINT32)pTCB->taskData + pTCB->private_data_len) != gSche_pDataRegion_Test)
                {
                    SCHE_printf("%s private data overflow", pTCB->task_name);
                    zOss_ASSERT(0);
                    return;
                }
                threadId = zOss_GetCurThreadID();
                zOss_AssertExN(pTCB->thread_id == threadId);
#endif
                /* ûϢ */
                switch (msgPtr->send_state)
                {
                    case ZOSS_MSGSENDTYPE_TIMER:
                    case ZOSS_MSGSENDTYPE_MSG:
                    {
                        pTCB->count++;
                        if (0 == msgPtr->msgLen)
                        {
                            pTCB->taskEntry(pTCB->state, msgPtr->msgID, NULL, msgPtr->msgLen, pTCB->taskData);
                        }
                        else
                        {
                            pTCB->taskEntry(pTCB->state, msgPtr->msgID, (UINT8 *)(msgPtr + 1), msgPtr->msgLen, pTCB->taskData);
                        }
                        if (pTCB->reserved[0] == 1 && msgPtr->msgID == EV_INIT && pTCB->state == ZOSS_STATUS_INIT )
                        {
                            zOss_PutSemaphore(gSche_SaticTaskInitSema);
                            pTCB->reserved[0] = 0;
                        }
                        /* ͷϢ */
                        zOss_RetUB((UINT8 *)msgPtr);
                        break;
                    }
                            
                    case ZOSS_MSGSENDTYPE_DATA:
                    {
                        bufPtr = (T_ZOss_TaskMsg *)(msgPtr + 1);
                        pTCB->count++;
                        pTCB->taskEntry(pTCB->state, msgPtr->msgID, (UINT8 *)bufPtr->msgbuf, bufPtr->msgLenEX, pTCB->taskData);
                        zOss_RetUB((UINT8 *)msgPtr);
                        break;
                    }
                            
                    case ZOSS_MSGSENDTYPE_INTER:
                    {
                        pTCB->count++;
                        pTCB->taskEntry(pTCB->state, msgPtr->msgID, (UINT8 *)msgPtr, msgPtr->msgLen, pTCB->taskData);
                        break;
                    }
                            
                    default:
                    {
                        break;
                    }
                }

#if ZOSS_SELF_MIMO
                /* ˽߽ */
                if (NULL != pTCB->taskData && *(UINT32 *)((UINT32)pTCB->taskData + pTCB->private_data_len) != gSche_pDataRegion_Test)
                {
                    SCHE_printf("%s private data overflow", pTCB->task_name);
                    zOss_ASSERT(0);
                    return;
                }
#endif
#ifndef _OS_WIN
                if (gOsa_SwapTimeFlag)
                {
                    tempTaskTime = Osa_HwTimeRead();
                    if (tempTaskTime >= pTCB->task_time)
                    {
                        taskTimeLen = tempTaskTime - pTCB->task_time;
                    }
                    else
                    {
                        taskTimeLen = tempTaskTime + ~pTCB->task_time;  /* ʱ */
                    }
                    pTCB->cputime += taskTimeLen;
                    pTCB->runtime += taskTimeLen;
                }
#endif
                pUa->curtaskid = 0;
                /* ִʱ */
                pTCB->task_time = 0;
                zOss_ListDelete(&(pTRF->TCBReady), &(pTCB->node));
                if (zOss_ListCount(&pTCB->msg_queue) == 0)                  /* ϢΪ     */
                {
                    pTCB->run_status = ZOSS_STATE_IDLE;
                    zOss_ListAdd(&(pTRF->TCBIdle), &(pTCB->node));
                }
                else                                                    /* ϢвΪ   */
                {
                    pTCB->run_status = ZOSS_STATE_READY;
                    zOss_ListAdd(&(pTRF->TCBReady), &(pTCB->node));
                }
            }
        }
    }
}

/**************************************************************************
* ƣSche_GetTCB
* IDȡTCB
* ˵(IN)
            taskId:ID
            (OUT)
*   ֵTCBָ룬ʧܷNULL
* ˵ѡ
**************************************************************************/
__tcm_func static T_ZOss_TCB *Sche_GetTCB(const ZOSS_TASK_ID taskId)
{
    T_ZOss_TCB *pCurTCB = NULL;
    
    zOss_AssertEx(NULL != gSche_TCBHeadPtr, NULL);
  
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        pCurTCB = gSche_TCBHeadPtr;
        while (NULL != pCurTCB)
        {
            if (pCurTCB == (T_ZOss_TCB *)taskId)
            {
                zOss_PutMutex(gSche_TCBMutex);
                return pCurTCB;
            }
            pCurTCB = pCurTCB->next;
        }
        zOss_PutMutex(gSche_TCBMutex);
    }
    return NULL;
}

/**************************************************************************
* ƣSche_AddTCB
* һTCB
* ˵(IN)
            ptTcb:ӵTCBָ
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵ѡ
**************************************************************************/
static UINT32 Sche_AddTCB(T_ZOss_TCB *ptTcb)
{
    UINT32 nore = ZOSS_ERROR;
    
    zOss_AssertEx(NULL != ptTcb, ZOSS_ERROR);
    
    ptTcb->next = NULL;
    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        if (gSche_MaxTCBLen >= gSche_Max_TaskTab_Num)                /*  */
        {
            zOss_PutMutex(gSche_TCBMutex);
            return ZOSS_ERROR;
        }
        
        if (NULL == gSche_TCBTailPtr)
        {
            gSche_TCBHeadPtr = ptTcb;
            gSche_TCBTailPtr = ptTcb;
        }
        else
        {
            gSche_TCBTailPtr->next = ptTcb;
            gSche_TCBTailPtr = ptTcb;
        }
        
        gSche_MaxTCBLen++;
        nore = zOss_PutMutex(gSche_TCBMutex);
        if (nore == ZOSS_ERROR)
        {
            return ZOSS_ERROR;
        }
        return ZOSS_SUCCESS;
    }
    return ZOSS_ERROR;
}

/**************************************************************************
* ƣSche_RemoveTCB
* ɾһTCBͷ
* ˵(IN)
            pDelTcb:ҪɾTCBָ
            (OUT)
*   ֵɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵ѡ
**************************************************************************/
static UINT32 Sche_RemoveTCB(T_ZOss_TCB *pDelTcb)
{
    T_ZOss_TCB  *pCurTCB    = NULL;
    UINT32      nore        = ZOSS_ERROR;
    
    zOss_AssertEx(NULL != pDelTcb, ZOSS_ERROR);

    if (ZOSS_SUCCESS == zOss_GetMutex(gSche_TCBMutex, ZOSS_WAIT_FOREVER))
    {
        if (NULL == gSche_TCBHeadPtr)       /* Ϊ */
        {
            zOss_PutMutex(gSche_TCBMutex);
            return ZOSS_ERROR;
        }

        if (pDelTcb == gSche_TCBHeadPtr)    /* ɾͷ */
        {
            if (gSche_TCBHeadPtr == gSche_TCBTailPtr)   /* ֻһ */
            {
                gSche_TCBTailPtr = NULL;
                gSche_TCBHeadPtr = NULL;
            }
            else
            {
                gSche_TCBHeadPtr = gSche_TCBHeadPtr->next;
            }
            gSche_MaxTCBLen--;
            nore = zOss_PutMutex(gSche_TCBMutex);
            if (nore == ZOSS_ERROR)
            {
                return ZOSS_ERROR;
            }
            return ZOSS_SUCCESS;
        }

        pCurTCB = gSche_TCBHeadPtr;
        while (NULL != pCurTCB)
        {
            if (pCurTCB->next == pDelTcb)
            {
                pCurTCB->next = pDelTcb->next;
                if (gSche_TCBTailPtr == pDelTcb)  /* ɾβ */
                {
                    gSche_TCBTailPtr = pCurTCB;
                }
                gSche_MaxTCBLen--;
                nore = zOss_PutMutex(gSche_TCBMutex);
                if (nore == ZOSS_ERROR)
                {
                    return ZOSS_ERROR;
                }
                return ZOSS_SUCCESS;
            }
            pCurTCB = pCurTCB->next;
        }
        zOss_PutMutex(gSche_TCBMutex);
    }
    return ZOSS_ERROR;
}

__tcm_func static VOID TaskTimer_CallBack(T_Task_Arg *task_arg)
{
    T_ZOss_TaskMsgHead *pTaskMsg = NULL;
    
    zOss_AssertExN(task_arg != NULL);
    
    pTaskMsg = (T_ZOss_TaskMsgHead *)zOss_GetUB(sizeof(T_ZOss_TaskMsgHead) + sizeof(task_arg->arg)); /* ڴ */
    
    zOss_AssertExN(pTaskMsg != NULL);
    
    pTaskMsg->send_state    = ZOSS_MSGSENDTYPE_TIMER;
    pTaskMsg->msgID         = task_arg->msg_id;
    pTaskMsg->msgLen        = sizeof(task_arg->arg);
    pTaskMsg->t_task_id     = task_arg->task_id;
    pTaskMsg->s_task_id     = (ZOSS_TASK_ID)task_arg->pTimerNode;
    zOss_Memcpy((UINT8 *)(pTaskMsg + 1), &(task_arg->arg), pTaskMsg->msgLen);
    zOss_TaskSendDataEx(pTaskMsg); /* Ϣ */
}

/**************************************************************************
* : Timer_IgnoreTaskMsg
* : жǷҪյĶʱϢ
* ˵: (IN)
            timerId:ʱID
            (OUT)
*   ֵ: Ҫ:TRUE;FALSE
* ˵: úṩȳʹãû֤
            ڷԶʱTRUE,ͬʱͷŶʱռԴ
**************************************************************************/
__tcm_func static BOOL Timer_IgnoreTaskMsg(ZOSS_TASK_ID timerId)
{
    T_TIMER_NODE *pTimerNode = NULL;
    
    zOss_AssertEx(NULL != timerId, TRUE);
    pTimerNode = (T_TIMER_NODE *)timerId;
    
    if (pTimerNode->Flag != TIMER_USE && pTimerNode->Flag != TIMER_SUSPEND)
    {
        return TRUE;
    }
    
    if (pTimerNode->bPeriod == FALSE)
    {
        zOss_KillTimer(timerId);
    }
        
    return FALSE;
}

#ifdef __cplusplus
}
#endif

