/***********************************************************************
* Copyright (C) 2001, ZTE Corporation.
* 
* File Name: 	drvs_cipher.h
* File Mark:  	
* Description:  Provide cipher module Function prototype declaration
*                and type declaration.
* Others:  	
* Version:  	v0.5
* Author:  	Wangxia
* Date:  	2008-07-06
* 
* History 1: 	
* History 2: 
**********************************************************************/
#ifndef _DRVS_CIPHER_H
#define _DRVS_CIPHER_H
/**************************************************************************
 *                                  Include files                                                                             *
 **************************************************************************/




/**************************************************************************
 *                                  Macro   
 *
 **************************************************************************/
 #define ZDRV_DEV_CIPHER  "cipher"

 
 /**************************************************************************
 *                                  Types                                                                                      *
 **************************************************************************/

/* param of cipher interface function */
typedef struct
{
 UINT32  uiDirection;		 /* direction param*/
 UINT32  uiCount;			  /* count param for encrypt and integrity check */
 UINT8	  pcKey[16];		/* key param */
 union
 {
	 UINT32  uiBearer;		 /* bearer param for encrypt */
	 UINT32  uiFresh;		  /* fresh param for integrity check */
 }uOthers;
} T_ZDrvCipher_Param;

 
typedef UINT8 aCiphKey[4][16]; 

/*GPRS cipher  struct, GPRS uses GEA1/2,GEA3 algorithm*/
 typedef struct
{
	UINT8 		*headerStart_ptr;
	UINT16		headerLength;
	UINT8 		*payloadStart_ptr;
	UINT16		payloadLength;
	UINT16		crcLength;
	UINT8 		*destination_ptr;
	UINT8  		cipherOn;
	UINT8  		*kc_ptr;
	UINT32 		cipherInput;
} T_ZDrvCipher_GEACipherData;


 typedef struct
{
	SINT32		Direction_CK_index;
	UINT32		Count;
	UINT32		Bearer;
	UINT32		Length;	
	UINT32		Fresh;
	UINT32 		*Message;
	UINT32		Direction;
	SINT32		IK_index;
	UINT32		MAC_I;
}T_ZDrvCipher_RequestListType;

typedef struct 
{
	SINT32		CiphContext;
	SINT32		CallerId;
	SINT32		NoRequests;
	aCiphKey		*IK;
	aCiphKey		*CK;
	T_ZDrvCipher_RequestListType  RequestList[2];
}T_ZDrvCipher_SCiphF8;

typedef T_ZDrvCipher_SCiphF8  T_ZDrvCipher_SCiphF9;

/**************************************************************************
 *                           Global  Variables                                                                              *
 **************************************************************************/



	
/**************************************************************************
 *                           Function Prototypes                                                                        *
 **************************************************************************/
/**************************************************************************
* Functin: zDrvCipher_Encrypt
* Description: This function is used to encrypt the input data.
* Parameters:
*		(IN)
*				pBufferInOut: Data buffer for input and output, and its size must be a multiple of 32
*				uiBitLenInOut: Data length of input and output, 1-20000bit.
*				pPara: Stuct T_ZDrvCipher_PARA
*		(OUT)
*				pBufferInOut: Data buffer for input and output, and its size must be a multiple of 32
* Returns:
*		T_ZDrv_ErrCode
* Others:
*		1. Param pBufferInOut is both for input and output.
*		2. The data length of input and output is the same.
 **************************************************************************/
SINT32 zDrvCipher_Encrypt( CHAR *pBufferInOut, UINT32 uiBitLenInOut, T_ZDrvCipher_Param *pParam );


/**************************************************************************
* Functin: zDrvCipher_Integrity
* Description: This function is used to chech the integrity.
* Parameters:
*	(IN)
*				pBufferInOut: Data buffer for input and output, and its size must be a multiple of 32
*				uiBitLenInOut: Data length of input and output.
*				pPara: Stuct T_ZDrvCipher_PARA
*		(OUT)
*				pBufferInOut: Data buffer for input and output, and its size must be a multiple of 32
* Returns:
*	   T_ZDrv_ErrCode
* Others:
*		1. Param pBufferInOut is both for input and output.
*		2. The data length of output is 32bit.
 **************************************************************************/
SINT32 zDrvCipher_Integrity( CHAR *pBufferInOut, UINT32 uiBitLenIn, T_ZDrvCipher_Param *pParam );

/***************************************************************************************
* Function: zDrvCipher_GprsUintInitialise
* Description: This function is used to initialize  ciphering semaphoreme,olny using for GPRS communication
* Parameters: 
*   Input:
*		None    
*   Output: 
*		None
* Returns:   
*		None
***************************************************************************************/
VOID zDrvCipher_GprsUnitInitialise (VOID);


/***************************************************************************************
* Function: zDrvCipher_GprsUnitEncode
* Description: This function is used to encode data of uplink,olny using for GPRS communication
* Parameters: 
*   Input:
*		pointer of  T_ZDrvCipher_GEACipherData struct   
*   Output: 
*		None
* Returns:   
*		None
***************************************************************************************/
VOID zDrvCipher_GprsUnitEncode(T_ZDrvCipher_GEACipherData * ciData_ptr);

/***************************************************************************************
* Function: zDrvCipher_GgprsUnitEncode
* Description: This function is used to encode data of uplink,olny using for GPRS communication
* Parameters: 
*   Input:
*		pointer of  T_ZDrvCipher_GEACipherData struct   
*   Output: 
*		None
* Returns:   
*		None
***************************************************************************************/
VOID zDrvCipher_GgprsUnitEncode(T_ZDrvCipher_GEACipherData * ciData_ptr);


/***************************************************************************************
* Function: zDrvCipher_GprsUnitDecode
* Description: This function is used to encode data of downlink,olny using for GPRS communication
* Parameters: 
*   Input:
*		pointer of  T_ZDrvCipher_GEACipherData struct   
*   Output: 
*		None
* Returns:   
*		None
***************************************************************************************/
BOOL zDrvCipher_GprsUnitDecode(T_ZDrvCipher_GEACipherData * ciData_ptr);

/****************************************************************************************
* Function: zDrvCipher_F8
* Description: This function is used to cipher data using f8 algorithm which be used in UMTS communication
* Parameters: 
*   Input:
*		pointer of  T_ZDrvCipher_SCiphF8 struct   
*   Output: 
*		None
* Returns:   
*		1: faild
*		0:success
****************************************************************************************/
BOOL zDrvCipher_F8(T_ZDrvCipher_SCiphF8  *f8_ctrl);


/***************************************************************************************
* Function: zDrvCipher_F9
* Description: This function is used to cipher data using f9 algorithm which be used in UMTS communication
* Parameters: 
*   Input:
*		pointer of  T_ZDrvCipher_GEACipherData struct   
*   Output: 
*		None
* Returns:   
*		None
***************************************************************************************/
VOID  zDrvCipher_F9(T_ZDrvCipher_SCiphF9  *f9_ctrl);


#endif	/* _CIPHER_API_H */

