/*******************************************************************************
 * Copyright (C) 2010, ZTE Corporation.
 *
 * File Name:	drvs_pmic_rtc.h
 * File Mark:
 * Description:
 * Others:
 * Version:       V1.0
 * Author:        yuxiang
 * Date:          2016-01-27
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_PMIC_RTC_H
#define _DRVS_PMIC_RTC_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_io_rtc.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#if defined(_USE_PMIC_ZX234290)

#define ZX234290_RTC_ALARM_INT_EN_LSH           (1)
#define ZX234290_RTC_ALARM_INT_EN_WID           (1)

#define ZX234290_RTC_TIMER_INT_EN_LSH           (0)
#define ZX234290_RTC_TIMER_INT_EN_WID           (1)


    /*RTC TIME SECONDS MIN HOU DAY MON YEAR WEEKDAY*/
#define ZX234290_RTC_TIME_SECONDS_LSH          	(0)
#define ZX234290_RTC_TIME_SECONDS_WID           (7)

#define ZX234290_RTC_TIME_MINUTES_LSH         	(0)
#define ZX234290_RTC_TIME_MINUTES_WID           (7)

#define ZX234290_RTC_TIME_HOURS_LSH             (0)
#define ZX234290_RTC_TIME_HOURS_WID            	(6)

#define ZX234290_RTC_TIME_DAYS_LSH             	(0)
#define ZX234290_RTC_TIME_DAYS_WID            	(6)

#define ZX234290_RTC_TIME_MONTHS_LSH            (0)
#define ZX234290_RTC_TIME_MONTHS_WID            (5)
#define ZX234290_RTC_TIME_CENTURY_LSH           (7)
#define ZX234290_RTC_TIME_CENTURY_WID           (1)

#define ZX234290_RTC_TIME_YEAR_LSH             	(0)
#define ZX234290_RTC_TIME_YEAR_WID            	(7)

#define ZX234290_RTC_TIME_WEEKDAY_LSH          	(0)
#define ZX234290_RTC_TIME_WEEKDAY_WID           (3)

    /*RTC ALARM  MIN HOU DAY  WEEKDAY*/
#define ZX234290_RTC_AlARM_MINUTES_LSH      	(0)
#define ZX234290_RTC_AlARM_MINUTES_WID        	(7)

#define ZX234290_RTC_AlARM_HOURS_LSH          	(0)
#define ZX234290_RTC_AlARM_HOURS_WID          	(6)

#define ZX234290_RTC_AlARM_DAYS_LSH          	(0)
#define ZX234290_RTC_AlARM_DAYS_WID          	(6)

#define ZX234290_RTC_AlARM_WEEKDAY_LSH      	(0)
#define ZX234290_RTC_AlARM_WEEKDAY_WID        	(3)

#define ZX234290_RTC_AlARM_SECOND_LSH      		(0)
#define ZX234290_RTC_AlARM_SECOND_WID        	(7)
    /*RTC ALARM Enable*/
#define ZX234290_RTC_AlARM_ACTIVATED_LSH        (7)
#define ZX234290_RTC_AlARM_ACTIVATED_WID        (1)

    /* RTC TIMER ENABLE */
#define ZX234290_RTC_TIMER_EN_LSH           	(7)
#define ZX234290_RTC_TIMER_EN_WID           	(1)

#define ZX234290_RTC_TIMER_TD_LSH           	(0)
#define ZX234290_RTC_TIMER_TD_WID           	(2)

#define ZX234290_RTC_TIMER_CNT_LSH           	(0)
#define ZX234290_RTC_TIMER_CNT_WID           	(8)

    /*RTC MASK IRQ */
#define ZX234290_RTC_MASK_ALARM_LSH           	(0)
#define ZX234290_RTC_MASK_ALARM_WID           	(1)

#define ZX234290_RTC_MASK_HOUR_LSH           	(4)
#define ZX234290_RTC_MASK_HOUR_WID           	(1)

#define ZX234290_RTC_MASK_MIN_LSH           	(3)
#define ZX234290_RTC_MASK_MIN_WID           	(1)
    /*AF/TF        alarm flag/timer flag*/
#define ZX234290_RTC_AF_LSH           	        (3)
#define ZX234290_RTC_AF_WID           	        (1)

#define ZX234290_RTC_TF_LSH           	        (2)
#define ZX234290_RTC_TF_WID           	        (1)

#define ZX234290_BCD2DEC(var)	((((var&0xF0)>>4)*10)+(var&0x0F))
#define ZX234290_DEC2BCD(var)	(((var/10)<<4)+(var%10))


typedef enum _T_ZDrvZx234290_TimerCount
{
	TIMER_COUNT_4096	= 0,
	TIMER_COUNT_64 		= 1,	/* 64 DEFAULT	*/
	TIMER_COUNT_1 		= 2,	/* 1	*/
	TIMER_COUNT_1_60 	= 3,	/* 1/60	*/

	TIMER_COUNT_MAX
}T_ZDrvZx234290_TimerCount;


/**************************************************************************
 *                                  Types                                                                                      *
 **************************************************************************/

typedef struct
{
    UINT8   mday;  /* day of the month    - [1,31]  */
    UINT8   mon;   /* months              - [01,12] */
    UINT8   wday;  /*days in a week       - [1,7] NULL when input*/
    UINT16  year;  /* years               - [0000,9999] */
}T_ZDrvRtc_Date;

typedef struct
{
    BOOL    PM_flag;	 /* if 12 hour flag = TRUE    TRUE->PM ; FALSE->AM */
    BOOL    mode_12_hour; /* TRUE->12 hour mode ; FALSE-> 24 hour mode */ /*20080227*/
    UINT8   sec;	/* seconds after the minute   - [0,59]  */
    UINT8   min;	/* minutes after the hour      - [0,59]  */
    UINT8   hour;	/* hours after the midnight   - [0,23]  */
}T_ZDrvRtc_Time;

typedef enum
{
    MON = 1,
    TUES,
    WED,
    THURS,
    FRI,
    SAT,
    SUN,

    MAX_RTC_WEEKDAY
} T_ZDrvRtc_WeekDay;

typedef enum _T_ZDrvRtc_TimerUnit
{
	RTC_TIMER_COUNT_4096	= 0,		/* 1/4096 s*/
	RTC_TIMER_COUNT_64 		= 1,	/* 64 DEFAULT	,1/64 s*/
	RTC_TIMER_COUNT_1 		= 2,	/* 1	,s*/
	RTC_TIMER_COUNT_1_60 	= 3,	/* 1/60	,min*/

	RTC_TIMER_COUNT_MAX
}T_ZDrvRtc_TimerUnit;

typedef struct  _T_ZDrvRtc_Timer
{
	UINT8 iCount;
	T_ZDrvRtc_TimerUnit unit;
}T_ZDrvRtc_Timer;


/*for appstart.c*/

typedef enum
{
    RTC_12_HOUR_MODE,
    RTC_24_HOUR_MODE,

    MAX_RTC_HOUR_MODE
} T_ZDrvRtc_HourMode;

#endif

/****************************************************************************
* 	                                        Types
****************************************************************************/

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

#endif/*_DRVS_PMIC_RTC_H*/

