/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       v2.0
 * Author:        wuhui
 * Date:          2016-9-13
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

#ifndef _DRVS_SENSOR_REF_H
#define _DRVS_SENSOR_REF_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include    "drvs_cam.h"


/****************************************************************************
* 	                                        Macros
****************************************************************************/


/****************************************************************************
* 	                                        Types
****************************************************************************/
#if defined(_USE_SPICC)

typedef enum
{
	BUF_WRITING= 0, /* the Buffer  storing the newest frame*/
	BUF_FULL= 1,
	BUF_READING= 2,
	BUF_FREE= 3,
	MAX_BUF_FLAG =4
}T_Halsensor_BufFlag;

#endif
typedef enum 
{
	SENSOR_OPEN= 0x0,
	SENSOR_START = 0x1,
	SENSOR_STANDBY = 0x2,
	SENSOR_CLOSE = 0x3,
	MAX_SENSOR_STATE
}T_SensorState;

#if defined (_CHIP_ZX297520V3)

typedef enum
{
	CLK_OUT1_20M,
	CLK_OUT1_40M,
	CLK_OUT1_13M,
	CLK_OUT1_26M
} T_ZDrv_WifiBtFreq;

#endif

#if defined (_CHIP_ZX297520V2)

typedef enum
{
	CLK_OUT1_13M,
	CLK_OUT1_26M,
	CLK_OUT1_20M,
	CLK_OUT1_40M
} T_ZDrv_WifiBtFreq;

#endif

#if defined(_USE_RAW_BUFFER)

typedef enum
{
	HAL_CAM_RAWBUF_PAST= 0,
	HAL_CAM_RAWBUF_CURRENT= 1,	/* the Buffer  store the newest frame*/
	MAX_HAL_CAM_RAWBUF_FLAG =2
}T_HalCam_RawBufFlag;
	
typedef struct
{
	T_HalCam_Buff_Addr	rawBufAddr;
	UINT32	            rawBufLen;
	T_HalCam_RawBufFlag	rawBufFlag;
} T_HalSensor_RawBuff;

#endif

typedef struct
{
	UINT8	uiReg;
	UINT8	uiVal;
} T_HalSensor_RegVal;

typedef enum
{
    SENSOR_POWER_OFF,
    SENSOR_POWER_ON,

    MAX_SENSOR_POWER_CTRL
}T_HalSensor_PowerCtrl, *T_HalSensor_PowerCtrlPtr;

typedef enum
{
    SENSOR_RESET_OFF,
    SENSOR_RESET_ON,

    MAX_SENSOR_RESET_CTRL
}T_HalSensor_ResetCtrl, *T_HalSensor_ResetCtlPtr;
typedef enum
{
    SPI_OUT_ENABLE,
    SPI_OUT_DISABLE,

    MAX_SPI_OUT_CTRL
}T_HalSensor_SpiCtrl, *T_HalSensor_SpiCtrlPtr;


typedef struct _T_HalSensor_Operations
{
    SINT32 (*halSensor_Open)( VOID );
    SINT32 (*halSensor_Close)( VOID );
	SINT32 (*halSensor_Start)( VOID );
    SINT32 (*halSensor_Stop)( VOID );
    SINT32 (*halSensor_PowerCtrl)(const T_HalSensor_PowerCtrl tPowerCtrl);
    SINT32 (*halSensor_ResetCtrl)(const T_HalSensor_ResetCtrl tResetCtrl);
    SINT32 (*halSensor_GetDevInfo)( T_ZDrv_SensorInfo *ptDevInfo );
    SINT32 (*halSensor_SetPixelFmt)( T_ZDrv_PixelFmt tFmt );
    SINT32 (*halSensor_SetImgSize)( T_ZDrv_CamOutputSize tImgSize );
    SINT32 (*halSensor_SetFrameRate)( T_ZDrv_CamFps tFrmRate );
    SINT32 (*halSensor_SetZoom)( T_ZDrv_CamZoom tZoom );
    SINT32 (*halSensor_SetBrightness)( T_ZDrv_CamBrightness tBrn );
    SINT32 (*halSensor_SetContrast)( T_ZDrv_CamContrast tCon );
    SINT32 (*halSensor_SetEffect)( T_ZDrv_CamEffect tEffect );
    SINT32 (*halSensor_SetWhiteBalance)( T_ZDrv_CamWhiteBalance tWB );
    /* SINT32 (*halSensor_SetSceneMode)( T_ZDrv_SceneMode tScreen ); */
    SINT32 (*halSensor_SetNightMode)(T_ZDrv_CamNightMode tNightMode);
    SINT32 (*halSensor_SetLightMode)(T_ZDrv_CamLightMode tLightMode);
    SINT32 (*halSensor_SetSaturation)(T_ZDrv_CamSaturation tSat);
    SINT32 (*halSensor_SetMirrorFlip)(T_ZDrv_MirrorType tMirrorFlip);
	SINT32 (*halSensor_SetAntiFlicker)(T_ZDrv_AntiFlicker tAntiFlicker);
	SINT32 (*halSensor_SetEV)(T_ZDrv_CamExpCom tEV);
    SINT32 (*halSensor_GetRegister)(UINT8 uiReg, UINT8 *puiVal);
    SINT32 (*halSensor_SetRegister)(UINT8 uiReg, UINT8 uiVal);
	#if defined(_USE_SPICC)
	SINT32 (*halSensor_GetOneFrame)(T_HalCam_Buff_Addr* ptBuff);
	SINT32 (*halSensor_FreeBuff)(T_HalCam_Buff_Addr readingBuff);
	#endif
	#if defined(_USE_RAW_BUFFER)
	SINT32 (*halSensor_GetOneFrame)(T_HalCam_Buff_Addr ptBuff);
	#endif
    /* for updating of version */
    UINT32  uiVersion;
    VOID     *pAdditionalOps;
} T_HalSensor_Operations, *T_HalSensor_OperationsPtr;
#if defined(_USE_TYPE_GC6133)
SINT32 zDrvGc6133_Initiate(VOID);
#endif
#if defined(_USE_TYPE_BF3A01CS)
SINT32 zDrvBf3a01cs_Initiate(VOID);
#endif

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
/*******************************************************************************
* Functin: halSensor_Open
* Description: This function is used to open the sensor.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be opened.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_Open( T_ZDrv_SensorId tSensorId );


/*******************************************************************************
* Functin: halSensor_Close
* Description: This function is used to close the sensor.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_Close( T_ZDrv_SensorId tSensorId );

/*******************************************************************************
* Functin: halSensor_Start
* Description: This function is used to Start the sensor.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be started.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_Start( T_ZDrv_SensorId tSensorId );

/*******************************************************************************
* Functin: halSensor_Stop
* Description: This function is used to stop the sensor.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be stoped.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_Stop( T_ZDrv_SensorId tSensorId );

/*******************************************************************************
* Functin: halSensor_PowerCtrl
* Description: This function is used for controlling sensor power on/off via a GPIO.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tPowerCtrl: the logic of power on or off.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_PowerCtrl(const T_ZDrv_SensorId tSensorId, const T_HalSensor_PowerCtrl tPowerCtrl);


/*******************************************************************************
* Functin: halSensor_ResetCtrl
* Description: This function is used for resetting the sensor.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*               tResetCtrl: the logic of reset on or off.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_ResetCtrl(const T_ZDrv_SensorId tSensorId, const T_HalSensor_ResetCtrl tResetCtrl);


/*******************************************************************************
* Functin: halSensor_GetDevInfo
* Description: This function is used to get the sensor information.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*       (OUT)
*               ptDevInfo: sensor information pointer.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_GetDevInfo( T_ZDrv_SensorId tSensorId, T_ZDrv_SensorInfo *ptDevInfo );


/*******************************************************************************
* Functin: halSensor_SetPixelFmt
* Description: This function is used to set the pixel format.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tFmt: pixel format.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetPixelFmt( T_ZDrv_SensorId tSensorId, T_ZDrv_PixelFmt tFmt );


/*******************************************************************************
* Functin: halSensor_SetImgSize
* Description: This function is used to set the image size .
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tImgSize: image size.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetImgSize( T_ZDrv_SensorId tSensorId, T_ZDrv_CamOutputSize tImgSize );


/*******************************************************************************
* Functin: halSensor_SetFrameRate
* Description: This function is used to set the frame rate.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*               tFrmRate: frame rate.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetFrameRate( T_ZDrv_SensorId tSensorId, T_ZDrv_CamFps tFrmRate );


/*******************************************************************************
* Functin: halSensor_SetZoom
* Description: This function is used to set the zoom level.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*               tZoom: zoom level.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetZoom( T_ZDrv_SensorId tSensorId, T_ZDrv_CamZoom tZoom );


/*******************************************************************************
* Functin: halSensor_SetBrightness
* Description: This function is used to set the brightness.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*               tBri: brightness.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetBrightness( T_ZDrv_SensorId tSensorId, T_ZDrv_CamBrightness tBrn );


/*******************************************************************************
* Functin: halSensor_SetContrast
* Description: This function is used to set the constrast.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*               tCon: constrast.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetContrast( T_ZDrv_SensorId tSensorId, T_ZDrv_CamContrast tCon );


/*******************************************************************************
* Functin: halSensor_SetEffect
* Description: This function is used to set the effect.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be closed.
*               tEffect: effect.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetEffect( T_ZDrv_SensorId tSensorId, T_ZDrv_CamEffect tEffect );


/*******************************************************************************
* Functin: halSensor_SetWhiteBalance
* Description: This function is used to set the white balance.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tWB: white balance.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetWhiteBalance( T_ZDrv_SensorId tSensorId, T_ZDrv_CamWhiteBalance tWB );


/*******************************************************************************
* Functin: halSensor_SetSceneMode
* Description: This function is used to set the scene mode.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tScreen: scene mode.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
/* SINT32 halSensor_SetSceneMode( T_ZDrv_SensorId tSensorId, T_ZDrv_SceneMode tScreen ); */


/*******************************************************************************
* Functin: halSensor_SetNightMode
* Description: This function is used to set the night mode.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tNightMode: night mode.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetNightMode(T_ZDrv_SensorId tSensorId, T_ZDrv_CamNightMode tNightMode);


/*******************************************************************************
* Functin: halSensor_SetMirrorFlip
* Description: This function is used to set the mirror and(or) flip.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tMirrorFlip: mirror and(or) flip.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetMirrorFlip(T_ZDrv_SensorId tSensorId, T_ZDrv_MirrorType tMirrorFlip);


/*******************************************************************************
* Functin: halSensor_GetRegister
* Description: This function is used to get the value of sensor register.
* Parameters:
*       (IN)
*
*       (OUT)
*               None.
* Returns:
*       
* Others:
*       
*******************************************************************************/
SINT32 halSensor_GetRegister(T_ZDrv_SensorId tSensorId, UINT8 uiReg, UINT8 *pValue);

/*******************************************************************************
* Functin: halSensor_SetRegister
* Description: This function is used to set the value of sensor register.
* Parameters:
*       (IN)
*               
*       (OUT)
*               None.
* Returns:
*       
* Others:
*       
*******************************************************************************/
SINT32 halSensor_SetRegister(T_ZDrv_SensorId tSensorId, UINT8 uiReg, UINT8 uiVal);

/*******************************************************************************
* Functin: halSeneor_SetLightMode
* Description: This function is used to set the light mode.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tLightMode: light mode.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetLightMode(T_ZDrv_SensorId tSensorId, T_ZDrv_CamLightMode tLightMode);


/*******************************************************************************
* Functin: halSensor_SetSaturation
* Description: This function is used to set the saturation.
* Parameters:
*       (IN)
*               tSensorId: which sensor to be set.
*               tLightMode: light mode.
*       (OUT)
*               None.
* Returns:
*       DRV_SUCCESS: successed.
*       DRV_ERR_NOT_SUPPORTED: this device don't support ioctrl operation.
*       DRV_ERR_NOT_OPENED: has not been opend yet.
*       DRV_ERR_INVALID_PARAM: the input parameters are invalid
*       DRV_ERROR: error
*       others: others programmer defined error code. for detailed information, please contact with the programmer
* Others:
*       others error code should be a negative number, and not equal to the value that already be defined in T_ZDrv_ErrCode in drv_pub.h.
*******************************************************************************/
SINT32 halSensor_SetSaturation(T_ZDrv_SensorId tSensorId, T_ZDrv_CamSaturation tSat);

/*******************************************************************************
 * Function: halSensor_SetAntiFlicker
 * Description: This function is used to anti 50/60HZ banding flicker 
 * Parameters:
 *   Input:tSat:the banding frequency  mode
 *   Output:None
 *
 * Returns:
 *          DRV_SUCCESS: successfully set the sensor.
 *          DRV_ERR_NOT_SUPPORTED: unsupported type of setting.
 *          DRV_ERROR: fail to set the sensor.
 *
 * Others:
 ********************************************************************************/
SINT32 halSensor_SetAntiFlicker(T_ZDrv_SensorId tSensorId, T_ZDrv_AntiFlicker tAntiFlicker);

/*******************************************************************************
 * Function: halSensor_SetEV
 * Description: This function is used to set the exposure compensation
 * Parameters:
 *   Input:tSat:the level of EV
 *   Output:None
 *
 * Returns:
 *          DRV_SUCCESS: successfully set the sensor.
 *          DRV_ERR_NOT_SUPPORTED: unsupported type of setting.
 *          DRV_ERROR: fail to set the sensor.
 *
 * Others:
 ********************************************************************************/
SINT32 halSensor_SetEV(T_ZDrv_SensorId tSensorId,T_ZDrv_CamExpCom tEV);
/*******************************************************************************
 * Function: halSensor_GetOneFrame
 * Description: This function is used to get one frame
 * Parameters:
 *   Input:tSat:T_ZDrv_SensorId T_HalCam_Buff_Addr*
 *   Output:None
 *
 * Returns:
 *          DRV_SUCCESS: successfully set the sensor.
 *          DRV_ERR_NOT_SUPPORTED: unsupported type of setting.
 *          DRV_ERROR: fail to set the sensor.
 *
 * Others:
 ********************************************************************************/
#if defined(_USE_SPICC)
SINT32 halSensor_GetOneFrame(T_ZDrv_SensorId tSensorId,T_HalCam_Buff_Addr* ptBuff);
#endif

#if defined(_USE_RAW_BUFFER)
SINT32 halSensor_GetOneFrame(T_ZDrv_SensorId tSensorId,T_HalCam_Buff_Addr ptBuff);
#endif

/*******************************************************************************
 * Function: halSensor_FreeBuff
 * Description: This function is used to free one frame
 * Parameters:
 *   Input:tSat:T_Halsensor_Buff_Addr
 *   Output:None
 *
 * Returns:
 *          DRV_SUCCESS: successfully set the sensor.
 *          DRV_ERR_NOT_SUPPORTED: unsupported type of setting.
 *          DRV_ERROR: fail to set the sensor.
 *
 * Others:
 ********************************************************************************/
#if defined(_USE_SPICC)
SINT32 halSensor_FreeBuff(T_ZDrv_SensorId tSensorId,T_HalCam_Buff_Addr readingBuff);
#endif
/*******************************************************************************
* Functin: zDrvSensor_SetOperations
* Description: This function is used to register operations of hal layer.
* Parameters:
*       (IN)
*               tSensorId: operations of which sensor.
*               ptOperations: operations for the specfied device.
*       (OUT)
*               None.
* Returns:
*      None
* Others:
*       None.
*******************************************************************************/
VOID zDrvSensor_SetOperations( T_ZDrv_SensorId tSensorId, T_HalSensor_OperationsPtr ptOperations );



#endif/*_DRVS_SENSOR_REF_H*/


