/***********************************************************************
* Copyright (C) 2007, ZTE Corporation.
* 
* File Name: 	dd_earpiece.c
* File Mark:  	
* Description:  This file contains the core routines for earpiece driver.
* Others:  	
* Version:  	v0.5
* Author:  	LvWenhua
* Date:  	      2007-12-01
* 
* History 1:  		
*     Date: 
*     Version:
*     Author: 
*     Modification:  
* History 2: 
**********************************************************************/

/**************************************************************************
 *                                             Include files                                                    *
 **************************************************************************/
#include "drvs_general.h"
#include "earpiece_api.h"
#include "hal_earpiece.h"

/****************************************************************************
* 	                                Local Type Definitions                                                *
****************************************************************************/
typedef enum
{
    DD_CLOSED = 0,
    DD_OPENED    ,

    MAX_DD_OPEN_STATUS      
}T_Dd_OpenStatus;
/****************************************************************************
* 	                                Local Function Prototypes                                           *
****************************************************************************/
static SINT32 ddEarp_Open(VOID *private,T_ZDRVIO_FLAGS flags);
static SINT32 ddEarp_Close(VOID *private);
static SINT32 ddEarp_Ioctl (VOID *private, T_DRVIO_CTRL_KEY cmd, VOID *param);
/****************************************************************************
* 	                                Global Constants                                                      *
****************************************************************************/

/****************************************************************************
* 	                                 Global Variables                                                      *
****************************************************************************/
static T_Dd_OpenStatus gDdEarp_OpenFlag = DD_CLOSED;
static T_HalEarp_Block gDdEarp_Block = 
                                    {
                                        MAX_EARP_INFO,
                                        NULL
                                    };

ZOSS_THREAD_ID gDdEarp_DealInfoThread = ZOSS_INVALID_THREAD_ID;
ZOSS_SEMAPHORE_ID gDdEarp_DealInfoSema = ZOSS_NULL;

/****************************************************************************
* 	                                         Function Definitions                                           *
****************************************************************************/

/**************************************************************************
* Function: ddEarp_DealInfoThread
* Description: This function is the entry of "earp_deal_inform_thead" thead.
* Parameters: 
*   Input:
*       param: No use.
*   Output:None
* Returns: None
* Others: None
**************************************************************************/
VOID ddEarp_DealInfoThread(SINT32 param)
{

    while(1) 
    {
        zOss_GetSemaphore(gDdEarp_DealInfoSema, ZOSS_WAIT_FOREVER);
        
        if(gDdEarp_Block.callback != NULL)
        {
            gDdEarp_Block.callback(gDdEarp_Block.inform);
        }
    }
}

/**************************************************************************
* Function: zDrvEarp_Init
* Description: This function is used to install earpiece driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*	DRV_SUCCESS:success to install device
*	DRV_ERROR:fail to install device
* Others: None
**************************************************************************/
T_ZDrvIODev_Handle g_earIODevHandle = NULL;

static T_ZDrvIODev_Ops s_earIODevOps =
{
    .open   = ddEarp_Open,
    .close  = ddEarp_Close,
    .read   = NULL,
    .write  = NULL,
    .ctrl   = ddEarp_Ioctl,
};

SINT32 zDrvEarp_Init(VOID)
{
    SINT32 ret=0;
    gDdEarp_DealInfoSema = zOss_CreateSemaphore("earp_deal_inform_sema", 0);
    gDdEarp_DealInfoThread = zOss_CreateThread("earp_deal_inform_thead", ddEarp_DealInfoThread, 0, 4*1024, 10, 1, 1);

    //ret=zDrv_DevInstall(ZDRV_DEV_EARP, &earp_entry);
    g_earIODevHandle = zDrvIODev_Connect(ZDRV_DEV_EARP, NULL, &s_earIODevOps);
    if(ret<0)
        return ret;
    else
        return DRV_SUCCESS;
}

/**************************************************************************
* Function: zDrvEarp_Exit
* Description: This function is used to uninstall earpiece driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*	DRV_SUCCESS:success to uninstall device
*	DRV_ERROR:fail to uninstall device
* Others: None
**************************************************************************/
SINT32 zDrvEarp_Exit(VOID)
{
    SINT32 ret=0;
    ret = zOss_DeleteSemaphore(gDdEarp_DealInfoSema);
    if(ret!=0)
        return ret;
    ret = zOss_DeleteThread(gDdEarp_DealInfoThread);
    if(ret!=0)
        return ret;
    gDdEarp_DealInfoSema = ZOSS_NULL;
    gDdEarp_DealInfoThread = ZOSS_INVALID_THREAD_ID;

    //ret=zDrv_DevUnInstall(ZDRV_DEV_EARP);
    zDrvIODev_Disconnect(g_earIODevHandle);
    if(ret<0)
        return ret;
    else
        return DRV_SUCCESS;
}

/**************************************************************************
* Function: ddEarp_Open
* Description: This function is used to open earpiece device.
* Parameters: 
*   Input:
*          private:device private data
*	     flags: no use
*   Output: None
* Returns:   
*	     DRV_SUCCESS:success to open device
*	     DRV_ERR_OPEN_TIMES: the device has been opened.
*	     DRV_ERROR:fail to open device
* Others: None
**************************************************************************/
static SINT32 ddEarp_Open(VOID *private,T_ZDRVIO_FLAGS flags)
{
    SINT32 ret = 0;

    if (gDdEarp_OpenFlag == DD_OPENED)
    {
        return DRV_ERR_OPEN_TIMES;
    }
    
    /*-------------- initialize CODEC ----------------*/
    ret = halEarp_Open();
    if (ret < 0)
    {
    	return ret;
    }
    gDdEarp_OpenFlag = DD_OPENED;
	
    return DRV_SUCCESS;
}

/**************************************************************************
* Function: ddEarp_Close
* Description: This function is used to close earpiece device.
* Parameters: 
*   Input:
*      private:device private data
*   Output:None
* Returns: 
*	DRV_SUCCESS:success to close device
*	DRV_ERR_NOT_OPENED:device is not openned before
*	DRV_ERROR:fail to close device
* Others: None
**************************************************************************/
static SINT32 ddEarp_Close(VOID *private)
{
    SINT32 ret = 0;

    if (gDdEarp_OpenFlag != DD_OPENED)
    {
        return DRV_ERR_NOT_OPENED;
    }
    
    /*-------------- exit CODEC ----------------*/
    ret = halEarp_Close();
    if ( ret < 0 )
    {
    	return ret;
    }
	
    gDdEarp_OpenFlag = DD_CLOSED;
    return DRV_SUCCESS;
}

/**************************************************************************
* Function: zDrv_Ioctl
* Description:  This function is used to control earpiece device.
* Parameters: 
*   Input:
*           private:device private data
*           cmd:command code
*           param:command parameters
*   Output:None
* Returns: 
*     DRV_SUCCESS: operate successfully.
*	DRV_ERR_INVALID_IOCTL_CMD: command error.
*	DRV_ERR_INVALID_PARAM: parameter error.
*     DRV_ERROR:other fail.

* Others: 	cmd-param
                      1. CMD:IOCTL_EARP_SET_CALLBACK
                          param: T_ZDrvEarp_CallbackFunc
                      2. CMD:IOCTL_EARP_GET_PLUG_STATUS
                          param: T_ZDrvEarp_State*
**************************************************************************/
static SINT32 ddEarp_Ioctl (VOID *private, T_DRVIO_CTRL_KEY cmd, VOID *param)
{
    SINT32 ret = 0;
    
    if (gDdEarp_OpenFlag != DD_OPENED)
    {
        return DRV_ERR_NOT_OPENED;
    }
    
    switch(cmd)   
    {
        case  IOCTL_EARP_SET_CALLBACK:
        {
            if(NULL == param)
            {
                return DRV_ERR_INVALID_PARAM;
            }
            gDdEarp_Block.callback = (T_ZDrvEarp_CallbackFunc)param;
            ret = halEarp_SetCallbackFunc((T_ZDrvEarp_CallbackFunc)param);
            break;
        }
            
        case  IOCTL_EARP_GET_PLUG_STATUS:			
        {
            if(NULL == param)
            {
                return DRV_ERR_INVALID_PARAM;
            }
            ret = halEarp_GetPlugStatus((T_ZDrvEarp_State*)param);
            break;
        }
            
        case  IOCTL_EARP_SET_HOOK_ENABLE:
        {
            ret = halEarp_SetHookEnable();
            break;
        }
        case  IOCTL_EARP_SET_HOOK_DISABLE:
        {
            ret = halEarp_SetHookDisable();
            break;
        }        
        default:
            return DRV_ERR_INVALID_IOCTL_CMD;
    }

    if(ret < 0)
        return ret;
    
    return DRV_SUCCESS;
}

/**************************************************************************
* Function: ddEarp_Isr
* Description: This function is used to handle earpiece interrupt.
* Parameters: 
*   Input:
*      info:interupt info
*   Output:None
* Returns: None
* Others: None
**************************************************************************/

/*Temp function for arena. [LvWenhua-2007-12-03]*/
VOID ddEarp_Isr(VOID)
{
/*    T_ZDrvEarp_Info temp = *(T_ZDrvEarp_Info*)info;

    if ( EARP_INFO_PLUG == temp )
        gDdEarp_Block.inform = EARP_INFO_PLUG;
    else if ( EARP_INFO_UNPLUG == temp )
        gDdEarp_Block.inform = EARP_INFO_UNPLUG;
    else if ( EARP_INFO_HOOK_SWITCH == temp )
        gDdEarp_Block.inform = EARP_INFO_HOOK_SWITCH;
    else 
    {
        return;
    }*/

    zOss_PutSemaphore(gDdEarp_DealInfoSema);
}
