/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  Headerfile for the I2S interface
 *
 * Modified ........ 
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_i2s.h
 *   Version: \main\24
 *   Date: 2007-10-02 09:06:03
 *   Comment:
 *     merged steon changes
 */

#ifndef _I2S_H
#define _I2S_H

// Defines for PINS

#define AUD_PAD_I2S1_RX     (*PCL_pad(PAD_I2S1_RX)) 
#define AUD_PAD_I2S1_TX     (*PCL_pad(PAD_I2S1_TX)) 
#define AUD_PAD_I2S1_CLK0   (*PCL_pad(PAD_I2S1_CLK0)) 
#define AUD_PAD_I2S1_CLK1   (*PCL_pad(PAD_I2S1_CLK1)) 
#define AUD_PAD_I2S1_WA0    (*PCL_pad(PAD_I2S1_WA0)) 
#define AUD_PAD_I2S1_WA1    (*PCL_pad(PAD_I2S1_WA1)) 
#define AUD_PAD_I2S2_RX     (*PCL_pad(PAD_I2S2_RX)) 
#define AUD_PAD_I2S2_TX     (*PCL_pad(PAD_I2S2_TX)) 
#define AUD_PAD_I2S2_CLK0   (*PCL_pad(PAD_I2S2_CLK0)) 
#define AUD_PAD_I2S2_CLK1   (*PCL_pad(PAD_I2S2_CLK1)) 
#define AUD_PAD_I2S2_WA0    (*PCL_pad(PAD_I2S2_WA0)) 
#define AUD_PAD_I2S2_WA1    (*PCL_pad(PAD_I2S2_WA1))

//Defines for settings

#define AUD_I2S_Switch_Interface_off 0
#define AUD_I2S_Switch_MMS_mode      1
#define AUD_I2S_Switch_MMS_FB_mode  2
#define AUD_I2S_Switch_external_mode 3
#define AUD_I2S_Switch_DAI_mode      4


#define AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_0_MASTER 0
#define AUD_I2S_CSEL_TXCLKSEL_FROM_CLK0_WA0_SLAVE 2
#define AUD_I2S_CSEL_TXCLKSEL_FROM_CLK1_WA1_SLAVE 1
#define AUD_I2S_CSEL_TXCLKSEL_FROM_Fractional_devider_1_MASTER 3
#define AUD_I2S_CSEL_TXCLKSEL_Bitmask 0xFFFC

#define AUD_I2S_CSEL_CLK0SEL_Fractional_devider_0 0
#define AUD_I2S_CSEL_CLK0SEL_Fractional_devider_1 1<<2
#define AUD_I2S_CSEL_CLK0SEL_external 2<<2
#define AUD_I2S_CSEL_CLK0SEL_Bitmask 0xFFF3

#define AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_1_MASTER 0
#define AUD_I2S_CSEL_RXCLKSEL_FROM_CLK0_WA0_SLAVE 1<<4
#define AUD_I2S_CSEL_RXCLKSEL_FROM_CLK1_WA1_SLAVE 2<<4
#define AUD_I2S_CSEL_RXCLKSEL_FROM_Fractional_devider_0_MASTER 3<<4
#define AUD_I2S_CSEL_RXCLKSEL_Bitmask 0xFFCF

#define AUD_I2S_CSEL_CLK1SEL_Fractional_devider_0 0
#define AUD_I2S_CSEL_CLK1SEL_Fractional_devider_1 1<<6
#define AUD_I2S_CSEL_CLK1SEL_external 2<<6
#define AUD_I2S_CSEL_CLK1SEL_Bitmask 0xFF3F

#define AUD_I2S_CONF_WIDTH_16 0
#define AUD_I2S_CONF_WIDTH_18 4<<5
#define AUD_I2S_CONF_WIDTH_20 5<<5
#define AUD_I2S_CONF_WIDTH_24 6<<5
#define AUD_I2S_CONF_WIDTH_32 7<<5


#define AUD_I2S_CONF_EDGE_FALLING         0
#define AUD_I2S_CONF_EDGE_RISING          1
#define AUD_I2S_CONF_EDGE_Bitmask         1
#define AUD_I2S_CONF_DEL_NO_DELAY         0
#define AUD_I2S_CONF_DEL_1_bit_DELAY      1<<1
#define AUD_I2S_CONF_POL_WA_HIGH_IS_RIGHT 0
#define AUD_I2S_CONF_POL_WA_HIGH_IS_LEFT  1<<2
#define AUD_I2S_CONF_PERIOD_64            0
#define AUD_I2S_CONF_PERIOD_48            1<<3
#define AUD_I2S_CONF_PERIOD_32            2<<3
#define AUD_I2S_CONF_WIDTH_16             0
#define AUD_I2S_CONF_WIDTH_18             4<<5
#define AUD_I2S_CONF_WIDTH_20             5<<5
#define AUD_I2S_CONF_WIDTH_24             6<<5
#define AUD_I2S_CONF_WIDTH_32             7<<5
#define AUD_I2S_CONF_ALIGN_LEFT           0
#define AUD_I2S_CONF_ALIGN_RIGHT          1<<8



#define AUD_I2S_CONF_RX_CLK1_OUT_IS_LOW   0
#define AUD_I2S_CONF_RX_CLK1_OUT_IS_HIGH  1<<13
#define AUD_I2S_CONF_RX_CLK1_CONT_STOPS   0
#define AUD_I2S_CONF_RX_CLK1_CONT_RUNNING 1<<14
#define AUD_I2S_CONF_RX_WA1_LEN_1_CYCLE   0
#define AUD_I2S_CONF_RX_WA1_LEN_2_CYCLE   1<<15
#define AUD_I2S_CONF_RX_WAx_LEN_Bitmask   1<<15


#define AUD_I2S_CONF_TX_MUTE_L_ACTIVE     0  
#define AUD_I2S_CONF_TX_MUTE_L_MUTED      1<<11
#define AUD_I2S_CONF_TX_MUTE_R_ACTIVE     0  
#define AUD_I2S_CONF_TX_MUTE_R_MUTED      1<<12
#define AUD_I2S_CONF_TX_CLK0_OUT_IS_LOW   0
#define AUD_I2S_CONF_TX_CLK0_OUT_IS_HIGH  1<<13
#define AUD_I2S_CONF_TX_CLK0_CONT_STOPS   0
#define AUD_I2S_CONF_TX_CLK0_CONT_RUNNING 1<<14
#define AUD_I2S_CONF_TX_WA0_LEN_1_CYCLE   0
#define AUD_I2S_CONF_TX_WA0_LEN_2_CYCLE   1<<15

#define AUD_I2S_NUM_FREF_MODULE_CLOCK     0
#define AUD_I2S_NUM_FREF_104MHz           1<<12

#define AUD_I2S_TRANSFER_MODE_STEREO    0<<9
#define AUD_I2S_TRANSFER_MODE_RIGHT         2<<9
#define AUD_I2S_TRANSFER_MODE_LEFT       3<<9

#define AUD_I2S_HW_MODE_BURST          0
#define AUD_I2S_HW_MODE_NORMAL       1

#define AUD_I2S_CHANNEL_MODE_MONO             0  // Mono
#define AUD_I2S_CHANNEL_MODE_DUALMONOL   1 //  left channel is taken from I2S1 interface and copied to both L & R
#define AUD_I2S_CHANNEL_MODE_DUALMONOR   2 //  Right channel is taken from I2S1 interface and copied to both L & R

//PIN definitions are made in aud_data.c to make them project dependent
extern const S32 AUD_PAD_I2S2_RX_OFF;
extern const S32 AUD_PAD_I2S2_TX_OFF;
extern const S32 AUD_PAD_I2S2_CLK0_OFF;
extern const S32 AUD_PAD_I2S2_CLK1_OFF;
extern const S32 AUD_PAD_I2S2_WA0_OFF;
extern const S32 AUD_PAD_I2S2_WA1_OFF;

extern const S32 AUD_PAD_I2S1_CLK0_OFF;
extern const S32 AUD_PAD_I2S1_RX_OFF;
extern const S32 AUD_PAD_I2S1_TX_OFF;
extern const S32 AUD_PAD_I2S1_WA0_OFF;
extern const S32 AUD_PAD_I2S1_CLK1_OFF;
extern const S32 AUD_PAD_I2S1_WA1_OFF;

typedef UINT32 aud_I2S_clk_handle_type;


typedef struct{
BOOL I2S2_Rx_enabled;
BOOL I2S2_Tx_enabled;
aud_I2S_clk_enum I2S2_Rx_clk;
aud_I2S_clk_enum I2S2_Tx_clk;
BOOL clk0_enabled;
BOOL clk1_enabled;
}aud_I2S_status_type;

typedef enum{
aud_I2S_E_setup_clk,
aud_I2S_E_enable_clk,
aud_I2S_E_disable_clk
}aud_I2S_E_setup_enum;

typedef enum{
  S_I2S_Clk_UnConfigured,
  S_I2S_Clk_Configured,
  S_I2S_Clk_active 
}aud_I2S_Clk_state_enum;

typedef enum{
  aud_I2S_ok,
  aud_I2S_clock_enum_out_of_range,
  aud_I2S_Master_Slave_enum_out_of_range,
  aud_I2S_samplerate_enum_out_of_range,
  aud_I2S_sample_width_enum_out_of_range,
  aud_I2S_transmission_mode_enum_out_of_range,
  aud_I2S_settings_enum_out_of_range,
  aud_I2S_mode_enum_out_of_range,
  aud_I2S_entry_point_enum_out_of_range,
  aud_I2S_setting_not_avaliable,
  aud_I2S_validation_matrix_error,
  aud_I2S_clk_activ_reconfig_not_possible,
  aud_I2S_SM_activ_reconfig_not_possible,
  aud_I2S_SM_in_idle_disabling_not_possible,
  aud_I2S_chosen_clk_not_configured,
  aud_I2S_resource_not_configured,
  aud_I2S_clock_config_returned_false,
  aud_I2S_update_VB_I2S2_returned_false,
  aud_I2S_PIN_config_not_possible,
  aud_I2S_conflict_between_entry_point_and_Tx_resource,
  aud_I2S_can_not_calculate_num_and_den,
  aud_I2S_errors_end
}aud_i2s_errors_enum;

typedef enum {
  aud_I2S_periode_64,
  aud_I2S_periode_48,
  aud_I2S_periode_32,
  aud_I2S_periode_18, /*Used for PCM mode*/
  aud_I2S_periode_17, /*Used for PCM mode*/
  aud_I2S_periode_end
}aud_I2S_periode_enum;

typedef struct{
  aud_I2S_Master_Slave_enum Master_Slave;
  aud_I2S_samplerate_enum samplerate;
  aud_I2S_sample_width_enum sample_width;
  aud_I2S_transmission_mode_emum transmission_mode;
  aud_I2S_setting_enum settings;
  aud_I2S_mode_enum I2S_mode;
  aud_I2S_periode_enum period;
  UINT16 backup_period;
  UINT16 backup_width;
  UINT16 backup_I2S_mode;
  UINT16 backup_rate;
}aud_I2S_clk_settings_type;

typedef struct{
aud_I2S_clk_enum clock;
aud_I2S_entry_point_enum entry_point;
aud_I2S_clk_handle_type handle;
}aud_I2S_resource_settings_type;

typedef struct {
UINT32 width;
UINT32 period;
UINT32 rate;
UINT32 mode;
aud_I2S_setting_enum settings;
aud_i2s_errors_enum error;
aud_I2S_clk_handle_type handle;
aud_resource_enum resource;
aud_I2S_entry_point_enum entry_point;
}aud_I2S_settings_type;

typedef struct{
UINT16 num;
UINT16 den;
}aud_i2s_num_den_type;

typedef enum {
aud_I2S1_Rx_pin,
aud_I2S1_Tx_pin,
aud_I2S1_Clk0_pin,
aud_I2S1_Clk1_pin,
aud_I2S1_Wa0_pin,
aud_I2S1_Wa1_pin,
aud_I2S2_Rx_pin,
aud_I2S2_Tx_pin,
aud_I2S2_Clk0_pin,
aud_I2S2_Clk1_pin,
aud_I2S2_Wa0_pin,
aud_I2S2_Wa1_pin
}aud_I2S_PIN_enum;


typedef enum {
aud_I2S_PIN_input,
aud_I2S_PIN_output,
aud_I2S_PIN_off
}aud_I2S_PIN_config_enum;

typedef enum{
  aud_I2S_get_info_I2S1_mode_pointer,
  aud_I2S_get_info_dai_mode
}aud_I2S_get_info_enum;

typedef struct{
  BOOL avaliable;
  UINT32 RXCONF; /*Width and Period will be or on later*/
  UINT32 TXCONF; /*Width and Period will be or on later*/ 
  UINT32 FREF_clk0;
  UINT32 FREF_clk1;
}aud_I2S2_default_settings_type;

typedef struct {
    UINT16 mode_pointer;
} aud_glob_I2S1_type;



/*Extern defined variables*/
extern const aud_I2S2_default_settings_type aud_I2S2_default_settings[aud_I2S_setting_end];

/*I2S functions*/
extern void Aud_I2S_init(void);
extern BOOL AudI2S1SM(aud_event_enum event, void* pData);
extern BOOL Aud_I2S_dispatcher (aud_event_enum event, void* pData);
extern UINT32 AUD_test_i2s_generic_func(void *func_req_ptr,BOOL * processed);
extern UINT32 Aud_I2S_get_info(aud_I2S_get_info_enum variable);
extern BOOL AudI2S1SM(aud_event_enum event, void* pData);
extern BOOL AudAFEI2SSM(aud_event_enum event, void* pData);
extern void DspSetVoiceBandPath(UINT16 mode) ;
extern void aud_dai_mode(aud_dai_mode_enum dai_mode);
extern void AudI2S2InterruptHandle(void);

#endif /* _I2S_H */
