/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:request_queue.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _REQUEST_QUEUE_H
#define _REQUEST_QUEUE_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_general.h"
#include "ring_queue.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef enum _T_QUEUE_STATE{
	QUEUE_IDLE,
	QUEUE_SUBMITING,
	QUEUE_SUSPEND,
	QUEUE_WORKING,
}T_QUEUE_STATE;


typedef struct _T_Request_Queue T_Request_Queue;
typedef struct _T_Request T_Request;

typedef SINT32 (*queue_notify)(T_Request_Queue *);


/*
 * request state
 */
typedef struct _T_Request_Queue {
	T_Ring_Queue *queue;
	
	T_QUEUE_STATE work_state;
	T_QUEUE_STATE process_state;
	
	queue_notify notify_fn;
	VOID *queue_data;
}T_Request_Queue;

/*
 * request
 */
typedef struct _T_Request {	
	VOID  *data;
}T_Request;



/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
T_Request_Queue *requestQueue_Create(unsigned long req_count, unsigned long req_size, queue_notify notify_fn, VOID* queue_data);

SINT32 requestQueue_SubmitRequest(T_Request_Queue *q, T_Request *req);

SINT32 requestQueue_FetchRequest(T_Request_Queue *q, T_Request *req);

SINT32 requestQueue_Suspend(T_Request_Queue *q);

SINT32 requestQueue_Resume(T_Request_Queue *q);

VOID requestQueue_Destroy(T_Request_Queue *q);

#endif/*_REQUEST_QUEUE_H*/

