/**
 * 
 * @file      zcat_sig.h
 * @brief     
 *            This file is part of ZCAT.
 *            ZCATPS׼SIG
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2012/12/27  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef ZCAT_SIG_H
#define ZCAT_SIG_H

#include "StdLogMsgID.h"

#ifdef __cplusplus
extern "C"
{
#endif

// ڻȡmask bit
#define GET_SIG_MASK_BIT(sig_id) (0x01 << ((sig_id) & 7))

// Sig Maskֽ
#define SIG_MASK_BYTE_NUM        ((LOG_TOOL_LAST + 7) / 8)

/************************************************************************/
/*                                                              */
/************************************************************************/
typedef struct
{
    UINT16 sig_id;
    UINT8  psType;
    UINT8  padding;
    UINT32 gsmSFN;
    UINT32 tdSFN;
    UINT32 lteSFN;
    UINT32 wcdmaSFN;
    UINT16 len;
    UINT16 reserved;
} T_ZCAT_SIG_HEADER;

typedef enum
{
    SIG_START_RESORCCO = 1,
    SIG_STOP_RESORCCO
} T_ZCAT_SIG_CONTROL_MSG_TYPE;

typedef struct
{
    UINT8  operation;
    UINT8  reserved;
    UINT16 len;
} T_ZCAT_SIG_CONTROL_MSG;

typedef struct {
	BYTE     bEUMacDlBlc;
	BYTE     bEUMacUlBlc;
	BYTE     bEUMacStatic;

	BYTE     bEURlcDlAMAllPdu;
	BYTE     bEURlcDlAMCtrlPdu;
	BYTE     bEURlcDlAMPollPdu;
	BYTE     bEURlcDlAMSignalPdu;
	BYTE     bEURlcDlUMPdu;
	BYTE     bEURlcDlStatic;

	BYTE     bEURlcUlAMAllPdu;
	BYTE     bEURlcUlAMCtrlPdu;
	BYTE     bEURlcUlAMPollPdu;
	BYTE     bEURlcUlAMSignalPdu;
	BYTE     bEURlcUlUMPdu;
	BYTE     bEURlcUlStatic;

	BYTE     bEPdcpDlPdu;
	BYTE     bEPdcpUlPdu;
	BYTE     bEPdcpDlCipherPdu;
	BYTE     bEPdcpUlCipherPdu;
	BYTE     bEPdcpDlCtrlPdu;
	BYTE     bEPdcpUlCtrlPdu;
	BYTE     bEPdcpDlSrbIntegrityPdu;
	BYTE     bEPdcpUlSrbIntegrityPdu;
	BYTE     bEPDCPDlStatic;
	BYTE     bEPDCPUlStatic;

	BYTE     abPadding[3];

} T_ZCAT_zEUL2_LogMask_Ind;
/************************************************************************/
/*                              ӿԭ                                */
/************************************************************************/
typedef struct
{
	UINT32 header;
	UINT16 type;
	UINT16 len;
//Ƚ⣬ݳҪ4MsgID
	UINT32 MsgID;
}THHeader;

#ifdef __cplusplus
}
#endif

#endif // ZCAT_SIG_H

