
define("firewall_url_filter","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    //system url filter setting VM
     
    function UrlFilterSettingVM() {
        var target = this;
        var urlFltInfo = service.getUrlFilterList();
        var columnsTmpl = [{
                columnType: "checkbox",
                rowText: "index",
                width: "30%"
            }, {
                headerTextTrans: "url",
                rowText: "url",
                width: "70%"
            }
        ];
        target.rules = ko.observableArray(urlFltInfo.urlFilterRules);

        target.gridTemplate = new ko.simpleGrid.viewModel({
            data: target.rules(),
            idName: "index",
            columns: columnsTmpl,
            tmplType: 'list',
            pageSize: 10
        });

        target.clear = clearFunc;
		
        target.callback = callbackFunc;
		//删除规则
         
        target.deleteRule = deleteRuleFunc;
		
        //添加规则
         
        target.addRule = addRuleFunc;
		function callbackFunc(elem) {
            if (elem.result != "success") {
                errorOverlay();                
            } else {
				target.clear();
                initialize(target);
                successOverlay();
                $("#urlFilters").translate();
            }
		}
		
		//添加规则
		function addRuleFunc() {
            if (target.rules().length >= config.urlFilterMax) {
                showAlert({
                    msg: "url_filter_max",
                    params: config.urlFilterMax
                });
                return false;
            }
            var tmpArr = [];
            for (var idx = 0; idx < target.rules().length; idx++) {
                tmpArr.push(target.rules()[idx].url);
            }
            if ($.inArray($("#addURLFilter").val(), tmpArr) != -1) {
                showAlert("url_repeated");
                return false;
            }

            showLoading();
            var urlFltParams = {
                goformId: "URL_FILTER_ADD",
                addURLFilter: $("#addURLFilter").val()
            };
            service.addUrlFilterRule(urlFltParams, target.callback);
        }
		//删除规则
		function deleteRuleFunc() {
            showConfirm('confirm_data_delete', function () {
                showLoading();
                var urlFltParams = {
                    goformId: "URL_FILTER_DELETE",
                    url_filter_delete_id: target.gridTemplate.selectedIds().join(";") + ";"
                };
                service.deleteSelectedRules(urlFltParams, target.callback);
            });
        }
		
    }
	
		function clearFunc() {
            $("#addURLFilter").val("");
        }
		
    //页面初始化
     
    function initialize() {
       
        var vm = new UrlFilterSettingVM();
		bindContainer(vm);
    }
	function bindContainer(vm){
		var container = $('#container');
        ko.cleanNode(container[0]);
		ko.applyBindings(vm, container[0]);
        $('#urlFilterForm').validate({
            submitHandler: function () {
                vm.addRule();
            },
            rules: {
                addURLFilter: 'url_filter_check'
            }
        });

        $("#urlFilterListForm").validate({
            submitHandler: function () {
                vm.deleteRule();
            }
        });
	}

    return {
        init: initialize
    };
});

define("firewall_upnp_set","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    //system upnp setting VM
     
    function UpnpSettingVM() {
        var target = this;
        var upnpInfo = getUpnpSetting();

        target.upnpSetting = ko.observable(upnpInfo.upnpSetting);

        target.save = saveFunc;
		function saveFunc() {
            showLoading();
            var upnpParams = {};
            upnpParams.upnpSetting = target.upnpSetting();
            service.setUpnpSetting(upnpParams, function (rlt) {
                if (rlt.result == "success") {
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });

        }
    }
	
		
    //获取upnp 信息
     
    function getUpnpSetting() {
        return service.getUpnpSetting();
    }

    //初始化UpnpSettingVM model
     
    function initialize() {
        
        var vm = new UpnpSettingVM();
		bindContainer(vm);
        
    }
	function bindContainer(vm) {
		var container = $('#container');
        ko.cleanNode(container[0]);
		ko.applyBindings(vm, container[0]);
        $('#upnpSettingForm').validate({
            submitHandler: function () {
                vm.save();
            }
        });
	}

    return {
        init: initialize
    };
});

//端口映射
 
define("firewall_port_map","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var protocolModes = _.map(config.MAP_PROTOCOL_MODES, function (ele) {
        return new Option(ele.name, ele.value);
    });

    var columnsTmpl = [{
            columnType: "checkbox",
            rowText: "index",
            width: "8%"
        }, {
            headerTextTrans: "source_port",
            rowText: "sourcePort",
            width: "20%"
        }, {
            headerTextTrans: "dest_ip_address",
            rowText: "destIpAddress",
            width: "20%"
        }, {
            headerTextTrans: "dest_port",
            rowText: "destPort",
            width: "20%"
        }, {
            headerTextTrans: "protocol",
            rowText: "protocol",
            width: "12%"
        }, {
            headerTextTrans: "comment",
            rowText: "comment",
            width: "20%"
        }
    ];

    //prot_map VM
     
    function PortMapVM() {
        var target = this;
        var mapInfo = getPortMap();

        target.oriPortMapEnable = ko.observable(mapInfo.portMapEnable);
        target.rules = ko.observableArray(mapInfo.portMapRules);
        target.portMapEnable = ko.observable(mapInfo.portMapEnable);

		
        target.comment = ko.observable('');
        target.selectedMode = ko.observable('TCP&UDP');
        target.modes = ko.observableArray(protocolModes);
		
        target.destPort = ko.observable('');
        target.destIpAddress = ko.observable('');
        target.sourcePort = ko.observable('');



        target.gridTemplate = new ko.simpleGrid.viewModel({
            data: target.rules(),
            idName: "index",
            columns: columnsTmpl,
            tmplType: 'list',
            pageSize: 10
        });

        //设定,新增,删除回调函数
         
        target.callback = callbackFunc;
		
		//删除规则
         
        target.deleteMapRules = deleteMapRulesFunc;
		
		//检查新增规则是否已经存在
         
        target.checkExist = checkExistFunc;
		
        //设定端口映射
         
        target.enablePortMap = enablePortMapFunc;

        //保存规则
         
        target.save = saveFunc;
		        
		//保存规则
		function saveFunc() {
            if (target.rules().length >= config.portForwardMax) {
                showAlert({
                    msg: "rules_max",
                    params: config.portForwardMax
                });
                return;
            }

            if (target.checkExist()) {
                showAlert("rule_exist");
                return;
            }

            showLoading();
            var mapParams = {};
            mapParams.portMapEnable = target.portMapEnable();
            mapParams.sourcePort = target.sourcePort();
            mapParams.destIpAddress = target.destIpAddress();
            mapParams.destPort = target.destPort();
            mapParams.protocol = target.selectedMode();
            mapParams.comment = target.comment();
            service.setPortMap(mapParams, target.callback);
        }
		
		//检查新增规则是否已经存在
		function checkExistFunc() {
            var newMapRule = {
                sourcePort: target.sourcePort(),
                destIpAddress: target.destIpAddress(),
                destPort: target.destPort(),
                protocol: transProtocolValue(target.selectedMode())
            };

            var oldMapRule;
            var mapRules = target.rules();
            for (var idx = 0; idx < mapRules.length; idx++) {
                oldMapRule = {
                    sourcePort: mapRules[idx].sourcePort,
                    destIpAddress: mapRules[idx].destIpAddress,
                    destPort: mapRules[idx].destPort,
                    protocol: mapRules[idx].protocol
                };

                if (_.isEqual(newMapRule, oldMapRule)) {
                    return true;
                }
            }
            return false;
        }
		
		//设定端口映射
		function enablePortMapFunc() {
            showLoading();
            var mapParams = {};
            mapParams.portMapEnable = target.portMapEnable();
            service.enablePortMap(mapParams, target.callback);
        }
		
		//删除规则
		function deleteMapRulesFunc() {
            var ids = target.gridTemplate.selectedIds();
            if (ids.length == 0) {
                showAlert("no_data_selected");
                return;
            }

            showConfirm("confirm_data_delete", function () {
                showLoading();
                var mapParams = {};
                mapParams.indexs = ids;
                service.deleteMapRules(mapParams, target.callback);
            });
        }
		
		//设定,新增,删除回调函数
		function callbackFunc(ret) {
            if (ret.result == "success") {
                clear();
                initialize(target);
                successOverlay();
            } else {
                errorOverlay();
            }
        }

        //情况添加规则输入
         
        function clear() {
            target.sourcePort('');
            target.destIpAddress('');
            target.destPort('');
            target.selectedMode('TCP&UDP');
            target.comment('');
        }
    }

    //获取port map信息
     
    function getPortMap() {
        return service.getPortMap();
    }

	function bindingContainer(vm){
		var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(vm, container[0]);

	}
    //初始化port map view model
     
    function initialize(viewModel) {
        var vm;
        if (viewModel) {
            vm = viewModel;
            var mapInfo = getPortMap();
            vm.portMapEnable(mapInfo.portMapEnable);
            vm.oriPortMapEnable(mapInfo.portMapEnable);
            vm.rules(mapInfo.portMapRules);
            vm.gridTemplate.clearAllChecked();
            vm.gridTemplate.data(mapInfo.portMapRules);
            refreshTableHeight();
            renderCheckbox();
            return;
        }

        vm = new PortMapVM();
        bindingContainer(vm);
        fixTableHeight();

        $('#mapBasicForm').validate({
            submitHandler: function () {
                vm.enablePortMap();
            }
        });

        $('#portMapListForm').validate({
            submitHandler: function () {
                vm.deleteMapRules();
            }
        });

        $('#portMapForm').validate({
            submitHandler: function () {
                vm.save();
            },
            rules: {
                txtDestIpAddress: {
                    ip_check: true
                },
                txtSourcePort: {
                    digits: true,
                    range_except: [1, 65000]
                },
                txtDestPort: {
                    digits: true,
                    range_except: [1, 65000]
                },
                txtComment: {
                    comment_check: true
                }
            },
            errorPlacement: function (error, element) {
                if (element.attr("name") == "txtDestIpAddress") {
                    error.appendTo("#txtDestIpAddressErrorDiv");
                } else if (element.attr("name") == "txtSourcePort") {
                    error.appendTo("#txtSourcePortErrorDiv");
                } else if (element.attr("name") == "txtDestPort") {
                    error.appendTo("#txtDestPortErrorDiv");
                } else
                    error.insertAfter(element);
            }
        });
    }

    return {
        init: initialize
    };
});

//端口转发
 
define("firewall_port_forward","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var protocolModes = _.map(config.FORWARD_PROTOCOL_MODES, function (ele) {
        return new Option(ele.name, ele.value);
    });
    //列表模板的columns项
     
    var columnsTmpl = [{
            columnType: "checkbox",
            rowText: "index",
            width: "8%"
        }, {
            headerTextTrans: "ip_address",
            rowText: "ipAddress",
            width: "23%"
        }, {
            headerTextTrans: "port_range",
            rowText: "portRange",
            width: "23%"
        }, {
            headerTextTrans: "protocol",
            rowText: "protocol",
            width: "23%"
        }, {
            headerTextTrans: "comment",
            rowText: "comment",
            width: "23%"
        }
    ];

    //prot_forward VM
     
    function PortForwardVM() {
        var target = this;
        var fwdinfo = getPortForward();

        target.portForwardEnable = ko.observable(fwdinfo.portForwardEnable);
        target.oriPortForwardEnable = ko.observable(fwdinfo.portForwardEnable);
		
        target.portEnd = ko.observable('');
        target.portStart = ko.observable('');
        target.ipAddress = ko.observable('');
		
        target.comment = ko.observable('');
        target.selectedMode = ko.observable('3');
        target.modes = ko.observableArray(protocolModes);

        target.rules = ko.observableArray(fwdinfo.portForwardRules);
		
		//设定,新增,删除回调函数
         
        target.callback = callbackFunc;
		
        //创建列表模板
         
        target.gridTemplate = new ko.simpleGrid.viewModel({
            data: target.rules(),
            idName: "index",
            columns: columnsTmpl,
            tmplType: 'list',
            pageSize: 10
        });

        //检查新增规则是否已经存在
         
        target.checkExist = checkExistFunc;
				
		//保存规则
         
        target.save = saveFunc;
		
		//删除规则
         
        target.deleteForwardRules = deleteForwardRulesFunc;
		
        //设定虚拟服务器
         
        target.enableVirtualServer = enableVirtualServerFunc;
		
		//设定虚拟服务器
		function enableVirtualServerFunc() {
            showLoading();
            var fwdParams = {};
            fwdParams.portForwardEnable = target.portForwardEnable();
            service.enableVirtualServer(fwdParams, target.callback);
        }
		
		//删除规则
		function deleteForwardRulesFunc() {
            var ids = target.gridTemplate.selectedIds();
            if (ids.length == 0) {
                showAlert("no_data_selected");
                return;
            }

            showConfirm("confirm_data_delete", function () {
                showLoading('deleting');
                var fwdParams = {};
                fwdParams.indexs = ids;
                service.deleteForwardRules(fwdParams, target.callback);
            });
        }
		
		//保存规则
		function saveFunc() {
            if (target.rules().length >= config.portForwardMax) {
                showAlert({
                    msg: "rules_max",
                    params: config.portForwardMax
                });
                return;
            }

            if (target.checkExist()) {
                showAlert("rule_exist");
                return;
            }

            showLoading();
            var fwdParams = {};
            fwdParams.comment = target.comment();
            fwdParams.protocol = target.selectedMode();
            fwdParams.portEnd = target.portEnd();
            fwdParams.portStart = target.portStart();
            fwdParams.ipAddress = target.ipAddress();
            service.setPortForward(fwdParams, target.callback);
        }
         //情况添加规则输入
        function clear() {
            target.ipAddress('');
            target.portStart('');
            target.portEnd('');
            target.selectedMode('TCP&UDP');
            target.comment('');
        }
		
		//设定,新增,删除回调函数
		function callbackFunc(ret) {
            if (ret.result == "success") {
                clear();
                initialize(target);
                successOverlay();
            } else {
                errorOverlay();
            }
        }

		//检查新增规则是否已经存在
		function checkExistFunc() {
            var newRule = {
                ipAddress: target.ipAddress(),
                portRange: target.portStart() + ' - ' + target.portEnd(),
                protocol: transProtocolValue(target.selectedMode())
            };

            var oldRule;
            var fwdrules = target.rules();
            for (var ki = 0; ki < fwdrules.length; ki++) {
                oldRule = {
                    ipAddress: fwdrules[ki].ipAddress,
                    portRange: fwdrules[ki].portRange,
                    protocol: fwdrules[ki].protocol
                };

                if (_.isEqual(newRule, oldRule)) {
                    return true;
                }
            }
            return false;
        }
    }

    //获取port forward信息
     
    function getPortForward() {
        return service.getPortForward();
    }

    //初始化port forward view model
     
    function initialize(viewModel) {
        var vm;
        if (viewModel) {
            vm = viewModel;
            var fwdinfo = getPortForward();
            vm.gridTemplate.clearAllChecked();
            vm.gridTemplate.data(fwdinfo.portForwardRules);
            vm.rules(fwdinfo.portForwardRules);
            vm.portForwardEnable(fwdinfo.portForwardEnable);
            vm.oriPortForwardEnable(fwdinfo.portForwardEnable);
            refreshTableHeight();
            return;
        }

        vm = new PortForwardVM();
        bindContainer(vm);
		
        fixTableHeight();
        renderCheckbox();

        $('#virtualServerForm').validate({
            submitHandler: function () {
                vm.enableVirtualServer();
            }
        });

        $('#portForwardListForm').validate({
            submitHandler: function () {
                vm.deleteForwardRules();
            }
        });

        $('#portForwardForm').validate({
            submitHandler: function () {
                vm.save();
            },
            rules: {
                txtIpAddress: {
                    ip_check: true
                },
                txtPortStart: {
                    digits: true,
                    range: [1, 65535],
                    portCompare: "#txtPortEnd"
                },
                txtPortEnd: {
                    digits: true,
                    range: [1, 65535],
                    portCompare: "#txtPortStart"
                },
                txtComment: {
                    comment_check: true
                }
            },
            groups: {
                range: "txtPortStart txtPortEnd"
            },
            errorPlacement: function (error, element) {
                if (element.attr("name") == "txtIpAddress") {
                    error.appendTo("#ipErrorDiv");
                } else if (element.attr("name") == "txtPortStart" || element.attr("name") == "txtPortEnd") {
                    error.appendTo("#portRangeErrorDiv");
                } else
                    error.insertAfter(element);
            }
        });
    }
	
	function bindContainer(vm){
		var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(vm, container[0]);

	}
	

    return {
        init: initialize
    };
});

define("firewall_port_filter","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var PROTOCOLS = {
        ICMP: 'ICMP',
        NONE: 'None'
    };

    var columnsTmpl = [{
            columnType: "checkbox",
            rowText: "index",
            width: "4%"
        }, {
            headerTextTrans: "mac_address",
            rowText: "macAddress",
            width: "12%"
        }, {
            headerTextTrans: "ip_type",
            rowText: "ipType",
            width: "5%",
            display: config.IPV6_SUPPORT
        }, {
            headerTextTrans: "source_ip_address",
            rowText: "sourceIpAddress",
            width: "12%"
        }, {
            headerTextTrans: "dest_ip_address",
            rowText: "destIpAddress",
            width: "12%"
        }, {
            headerTextTrans: "protocol",
            rowText: "protocol",
            width: "12%",
            needTrans: true
        }, {
            headerTextTrans: "source_port_range",
            rowText: "sourcePortRange",
            width: "12%"
        }, {
            headerTextTrans: "dest_port_range",
            rowText: "destPortRange",
            width: "12%"
        }, {
            headerTextTrans: "port_filter_action",
            rowText: "action",
            width: "12%",
            needTrans: true
        }, {
            headerTextTrans: "comment",
            rowText: "comment",
            width: "12%"
        }
    ];

    var protocolModes = _.map(config.FILTER_PROTOCOL_MODES, function (elem) {
        return new Option(elem.name, elem.value);
    });
    //prot_filter VM
     
    function PortFilterVM() {
        var target = this;
        var info = getPortFilter();
		
        target.oriDefaultPolicy = ko.observable(info.defaultPolicy);
        target.defaultPolicy = ko.observable(info.defaultPolicy);
        target.oriPortFilterEnable = ko.observable(info.portFilterEnable);
        target.portFilterEnable = ko.observable(info.portFilterEnable);
        target.rules = ko.observableArray(info.portFilterRules);
		
        target.ipv6Support = ko.observable(config.IPV6_SUPPORT);
        target.comment = ko.observable('');
        target.selectedMode = ko.observable('5');
        target.modes = ko.observableArray(protocolModes);
        target.sourcePortEnd = ko.observable('');
        target.sourcePortStart = ko.observable('');
        target.destPortEnd = ko.observable('');
        target.destPortStart = ko.observable('');
        target.destIpv6Address = ko.observable('');
        target.sourceIpv6Address = ko.observable('');
        target.sourceIpAddress = ko.observable('');
        target.destIpAddress = ko.observable('');
        target.macAddress = ko.observable('');
        target.portFilterAction = ko.observable('');

        target.ipType = ko.observable('ipv4');

        //设定,新增,删除回调函数
         
        target.callback = callbackFunc;
		
        //创建列表模板
         
        target.gridTemplate = new ko.simpleGrid.viewModel({
            data: target.rules(),
            idName: "index",
            columns: columnsTmpl,
            tmplType: 'list',
            pageSize: 20
        });
        //default policy change handler
         
        target.policyChangeHandler = policyChangeHandlerFunc;

        //保存规则
         
        target.save = saveFunc;
	
        //设定过滤基本信息
         
        target.setPortFilterBasic = setPortFilterBasicFunc;
		
		//清空添加规则输入
         
        target.clear = clearFunc;

        //检查新增规则是否已经存在
         
        target.checkExist = checkExistFunc;

		//ip类型变化事件监听
         
        target.ipTypeChangeHandler = ipTypeChangeHandlerFunc;
		
        //协议变化事件监听
         
        target.protocolChangeHandler = protocolChangeHandlerFunc;

        //删除规则
         
        target.deleteFilterRules = deleteFilterRulesFunc;

        //init to call
        target.policyChangeHandler();
		
		//设定,新增,删除回调函数
		function callbackFunc(ret) {
            if (ret.result != "success") {
                errorOverlay();
            } else {
                target.clear();
                initialize(target);
                successOverlay();
            }
        }
		//default policy change handler
		function policyChangeHandlerFunc() {
            var action = target.defaultPolicy() != "1" ? "Drop" : "Accept";
            target.portFilterAction(action);
            return true;
        }
		
		//保存规则
		function saveFunc() {
            target.sourceIpAddress(target.sourceIpAddress().replace(/\s+/g, ''));
            target.destIpAddress(target.destIpAddress().replace(/\s+/g, ''));
            target.sourceIpv6Address(target.sourceIpv6Address().replace(/\s+/g, ''));
            target.destIpv6Address(target.destIpv6Address().replace(/\s+/g, ''));
            target.macAddress(target.macAddress().replace(/\s+/g, ''));
            if (target.ipv6Support() == false) {
                if (target.rules().length >= config.portForwardMax) {
                    showAlert({
                        msg: "rules_max",
                        params: config.portForwardMax
                    });
                    return;
                }

                if (target.checkExist()) {
                    showAlert("rule_exist");
                    return;
                }

            } else {
				var type = target.ipType() == "ipv4" ? "IPv4" : "IPv6";
                var oldRules = _.filter(target.rules(), function (item) {
                    return item.ipType == type;
                });

                if (oldRules.length >= config.portForwardMax) {
                    showAlert({
                        msg: "rules_max_v4v6",
                        params: [type, config.portForwardMax]
                    });
                    return;
                }

                if (target.checkExist()) {
                    showAlert({
                        msg: "rule_exist_v4v6",
                        params: type
                    });
                    return;
                }
            }
            showConfirm("confirm_data_effect", function () {
                showLoading();
                var fltParams = {};
                fltParams.macAddress = target.macAddress();

                if (target.ipv6Support() && target.ipType() != 'ipv6') {
                    fltParams.destIpAddress = target.destIpAddress();
                    fltParams.sourceIpAddress = target.sourceIpAddress();
                } else {
                    fltParams.destIpAddress = target.destIpv6Address();
                    fltParams.sourceIpAddress = target.sourceIpv6Address();
                }
				
                fltParams.ipType = target.ipType();
                fltParams.comment = target.comment();
                fltParams.protocol = target.selectedMode();
                fltParams.action = target.portFilterAction();
                fltParams.sourcePortEnd = target.sourcePortEnd();
                fltParams.sourcePortStart = target.sourcePortStart();
                fltParams.destPortEnd = target.destPortEnd();
                fltParams.destPortStart = target.destPortStart();
                service.setPortFilter(fltParams, target.callback);
            });
        }
		
		//设定过滤基本信息
		function setPortFilterBasicFunc() {
            showLoading();
            var elems = {};
            elems.defaultPolicy = target.defaultPolicy();
            elems.portFilterEnable = target.portFilterEnable();
            service.setPortFilterBasic(elems, target.callback);
        }
		//清空添加规则输入
		function clearFunc() {
            target.comment('');
            target.selectedMode('None');
            target.sourcePortEnd('0');
            target.sourcePortStart('0');
            target.destPortEnd('0');
            target.destPortStart('0');
            target.sourceIpv6Address('');
            target.sourceIpAddress('');
            target.destIpv6Address('');
            target.destIpAddress('');
            target.macAddress('');
            clearValidateMsg();
        }
		
		//检查新增规则是否已经存在
		function checkExistFunc() {
            target.macAddress(target.macAddress().toUpperCase());
            var currIpType = target.ipType().toUpperCase();
            var newRule = {
                macAddress: target.macAddress(),
                destIpAddress: currIpType == "IPV4" ? target.destIpAddress() : target.destIpv6Address(),
                sourceIpAddress: currIpType == "IPV4" ? target.sourceIpAddress() : target.sourceIpv6Address(),
                destPortRange: target.destPortStart() == '0' ? '' : target.destPortStart() + ' - ' + target.destPortEnd(),
                sourcePortRange: target.sourcePortStart() == '0' ? '' : target.sourcePortStart() + ' - ' + target.sourcePortEnd(),
                action: target.portFilterAction() == "Drop" ? "filter_drop" : "filter_accept",
                protocol: transProtocolValue(target.selectedMode()),
                ipType: currIpType
            };

            var oldRule;
            var rules = target.rules();
            for (var ki = 0; ki < rules.length; ki++) {
                oldRule = {
                    macAddress: rules[ki].macAddress,
                    destIpAddress: rules[ki].destIpAddress,
                    sourceIpAddress: rules[ki].sourceIpAddress,
                    destPortRange: rules[ki].destPortRange,
                    sourcePortRange: rules[ki].sourcePortRange,
                    action: rules[ki].action,
                    protocol: rules[ki].protocol,
                    ipType: rules[ki].ipType.toUpperCase()
                };

                if (_.isEqual(newRule, oldRule)) {
                    return true;
                }
            }
            return false;
        }
		
		//协议变化事件监听
		function protocolChangeHandlerFunc() {
            if (target.selectedMode() == PROTOCOLS.ICMP || target.selectedMode() == PROTOCOLS.NONE) {
                target.sourcePortEnd('0');
                target.sourcePortStart('0');
                target.destPortEnd('0');
                target.destPortStart('0');
                clearValidateMsg('#portRangeArea');
            } else {
                target.sourcePortEnd('65535');
                target.sourcePortStart('1');
                target.destPortEnd('65535');
                target.destPortStart('1');
            }
            return true;
        }
		
		//删除规则
		function deleteFilterRulesFunc() {
            var ids = target.gridTemplate.selectedIds();
            if (ids.length == 0) {
                showAlert("no_data_selected");
                return;
            }

            showConfirm("confirm_data_effect", function () {
                showLoading('deleting');
                var rules = {};
                rules.indexs = ids;
                service.deleteFilterRules(rules, target.callback);
            });
        }
		
    }

    //获取port filter信息
     
    function getPortFilter() {
        return service.getPortFilter();
    }
		
	//ip类型变化事件监听
	function ipTypeChangeHandlerFunc() {
        clearValidateMsg();
        return true;
    }
	
    //初始化port filter view model
     
    function initialize(viewModel) {
        var vm;
        if (viewModel) {
            vm = viewModel;
            var fltinfo = getPortFilter();
            vm.gridTemplate.clearAllChecked();
            vm.gridTemplate.data(fltinfo.portFilterRules);
			vm.defaultPolicy(fltinfo.defaultPolicy);
            vm.oriDefaultPolicy(fltinfo.defaultPolicy);
            vm.portFilterEnable(fltinfo.portFilterEnable);
            vm.oriPortFilterEnable(fltinfo.portFilterEnable);
            vm.rules(fltinfo.portFilterRules);
            refreshTableHeight();
            $('#portFilters').find('tbody').translate();
            renderCheckbox();
            $('.notes-content').translate();
            return;
        }

        vm = new PortFilterVM();
        var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(vm, container[0]);

        fixTableHeight();

        $('#filterBasicForm').validate({
            submitHandler: function () {
                showConfirm("confirm_data_effect", function () {
                    vm.setPortFilterBasic();
                });
            }
        });

        $('#portFilterListForm').validate({
            submitHandler: function () {
                vm.deleteFilterRules();
            }
        });

        $('#portFilterForm').validate({
            submitHandler: function () {
                vm.save();
            },
            rules: {
                txtMacAddress: {
                    filter_optional: true,
                    mac_check: true
                },
                txtDestIpAddress: {
                    ip_check: true
                },
                txtSourceIpAddress: {
                    ip_check: true
                },
                txtSourceIpv6Address: {
                    ipv6: true
                },
                txtDestIpv6Address: {
                    ipv6: true
                },
                txtDestPortStart: {
                    digits: true,
                    range: [1, 65535],
                    portCompare: "#txtDestPortEnd"
                },
                txtDestPortEnd: {
                    digits: true,
                    range: [1, 65535],
                    portCompare: "#txtDestPortStart"
                },
                txtSourcePortStart: {
                    digits: true,
                    range: [1, 65535],
                    portCompare: "#txtSourcePortEnd"
                },
                txtSourcePortEnd: {
                    digits: true,
                    range: [1, 65535],
                    portCompare: "#txtSourcePortStart"
                },

                txtComment: {
                    comment_check: true
                }
            },
            groups: {
                destPort: "txtDestPortStart txtDestPortEnd",
                sourcePort: "txtSourcePortStart txtSourcePortEnd"
            },
            errorPlacement: function (error, element) {
                if (element.attr("name") == "txtMacAddress") {
                    error.appendTo("#macErrorDiv");
                } else if (element.attr("name") == "txtDestPortStart" || element.attr("name") == "txtDestPortEnd") {
                    error.appendTo("#destPortErrorDiv");
                } else if (element.attr("name") == "txtSourcePortStart" || element.attr("name") == "txtSourcePortEnd") {
                    error.appendTo("#sourcePortErrorDiv");
                } else
                    error.insertAfter(element);
            }
        });
    }

    $.validator.addMethod("filter_optional", function (value, element, param) {
        var result = _.any(['#txtMacAddress', '#txtDestIpAddress', '#txtSourceIpAddress', '#txtSourceIpv6Address', '#txtDestIpv6Address'],
                function (item) {
            var tmp = $(item).val().replace(/\s+/g, '');
            return $(item + ':visible').length > 0 && tmp != '';
        });

        var portResult = _.any(['#txtDestPortStart', '#txtDestPortEnd', '#txtSourcePortStart', '#txtSourcePortEnd'],
                function (item) {
            return $(item).val() != '0';
        });

        return result || portResult;
    });

    return {
        init: initialize
    };
});

//家长控制
 
define("firewall_parental_control","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var maxItem = 10;
    var pcVm = null;
    var PAGES = {
        MAIN: 0,
        MANAGE: 1,
        RULE: 2
    };
	
	
    function ParentalControlVM() {
        var target = this;
        var hostNameList = service.getHostNameList({}).devices;
        target.currentPage = ko.observable(PAGES.MAIN);
        target.pages = PAGES;


        target.childGroupList = ko.observable([]);
        target.childGroupMac = ko.computed(function () {
            return _.map(target.childGroupList(), function (data) {
                return data.mac;
            });
        });
		
        target.currentUserInChildGroup = ko.observable(true);
        //获取儿童组设备列表
         
        target.fetchChildGroupList = fetchChildGroupListFunc;
		
        target.fetchChildGroupList();

        target.manageHandler = manageHandlerFunc;
		function manageHandlerFunc() {
            target.currentPage(PAGES.MANAGE);
            target.fetchAttachedDevices();
        }
        target.attachedDevices = ko.observable([]);
        //获取已连接设备列表
         
        target.fetchAttachedDevices = fetchAttachedDevicesFunc;
		

		//儿童组设备 标签按钮事件
         
        target.backToMainHandler = backToMainHandlerFunc;
		
		
        ko.computed(function () {
            target.attachedDevices();
            target.childGroupList();
            $("#pc_children_group_form").translate();
        }).extend({
            notify: 'always',
            throttle: 300
        });
        
        //添加至儿童组
         
        function addChildGroupFun(flag, eleData) {
            showLoading();
            service.addChildGroup(eleData, function (data) {
                target.fetchChildGroupList(function () {
                    target.fetchAttachedDevices(function () {
                        hideLoading();
                        if (flag) {
                            service.logout({}, function () {
                                window.location = 'index.html';
                            });
                        }
                    });
                });
            }, function (data) {
                errorOverlay();
            });
        }
		
        //移除按钮事件
         
        target.removeChildGroupHandler = removeChildGroupHandlerFunc;
		
		
        //添加按钮事件
         
        target.addChildGroupHandler = addChildGroupHandlerFunc;
		

        target.dealElement = dealElementFunc;
		
		
		
        //取消编辑主机名按钮事件
         
        target.cancelEditHostNameHandler = cancelEditHostNameHandlerFunc;
		
        //主机名编辑保存按钮事件
         
        target.saveHostNameHandler = saveHostNameHandlerFunc;
		
        //主机名编辑按钮事件
         
        target.editHostNameHandler = editHostNameHandlerFunc;
		
		
        target.selectedIds = ko.observableArray([]);
        target.siteList = ko.observable([]);
        /////////////////////////////////////////////////////////////////
        target.disableAdd = ko.computed(function () {
            return target.siteList().length == maxItem;
        });
        
        ko.computed(function () {
            target.siteList();
            target.selectedIds();
            setTimeout(function () {
                renderCheckbox();
            }, 100);
            $("#pc_site_white_list_form").translate();
        });
		
        //网站白名单添加按钮事件
         
        target.openAddSitePopoverHandler = openAddSitePopoverHandlerFunc;
		
        //网站白名单列表选择框点击事件
         
        target.checkboxClickHandler = checkboxClickHandlerFunc;
		
		//获取网站白名单列表
         
        target.fetchSiteWhiteList = fetchSiteWhiteListFunc;
		
		//网站白名单删除函数
         
        function removeSiteWhiteItem(ids) {
            showConfirm('confirm_data_delete', function () {
                showLoading();
                service.removeSiteWhite({
                    ids: ids
                }, function (data) {
                    target.fetchSiteWhiteList(function () {
                        successOverlay();
                    });
                }, function (data) {
                    target.fetchSiteWhiteList(function () {
                        errorOverlay();
                    });
                });
            });
        }
		//网站白名单删除所有按钮事件
         
        target.removeAllWhiteSite = removeAllWhiteSiteFunc;
		
        //网站白名单删除按钮事件
         
        target.removeSelectedWhiteSite = removeSelectedWhiteSiteFunc;
		
        //网站白名单移除按钮事件
         
        target.removeWhiteSite = removeWhiteSiteFunc;
		
        
        
        //网站白名单添加框保存按钮事件
         
        target.saveSiteWhite = saveSiteWhiteFunc;
		
        //////////////////////////////////////////////////////////////////
        target.notSave = ko.observable(false);
        //获取时间限制信息
         
        target.fetchTimeLimited = fetchTimeLimitedFunc;
		
        
        //上网时间设置时间表格事件绑定
         
        target.bindEvent = bindEventFunc;
		
		//上网时间设置保存按钮事件
         
        target.saveTimeLimitedHandler = saveTimeLimitedHandlerFunc;
		
        //////////////////////////////////////////////////////////////////
        var isBinded = false;
        //上网规则标签点击事件
         
        target.openRulePage = openRulePageFunc;
		function openRulePageFunc() {
            if (target.currentPage() == PAGES.RULE) {
                return;
            }
            target.currentPage(PAGES.RULE);
            target.currentUserInChildGroup(service.checkCurrentUserInChildGroup().result);
            initTableData();
            if (!isBinded) {
                if (!target.currentUserInChildGroup()) {
                    target.bindEvent();
                }
                isBinded = true;
            }
            showLoading();
            target.fetchTimeLimited();
            target.fetchSiteWhiteList(function () {
                hideLoading();
            });
        }
		
		//获取儿童组设备列表
		function fetchChildGroupListFunc(cb) {
            service.childGroupList({}, function (data) {
                target.currentUserInChildGroup(service.checkCurrentUserInChildGroup(data.devices).result);
                target.childGroupList([]);
                _.map(data.devices, function (elem, idx) {
                    elem.idx = idx;
                    elem.hostname = pcUtil.getHostName(elem.hostname, elem.mac, hostNameList);
                });
                target.childGroupList(data.devices);
                if (_.isFunction(cb)) {
                    cb.apply(this);
                }
            });
		}
		
		//获取已连接设备列表
		function fetchAttachedDevicesFunc(cb) {
            target.attachedDevices([]);
            var counter = 0;
            var currDevices = [];
            //RJ45 已连接设备
            service.getAttachedCableDevices({}, function (data) {
                counter++;
                var devs = _.map(data.attachedDevices, function (elem) {
                    elem.idx = _.uniqueId('wireless_');
                    elem.hostName = pcUtil.getHostName(elem.hostName, elem.macAddress, hostNameList);
                    elem.inChildGroup = _.contains(target.childGroupMac(), elem.macAddress);
                    return elem;
                });
                if (counter != 1) {
                    target.attachedDevices(_.flatten([currDevices, devs]));
                    if (_.isFunction(cb)) {
                        cb.apply(this);
                    }
                } else {
                    currDevices = devs;
                }
            });
			
            //wifi 已连接设备
            service.getCurrentlyAttachedDevicesInfo({}, function (data) {
                counter++;
                var devs = _.map(data.attachedDevices, function (elem) {
                    elem.idx = _.uniqueId('wireless_');
                    elem.hostName = pcUtil.getHostName(elem.hostName, elem.macAddress, hostNameList);
                    elem.inChildGroup = _.contains(target.childGroupMac(), elem.macAddress);
                    return elem;
                });
                if (counter != 1) {
                    target.attachedDevices(_.flatten([currDevices, devs]));
                    if (_.isFunction(cb)) {
                        cb.apply(this);
                    }
                } else {
                    currDevices = devs;
                }
            });
		}
		//儿童组设备 标签按钮事件
		function backToMainHandlerFunc() {
			target.currentPage(PAGES.MAIN);
		}
		
		//移除按钮事件
		function removeChildGroupHandlerFunc(ele) {
            showLoading();
            service.removeChildGroup(ele, function (data) {
                target.fetchChildGroupList(function () {
                    target.fetchAttachedDevices(function () {
                        hideLoading();
                    });
                });
            }, function (data) {
                errorOverlay();
            });
        }
		
		//添加按钮事件
		function addChildGroupHandlerFunc(data) {
            var uMacAddr = service.getCurretnMAC();
            if (uMacAddr != data.macAddress) {
                addChildGroupFun(false, data);
            } else {
                showConfirm("parental_add_self", function () {
                    addChildGroupFun(true, data);
                })
            }
        }
		
		//取消编辑主机名按钮事件
		function cancelEditHostNameHandlerFunc(eleData) {
            target.dealElement(false, eleData.idx);
        }
		
		//主机名编辑保存按钮事件
		function saveHostNameHandlerFunc(ele) {
            var $hostInput = $("#hostname_input_" + ele.idx);
            var hostname = $.trim($hostInput.val());
			if (hostname.indexOf(" ") == 0 || hostname.lastIndexOf(" ") == (hostname.length - 1) || /[\*\+\$\[&:,;<>'"\\`\]￥]{1,32}/.test(hostname)) {
                showAlert('modify_hostname_invalid');
                return false;
            }else if (hostname == '') {
                $(".promptErrorLabel", "#confirm-message-container").text($.i18n.prop("required"));
                var $closestTD = $hostInput.closest('td').addClass('has-error');
                addTimeout(function () {
                    $closestTD.removeClass('has-error');
                }, 5000);
                showAlert('required');
                return false;
            }  
            showLoading();
            ele.hostname = hostname;
            service.editHostName(ele, function () {
                service.getHostNameList({}, function (hostNameData) {
                    hostNameList = hostNameData.devices;
                    target.fetchChildGroupList(function () {
                        hideLoading();
                    });
                    target.fetchAttachedDevices();
                });
            }, function () {
                errorOverlay();
            });
        }
		
		//主机名编辑按钮事件
		function editHostNameHandlerFunc(ele) {
            $("#hostname_input_" + ele.idx).val(ele.hostname);
            target.dealElement(true, ele.idx);
            return false;
        }
		//网站白名单添加按钮事件
		function openAddSitePopoverHandlerFunc() {
            var addNewSiteTmpl = $("#addNewSiteTmpl").html();
            popover.open({
                target: $("#openAddSiteBtn"),
                html: addNewSiteTmpl,
                width: "300px",
                validation: addValidation
            });
        }
		
		//网站白名单列表选择框点击事件
		function checkboxClickHandlerFunc(eleData, evt) {
            addTimeout(function () {
                target.selectedIds(getSelectedValues());
            }, 100);
        }
		//获取网站白名单列表
		function fetchSiteWhiteListFunc(cb) {
            service.getSiteWhiteList({}, function (eledata) {
                target.selectedIds([]);
                target.siteList(eledata.siteList);
                _.isFunction(cb) && cb.apply(this);
            }, function () {
                target.siteList([]);
                _.isFunction(cb) && cb.apply(this);
            });
        }
		
		//网站白名单删除所有按钮事件
		function removeAllWhiteSiteFunc() {
            removeSiteWhiteItem(getAllCheckboxValues());
        }
		//网站白名单删除按钮事件
		function removeSelectedWhiteSiteFunc() {
            removeSiteWhiteItem(getSelectedValues());
        }
		//网站白名单移除按钮事件
		function removeWhiteSiteFunc(ele, evt) {
            removeSiteWhiteItem([ele.id]);
        }
		
		//网站白名单添加框保存按钮事件
		function saveSiteWhiteFunc(name, site) {
            popover.hide();
            var matched = _.find(target.siteList(), function (one) {
                return one.site == site;
            });
            if (matched) {
                showAlert("pc_link_exist", function () {
                    setTimeout(function () {
                        popover.show();
                    }, 200);
                });
                return false;
            }

            showLoading();
            service.saveSiteWhite({
                name: name,
                site: site
            }, function () {
                target.fetchSiteWhiteList(function () {
                    popover.close();
                    successOverlay();
                });
            }, function () {
                target.fetchSiteWhiteList(function () {
                    errorOverlay();
                    popover.show();
                });
            });
        }
		
		//上网时间设置时间表格事件绑定
		function bindEventFunc() {
            $("td:not('.col-head')", "#pc_time_limited_tbody").addClass('cursorhand').die().click(function () {
                target.notSave(true);
                $(this).toggleClass('active');
            }).hover(function () {
                var $this = $(this);
                var w = $this.data('week');
                var h = $this.data('hour');
                $("tr:nth-child(" + (w + 1) + ") td:first-child", "#pc_time_limited_tbody").addClass('time_td_hover');
                $("#col_" + h).addClass('time_td_hover');
                if ($this.not('.active')) {
                    $this.addClass('time_td_hover');
                }
            }, function () {
                var $this = $(this);
                var w = $this.data('week');
                var h = $this.data('hour');
                $("tr:nth-child(" + (w + 1) + ") td:first-child", "#pc_time_limited_tbody").removeClass('time_td_hover');
                $("#col_" + h).removeClass('time_td_hover');
                $this.removeClass('time_td_hover');
            });
        }
		
		//上网时间设置保存按钮事件
		function saveTimeLimitedHandlerFunc() {
            showLoading();
            var tds = getSelectedTds();
            var timeStr = getSavedData(tds);
            service.saveTimeLimited({
                time: timeStr
            }, function () {
                target.notSave(false);
                successOverlay();
            }, function () {
                errorOverlay();
            });
        }
		
    }
	
		function dealElementFunc(flag, idx) {
            if (flag == false) {
                $("#edit_btn_" + idx + ",#hostname_txt_" + idx).show();
                $("#save_btn_" + idx + ",#cancel_btn_" + idx + ",#hostname_input_" + idx).hide();
            } else {
                $("#edit_btn_" + idx + ",#hostname_txt_" + idx).hide();
                $("#save_btn_" + idx + ",#cancel_btn_" + idx + ",#hostname_input_" + idx).show();
            }
        }

		//获取时间限制信息
		function fetchTimeLimitedFunc() {
            service.getTimeLimited({}, function (ele) {
                for (var ki in ele) {
                    for (var idx = 0; idx < ele[ki].length; idx++) {
                        var id = 'td_' + ki + '_' + ele[ki][idx];
                        $("#" + id).addClass('active');
                    }
                }
            }, function () {});
        }

    var pcUtil = {
        getHostName: function (hostName, mac, hostNameList) {
            var ele = _.find(hostNameList, function (ele) {
                return ele.mac == mac;
            });
            return ele ? ele.hostname : hostName;
        }
    };
	function getCheckboxValues(flag) {
        var selectedValues = [];
        $(":checkbox" + (flag ? ":checked" : ""), "#pb_white_list").each(function (i, n) {
            selectedValues.push(n.value)
        });
        return selectedValues;
    }
    //获取列表中被选中项的value值
     
    function getSelectedValues() {
        return getCheckboxValues(true);
    }
    function getAllCheckboxValues() {
        return getCheckboxValues(false);
    }
    
    //增加网站白名单表单提交函数绑定和校验规则设置
     
    function addValidation() {
        $('#whiteSiteAddForm').validate({
            submitHandler: function () {
                var name = $("#siteName").val();
                var site = $("#siteLink").val();
                pcVm.saveSiteWhite(name, site);
            },
            rules: {
                siteName: 'siteName_check',
                siteLink: 'siteLink_check'
            }
        });
    }
	
    function getSavedData(timeDatas) {
        var ret = '';
        for (var ki in timeDatas) {
            var hours = _.sortBy(timeDatas[ki], function (n) {
                return n;
            });
            if (timeDatas[ki].length) {
                ret += ki + '+';
                ret += hours.join(',');
                ret += ';'
            }
        }
        return ret.substring(0, ret.length - 1);
    }
    //获取时间表格选中的时间
     
    function getSelectedTds() {
        var defaultValue = {
            '0': [],
            '1': [],
            '2': [],
            '3': [],
            '4': [],
            '5': [],
            '6': []
        };
        $("td.active", "#pc_time_limited_tbody").each(function (i, n) {
            var $this = $(n);
            var week = $this.data('week');
            var hour = $this.data('hour');
            defaultValue[week].push(hour);
        });
        return defaultValue;
    }

	function convertHour(hour) {
        if (hour <= 16) {
            return hour + 7;
        } else {
            return hour - 17;
        }
    }
    //初始化时间表格
     
    function initTableData() {
        $("tr", "#pc_time_limited_tbody").each(function (idx, n) {
            var $tr = $(n);
            $("td:not(:first)", $tr).each(function (j, m) {
                var $td = $(m);
                var hour = convertHour(j);
                $td.attr({
                    id: 'td_' + idx + '_' + hour
                }).data({
                    week: idx,
                    hour: hour
                });
            });
        });
        $("td.active", "#pc_time_limited_tbody").removeClass("active");
        $("thead td:not(:first)", "#pc_time_limited_form").each(function (idx, n) {
            var hour = convertHour(idx);
            $(n).attr({
                id: 'col_' + hour
            });
        });
        pcVm.notSave(false);
    }

    
    //页面初始化
     
    function initialize() {
       
        pcVm = new ParentalControlVM();
		bindContainer(pcVm);
    }
	function bindContainer(pcVm)
	{
		var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(pcVm, container[0]);
	}

    return {
        init: initialize
    };
});

define("firewall_dmz_set","underscore jquery knockout set service".split(" "),
    function ( _, $, ko, config, service) {

    //system dmz setting VM
     
    function DmzSettingVM() {
        var target = this;
        var dmzInfo = getDmzSetting();
        target.dmzSetting = ko.observable(dmzInfo.dmzSetting);
        target.ipAddress = ko.observable(dmzInfo.ipAddress);
        target.isDataCard = config.PRODUCT_TYPE == 'DATACARD';

        target.clear = clearFunc;
        //应用按钮事件
         
        target.save = saveFunc;
		
		function saveFunc() {
			showLoading();
			var params = {};
			params.dmzSetting = target.dmzSetting();
			params.ipAddress = target.ipAddress();
			service.setDmzSetting(params, function (result) {
				if (result.result != "success") {
					errorOverlay();
				} else {
					target.clear();
					successOverlay();
				}
			});
		}
		
    }
	
	function clearFunc() {
		initialize();
    }
	
	
    //获取dmz 信息
     
    function getDmzSetting() {
        return service.getDmzSetting();
    }

    //初始化DmzSettingVM model
     
    function initialize() {
        
        var dmzVm = new DmzSettingVM();
        bindContainer(dmzVm);
    }
	function bindContainer(dmzVm){
		var container = $('#container');
        ko.cleanNode(container[0]);
		ko.applyBindings(dmzVm, container[0]);
        $('#dmzSettingForm').validate({
            submitHandler: function () {
                dmzVm.save();
            },
            rules: {
                txtIpAddress: 'dmz_ip_check'
            }
        });
	}

    return {
        init: initialize
    };
});

define("firewall","underscore jquery knockout set service".split(" "),

function(_, $, ko, config, service) {

    function FirewallVM() {
        var target = this;
		target.hasDdns = config.DDNS_SUPPORT;
		target.hasUpdateCheck = config.HAS_UPDATE_CHECK;
		target.hasUrlFilter = config.HAS_URL;
		target.hasUssd = config.HAS_USSD;
		target.hasUpnp = config.HAS_UPNP;
    }

	function initialize() {        
        var fwVm = new FirewallVM();
		bindingContainer(fwVm);
    }
	function bindingContainer(fwVm)
	{
		var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(fwVm, container[0]);
	}
	return {
		init : initialize
	};
});

define("ddns","underscore jquery knockout set service".split(" "), function (_, $, ko, config, service) {
    var ddnsSetModes = _.map(config.DDNSSetMode, newOption);
    var ddnsProviderList = _.map(config.DDNSDDP, newOption);
    var ddns_mode_select = _.map(config.ddns_Modeselect, newOption);
    function newOption(optItem) {
        return new Option(optItem.name, optItem.value);
    }
    function DdnsViewModel() {
        var target = this;
        target.hasUssd = config.HAS_USSD;
        target.hasUpdateCheck = config.HAS_UPDATE_CHECK;
        var data = service.getDdnsParams();
        target.ddnsSetModes = ko.observableArray(ddnsSetModes);
        target.ddnsProviderList = ko.observableArray(ddnsProviderList);
        target.ddns_mode_select = ko.observableArray(ddns_mode_select);
        target.currentMode = ko.observable(data.DDNS_Enable);
        target.currentModeselect = ko.observable(data.DDNS_Mode);
        target.currentProviderList = ko.observable("dyndns.org");
        $.each(config.DDNSDDP, function (i, n) {
            if (data.DDNSProvider == n.value) {
                target.currentProviderList(data.DDNSProvider);
            }
        });
        target.DDNSaccount = ko.observable(data.DDNSAccount);
        target.DDNSpasswd = ko.observable(data.DDNSPassword);
        target.DDNSname = ko.observable(data.DDNS);
        target.DDNS_HashValue = ko.observable(data.DDNS_Hash_Value);
        target.isddnsStatusTrans = ko.observable();
        target.isEnableSet = ko.observable();
        target.isHashValue = ko.observable();
        target.isddnsaccount = ko.observable();
        target.isddnspasswd = ko.observable();
        target.isDDNSStatus = ko.observable();
        target.isddnsdomainName = ko.observable();
        target.isNone = ko.observable();
        target.onStates = ko.observable();
        target.showPassword_ddns = ko.observable(false);
        target.showPasswordHandler_ddns = showPasswordHandler_ddns;
        changeddnsProviderList();
        target.changeDdnsProvider = changeDdnsProviderFunc;
        changeSetDdnsMode();
        target.changeSetDdnsMode = changeSetDdnsModeFunc;
        updateScanDdnsStatus();
        target.apply = applyFunc;
        function updateScanDdnsStatus() {
            var trans = "";
            $.getJSON("/reqproc/proc_get", {
                cmd: "getddns_status",
                "_": new Date().getTime()
            }, function (data) {
                if (data.getddns_status == "0") {
                    trans = "register successful";
                    target.onStates(true);
                } else if (data.getddns_status == "1") {
                    trans = "login error";
                    target.onStates(true);
                } else if (data.getddns_status == "2") {
                    trans = "network error";
                    target.onStates(true);
                } else if (data.getddns_status == "3") {
                    trans = "registering";
                    target.onStates(true);
                } else if (data.getddns_status == "4") {
                    trans = "not registered";
                    target.onStates(true);
                } else if (data.getddns_status == "5") {
                    trans = "error registering";
                    target.onStates(true);
                } else if (data.getddns_status == "-1") {
                    trans = "";
                    target.onStates(true);
                }
                target.isddnsStatusTrans($.i18n.prop(trans));
                addTimeout(updateScanDdnsStatus, 2000);
            });
        }
        function changeSetDdnsMode() {
            if (target.currentMode() != "1") {
                target.isEnableSet(false);
            } else {
                target.isEnableSet(true);
            }
            return true;
        }
        function changeSetDdnsModeFunc() {
            changeSetDdnsMode();
        }
        function showPasswordHandler_ddns() {
            $("#ddns_secretcode_input").parent().find(".error").hide();
            var checkbox = $("#showPassword_ddns:checked");
            if (checkbox && checkbox.length == 0) {
                target.showPassword_ddns(true);
            } else {
                target.showPassword_ddns(false);
            }
        }
        function changeDdnsProviderFunc() {
            if (data.DDNSProvider != target.currentProviderList()) {
                target.DDNSaccount("");
                target.DDNSpasswd("");
                target.DDNSname("");
            } else {
                target.DDNSaccount(data.DDNSAccount);
                target.DDNSpasswd(data.DDNSPassword);
                target.DDNSname(data.DDNS);
            }
            changeddnsProviderList();
        }
        function changeddnsProviderList() {
            if (target.currentProviderList() != "none") {
                target.isddnsaccount(true);
                target.isddnspasswd(true);
                target.isddnsdomainName(true);
                target.isHashValue(true);
                target.isDDNSStatus(true);
            } else {
                target.isddnsaccount(false);
                target.isddnspasswd(false);
                target.isddnsdomainName(false);
                target.isHashValue(false);
                target.isDDNSStatus(false);
            }
            if (target.currentProviderList() != "freedns.afraid.org") {
                target.isHashValue(false);
            } else {
                target.isHashValue(true);
            }
            return true;
        }
        function applyFunc() {
            showLoading();
            var params = {};
            params.goformId = "DDNS";
            params.DDNS_Enable = target.currentMode();
            if (target.currentMode() == "1") {
                params.DDNS_Mode = target.currentModeselect();
                params.DDNSProvider = target.currentProviderList();
                if (target.currentProviderList() != "none") {
                    params.DDNS = target.DDNSname();
                    params.DDNSPassword = target.DDNSpasswd();
                    params.DDNSAccount = target.DDNSaccount();
                }
                if (target.currentProviderList() == "freedns.afraid.org") {
                    params.DDNS_Hash_Value = target.DDNS_HashValue();
                }
            }
            service.setDDNSForward(params, function (result) {
                if (result.result == "success") {
                    successOverlay();
                    data = service.getDdnsParams();
                } else {
                    errorOverlay();
                }
            });
        }
    }
    function initialize() {
        var container = $('#container');
        ko.cleanNode(container[0]);
        var vm = new DdnsViewModel();
        ko.applyBindings(vm, container[0]);
        $("#ddnsForm").validate({
            submitHandler: function () {
                vm.apply();
            },
            rules: {
                ddns_secretcode_input: "secretcode_check",
                DDNS_Hash_Value: "ddns_hashvalue_check",
                ddns_secretcode_inputshow: "secretcode_check"
            },
            errorPlacement: function (error, element) {
                var id = element.attr("id");
                if (id == "ddns_secretcode_input" || id == "ddns_secretcode_inputshow") {
                    error.insertAfter("#lblShowPassword");
                } else {
                    error.insertAfter(element);
                }
            }
        });
    }
    return {
        init: initialize
    };
});


//选网模块
 
define("network_net_select","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var selectModes = _.map(config.AUTO_MODES, function (item) {
        return new Option(item.name, item.value);
    });

    //选网功能view model
     
    function NetSelectVM() {
        var target = this;

        target.networkList = ko.observableArray([]);
        target.selectNetwork = ko.observable('');
        target.enableFlag = ko.observable(true);
        target.types = ko.observableArray(selectModes);
        target.selectedType = ko.observable();
        target.selectMode = ko.observable();

		target.networkText = networkTextFunc;
		
		target.networkStatusId = networkStatusIdFunc;
		
        target.networkStatus = networkStatusFunc;

        target.subnetworkType = subnetworkTypeFunc;

		target.networkType = networkTypeFunc;

        target.operatorName = operatorNameFunc;

        target.networkValue = networkValueFunc;

        target.networkTypeId = networkTypeIdFunc;

        target.subnetTypeId = subnetTypeIdFunc;
       //手动搜网.
         
        target.search = searchFunc;

        //自动选网时设置网络模式.
         
        target.save = saveFunc;

        target.checkEnable = checkEnableFunc;

        //注册选择的网络.
         
        target.register = registerFunc;

        //init data
        target.checkEnable();
        var info = getNetSelectInfo();
        if ("manual_select" == info.net_select_mode || "manual_select" == info.m_netselect_save) {
            target.selectMode("manual_select");
        } else {
            target.selectMode("auto_select");
        }

        target.selectedType(info.net_select);
		
		//注册选择的网络.
		function registerFunc() {
            showLoading('registering_net');
            var networkToSet = target.selectNetwork().split(',');
            service.setNetwork(networkToSet[0], parseInt(networkToSet[1]), parseInt(networkToSet[2]), function (result) {
                if (result) {
                    target.networkList([]);
                    var autoType = getNetSelectInfo();
                    target.selectedType(autoType.net_select);
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        }
		
		function checkEnableFunc() {
            var status = service.getStatusInfo();
            if (status.connectStatus == "ppp_connected" || status.connectStatus == "ppp_connecting") {
                target.enableFlag(false);
            } else {
                target.enableFlag(true);
            }
        }
		
		//自动选网时设置网络模式.
		function saveFunc() {
            showLoading();

            //AutoSelect call SetBearerPreference
            var params = {};
            params.strBearerPreference = target.selectedType();
            service.setBearerPreference(params, function (result) {
                if (result.result == "success") {
                    target.networkList([]);
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        }
		
		//手动搜网.
		function searchFunc() {
            showLoading('searching_net');
            service.scanForNetwork(function (result, networkList) {
                hideLoading();
                if (result) {
                    target.networkList(networkList);
                    for (var i = 0; i < networkList.length; i++) {
                        var n = networkList[i];
                        if (n.nState == '2') {
                            target.selectNetwork(n.strNumeric + ',' + n.nRat + ',' + n.SubAct);
                            return;
                        }
                    }
                } else {
                    target.networkList([]);
                }
            });
        }
		
		function subnetTypeIdFunc(data) {
            return getSubNetworkTypeTog(data.nRat, data.SubAct);
        }
		
		function networkTypeIdFunc(data) {
            return getNetworkType(data.nRat);
        }
		
		function networkValueFunc(data) {
            var result = [];
            result.push(data.strNumeric); //strNumeric
            result.push(data.nRat); //nRat
            result.push(data.SubAct);
            return result.join(',');
        }
		
		function operatorNameFunc(data) {
            return data.strShortName;
        }
		
		function networkTypeFunc(data) {
            var result = getNetworkType(data.nRat);
            if (result == "auto")
                result = $.i18n.prop("auto");
            return result;
        }
		
		function subnetworkTypeFunc(data) {
            var result = getSubNetworkTypeTog(data.nRat, data.SubAct);
            return result;
        }
		
		function networkStatusFunc(data) {
            return $.i18n.prop(getNetworkStatusTog(data.nState));
        }
		
		function networkStatusIdFunc(data) {
            return getNetworkStatusTog(data.nState);
        }
		
		function networkTextFunc(data) {
            return data.strNumeric;
        }

    }

    //获取网络选择信息.
     
    function getNetSelectInfo() {
        return service.getNetSelectInfo();
    }

    //搜网结果中的状态转换为对应的语言项.
     
    function getNetworkStatusTog(status) {
        if ("3" == status) {
            return "forbidden";
        } else if ("2" == status) {
            return "current";
        } else if ("1" == status) {
            return "available";
        }else if ("0" == status) {
            return "unknown";
        }
    }
	//子网络类型转换.
     
    function getSubNetworkTypeTog(type, subtype) {
        var type_3g = [2, 4, 5, 6, 8];
        if ("1" == subtype) {
            if ("7" == type) {
                subtype = "FDD-LTE";
            } else if ($.inArray(type, type_3g) != -1) {
                subtype = "WCDMA";
            }else {
                subtype = "GSM";
            }
        } else if ("0" == subtype) {
            if ("7" == type) {
                subtype = "TD-LTE";
            } else if ($.inArray(type, type_3g) != -1) {
                subtype = "TD-SCDMA";
            } else {
                subtype = "GSM";
            }
        } else {
            subtype = "";
        }
        return subtype;
    }
    //网络类型转换.
     
    function getNetworkType(type) {
        if ("7" == type) {
            return "4G";
        } else if ("2" == type) {
            return "3G";
        } else if ("0" == type) {
            return "2G";
        } else {
            return "auto";
        }
    }

    function bindContainer(vm){
	
        var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(vm, container[0]);
	}

    //初始化选网功能view model.
     
    function initialize() {
        var vm = new NetSelectVM();
		bindContainer(vm);
        addInterval(vm.checkEnable, 1000);
    }

    return {
        init: initialize
    };
});
define("locknet","jquery knockout service jquery set main".split(" "),
    function ($, ko, service, config, home) {

    function initialize() {
        var container = $('#container')[0];
        ko.cleanNode(container);
        var vm = new locknetViewMode();
        ko.applyBindings(vm, container);

        $("#frmNetworkLock").validate({
            submitHandler: function () {
                vm.unlock();
            },
            rules: {
                txtLockNumber: "unlock_code_check"
            }
        });
    }

    function locknetViewMode() {
        var target = this;
        var curCableMode = false;
        target.isCPE = config.PRODUCT_TYPE == 'CPE';
        target.hasRj45 = config.RJ45_SUPPORT;
        target.hasSms = config.HAS_SMS;
        target.hasPhonebook = config.HAS_PHONEBOOK;
        target.isSupportSD = config.SD_CARD_SUPPORT;
        if (config.WIFI_SUPPORT_QR_SWITCH == false) {
            target.showQRCode = config.WIFI_SUPPORT_QR_CODE;
        } else {
            var wifiInfo = service.getWifiBasic();
            target.showQRCode = config.WIFI_SUPPORT_QR_CODE && wifiInfo.show_qrcode_flag;
        }
        if(config.WIFI_SUPPORT_QR_CODE){
            target.qrcodeSrc = './pic/qrcode_ssid_wifikey.png?_=' + $.now();
        } else {
            target.qrcodeSrc = './pic/res_blacktrans.png';
        }
        target.hasParentalControl = ko.observable(config.HAS_PARENTAL_CONTROL && curCableMode);
        target.deviceInfo = ko.observable([]);
        target.isHomePage = ko.observable(false);
        if (window.location.hash == "#main") {
            target.isHomePage(true);
        }

        target.supportUnlock = config.NETWORK_UNLOCK_SUPPORT;
        target.unlockCode = ko.observable();

        var info = service.getNetworkUnlockTimes();
        target.times = ko.observable(info.unlock_nck_time);

        //显示工作模式设置窗口
        target.showOpModeWindow = showOpModeWindowFunc;
		
        target.isLoggedIn = ko.observable(false);
        target.enableFlag = ko.observable(false);
        //解锁
        target.unlock = unlockFunc;

        //更新工作模式状态
        target.refreshOpmodeInfo = refreshOpmodeInfoFunc;
		
        //定时检查工作模式状态
        if (target.hasRj45) {
            target.refreshOpmodeInfo();
            addInterval(function () {
                target.refreshOpmodeInfo();
            }, 1000);
        }
		
		//更新工作模式状态
		function refreshOpmodeInfoFunc() {
            var obj = service.getStatusInfo();
            target.isLoggedIn(obj.isLoggedIn);

            if (!curCableMode && checkCableMode(obj.blc_wan_mode)) { //如果有线，则重新加载
                window.location.reload();
                return;
            }

            curCableMode = checkCableMode(obj.blc_wan_mode);
            target.hasParentalControl(config.HAS_PARENTAL_CONTROL && curCableMode);
            if (curCableMode && obj.ethWanMode.toUpperCase() == "DHCP") {
                target.enableFlag(true);
            } else if ((!curCableMode && obj.connectStatus != "ppp_disconnected") || (curCableMode && obj.rj45ConnectStatus != "idle" && obj.rj45ConnectStatus != "dead")) {
                target.enableFlag(false);
            } else {
                target.enableFlag(true);
            }
            var getMode = (obj.blc_wan_mode == "AUTO_PPP" || obj.blc_wan_mode == "AUTO_PPPOE") ? "AUTO" : obj.blc_wan_mode;
            var currMode = "";
            switch (getMode) {
			case "PPP":
                currMode = "opmode_gateway";
                break;
			case "PPPOE":
                currMode = "opmode_cable";
                break;
            case "AUTO":
                currMode = "opmode_auto";
                break;
            default:
                break;
            }
            $("#opmode").attr("data-trans", currMode).text($.i18n.prop(currMode));
        }
		
		//解锁
		function unlockFunc() {
            showLoading();
            service.unlockNetwork({
                unlock_network_code: target.unlockCode()
            }, function (data) {
                target.unlockCode("");
                if (data && data.result == "success") {
                    successOverlay();
                    if (window.location.hash == "#main") {
                        setTimeout(function () {
                            window.location.reload();
                        }, 500);
                    } else {
                        window.location.hash = "#main";
                    }
                } else {
                    var info = service.getNetworkUnlockTimes();
                    target.times(info.unlock_nck_time);
                    errorOverlay();
                }
            })
        }
		
		//显示工作模式设置窗口
		function showOpModeWindowFunc() {
            showSettingWindow("change_mode", "opmode_popup", "opmode_popup", 400, 300, function () {});
        }
    }

    return {
        init: initialize
    };
});

// RJ45联网设置模块
 
define("network_dial_set_cpe","underscore jquery knockout set service".split(" "),
function(_, $, ko, config, service) {
	var dialActions = _.map(config.dialActions, function(elem){
		return new Option(elem.name, elem.value);
	});
	
	var dialModes = _.map(config.pppoeModes, function(elem) {
		return new Option(elem.name, elem.value);
	});
		
    var checkStatusTimer = 0;
    var checkConCounter = 0;
    var timeoutTipShowed = false;

    // 联网设置view model.
     
	function PPPoEViewModel() {
		var pppObj = service.getPppoeParams();
        var ethParams = pppObj;
		var target = this;
		
		target.staticNoticeShow = ko.observable();
		target.dhcpNoticeShow = ko.observable();
		target.pppoeNoticeShow = ko.observable();
		target.autoNoticeShow = ko.observable();
		target.staticNotice = ko.observable();
		target.dhcpNotice = ko.observable();
		target.pppoeNotice = ko.observable();
		target.autoNotice = ko.observable();
		target.dhcpNoticeText = ko.observable();
		target.staticNoticeText = ko.observable();
		target.pppoeNoticeText = ko.observable();
        target.autoNoticeText = ko.observable();		
		target.currentMode = ko.observable(pppObj.ethwan_mode);//auto dhcp pppoe static
		target.showPassword = ko.observable(false);
		target.modes = ko.observableArray(dialModes);
		target.isPppoeMode = ko.observable(false);
		target.isStaticMode = ko.observable(false);
		target.isAutoMode = ko.observable(false);
		target.action = ko.observable();
		target.btnTrans = ko.observable();
		target.enableFlag = ko.observable();
		target.isShowDisbtn = ko.observable();
		target.isShowCancelbtn = ko.observable();
		
		if(pppObj.rj45_state == "dead"){
			checkRj45DeadTip();
		} else if(pppObj.rj45_state == "connect"){
			timeoutTipShowed = true;
			setRj45CheckTimer("connect");
		} else if(pppObj.rj45_state == "working"){
			setRj45WorkingTip();
		}
		
		target.user = ko.observable(pppObj.pppoe_username);
		target.password = ko.observable(pppObj.pppoe_cc);
		target.autoUser = ko.observable(pppObj.pppoe_username);
		target.autoPassword = ko.observable(pppObj.pppoe_cc);
		target.pppMode = ko.observable(pppObj.ethwan_dialmode);
		initContronler();
		

		//下拉框选择改变下面DIV模块
		target.changeModeDiv = changeModeDivFunc;
				
		target.radioHandler = radioHandlerFunc;
				
		target.primaryDNS = ko.observable(pppObj.static_wan_primary_dns);
		target.secondaryDNS = ko.observable(pppObj.static_wan_secondary_dns);
		target.ipAddress = ko.observable(pppObj.static_wan_ipaddr);
		target.subnetMask = ko.observable(pppObj.static_wan_netmask);
		target.defaultGateway = ko.observable(pppObj.static_wan_gateway);
		
		addInterval(function(){
			ethParams = service.getPppoeParams();
			pppObj.rj45_state = ethParams.rj45_state;
			initContronler();
		}, 1000);
		
        // 取消连接按钮事件.
         					
		target.cancelConnect = cancelConnectFunc;
		
        // 应用按钮事件.
         		
		target.save = saveFunc;
		
		 //密码显示事件
        target.showPasswordHandler = function () {
            var checkbox = $("#showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.showPassword(true);
            } else {
                target.showPassword(false);
            }
        };
		
        // 更新当前界面状态、按钮、提示语等.
         			
		function initContronler() {	
            checkRj45DeadTip();		
			if(target.currentMode() == "PPPOE"){
				target.isPppoeMode(true);
				target.isStaticMode(false);
				target.isAutoMode(false);
				target.staticNoticeShow(false);
				target.dhcpNoticeShow(false);	
				target.autoNoticeShow(false);	
			} else if(target.currentMode() == "AUTO"){
				target.isStaticMode(false);
				target.isPppoeMode(false);
				target.isAutoMode(true);
				target.dhcpNoticeShow(false);
				target.pppoeNoticeShow(false);
				target.staticNoticeShow(false);
			} else if(target.currentMode() == "STATIC"){
				target.isStaticMode(true);
				target.isPppoeMode(false);
				target.isAutoMode(false);
				target.dhcpNoticeShow(false);
				target.pppoeNoticeShow(false);
				target.autoNoticeShow(false);
			} else{
				target.isStaticMode(false);
				target.isPppoeMode(false);
				target.isAutoMode(false);
				target.staticNoticeShow(false);
				target.pppoeNoticeShow(false);
                target.autoNoticeShow(false);					
			}
			if(ethParams.ethwan_dialmode != "auto_dial" && (pppObj.rj45_state == "working" || pppObj.rj45_state =="connect") ){
				target.enableFlag(false);
			} else {
				target.enableFlag(true);
			}
			if(pppObj.rj45_state == "connect"){
				if(target.pppMode() == "auto_dial"){
					target.action("connect");
				}else{
					target.action("disconnect");
				}					
			} else if(pppObj.rj45_state == "working"){
				target.action("disconnect");
			}else{
				target.action("connect");
			}
			//应用/连接按钮
			if(target.pppMode() != "auto_dial" && target.currentMode() == ethParams.ethwan_mode){
				target.btnTrans("connect");
			} else{
				target.btnTrans("apply");
			}
			if(pppObj.rj45_state != "idle"){
				$("#pppoeApply").attr("disabled", true);
		    }else {
				$("#pppoeApply").attr("disabled", false);
            }
			
			//取消/断开按钮
			target.isShowDisbtn(target.pppMode() != "auto_dial" && pppObj.rj45_state == "working");
			target.isShowCancelbtn(target.pppMode() != "auto_dial" && pppObj.rj45_state == "connect");
			
			$("#pppoeApply").translate();
		}
        // 设置后通过定时检查rj45_state状态，判断连接或断开操作结果.
         		
	    function setRj45CheckTimer(action){
            checkStatusTimer && window.clearInterval(checkStatusTimer);
            if("connect" != action){				
                checkStatusTimer = addInterval(function () {
                    checkDisconnectStatus();
                }, 2000);
            }else{
                if(target.currentMode() == "PPPOE"){
                    target.pppoeNoticeShow(true);
                    target.pppoeNotice("pppoe_processing");
                    target.pppoeNoticeText($.i18n.prop("pppoe_processing"));
                } else if(target.currentMode() == "STATIC"){
                    target.staticNoticeShow(true);
                    target.staticNotice("static_processing");
                    target.staticNoticeText($.i18n.prop("static_processing"));
                } else if(target.currentMode() == "DHCP"){
                    target.dhcpNoticeShow(true);
                    target.dhcpNotice("dyn_processing");
                    target.dhcpNoticeText($.i18n.prop("dyn_processing"));
                }else{
                    target.autoNoticeShow(true);
                    target.autoNotice("auto_processing");
                    target.autoNoticeText($.i18n.prop("auto_processing"));
                }
                checkStatusTimer = addInterval(function () {
                    checkConnectionStatus();
                }, 2000);
            }			
        }
        // 设置后通过定时检查rj45_state状态，判断连接操作结果.
         			
        function checkConnectionStatus(){
            if(checkConCounter < 1){
				checkConCounter++;
				return;
            }
            if(pppObj.rj45_state == "connect"){
                if(target.currentMode() != ethParams.ethwan_mode){
                    if(target.currentMode() == "AUTO"){
                        target.autoNoticeShow(true);
                    }else if(target.currentMode() == "PPPOE"){
                        target.pppoeNoticeShow(true);
                    }else if(target.currentMode() == "STATIC"){
                        target.staticNoticeShow(true);
                    }else if(target.currentMode() == "DHCP"){
                        target.dhcpNoticeShow(true);
                    }
                }
                if(checkConCounter > 6){
                    if(timeoutTipShowed == false){
                        timeoutTipShowed = true;
                        showAlert("ussd_operation_timeout");
                    }
                }
                checkConCounter++;
            } else if (pppObj.rj45_state == "working") {
                hideLoading();
                setRj45WorkingTip();
                window.clearInterval(checkStatusTimer);						
            } else if (pppObj.rj45_state == "dead") {
				hideLoading();
				checkRj45DeadTip();
                window.clearInterval(checkStatusTimer);
            } else if(pppObj.rj45_state == "idle"){
                hideLoading();
                if(target.currentMode() == "DHCP" && ethParams.ethwan_mode == "DHCP") {
                    timeoutTipShowed == false && target.dhcpNoticeShow(true);
                    target.dhcpNotice("dyn_fail");
                    target.dhcpNoticeText($.i18n.prop("dyn_fail"));
                }
                if(target.currentMode() == "STATIC" && ethParams.ethwan_mode == "STATIC") {
                    timeoutTipShowed == false && target.staticNoticeShow(true);
                    target.staticNotice("static_fail");
                    target.staticNoticeText($.i18n.prop("static_fail"));
                }
                if(target.currentMode() == "PPPOE" && ethParams.ethwan_mode == "PPPOE") {
                    timeoutTipShowed == false && target.pppoeNoticeShow(true);
                    target.pppoeNotice("pppoe_fail");
                    target.pppoeNoticeText($.i18n.prop("pppoe_fail"));
                }
                if(target.currentMode() == "AUTO" && ethParams.ethwan_mode == "AUTO") {
                    timeoutTipShowed == false && target.autoNoticeShow(true);
                    target.autoNotice("auto_fail");
                    target.autoNoticeText($.i18n.prop("auto_fail"));
                }
                window.clearInterval(checkStatusTimer);
            }   else{
                hideLoading();
				window.clearInterval(checkStatusTimer);
			}
        }
		// 设置连接成功时提示语状态.
         		
        function setRj45WorkingTip(){
            if(target.currentMode() == ethParams.ethwan_mode){
                if(target.currentMode() == "AUTO") {
                    target.autoNoticeShow(true);
                    target.autoNotice("auto_success");
                    target.autoNoticeText($.i18n.prop("auto_success"));
                }else if(target.currentMode() == "PPPOE") {
                    target.pppoeNoticeShow(true);
                    target.pppoeNotice("pppoe_success");
                    target.pppoeNoticeText($.i18n.prop("pppoe_success"));
                }else if(target.currentMode() == "STATIC") {
                    target.staticNoticeShow(true);
                    target.staticNotice("static_success");
                    target.staticNoticeText($.i18n.prop("static_success"));
                }else if(target.currentMode() == "DHCP" ) {
                    target.dhcpNoticeShow(true);
                    target.dhcpNotice("dyn_success");
                    target.dhcpNoticeText($.i18n.prop("dyn_success"));
                }
            }
        }
		
		// 设置网线断开提示语状态.
         		
        function checkRj45DeadTip(){
            if(pppObj.rj45_state != "dead"){
                if(target.currentMode() == "AUTO"  && target.autoNotice() == "pppoe_msg") {
                    target.autoNoticeShow(false);
                }else if(target.currentMode() == "PPPOE"  && target.pppoeNotice() == "pppoe_msg") {
                    target.pppoeNoticeShow(false);
                }else if(target.currentMode() == "STATIC"  && target.staticNotice() == "pppoe_msg") {
                    target.staticNoticeShow(false);
                }else if(target.currentMode() == "DHCP" && target.dhcpNotice() == "pppoe_msg") {
                    target.dhcpNoticeShow(false);
                }				
                
            } else{
				target.dhcpNotice("pppoe_msg");
                target.dhcpNoticeText($.i18n.prop("pppoe_msg"));
                target.staticNotice("pppoe_msg");
                target.staticNoticeText($.i18n.prop("pppoe_msg"));
                target.pppoeNotice("pppoe_msg");
                target.pppoeNoticeText($.i18n.prop("pppoe_msg"));
                target.autoNotice("pppoe_msg");
                target.autoNoticeText($.i18n.prop("pppoe_msg"));
                if(target.currentMode() == "AUTO") {
                    target.autoNoticeShow(true);
                }else if(target.currentMode() == "PPPOE") {
                    target.pppoeNoticeShow(true);
                }else if(target.currentMode() == "STATIC") {
                    target.staticNoticeShow(true);
                }else if(target.currentMode() == "DHCP") {
                    target.dhcpNoticeShow(true);
                }
            }            
		}
        // 设置后通过定时检查rj45_state状态，判断断开操作结果.
         		
        function checkDisconnectStatus(){
            if(checkConCounter < 1){
                checkConCounter++;
            } else if (pppObj.rj45_state != "working" && pppObj.rj45_state != "connect") {
                target.dhcpNoticeShow(false);
                target.staticNoticeShow(false);
                target.pppoeNoticeShow(false);
                target.autoNoticeShow(false);
                window.clearInterval(checkStatusTimer);
                successOverlay();
            } else if(checkConCounter > 6){
                if(timeoutTipShowed == false){
                    timeoutTipShowed = true;
                    showAlert("ussd_operation_timeout");
                }
                window.clearInterval(checkStatusTimer);
            } else if(checkConCounter < 7) {
                checkConCounter++;
            } else {
                hideLoading();
                window.clearInterval(checkStatusTimer);
            }				
        }
        
		//应用按钮事件.
		function saveFunc(){
			target.dhcpNoticeShow(false);
			target.staticNoticeShow(false);
			target.pppoeNoticeShow(false);
			target.autoNoticeShow(false);
			if(pppObj.rj45_state == "dead"){
				showAlert("pppoe_msg");
				return;
			}
			var requestParams = {};
			if($("#pppoe_mode").val() == "PPPOE") {
				requestParams = $.extend({}, {
					goformId: "WAN_GATEWAYMODE_PPPOE",
					pppoe_username: target.user(),
					pppoe_cc: target.password()
				});
			} else if($("#pppoe_mode").val() == "AUTO") {
				requestParams = $.extend({}, {
					goformId: "WAN_GATEWAYMODE_AUTO",
					pppoe_username: target.autoUser(),
					pppoe_cc: target.autoPassword()
				});
			} else if($("#pppoe_mode").val() == "STATIC") {
				if(target.ipAddress() == target.defaultGateway()){
					showAlert("ip_gate_not_same");
					return;
				}
				if(isStaticIPValid(target.ipAddress(), pppObj.lan_ipaddr, pppObj.lan_netmask)){
					showAlert("ip_innergate_not_same");
					return;
				}
				requestParams = $.extend({}, {
					goformId: "WAN_GATEWAYMODE_STATIC",
					static_wan_ipaddr: target.ipAddress(),
					static_wan_netmask: target.subnetMask(),
					static_wan_gateway: target.defaultGateway(),
					static_wan_primary_dns: target.primaryDNS(),
					static_wan_secondary_dns: target.secondaryDNS(),
					WAN_MODE: "STATIC"
				});
			} else {
				requestParams = $.extend({}, {
					goformId: "WAN_GATEWAYMODE_DHCP"
				});
			}
			requestParams.action_link = "connect";
			requestParams.dial_mode = target.pppMode();
			showLoading("waiting");
			
			service.setPppoeDialMode(requestParams, function(data){
				if(data.result){
					target.currentMode($("#pppoe_mode").val());
					pppObj = service.getPppoeParams();
					checkConCounter = 0;
					timeoutTipShowed = false;
					setRj45CheckTimer("connect");					
					$("#pppoeApply").translate();
                } else {
					errorOverlay("pppoe_message_send_fail");
                }
			});
			
		}
		
		//取消连接按钮事件.
		function cancelConnectFunc(){
			target.dhcpNoticeShow(false);
			target.staticNoticeShow(false);
			target.pppoeNoticeShow(false);
			target.autoNoticeShow(false);
			if(pppObj.rj45_state == "dead"){
				showAlert("pppoe_msg");
				return;
			}
			var requestParams = {
				dial_mode: target.pppMode(),
				action_link: "disconnect"
			};
			if(pppObj.ethwan_mode == "PPPOE") {
				requestParams = $.extend(requestParams, {
					goformId: "WAN_GATEWAYMODE_PPPOE",
					pppoe_username: pppObj.pppoe_username,
					pppoe_cc: pppObj.pppoe_cc					
				});
			}else if(pppObj.ethwan_mode == "AUTO") {
				requestParams = $.extend(requestParams, {
					goformId: "WAN_GATEWAYMODE_AUTO",
					pppoe_username: pppObj.pppoe_username,
					pppoe_cc: pppObj.pppoe_cc					
				});
			}else if(pppObj.ethwan_mode == "STATIC") {
				requestParams = $.extend(requestParams, {
					goformId: "WAN_GATEWAYMODE_STATIC",
					static_wan_ipaddr: pppObj.static_wan_ipaddr,
					static_wan_netmask: pppObj.static_wan_netmask,
					static_wan_gateway: pppObj.static_wan_gateway,
					static_wan_primary_dns: pppObj.static_wan_primary_dns,
					static_wan_secondary_dns: pppObj.static_wan_secondary_dns,
					WAN_MODE: "STATIC"
				});
			}else {
				requestParams = $.extend(requestParams, {
					goformId: "WAN_GATEWAYMODE_DHCP"
				});
			}
			showLoading("waiting");
			service.setPppoeDialMode(requestParams, function(data){
				if(data.result){
                    checkConCounter = 0;
					timeoutTipShowed = false;
					setRj45CheckTimer("disconnect");
					$("#pppoeApply").translate();
                } else {
					errorOverlay("pppoe_message_send_fail");
                }
			});
			
		}
		
		function radioHandlerFunc(){
			initContronler();
			return true;
		}
		
		function changeModeDivFunc(){
			initContronler();
		}
        
    }

	function bindContainer(vm){
		var container = $('#container');
		ko.cleanNode(container[0]);
		ko.applyBindings(vm, container[0]);
	
	}
    // 联网设置初始化.
     
	function initialize() {
		var vm = new PPPoEViewModel();
		bindContainer(vm);
		
		$("#pppoeApply").translate();
		
		$('#pppoeForm').validate({
			submitHandler : function() {
				vm.save();
			},
            rules: {
                txtPin: "wps_pin_check",
				txtIpAddress: "dmz_ip_check",
				txtSubnetMask: {
					ipv4: true,
                    subnetmask_check: true
				},
				txtDefaultGateway: {
					ipv4: true,
					gateway_check: true
				},
				txtPrimaryDNS: {
					ipv4: true,
					dns_check:true
				},
				txtSecondaryDNS: {
					ipv4: true,
					dns_check:true
				}
            }
		});
	}
	
	
//from 4.0
    // 有效DNS检查.
     
function validateDns(dns){
	if ( "0.0.0.0" == dns || "255.255.255.255" == dns) {
		return false;
	}
	return true;
}
    // 联网设置初始化.
     
function isStaticIPValid(ip, lanip, lanmask){
	if(!ip || !lanip || !lanmask){//各参数不能为空
        return false;
    }
	if(ip == lanip){// 与内网IP相等
		return true;
	}
    var  res1 = [], res2 = [], mask = [];
    addr1 = ip.split(".");
    addr2 = lanip.split(".");
    mask  = lanmask.split(".");
    for(var i = 0; i < addr1.length; i += 1){
        res1.push(parseInt(addr1[i]) & parseInt(mask[i]));
        res2.push(parseInt(addr2[i]) & parseInt(mask[i]));
    }
    if(res1.join(".") == res2.join(".")){//在同一个网段
        return true;
    }else{//不在同一个网段
        return false;
    }
}

// 有效子网掩码验证.
     
function isNetmaskIPValid(ip) {
	if (ip == 255 || ip == 254 || ip == 252 || ip == 248
		|| ip == 240 || ip == 224 || ip == 192 || ip == 128 || ip == 0)
	{
		return true;
	}
	else
	{
		return false;
	}
}
    // 有效子网掩码检查.
     
function validateNetmask(netmask) {
	var array = new Array();
	array = netmask.split(".");

	if (array.length != 4) {
		return false;
	}

	array[0] = parseInt(array[0]);
	array[1] = parseInt(array[1]);
	array[2] = parseInt(array[2]);
	array[3] = parseInt(array[3]);

	if (array[3] != 0) {
		if (array[2] != 255 || array[1] != 255 || array[0] != 255) {
			return false;
		} else {
			if (!isNetmaskIPValid(array[3])) {
				return false;
			}
		}
	}

	if (array[2] != 0) {
		if (array[1] != 255 || array[0] != 255) {
			return false;
		} else {
			if (!isNetmaskIPValid(array[2])) {
				return false;
			}
		}
	}

	if (array[1] != 0) {
		if (array[0] != 255) {
			return false;
		} else{
			if (!isNetmaskIPValid(array[1])) {
				return false;
			}
		}
	}
	if(array[0]!=255) {
		return false;
	}
	if ( "0.0.0.0" == netmask || "255.255.255.255" == netmask) {
		return false;
	}
	return true;
}
    
    // subnetmask_check校验规则
     
jQuery.validator.addMethod("subnetmask_check", function (value, element, param) {
	var result = validateNetmask(value);
    return this.optional(element) || result;
});
    // dns_check校验规则
     
jQuery.validator.addMethod("dns_check", function (value, element, param) {
	var result = validateDns(value);
    return this.optional(element) || result;
});
    // 有效网关检查.
     
function validateGateway(wanIp, netmaskIp, gatewayIp) {
	if(myConcat(wanIp,netmaskIp) == myConcat(netmaskIp, gatewayIp)) {
		return true;
	} else {
		return false;
	}
}
    // IP和子网掩码转换成数组形式并相与，返回相与后的IP.
     
function myConcat(ip1,ip2){
	var result = [];
	var iplArr = ip1.split(".");
	var ip2Arr = ip2.split(".");
	for(var i = 0; i < iplArr.length;i++){
		result[i] = (iplArr[i] & ip2Arr[i]);
	}
	return result.join(".");
}
    // gateway_check校验规则
     
jQuery.validator.addMethod("gateway_check", function (value, element, param) {
	var result = validateGateway($('#txtIpAddress').val(), $('#txtSubnetMask').val(), $("#txtDefaultGateway").val());
    return this.optional(element) || result;
});
	
	return {
		init: initialize
	};
});
//联网设置模块
define("network_dial_set","underscore jquery knockout set service".split(" "),
function(_, $, ko, config, service) {

    //联网设置view model
	function DialVM() {
		var dialMode = service.getConnectionMode();
		var target = this;

		target.selectMode = ko.observable(dialMode.connectionMode);
        target.enableFlag = ko.observable(true);
        target.isAllowedRoaming = ko.observable(dialMode.isAllowedRoaming);
        var originalRoaming = dialMode.isAllowedRoaming;

        target.setAllowedRoaming = setAllowedRoamingFunc;
		
		var checkboxFlag = $(".checkboxToggle");
        target.checkEnable = checkEnableFunc;
		
        //修改联网模式
        target.save = saveFunc;
		
		function saveFunc() {
            showLoading();
            var connMode = target.selectMode();
            //当选择自动时，下发原先的勾选状态
            if (connMode == 'auto_dial') {
                originalRoaming = target.isAllowedRoaming();
            } else {
                target.isAllowedRoaming(originalRoaming);
            }
            service.setConnectionMode({
                connectionMode: connMode,
                isAllowedRoaming: target.isAllowedRoaming()
            }, function (result) {
                if (result.result == "success") {
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        }
		
		function setAllowedRoamingFunc() {
            if(!$("#roamBtn").hasClass("disable")){
                var checkbox = $("#isAllowedRoaming:checked");
                if(checkbox && checkbox.length == 0 ){
                    target.isAllowedRoaming("on");
                }else{
                    target.isAllowedRoaming("off");
                }
            }
        }
		
		function checkEnableFunc() {
            var status = service.getStatusInfo();

            if (status.connectStatus == "ppp_connected" || status.connectStatus == "ppp_connecting") {
                target.enableFlag(false);
                disableCheckbox(checkboxFlag);
            }
            else {
                target.enableFlag(true);
                enableCheckbox(checkboxFlag);
            }
        }

	}

    //联网设置初始化.
	function initialize() {
		var vm = new DialVM();
		bindContainer(vm);
		
        vm.checkEnable();
        addInterval( vm.checkEnable, 1000);
	}
	
	function bindContainer(vm){
		var container = $('#container');
		ko.cleanNode(container[0]);
		ko.applyBindings(vm, container[0]);
	
	}
	
	return {
		init: initialize
	};
});
// APN Setting 模块
define("network_apn_set","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    //获取鉴权方式
     
    function getAuthModes() {
        return _.map(config.APN_AUTH_MODES, function (item) {
            return new Option(item.name, item.value);
        });
    }

    function getApnPdpTypes() {
        var pdpTypesArray = [new Option('IPv4', 'IP')];
        if (config.IPV6_SUPPORT) {
            pdpTypesArray.push(new Option('IPv6', 'IPv6'));
            if (config.IPV4V6_SUPPORT) {
                pdpTypesArray.push(new Option('IPv4v6', 'IPv4v6'));
            }
            if (config.IPV4_AND_V6_SUPPORT) {
                pdpTypesArray.push(new Option('IPv4 & IPv6', 'IPv4v6'));
            }
        }
        return pdpTypesArray;
    }

    //获取apn相关信息
     
    function getApnSet() {
        var apnInfo = service.getApnSettings();
        apnInfo.ipv6ApnConfigs = getApnConfigs(apnInfo.ipv6APNs, true);
        apnInfo.apnConfigs = getApnConfigs(apnInfo.APNs, false);
        apnInfo.autoApnConfigs = getAutoApnsConfig(apnInfo.autoApns, apnInfo.autoApnsV6);
        return apnInfo;
    }
    var apnConfigs = {};
    var ipv6ApnConfigs = {};
    var autoApnConfigs = {};

    //解析自动apn信息
     
    function getAutoApnsConfig(autoApnV4, autoApnV6) {
        var autoApnsV4 = [];
        var autoApnsV6 = [];

        if (autoApnV4 && autoApnV4.length > 5) {
            var apnArr = autoApnV4.split("||");
            for (var ki = 0; ki < apnArr.length; ki++) {
                if (apnArr[ki] != "") {
                    var apnItem = parseApnItem(apnArr[ki], false);
                    autoApnsV4.push(apnItem);
                }
            }
        }
        if (autoApnV6 && autoApnV6.length > 5) {
            var apnArr = autoApnV6.split("||");
            for (var ki = 0; ki < apnArr.length; ki++) {
                if (apnArr[ki] != "") {
                    var apnItem = parseApnItem(apnArr[ki], false);
                    autoApnsV6.push(apnItem);
                }
            }
        }
        return dealAutoApnsV4V6(autoApnsV4, autoApnsV6);
    }
    //解析apn信息
     
    function getApnConfigs(apnsStr, isIpv6) {
        var apnCfgs = [];
        var theApnConfigs = {};
        if (apnsStr && apnsStr.length > 10) {
            var apnArr = apnsStr.split("||");
            for (var ki = 0; ki < apnArr.length; ki++) {
                if (apnArr[ki] != "") {
                    var apnItem = parseApnItem(apnArr[ki], isIpv6);
                    apnCfgs.push(apnItem);
                    theApnConfigs[apnItem.profileName] = apnItem;
                }
            }
        }
        if (isIpv6 == false) {
            apnConfigs = theApnConfigs;
        } else {
            ipv6ApnConfigs = theApnConfigs;
        }
        return apnCfgs;
    }

	//解析单条apn信息
     
    function parseApnItem(apnStr, isIpv6) {
        var apnItem = {};
        var items = apnStr.split("($)");
        for (var ki = 0; ki < items.length; ki++) {
            apnItem.profileName = items[0];
            apnItem.pdpType = items[7];
            if (isIpv6 == false) {	
                apnItem.dnsMode = items[10];
                apnItem.dns1 = items[11];
                apnItem.dns2 = items[12];
                apnItem.wanApn = items[1];
                apnItem.authMode = items[4].toLowerCase();
                apnItem.username = items[5];
                apnItem.password = items[6];
            } else {		
                apnItem.dnsModeV6 = items[10];
                apnItem.dns1V6 = items[11];
                apnItem.dns2V6 = items[12];
                apnItem.wanApnV6 = items[1];
                apnItem.authModeV6 = items[4].toLowerCase();
                apnItem.usernameV6 = items[5];
                apnItem.passwordV6 = items[6];
            }
        }
        return apnItem;
    }
    //合并V4\V6自动apn信息
     
    function dealAutoApnsV4V6(v4, v6) {
        autoApnConfigs = {};
        var autoApns = [];
        for (var ki = 0; ki < v4.length; ki++) {
            var apnElem = v4[ki];
            var itemsV6 = v6[ki];
            if (itemsV6 && (itemsV6.pdpType == 'IPv6' || itemsV6.pdpType == 'IPv4v6')) {
                apnElem.usernameV6 = itemsV6.username;
                apnElem.passwordV6 = itemsV6.password;
                apnElem.dns1V6 = itemsV6.dns1;
                apnElem.dns2V6 = itemsV6.dns2;
                apnElem.wanApnV6 = itemsV6.wanApn;
                apnElem.authModeV6 = itemsV6.authMode;
                apnElem.dnsModeV6 = itemsV6.dnsMode;
            }
            autoApns.push(apnElem);
            autoApnConfigs[apnElem.profileName] = apnElem;
        }
        return autoApns;
    }

    function getProfileOptions(apns) {
        return _.map(apns, function (item) {
            return new Option(item.profileName, item.profileName);
        });
    }

    //APNViewModel
     
    function APNViewModel() {
        var target = this;
        var apnSettings = getApnSet();
        if (apnSettings.apnNumPreset) {
            config.maxApnNumber = apnSettings.apnNumPreset;
        }

        target.defApn = ko.observable(apnSettings.profileName); //当前默认APN
        target.apnMode = ko.observable(apnSettings.apnMode);
        target.autoProfiles = ko.observableArray(getProfileOptions(apnSettings.autoApnConfigs));
        target.profiles = ko.observableArray(getProfileOptions(apnSettings.apnConfigs));
        target.wanDial = ko.observable(apnSettings.wanDial);
		
        target.showApnDns = ko.observable(config.SHOW_APN_DNS);
        target.index = ko.observable(apnSettings.currIndex);
        target.supportIPv6 = ko.observable(config.IPV6_SUPPORT);
        target.supportIpv4AndIpv6 = ko.observable(config.IPV4_AND_V6_SUPPORT);

        target.apn = ko.observable(apnSettings.wanApn);
        target.dnsMode = ko.observable(apnSettings.dnsMode == 'manual' ? 'manual' : 'auto');
        target.dns1 = ko.observable(apnSettings.dns1);
        target.dns2 = ko.observable(apnSettings.dns2);
        target.authModes = ko.observableArray(getAuthModes());
        target.username = ko.observable(apnSettings.username);
        target.password = ko.observable(apnSettings.password);
		
        target.pdpTypes = ko.observableArray(getApnPdpTypes());
        target.selectedPdpType = ko.observable(apnSettings.pdpType);
        target.selectedPdpTypeTmp = ko.observable(apnSettings.pdpType); //the PdpType select's value before chang
        target.profileName = ko.observable(apnSettings.profileName); //当前编辑框中的
        target.selectedProfile = ko.observable(apnSettings.profileName); //当前下拉框选择的APN

        target.showPassword = ko.observable(false);

        target.apnV6 = ko.observable(apnSettings.wanApnV6);
        target.dnsModeV6 = ko.observable(apnSettings.dnsModeV6 == 'manual' ? 'manual' : 'auto');
        target.dns1V6 = ko.observable(apnSettings.dns1V6);
        target.dns2V6 = ko.observable(apnSettings.dns2V6);
        target.authModesV6 = ko.observableArray(getAuthModes());
        target.usernameV6 = ko.observable(apnSettings.usernameV6);
        target.passwordV6 = ko.observable(apnSettings.passwordV6);
        target.pdpTypeNote = ko.observable(true);
        if (apnSettings.autoApnConfigs && apnSettings.autoApnConfigs.length > 0) {
            target.selectedAutoProfile = ko.observable(apnSettings.autoApnConfigs[0].profileName);
        } else {
            target.selectedAutoProfile = ko.observable();
        }

        if (config.EMPTY_APN_SUPPORT == false) {
            $("#apn_ipv4_apn").addClass("required");
            $("#apn_ipv6_apn").addClass("required");
        } else {
            $("#apn_ipv4_apn").removeClass("required");
            $("#apn_ipv6_apn").removeClass("required");
        }
		
        target.disableProfile = ko.observable(false); //表示处于新增页面
        target.addApnHide = ko.observable(true);
        target.defaultCfg = ko.observable(true); //当前选中的是默认APN
        target.predeterminedCfg = ko.observable(true); //当前选中的是预置的APN
		
        target.selectedAuthentication = ko.observable(apnSettings.authMode);
        target.selectedAuthenticationV6 = ko.observable(apnSettings.authModeV6);


        target.transApnV6 = ko.observable('apn');
        target.transDnsModeV6 = ko.observable('apn_dns_mode');
        target.transDns1V6 = ko.observable('apn_dns1');
        target.transDns2V6 = ko.observable('apn_dns2');
        target.transAuthV6 = ko.observable('apn_authentication');
        target.transUserNameV6 = ko.observable('apn_user_name');
        target.transPasswordV6 = ko.observable('apn_password');
		
        target.transApn = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_ipv4_apn' : 'apn');
        target.transDnsMode = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_dns_mode_ipv4' : 'apn_dns_mode');
        target.transDns1 = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_dns1_ipv4' : 'apn_dns1');
        target.transDns2 = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_dns2_ipv4' : 'apn_dns2');
        target.transAuth = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_authentication_ipv4' : 'apn_authentication');
        target.transUserName = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_user_name_ipv4' : 'apn_user_name');
        target.transPassword = ko.observable(config.IPV4_AND_V6_SUPPORT ? 'apn_password_ipv4' : 'apn_password');

        target.setDefaultVisible = ko.observable(!isConnectedNetWork());

        target.tmp1 = ko.computed(function () {
             if (target.selectedPdpType() == "IPv6") {
                target.transApnV6('apn');
                target.transDnsModeV6('apn_dns_mode');
                target.transDns1V6('apn_dns1');
                target.transDns2V6('apn_dns2');
                target.transAuthV6('apn_authentication');
                target.transUserNameV6('apn_user_name');
                target.transPasswordV6('apn_password');
            } else if (config.IPV4_AND_V6_SUPPORT && target.selectedPdpType() == 'IPv4v6') {
                target.transApn('apn_ipv4_apn');
                target.transDnsMode('apn_dns_mode_ipv4');
                target.transDns1('apn_dns1_ipv4');
                target.transDns2('apn_dns2_ipv4');
                target.transAuth('apn_authentication_ipv4');
                target.transUserName('apn_user_name_ipv4');
                target.transPassword('apn_password_ipv4');

                target.transApnV6('apn_ipv6_apn');
                target.transDnsModeV6('apn_dns_mode_ipv6');
                target.transDns1V6('apn_dns1_ipv6');
                target.transDns2V6('apn_dns2_ipv6');
                target.transAuthV6('apn_authentication_ipv6');
                target.transUserNameV6('apn_user_name_ipv6');
                target.transPasswordV6('apn_password_ipv6');
            } else if (target.selectedPdpType() == "IP" || target.selectedPdpType() == "IPv4") {
                target.transApn('apn');
                target.transDnsMode('apn_dns_mode');
                target.transDns1('apn_dns1');
                target.transDns2('apn_dns2');
                target.transAuth('apn_authentication');
                target.transUserName('apn_user_name');
                target.transPassword('apn_password');
            } else { //config.IPV4V6_SUPPORT && target.selectedPdpType() == 'IPv4v6'
                target.transApn('apn');
                target.transDnsMode('apn_dns_mode');
                target.transDns1('apn_dns1');
                target.transDns2('apn_dns2');
                target.transAuth('apn_authentication');
                target.transUserName('apn_user_name');
                target.transPassword('apn_password');
            }
            $("#apn_setting_form").translate();
        });

        target.autoApnChecked = ko.computed(function () {
            return target.apnMode() == "auto";
        });
		
        target.hasCapacity = ko.computed(function () {
            if (target.profiles().length < config.maxApnNumber) {
                return true;
            } else {
                return false;
            }
        });

        target.showDnsV6 = ko.computed(function () {
            return target.dnsModeV6() == "manual";
        });
		
        target.showDns = ko.computed(function () {
            return target.dnsMode() == "manual";
        });


        checkDefaultProfileStatus();
        target.checkInputDisable = ko.computed(function () {
            if (target.apnMode() != "auto"  && (target.predeterminedCfg() == false && target.defaultCfg() == true) && !isConnectedNetWork()) {
                return false;
            }
            if (((target.apnMode() != "auto" && (target.predeterminedCfg() || target.defaultCfg()) && !target.disableProfile())) || target.apnMode() == "auto") {
                return true;
            }
            if ((!target.disableProfile() || !(target.predeterminedCfg() || target.defaultCfg())) && target.apnMode() != "auto") {
                return false;
            }
            return false;
        });

        var data = service.getDeviceInfo();
        target.pdpTypeChangeAlert = pdpTypeChangeAlertFunc;
		

        target.showAutoApnDetail = ko.computed(function () {
            if (target.apnMode() != "auto") {
                return true;
            } else {
                return target.autoProfiles().length > 0;
            }
        });
		//密码显示事件
        target.showPasswordHandler = function () {
            var checkbox = $("#showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.showPassword(true);
            } else {
                target.showPassword(false);
            }
        };
		//auto apn profile change 事件处理
         
        target.autoProfileChangeHandler = autoProfileChangeHandlerFunc;
		
		
        //profile change 事件处理
         
        target.profileChangeHandler = profileChangeHandlerFunc;
		
        
        //切换profile时重置下面的显示项
        target.setUIData = setUIDataFunc;
		

        //设置默认apn状态
         
        function checkDefaultProfileStatus() {
            var index = getApnIndex();
            //默认apn不允许编辑
            if (target.apnMode() != "auto") { //当前选中与实际不一致的话
                if (target.selectedProfile() != target.defApn()) {
                    target.defaultCfg(false);
                } else {
                    target.defaultCfg(true); //默认APN
                }
            } else {
                if (target.selectedAutoProfile() != target.defApn()) {
                    target.defaultCfg(false);
                } else {
                    target.defaultCfg(true); //默认APN
                }
            }

            if (index >= config.defaultApnSize) {
                target.predeterminedCfg(false);
            } else {
                target.predeterminedCfg(true); //预置APN
            }
        }


        //设置为默认apn
         
        target.setDefaultAct = setDefaultActFunc;
		

		
        //APN mode change 事件处理
         
        target.apnModeChangeHandler = apnModeChangeHandlerFunc;
		
		
        function doSetDefaultAct() {
            var index = 0;
            if (target.apnMode() != 'auto') {
                index = getApnIndex();
                target.selectedProfile($("#profile").val());
            } else {
                index = getAutoApnIndex();
                target.selectedAutoProfile($("#autoProfile").val());
            }
            var selectedProfileDetail = target.getSelectedManualProfile();
            service.setDefaultApn({
                index: index,
                apnMode: target.apnMode(),
                pdpType: selectedProfileDetail.pdpType,

                profileName: selectedProfileDetail.profileName,
                wanApn: selectedProfileDetail.wanApn,
                authMode: selectedProfileDetail.authMode,
                username: selectedProfileDetail.username,
                password: selectedProfileDetail.password,
                dnsMode: config.SHOW_APN_DNS ? selectedProfileDetail.dnsMode : 'auto',
                dns1: config.SHOW_APN_DNS ? selectedProfileDetail.dns1 : '',
                dns2: config.SHOW_APN_DNS ? selectedProfileDetail.dns2 : ''
            }, function (data) {
                if (data.result) {
                    //showLoading("apn_alert_restart");
                    //restartDevice(service);
                    addTimeout(function () {
                        initialize(true);
                        target.apnModeChangeHandler();
                        successOverlay();
                    }, 500);
                } else {
                    errorOverlay();
                }
            }, function (data) {
                errorOverlay();
            });
        }

        target.getSelectedManualProfile = getSelectedManualProfileFunc;
		

        //获取自动apn索引
         
        function getAutoApnIndex() {
            var configs = $("#autoProfile option");
            for (var ki = 0; ki < configs.length; ki++) {
                if (configs[ki].value == target.selectedAutoProfile()) {
                    return ki;
                }
            }
            return configs.length - 1;
        }
		
		//获取apn索引
         
        function getApnIndex() {
            var configs = $("#profile option");
            if (configs.length == 0) {
                configs = target.profiles();
            }
            var ki = 0;
            for (; ki < configs.length; ki++) {
                if (configs[ki].value == target.selectedProfile()) {
                    break;
                }
            }
            return ki;
        }

        //保存APN设置信息
         
        target.saveAct = saveActFunc;
		
		//编辑APN信息
         
        function editApnSetting(preAct) { //默认设置按钮触发为TRUE
            showLoading();
            var apnIndex = getApnIndex();
            var sameInfo = false;
            if (config.IPV4V6_SUPPORT && target.selectedPdpType() == 'IPv4v6') {
                sameInfo = true;
            }
            var needDoDefault = false;
            if (preAct || (target.predeterminedCfg() || target.defaultCfg())) {
                needDoDefault = true;
            }
            service.addOrEditApn({
                profileName: target.profileName(),
                pdpType: target.selectedPdpType(),
                index: apnIndex,

                wanApn: target.apn(),
                authMode: target.selectedAuthentication(),
                username: target.username(),
                password: target.password(),
                dnsMode: config.SHOW_APN_DNS ? target.dnsMode() : 'auto',
                dns1: config.SHOW_APN_DNS ? target.dns1() : '',
                dns2: config.SHOW_APN_DNS ? target.dns2() : '',

                wanApnV6: sameInfo ? target.apn() : target.apnV6(),
                authModeV6: sameInfo ? target.selectedAuthentication() : target.selectedAuthenticationV6(),
                usernameV6: sameInfo ? target.username() : target.usernameV6(),
                passwordV6: sameInfo ? target.password() : target.passwordV6(),
                dnsModeV6: config.SHOW_APN_DNS ? (sameInfo ? target.dnsMode() : target.dnsModeV6()) : 'auto',
                dns1V6: config.SHOW_APN_DNS ? (sameInfo ? target.dns1() : target.dns1V6()) : '',
                dns2V6: config.SHOW_APN_DNS ? (sameInfo ? target.dns2() : target.dns2V6()) : ''
            }, function (data) {
                if (data.result) {
                    apnSettings = getApnSet();
                    if (target.profileName() != target.selectedProfile()) {
                        var newProfileName = target.profileName();
                        target.profiles(getProfileOptions(apnSettings.apnConfigs));
                        $('#profile').val(newProfileName).trigger('change');
                    }
                    if (needDoDefault == false) {
                        successOverlay();
                    } else {
                        doSetDefaultAct();
                    }
                } else {
                    errorOverlay();
                }
            }, function (data) {
                errorOverlay();
            });
        }
		
        //新增APN信息
         
        function addNewApnSetting() {
            showLoading("waiting");
            var optionLen = $("option", "#profile").length;
            if (optionLen < config.defaultApnSize) {
                errorOverlay();
                return;
            }
            // 支持IPv4v6，并且选择IPv4v6时，IPv4 与 IPv6下发相同的信息
            // 支持IPv4 & v6，并且选择IPv4v6时，IPv4 与 IPv6下发各自的信息
            var sameInfo = false;
            if (config.IPV4V6_SUPPORT && target.selectedPdpType() == 'IPv4v6') {
                sameInfo = true;
            }

            service.addOrEditApn({
                profileName: target.profileName(),
                pdpType: target.selectedPdpType(),
                index: optionLen,

                wanApn: target.apn(),
                authMode: target.selectedAuthentication(),
                username: target.username(),
                password: target.password(),
                dnsMode: config.SHOW_APN_DNS ? target.dnsMode() : 'auto',
                dns1: config.SHOW_APN_DNS ? target.dns1() : '',
                dns2: config.SHOW_APN_DNS ? target.dns2() : '',

                wanApnV6: sameInfo ? target.apn() : target.apnV6(),
                authModeV6: sameInfo ? target.selectedAuthentication() : target.selectedAuthenticationV6(),
                usernameV6: sameInfo ? target.username() : target.usernameV6(),
                passwordV6: sameInfo ? target.password() : target.passwordV6(),
                dnsModeV6: config.SHOW_APN_DNS ? (sameInfo ? target.dnsMode() : target.dnsModeV6()) : 'auto',
                dns1V6: config.SHOW_APN_DNS ? (sameInfo ? target.dns1() : target.dns1V6()) : '',
                dns2V6: config.SHOW_APN_DNS ? (sameInfo ? target.dns2() : target.dns2V6()) : ''
            }, function (data) {
                if (data.result) {
                    apnSettings = getApnSet();
                    if (target.profileName() != target.selectedProfile()) {
                        var newProfileName = target.profileName();
                        target.profiles(getProfileOptions(apnSettings.apnConfigs));
                        $('#profile').val(newProfileName).trigger('change');
                    }
                    doSetDefaultAct();
                } else {
                    errorOverlay();
                }
            }, function (data) {
                errorOverlay();
            });
        }

        

        var tempApn = {};
		//删除APN
         
        target.deleteAct = deleteActFunc;
		
		//取消新增APN
         
        target.cancelAddAct = cancelAddActFunc;
		
        //进入新增APN页面
         
        target.addAct = addActFunc;
		//进入新增APN页面
		function addActFunc() {
            clearValidateMsg('#apn_setting_form');
            target.pdpTypeNote(true);
            target.disableProfile(true);
            target.addApnHide(true);
            tempApn = {
                profileName: target.profileName(),
                selectedPdpType: target.selectedPdpType(),

                wanApnV6: target.apnV6(),
                dnsModeV6: config.SHOW_APN_DNS ? target.dnsModeV6() : 'auto',
                dns1V6: config.SHOW_APN_DNS ? target.dns1V6() : '',
                dns2V6: config.SHOW_APN_DNS ? target.dns2V6() : '',
                authModeV6: target.selectedAuthenticationV6(),
                usernameV6: target.usernameV6(),
                passwordV6: target.passwordV6(),
				
                wanApn: target.apn(),
                dnsMode: config.SHOW_APN_DNS ? target.dnsMode() : 'auto',
                dns1: config.SHOW_APN_DNS ? target.dns1() : '',
                dns2: config.SHOW_APN_DNS ? target.dns2() : '',
                authMode: target.selectedAuthentication(),
                username: target.username(),
                password: target.password(),

            };
            target.profileName("");
            target.selectedPdpType("IP");
            target.selectedPdpTypeTmp("IP");

            target.apnV6("");
            target.dnsModeV6("auto");
            target.dns1V6("");
            target.dns2V6("");
            target.selectedAuthenticationV6("none");
            target.usernameV6("");
            target.passwordV6("");
			
            target.apn("");
            target.dnsMode("auto");
            target.dns1("");
            target.dns2("");
            target.selectedAuthentication("none");
            target.username("");
            target.password("");

        }
		
		//取消新增APN
		function cancelAddActFunc() {
            clearValidateMsg('#apn_setting_form');
            target.pdpTypeNote(false);
            target.disableProfile(false);
            target.addApnHide(false);
            target.profileName(tempApn.profileName);
            target.selectedPdpType(tempApn.selectedPdpType);
            target.selectedPdpTypeTmp(tempApn.selectedPdpType);

            target.apnV6(tempApn.wanApnV6);
            target.dnsModeV6(tempApn.dnsModeV6);
            target.dns1V6(tempApn.dns1V6);
            target.dns2V6(tempApn.dns2V6);
            target.selectedAuthenticationV6(tempApn.authModeV6);
            target.usernameV6(tempApn.usernameV6);
            target.passwordV6(tempApn.passwordV6);
			
            target.apn(tempApn.wanApn);
            target.dnsMode(tempApn.dnsMode);
            target.dns1(tempApn.dns1);
            target.dns2(tempApn.dns2);
            target.selectedAuthentication(tempApn.authMode);
            target.username(tempApn.username);
            target.password(tempApn.password);

        }
		
		//删除APN
		function deleteActFunc() {
            if (!target.selectedProfile()) {
                showAlert("apn_no_select_alert");
                return false;
            }
            if (target.predeterminedCfg()) { //预置的apn不允许删除
                errorOverlay("apn_delete_cant_delete_default");
                return false;
            }
            if (getApnSet().profileName == target.profileName()) {
                errorOverlay("apn_cant_delete_current");
                return false;
            }

            showConfirm("apn_delete_confirm", function () {
                showLoading('deleting');
                service.deleteApn({
                    index: getApnIndex()
                }, function (data) {
                    if (data.result) {
                        target.profiles(getProfileOptions(getApnSet().apnConfigs));
                        target.selectedProfile(target.defApn());
                        target.profileChangeHandler();
                        successOverlay();
                    } else {
                        errorOverlay();
                    }
                }, function (data) {
                    errorOverlay();
                });
            });
        }
		
		//保存APN设置信息
		function saveActFunc() {
            if (!$('#apn_setting_form').valid()) {
                return false;
            }
            if (!target.selectedProfile() && !target.disableProfile()) { //不是增加时的设置需要判断是否选择了Profile
                showAlert("apn_no_select_alert");
                return false;
            }
            var exist = false;
            $.each(target.profiles(), function (i, e) {
                if (e.value == target.profileName()) {
                    exist = true;
                }
            });

            if (target.disableProfile() == false) {
                if (exist && target.selectedProfile() != target.profileName()) {
                    showInfo("apn_save_profile_exist");
                    return false;
                }
                if (target.predeterminedCfg()) { //预置的APN不可以修改
                    errorOverlay();
                    return false;
                }
                if (target.predeterminedCfg() || target.defaultCfg()) {
                    //showConfirm("apn_alert", function () {
                    editApnSetting(false);
                    //});
                } else {
                    editApnSetting(false);
                }
            } else {
				
                if ($("#profile option").length >= config.maxApnNumber) {
                    showInfo({
                        msg: "apn_profile_full",
                        params: [config.maxApnNumber]
                    });
                    return false;
                }
                if (exist) {
                    showInfo("apn_save_profile_exist");
                    return false;
                }
                var info = service.getStatusInfo();
                if (info.connectStatus != "ppp_connected") {
                    //showConfirm("apn_alert", function () {
                    addNewApnSetting();
                    //});
                    
                } else {
					showConfirm("apn_diconneted_network_confirm", function () {
                        showLoading('disconnecting');
                        service.disconnect({}, function (data) {
                            if (data.result) {
                                config.connect_flag = true;
                                addNewApnSetting();
                            } else {
                                errorOverlay();
                            }
                        });
                    });
                }
            }
        }
		
		function getSelectedManualProfileFunc() {
            var cfg = {};
            var profileVal = $("#profile").val();
            if (typeof target.selectedProfile() == 'undefined') {
                target.selectedProfile(profileVal);
            }
            var cfgV4 = apnConfigs[profileVal];
            var cfgV6 = ipv6ApnConfigs[profileVal];
            if (cfgV4 && !cfgV6) {
                $.extend(cfg, cfgV4);
            } else if (cfgV4 && cfgV6) {
                if (!!cfgV4.pdpType) {
                    $.extend(cfg, cfgV6);
                    $.extend(cfg, cfgV4);
                } else {
                    $.extend(cfg, cfgV4);
                    $.extend(cfg, cfgV6);
                }
            }
            return cfg;
        }
		
		//APN mode change 事件处理
		function apnModeChangeHandlerFunc(data, event) {
            if (target.apnMode() != 'auto') {
                target.profileChangeHandler();
            } else {
                if (target.showAutoApnDetail()) {
                    target.autoProfileChangeHandler();
                }
            }
            return true;
        }
		
		//设置为默认apn
		function setDefaultActFunc() {
            if (!target.selectedProfile()) {
                showAlert("apn_no_select_alert");
                return false;
            }
            var connectStatus = service.getConnectionInfo().connectStatus;
             if (connectStatus == "ppp_connecting") {
                showAlert({
                    msg: "apn_cant_modify_status",
                    params: [$.i18n.prop("connecting").toLowerCase()]
                });
                return false;
            } else if (connectStatus == "ppp_disconnecting") {
                showAlert({
                    msg: "apn_cant_modify_status",
                    params: [$.i18n.prop("disconnecting").toLowerCase()]
                });
                return false;
            } else if (connectStatus == "ppp_connected") {
                showAlert({
                    msg: "apn_cant_modify_status",
                    params: [$.i18n.prop("connected").toLowerCase()]
                });
                return false;
            }
            if (target.apnMode() == 'auto' || target.predeterminedCfg()) {
                //showConfirm("apn_alert", function () {
                showLoading("waiting");
                doSetDefaultAct();
                //});
            } else {
                if ($('#apn_setting_form').valid() == false) {
                    $(".error:first", "#apn_setting_form").focus();                    
                } else {
					var exist = false;
                    $.each(target.profiles(), function (i, e) {
                        if (e.value == target.profileName()) {
                            exist = true;
                        }
                    });
                    if (exist && target.selectedProfile() != target.profileName()) {
                        showInfo("apn_save_profile_exist");
                        return false;
                    }
                    //showLoading("waiting");
                    //showConfirm("apn_alert", function () {
                    editApnSetting(true);
                    //});
                }
            }
        }
		
		//切换profile时重置下面的显示项
		function setUIDataFunc(data) {
            clearValidateMsg('#apn_setting_form');
            if (!data) {
                return;
            }
            target.selectedPdpType(data.pdpType || 'IP');
            target.selectedPdpTypeTmp(data.pdpType || 'IP');
            target.profileName(data.profileName);

            target.apn(data.wanApn);
            target.dnsMode(data.dnsMode != 'manual' ? 'auto' : 'manual');
            target.dns1(data.dns1);
            target.dns2(data.dns2);
            target.username(data.username);
            target.password(data.password);
            target.selectedAuthentication(data.authMode || 'none');

            target.apnV6(data.wanApnV6);
            target.dnsModeV6(data.dnsModeV6 != 'manual' ? 'auto' : 'manual');
            target.dns1V6(data.dns1V6);
            target.dns2V6(data.dns2V6);
            target.usernameV6(data.usernameV6);
            target.passwordV6(data.passwordV6);
            target.selectedAuthenticationV6(data.authModeV6 || 'none');
        }
		
		//profile change 事件处理
		function profileChangeHandlerFunc(data, event) {
            target.pdpTypeNote(true);
            if (target.apnMode() != 'manual') {
                return true;
            }
            var cfg = target.getSelectedManualProfile();
            target.setUIData(cfg);
            checkDefaultProfileStatus();
            return true;
        }
		
		//auto apn profile change 事件处理
		function autoProfileChangeHandlerFunc(data, event) {
            if (target.apnMode() != 'auto') {
                return true;
            }
            var cfg = autoApnConfigs[target.selectedAutoProfile()];
            target.setUIData(cfg);
            checkDefaultProfileStatus();
            return true;
        }
		
		function pdpTypeChangeAlertFunc() {
            if (target.pdpTypeNote()) {
                showAlert({
                    msg: "apn_pdptype_change_note",
                    params: [data.lanDomain, data.ipAddress]
                });
            }
            if (target.apnMode() != "auto" && !target.disableProfile()) { //如果是手动非ADD状态，切换PDP类型时，不改变界面显示的各项值
                if ((config.IPV4_AND_V6_SUPPORT && target.selectedPdpTypeTmp() != 'IPv4v6' && target.selectedPdpType() != 'IPv4v6') || !config.IPV4_AND_V6_SUPPORT) { //
                    if (target.selectedPdpTypeTmp() == 'IPv6') { //V6 -> V4 / V4V6
                        target.apn(target.apnV6());
                        target.dnsMode(target.dnsModeV6());
                        target.dns1(target.dns1V6());
                        target.dns2(target.dns2V6());
                        target.username(target.usernameV6());
                        target.password(target.passwordV6());
                        target.selectedAuthentication(target.selectedAuthenticationV6());
                    } else if (target.selectedPdpType() == 'IPv6') { //V4 / V4V6 -> V6
                        target.apnV6(target.apn());
                        target.dnsModeV6(target.dnsMode());
                        target.dns1V6(target.dns1());
                        target.dns2V6(target.dns2());
                        target.usernameV6(target.username());
                        target.passwordV6(target.password());
                        target.selectedAuthenticationV6(target.selectedAuthentication());
                    }
                }
            }
            target.selectedPdpTypeTmp(target.selectedPdpType());
        }
       

    }

    //是否已联网
     
    function isConnectedNetWork() {
        var info = service.getConnectionInfo();
        return info.connectStatus == "ppp_connected";
    }

    function initVar() {
        apnConfigs = {};
        ipv6ApnConfigs = {};
        autoApnConfigs = {};
    }
	function bindContainer(vm){
		var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(vm, container[0]);
	}
    //初始化ViewModel
     
    function initialize(formInit) {
        initVar();
        
        var vm = new APNViewModel();
		bindContainer(vm);

        if (!formInit) {
            addInterval(function () {
                vm.setDefaultVisible(!isConnectedNetWork());
            }, 1000);
        }
        $('#apn_setting_form').validate({
            submitHandler: function () {
                vm.saveAct();
            },
            rules: {
                profile_name: 'apn_profile_name_check',
                apn_ipv4_apn: 'apn_check',
                apn_dns1_ipv4: "ipv4",
                apn_dns2_ipv4: "ipv4",
                apn_ipv6_apn: 'apn_check',
                apn_dns1_ipv6: "ipv6",
                apn_dns2_ipv6: "ipv6",
                apn_user_name_ipv4: 'ppp_username_check',
                apn_secretcode_ipv4: 'ppp_secretcode_check',
                apn_user_name_ipv6: 'ppp_username_check',
                apn_secretcode_ipv6: 'ppp_secretcode_check'
            }
        });
    }

    return {
        init: initialize
    };
});