define("wifi_advance","underscore jquery knockout set service jqui".split(" "),
    function (_, $, ko, config, service, jqui) {
    var $sliderRange = null;
    //当前是否WiFi连接
    var viaWifi = false;

    function paintRateOption(data) {
        var opts = [];
        for (var i = 0; i < data.length; i++) {
            var rate = data[i].rate == 0 ? "Auto" : data[i].rate + " Mbps";
            opts.push(new Option(rate, data[i].index));
        }
        return opts;
    }

    //wifi传输速率
    var transpeed = [0, 1, 2, 5.5, 6, 6.5, 9, 11, 12, 13, 18, 19.5, 24, 26, 36, 39, 48, 52, 54, 58.5, 65];

    function rateSort(a, b) {
        return a.rate - b.rate;
    }
    //删除重复速率值
    function unionRate(rateTable) {
        var rates = [],
        result = [];
        for (var i = 0; i < rateTable.length; i++) {
            for (var j = 0; j < rateTable[i].length; j++) {
                if (ko.utils.arrayIndexOf(rates, rateTable[i][j]) == -1) {
                    rates.push(rateTable[i][j]);
                    result.push({
                        index: rateTable[i][j],
                        rate: transpeed[rateTable[i][j]]
                    });
                }
            }
        }
        result.sort(rateSort);
        return result;
    }

    //根据模式生成速率选项
    function modeRateOption(wifimode) {
        var wifimodeN = [0, 5, 9, 11, 13, 15, 17, 19, 20];
        var wifimodeG = [0, 4, 6, 8, 10, 12, 14, 16, 18];
        var wifimodeB = [0, 1, 2, 3, 7];
        var rate = [];

        switch (wifimode) {
            //--wifimode
        case '5':
            rate.push(wifimodeN);
            rate.push(wifimodeG);
            rate.push(wifimodeB);
            break;
        case '4':
            rate.push(wifimodeN);
            rate.push(wifimodeG);
            rate.push(wifimodeB);
            break;
        case '3':
            rate.push(wifimodeG);
            rate.push(wifimodeB);
            break;
        case '2':
            rate.push(wifimodeN);
            break;
        case '1':
            rate.push(wifimodeG);
            break;
        case '0':
            rate.push(wifimodeB);
            break;

        default:
            rate.push(wifimodeN);
            break;
        }
        var union = unionRate(rate);
        return paintRateOption(union);
    }

    function getCountryCode(country) {
        var countryCodeArr = config.countryCode;
        var type = '';
        for (key in countryCodeArr) {
            var codes = countryCodeArr[key];
            if ($.inArray(country, codes) != -1) {
                type = key;
                break;
            }
        }
        var typeCode = config.countryCodeType[type];
        return typeCode ? typeCode : "0";
    }

    function channelOption(country) {
        var showOption = [new Option('Auto', '0')];
        var type = getCountryCode(country) + '';
        switch (type) {
            //--type
        case '9':
            generateChannelOption(showOption, 2307, 13);
            break;
        case '7':
            generateChannelOption(showOption, 2307, 13);
            generateChannelOption(showOption, 2407, 11);
            generateChannelOption(showOption, 2462, 2);
            break;
        case '3':
            generateChannelOption(showOption, 2407, 11);
            generateChannelOption(showOption, 2462, 2);
            break;
            //--type
        case '2':
            generateChannelOption(showOption, 2307, 13);
            generateChannelOption(showOption, 2407, 11);
            break;
        case '1':
            generateChannelOption(showOption, 2407, 11);
            break;
        default:
            generateChannelOption(showOption, 2407, 11);
        }
        return showOption;
    }
    function generateChannelOption(showOption, start, count) {
        for (var i = 1; i <= count; i++) {
            var txt = start + i * 5 + "MHz (Channel " + showOption.length + ")";
            showOption.push(new Option(txt, showOption.length + "_" + (start + i * 5)));
        }
    }

    function channelOption5g(country) {
        for (key in config.countryCode_5g) {
            var item = config.countryCode_5g[key];
            if ($.inArray(country, item.codes) != -1) {
                return generate5gChannelOption(item.channels);
            }
        }
        return [new Option('Auto', '0')];
    }
    function generate5gChannelOption(channels) {
        var showOption = [new Option('Auto', '0')];
        for (var i = 0; i < channels.length; i++) {
            var channel = channels[i];
            var mhz = channel * 5 + 5000;
            var txt = mhz + "MHz (Channel " + channel + ")";
            showOption.push(new Option(txt, channel + "_" + (mhz)));
        }
        return showOption;
    }

    function getBandOptions() {
        var showOption = [];
        if (!config.WIFI_HAS_5G) {
            showOption.push(new Option('2.4GHz', 'b'));
        } else {
            showOption.push(new Option('5GHz', 'a'));
            showOption.push(new Option('2.4GHz', 'b'));
        }
        return showOption;
    }

    function getChannelBandwidthsOptions(isSupport40) {
        var showOption = [];
        if (isSupport40) {
            showOption.push(new Option('20MHz', '0'));
            showOption.push(new Option('20MHz/40MHz', '1'));
        } else {
            showOption.push(new Option('20MHz', '0'));
        }
        return showOption;
    }

    function countryCodeOption(is5G) {
        var countries = is5G ? config.countries_5g : config.countries;
        var showOption = [];
        for (key in countries) {
            showOption.push(new Option(countries[key], key));
        }
        showOption = _.sortBy(showOption, function (opt) {
            return opt.text;
        });
        return showOption;
    }

    function getWifiAdvance() {
        return service.getWifiAdvance();
    }

    function getWpsState() {
        return service.getWpsInfo();
    }

    function getModeOption(wifiBand) {
        var modes = wifiBand == 'a' ? config.NETWORK_MODES_BAND : config.NETWORK_MODES;
        if (wifiBand == 'a') {
            $("#mode").hide();
            $("#modeFor5HZ").show();
            $("#modeLabel").attr('for', 'modeFor5HZ');
        } else if (modes.length == 1) {
            $("#mode").hide();
            $("#modeFor5HZ").hide();
        } else {
            $("#mode").show();
            $("#modeFor5HZ").hide();
        }
        var modeOptions = [];
        for (var i = 0; i < modes.length; i++) {
            modeOptions.push(new Option(modes[i].name, modes[i].value));
        }
        return modeOptions;
    }

    function getSelectedRateV(rate, rates) {
        for (var i = 0; i < rates.length; i++) {
            var opt = rates[i];
            if (opt.text == rate + " Mbps") {
                return opt.value;
            }
        }
        return '0';
    }
    //获取所选的信道对应的value值
    function getSelectedChannelV(channel, channels) {
        for (var i = 0; i < channels.length; i++) {
            var opt = $(channels[i]);
            if (opt.val().split("_")[0] == channel) {
                return opt.val();
            }
        }
        return '0';
    }

    function WifiAdvanceViewModel() {
        // Data
        var target = this;

        var wifiInfo = service.getWifiAdvance();
        target.origin_ap_station_enable = wifiInfo.ap_station_enable;
        target.modes = ko.observableArray(getModeOption(wifiInfo.wifiBand));
        target.bands = ko.observableArray(getBandOptions());

        var countryOpts = countryCodeOption(wifiInfo.wifiBand == 'a');
        target.countries = ko.observableArray(countryOpts);
        target.channels = ko.observableArray(wifiInfo.wifiBand == 'a' ? channelOption5g(wifiInfo.countryCode) : channelOption(wifiInfo.countryCode));
        target.rates = ko.observableArray(modeRateOption(wifiInfo.mode));

        target.hasAPStation = config.AP_STATION_SUPPORT;
        target.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
        target.hasMultiSSID = config.HAS_MULTI_SSID;
        target.hasWlanMacfilter = config.HAS_BLACK_AND_WHITE_FILTER;
        target.hasWifiBand = ko.observable(config.WIFI_BAND_SUPPORT);
        target.hasBandwidth = ko.observable(config.WIFI_BANDWIDTH_SUPPORT);

        target.selectedMode = ko.observable(wifiInfo.mode);
        target.selectedChannel = ko.observable(getSelectedChannelV(wifiInfo.channel, target.channels()));
        target.selectedChannelBandwidth = ko.observable(wifiInfo.bandwidth); //5:a, 2.5:b
        target.selectedCountry = ko.observable(wifiInfo.countryCode.toUpperCase());
        target.selectedBand = ko.observable(wifiInfo.wifiBand); //5:a, 2.5:b
        target.selectedRate = ko.observable(getSelectedRateV(wifiInfo.rate, target.rates()));

        var baseInfo = service.getWifiBasic();
        target.wifi_enable = ko.observable(baseInfo.wifi_enable);
        if (config.HAS_MULTI_SSID && ((baseInfo.m_AuthMode == "OPEN" && baseInfo.m_encryptType == "WEP") || (baseInfo.m_AuthMode == "SHARED" && baseInfo.m_encryptType == "WEP") || baseInfo.m_encryptType == "TKIP")) {
            target.isF = ko.observable(true);
        } else if ((baseInfo.AuthMode == "OPEN" && baseInfo.encryptType == "WEP") || (baseInfo.AuthMode == "SHARED" && baseInfo.encryptType == "WEP") || baseInfo.encryptType == "TKIP") {
            target.isF = ko.observable(true);
        } else {
            target.isF = ko.observable(false);
        }
        target.isShowSSIDInfoDiv = ko.observable(false);
        if (config.WIFI_SWITCH_SUPPORT) {
            if (baseInfo.wifi_enable == "1") {
                target.isShowSSIDInfoDiv(true);
            } else {
                target.isShowSSIDInfoDiv(false);
            }
        } else {
            target.isShowSSIDInfoDiv(true);
        }
        target.multi_ssid_enable = ko.observable(baseInfo.multi_ssid_enable);
        target.origin_multi_ssid_enable = baseInfo.multi_ssid_enable;
        target.maxStationNumber = ko.observable(wifiInfo.MAX_Station_num);
        target.selectedStation = ko.observable(wifiInfo.MAX_Access_num);
        target.selectedStationM = ko.observable(wifiInfo.m_MAX_Access_num);

        target.oneBandTrans = ko.observable(wifiInfo.wifiBand == 'a' ? '5G' : '2.4G');
        target.oneModeTrans = ko.observable((wifiInfo.wifiBand == 'a' ? 'network_modes_band_select_' : 'network_mode_select_') + wifiInfo.mode);

        target.channelBandwidths = ko.computed(function () {
            if (config.WIFI_BANDWIDTH_SUPPORT_40MHZ) {
                return getChannelBandwidthsOptions(true);
            } else {
                return getChannelBandwidthsOptions(false);
            }
        });

        wifiInfo = $.extend(wifiInfo, target);

        //Event Handler 频段切换时更新对应的国家/地区码、信道和网络模式选项
        target.bandChangeHandler = function () {
            if (target.selectedBand() == 'a') { //5g
                //802.11a only   802.11n only   802.11a/n
                target.modes(getModeOption(target.selectedBand()));
                target.countries(countryCodeOption(true));
            } else { // 2.4g
                //802.11 n only   802.11 b/g/n
                target.modes(getModeOption(target.selectedBand()));
                target.countries(countryCodeOption(false));
            }
            target.selectedCountry('0');
            target.channels(target.generateChannelOption());
            target.selectedChannel('0');
        };

        target.countryChangeHandler = function (data, event) {
            var opts = target.generateChannelOption();
            target.channels(opts);
            target.selectedChannel('0');
        };

        target.modeChangeHandler = function (data, event) {
            var opts = modeRateOption(target.selectedMode());
            target.rates(opts);
            target.selectedRate('0');
        };

        target.generateChannelOption = function () {
            if (target.selectedBand() == 'a') {
                return channelOption5g(target.selectedCountry());
            } else {
                return channelOption(target.selectedCountry());
            }
        };

        target.save = function () {
            var status = getWpsState();
            if (status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return;
            }
            var selectedRateTxt = $("#rate option:selected").text();
            var rateVal = null;
            if (selectedRateTxt != $.i18n.prop('rate_0')) {
                rateVal = $.trim(selectedRateTxt.replace('Mbps', ''));
            } else {
                rateVal = 0;
            }
            var wifiParam = {};
            wifiParam.countryCode = target.selectedCountry();
            wifiParam.mode = target.selectedMode();
            var selectedChannel = target.selectedChannel();
            wifiParam.channel = selectedChannel == '0' ? '0' : selectedChannel.split("_")[0];
            wifiParam.rate = rateVal;
            wifiParam.wifiBand = target.selectedBand();
            if (config.WIFI_BANDWIDTH_SUPPORT) {
                wifiParam.bandwidth = target.selectedChannelBandwidth();
            }
            wifiParam.station = target.selectedStation();
            wifiParam.m_station = target.selectedStationM();
            showConfirm('wifi_disconnect_confirm', function () {
                showLoading('waiting');
                service.setWifiAdvance(wifiParam, function (result) {
                    if (result.result == "success") {
                        if (viaWifi) {
                            setTimeout(advanceReloadVarWifi, 15000);
                        } else {
                            addInterval(advanceReload, 1000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            });
        };

        target.checkSettings = function (ssid) {
            var status = getWpsState();
            if (status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }
            if (config.HAS_MULTI_SSID && baseInfo.multi_ssid_enable == "1") {
                if ((ssid == "ssid1" && parseInt(target.selectedStation()) + parseInt(baseInfo.m_MAX_Access_num) > baseInfo.MAX_Station_num)
                     || (ssid == "ssid2" && parseInt(target.m_selectedStation()) + parseInt(baseInfo.MAX_Access_num) > baseInfo.MAX_Station_num)) {
                    showAlert({
                        msg: 'multi_ssid_max_access_number_alert',
                        wifiParam: baseInfo.MAX_Station_num
                    });
                    return true;
                }
            }

            return false;
        };

        target.setMultiSSIDSwitch = function () {
            if (target.checkSettings("switch")) {
                return;
            }

            var setSwitch = function () {
                showLoading('waiting');
                var wifiParam = {};
                wifiParam.m_ssid_enable = target.multi_ssid_enable();
                if (config.WIFI_SWITCH_SUPPORT) {
                    wifiParam.wifiEnabled = target.wifi_enable();
                }
                service.setWifiBasicMultiSSIDSwitch(wifiParam, function (result) {
                    if (result.result == "success") {
                        if (viaWifi) {
                            setTimeout(hasApReloadVarWifi, 15000);
                        } else {
                            addInterval(hasApReload, 1000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            };

            var baseInfo = service.getStatusInfo();
            if (config.HAS_MULTI_SSID && target.wifi_enable() == "1") {
                if (target.multi_ssid_enable() == "1" && config.AP_STATION_SUPPORT && target.origin_ap_station_enable == "1") {
                    if (!baseInfo.wifiStatus) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        });
                    } else {
                        showConfirm("multi_ssid_enable_confirm2", function () {
                            setSwitch();
                        });
                    }
                } else {
                    if (!baseInfo.wifiStatus) {
                        setSwitch();
                    } else {
                        showConfirm("wifi_disconnect_confirm2", function () {
                            setSwitch();
                        });
                    }
                }
            } else {
                setSwitch();
            }
            
            function hasApReloadVarWifi() {
                successOverlay();
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
                clearTimer();
                clearValidateMsg();
                service.refreshAPStationStatus();
                initialize();
            }
            function hasApReload() {
                var baseInfo = service.getWifiBasic();
                if (baseInfo.wifi_enable == target.wifi_enable()) {
                    successOverlay();
                    clearTimer();
                    clearValidateMsg();
                    service.refreshAPStationStatus();
                    initialize();
                }
            }

        };

    }

    function checkAccessMode() {
        service.getParams({
            nv: 'user_ip_addr'
        }, function (dataIp) {
            service.getParams({
                nv: 'station_list'
            }, function (dataList) {
                viaWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
            });
        });
    }

    function advanceReloadVarWifi() {
        successOverlay();
        setTimeout(function () {
            window.location.reload();
        }, 1000);
    }

    function advanceReload() {
        var baseInfo = service.getWifiBasic();
        if (baseInfo.wifi_enable == "1") {
            successOverlay();
            clearTimer();
            clearValidateMsg();
            initialize();
        }
    }

    function initialize() {
        var container = $('#container');
        ko.cleanNode(container[0]);
        var vm = new WifiAdvanceViewModel();
        ko.applyBindings(vm, container[0]);
        addTimeout(function () {
            checkAccessMode();
        }, 600);

        if (config.WDS_SUPPORT) {
            checkWifiStatusUseWDS();
        } else if (config.AP_STATION_SUPPORT) {
            checkWifiStatus();
        }
        
        $('#wifi_advance_form').validate({
            submitHandler: function () {
                vm.save();
            }
        });
        
        $('#frmWifiSwitch').validate({
            submitHandler: function () {
                vm.setMultiSSIDSwitch();
            }
        });
    }

    function checkWifiStatusUseWDS() {
        var baseInfo = service.getWdsInfo();
        if (baseInfo.currentMode == "0") {
            $(':input', '#frmWifiSwitch,#wifi_advance_form').each(function () {
                $(this).prop("disabled", false);
            });
        } else {
            $(':input', '#frmWifiSwitch,#wifi_advance_form').each(function () {
                $(this).prop("disabled", true);
            });
        }
    }

    function checkWifiStatus() {
        var baseInfo = service.getAPStationBasic();
        if (baseInfo.ap_station_enable != "1") {
            $(':input', '#wifi_advance_form').each(function () {
                $(this).prop("disabled", false);
            });
        } else {
            $(':input', '#wifi_advance_form').each(function () {
                $(this).prop("disabled", true);
            });
        }
    }

    return {
        init: initialize
    };
});

define("wifi_ap_station","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {
    var viaWifi = false;
    function checkAccessMode() {
        service.getParams({
            nv: 'user_ip_addr'
        }, function (dataIp) {
            service.getParams({
                nv: 'station_list'
            }, function (dataList) {
                viaWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
            });
        });
    }

    function apStationViewMode() {
        var target = this;
        var ssid_ex = "";
        target.hasMultiSSID = config.HAS_MULTI_SSID;
        target.hasAPStation = config.AP_STATION_SUPPORT;
        target.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
        target.hasWlanMacfilter = config.HAS_BLACK_AND_WHITE_FILTER;

        var securityModes = _.map(config.AUTH_MODES_ALL, function (item) {
            return new Option(item.name, item.value);
        });
        //当前页面标识  list列表页 add添加页面  edit编辑页面
        target.page = {
            list: 1,
            add: 2,
            edit: 3
        };
        //WiFi热点列表列的配置项
        var gridColumn = [{
                columnType: "radio",
                headerTextTrans: "option",
                rowText: "profileName",
                width: "10%"
            }, {
                headerTextTrans: "ssid_title",
                rowText: "ssid",
                width: "30%"
            }, {
                columnType: "image",
                headerTextTrans: "signal",
                rowText: "imgSignal",
                width: "30%"
            }, {
                headerTextTrans: "security_mode",
                rowText: "authMode_show",
                width: "30%"
            }
        ];
        //搜索到的WiFi热点列表列的配置项
        var searchGridColumn = [{
                columnType: "radio",
                rowText: "index",
                width: "10%"
            }, {
                headerTextTrans: "ssid_title",
                rowText: "ssid",
                width: "30%"
            }, {
                columnType: "image",
                headerTextTrans: "signal",
                rowText: "imgSignal",
                width: "30%"
            }, {
                headerTextTrans: "security_mode",
                rowText: "authMode_show",
                width: "30%"
            }
        ];

        target.pageState = ko.observable(target.page.list);

        var info = service.getAPStationBasic();

        target.origin_ap_station_enable = info.ap_station_enable;
        target.ap_station_enable = ko.observable(info.ap_station_enable);
        target.apList = ko.observable([]);
        if (target.origin_ap_station_enable == "1") {
            var apList = service.getHotspotList();
            target.apList(fixHotspotList(apList.hotspotList));
        }

        target.apSearchList = ko.observable([]);

        target.connectButtonStatus = ko.observable("disable");
        target.hasSelectFromUser = ko.observable();
        target.showPassword = ko.observable(false);

        target.isCableMode = ko.observable();

        var infoBasic = service.getWifiBasic();
        target.wifi_enable = ko.observable(infoBasic.wifi_enable);

        target.isShowSSIDInfoDiv = ko.observable(false);
        if (config.WIFI_SWITCH_SUPPORT) {
            if (infoBasic.wifi_enable == "1") {
                target.isShowSSIDInfoDiv(true);
            } else {
                target.isShowSSIDInfoDiv(false);
            }
        } else {
            target.isShowSSIDInfoDiv(true);
        }
        target.multi_ssid_enable = ko.observable(infoBasic.multi_ssid_enable);

        //密码显示事件
        target.showPasswordHandler = function () {
            $("#codeWPAKey").parent().find(".error").hide();
            $("#pwdWepKey").parent().find(".error").hide();
            var checkbox = $("#showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.showPassword(true);
            } else {
                target.showPassword(false);
            }
        };

        target.showWPAPasswordHandler = function () {
            $("#codeWPAKey").parent().find(".error").hide();
            $("#pwdWepKey").parent().find(".error").hide();
            if ($("#showWPAPassword").is(":checked")) {
                target.showPassword(true);
            } else {
                target.showPassword(false);
            }
        };

        //列表模板创建
        target.apGrid = new ko.simpleGrid.viewModel({
            idName: "profileName",
            data: target.apList(),
            tmplType: 'list',
            pageSize: 100,
            columns: gridColumn,
            primaryColumn: "fromProvider",
            radioClickHandler: function () {
                computeButtonState();
            }
        });
        //热点搜索结果列表模板创建
        target.apSearchGrid = new ko.simpleGrid.viewModel({
            data: target.apSearchList(),
            idName: "index",
            tmplType: 'list',
            pageSize: 100,
            columns: searchGridColumn,
            radioClickHandler: function () {
                var index = target.apSearchGrid.radioSelectValue();
                var aplist = target.apSearchList();
                for (var i = 0; i < aplist.length; i++) {
                    var list_item = aplist[i];
                    if (list_item.index == index) {
                        target.profileName("");
                        target.ssid(list_item.ssid);
                        ssid_ex = list_item.ssid;
                        target.signal(list_item.signal);
                        target.authMode(list_item.authMode);
                        target.password(list_item.password);
                        target.mac(list_item.mac);
                        if (list_item.authMode == "WPAPSKWPA2PSK" || list_item.authMode == "WPA2PSK" || list_item.authMode == "WPAPSK" || list_item.authMode == "WPA3Personal" || list_item.authMode == "WPA2WPA3") {
                            target.encryptType_WPA(list_item.encryptType);
                        } else {
                            target.encryptType(list_item.encryptType);
                        }
                        target.keyID(list_item.keyID);
                        renderCustomElement($("#cipherGroup"));
                        break;
                    }
                }
            }
        });

        //计算并设置当前连接和按钮的状态
        target.computeConnectStatus = function () {
            computeButtonState();

            var networkStatus = target.connectStatus();
            if (networkStatus == "ppp_connected") {
                target.current_status_trans("ap_station_wan_connected");
                target.current_status_text($.i18n.prop("ap_station_wan_connected"));
                return;
            }

            var ssid = target.connectWifiSSID();
            var wifiStatus = target.connectWifiStatus();
            if (ssid && wifiStatus == "connect") {
                target.current_status_trans("ap_station_wlan_connected");
                target.current_status_text($.i18n.prop("ap_station_wlan_connected"));
                return;
            }

            target.current_status_trans("ap_station_no_connection");
            target.current_status_text($.i18n.prop("ap_station_no_connection"));
        };
        //计算并设置按钮的状态
        function computeButtonState() {
            var profileName = target.apGrid.radioSelectValue();
            if (!profileName) {
                target.hasSelectFromUser(false);
                target.connectButtonStatus("disable");
                return;
            }

            var status = "";
            var fromProvider = "";
            for (var i = 0; i < target.apList().length; i++) {
                var list_item = target.apList()[i];
                if (list_item.profileName == profileName) {
                    status = list_item.connectStatus;
                    fromProvider = list_item.fromProvider;
                    break;
                }
            }

            if (status == "1") {
                target.connectButtonStatus("hide");
                target.hasSelectFromUser(false);
            } else {
                target.connectButtonStatus("show");
                target.hasSelectFromUser(fromProvider == "0");
            }
        }
        var statusInfo = service.getStatusInfo();
        target.networkType = ko.observable(statusInfo.networkType);
        target.networkOperator = ko.observable(statusInfo.networkOperator);
        target.connectStatus = ko.observable(statusInfo.connectStatus);
        target.connectWifiStatus = ko.observable(statusInfo.connectWifiStatus);
        target.connectWifiProfile = ko.observable(statusInfo.connectWifiProfile);
        target.connectWifiSSID = ko.observable(statusInfo.connectWifiSSID);

        target.current_status_trans = ko.observable("");
        target.current_status_text = ko.observable("");
        target.current_status = ko.computed(function () {
            target.computeConnectStatus()
        });

        target.modes = securityModes;
        target.profileName = ko.observable("");
        target.ssid = ko.observable();
        target.signal = ko.observable("0");
        target.authMode = ko.observable();
        target.password = ko.observable();
        target.encryptType = ko.observable();
        target.encryptType_WPA = ko.observable("TKIPCCMP");
        target.keyID = ko.observable("0");
        target.mac = ko.observable();

        target.openAddPage = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            target.clear();
            getSearchHotspot();
        };

        //打开基本设置页面
        target.openListPage = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            target.clear();
            target.pageState(target.page.list);
            target.apGrid.data(target.apList());
            v.computeConnectStatus();
        };

        target.addHotspot = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            if (target.pageState() == target.page.add && target.apList().length >= config.AP_STATION_LIST_LENGTH) {
                showAlert({
                    msg: "ap_station_exceed_list_max",
                    params: config.AP_STATION_LIST_LENGTH
                });
                return;
            }
            showLoading('waiting');
            var wifi_para = {};
            var profileName = target.apGrid.radioSelectValue();
            wifi_para.profileName = target.profileName();
            wifi_para.ssid = target.ssid();
            wifi_para.signal = target.signal();
            wifi_para.authMode = target.authMode();
            wifi_para.password = target.password();
            if (wifi_para.authMode == "SHARED") {
                wifi_para.encryptType = "WEP";
            } else if (wifi_para.authMode == "WPAPSKWPA2PSK" || wifi_para.authMode == "WPA2PSK" || wifi_para.authMode == "WPAPSK" || wifi_para.authMode == "WPA3Personal" || wifi_para.authMode == "WPA2WPA3") {
                wifi_para.encryptType = target.encryptType_WPA();
            } else {
                wifi_para.encryptType = target.encryptType();
            }
            wifi_para.keyID = target.keyID();
            wifi_para.mac = (target.mac() == "" || target.ssid() != ssid_ex) ? "0F:00:00:00:00:00" : target.mac();
            wifi_para.apList = target.apList();
            service.saveHotspot(wifi_para, function (data) {
                target.callback(data, true);
            });
        };

        target.deleteHotspot = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            showConfirm("confirm_data_delete", function () {
                var wifi_para = {};
                wifi_para.profileName = target.apGrid.radioSelectValue();
                wifi_para.apList = target.apList();
                showLoading('waiting');
                service.deleteHotspot(wifi_para, function (data) {
                    target.callback(data, true);
                });
            });
        };

        target.openEditPage = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            var profileName = target.apGrid.radioSelectValue();
            var aplist = target.apList();
            for (var i = 0; i < aplist.length; i++) {
                var list_item = aplist[i];
                if (list_item.profileName == profileName) {
                    target.profileName(profileName);
                    target.ssid(list_item.ssid);
                    target.signal(list_item.signal);
                    target.authMode(list_item.authMode);
                    target.password(list_item.password);
                    target.mac(list_item.mac);
                    if (list_item.authMode == "WPAPSKWPA2PSK" || list_item.authMode == "WPA2PSK" || list_item.authMode == "WPAPSK" || list_item.authMode == "WPA3Personal" || list_item.authMode == "WPA2WPA3") {
                        target.encryptType_WPA(list_item.encryptType);
                    } else {
                        target.encryptType(list_item.encryptType);
                    }
                    target.keyID(list_item.keyID);
                }
            }
            target.pageState(target.page.edit);
        };

        target.connectHotspot = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            var profileName = target.apGrid.radioSelectValue();
            var apList = target.apList();

            function connect() {
                showLoading("connecting");
                var wifi_para = {};
                var connectIndex = -1;
                var ssid = "";
                for (var i = 0; i < apList.length; i++) {
                    if (apList[i].profileName == profileName) {

                        wifi_para.EX_SSID1 = apList[i].ssid;
                        wifi_para.EX_AuthMode = apList[i].authMode;
                        wifi_para.EX_EncrypType = apList[i].encryptType;
                        wifi_para.EX_DefaultKeyID = apList[i].keyID;
                        wifi_para.EX_WEPKEY = apList[i].password;
                        wifi_para.EX_WPAPSK1 = apList[i].password;
                        wifi_para.EX_wifi_profile = apList[i].profileName;
                        wifi_para.EX_mac = apList[i].mac;
                        connectIndex = i;
                        ssid = apList[i].ssid;
                        break;
                    }
                }

                target.connectWifiSSID(ssid);
                target.connectWifiStatus("connecting");
                target.apGrid.setRadioSelect(profileName);
                target.connectButtonStatus("disable");

                service.connectHotspot(wifi_para, function (data) {
                    if (data && data.result == "success") {
                        target.connectButtonStatus("disable");
                        //延迟检测 确保取得的状态是最新的
                        addTimeout(checkWifiStatus, 3000);
                    } else if (data && data.result == "processing") {
                        showAlert("ap_station_processing");
                    } else {
                        var apList = target.apList(); // cov_2
                        apList[connectIndex].connectStatus = "0";
                        target.connectWifiStatus("disconnect");
                        target.connectButtonStatus("show");
                        hideLoading();
                        errorOverlay();
                    }
                    var apList = service.getHotspotList();
                    target.apList(fixHotspotList(apList.hotspotList));
                    target.connectWifiProfile(profileName);
                    target.connectWifiSSID(ssid);
                    target.apGrid.data([]);
                    target.apGrid.data(target.apList());
                    target.apGrid.setRadioSelect(profileName);
                });
            }

            //将用户选中的profile排在运营商定制profile后的第一位
            function refreshApList(profile, aplist) {
                var apListLeft = [];
                var apListPre = [];
                for (var i = 0; i < aplist.length; i++) {
                    if (aplist[i].fromProvider != "1") {
                        if (aplist[i].profileName == profile) {
                            apListPre.push(apList[i]);
                        } else {
                            apListLeft.push(apList[i]);
                        }
                    } else {
                        apListPre.push(apList[i]);
                    }
                }
                var apListNew = apListPre.concat(apListLeft);
                service.saveHotspot({
                    apList: apListNew
                }, function (data) {
                    if (data && data.result == "success") {
                        apList = apListNew;
                        target.apList(fixHotspotList(apList));
                    }
                });
            }

            var check_count = 0;
            var connectStatus = false;

            var status = service.getStatusInfo();
            if (status.connectStatus == "ppp_connected" || status.connectStatus == "ppp_connecting") {
                showConfirm("ap_station_connect_change_alert", function () {
                    showLoading();
                    connect();
                });
            } else {
                connect();
            }

            function checkWifiStatus() {
                check_count = check_count + 1;
                if (check_count > 60) {
                    hideLoading();
                    errorOverlay();
                    return;
                }
                if (!connectStatus) {
                    var status = service.getStatusInfo();
                    if (status.connectWifiStatus != "connect") {
                        addTimeout(checkWifiStatus, 1000);
                    } else {
                        connectStatus = true;
                    }
                }
                if (connectStatus) {
                    //继续判断profile中连接状态是否为1
                    service.getHotspotList({}, function (data) {
                        for (var i = 0, len = data.hotspotList.length; i < len; i++) {
                            var list_item = data.hotspotList[i];
                            if (list_item.profileName == profileName) {
                                if (list_item.connectStatus == "1") {
                                    hideLoading();
                                    return;
                                } else {
                                    var errorMsg = {
                                        msg: 'ap_connect_error',
                                        params: [list_item.ssid]
                                    };
                                    showAlert(errorMsg);
                                    return;
                                }
                                break;
                            }
                        }
                        addTimeout(checkWifiStatus, 1000);
                    });
                }
            }

        };

        target.disconnectHotspot = function () {
            if (wpsIsOn()) {
                return;
            }
            showLoading('disconnecting');
            service.disconnectHotspot({}, function (data) {
                target.callback(data, true);
            })
        };

        function getSearchHotspot() {
            var check_count = 0;

            function search() {
                var result = service.getSearchHotspotList();
                if (result.scan_finish == "0") {
                    if (check_count <= 60) {
                        check_count = check_count + 1;
                        addTimeout(search, 1000);
                    } else {
                        hideLoading();
                        showAlert("ap_station_search_hotspot_fail");
                    }
                } else {
                    if ("2" == result.scan_finish) {
                        hideLoading();
                        showAlert("ap_station_processing");
                    } else {
                        target.apSearchList(fixHotspotList(result.hotspotList));
                        target.apSearchGrid.data(target.apSearchList());
                        hideLoading();
                    }
                }
            }

            showLoading('scanning');
            service.searchHotspot({}, function (data) {
                if (data && data.result == "processing") {
                    hideLoading();
                    showAlert("ap_station_processing");
                } else if (data && data.result == "success") {
                    if (target.pageState() != target.page.add) {
                        target.pageState(target.page.add);
                    }
                    search();
                } else {
                    if (target.pageState() != target.page.add) {
                        target.pageState(target.page.add);
                    }
                    hideLoading();
                    showAlert("ap_station_search_hotspot_fail");
                }
            });
        }

        //清除编辑页面的信息
        target.clear = function () {
            target.apSearchGrid.clearRadioSelect();
            target.profileName("");
            target.ssid("");
            target.signal("0");
            target.authMode("OPEN");
            target.password("");
            target.encryptType("NONE");
            target.encryptType_WPA("TKIPCCMP");
            target.keyID("0");
            target.mac("");
        };

        target.apply = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }

            function setBasic() {
                showLoading('waiting');
                var wifi_para = {};
                wifi_para.ap_station_enable = target.ap_station_enable();
                service.setAPStationBasic(wifi_para, function (data) {
                    if (target.origin_ap_station_enable == target.ap_station_enable()) {
                        target.callback(data, true);
                    } else {
                        target.callback2(data, true);
                    }
                });
                service.refreshAPStationStatus();
            }
            if (!config.HAS_MULTI_SSID) {
                setBasic();
            } else {
                var infoBasic = service.getWifiBasic();
                if (target.ap_station_enable() == "1" && infoBasic.multi_ssid_enable == "1") {
                    showConfirm("ap_station_enable_confirm", setBasic);
                } else {
                    setBasic();
                }
            }
        };
        //刷新搜到的热点列表
        target.searchHotspot = function () {
            if (wifiIsClosed()) {
                return;
            }
            if (wpsIsOn()) {
                return;
            }
            getSearchHotspot();
        };
        //和webserver交互时的回调，wifi不重启的情况
        target.callback = function (data, isInitPage) {
            if (data) {
                if (isInitPage) {
                    initialize();
                    $("#apList").translate();
                }
                if (data.result == "processing") {
                    showAlert("ap_station_processing");
                } else if (data.result == "spot_connected" || data.result == "spot_connecting") {
                    showAlert("ap_station_update_fail");
                } else if (data.result == "success") {
                    successOverlay();
                } else if (data.result == "exist") {
                    showAlert("ap_station_exist");
                } else {
                    errorOverlay();
                }
            } else {
                errorOverlay();
            }
        }

        //和webserver交互时的回调,wifi会重启的情况
        target.callback2 = function (data, isInitPage) {
            if (data) {
                if (!viaWifi) { //通过wifi登录webui
                    addInterval(function () {
                        var info = service.getWifiBasic();
                        if (info.wifi_enable == "1") {
                            clearTimer();
                            clearValidateMsg();
                            initialize();
                            $("#apList").translate();
                            if (data.result == "spot_connected" || data.result == "spot_connecting") {
                                showAlert("ap_station_update_fail");
                            } else if (data.result == "success") {
                                successOverlay();
                            } else {
                                errorOverlay();
                            }
                        }
                    }, 1000);
                } else {
                    setTimeout(function () {
                        if (data.result == "processing") {
                            showAlert("ap_station_processing");
                        } else if (data.result == "spot_connecting" || data.result == "spot_connected") {
                            showAlert("ap_station_update_fail");
                        } else if (data.result == "success") {
                            successOverlay();
                            setTimeout(function () {
                                window.location.reload();
                            }, 1000);
                            clearTimer();
                            clearValidateMsg();
                            initialize();
                        } else {
                            errorOverlay();
                        }
                    }, 15000);
                }
            } else {
                errorOverlay();
            }
        };

        target.checkSettings = function (ssid) {
            var status = service.getWpsInfo();
            if (status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }
            if (config.HAS_MULTI_SSID && info.multi_ssid_enable == "1") {
                if ((ssid == "ssid1" && parseInt(target.selectedStation()) + parseInt(info.m_MAX_Access_num) > info.MAX_Station_num)
                     || (ssid == "ssid2" && parseInt(target.m_selectedStation()) + parseInt(info.MAX_Access_num) > info.MAX_Station_num)) {
                    showAlert({
                        msg: 'multi_ssid_max_access_number_alert',
                        params: info.MAX_Station_num
                    });
                    return true;
                }
            }

            return false;
        };

        target.setMultiSSIDSwitch = function () {
            if (target.checkSettings("switch")) {
                return;
            }

            var setSwitch = function () {
                showLoading('waiting');
                var params = {};
                params.m_ssid_enable = target.multi_ssid_enable();
                if (config.WIFI_SWITCH_SUPPORT) {
                    params.wifiEnabled = target.wifi_enable();
                }
                service.setWifiBasicMultiSSIDSwitch(params, function (result) {
                    if (result.result == "success") {
                        if (!viaWifi) {
                            addInterval(function () {
                                var info = service.getWifiBasic();
                                if (info.wifi_enable == target.wifi_enable()) {
                                    successOverlay();
                                    clearTimer();
                                    clearValidateMsg();
                                    service.refreshAPStationStatus();
                                    initialize();
                                }
                            }, 1000);
                        } else {
                            setTimeout(function () {
                                successOverlay();
                                setTimeout(function () {
                                    window.location.reload();
                                }, 1000);
                                clearTimer();
                                clearValidateMsg();
                                service.refreshAPStationStatus();
                                initialize();
                            }, 15000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            };

            var info = service.getStatusInfo();
            if (config.HAS_MULTI_SSID && target.wifi_enable() == "1") {
                if (target.multi_ssid_enable() == "1" && config.AP_STATION_SUPPORT && target.origin_ap_station_enable == "1") {
                    if (!info.wifiStatus) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        });
                    } else {
                        showConfirm("multi_ssid_enable_confirm2", function () {
                            setSwitch();
                        });
                    }
                } else {
                    if (!info.wifiStatus) {
                        setSwitch();
                    } else {
                        showConfirm("wifi_disconnect_confirm2", function () {
                            setSwitch();
                        });
                    }
                }
            } else {
                setSwitch();
            }
        };

    }

    function wpsIsOn() {
        var wifi_info = service.getWpsInfo();
        if (wifi_info.wpsFlag == '1') {
            showAlert('wps_on_info');
            return true;
        }
    }

    //处理热点列表内容，以便在表格显示
    function fixHotspotList(list) {
        var fixedList = [];
        for (var ii = 0; ii < list.length; ii++) {
            list[ii].index = ii;
            var url_image = "";
            if (list[ii].connectStatus != "1") {
                if (list[ii].encryptType.toLowerCase() == "none" && list[ii].authMode.toLowerCase() == "open") {
                    url_image = "pic/wlan_signal_" + list[ii].signal + ".png";
                } else {
                    url_image = "pic/wlan_lock_signal_" + list[ii].signal + ".png";
                }
            } else {
                if (list[ii].encryptType.toLowerCase() == "none" && list[ii].authMode.toLowerCase() == "open") {
                    url_image = "pic/wlan_connected.png";
                } else {
                    url_image = "pic/wlan_lock_connected.png";
                }
            }
            list[ii].imgSignal = url_image;
            list[ii].authMode_show = $.i18n.prop("ap_station_security_mode_" + list[ii].authMode);
        }
        return list;
    }

    function wifiIsClosed() {
        var wifi_info = service.getWpsInfo();
        if (wifi_info.radioFlag == "0") {
            showAlert('wps_wifi_off');
            return true;
        }
    }

    function event_bind(aps_vm) {
        $("#showWPAPassword").change(function () {
            aps_vm.showWPAPasswordHandler();
        });
        $("#showPassword").change(function () {
            aps_vm.showPasswordHandler();
        });
    }

    function initialize() {
        var aps_vm = new apStationViewMode();
        var container = $('#container')[0];
        ko.cleanNode(container);
        ko.applyBindings(aps_vm, container);
        event_bind(aps_vm);

        aps_refresh(true);
        clearTimer();
        addInterval(function () {
            aps_refresh(false);
            checkAccessMode();
        }, 1000);

        $('#frmWifiSwitch').validate({
            submitHandler: function () {
                aps_vm.setMultiSSIDSwitch();
            }
        });

        $("#frmAPStation").validate({
            submitHandler: function () {
                aps_vm.addHotspot();
            },
            rules: {
                txtSSID: "ssid_ap"
            },
            errorPlacement: function (error, element) {
                var id = element.attr("id");
                if (id == "txtWPAKey" || id == "codeWPAKey") {
                    error.insertAfter("#lblshowWPAPassword");
                } else if (id == "txtWepKey" || id == "pwdWepKey") {
                    error.insertAfter("#lblShowPassword");
                } else {
                    error.insertAfter(element);
                }
            }
        });

        function aps_refresh(initPage) {
            var info = service.getStatusInfo();
            if (info.multi_ssid_enable != "1") {
                aps_vm.isCableMode(checkCableMode(info.blc_wan_mode));
                aps_vm.connectWifiProfile(info.connectWifiProfile);
                aps_vm.connectWifiSSID(info.connectWifiSSID);
                aps_vm.connectWifiStatus(info.connectWifiStatus);
                aps_vm.networkType(info.networkType);
                aps_vm.connectStatus(info.connectStatus);
                aps_vm.computeConnectStatus();

                service.getHotspotList({}, function (data) {
                    var list = fixHotspotList(data.hotspotList);
                    aps_vm.apList(list);
                    var gripList = aps_vm.apGrid.data();
                    if (list.length > 0 && list[0].profileName != gripList[0].profileName && list[0].connectStatus == "1") {
                        aps_vm.apGrid.data([]);
                        aps_vm.apGrid.data(aps_vm.apList());
                        aps_vm.apGrid.setRadioSelect(list[0].profileName);
                    }
                    renderCustomElement($("#apList"));
                    var radios = $("input[type='radio']", "#apList").each(function () {
                        for (var i = 0, len = list.length; i < len; i++) {
                            if (list[i].profileName == $(this).val()) {
                                var img = $(this).parent().parent().find("img")[0];
                                img.src = list[i].imgSignal;
                                if (initPage) {
                                    if (list[i].connectStatus == "1") {
                                        aps_vm.hasSelectFromUser(false);
                                        aps_vm.connectButtonStatus("disable");
                                    }
                                }
                            }
                        }
                    });
                });
            } else {
                //to do
            }
        }

    }

    return {
        init: initialize
    }
});

define("wifi_guest","underscore jquery knockout set service CryptoJS".split(" "),

    function (_, $, ko, config, service, CryptoJS) {

    var viaWifi = false;
    function checkAccessMode() {
        service.getParams({
            nv: 'user_ip_addr'
        }, function (dataIp) {
            service.getParams({
                nv: 'station_list'
            }, function (dataList) {
                viaWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
            });
        });
    }

    var securityModes = _.map(config.WIFI_WEP_SUPPORT ? config.AUTH_MODES_WEP : config.AUTH_MODES, function (item) {
        return new Option(item.name, item.value);
    });

    function maxStationAccess(max) {
        var showOption = [];
        for (var i = 1; i <= max; i++) {
            showOption.push(new Option(i, i));
        }
        return showOption;
    }

    function wifiGuestVM() {
        var target = this;
        var info = service.getWifiBasic();

        target.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
        target.hasMultiSSID = config.HAS_MULTI_SSID;
        target.showIsolated = config.SHOW_WIFI_AP_ISOLATED;
        target.hasAPStation = config.AP_STATION_SUPPORT;
        target.hasWlanMacfilter = config.HAS_BLACK_AND_WHITE_FILTER;
        target.hasWifiWep = config.WIFI_WEP_SUPPORT;
        target.hasWifiWpa3 = config.WIFI_WAP3_SUPPORT;
        target.hasWifiWpa23 = config.WIFI_WPA2_WAP3_SUPPORT;

        var advanceInfo = service.getWifiAdvance();
        target.adBand = ko.observable(advanceInfo.wifiBand);
        target.adMode = ko.observable(advanceInfo.mode);

        target.showQRSwitch = config.WIFI_SUPPORT_QR_CODE && config.WIFI_SUPPORT_QR_SWITCH;
        target.showQR = ko.observable(info.m_show_qrcode_flag);
        if (config.WIFI_SUPPORT_QR_SWITCH) {
            target.showQRCode = ko.observable(config.WIFI_SUPPORT_QR_CODE && target.showQR());
        } else {
            target.showQRCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
        }
        if(config.WIFI_SUPPORT_QR_CODE){
            target.qrcodeSrc = './pic/qrcode_multi_ssid_wifikey.png?_=' + $.now();
        } else {
            target.qrcodeSrc = './pic/res_blacktrans.png';
        }
        target.origin_ap_station_enable = info.ap_station_enable;
        target.wifi_enable = ko.observable(info.wifi_enable);
        target.isShowSSIDInfoDiv = ko.observable(false);
        if (config.WIFI_SWITCH_SUPPORT) {
            if (info.wifi_enable == "1") {
                target.isShowSSIDInfoDiv(true);
            } else {
                target.isShowSSIDInfoDiv(false);
            }
        } else {
            target.isShowSSIDInfoDiv(true);
        }

        target.multi_ssid_enable = ko.observable(info.multi_ssid_enable);
        target.origin_multi_ssid_enable = info.multi_ssid_enable;

        target.maxStationNumber = ko.computed(function () {
            return config.MAX_STATION_NUMBER;
        });

        target.modes = ko.observableArray(securityModes);
        target.selectedMode = ko.observable(info.AuthMode);
        target.passPhrase = ko.observable(info.passPhrase);
        target.showPassword = ko.observable(false);
        target.ssid = ko.observable(info.SSID);
        target.broadcast = ko.observable(info.broadcast == '1' ? '1' : '0');
        target.apIsolation = ko.observable(info.apIsolation == '1' ? '1' : '0');
        target.cipher = info.cipher;
        target.selectedStation = ko.observable(info.MAX_Access_num);
        target.maxStations = ko.observableArray(maxStationAccess(info.MAX_Station_num));

        target.m_modes = ko.observableArray(securityModes);
        target.m_selectedMode = ko.observable(info.m_AuthMode);
        target.m_passPhrase = ko.observable(info.m_passPhrase);
        target.m_showPassword = ko.observable(false);
        target.m_ssid = ko.observable(info.m_SSID);
        target.m_broadcast = ko.observable(info.m_broadcast == '1' ? '1' : '0');
        target.m_apIsolation = ko.observable(info.m_apIsolation == '1' ? '1' : '0');
        target.m_cipher = info.m_cipher;
        target.m_selectedStation = ko.observable(info.m_MAX_Access_num);
        target.m_maxStations = ko.observableArray(maxStationAccess(info.MAX_Station_num));
        target.m_encryptType = ko.observable(info.m_encryptType);
        target.m_keyID = ko.observable(info.m_keyID);
        target.m_wepPassword = ko.observable("");

        //刷新界面状态值显示
        target.clear = function (option) {
            if (option == "switch") {
                target.multi_ssid_enable(info.multi_ssid_enable);
                target.wifi_enable(info.wifi_enable);
            } else if (option == "ssid1") {
                target.selectedMode(info.AuthMode);
                target.passPhrase(info.passPhrase);
                target.ssid(info.SSID);
                target.broadcast(info.broadcast == '1' ? '1' : '0');
                target.cipher = info.cipher;
                target.selectedStation(info.MAX_Access_num);
                target.apIsolation(info.apIsolation == '1' ? '1' : '0');
            } else if (option == "ssid2") {
                target.m_selectedMode(info.m_AuthMode);
                target.m_passPhrase(info.m_passPhrase);
                target.m_ssid(info.m_SSID);
                target.m_broadcast(info.m_broadcast == '1' ? '1' : '0');
                target.m_cipher = info.m_cipher;
                target.m_selectedStation(info.m_MAX_Access_num);
                target.m_apIsolation(info.m_apIsolation == '1' ? '1' : '0');
                if (config.WIFI_WEP_SUPPORT) {
                    target.m_encryptType(info.m_encryptType);
                    target.m_keyID(info.m_keyID);
                    target.m_wepPassword(target.getWepPassword());
                }
            } else {
                clearTimer();
                clearValidateMsg();
                initialize();
                service.refreshAPStationStatus();
            }
        };

        target.getWepPassword = function () {
            return target.m_keyID() == '3' ? info.m_Key4Str1 : (target.m_keyID() == '2' ? info.m_Key3Str1 : target.m_keyID() == '1' ? info.m_Key2Str1 : info.m_Key1Str1);
        }
        target.m_wepPassword(target.getWepPassword());
        //WEP加密模式下网络秘钥切换事件
        target.profileChangeHandler = function (data, event) {
            $("#pwdWepKey").parent().find("label[class='error']").hide();
            target.m_wepPassword(target.getWepPassword());
            return true;
        };

        target.saveSSID1 = function () {
            if (target.checkSettings("ssid1")) {
                return;
            }
            showConfirm('wifi_disconnect_confirm', function () {
                target.saveSSID1Action();
            });
        };
        target.saveSSID1Action = function () {
            showLoading('waiting');
            target.broadcast($("#broadcastCheckbox:checked").length > 0 ? '0' : '1');
            target.apIsolation($("#apisolatedCheckbox:checked").length);
            var params = {};
            params.AuthMode = target.selectedMode();
            params.passPhrase = target.passPhrase();
            params.SSID = target.ssid();
            params.broadcast = target.broadcast();
            params.station = target.selectedStation();
            params.cipher = target.selectedMode() == "WPA2PSK" ? 1 : 2;
            if (params.AuthMode == "WPA3Personal" || params.AuthMode == "WPA2WPA3") {
                params.cipher = 1;
            }
            params.NoForwarding = target.apIsolation();
            params.show_qrcode_flag = target.showQR() == true ? 1 : 0;
            service.setWifiBasic(params, function (result) {
                if (result.result == "success") {
                    if (viaWifi) {
                        setTimeout(guestReloadVarWifi, 15000);
                    } else {
                        addInterval(guestReload, 1000);
                    }
                } else {
                    errorOverlay();
                }
            });
        };

        target.saveSSID2 = function () {
            if (target.checkSettings("ssid2")) {
                return;
            }
            if (!config.PASSWORD_ENCODE) {
                var pwdRegex = new RegExp('(?=.*[0-9])(?=.*[a-zA-Z])(?=.*[^a-zA-Z0-9]).{8,32}');
                if (!pwdRegex.test(target.m_passPhrase())) {
                        showConfirm("password_note_too_low", function () {
                            showConfirm('wifi_disconnect_confirm', function () {
                            target.saveSSID2Action();
                            return;
                        });
                        return;
                    });
                    return;
                }
            }
            showConfirm('wifi_disconnect_confirm', function () {
                target.saveSSID2Action();
            });
        };
        target.saveSSID2Action = function () {
            showLoading('waiting');
            target.m_broadcast($("#mBroadcastCheckbox:checked").length > 0 ? '0' : '1');
            target.m_apIsolation($("#mApIsolatedCheckbox:checked").length);
            var ciphertext = "";
            if (config.PASSWORD_ENCODE) {
	        ciphertext = target.m_passPhrase();
	    } else {
                var kparam = service.getDeviceInfoLow();
                var tkey = CryptoJS.enc.Latin1.parse(kparam.skey);
		var tiv = CryptoJS.enc.Latin1.parse(kparam.siv);
                ciphertext = CryptoJS.AES.encrypt(target.m_passPhrase(), tkey, {
                    iv: tiv,
                    mode: CryptoJS.mode.CBC,
                    padding: CryptoJS.pad.ZeroPadding
                    }).toString();
	    }
            var params = {};
            params.m_AuthMode = target.m_selectedMode();
            params.m_passPhrase = ciphertext;
            params.m_SSID = target.m_ssid();
            params.m_broadcast = target.m_broadcast();
            params.m_station = target.m_selectedStation();
            params.m_cipher = target.m_selectedMode() == "WPA2PSK" ? 1 : 2;
            if (params.m_AuthMode == "WPA3Personal" || params.m_AuthMode == "WPA2WPA3") {
                params.m_cipher = 1;
            }
            params.m_NoForwarding = target.m_apIsolation();
            params.m_show_qrcode_flag = target.showQR() == true ? 1 : 0;

            if (config.WIFI_WEP_SUPPORT) {
                if (params.m_AuthMode == "SHARED") {
                    params.m_encryptType = "WEP";
                } else if (params.m_AuthMode == "WPAPSKWPA2PSK" || params.m_AuthMode == "WPA2PSK" || params.m_AuthMode == "WPAPSK" || params.m_AuthMode == "WPA3Personal" || params.m_AuthMode == "WPA2WPA3") {
                    //params.m_encryptType = target.m_encryptType_WPA();
                } else {
                    params.m_encryptType = target.m_encryptType();
                }
                params.m_wep_default_key = target.m_keyID();
                params.m_wep_key_4 = info.m_Key4Str1;
                params.m_wep_key_3 = info.m_Key3Str1;
                params.m_wep_key_2 = info.m_Key2Str1;
                params.m_wep_key_1 = info.m_Key1Str1;
                var mWEPSelect = '0';
                if (target.m_wepPassword().length == '13' || target.m_wepPassword().length == '5') {
                    mWEPSelect = '1';
                } else {
                    mWEPSelect = '0';
                }
                if (target.m_keyID() == '3') {
                    params.m_wep_key_4 = target.m_wepPassword();
                    params.m_WEP4Select = mWEPSelect;
                } else if (target.m_keyID() == '2') {
                    params.m_wep_key_3 = target.m_wepPassword();
                    params.m_WEP3Select = mWEPSelect;
                } else if (target.m_keyID() == '1') {
                    params.m_wep_key_2 = target.m_wepPassword();
                    params.m_WEP2Select = mWEPSelect;
                } else {
                    params.m_wep_key_1 = target.m_wepPassword();
                    params.m_WEP1Select = mWEPSelect;
                }
            }

            service.setWifiBasic4SSID2(params, function (result) {
                if (result.result == "success") {
                    if (viaWifi) {
                        setTimeout(ssid2ReloadVarWifi, 15000);
                    } else {
                        addInterval(ssid2Reload, 1000);
                    }
                } else {
                    errorOverlay();
                }
            });
        };

        function guestReloadVarWifi() {
            successOverlay();
            setTimeout(function () {
                window.location.reload();
            }, 1000);
            target.clear();
        }
        function guestReload() {
            var info = getWifiMain();
            if (info.wifi_enable == "1") {
                successOverlay();
                target.clear();
            }
        }
        function ssid2ReloadVarWifi() {
            successOverlay();
            setTimeout(function () {
                window.location.reload();
            }, 1000);
            target.clear();
        }
        function ssid2Reload() {
            var info = getWifiMain();
            if (info.wifi_enable == "1") {
                successOverlay();
                target.clear();
            }
        }

        target.checkSettings = function (ssid) {
            var status = getWpsState();

            if (config.HAS_MULTI_SSID) {
                if (ssid == "ssid1" || ssid == "ssid2") {
                    if (ssid == "ssid2") {
                        var accessDevice = service.getStatusInfo().ssid2AttachedNum;
                        if (parseInt(target.m_selectedStation()) < accessDevice) {
                            showAlert('Extend_accessDevice');
                            return true;
                        }
                    } else {
                        var accessDevice = service.getStatusInfo().ssid1AttachedNum;
                        if (parseInt(target.selectedStation()) < accessDevice) {
                            showAlert('Extend_accessDevice');
                            return true;
                        }
                    }
                }
            }

            if (status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }
            if (config.HAS_MULTI_SSID && info.multi_ssid_enable == "1") {
                if ((ssid == "ssid1" && parseInt(target.selectedStation()) + parseInt(info.m_MAX_Access_num) > info.MAX_Station_num)
                     || (ssid == "ssid2" && parseInt(target.m_selectedStation()) + parseInt(info.MAX_Access_num) > info.MAX_Station_num)) {
                    showAlert({
                        msg: 'multi_ssid_max_access_number_alert',
                        params: info.MAX_Station_num
                    });
                    return true;
                }
            }

            return false;
        };

        target.setMultiSSIDSwitch = function () {
            if (target.checkSettings("switch")) {
                return;
            }

            var setSwitch = function () {
                showLoading('waiting');
                var params = {};
                params.m_ssid_enable = target.multi_ssid_enable();
                if (config.WIFI_SWITCH_SUPPORT) {
                    params.wifiEnabled = target.wifi_enable();
                }
                service.setWifiBasicMultiSSIDSwitch(params, function (result) {
                    if (result.result == "success") {
                        if (viaWifi) {
                            setTimeout(multiReloadViaWifi, 15000);
                        } else {
                            addInterval(multiReload, 1000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            };
            function multiReloadViaWifi() {
                successOverlay();
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
                target.clear();
            }
            function multiReload() {
                var info = getWifiMain();
                if (info.wifi_enable == target.wifi_enable()) {
                    successOverlay();
                    target.clear();
                }
            }
            var info = service.getStatusInfo();
            if (config.HAS_MULTI_SSID && target.wifi_enable() == "1") {
                if (config.AP_STATION_SUPPORT && target.multi_ssid_enable() == "1" && target.origin_ap_station_enable == "1") {
                    if (!info.wifiStatus) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        });
                    } else {
                        showConfirm("multi_ssid_enable_confirm2", function () {
                            setSwitch();
                        });
                    }
                } else {
                    if (!info.wifiStatus) {
                        setSwitch();
                    } else {
                        showConfirm("wifi_disconnect_confirm2", function () {
                            setSwitch();
                        });
                    }
                }
            } else {
                setSwitch();
            }
        };
        target.showQRHandler = function () {
            var checkbox = $("#showQR:checked");
            if (checkbox && checkbox.length == 0) {
                target.showQR(true);
            } else {
                target.showQR(false);
            }
            target.showQRCode(config.WIFI_SUPPORT_QR_CODE && target.showQR());
        };

        target.showPasswordHandler = guestShowPassword;

        target.m_showPasswordHandler = m_guestShowPassword;

        function guestShowPassword() {
            $("#passShow").parent().find(".error").hide();
            var checkbox = $("#showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.showPassword(true);
            } else {
                target.showPassword(false);
            }
        }
        function m_guestShowPassword() {
            $("#m_passShow").parent().find(".error").hide();
            $("#m_pwdWepKey").parent().find(".error").hide();
            var checkbox = $("#m_showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.m_showPassword(true);
            } else {
                target.m_showPassword(false);
            }
        }

    }

    function getWifiMain() {
        return service.getWifiBasic();
    }

    function initialize() {
        var container = $('#container');
        ko.cleanNode(container[0]);
        var vm = new wifiGuestVM();
        ko.applyBindings(vm, container[0]);
        addTimeout(function () {
            checkAccessMode();
        }, 600);

        function checkWifiStatus() {
            var info = service.getAPStationBasic();
            if (info.ap_station_enable != "1") {
                $('#frmMultiSSID :input').each(function () {
                    $(this).attr("disabled", false);
                });
            } else {
                $('#frmMultiSSID :input').each(function () {
                    $(this).attr("disabled", true);
                });
            }
        }

        function checkWifiStatusAccordingToWDS() {
            var info = service.getWdsInfo();
            if (info.currentMode == "0") {
                $('#frmWifiSwitch :input').each(function () {
                    $(this).attr("disabled", false);
                });
                $('#frmSSID2 :input').each(function () {
                    $(this).attr("disabled", false);
                });
                $('#frmSSID1 :input').each(function () {
                    $(this).attr("disabled", false);
                });
            } else {
                $('#frmWifiSwitch :input').each(function () {
                    $(this).attr("disabled", true);
                });
                $('#frmSSID2 :input').each(function () {
                    $(this).attr("disabled", true);
                });
                $('#frmSSID1 :input').each(function () {
                    $(this).attr("disabled", true);
                });
            }
        }

        if (config.WDS_SUPPORT) {
            checkWifiStatusAccordingToWDS();
        } else if (config.AP_STATION_SUPPORT) {
            checkWifiStatus();
        }

        $('#frmMultiSSID').validate({
            submitHandler: function () {
                vm.setMultiSSIDSwitch();
            }
        });
        $('#frmWifiSwitch').validate({
            submitHandler: function () {
                vm.setMultiSSIDSwitch();
            }
        });
        $('#frmSSID2').validate({
            submitHandler: function () {
                vm.saveSSID2();
            },
            rules: {
                m_ssid: 'ssid',
                m_pwdWepKey: {
                    wifi_wep_password_check: true,
                    wifi_password_check: true
                },
                m_txtWepKey: {
                    wifi_wep_password_check: true,
                    wifi_password_check: true
                },
                m_pass: 'wifi_password_check',
                m_passShow: 'wifi_password_check'
            },
            errorPlacement: function (error, element) {
                var id = element.attr("id");
                if (id == "m_passShow" || id == "m_pass") {
                    error.insertAfter("#m_lblShowPassword");
                } else if (id == "m_txtWepKey" || id == "m_pwdWepKey") {
                    error.insertAfter("#m_lblShowWepPassword");
                } else {
                    error.insertAfter(element);
                }
            }
        });
        $('#frmSSID1').validate({
            submitHandler: function () {
                vm.saveSSID1();
            },
            rules: {
                pass: 'wifi_password_check',
                ssid: 'ssid',
                passShow: 'wifi_password_check'
            },
            errorPlacement: function (error, element) {
                var id = element.attr("id");
                if (id == "passShow" || id == "pass") {
                    error.insertAfter("#lblShowPassword");
                } else {
                    error.insertAfter(element);
                }
            }
        });

    }

    function getWpsState() {
        return service.getWpsInfo();
    }

    return {
        init: initialize
    };
});

define("wifi_mac_filter","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var viaWifi = false;
    function checkAccessMode() {
        service.getParams({
            nv: 'user_ip_addr'
        }, function (dataIp) {
            service.getParams({
                nv: 'station_list'
            }, function (dataList) {
                viaWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
            });
        });
    }

    function macFilterViewModel() {
        var target = this;
        target.hasAPStation = config.AP_STATION_SUPPORT;
        target.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
        target.hasMultiSSID = config.HAS_MULTI_SSID;
        target.showIsolated = config.SHOW_WIFI_AP_ISOLATED;

        var info = service.getMacFilterInfo();
        var wifiBaseInfo = service.getWifiBasic();
        target.multi_ssid_enable = ko.observable(wifiBaseInfo.multi_ssid_enable);
        target.origin_ap_station_enable = wifiBaseInfo.ap_station_enable;
        target.wifi_enable = ko.observable(wifiBaseInfo.wifi_enable);

        target.isShowSSIDInfoDiv = ko.observable(false);
        if (config.WIFI_SWITCH_SUPPORT) {
            if (wifiBaseInfo.wifi_enable == "1") {
                target.isShowSSIDInfoDiv(true);
            } else {
                target.isShowSSIDInfoDiv(false);
            }
        } else {
            target.isShowSSIDInfoDiv(true);
        }

        target.selectedAction = ko.observable(info.ACL_mode);
        target.mac1 = ko.observable("");
        target.mac2 = ko.observable("");
        target.mac3 = ko.observable("");
        target.mac4 = ko.observable("");
        target.mac5 = ko.observable("");
        target.mac6 = ko.observable("");
        target.mac7 = ko.observable("");
        target.mac8 = ko.observable("");
        target.mac9 = ko.observable("");
        target.mac10 = ko.observable("");
        if (info.ACL_mode == "1") {
            macInfoWhite = info.wifi_mac_white_list.split(";");
            target.mac1 = ko.observable(macInfoWhite[0]);
            target.mac2 = ko.observable(macInfoWhite[1]);
            target.mac3 = ko.observable(macInfoWhite[2]);
            target.mac4 = ko.observable(macInfoWhite[3]);
            target.mac5 = ko.observable(macInfoWhite[4]);
            target.mac6 = ko.observable(macInfoWhite[5]);
            target.mac7 = ko.observable(macInfoWhite[6]);
            target.mac8 = ko.observable(macInfoWhite[7]);
            target.mac9 = ko.observable(macInfoWhite[8]);
            target.mac10 = ko.observable(macInfoWhite[9]);
        } else if (info.ACL_mode == "2") {
            macInfoBlack = info.wifi_mac_black_list.split(";");
            target.mac1 = ko.observable(macInfoBlack[0]);
            target.mac2 = ko.observable(macInfoBlack[1]);
            target.mac3 = ko.observable(macInfoBlack[2]);
            target.mac4 = ko.observable(macInfoBlack[3]);
            target.mac5 = ko.observable(macInfoBlack[4]);
            target.mac6 = ko.observable(macInfoBlack[5]);
            target.mac7 = ko.observable(macInfoBlack[6]);
            target.mac8 = ko.observable(macInfoBlack[7]);
            target.mac9 = ko.observable(macInfoBlack[8]);
            target.mac10 = ko.observable(macInfoBlack[9]);
        }

        target.save = filter_save;
        //切换MAC过滤规则事件
        target.ChangeHandler = function () {
            $("#mac_filter_form").find(".error").hide();
            $("#mac_filter_form").find("input[type=text]").show();
            var info = service.getMacFilterInfo();
            if (target.selectedAction() == "1") {
                macInfoWhite = info.wifi_mac_white_list.split(";");
                target.mac1(macInfoWhite[0]);
                target.mac2(macInfoWhite[1]);
                target.mac3(macInfoWhite[2]);
                target.mac4(macInfoWhite[3]);
                target.mac5(macInfoWhite[4]);
                target.mac6(macInfoWhite[5]);
                target.mac7(macInfoWhite[6]);
                target.mac8(macInfoWhite[7]);
                target.mac9(macInfoWhite[8]);
                target.mac10(macInfoWhite[9]);
            } else if (target.selectedAction() == "2") {
                macInfoBlack = info.wifi_mac_black_list.split(";");
                target.mac1(macInfoBlack[0]);
                target.mac2(macInfoBlack[1]);
                target.mac3(macInfoBlack[2]);
                target.mac4(macInfoBlack[3]);
                target.mac5(macInfoBlack[4]);
                target.mac6(macInfoBlack[5]);
                target.mac7(macInfoBlack[6]);
                target.mac8(macInfoBlack[7]);
                target.mac9(macInfoBlack[8]);
                target.mac10(macInfoBlack[9]);
            } else {
                target.mac1("");
                target.mac2("");
                target.mac3("");
                target.mac4("");
                target.mac5("");
                target.mac6("");
                target.mac7("");
                target.mac8("");
                target.mac9("");
                target.mac10("");
            }
        }
        //检查WPS状态
        target.checkSettings = function (ssid) {
            var wifi_status = service.getWpsInfo();
            if (wifi_status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }
            return false;
        };

        //设置多SSID开关
        target.setMultiSSIDSwitch = function () {
            if (target.checkSettings("switch")) {
                return;
            }

            var setSwitch = setFilterSwitch;

            var info = service.getStatusInfo();
            if (config.HAS_MULTI_SSID && target.wifi_enable() == "1") {
                if (target.multi_ssid_enable() == "1" && config.AP_STATION_SUPPORT && target.origin_ap_station_enable == "1") {
                    if (!info.wifiStatus) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        });
                    } else {
                        showConfirm("multi_ssid_enable_confirm2", function () {
                            setSwitch();
                        });
                    }
                } else {
                    if (!info.wifiStatus) {
                        setSwitch();
                    } else {
                        showConfirm("wifi_disconnect_confirm2", function () {
                            setSwitch();
                        });
                    }
                }
            } else {
                setSwitch();
            }
			
			function setFilterSwitch() {
                showLoading('waiting');
                var filter_param = {};
                filter_param.m_ssid_enable = target.multi_ssid_enable();
                if (config.WIFI_SWITCH_SUPPORT) {
                    filter_param.wifiEnabled = target.wifi_enable();
                }
                service.setWifiBasicMultiSSIDSwitch(filter_param, function (result) {
                    if (result.result == "success") {
                        if (!viaWifi) {
                            addInterval(function () {
                                var info = service.getWifiBasic();
                                service.refreshAPStationStatus();
                                if (info.wifi_enable == target.wifi_enable()) {
                                    successOverlay();
                                    clearTimer();
                                    clearValidateMsg();
                                    service.refreshAPStationStatus();
                                    initialize();
                                }
                            }, 1000);
                        } else {
                            setTimeout(function () {
                                successOverlay();
                                setTimeout(function () {
                                    window.location.reload();
                                }, 1000);
                                clearTimer();
                                clearValidateMsg();
                                service.refreshAPStationStatus();
                                initialize();
                            }, 15000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            }
        };

		function filter_save() {
            var wifi_status = service.getWpsInfo();
            if (wifi_status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }

            if (target.mac1() == undefined || target.mac1().indexOf(" ") >= 0) {
                target.mac1("")
            }
            if (target.mac2() == undefined || target.mac2().indexOf(" ") >= 0) {
                target.mac2("")
            }
            if (target.mac3() == undefined || target.mac3().indexOf(" ") >= 0) {
                target.mac3("")
            }
            if (target.mac4() == undefined || target.mac4().indexOf(" ") >= 0) {
                target.mac4("")
            }
            if (target.mac5() == undefined || target.mac5().indexOf(" ") >= 0) {
                target.mac5("")
            }
            if (target.mac6() == undefined || target.mac6().indexOf(" ") >= 0) {
                target.mac6("")
            }
            if (target.mac7() == undefined || target.mac7().indexOf(" ") >= 0) {
                target.mac7("")
            }
            if (target.mac8() == undefined || target.mac8().indexOf(" ") >= 0) {
                target.mac8("")
            }
            if (target.mac9() == undefined || target.mac9().indexOf(" ") >= 0) {
                target.mac9("")
            }
            if (target.mac10() == undefined || target.mac10().indexOf(" ") >= 0) {
                target.mac10("")
            }

            var mac_list = new Array(target.mac1(), target.mac2(), target.mac3(), target.mac4(), target.mac5(),
                    target.mac6(), target.mac7(), target.mac8(), target.mac9(), target.mac10());
            if (target.selectedAction() == "2" && info.client_mac_address != "" && $.inArray(info.client_mac_address, mac_list) != -1) {
                showAlert('black_yourself_tip');
                return false;
            }
            var list_sort = mac_list.sort(); //排序
            for (var i = 0; i < list_sort.length - 1; i++) {
                if (list_sort[i] != "" && list_sort[i] == list_sort[i + 1]) {
                    showAlert('mac_repeat_tip');
                    return false;
                }
            }
            var string_maclist = "";
            for (var i = 0; i < 10; i++) {
                if (string_maclist == "") {
                    string_maclist = mac_list[i];
                } else {
                    if (mac_list[i]) {
                        string_maclist = string_maclist + ";" + mac_list[i];
                    }
                }
            }
            var filter_param = {};
            filter_param.ACL_mode = target.selectedAction();
            if (target.selectedAction() == "2") {
                filter_param.wifi_mac_black_list = string_maclist;
            } else if (target.selectedAction() == "1") {
                filter_param.wifi_mac_white_list = string_maclist;
            }
            showLoading('waiting');
            service.setMacFilter(filter_param, function (result) {
                if (result.result == "success") {
                    successOverlay();
                } else {
                    errorOverlay();
                }
            });
        }
    }

    function bindContainer(filter_vm) {
        var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(filter_vm, container[0]);

        $('#frmWifiSwitch').validate({
            submitHandler: function () {
                filter_vm.setMultiSSIDSwitch();
            }
        });
        $('#mac_filter_form').validate({
            submitHandler: function () {
                filter_vm.save();
            },
            rules: {
                mac_1: 'mac_check',
                mac_2: 'mac_check',
                mac_3: 'mac_check',
                mac_4: 'mac_check',
                mac_5: 'mac_check',
                mac_6: 'mac_check',
                mac_7: 'mac_check',
                mac_8: 'mac_check',
                mac_9: 'mac_check',
                mac_10: 'mac_check'
            }
        });
    }
    function initialize() {
        var filter_vm = new macFilterViewModel();
        bindContainer(filter_vm);

        addTimeout(function () {
            checkAccessMode();
        }, 600);
    }

    return {
        init: initialize
    };
});

define("wifi_main","underscore jquery knockout set service CryptoJS".split(" "),
    function (_, $, ko, config, service, CryptoJS) {

    var securityModes = _.map(config.WIFI_WEP_SUPPORT ? config.AUTH_MODES_WEP : config.AUTH_MODES, function (item) {
        return new Option(item.name, item.value);
    });

    function maxStationAccess(max) {
        var showOption = [];
        for (var i = 1; i <= max; i++) {
            showOption.push(new Option(i, i));
        }
        return showOption;
    }
    //是否通过wifi接入
    var viaWifi = false;
    function checkAccessMode() {
        service.getParams({
            nv: 'user_ip_addr'
        }, function (dataIp) {
            service.getParams({
                nv: 'station_list'
            }, function (dataList) {
                viaWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
            });
        });
    }

    function WifiMainVM() {
        var target = this;
        var info = getWifiMain();

        target.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
        target.hasMultiSSID = config.HAS_MULTI_SSID;
        target.showIsolated = config.SHOW_WIFI_AP_ISOLATED;
        target.hasAPStation = config.AP_STATION_SUPPORT;
        target.hasWlanMacfilter = config.HAS_BLACK_AND_WHITE_FILTER;
        target.hasWifiWep = config.WIFI_WEP_SUPPORT;
        target.hasWifiWpa3 = config.WIFI_WAP3_SUPPORT;
        target.hasWifiWpa23 = config.WIFI_WPA2_WAP3_SUPPORT;

        var advanceInfo = service.getWifiAdvance();
        target.adBand = ko.observable(advanceInfo.wifiBand);
        target.adMode = ko.observable(advanceInfo.mode);
        target.showQRSwitch = config.WIFI_SUPPORT_QR_CODE && config.WIFI_SUPPORT_QR_SWITCH;
        target.showQR = ko.observable(info.show_qrcode_flag);
        if (config.WIFI_SUPPORT_QR_SWITCH) {
            target.showQRCode = ko.observable(config.WIFI_SUPPORT_QR_CODE && target.showQR());
        } else {
            target.showQRCode = ko.observable(config.WIFI_SUPPORT_QR_CODE);
        }
        if(config.WIFI_SUPPORT_QR_CODE){
            target.qrcodeSrc = './pic/qrcode_ssid_wifikey.png?_=' + $.now();
        } else {
            target.qrcodeSrc = './pic/res_blacktrans.png';
        }
        target.origin_ap_station_enable = info.ap_station_enable;
        target.wifi_enable = ko.observable(info.wifi_enable);

        target.isShowSSIDInfoDiv = ko.observable(false);
        if (config.WIFI_SWITCH_SUPPORT) {
            if (info.wifi_enable == "1") {
                target.isShowSSIDInfoDiv(true);
            } else {
                target.isShowSSIDInfoDiv(false);
            }
        } else {
            target.isShowSSIDInfoDiv(true);
        }

        target.multi_ssid_enable = ko.observable(info.multi_ssid_enable);
        target.origin_multi_ssid_enable = info.multi_ssid_enable;

        target.maxStationNumber = ko.computed(function () {
            return config.MAX_STATION_NUMBER;
        });

        target.modes = ko.observableArray(securityModes);
        target.selectedMode = ko.observable(info.AuthMode);
        target.passPhrase = ko.observable(info.passPhrase);
        target.showPassword = ko.observable(false);
        target.ssid = ko.observable(info.SSID);
        target.broadcast = ko.observable(info.broadcast == '1' ? '1' : '0');
        target.apIsolation = ko.observable(info.apIsolation == '1' ? '1' : '0');
        target.cipher = info.cipher;
        target.selectedStation = ko.observable(info.MAX_Access_num);
        target.maxStations = ko.observableArray(maxStationAccess(info.MAX_Station_num));
        target.encryptType = ko.observable(info.encryptType);
        target.keyID = ko.observable(info.keyID);
        target.wepPassword = ko.observable("");

        target.m_modes = ko.observableArray(securityModes);
        target.m_selectedMode = ko.observable(info.m_AuthMode);
        target.m_passPhrase = ko.observable(info.m_passPhrase);
        target.m_showPassword = ko.observable(false);
        target.m_ssid = ko.observable(info.m_SSID);
        target.m_broadcast = ko.observable(info.m_broadcast == '1' ? '1' : '0');
        target.m_apIsolation = ko.observable(info.m_apIsolation == '1' ? '1' : '0');
        target.m_cipher = info.m_cipher;
        target.m_selectedStation = ko.observable(info.m_MAX_Access_num);
        target.m_maxStations = ko.observableArray(maxStationAccess(info.MAX_Station_num));

        target.getWepPassword = function () {
            return target.keyID() == '3' ? info.Key4Str1 : (target.keyID() == '2' ? info.Key3Str1 : target.keyID() == '1' ? info.Key2Str1 : info.Key1Str1);
        }
        target.wepPassword(target.getWepPassword());
        target.profileChangeHandler = function (data, event) {
            $("#pwdWepKey").parent().find("label[class='error']").hide();
            target.wepPassword(target.getWepPassword());
            return true;
        };

        target.clear = function (option) {
            if (option == "switch") {
                target.multi_ssid_enable(info.multi_ssid_enable);
                target.wifi_enable(info.wifi_enable);
            } else if (option == "ssid2") {
                target.m_selectedMode(info.m_AuthMode);
                target.m_passPhrase(info.m_passPhrase);
                target.m_ssid(info.m_SSID);
                target.m_broadcast(info.m_broadcast == '1' ? '1' : '0');
                target.m_cipher = info.m_cipher;
                target.m_selectedStation(info.m_MAX_Access_num);
                target.m_apIsolation(info.m_apIsolation == '1' ? '1' : '0');
            } else if (option == "ssid1") {
                target.selectedMode(info.AuthMode);
                target.passPhrase(info.passPhrase);
                target.ssid(info.SSID);
                target.broadcast(info.broadcast == '1' ? '1' : '0');
                target.cipher = info.cipher;
                target.selectedStation(info.MAX_Access_num);
                target.apIsolation(info.apIsolation == '1' ? '1' : '0');
                if (config.WIFI_WEP_SUPPORT) {
                    target.encryptType(info.encryptType);
                    target.keyID(info.keyID);
                    target.wepPassword(target.getWepPassword());
                }
            } else {
                clearTimer();
                clearValidateMsg();
                initialize();
            }
        };

        target.saveSSID1 = function () {
            if (target.checkSettings("ssid1")) {
                return;
            }
            if (!config.PASSWORD_ENCODE) {
                var pwdRegex = new RegExp('(?=.*[0-9])(?=.*[a-zA-Z])(?=.*[^a-zA-Z0-9]).{8,32}');
                if (!pwdRegex.test(target.passPhrase())) {
                        showConfirm("password_note_too_low", function () {
                            showConfirm('wifi_disconnect_confirm', function () {
                            target.saveSSID1Action();
                            return;
                        });
                        return;
                    });
                    return;
                }
            }
            showConfirm('wifi_disconnect_confirm', function () {
                target.saveSSID1Action();
            });
        };

        target.saveSSID1Action = getSSID1Action;

        target.saveSSID2 = function () {
            if (target.checkSettings("ssid2")) {
                return;
            }
            showConfirm('wifi_disconnect_confirm', function () {
                target.saveSSID2Action();
            });
        };

        target.saveSSID2Action = getSSID2Action;

        //检测wps\最大接入数
        target.checkSettings = function (ssid) {
            var status = getWpsState();
            if (ssid == "ssid1" || ssid == "ssid2") {
                if (ssid == "ssid2") {
                    var accessDevice = service.getStatusInfo().ssid2AttachedNum;
                    if (parseInt(target.m_selectedStation()) < accessDevice) {
                        showAlert('Extend_accessDevice');
                        return true;
                    }
                } else {
                    var accessDevice = service.getStatusInfo().ssid1AttachedNum;
                    if (parseInt(target.selectedStation()) < accessDevice) {
                        showAlert('Extend_accessDevice');
                        return true;
                    }
                }
            }

            if (status.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }

            if (info.multi_ssid_enable == "1" && config.HAS_MULTI_SSID) {
                if ((ssid == "ssid2" && parseInt(target.m_selectedStation()) + parseInt(info.MAX_Access_num) > info.MAX_Station_num)
                     || (ssid == "ssid1" && parseInt(target.selectedStation()) + parseInt(info.m_MAX_Access_num) > info.MAX_Station_num)) {
                    showAlert({
                        msg: 'multi_ssid_max_access_number_alert',
                        params: info.MAX_Station_num
                    });
                    return true;
                }
            }

            return false;
        };

        target.setMultiSSIDSwitch = function () {
            if (target.checkSettings("switch")) {
                return;
            }

            var setSwitch = function () {
                showLoading('waiting');
                var params = {};
                params.m_ssid_enable = target.multi_ssid_enable();
                if (config.WIFI_SWITCH_SUPPORT) {
                    params.wifiEnabled = target.wifi_enable();
                }
                service.setWifiBasicMultiSSIDSwitch(params, function (result) {
                    if (result.result == "success") {
                        if (viaWifi) {
                            setTimeout(hasApReloadVarWifi, 15000);
                        } else {
                            addInterval(hasApReload, 1000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            };

            function hasApReloadVarWifi() {
                successOverlay();
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
                service.refreshAPStationStatus();
                target.clear();
            }
            function hasApReload() {
                var info = getWifiMain();
                service.refreshAPStationStatus();
                if (info.wifi_enable == target.wifi_enable()) {
                    successOverlay();
                    target.clear();
                }
            }

            var info = service.getStatusInfo();
            if (config.HAS_MULTI_SSID && target.wifi_enable() == "1") {
                if (target.multi_ssid_enable() == "1" && config.AP_STATION_SUPPORT && target.origin_ap_station_enable == "1") {
                    if (!info.wifiStatus) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        });
                    } else {
                        showConfirm("multi_ssid_enable_confirm2", function () {
                            setSwitch();
                        });
                    }
                } else {
                    if (!info.wifiStatus) {
                        setSwitch();
                    } else {
                        showConfirm("wifi_disconnect_confirm2", function () {
                            setSwitch();
                        });
                    }
                }
            } else {
                setSwitch();
            }
        };

        //二维码显示事件
        target.showQRHandler = function () {
            var checkbox = $("#showQR:checked");
            if (checkbox && checkbox.length == 0) {
                target.showQR(true);
            } else {
                target.showQR(false);
            }
            target.showQRCode(config.WIFI_SUPPORT_QR_CODE && target.showQR());
        };

        //SSID2
        target.m_showPasswordHandler = function () {
            $("#m_passShow").parent().find(".error").hide();
            var checkbox = $("#m_showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.m_showPassword(true);
            } else {
                target.m_showPassword(false);
            }
        };
        target.showPasswordHandler = function () {
            $("#codeWPAKey").parent().find(".error").hide();
            $("#pwdWepKey").parent().find(".error").hide();
            var checkbox = $("#showPassword:checked");
            if (checkbox && checkbox.length == 0) {
                target.showPassword(true);
            } else {
                target.showPassword(false);
            }
        };

        function getSSID2Action() {
            showLoading('waiting');
            var params = {};
            params.m_AuthMode = target.m_selectedMode();
            params.m_passPhrase = target.m_passPhrase();
            params.m_SSID = target.m_ssid();
            params.m_broadcast = target.m_broadcast();
            params.m_station = target.m_selectedStation();
            params.m_cipher = target.m_selectedMode() == "WPA2PSK" ? 1 : 2;
            if (params.m_AuthMode == "WPA3Personal" || params.m_AuthMode == "WPA2WPA3") {
                params.m_cipher = 1;
            }
            params.m_NoForwarding = target.m_apIsolation();
            params.m_show_qrcode_flag = target.showQR() == true ? 1 : 0;
            service.setWifiBasic4SSID2(params, function (result) {
                if (result.result == "success") {
                    if (viaWifi) {
                        setTimeout(ssid2ReloadVarWifi, 15000);
                    } else {
                        addInterval(ssid2Reload, 1000);
                    }
                } else {
                    errorOverlay();
                }
            });
        }
        function ssid2ReloadVarWifi() {
            successOverlay();
            setTimeout(function () {
                window.location.reload();
            }, 1000);
            target.clear();
        }
        function ssid2Reload() {
            var info = getWifiMain();
            if (info.wifi_enable == "1") {
                successOverlay();
                target.clear();
            }
        }

        function getSSID1Action() {

            showLoading('waiting');
            target.broadcast($("#broadcastCheckbox:checked").length > 0 ? '0' : '1');
            target.apIsolation($("#apisolatedCheckbox:checked").length);
            var ciphertext = "";
            if (config.PASSWORD_ENCODE) {
	        ciphertext = target.passPhrase();
	    } else {
                var kparam = service.getDeviceInfoLow();
                var tkey = CryptoJS.enc.Latin1.parse(kparam.skey);
		var tiv = CryptoJS.enc.Latin1.parse(kparam.siv);
                ciphertext = CryptoJS.AES.encrypt(target.passPhrase(), tkey, {
                    iv: tiv,
                    mode: CryptoJS.mode.CBC,
                    padding: CryptoJS.pad.ZeroPadding
                    }).toString();
	    }
            var params = {};
            params.AuthMode = target.selectedMode();
            params.passPhrase = ciphertext;
            params.SSID = target.ssid();
            params.broadcast = target.broadcast();
            params.station = target.selectedStation();
            params.cipher = target.selectedMode() == "WPA2PSK" ? 1 : 2;
            if (params.AuthMode == "WPA3Personal" || params.AuthMode == "WPA2WPA3") {
                params.cipher = 1;
            }
            params.NoForwarding = target.apIsolation();
            params.show_qrcode_flag = target.showQR() == true ? 1 : 0;
            if (config.WIFI_WEP_SUPPORT) {
                if (params.AuthMode == "WPAPSK" || params.AuthMode == "WPA2PSK" || params.AuthMode == "WPAPSKWPA2PSK" || params.AuthMode == "WPA3Personal" || params.AuthMode == "WPA2WPA3") {}
                else if (params.AuthMode == "SHARED") {
                    params.encryptType = "WEP";
                } else {
                    params.encryptType = target.encryptType();
                }
                params.wep_default_key = target.keyID();
                params.wep_key_1 = info.Key1Str1;
                params.wep_key_2 = info.Key2Str1;
                params.wep_key_3 = info.Key3Str1;
                params.wep_key_4 = info.Key4Str1;
                var WEPSelect = '0';
                if (target.wepPassword().length == '5' || target.wepPassword().length == '13') {
                    WEPSelect = '1';
                } else {
                    WEPSelect = '0';
                }
                if (target.keyID() == '3') {
                    params.wep_key_4 = target.wepPassword();
                    params.WEP4Select = WEPSelect;
                } else if (target.keyID() == '2') {
                    params.wep_key_3 = target.wepPassword();
                    params.WEP3Select = WEPSelect;
                } else if (target.keyID() == '1') {
                    params.wep_key_2 = target.wepPassword();
                    params.WEP2Select = WEPSelect;
                } else {
                    params.wep_key_1 = target.wepPassword();
                    params.WEP1Select = WEPSelect;
                }
            }

            service.setWifiBasic(params, function (result) {
                if (result.result == "success") {
                    if (viaWifi) {
                        setTimeout(ssid1ReloadVarWifi, 15000);
                    } else {
                        addInterval(ssid1Reload, 1000);
                    }
                } else {
                    errorOverlay();
                }
            });
        }
        function ssid1ReloadVarWifi() {
            successOverlay();
            setTimeout(function () {
                window.location.reload();
            }, 1000);
            target.clear();
        }
        function ssid1Reload() {
            var info = getWifiMain();
            if (info.wifi_enable == "1") {
                successOverlay();
                target.clear();
            }
        }

    }

    function getWpsState() {
        return service.getWpsInfo();
    }

    function getWifiMain() {
        return service.getWifiBasic();
    }

    function initialize() {
        var container = $('#container');
        ko.cleanNode(container[0]);
        var vm = new WifiMainVM();
        ko.applyBindings(vm, container[0]);
        addTimeout(function () {
            checkAccessMode();
        }, 600);

        if (config.WDS_SUPPORT) {
            checkWifiStatusAccordingToWDS();
        } else if (config.AP_STATION_SUPPORT) {
            checkWifiStatus();
        }

        $('#frmSSID1').validate({
            submitHandler: function () {
                vm.saveSSID1();
            },
            rules: {
                ssid: 'ssid',
                pwdWepKey: {
                    wifi_wep_password_check: true,
                    wifi_password_check: true
                },
                txtWepKey: {
                    wifi_wep_password_check: true,
                    wifi_password_check: true
                },
                codeWPAKey: 'wifi_password_check',
                txtWPAKey: 'wifi_password_check'
            },
            errorPlacement: function (error, element) {
                var id = element.attr("id");
                if (id == "codeWPAKey" || id == "txtWPAKey") {
                    error.insertAfter("#lblshowWPAPassword");
                } else if (id == "pwdWepKey" || id == "txtWepKey") {
                    error.insertAfter("#lblShowWepPassword");
                } else {
                    error.insertAfter(element);
                }
            }
        });
        $('#frmSSID2').validate({
            submitHandler: function () {
                vm.saveSSID2();
            },
            rules: {
                m_ssid: 'ssid',
                m_pass: 'wifi_password_check',
                m_passShow: 'wifi_password_check'
            },
            errorPlacement: function (error, element) {
                var id = element.attr("id");
                if (id == "m_pass" || id == "m_passShow") {
                    error.insertAfter("#m_lblShowPassword");
                } else if (id == "pass" || id == "passShow") {
                    error.insertAfter("#lblShowPassword");
                } else {
                    error.insertAfter(element);
                }
            }
        });
        //表单提交函数、校验规则配置
        $('#frmWifiSwitch').validate({
            submitHandler: function () {
                vm.setMultiSSIDSwitch();
            }
        });

        $('#frmMultiSSID').validate({
            submitHandler: function () {
                vm.setMultiSSIDSwitch();
            }
        });

    }

    function checkWifiStatusAccordingToWDS() {
        var info = service.getWdsInfo();
        if (info.currentMode == "0") {
            $('#frmWifiSwitch :input').each(function () {
                $(this).prop("disabled", false);
            });
            $('#frmSSID1 :input').each(function () {
                $(this).prop("disabled", false);
            });
            $('#frmSSID2 :input').each(function () {
                $(this).prop("disabled", false);
            });
        } else {
            $('#frmWifiSwitch :input').each(function () {
                $(this).prop("disabled", true);
            });
            $('#frmSSID1 :input').each(function () {
                $(this).prop("disabled", true);
            });
            $('#frmSSID2 :input').each(function () {
                $(this).prop("disabled", true);
            });
        }
    }
    function checkWifiStatus() {
        var info = service.getAPStationBasic();
        if (info.ap_station_enable == "1") {
            $('#frmMultiSSID :input').each(function () {
                $(this).prop("disabled", true);
            });
        } else {
            $('#frmMultiSSID :input').each(function () {
                $(this).prop("disabled", false);
            });
        }
    }

    return {
        init: initialize
    };
});

define("wifi_sleep_mode","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    //休眠方式
    function getSleepMode() {
        return service.getSleepMode();
    }

    //覆盖范围
    function getWifiRange() {
        return service.getWifiRange();
    }

    var sleepTime = _.map(config.SLEEP_MODES, function (item) {
        return new Option(item.name, item.value);
    });

    function SleepModeViewMode() {
        var target = this;

        target.isCPE = config.PRODUCT_TYPE == 'CPE';
        target.showTSWDiv = config.TSW_SUPPORT;
        target.showSleepDiv = config.WIFI_SLEEP_SUPPORT;
        target.hasUssd = config.HAS_USSD;
        target.hasUpdateCheck = config.HAS_UPDATE_CHECK;
        target.hasDdns = config.DDNS_SUPPORT;

        target.modes = ko.observableArray(sleepTime);

        var smInfo = getSleepMode();
        target.selectedMode = ko.observable(smInfo.sleepMode);

        var wifiRangeInfo = getWifiRange();
        target.wifiRangeMode = ko.observable(wifiRangeInfo.wifiRangeMode);

        target.setWifiRange = smSetWifiRange;

        target.setWifiRangeAct = smSetWifiRangeAct;

        target.setSleepMode = smSetSleepMode;

        target.setSleepModeAct = smSetSleepModeAct;

        var tsw = service.getTsw();
        target.openEnable = ko.observable(tsw.openEnable == "" ? '0' : tsw.openEnable);
        target.openH = ko.observable(tsw.openH);
        target.openM = ko.observable(tsw.openM);
        target.closeH = ko.observable(tsw.closeH);
        target.closeM = ko.observable(tsw.closeM);
        //定时休眠唤醒
        target.saveTsw = smSaveTsw;

        function smSetWifiRange() {
            service.getWpsInfo({}, function (smInfo) {
                if (smInfo.wpsFlag == '1') {
                    showAlert('wps_on_info');
                } else if (smInfo.radioFlag == '0') {
                    showAlert('wps_wifi_off');
                } else {
                    showConfirm('wifi_sleep_confirm', function () {
                        showLoading('waiting');
                        target.setWifiRangeAct();
                    });

                }
            });
        }
        function smSetSleepModeAct() {
            var params = {};
            params.sleepMode = target.selectedMode();
            service.setSleepMode(params, function (result) {
                if (result.result != "success") {
                    errorOverlay();
                } else {
                    successOverlay();
                }
            });
        }

        function smSetWifiRangeAct() {
            var params = {};
            params.wifiRangeMode = target.wifiRangeMode();
            service.setWifiRange(params, function (result) {
                if (result.result != "success") {
                    errorOverlay();
                } else {
                    successOverlay();
                }
            });
        }

        function smSetSleepMode() {
            showLoading('waiting');
            service.getWpsInfo({}, function (info) {
                if (info.wpsFlag == '1') {
                    showAlert('wps_on_info');
                } else if (info.radioFlag == '0') {
                    showAlert('wps_wifi_off');
                } else {
                    target.setSleepModeAct();
                }
            });
        }
        function smSaveTsw() {
            if (target.openEnable() == '1') {
                if (Math.abs((target.openH() * 60 + parseInt(target.openM(), 10)) - (target.closeH() * 60 + parseInt(target.closeM(), 10))) < 10) {
                    showAlert('tsw_time_interval_alert');
                    return false;
                }
                showLoading('waiting');
                service.saveTsw({
                    openEnable: target.openEnable(),
                    closeEnable: target.openEnable(),
                    openTime: leftInsert(target.openH(), 2, '0') + ':' + leftInsert(target.openM(), 2, '0'),
                    closeTime: leftInsert(target.closeH(), 2, '0') + ':' + leftInsert(target.closeM(), 2, '0')
                }, smShowRes, $.noop);
            } else {
                showLoading('waiting');
                service.saveTsw({
                    openEnable: target.openEnable(),
                    closeEnable: target.openEnable()
                }, smShowRes, $.noop);
            }

        }

    }
    function bindContainer(smVm) {
        var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(smVm, container[0]);

        $('#frmTsw').validate({
            submitHandler: function () {
                smVm.saveTsw();
            },
            errorPlacement: function (error, element) {
                if (element.attr("name") == "closeM" || element.attr("name") == "closeH") {
                    $("#closeErrorDiv").html(error);
                } else if (element.attr("name") == "openM" || element.attr("name") == "openH") {
                    $("#openErrorDiv").html(error);
                } else {
                    error.insertAfter(element);
                }
            }
        });

        $('#sleepModeForm').validate({
            submitHandler: function () {
                smVm.setSleepMode();
            }
        });

        $('#wifiRangeForm').validate({
            submitHandler: function () {
                smVm.setWifiRange();
            }
        });

    }
    function initialize() {
        var smVm = new SleepModeViewMode();
        bindContainer(smVm);
    }
    function smShowRes(data) {
        if (data && data.result == "success") {
            successOverlay();
        } else {
            errorOverlay();
        }
    }

    return {
        init: initialize
    };
});

define("wifi_station_info","underscore jquery knockout set service menu".split(" "),
    function (_, $, ko, config, service, menu) {

    var stationUtil = {
        dealElement: function (showEdit, idx) {
            if (idx != "all") {
                if (!showEdit) {
                    $("#edit_btn_" + idx + ",#hostname_txt_" + idx).show();
                    $("#save_btn_" + idx + ",#cancel_btn_" + idx + ",#hostname_input_" + idx).hide();
                } else {
                    $("#edit_btn_" + idx + ",#hostname_txt_" + idx).hide();
                    $("#save_btn_" + idx + ",#cancel_btn_" + idx + ",#hostname_input_" + idx).show();
                }
            } else {
                $("input[id^='hostname_txt_'],a[id^='edit_btn_']").show();
                $("input[id^='hostname_input_'],a[id^='cancel_btn_'],a[id^='save_btn_']").hide();
            }
        },
        //根据MAC匹配主机名
        getHostName: function (hostName, mac, hostNameList) {
            var element_data = _.find(hostNameList, function (element_data) {
                return element_data.mac == mac;
            });
            return element_data ? element_data.hostname : hostName;
        },
        //匹配黑名单列表和主机名
        parseBlackString: function (macStr, hostnameStr) {
            if (macStr == "") {
                return [];
            }
            var tempMac = macStr.split(';');
            var tempHostName = hostnameStr.split(';');
            var result = [];
            for (var i = 0; i < tempMac.length; i++) {
                //var obj = {};
                //obj.hostName = tempHostName[i];
                //obj.macAddress = tempMac[i];
                result.push({
                    hostName: tempHostName[i],
                    macAddress: tempMac[i]
                });
            }
            return result;
        }
    };

    function staInfoViewMode() {
        var target = this;
        var originalData = {
            user_ip: '',
            macList: '',
            ACL_mode: 2, //黑白名单
            hostnameList: ''
        };
        target.showCableDiv = config.PRODUCT_TYPE == 'CPE' && config.RJ45_SUPPORT;
        target.supportBlock = config.STATION_BLOCK_SUPPORT;
        var pcMenu = menu.findMenu('#parental_control');
        target.showPCLink = pcMenu && pcMenu.length > 0 && config.HAS_PARENTAL_CONTROL;

        target.deviceInfo = ko.observableArray([]);
        target.cableDeviceInfo = ko.observableArray([]);
        target.blackDevices = ko.observableArray([]);
        target.blackDevicesMac = ko.computed(function () {
            return _.map(target.blackDevices(), function (element_data) {
                return element_data.macAddress;
            });
        });
        target.showBlackDiv = ko.observable(config.HAS_BLACK_AND_WHITE_FILTER ? (originalData.ACL_mode == '2' ? true : false) : config.STATION_BLOCK_SUPPORT);

        ko.computed(function () {
            target.deviceInfo();
            target.cableDeviceInfo();
            target.blackDevices();
            $("#station_info_div").translate();
        }).extend({
            notify: 'always',
            throttle: 300
        });

        var hostNameList = service.getHostNameList({}).devices;
        //获取WiFi已连接设备
        target.fetchAttachedDevices = function (cb) {
            service.getCurrentlyAttachedDevicesInfo({}, function (data) {
                if (editingHostname) {
                    return false;
                }
                target.deviceInfo(_.map(data.attachedDevices, function (element_data, idx) {
                        element_data.idx = _.uniqueId('wireless_');
                        element_data.type = 1;
                        element_data.inBlackGroup = config.HAS_BLACK_AND_WHITE_FILTER && originalData.ACL_mode != '2' ? false : _.contains(target.blackDevicesMac(), element_data.macAddress);
                        element_data.hostName = stationUtil.getHostName(element_data.hostName, element_data.macAddress, hostNameList);
                        element_data.disableFlag = (config.HAS_BLACK_AND_WHITE_FILTER && originalData.ACL_mode != '2') || element_data.inBlackGroup || editingHostname;
                        return element_data;
                    }));
                if (_.isFunction(cb)) {
                    cb.apply(this);
                }
            });
        };
        //获取RJ45已连接设备
        target.fetchAttachedCableDevices = function (cb) {
            service.getAttachedCableDevices({}, function (data) {
                if (editingHostname) {
                    return false;
                }
                target.cableDeviceInfo(_.map(data.attachedDevices, function (element_data, idx) {
                        element_data.idx = _.uniqueId('cable_');
                        element_data.hostName = stationUtil.getHostName(element_data.hostName, element_data.macAddress, hostNameList);
                        element_data.type = 2;
                        return element_data;
                    }));
                if (_.isFunction(cb)) {
                    cb.apply(this);
                }
            });
        };

        target.fetchBlacklist = function (cb) {
            service.getMacFilterInfo({}, function (data) {
                originalData.ACL_mode = data.ACL_mode;
                originalData.user_ip = data.user_ip_addr;
                originalData.hostnameList = data.wifi_hostname_black_list;
                originalData.macList = data.wifi_mac_black_list;
                target.showBlackDiv(config.HAS_BLACK_AND_WHITE_FILTER ? (originalData.ACL_mode == '2' ? true : false) : config.STATION_BLOCK_SUPPORT);
                var blackDevices = stationUtil.parseBlackString(data.wifi_mac_black_list, data.wifi_hostname_black_list);
                target.blackDevices(_.map(blackDevices, function (element_data, idx) {
                        element_data.idx = _.uniqueId('black_');
                        element_data.type = 3;
                        element_data.hostName = stationUtil.getHostName(element_data.hostName, element_data.macAddress, hostNameList);
                        return element_data;
                    }));
                if (_.isFunction(cb)) {
                    cb.apply(this);
                }
            }, $.noop);
        };
        target.fetchBlacklist();
        target.fetchAttachedDevices();
        if (target.showCableDiv) {
            target.fetchAttachedCableDevices();
        }

        var editingHostname = 0;
        addInterval(function () {
            if (editingHostname == 0) {
                target.fetchAttachedDevices();
            }
        }, 3000);

        if (target.showCableDiv) {
            addInterval(function () {
                if (editingHostname == 0) {
                    target.fetchAttachedCableDevices();
                }
            }, 5000);
        }
        //WiFi已连接设备列表中屏蔽按钮事件 入黑名单
        target.wirelessBlockHandler = stationBlockEvent;
        //保存主机名事件
        target.saveHostNameHandler = saveHostNameEvent;
        //主机名修改按钮点击事件
        target.editHostNameHandler = function (element_data) {
            editingHostname++;
            $("#hostname_input_" + element_data.idx).val(element_data.hostName);
            stationUtil.dealElement(true, element_data.idx);
            return false;
        };
        //取消编辑主机名事件
        target.cancelEditHostNameHandler = function (element_data) {
            stationUtil.dealElement(false, element_data.idx);
            editingHostname--;
        };
        target.cancelAllEditHostNameHandler = function () {
            stationUtil.dealElement(false, "all");
            editingHostname = 0;
        };
        //从黑名单列表中移除
        target.blacklistRemoveHandler = function (element_data) {
            if (originalData.macList.indexOf(element_data.macAddress) == -1) {
                return false;
            }
            if (editingHostname) {
                target.cancelAllEditHostNameHandler();
            }
            showLoading('waiting');
            var macArr = [];
            var hostnameArr = [];
            $.each(target.blackDevices(), function (i, n) {
                if (n.macAddress != element_data.macAddress) {
                    macArr.push(n.macAddress);
                    hostnameArr.push(n.hostName);
                }
            });
            var params = {
                ACL_mode: '2', //originalData.ACL_mode
                macFilteringMode: '2', //originalData.ACL_mode
                wifi_hostname_black_list: hostnameArr.join(';'),
                wifi_mac_black_list: macArr.join(';')
            };
            target.updateMacFilterList(params);
        };
        target.updateMacFilterList = function (params) {
            service.setMacFilter(params, function (data) {
                if (data.result == "success") {
                    target.blackDevices([]);
                    target.fetchBlacklist(function () {
                        target.fetchAttachedDevices(function () {
                            successOverlay();
                        });
                    });
                }
            }, function () {
                errorOverlay();
            });
        };

        function saveHostNameEvent(element_data) {
            var $input = $("#hostname_input_" + element_data.idx);
            var newHostname = $input.val();
            if (newHostname.indexOf(" ") == 0 || newHostname.lastIndexOf(" ") == (newHostname.length - 1) || /[\*\$\[&:,;<>'"\\`\]￥]{1,32}/.test(newHostname)) {
                showAlert('device_rename');
                return false;
            } else if (newHostname == '') {
                $(".promptErrorLabel", "#confirm-message-container").text($.i18n.prop("required"));
                var $closestTD = $input.closest('td').addClass('has-error');
                addTimeout(function () {
                    $closestTD.removeClass('has-error');
                }, 5000);
                showAlert('required');
                return false;
            }
            showLoading('waiting');
            element_data.hostName = newHostname;
            service.editHostName({
                hostname: element_data.hostName,
                mac: element_data.macAddress
            }, function () {
                editingHostname = 0;
                service.getHostNameList({}, function (data) {
                    hostNameList = data.devices;
                    if (element_data.type == 3) {
                        target.fetchBlacklist(function () {
                            hideLoading();
                            successOverlay();
                        });
                    } else if (element_data.type == 2) {
                        target.fetchAttachedCableDevices(function () {
                            hideLoading();
                            successOverlay();
                        });
                    } else if (element_data.type == 1) {
                        target.fetchAttachedDevices(function () {
                            hideLoading();
                            successOverlay();
                        });
                    }
                });
            }, function () {
                errorOverlay();
            });
        }

        function stationBlockEvent(element_data) {
            if (config.HAS_BLACK_AND_WHITE_FILTER && originalData.ACL_mode != '2') {
                return false;
            }
            if (originalData.macList.split(';').length == 10) {
                showAlert('black_list_max');
                return false;
            }
            if (originalData.macList.indexOf(element_data.macAddress) != -1) {
                return false;
            }
            if (element_data.ipAddress == originalData.user_ip) {
                showAlert('black_yourself_tip');
                return false;
            }
            if (editingHostname) {
                target.cancelAllEditHostNameHandler();
            }
            showLoading('waiting');
            var newHostnameList = originalData.hostnameList == '' ? element_data.hostName : element_data.hostName + ';' + originalData.hostnameList;
            var newMacList = originalData.macList == '' ? element_data.macAddress : element_data.macAddress + ';' + originalData.macList;
            var params = {
                ACL_mode: '2',
                wifi_hostname_black_list: newHostnameList,
                wifi_mac_black_list: newMacList
            };
            target.updateMacFilterList(params);
        }

    }

    function bindContainer(ws_vm) {
        var container = $('#container')[0];
        ko.cleanNode(container);
        ko.applyBindings(ws_vm, container);
    }
    function initialize() {
        var ws_vm = new staInfoViewMode();
        bindContainer(ws_vm);
    }

    return {
        init: initialize
    };
});

define("wifi_wps","underscore jquery knockout set service".split(" "),
    function (_, $, ko, config, service) {

    var viaWifi = false;

    function WpsViewMode() {
        var target = this;
        target.hasMultiSSID = config.HAS_MULTI_SSID;
        target.hasAPStation = config.AP_STATION_SUPPORT;
        target.hasWifiSwitch = config.WIFI_SWITCH_SUPPORT;
        target.hasWlanMacfilter = config.HAS_BLACK_AND_WHITE_FILTER;

        target.wpsType = ko.observable('');
        target.wpsPin = ko.observable('');

        var state = getWpsState();
        target.origin_ap_station_enable = state.ap_station_enable;

        target.wpsFlag = ko.observable(state.wpsFlag);
        target.authMode = ko.observable(state.authMode);

        target.radioFlag = ko.observable(state.radioFlag);
        target.encrypType = ko.observable(state.encrypType);

        target.mulOption = ko.observable(paintSSIDOption(state));
        target.wpsSSID = ko.observable(getSSIDCurrWps(state));

        var infoBasic = service.getWifiBasic();
        target.wifi_enable = ko.observable(infoBasic.wifi_enable);

        target.isShowSSIDInfoDiv = ko.observable(false);
        if (config.WIFI_SWITCH_SUPPORT) { //软开关
            if (infoBasic.wifi_enable == "1") {
                target.isShowSSIDInfoDiv(true);
            } else {
                target.isShowSSIDInfoDiv(false);
            }
        } else {
            target.isShowSSIDInfoDiv(true);
        }
        target.multi_ssid_enable = ko.observable(infoBasic.multi_ssid_enable);
        target.origin_multi_ssid_enable = infoBasic.multi_ssid_enable;

        target.save = wpa_save;

        if (state.wpsFlag != '0') {
            target.wpsType(state.wpsType == 'PIN' ? 'PIN' : 'PBC');
        } else {
            target.wpsType('');
        }

        target.setMultiSSIDSwitch = function () {
            if (target.checkSettings("switch")) {
                return;
            }

            function wpsSetSwitch() {
                showLoading('waiting');
                var wps_param = {};
                wps_param.m_ssid_enable = target.multi_ssid_enable();
                if (config.WIFI_SWITCH_SUPPORT) {
                    wps_param.wifiEnabled = target.wifi_enable();
                }
                service.setWifiBasicMultiSSIDSwitch(wps_param, function (result) {
                    if (result.result == "success") {
                        if (!viaWifi) {
                            addInterval(wpsReload, 1000);
                        } else {
                            setTimeout(wpsReloadViaWifi, 15000);
                        }
                    } else {
                        errorOverlay();
                    }
                });
            }

            var setSwitch = wpsSetSwitch;
            var state = service.getStatusInfo();
            if (target.wifi_enable() == "1" && config.HAS_MULTI_SSID) {
                if (target.multi_ssid_enable() == "1" && config.AP_STATION_SUPPORT && target.origin_ap_station_enable == "1") {
                    if (!state.wifiStatus) {
                        showConfirm("multi_ssid_enable_confirm", function () {
                            setSwitch();
                        });
                    } else {
                        showConfirm("multi_ssid_enable_confirm2", function () {
                            setSwitch();
                        });
                    }
                } else {
                    if (!state.wifiStatus) {
                        setSwitch();
                    } else {
                        showConfirm("wifi_disconnect_confirm2", function () {
                            setSwitch();
                        });
                    }
                }
            } else {
                setSwitch();
            }

            function wpsReload() {
                var state = service.getWifiBasic();
                if (state.wifi_enable == target.wifi_enable()) {
                    successOverlay();
                    clearTimer();
                    clearValidateMsg();
                    service.refreshAPStationStatus();
                    initialize();
                }
            }
            function wpsReloadViaWifi() {
                successOverlay();
                setTimeout(function () {
                    window.location.reload();
                }, 1000);
                clearTimer();
                clearValidateMsg();
                service.refreshAPStationStatus();
                initialize();
            }

        };

        target.checkSettings = function (ssid) {
            var state = getWpsState();
            if (state.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }
            return false;
        };

        function wpa_save() {
            var state = getWpsState();

            if (state.radioFlag == '0') {
                showAlert('wps_wifi_off');
                return;
            }

            if (state.wpsFlag == '1') {
                showAlert('wps_on_info');
                return true;
            }

            if (target.wpsSSID() == "SSID1") {
                var res = (state.AuthMode == "OPEN" && state.encrypType == "WEP")
                 || (state.AuthMode == "SHARED" && state.encrypType == "WEP")
                 || (state.AuthMode == "WPAPSK" && state.encrypType == "TKIP")
                 || (state.AuthMode == "WPAPSK" && state.encrypType == "TKIPCCMP")
                 || (state.AuthMode == "WPAPSK" && state.encrypType == "AES")
                 || (state.AuthMode == "WPA2PSK" && state.encrypType == "TKIP")
                 || (state.AuthMode == "WPAPSKWPA2PSK" && state.encrypType == "TKIP")
                 || (state.AuthMode == "WPA3Personal")
                 || (state.AuthMode == "WPA2WPA3");
                if (res) {
                    showAlert('wps_auth_open');
                    return;
                }
            } else {
                var resm = (state.m_AuthMode == "OPEN" && state.m_encrypType == "WEP")
                 || (state.m_AuthMode == "SHARED" && state.m_encrypType == "WEP")
                 || (state.m_AuthMode == "WPAPSK" && state.m_encrypType == "TKIP")
                 || (state.m_AuthMode == "WPAPSK" && state.m_encrypType == "TKIPCCMP")
                 || (state.m_AuthMode == "WPAPSK" && state.m_encrypType == "AES")
                 || (state.m_AuthMode == "WPA2PSK" && state.m_encrypType == "TKIP")
                 || (state.m_AuthMode == "WPAPSKWPA2PSK" && state.m_encrypType == "TKIP")
                 || (state.m_AuthMode == "WPA3Personal")
                 || (state.m_AuthMode == "WPA2WPA3");
                if (resm) {
                    showAlert('wps_auth_open');
                    return;
                }
            }

            var wpsSSID;
            var wpsIndex;
            if (target.wpsSSID() != "SSID1") {
                wpsSSID = state.multiSSID;
                wpsIndex = 2;
            } else {
                wpsSSID = state.ssid;
                wpsIndex = 1;
            }

            var basic = service.getWifiBasic();
            if (wpsSSID == basic.m_SSID && wpsIndex == 2) {
                if (basic.m_broadcast == '1') {
                    showAlert('wps_ssid_broadcast_disable');
                    return;
                }
            } else if (wpsSSID == basic.SSID && wpsIndex == 1) {
                if (basic.broadcast == '1') {
                    showAlert('wps_ssid_broadcast_disable');
                    return;
                }
            }

            showLoading('waiting');
            var wps_param = {};
            wps_param.wpsType = target.wpsType();
            wps_param.wpsSSID = wpsSSID;
            wps_param.wpsIndex = wpsIndex;
            wps_param.wpsPin = getWpsPin(target.wpsPin());

            service.openWps(wps_param, function (result) {
                if (result.result != "success") {
                    errorOverlay();
                } else {
                    target.wpsPin('');
                    clearValidateMsg();
                    successOverlay();
                }
            });
        }

    }

    function getWpsPin(value) {
        if (value.length != 9) {
            return value;
        } else {
            return value.substring(0, 4) + value.substring(5);
        }
    }

    function getWpsState() {
        return service.getWpsInfo();
    }

    function paintSSIDOption(info) {
        var show_opt = [];
        show_opt.push(new Option(info.ssid, "SSID1"));
        if (info.ssidEnable == "1") {
            show_opt.push(new Option(info.multiSSID, "SSID2"));
        }
        return show_opt;
    }

    //检查当前是否通过wifi登录webui
    function checkAccessMode() {
        service.getParams({
            nv: 'user_ip_addr'
        }, function (dataIp) {
            service.getParams({
                nv: 'station_list'
            }, function (dataList) {
                viaWifi = isWifiConnected(dataIp.user_ip_addr, dataList.station_list);
            });
        });
    }
    function bindContainer(wpsVm) {
        var container = $('#container');
        ko.cleanNode(container[0]);
        ko.applyBindings(wpsVm, container[0]);

        addTimeout(function () {
            checkAccessMode();
        }, 600);

        $('#wpsForm').validate({
            submitHandler: function () {
                wpsVm.save();
            },
            rules: {
                txtPin: {
                    "wps_pin_validator": true
                }
            }
        });

        $('#frmWifiSwitch').validate({
            submitHandler: function () {
                wpsVm.setMultiSSIDSwitch();
            }
        });
    }
    function getSSIDCurrWps(info) {
        if (info.ssid != info.multiSSID) {
            return info.wpsSSID == info.multiSSID ? "SSID2" : "SSID1";
        } else {
            if (info.wifi_wps_index == '2') {
                return "SSID2";
            } else {
                return "SSID1";
            }
        }
    }
    //视图初始化
    function initialize() {
        var wpsVm = new WpsViewMode();
        bindContainer(wpsVm);
    }

    return {
        init: initialize
    };
});

