#ifdef CONFIG_SINGLECORE

#include <linux/module.h>
#include <linux/errno.h>

#define CPPS_INIT2_FUNC_MAX  10
static int (*cpps_init2_funcs[CPPS_INIT2_FUNC_MAX]) (void);

int cpps_init2_register(int (*function) (void))
{
	int i;

	for (i = 0; i < CPPS_INIT2_FUNC_MAX; i++) {
		if (cpps_init2_funcs[i] == 0) {
			cpps_init2_funcs[i] = function;
			return 0;
		}
	}

	return -ENOMEM;
}

EXPORT_SYMBOL(cpps_init2_register);

void cpps_init2(void)
{
	int i;
	int ret = 0;

	for (i = 0; i < CPPS_INIT2_FUNC_MAX; i++) {
		if (cpps_init2_funcs[i] != 0) {
			ret = cpps_init2_funcs[i] ();
			if (ret != 0) {
				printk(KERN_ERR "init2_func: init failed\n");
				panic("cpps_init2 failed");
			}
		}
	}
}

EXPORT_SYMBOL(cpps_init2);

#endif
