/**
 * 
 * @file      logcat_drv.h
 * @brief     
 *            This file is part of ZCAT.
 *            zcatlog豸ͷļ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

/* AP LOG BEGIN */
#ifndef _LOGCAT_DRV_H
#define _LOGCAT_DRV_H

/* AP LOG module name */
#define MODULE_NUMBER           24
#define MODULE_NUMBER_MAX       255

#define MODULE_PRINTF           1   // ԭprintf
#define MODULE_PRINTK           2   // ԭprintk
#define MODULE_CALL             3   // ͨ
#define MODULE_MESSAGE          4   // Ϣ
#define MODULE_DATA             5   // ҵ
#define MODULE_SETTING          6   // ù
#define MODULE_DISPLAY          7   // ʾ
#define MODULE_INTERNET         8   // 
#define MODULE_INSTALL          9   // װ
#define MODULE_FOTA             10  // 
#define MODULE_DIAGNOSIS        11  // Ϲ
#define MODULE_SYSTEM_LOG       12  // ϵͳ־
#define MODULE_T_CARD           13  // Tҵ
#define MODULE_DRIVERS          14  // 
#define MODULE_PROTOCOL         15  // Э
#define MODULE_DM               16  // 豸
#define MODULE_WIFI             17  // WIFI߿
#define MODULE_APN              18  // APN
#define MODULE_POWER            19  // ʡ
#define MODULE_WEB_UI           20  // WEBû
#define MODULE_PC_UI            21  // PCû
#define MODULE_PC_TOOLS         22  // PC
#define MODULE_AP_LOG           23  // AP LOG
#define MODULE_OTHERS           24  // 

/* AP LOG module level */
#define MODULE_LEVEL_EMERG      0   // ¼Ϣϵͳ֮ǰʾʾϵͳ
#define MODULE_LEVEL_ALERT      1   // Ϣʾȡʩ
#define MODULE_LEVEL_CRIT       2   // ٽͨ漰صӲʧ
#define MODULE_LEVEL_ERR        3   // KERN_ERRӲĴ
#define MODULE_LEVEL_WARNING    4   // Կܳо
#define MODULE_LEVEL_NOTICE     5   // Ҫ
#define MODULE_LEVEL_INFO       6   // ʾϢʱӡӲϢ
#define MODULE_LEVEL_DEBUG      7   // ԼϢ
/* AP LOG END */

#define LEVEL_EMERG             1   // ¼Ϣϵͳ֮ǰʾʾϵͳ
#define LEVEL_ALERT             2   // Ϣʾȡʩ
#define LEVEL_CRIT              4   // ٽͨ漰صӲʧ
#define LEVEL_ERR               8   // KERN_ERRӲĴ
#define LEVEL_WARNING           16  // Կܳо
#define LEVEL_NOTICE            32  // Ҫ
#define LEVEL_INFO              64  // ʾϢʱӡӲϢ
#define LEVEL_DEBUG             128 // ԼϢ
#define LEVEL_ALL               255 // мĬǴӡм


typedef unsigned int    UINT32; 
typedef unsigned char   UINT8;  

#define BOOL int
#define VOID void


typedef enum
{
    ZCAT_IPC_SYN = 0xA0,
    ZCAT_IPC_ACK,
    ZCAT_IPC_ESTABLISHED,
    ZCAT_IPC_SET_TTY,
    ZCAT_IPC_SET_PERIPHERAL_MODE,
    ZCAT_IPC_STOP,
    ZCAT_IPC_START,
    ZCAT_IPC_EXIT,
#ifdef _USE_VEHICLE_DC
    ZCAT_IPC_ALLOC_CAP_SMLOGBUF,
#endif
    ZCAT_IPC_READ_IRAM_ZCAT_MODE,
    ZCAT_IPC_SET_VEHICLE_WAKE_SIGN,
} E_ZCAT_IPC_HANDSHAKE;

/* zcatȫϢ */
typedef struct
{
    int  status;
    int  peripheral_mode;
    char usblog_path[8];
} T_ZCAT_CONFIG_INFO;


#endif /* !_LOGCAT_DRV_H */
