/**
 * 
 * @file      cp_log_drv.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatcplog豸
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/18
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/02/18  1.2      jiang.fenglin  ̬LOG˿,log˿ڶֻ̬usbΪģʽģʽֲ
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/ioport.h>
#include <linux/serial_reg.h>
#include <linux/poll.h>
#include <linux/delay.h>
#include <linux/wait.h>
#include <linux/err.h>
#include <linux/interrupt.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/device.h>
#include <linux/miscdevice.h>
#include <linux/spinlock.h>
#include <linux/list.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/kthread.h>
#include <linux/vmalloc.h>
#include <linux/sysctl.h>
#include <asm/io.h>
#include "logcat_drv.h"
#include "ringbuf.h"

/**
 * 궨
 */
#define RAMDUMP_MODE_ADDR         (int *)IRAM_BASE_ADDR_RAMDUMP_MODE 

#ifdef _USE_VEHICLE_DC
#define RINGBUF_CAP_TO_AP_OFFSET  (ICP_CAP_BUF_LEN + TOOL_CAP_BUF_LEN)
#define RINGBUF_AP_TO_CAP_OFFSET  (RINGBUF_CAP_TO_AP_OFFSET + RINGBUF_CAP_TO_AP_LEN + ADB_CAP_BUF_LEN + RAMDUMP_CAP_CMM_BUF_LEN)
#endif

/**
 * ⲿ
 */
extern size_t Comm_Read_CP_TO_AP_Data(const char __user *buf, size_t len);
extern size_t Comm_Write_AP_TO_CP_Data(const char __user *buf, size_t len);

static int     cplog_open(struct inode *ip, struct file *fp);
static int     cplog_release(struct inode *ip, struct file *fp);
static long    cplog_ioctl(struct file *fp, unsigned int cmd, unsigned long arg);
static ssize_t cplog_read(struct file *fp, char __user *buf,size_t count, loff_t *pos);
static ssize_t cplog_write(struct file *fp, const char __user *buf,size_t count, loff_t *pos);

T_ZCAT_CONFIG_INFO gZcatConfig = {
    .peripheral_mode = 0xC5, // ZCAT_MODE_CP_USB
    .status = 0,
    .usblog_path = "ttyGS2",
};
EXPORT_SYMBOL(gZcatConfig);

T_RINGBUFFER *g_AP_ApToCpBuffer = NULL;
EXPORT_SYMBOL(g_AP_ApToCpBuffer);

T_RINGBUFFER *g_AP_CpToApBuffer = NULL;
EXPORT_SYMBOL(g_AP_CpToApBuffer);

#ifdef _USE_VEHICLE_DC
T_RINGBUFFER *g_AP_ApToCapBuffer = NULL;
EXPORT_SYMBOL(g_AP_ApToCapBuffer);

T_RINGBUFFER *g_AP_CapToApBuffer = NULL;
EXPORT_SYMBOL(g_AP_CapToApBuffer);
#endif

static const struct file_operations cplog_fops = {
    .owner = THIS_MODULE,
    .read = cplog_read,
    .write = cplog_write,
    .open = cplog_open,
    .release = cplog_release,
    .unlocked_ioctl = cplog_ioctl,
};
static struct miscdevice cplog_device = {
    .minor = MISC_DYNAMIC_MINOR,
    .name = "cplog",
    .fops = &cplog_fops,
};

#ifdef _USE_VEHICLE_DC
static struct ctl_table cfg_logcom_array[] = {
    {
        .procname   = "ramdump_save_mode",
        .data       = RAMDUMP_MODE_ADDR,
        .maxlen     = sizeof(int),
        .mode       = 0644,
        .proc_handler  = proc_dointvec_minmax,
    },
    { }
};

static struct ctl_table sysctl_logcom_table[] = {
    {
        .procname   = "zcatkern",
        .mode       = 0555,
        .child      = cfg_logcom_array,
    },
    { }
};
#endif

static ssize_t cplog_read(struct file *fp, char __user *buf, size_t count, loff_t *pos)
{
    size_t cpbufLen = 0;
    
    //printk("cplog_read\n");
    if(buf && count)
    {
        //char *cpbuf = kzalloc(count*sizeof(UINT8), GFP_KERNEL);
        //if(cpbuf)
        //{
#ifndef CONFIG_SYSTEM_RECOVERY
       cpbufLen = CPPS_FUNC(cpps_callbacks, Comm_Read_CP_TO_AP_Data)(buf,count);
#endif
        //   copy_to_user(buf, cpbuf, cpbufLen);
        //   kfree(cpbuf);
        //}
        
        //printk("cplog_read %d\n", cpbufLen);
    }
    return cpbufLen;
}

static ssize_t cplog_write(struct file *fp, const char __user *buf, size_t count, loff_t *pos)
{
    size_t cpbufLen = 0;
    
    //printk("cplog_write\n");
    if (buf && count)
    {
        //char *cpbuf = kzalloc(count*sizeof(UINT8), GFP_KERNEL);
        //if(cpbuf)
        //{
        //  copy_from_user(cpbuf, buf, count);

#ifndef CONFIG_SYSTEM_RECOVERY
        cpbufLen = CPPS_FUNC(cpps_callbacks, Comm_Write_AP_TO_CP_Data)(buf, count);
#endif
        //    kfree(cpbuf);
        //}
        
        //printk("cplog_write %d\n", cpbufLen);
    }
    return cpbufLen;

}

static int cplog_open(struct inode *ip, struct file *fp)
{
    printk("cplog open.\n");
    return 0;
}

static int cplog_release(struct inode *ip, struct file *fp)
{
    printk("cplog release.\n");
    return 0;
}

static long cplog_ioctl(struct file *fp, unsigned int cmd, unsigned long arg)
{
    //printk("[tool] %s, cmd = %d., tty = %s\n", __func__, cmd, gZcatConfig.usblog_path);
    switch(cmd)
    {
        case ZCAT_IPC_SET_PERIPHERAL_MODE:
        {
            if(arg >= 0xC1 && arg <= 0xC4)
            {
                if(g_AP_ApToCpBuffer == NULL)
                {
                    UINT8 *buf = vmalloc(0x8000);
                    g_AP_ApToCpBuffer = CreateRingBufferWithSymbol(buf, 0x8000, ZCAT_IPC_ESTABLISHED);
                    if(!g_AP_ApToCpBuffer)
                    {
                        printk("[tool] %s, create buffer failed.\n", __func__);
                        break;
                    }
                }

                if(g_AP_CpToApBuffer == NULL)
                {
                    UINT8 *buf = vmalloc(0x20000);
                    g_AP_CpToApBuffer = CreateRingBufferWithSymbol(buf, 0x20000, ZCAT_IPC_ESTABLISHED);
                    if(!g_AP_CpToApBuffer)
                    {
                        printk("[tool] %s, create buffer failed.\n", __func__);
                        break;
                    }
                }
                printk("[tool] %s, create buffer success.\n", __func__);
            }
            
            gZcatConfig.peripheral_mode = arg;

            break;
        }
#if _USE_VEHICLE_DC
        case ZCAT_IPC_ALLOC_CAP_SMLOGBUF:
        {
            if(g_AP_CapToApBuffer == NULL)
            {
                UINT8 *buf = (UINT8 *)(ZX_DDR_CAPBUF_BASE + RINGBUF_CAP_TO_AP_OFFSET); 
                g_AP_CapToApBuffer = CreateRingBufferWithSymbol(buf, RINGBUF_CAP_TO_AP_LEN, ZCAT_IPC_ESTABLISHED);

                if(!g_AP_CapToApBuffer)
                {
                    printk("[tool] %s, create buffer failed.\n", __func__);
                    break;
                }
            }
            if(g_AP_ApToCapBuffer == NULL)
            {
                UINT8 *buf = (UINT8 *)(ZX_DDR_CAPBUF_BASE + RINGBUF_AP_TO_CAP_OFFSET);
                g_AP_ApToCapBuffer = CreateRingBufferWithSymbol(buf, RINGBUF_AP_TO_CAP_LEN, ZCAT_IPC_ESTABLISHED);
                if(!g_AP_ApToCapBuffer)
                {
                    printk("[tool] %s, create buffer failed.\n", __func__);
                    break;
                }
            }
        }
#endif
        case ZCAT_IPC_SET_TTY:
        {
            if(copy_from_user(gZcatConfig.usblog_path , (void __user *)arg, sizeof(gZcatConfig.usblog_path)))
                return -1;
            break;
        }
        case ZCAT_IPC_READ_IRAM_ZCAT_MODE:
        {
            if(copy_to_user((void __user *)arg, (UINT32 *)(IRAM_BASE_ADDR_ZCAT_MODE), sizeof(UINT32)))
                return -1;
            break;
        }
        case ZCAT_IPC_SYN:
        {
            gZcatConfig.status = 1;
            break;
        }
        case ZCAT_IPC_ACK:
        {
            if(gZcatConfig.status != 2)
                return -1;
            break;
        }
        case ZCAT_IPC_ESTABLISHED:
        {
            if(gZcatConfig.status == 2)
                gZcatConfig.status = 3;
            break;
        }
    }

    return 0;
}

static int __init cplog_init(void)
{
    int ret = 0;
    
#ifdef _USE_VEHICLE_DC
    register_sysctl_table(sysctl_logcom_table);
#endif

    ret = misc_register(&cplog_device);
    
    printk("cplog_init.\n");
    if (ret)
    {
        printk(KERN_ERR "cplog driver init failed.\n");
    }

    return ret;
}

static void __exit cplog_exit(void)
{
    printk("cplog_exit.\n");
    misc_deregister(&cplog_device);
}

module_init(cplog_init);
module_exit(cplog_exit);

MODULE_AUTHOR("jinkai");
MODULE_DESCRIPTION("zCat cplog driver");
MODULE_LICENSE("GPL");


