/*
 * (C) Copyright 2016 ZXIC Inc.
 *
 */

#include <common.h>
#include "../../drivers/config.h"


// ϵͳʱ
typedef struct
{
	u32		ctrl;					// ϵͳʱӿ
	u32		reload;					// ֵ
	u32		count;					// ǰֵ
	u32		calibration;			// У׼ֵ

} t_tick;


volatile t_tick	 g_tick; 


// ʱӳʼ
void timer_init(void)
{
	volatile t_tick	*tick 	= (t_tick*)(&g_tick);
	tick->ctrl				= 0;
	tick->count		        = 0;
	tick->reload			= (u32)-1;
	tick->ctrl				= 0x05;
}

// עʱ 24λ
void usdelay(u32 us)
{
	int t0, t1, t2, t3;

	volatile t_tick	*tick 	= (t_tick*)(&g_tick);

	t0  	= tick->count;
	t1		= us * (SYS_CPU_FREQ / 1000000);

	if(t1 <= t0)
	{
		t2	= t0 - t1;
		while((t3 = tick->count) > t2)
		{
			if(t3 > 0xFFFF00) break;
		}
	}
	else
	{
		t2	= 0x00FFFFFF + t0 - t1;
		while(1)
		{
			t1 = tick->count;
			if((t1 >= t0) && (t1 <= t2)) break;
		}
	}
}

