/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_cp_reset.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-4-22
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_nand.h"
#include "downloader_config.h"
#include "errno.h"
#include <asm/io.h>

/****************************************************************************
*							Global Function Prototypes
****************************************************************************/

extern int downloader_serial_write(const char * buffer,unsigned int len);
extern char *tsp_console_buffer;

/*******************************************************************************
 * Function:do_reboot
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_reboot(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    char *ack = tsp_console_buffer;
    uint32_t reg_start = 0;
		
    if(argc < 1)
    {
        return cmd_usage(cmdtp);
    }
    
    sprintf(ack,"OKAY REBOOT");
    downloader_serial_write(ack, strlen(ack)+1);
	
    run_command("reset",0);
    return 0;
}

U_BOOT_CMD(
	reboot, CONFIG_SYS_MAXARGS, 0, do_reboot,
	"reboot: reboot",
	""
);

        
