/*******************************************************************************
* Ȩ (C)2013, ͨѶɷ޹˾
* 
* ļ:     hal_cache.h
* ļʶ:     hal_cache.h
* ժҪ:     arm cpu cacheöģ
* ʹ÷:     #include <cyg/hal/hal_cache.h>
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/04/03      V1.0        Create                    
* 
*******************************************************************************/

#ifndef CYGONCE_HAL_CACHE_H
#define CYGONCE_HAL_CACHE_H

#include <asm/armv7.h>
#include <asm/proc-armv/system.h>

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define CYG_MACRO_START  do {
#define CYG_MACRO_END   }while(0)
#define HAL_ARM_MODE(x)
#define HAL_THUMB_MODE(x)

#define HAL_DSB() CP15DSB

#ifdef __GNUC__

//-----------------------------------------------------------------------------
// Global control of Instruction cache

// Enable the instruction cache
#define HAL_ICACHE_ENABLE()                                                 \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc  p15, 0, r4, c1, c0, 0;"                                       \
        "orr  r4, r4, #0x1000;"                                             \
        "orr  r4, r4, #0x0002;" /* enable ICache (also ensures   */         \
                                /* that alignment faults         */         \
                                /* is enabled)                   */         \
        "mcr  p15, 0, r4, c1, c0, 0;"                                       \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
CYG_MACRO_END

// Disable the instruction cache (and invalidate it, required semanitcs)
#define HAL_ICACHE_DISABLE()                                                \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc    p15, 0, r4, c1, c0, 0;"                                     \
        "bic    r4, r4, #0x1000;" /* disable ICache               */        \
        "mcr    p15, 0, r4, c1, c0, 0;"                                     \
        "mov    r4, #0;"                                                    \
        "mcr    p15, 0, r4, c7, c5, 0;" /* invalidate ICache */             \
        "mcr    p15, 0, r4, c8, c5, 0;" /* invalidate I-TLB unlocked */     \
        HAL_THUMB_MODE(r4)                                                  \
        "nop;" /* next few instructions may be via cache    */              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop"                                                               \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
CYG_MACRO_END

// Query the state of the instruction cache
#define HAL_ICACHE_IS_ENABLED(_state_)                                      \
CYG_MACRO_START                                                             \
    register u32 reg;                                                \
                                                                            \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc    p15, 0, %0, c1, c0, 0;"                                     \
        HAL_THUMB_MODE(r4)                                                  \
        : "=r"(reg)                                                         \
        :                                                                   \
        : HAL_ARM_THUMB_REG(r4) /* Clobber list */                          \
    );                                                                      \
    (_state_) = (0 != (0x1000 & reg)); /* Bit 12 is ICache enable */        \
CYG_MACRO_END

// Invalidate the cache by address
#define HAL_ICACHE_INVALIDATE_BY_MVA(_value_)                               \
CYG_MACRO_START                                                             \
    /* this macro can discard dirty cache lines (N/A for ICache) */         \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mcr    p15, 0, %0, c7, c5, 1;" /* invalidate ICache */             \
        HAL_THUMB_MODE(r4)                                                  \
        "nop;" /* next few instructions may be via cache    */              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        :                                                                   \
        : "r"(_value_)                                                      \
        : HAL_ARM_THUMB_REG(r4)  /* Clobber list */                         \
    );                                                                      \
CYG_MACRO_END

// Invalidate the cache by range
#define HAL_ICACHE_INVALIDATE_BY_RANGE(_addr_, _len_)                       \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mov    r0, %0;"                                                    \
        "mov    r4, %1;"                                                    \
    "1:"                                                                    \
        "mcr    p15, 0, r0, c7, c5, 1;"/* Invalidate i-cache line */        \
        "add    r0, r0, #32;"                                               \
        "subs   r4, r4, #32;"                                               \
        "bgt    1b;"                                                        \
        HAL_THUMB_MODE(r4)                                                  \
        "nop;" /* next few instructions may be via cache    */              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        :                                                                   \
        : "r"(_addr_),"r"(_len_)                                            \
        : "r0", "r4"  /* Clobber list */                                    \
    );                                                                      \
CYG_MACRO_END


// Invalidate the entire cache
#define HAL_ICACHE_INVALIDATE_ALL()                                         \
CYG_MACRO_START                                                             \
    /* this macro can discard dirty cache lines (N/A for ICache) */         \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mov    r4, #0;"                                                    \
        "mcr    p15, 0, r4, c7, c5, 0;" /* invalidate ICache */             \
        "mcr    p15, 0, r4, c8, c5, 0;" /* invalidate I-TLB unlocked */     \
        HAL_THUMB_MODE(r4)                                                  \
        "nop;" /* next few instructions may be via cache    */              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        "nop;"                                                              \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
CYG_MACRO_END

// Synchronize the contents of the cache with memory.
// (which includes flushing out pending writes)
#define HAL_ICACHE_SYNC()                                                   \
CYG_MACRO_START                                                             \
    HAL_DCACHE_SYNC(); /* ensure data gets to RAM */                        \
    HAL_ICACHE_INVALIDATE_ALL(); /* forget all we know */                   \
CYG_MACRO_END

//-----------------------------------------------------------------------------
// Global control of data cache

// Enable the data cache
#define HAL_DCACHE_ENABLE()                                                 \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc    p15, 0, r4, c1, c0, 0;"                                     \
        "orr    r4, r4, #0x0006;" /* enable DCache (also ensures    */      \
                                  /* alignment faults is enabled    */      \
        "mcr    p15, 0, r4, c1, c0, 0;"                                     \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
CYG_MACRO_END

// Disable the data cache (and invalidate it, required semanitcs)
#define HAL_DCACHE_DISABLE()                                                \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc    p15, 0, r4, c1, c0, 0;"                                     \
        "bic    r4, r4, #0x0004;" /* disable DCache                  */     \
                                  /* but not alignment faults         */    \
        "mcr    p15, 0, r4, c1, c0, 0;"                                     \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
    HAL_DCACHE_SYNC();                                                      \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mov    r4, #0;"                                                    \
        "mcr    p15, 0, r4, c8, c6, 0;" /* invalidate I+D TLB unlocked */   \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
CYG_MACRO_END

// Query the state of the data cache
#define HAL_DCACHE_IS_ENABLED(_state_)                                      \
CYG_MACRO_START                                                             \
    register int reg;                                                       \
                                                                            \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc  p15, 0, %0, c1, c0, 0;"                                       \
        HAL_THUMB_MODE(r4)                                                  \
        : "=r"(reg)                                                         \
        :                                                                   \
        : HAL_ARM_THUMB_REG(r4) /* Clobber list */                          \
    );                                                                      \
    (_state_) = (0 != (4 & reg)); /* Bit 2 is DCache enable */              \
CYG_MACRO_END

// Flush the dcache by address
#define HAL_DCACHE_INVALIDATE_BY_MVA(_value_)                               \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mcr    p15, 0, %0, c7, c6, 1;" /* invalidate d-cache */            \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_value_)                                                      \
        : "r4", "memory" /* Clobber list */                                 \
    );                                                                      \
CYG_MACRO_END

// Flush the dcache by range
#define HAL_DCACHE_INVALIDATE_BY_RANGE(_addr_, _len_)                       \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mov    r0, %0;"                                                    \
        "mov    r4, %1;"                                                    \
    "1:"                                                                    \
        "mcr    p15, 0, r0, c7, c6, 1;"/* Invalidate d-cache line */        \
        "add    r0, r0, #32;"                                               \
        "subs   r4, r4, #32;"                                               \
        "bgt    1b;"                                                        \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_addr_),"r"(_len_)                                            \
        : "r0", "r4"  /* Clobber list */                                    \
    );                                                                      \
CYG_MACRO_END

// Clean the dcache by address
#define HAL_DCACHE_CLEAN_BY_MVA(_value_)                                    \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mcr    p15, 0, %0, c7, c10, 1;" /* clean d-cache */                \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_value_)                                                      \
        : "r4", "memory" /* Clobber list */                                 \
    );                                                                      \
CYG_MACRO_END

// Clean the dcache by range
#define HAL_DCACHE_CLEAN_BY_RANGE(_addr_, _len_)                            \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mov    r0, %0;"                                                    \
        "mov    r4, %1;"                                                    \
    "1:"                                                                    \
        "mcr    p15, 0, r0, c7, c10, 1;"/* Clean d-cache line */            \
        "add    r0, r0, #32;"                                               \
        "subs   r4, r4, #32;"                                               \
        "bgt    1b;"                                                        \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_addr_),"r"(_len_)                                            \
        : "r0", "r4"  /* Clobber list */                                    \
    );                                                                      \
CYG_MACRO_END

/*
 * Clean & Invalidate the dcache by address
 */
#define HAL_DCACHE_SYNC_BY_MVA(_value_)                                     \
    CYG_MACRO_START                                                         \
        asm volatile (                                                      \
            HAL_ARM_MODE(r4)                                                \
            "mcr p15, 0, %0, c7, c14, 1;"/*Clean and invalidate data cache*/\
            HAL_THUMB_MODE(r4)                                              \
            :                                                               \
            : "r"(_value_)                                                  \
            : "r4", "memory"  /* Clobber list */                            \
        );                                                                  \
    CYG_MACRO_END

/*
 * Clean & Invalidate the dcache by range
 */
#define HAL_DCACHE_SYNC_BY_RANGE(_addr_, _len_)                             \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mov    r0, %0;"                                                    \
        "mov    r4, %1;"                                                    \
    "1:"                                                                    \
        "mcr    p15, 0, r0, c7, c14, 1;"/* Sync d-cache line */             \
        "add    r0, r0, #32;"                                               \
        "subs   r4, r4, #32;"                                               \
        "bgt    1b;"                                                        \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_addr_),"r"(_len_)                                            \
        : "r0", "r4"  /* Clobber list */                                    \
    );                                                                      \
CYG_MACRO_END

// Flush the dcache by set/way
#define HAL_DCACHE_INVALIDATE_BY_SETWAY(_value_)                            \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mcr    p15, 0, %0, c7, c6, 2;" /* invalidate d-cache */            \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_value_)                                                      \
        : "r4", "memory" /* Clobber list */                                 \
    );                                                                      \
CYG_MACRO_END

// Clean the dcache by set/way
#define HAL_DCACHE_CLEAN_BY_SETWAY(_value_)                                 \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mcr    p15, 0, %0, c7, c10, 2;" /* clean d-cache */                \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        : "r"(_value_)                                                      \
        : "r4", "memory" /* Clobber list */                                 \
    );                                                                      \
CYG_MACRO_END

/*
 * Clean & Invalidate the dcache by set/way
 */
#define HAL_DCACHE_SYNC_BY_SETWAY(_value_)                                  \
    CYG_MACRO_START                                                         \
        asm volatile (                                                      \
            HAL_ARM_MODE(r4)                                                \
            "mcr p15, 0, %0, c7, c14, 2;"/*Clean and invalidate data cache*/\
            HAL_THUMB_MODE(r4)                                              \
            :                                                               \
            : "r"(_value_)                                                  \
            : "r4", "memory"  /* Clobber list */                            \
        );                                                                  \
    CYG_MACRO_END

/*
 * Invalidate the entire dcache
 */
#define HAL_DCACHE_INVALIDATE_ALL()                                         \
    CYG_MACRO_START                                                         \
        asm volatile (                                                      \
            HAL_ARM_MODE(r4)                                                \
            "mrc    p15, 1, r0, c0, c0, 1;"                                 \
            "ands   r3, r0, #0x07000000;"                                   \
            "mov    r3, r3, lsr #23;"                                       \
            "beq    5f;"                                                    \
            "mov    r10, #0;"                                               \
        "1:"                                                                \
            "add    r2, r10, r10, lsr #1;"                                  \
            "mov    r1, r0, lsr r2;"                                        \
            "and    r1, r1, #7;"                                            \
            "cmp    r1, #2;"                                                \
            "blt    4f;"                                                    \
            "mcr    p15, 2, r10, c0, c0, 0;"                                \
            "isb;"                                                          \
            "mrc    p15, 1, r1, c0, c0, 0;"                                 \
            "and    r2, r1, #7;"                                            \
            "add    r2, r2, #4;"                                            \
            "ldr    r4, =0x3FF;"                                            \
            "ands   r4, r4, r1, lsr #3;"                                    \
            "clz    r5, r4;"                                                \
            "mov    r9, r4;"                                                \
        "2:"                                                                \
            "ldr    r7, =0x00007FFF;"                                       \
            "ands   r7, r7, r1, lsr #13;"                                   \
        "3:"                                                                \
            "orr    r11, r10, r9, lsl r5;"                                  \
            "orr    r11, r11, r7, lsl r2;"                                  \
            "mcr    p15, 0, r11, c7, c6, 2;"                                \
            "subs   r7, r7, #1;"                                            \
            "bge    3b;"                                                    \
            "subs   r9, r9, #1;"                                            \
            "bge    2b;"                                                    \
        "4:"                                                                \
            "add    r10, r10, #2;"                                          \
            "cmp    r3, r10;"                                               \
            "bgt    1b;"                                                    \
            "dsb;"                                                          \
        "5:"                                                                \
            HAL_THUMB_MODE(r4)                                              \
            :                                                               \
            :                                                               \
            : "r0", "r1", "r2", "r3", "r4", "r5", "r7", "r9", "r10", "r11"  /* Clobber list */       \
            );                                                              \
    CYG_MACRO_END
    
/*
 * Clean the entire dcache
 */
#define HAL_DCACHE_CLEAN_ALL()                                              \
    CYG_MACRO_START                                                         \
        asm volatile (                                                      \
            HAL_ARM_MODE(r4)                                                \
            "mrc    p15, 1, r0, c0, c0, 1;"                                 \
            "ands   r3, r0, #0x07000000;"                                   \
            "mov    r3, r3, lsr #23;"                                       \
            "beq    5f;"                                                    \
            "mov    r10, #0;"                                               \
        "1:"                                                                \
            "add    r2, r10, r10, lsr #1;"                                  \
            "mov    r1, r0, lsr r2;"                                        \
            "and    r1, r1, #7;"                                            \
            "cmp    r1, #2;"                                                \
            "blt    4f;"                                                    \
            "mcr    p15, 2, r10, c0, c0, 0;"                                \
            "isb;"                                                          \
            "mrc    p15, 1, r1, c0, c0, 0;"                                 \
            "and    r2, r1, #7;"                                            \
            "add    r2, r2, #4;"                                            \
            "ldr    r4, =0x3FF;"                                            \
            "ands   r4, r4, r1, lsr #3;"                                    \
            "clz    r5, r4;"                                                \
            "mov    r9, r4;"                                                \
        "2:"                                                                \
            "ldr    r7, =0x00007FFF;"                                       \
            "ands   r7, r7, r1, lsr #13;"                                   \
        "3:"                                                                \
            "orr    r11, r10, r9, lsl r5;"                                  \
            "orr    r11, r11, r7, lsl r2;"                                  \
            "mcr    p15, 0, r11, c7, c10, 2;"                               \
            "subs   r7, r7, #1;"                                            \
            "bge    3b;"                                                    \
            "subs   r9, r9, #1;"                                            \
            "bge    2b;"                                                    \
        "4:"                                                                \
            "add    r10, r10, #2;"                                          \
            "cmp    r3, r10;"                                               \
            "bgt    1b;"                                                    \
            "dsb;"                                                          \
        "5:"                                                                \
            HAL_THUMB_MODE(r4)                                              \
            :                                                               \
            :                                                               \
            : "r0", "r1", "r2", "r3", "r4", "r5", "r7", "r9", "r10", "r11"  /* Clobber list */       \
            );                                                              \
    CYG_MACRO_END

/*
 * Clean & Invalidate the entire dcache
 */
#define HAL_DCACHE_SYNC()                                                   \
    CYG_MACRO_START                                                         \
        asm volatile (                                                      \
            HAL_ARM_MODE(r4)                                                \
            "mrc    p15, 1, r0, c0, c0, 1;"                                 \
            "ands   r3, r0, #0x07000000;"                                   \
            "mov    r3, r3, lsr #23;"                                       \
            "beq    5f;"                                                    \
            "mov    r10, #0;"                                               \
        "1:"                                                                \
            "add    r2, r10, r10, lsr #1;"                                  \
            "mov    r1, r0, lsr r2;"                                        \
            "and    r1, r1, #7;"                                            \
            "cmp    r1, #2;"                                                \
            "blt    4f;"                                                    \
            "mcr    p15, 2, r10, c0, c0, 0;"                                \
            "isb;"                                                          \
            "mrc    p15, 1, r1, c0, c0, 0;"                                 \
            "and    r2, r1, #7;"                                            \
            "add    r2, r2, #4;"                                            \
            "ldr    r4, =0x3FF;"                                            \
            "ands   r4, r4, r1, lsr #3;"                                    \
            "clz    r5, r4;"                                                \
            "mov    r9, r4;"                                                \
        "2:"                                                                \
            "ldr    r7, =0x00007FFF;"                                       \
            "ands   r7, r7, r1, lsr #13;"                                   \
        "3:"                                                                \
            "orr    r11, r10, r9, lsl r5;"                                  \
            "orr    r11, r11, r7, lsl r2;"                                  \
            "mcr    p15, 0, r11, c7, c14, 2;"                               \
            "subs   r7, r7, #1;"                                            \
            "bge    3b;"                                                    \
            "subs   r9, r9, #1;"                                            \
            "bge    2b;"                                                    \
        "4:"                                                                \
            "add    r10, r10, #2;"                                          \
            "cmp    r3, r10;"                                               \
            "bgt    1b;"                                                    \
            "dsb;"                                                          \
        "5:"                                                                \
            HAL_THUMB_MODE(r4)                                              \
            :                                                               \
            :                                                               \
            : "r0", "r1", "r2", "r3", "r4", "r5", "r7", "r9", "r10", "r11"  /* Clobber list */       \
            );                                                              \
    CYG_MACRO_END

// Disable the data cache (and invalidate it, required semanitcs)
#define HAL_MMU_DISABLE()                                                \
CYG_MACRO_START                                                             \
    asm volatile (                                                          \
        HAL_ARM_MODE(r4)                                                    \
        "mrc    p15, 0, r4, c1, c0, 0;"                                     \
        "bic    r4, r4, #0x0001;" /* disable DCache                  */     \
                                  /* but not alignment faults         */    \
        "mcr    p15, 0, r4, c1, c0, 0;"                                     \
        HAL_THUMB_MODE(r4)                                                  \
        :                                                                   \
        :                                                                   \
        : "r4"  /* Clobber list */                                          \
    );                                                                      \
    CYG_MACRO_END

    
#elif defined(__ARMCC_VERSION)  // #ifdef __GNUC__

//-----------------------------------------------------------------------------
// Global control of Instruction cache

// Enable the instruction cache
#define HAL_ICACHE_ENABLE()                                                 \
CYG_MACRO_START                                                             \
    __asm {                                                                 \
        mrc  p15, 0, r4, c1, c0, 0;                                         \
        orr  r4, r4, #0x1000;                                               \
        orr  r4, r4, #0x0002; /* enable ICache (also ensures   */           \
                                /* that alignment faults         */         \
                                /* is enabled)                   */         \
        mcr  p15, 0, r4, c1, c0, 0;                                         \
        }                                                                   \
CYG_MACRO_END

// Disable the instruction cache (and invalidate it, required semanitcs)
#define HAL_ICACHE_DISABLE()                                                \
CYG_MACRO_START                                                             \
    __asm {                                                                 \
        mrc    p15, 0, r4, c1, c0, 0;                                       \
        bic    r4, r4, #0x1000; /* disable ICache               */          \
        mcr    p15, 0, r4, c1, c0, 0;                                       \
        mov    r4, #0;                                                      \
        mcr    p15, 0, r4, c7, c5, 0; /* invalidate ICache */               \
        nop; /* next few instructions may be via cache    */                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        nop                                                                 \
        }                                                                   \
CYG_MACRO_END

// Query the state of the instruction cache
#define HAL_ICACHE_IS_ENABLED(_state_)                                      \
CYG_MACRO_START                                                             \
    register u32 reg;                                                \
                                                                            \
    __asm {                                                                 \
        mrc    p15, 0, (reg), c1, c0, 0;                                    \
        }                                                                   \
    (_state_) = (0 != (0x1000 & reg)); /* Bit 12 is ICache enable */        \
CYG_MACRO_END

// Invalidate the cache by address
#define HAL_ICACHE_INVALIDATE_BY_MVA(_value_)                               \
CYG_MACRO_START                                                             \
    /* this macro can discard dirty cache lines (N/A for ICache) */         \
    __asm {                                                                 \
        mcr    p15, 0, (_value_), c7, c5, 1; /* invalidate ICache */        \
        nop; /* next few instructions may be via cache    */                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        }                                                                   \
CYG_MACRO_END

// Invalidate the entire cache
#define HAL_ICACHE_INVALIDATE_ALL()                                         \
CYG_MACRO_START                                                             \
    /* this macro can discard dirty cache lines (N/A for ICache) */         \
    __asm {                                                                 \
        mov    r4, #0;                                                      \
        mcr    p15, 0, r4, c7, c5, 0; /* invalidate ICache */               \
        nop; /* next few instructions may be via cache    */                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        nop;                                                                \
        }                                                                   \
CYG_MACRO_END

// Synchronize the contents of the cache with memory.
// (which includes flushing out pending writes)
#define HAL_ICACHE_SYNC()                                                   \
CYG_MACRO_START                                                             \
    HAL_DCACHE_SYNC(); /* ensure data gets to RAM */                        \
    HAL_ICACHE_INVALIDATE_ALL(); /* forget all we know */                   \
CYG_MACRO_END

//-----------------------------------------------------------------------------
// Global control of data cache

// Enable the data cache
#define HAL_DCACHE_ENABLE()                                                 \
CYG_MACRO_START                                                             \
    __asm {                                                                 \
        mrc    p15, 0, r4, c1, c0, 0;                                       \
        orr    r4, r4, #0x0006; /* enable DCache (also ensures    */        \
                                  /* alignment faults is enabled    */      \
        mcr    p15, 0, r4, c1, c0, 0;                                       \
        }                                                                   \
CYG_MACRO_END

// Disable the data cache (and invalidate it, required semanitcs)
#define HAL_DCACHE_DISABLE()                                                \
CYG_MACRO_START                                                             \
    __asm {                                                                 \
        mrc    p15, 0, r4, c1, c0, 0;                                       \
        bic    r4, r4, #0x0004; /* disable DCache                  */       \
                                  /* but not alignment faults         */    \
        mcr    p15, 0, r4, c1, c0, 0;                                       \
        }                                                                   \
    HAL_DCACHE_SYNC();                                                      \
CYG_MACRO_END

// Query the state of the data cache
#define HAL_DCACHE_IS_ENABLED(_state_)                                      \
CYG_MACRO_START                                                             \
    register int reg;                                                       \
                                                                            \
    __asm {                                                                 \
        mrc  p15, 0, (reg), c1, c0, 0;                                      \
        }                                                                   \
    (_state_) = (0 != (4 & reg)); /* Bit 2 is DCache enable */              \
CYG_MACRO_END

// Flush the dcache by address
#define HAL_DCACHE_INVALIDATE_BY_MVA(_value_)                               \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    __asm {                                                                 \
        mcr    p15, 0, (_value_), c7, c6, 1; /* invalidate d-cache */       \
        }                                                                   \
CYG_MACRO_END

// Clean the dcache by address
#define HAL_DCACHE_CLEAN_BY_MVA(_value_)                                    \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    __asm {                                                                 \
        mcr    p15, 0, (_value_), c7, c10, 1; /* clean d-cache */           \
        }                                                                   \
CYG_MACRO_END

/*
 * Clean & Invalidate the dcache by address
 */
#define HAL_DCACHE_SYNC_BY_MVA(_value_)                                     \
    CYG_MACRO_START                                                         \
        __asm {                                                             \
            mcr p15, 0, (_value_), c7, c14, 1;/*Clean and invalidate data cache*/\
        }                                                                   \
    CYG_MACRO_END
    
// Flush the dcache by set/way
#define HAL_DCACHE_INVALIDATE_BY_SETWAY(_value_)                            \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    __asm {                                                                 \
        mcr    p15, 0, (_value_), c7, c6, 2; /* invalidate d-cache */       \
        }                                                                   \
CYG_MACRO_END

// Clean the dcache by set/way
#define HAL_DCACHE_CLEAN_BY_SETWAY(_value_)                                 \
CYG_MACRO_START  /* this macro can discard dirty cache lines. */            \
    __asm {                                                          \
        mcr    p15, 0, (_value_), c7, c10, 2; /* clean d-cache */                \
        }                                                                   \
CYG_MACRO_END

/*
 * Clean & Invalidate the dcache by set/way
 */
#define HAL_DCACHE_SYNC_BY_SETWAY(_value_)                                  \
    CYG_MACRO_START                                                         \
        __asm {                                                             \
            mcr p15, 0, (_value_), c7, c14, 2;/*Clean and invalidate data cache*/\
        }                                                                   \
    CYG_MACRO_END

/*
 * Invalidate the entire dcache
 */
#define HAL_DCACHE_INVALIDATE_ALL()                                         \
    CYG_MACRO_START                                                         \
        __asm {                                                             \
            mrc    p15, 1, r0, c0, c0, 1;                                   \
            ands   r3, r0, #0x07000000;                                     \
            mov    r3, r3, lsr #23;                                         \
            beq    %F5;                                                     \
            mov    r10, #0;                                                 \
        1                                                                   \
            add    r2, r10, r10, lsr #1;                                    \
            mov    r1, r0, lsr r2;                                          \
            and    r1, r1, #7;                                              \
            cmp    r1, #2;                                                  \
            blt    %F4;                                                     \
            mcr    p15, 2, r10, c0, c0, 0;                                  \
            isb;                                                            \
            mrc    p15, 1, r1, c0, c0, 0;                                   \
            and    r2, r1, #7;                                              \
            add    r2, r2, #4;                                              \
            ldr    r4, =0x3FF;                                              \
            ands   r4, r4, r1, lsr #3;                                      \
            clz    r5, r4;                                                  \
            mov    r9, r4;                                                  \
        2                                                                   \
            ldr    r7, =0x00007FFF;                                         \
            ands   r7, r7, r1, lsr #13;                                     \
        3                                                                   \
            orr    r11, r10, r9, lsl r5;                                    \
            orr    r11, r11, r7, lsl r2;                                    \
            mcr    p15, 0, r11, c7, c6, 2;                                  \
            subs   r7, r7, #1;                                              \
            bge    %B3;                                                     \
            subs   r9, r9, #1;                                              \
            bge    %B2;                                                     \
        4                                                                   \
            add    r10, r10, #2;                                            \
            cmp    r3, r10;                                                 \
            bgt    %B1;                                                     \
            dsb;                                                            \
        5                                                                   \
        }                                                                   \
    CYG_MACRO_END
    
/*
 * Clean the entire dcache
 */
#define HAL_DCACHE_CLEAN_ALL()                                              \
    CYG_MACRO_START                                                         \
        __asm {                                                             \
            mrc    p15, 1, r0, c0, c0, 1;                                   \
            ands   r3, r0, #0x07000000;                                     \
            mov    r3, r3, lsr #23;                                         \
            beq    %F5;                                                     \
            mov    r10, #0;                                                 \
        1                                                                   \
            add    r2, r10, r10, lsr #1;                                    \
            mov    r1, r0, lsr r2;                                          \
            and    r1, r1, #7;                                              \
            cmp    r1, #2;                                                  \
            blt    %F4;                                                     \
            mcr    p15, 2, r10, c0, c0, 0;                                  \
            isb;                                                            \
            mrc    p15, 1, r1, c0, c0, 0;                                   \
            and    r2, r1, #7;                                              \
            add    r2, r2, #4;                                              \
            ldr    r4, =0x3FF;                                              \
            ands   r4, r4, r1, lsr #3;                                      \
            clz    r5, r4;                                                  \
            mov    r9, r4;                                                  \
        2                                                                   \
            ldr    r7, =0x00007FFF;                                         \
            ands   r7, r7, r1, lsr #13;                                     \
        3                                                                   \
            orr    r11, r10, r9, lsl r5;                                    \
            orr    r11, r11, r7, lsl r2;                                    \
            mcr    p15, 0, r11, c7, c10, 2;                                 \
            subs   r7, r7, #1;                                              \
            bge    %B3;                                                     \
            subs   r9, r9, #1;                                              \
            bge    %B2;                                                     \
        4                                                                   \
            add    r10, r10, #2;                                            \
            cmp    r3, r10;                                                 \
            bgt    %B1;                                                     \
            dsb;                                                            \
        5                                                                   \
        }                                                                   \
    CYG_MACRO_END

/*
 * Clean & Invalidate the entire dcache
 */
#define HAL_DCACHE_SYNC()                                                   \
    CYG_MACRO_START                                                         \
        __asm {                                                             \
            mrc    p15, 1, r0, c0, c0, 1;                                   \
            ands   r3, r0, #0x07000000;                                     \
            mov    r3, r3, lsr #23;                                         \
            beq    %F5;                                                     \
            mov    r10, #0;                                                 \
        1                                                                   \
            add    r2, r10, r10, lsr #1;                                    \
            mov    r1, r0, lsr r2;                                          \
            and    r1, r1, #7;                                              \
            cmp    r1, #2;                                                  \
            blt    %F4;                                                     \
            mcr    p15, 2, r10, c0, c0, 0;                                  \
            isb;                                                            \
            mrc    p15, 1, r1, c0, c0, 0;                                   \
            and    r2, r1, #7;                                              \
            add    r2, r2, #4;                                              \
            ldr    r4, =0x3FF;                                              \
            ands   r4, r4, r1, lsr #3;                                      \
            clz    r5, r4;                                                  \
            mov    r9, r4;                                                  \
        2                                                                   \
            ldr    r7, =0x00007FFF;                                         \
            ands   r7, r7, r1, lsr #13;                                     \
        3                                                                   \
            orr    r11, r10, r9, lsl r5;                                    \
            orr    r11, r11, r7, lsl r2;                                    \
            mcr    p15, 0, r11, c7, c14, 2;                                 \
            subs   r7, r7, #1;                                              \
            bge    %B3;                                                     \
            subs   r9, r9, #1;                                              \
            bge    %B2;                                                     \
        4                                                                   \
            add    r10, r10, #2;                                            \
            cmp    r3, r10;                                                 \
            bgt    %B1;                                                     \
            dsb;                                                            \
        5                                                                   \
        }                                                                   \
    CYG_MACRO_END
    

#endif  // #ifdef __GNUC__

#define HAL_DCACHE_WRITETHRU_MODE       0
#define HAL_DCACHE_WRITEBACK_MODE       1

// Get the current writeback mode - or only writeback mode if fixed
#define HAL_DCACHE_QUERY_WRITE_MODE( _mode_ )                               \
CYG_MACRO_START                                                             \
    _mode_ = HAL_DCACHE_WRITEBACK_MODE;                                     \
CYG_MACRO_END

//-----------------------------------------------------------------------------
// Cache controls for safely disabling/reenabling caches around execution
// of relocated code.

#define HAL_FLASH_CACHES_OFF(_d_, _i_)                                      \
    CYG_MACRO_START                                                         \
        HAL_ICACHE_IS_ENABLED(_i_);                                         \
        HAL_DCACHE_IS_ENABLED(_d_);                                         \
        HAL_ICACHE_INVALIDATE_ALL();                                        \
        HAL_ICACHE_DISABLE();                                               \
        HAL_DCACHE_SYNC();                                                  \
        HAL_DCACHE_INVALIDATE_ALL();                                        \
        HAL_DCACHE_DISABLE();                                               \
    CYG_MACRO_END

#define HAL_FLASH_CACHES_ON(_d_, _i_)                                       \
    CYG_MACRO_START                                                         \
        if (_d_) HAL_DCACHE_ENABLE();                                       \
        if (_i_) HAL_ICACHE_ENABLE();                                       \
    CYG_MACRO_END

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/


/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/

#endif	// #ifndef CYGONCE_HAL_CACHE_H

