/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:   hal_led.c
 * File Mark:
 * Description:  This file contains the hal layer routines for i2c driver.
 * Others:
 * Version:       V1.0
 * Author:        yx
 * Date:          2014-07-03
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ******************************************************************************/

/****************************************************************************
*                                  Include files
****************************************************************************/
#include <drvs_gpio.h>
#include <led.h>

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/


SINT32 led_SetStatus(led_channel channel, led_status status)
{
    SINT32 ret = 0;
    if (status == LED_STATUS_ON)
    {
        switch (channel)
        {
        case LED_WIFI_BLUE:
            zDrvGpio_SetOutputValue(LED_WIFI_BLUE_GPIO,GPIO_HIGH);
            break;
        case LED_SMS_BLUE:
            zDrvGpio_SetOutputValue(LED_SMS_BLUE_GPIO,GPIO_HIGH);
            break;
        case LED_BAT_RED:
            zDrvGpio_SetOutputValue(LED_BAT_RED_GPIO,GPIO_HIGH);
            break;
        case LED_BAT_GREEN:
            zDrvGpio_SetOutputValue(LED_BAT_GREEN_GPIO,GPIO_HIGH);
            break;
		case LED_MODEM_BLUE:
			zDrvGpio_SetOutputValue(LED_MODEM_BLUE_GPIO,GPIO_HIGH);			
			break;
		case LED_MODEM_RED:		
			zDrvGpio_SetOutputValue(LED_MODEM_RED_GPIO,GPIO_HIGH);
			break;		
        default:
            break;
			

        }
    }
    else if (status == LED_STATUS_OFF)
    {
        switch (channel)
        {
        case LED_WIFI_BLUE:
            zDrvGpio_SetOutputValue(LED_WIFI_BLUE_GPIO,GPIO_LOW);
            break;
        case LED_SMS_BLUE:
            zDrvGpio_SetOutputValue(LED_SMS_BLUE_GPIO,GPIO_LOW);
            break;
        case LED_BAT_RED:
            zDrvGpio_SetOutputValue(LED_BAT_RED_GPIO,GPIO_LOW);
            break;
        case LED_BAT_GREEN:
            zDrvGpio_SetOutputValue(LED_BAT_GREEN_GPIO,GPIO_LOW);
            break;
		case LED_MODEM_BLUE:
			zDrvGpio_SetOutputValue(LED_MODEM_BLUE_GPIO,GPIO_LOW);			
			break;
		case LED_MODEM_RED:		
			zDrvGpio_SetOutputValue(LED_MODEM_RED_GPIO,GPIO_LOW);
			break;		
        default:
            break;
			

        }
    }
    else
    {
        return -1;
    }

    return ret;

}

#if 0

/*******************************************************************************
  * Function:	       led_SetLEDcurrent
  * Description:
  * Parameters:
  *   Input:		 led_color:  	LED_RED / LED_GREEN / LED_BLUE
  *				brightness: LED_BRIGHTNESS_1 ~ LED_BRIGHTNESS_16
  *   Output:
  * Returns:					success or fail
  * Others: blue led can't set brightness, only can set on/off
  ********************************************************************************/
SINT32 led_SetLEDcurrent(UINT8 sink, led_current current)
{
    SINT32 ret = 0;
    UINT8 slv_addr=0, reg_addr=0, reg_val=0, mask=0;

    slv_addr = ZX234290_I2C_SLAVE_ADDR0;

    reg_addr = ZX234290_REG_ADDR_SYS_CTRL;
    if (current)
    {
        switch (sink)
        {
            case 1:
            reg_val = LED_BITFVAL(1, 0);	/* 0x07 寄存器 [1:0]	*/
            break;
            case 2:
            reg_val = LED_BITFVAL(1, 1);	/* 0x07 寄存器 [1:0]	*/
            break;
            default:
            break;
        }
    }
    else
    {
        switch (sink)
        {
            case 1:
                reg_val = LED_BITFVAL(0, 0);
                break;
            case 2:
                reg_val = LED_BITFVAL(0, 1);	/* 0x07 寄存器 [1:0]	*/
                break;
            default:
                break;
        }
    }

    switch (sink)
    {
        case 1:
            mask = LED_BITFMASK(1, 0);
            break;
        case 2:
            mask = LED_BITFMASK(1, 1);;	/* 0x07 寄存器 [1:0]	*/
            break;
        default:
            break;
    }


    ret = zx297520_led_SetRegister(reg_addr, reg_val, mask);
    //zOss_Sleep(500);

    switch (sink)
    {
        case 1:
            reg_addr = ZX234290_REG_ADDR_SINK1_CUR_SEL;
            break;
        case 2:
            reg_addr = ZX234290_REG_ADDR_SINK2_CUR_SEL;
            break;
        default:
            break;
    }

    reg_val = LED_BITFVAL(current, 0);	/* 0x07 寄存器 [1:0]	*/
    mask = LED_BITFMASK(4, 0);
    ret = zx297520_led_SetRegister(reg_addr, reg_val, mask);

    if (ret != 0)
    {
        return -1;
    }

    return 0;
}
#endif
void zx29_led_init(void)
{
    zDrvGpio_SetFunc(LED_WIFI_BLUE_GPIO,LED_WIFI_BLUE_GPIO_FUN);
    zDrvGpio_SetDirection(LED_WIFI_BLUE_GPIO,GPIO_OUT);	
	zDrvGpio_SetOutputValue(LED_WIFI_BLUE_GPIO,GPIO_LOW);

    zDrvGpio_SetFunc(LED_SMS_BLUE_GPIO,LED_SMS_BLUE_GPIO_FUN);
    zDrvGpio_SetDirection(LED_SMS_BLUE_GPIO,GPIO_OUT);
	zDrvGpio_SetOutputValue(LED_SMS_BLUE_GPIO,GPIO_LOW);

    zDrvGpio_SetFunc(LED_BAT_RED_GPIO,LED_BAT_RED_GPIO_FUN);
    zDrvGpio_SetDirection(LED_BAT_RED_GPIO,GPIO_OUT);
	zDrvGpio_SetOutputValue(LED_BAT_RED_GPIO,GPIO_LOW);

    zDrvGpio_SetFunc(LED_BAT_GREEN_GPIO,LED_BAT_GREEN_GPIO_FUN);
    zDrvGpio_SetDirection(LED_BAT_GREEN_GPIO,GPIO_OUT);
	zDrvGpio_SetOutputValue(LED_BAT_GREEN_GPIO,GPIO_LOW);
	
    zDrvGpio_SetFunc(LED_MODEM_RED_GPIO,LED_MODEM_RED_GPIO_FUN);
    zDrvGpio_SetDirection(LED_MODEM_RED_GPIO,GPIO_OUT);
	zDrvGpio_SetOutputValue(LED_MODEM_RED_GPIO,GPIO_LOW);

    zDrvGpio_SetFunc(LED_MODEM_BLUE_GPIO,LED_MODEM_BLUE_GPIO_FUN);
    zDrvGpio_SetDirection(LED_MODEM_BLUE_GPIO,GPIO_OUT);
	zDrvGpio_SetOutputValue(LED_MODEM_BLUE_GPIO,GPIO_LOW);
}

void zx29_led_PowerOnLedOn(void)
{
	#if 1
    led_SetStatus(LED_MODEM_RED,LED_STATUS_OFF);
    led_SetStatus(LED_BAT_GREEN,LED_STATUS_OFF);
	
    led_SetStatus(LED_WIFI_BLUE,LED_STATUS_ON);
    led_SetStatus(LED_SMS_BLUE,LED_STATUS_ON);
    led_SetStatus(LED_BAT_RED,LED_STATUS_ON);
    led_SetStatus(LED_MODEM_BLUE,LED_STATUS_ON);
	#endif
	
}
void zx29_led_PowerOnLedOff(void)
{	
    udelay(19500);	/*300ms*/
    led_SetStatus(LED_WIFI_BLUE,LED_STATUS_OFF);
    led_SetStatus(LED_SMS_BLUE,LED_STATUS_OFF);
    led_SetStatus(LED_MODEM_BLUE,LED_STATUS_OFF);	
}

